#ifndef _TKGSCOLOR
#define _TKGSCOLOR

/*
 * Colors
 */

/* Base type */
EXTERN TkGS_BaseType*	TkGS_GetColorBaseType();

/* Structure */
typedef struct TkGS_Color_ {
    TkGS_Obj header;	/* Must be first */

    int type;		/* Any of the TKGS_COLOR_* constants */
    union {
	int systemColor;	/* System color */
	unsigned short rgb[3];	/* Color RGB values */
    } value;
} TkGS_Color_;

/* Accessors */
#define TkGSColor_Type(objPtr) \
    (((TkGS_Color_*)objPtr)->type)
#define TkGSColor_SystemColor(objPtr) \
    (((TkGS_Color_*)objPtr)->value.systemColor)
#define TkGSColor_RGB(objPtr) \
    (((TkGS_Color_*)objPtr)->value.rgb)

/* Functions */
EXTERN TkGS_Color_ *	TkGSNewSystemColor _ANSI_ARGS_((int systemColor));
EXTERN TkGS_Color_ *	TkGSNewRGBColor _ANSI_ARGS_((unsigned short red, 
			    unsigned short green, unsigned short blue));

#endif /* _TKGSCOLOR */

