#include "tkgsWin.h"
#include "tkgsWinInt.h"

/*
 * Prototypes for procedures defined later in this file:
 */

static TkGS_FreeInternalRepProc		FreeWinColorIntRep;
static TkGS_SetFromAnyProc		SetWinColorFromAny;


/*
 * Win32 Color Obj type
 */

/* Object type */
TkGS_ObjType WinColorType = {
    "WinColor",
    NULL,				/* Base type, initialized at runtime */

    FreeWinColorIntRep,			/* freeIntRepProc */
    SetWinColorFromAny			/* setFromAnyProc */
};
TkGS_ObjType *WinColorTypePtr = &WinColorType;


/* Object type procs */

static void
FreeWinColorIntRep(intRepPtr)
    TkGS_InternalRep *intRepPtr;
{
    if (WinColor_HPEN(intRepPtr) != NULL) {
	DeleteObject(WinColor_HPEN(intRepPtr));
    }
    if (WinColor_HBRUSH(intRepPtr) != NULL) {
	DeleteObject(WinColor_HBRUSH(intRepPtr));
    }
}

static int
SetWinColorFromAny(interp, objPtr, intRepPtr)
    Tcl_Interp *interp;
    TkGS_Obj *objPtr;
    TkGS_InternalRep *intRepPtr;
{
    /* 
     * Free old internal rep
     */

    if (   intRepPtr->typePtr != NULL
	&& intRepPtr->typePtr->freeIntRepProc != NULL) {
	intRepPtr->typePtr->freeIntRepProc(intRepPtr);
    }

    /* 
     * Initialize internal rep
     */

    WinColor_HPEN(intRepPtr)   = NULL;
    WinColor_HBRUSH(intRepPtr) = NULL;

    /* Change type */
    intRepPtr->typePtr = &WinColorType;

    return TKGS_OK;
}



HPEN
WinTkGS_GetPenFromColor(interp, color)
    Tcl_Interp *interp;
    TkGS_Color color;
{
    register TkGS_InternalRep 
	*intRepPtr = TkGS_FindInternalRep((TkGS_Obj *) color, &WinColorType);

    /*
     * Get a Windows HPEN from TkGS Color's internal rep
     */

    if (intRepPtr == NULL) {
	intRepPtr = TkGS_AddNewInternalRep(interp, (TkGS_Obj *) color, 
					   &WinColorType);
	if (!intRepPtr) {
	    return NULL;
	}
    }

    /* 
     * Create a 0-pixel wide Pen with the given color if needed
     */

    if (WinColor_HPEN(intRepPtr) == NULL) {
	unsigned short r, g, b;
	TkGS_GetRGBColorValues(color, &r, &g, &b);
	WinColor_HPEN(intRepPtr) = CreatePen(PS_SOLID, 
					0, 
					RGB(r>>8, g>>8, b>>8));
    }
    return WinColor_HPEN(intRepPtr);
}


HBRUSH
WinTkGS_GetBrushFromColor(interp, color)
    Tcl_Interp *interp;
    TkGS_Color color;
{
    register TkGS_InternalRep 
	*intRepPtr = TkGS_FindInternalRep((TkGS_Obj *) color, &WinColorType);

    /*
     * Get a Windows HBRUSH from TkGS Color's internal rep
     */

    if (intRepPtr == NULL) {
	intRepPtr = TkGS_AddNewInternalRep(interp, (TkGS_Obj *) color, 
					   &WinColorType);
	if (!intRepPtr) {
	    return NULL;
	}
    }

    /* 
     * Create a solid Brush with the given color if needed
     */

    if (WinColor_HBRUSH(intRepPtr) == NULL) {
	if (TkGSColor_Type(color) == TKGS_COLOR_SYSTEM) {
	    WinColor_HBRUSH(intRepPtr) = 
		GetSysColorBrush(TkGSColor_SystemColor(color));
	} else {
	    unsigned short r, g, b;
	    TkGS_GetRGBColorValues(color, &r, &g, &b);
	    WinColor_HBRUSH(intRepPtr) = CreateSolidBrush(
					RGB(r>>8, g>>8, b>>8));
	}
    }
    return WinColor_HBRUSH(intRepPtr);
}

COLORREF
WinTkGS_GetColorrefFromColor(color)
    TkGS_Color color;
{
    if (TkGSColor_Type(color) == TKGS_COLOR_SYSTEM) {
	return GetSysColor(TkGSColor_SystemColor(color));
    } else {
	unsigned short r, g, b;
	TkGS_GetRGBColorValues(color, &r, &g, &b);
	return RGB(r>>8, g>>8, b>>8);
    }
}
