.TH "tcldompro" TCL "" "Tcl"
.SH NAME
TclDomPro - DOM (Document Object Model) Interface for Tcl
.sp
.SH "INTRODUCTION"
.P
The TclDomPro extension implements Level 1, and selected interfaces of Level
2, of the DOM (Document Object Model). Only XML documents are supported.
For an explanation of the DOM, refer to the DOM specification:
http://www.w3.org/DOM/.
.sp
In this implementation, DOM objects are represented by opaque handles; 
no assumptions should be made about these handles. DOM interfaces 
are implemented as commands in the ::dom:: namespace; DOM object methods
are implemented as sub-commands; DOM object attributes are accessed via 
\fBcget\fR and \fBconfigure\fR sub-commands.
.sp
The package name for the TclDomPro extension is "tcldompro".

.sp
.SH "TCLCOMPRO COMMANDS"
.TP
.B ::dom::DOMImplementation \fImethod\fR ?\fIarguments\fR?
.br
This command provides features specific to the TclDomPro implementation of
the DOM specification. The methods include:

.SP
.B ::dom::DOMImplementation \fBhasFeature\fR \fIfeature\fR
.br
This command returns "1" if a feature is implemented; "0" otherwise.


.sp
.B ::dom::DOMImplementation \fBcreate\fR
.br
This command creates an empty document, and returns a handle for it.

.sp
.B ::dom::DOMImplementation \fBdestroy\fR \fIhandle\fR
.br
This command releases all data structures associated with a DOM document.
Here \fIhandle\fR may refer to any node in the document.

.sp
.B ::dom::DOMImplementation \fBparse\fR \fIdata\fR ?\fIoptions\fR?
.br
This command parses XML formatted text specified by \fIdata\fR and
constructs a DOM document tree from it. If the text was successfully
parsed then the command returns a handle for the new document; otherwise
the command generates an error and returns a string describing where the
error occurred in the document. The following options are supported:

.IP "" 10

.sp
\fB-parser\fR {} | \fBexpat\fR | \fBtcl\fR
.sp
This option specifies which parser to use, and is provided
for compatibility with tcldom. TclDomPro will always use the expat parser.

.sp
\fB-progresscommand\fR \fIscript\fR
.sp
This option is provided for compatibility with tcldom. The option has no effect.

.sp
\fB-chunksize\fR \fIinteger\fR
.sp
This option is provided for compatibility with tcldom. The option has no effect.

.sp
\fB-final\fR \fIisFinal\fR
.sp
This option allows XML to be passed incrementally, or streamed, to the parser.
You should set \fIisFinal\fR to "0" if there may be more XML to follow; set
\fIisFinal\fR to "1" when the last piece of XML is passed to the parser. The
command returns a document handle if sufficient XML has been parsed to do so.
The default is "-final 1".

.sp
\fB-trim\fR
.sp
This option tells the parser to suppress text nodes that only contain
whitespace.  This is a tcldompro specific extension.

.IP "" 5

.sp
.B ::dom::DOMImplementation \fBserialize\fR \fIhandle\fR ?\fIoptions\fR
.br
This command returns the XML formatted text corresponding for the
document corresponding to the node specified by \fIhandle\fR. The
following options are supported:

.IP "" 10

.sp
\fB-newline\fR \fIelementList\fR
.sp
This option is provided for compatibility with tcldom. The option has no effect.

.IP "" 5

.sp
.TP
.B ::dom::document \fImethod\fR \fIhandle\fR ?\fIarguments...\fR?
.br
This command implements the Document interface of the DOM specification.
The document is specified by \fIhandle\fR, which may be the handle for
any node in the containing document.  The following methods are supported:

.sp
\fB::dom::document configure\fR \fIhandle\fR \fIattribute\fR ?\fIvalue\fR?
.sp
This method reads or writes the value of a Document attribute. Document
attributes are:

.IP "" 10

.sp
\fB-doctype\fR
.sp
Specifies the handle of the Document Type Declaration node. This attribute is
read-only.

.sp
\fB-implementation\fR
.sp
Specifies the handle of the document's implementation. This attribute is
read-only.

.sp
\fB-documentElement\fR
.sp
Specifies the handle of the document's document element node. This attribute is
read-only.

.IP "" 5

.sp
\fB::dom::document cget\fR \fIhandle\fR \fIattribute\fR
.sp
This method returns a value of a Document attribute.

.sp
\fB::dom::document createElement\fR \fIhandle\fR \fItype\fR
.sp
This method creates an Element node in the document specified by \fIhandle\fR.
The new node has its type set to \fItype\fR.

.sp
\fB::dom::document createDocumentFragment\fR \fIhandle\fR 
.sp
This method creates a Document Fragment node in the document specified by 
\fIhandle\fR.

.sp
\fB::dom::document createTextNode\fR \fIhandle\fR \fItext\fR
.sp
This method creates a Text node in the document specified by \fIhandle\fR.
The new node's text is given by \fItext\fR.

.sp
\fB::dom::document createComment\fR \fIhandle\fR \fIdata\fR
.sp
This method creates a Comment node in the document specified by \fIhandle\fR.
The new node has its value set to \fIdata\fR.

.sp
\fB::dom::document createCDATASection\fR \fIhandle\fR \fItext\fR
.sp
This method creates a CDATASection node in the document specified by 
\fIhandle\fR.
The new node has its value set to \fItext\fR.

.sp
\fB::dom::document createProcessingInstruction\fR \fIhandle\fR 
	\fItarget\fR \fIdata\fR
.sp
This method creates a ProcessingInstruction node in the document specified 
by \fIhandle\fR.
The new node has its name set to \fItarget\fR and its value set to \fIdata\fR.

.sp
\fB::dom::document createAttribute\fR \fIhandle\fR \fIname\fR
.sp
This method creates an Attribute node in the document specified by \fIhandle\fR.
The new node has its name set to \fIname\fR and an empty value.

.sp
\fB::dom::document createEntity\fR \fIhandle\fR \fIdata\fR
.sp
This method is not currently implemented.

.sp
\fB::dom::document createEntityReference\fR \fIhandle\fR \fIdata\fR
.sp
This method is not currently implemented.

.sp
\fB::dom::document getElementsByTagName\fR \fIhandle\fR \fIname\fR
.sp
This method a Tcl variable containing the list of child elements
with a type matching \fIname\fR.

.sp
.TP
.B ::dom::node \fImethod\fR \fInodeHandle\fR ?\fIarguments...\fR?
.br
This command implements the Node interface of the DOM specification.
The node is specified by \fInodeHandle\fR.  The following methods are supported:

.sp
\fB::dom::node configure\fR \fInodeHandle\fR \fIattribute\fR ?\fIvalue\fR?
.sp
This method reads or writes the value of a Node attribute. Node
attributes are:

.IP "" 10

.sp
\fB-nodeName\fR
.sp
Specifies the name of the node. This attribute is read-only.

.sp
\fB-nodeType\fR
.sp
Specifies the type of the node. This attribute is read-only.

.sp
\fB-parentNode\fR
.sp
Specifies the parent of a node. This attribute is read-only.

.sp
\fB-childNodes\fR
.sp
Returns a Tcl variable containing the list of the children of the
node specified by \fInodeHandle\fR. The node list is "live".
This attribute is read-only.

.sp
\fB-firstChild\fR
.sp
Specifies the first child of a node. This attribute is read-only.

.sp
\fB-lastChild\fR
.sp
Specifies the last child of a node. This attribute is read-only.

.sp
\fB-previousSibling\fR
.sp
Specifies the previous sibling of a node. This attribute is read-only.

.sp
\fB-nextSibling\fR
.sp
Specifies the next sibling of a node. This attribute is read-only.

.sp
\fB-attributes\fR
.sp
Returns a Tcl array variable that represents the attribute list for an
Element node. If the node is not an Element type then an empty string is
returned. The elements of the array variable are the attribute names, and 
the values of the array elements are the corresponding attribute values.
This attribute is read-only.

.sp
\fB-nodeValue\fR
.sp
Specifies the value of a node.

.sp
\fB-startLine\fR
.sp
Returns the line number in the XML source on which a node begins, or 0 if
the node was not created by the \fBparse\fR method. This attribute is read-only.
\fIThis is not a standard DOM attribute for this interface.\fR

.sp
\fB-startColumn\fR
.sp
Returns the column number in the XML source on which a node begins, or 0 if
the node was not created by the \fBparse\fR method. This attribute is read-only.
\fIThis is not a standard DOM attribute for this interface.\fR

.sp
\fB-startWidth\fR
.sp
Returns the width in characters of the textual representation of a node
in the XML source, or 0 if the node was not created by the \fBparse\fR method. 
This attribute is read-only.
\fIThis is not a standard DOM attribute for this interface.\fR

.sp
\fB-endLine\fR
.sp
Returns the line number in the XML source on which an Element node's end tag
begins, or 0 if the node is not an Element or was not created by the 
\fBparse\fR method. This attribute is read-only.  
\fIThis is not a standard DOM attribute for this interface.\fR

.sp
\fB-endColumn\fR
.sp
Returns the column number in the XML source on which an Element node's end
tag begins, or 0 if the node is not an Element or was not created by the 
\fBparse\fR method. This attribute is read-only.
\fIThis is not a standard DOM attribute for this interface.\fR

.sp
\fB-endWidth\fR
.sp
Returns the width in characters of the textual representation of the end
tag for an Element node in the XML source, or 0 if the node is not an 
Element or was not created by the \fBparse\fR method. 
This attribute is read-only.
\fIThis is not a standard DOM attribute for this interface.\fR

.sp
\fB-parsingComplete\fR
.sp
This attribute's value is "1" if parsing is complete for a node, or "0"
otherwise. This attribute is useful when the \fB-final\fR option is used 
when parsing XML.
This attribute is read-only.
\fIThis is not a standard DOM attribute for this interface.\fR

.IP "" 5

.sp
\fB::dom::document cget\fR \fInodeHandle\fR \fIattribute\fR
.sp
This method returns the value of a Node attribute.

.sp
\fB::dom::document insertBefore\fR \fInodeHandle\fR \fInewChildHandle\fR
	?\fIreferenceChildHandle\fR?
.sp
The node specified by \fInewChildHandle\fR is removed from its parent, 
and inserted as a child of \fInodeHandle\fR, positioned before the child
specified by \fIreferenceChildHandle\fR. If \fIreferenceChildHandle\fR is
not specified then the child is appended to \fInodeHandle\fR's list 
of children.

.sp
\fB::dom::document replaceChild\fR \fInodeHandle\fR \fInewChildHandle\fR
	\fIoldChildHandle\fR
.sp
The node specified by \fInewChildHandle\fR is removed from its parent, 
and replaces \fIoldChildHandle\fR as a child of \fInodeHandle\fR.
The node \foldChildHandle\fR is now without a parent.

.sp
\fB::dom::document removeChild\fR \fInodeHandle\fR \fIoldChildHandle\fR
.sp
The node specified by \fIoldChildHandle\fR is removed from 
\fInodeHandle\fR; it will now have no parent.

.sp
\fB::dom::document appendChild\fR \fInodeHandle\fR \fInewChildHandle\fR
.sp
The node specified by \fIoldChildHandle\fR is appended to the node
specified by \fInodeHandle\fR.

.sp
\fB::dom::document hasChildNodes\fR \fInodeHandle\fR
.sp
Returns "1" is the node has any child nodes; "0" otherwise.

.sp
\fB::dom::document cloneNode\fR \fInodeHandle\fR ?\fIdeep\fR?
.sp
This command copies the node specified by \fInodeHandle\fR. If the argument
\fIdeep\fR is not specified, or has the value "0", then only the node itself
is copied, not its children. If the argument \fIdeep\fR has the value "1",
then the node's children are also copied recursively. The method returns a 
handle for the newly created node.

.sp
\fB::dom::document children \fR \fInodeHandle\fR
.sp
This is a convenience method that returns a list of child nodes for the 
given node. \fIThis is not a standard DOM method for this interface\fR.

.sp
\fB::dom::document parent \fR \fInodeHandle\fR
.sp
This is a convenience method that returns the parent node for the 
given node. \fIThis is not a standard DOM method for this interface\fR.

.sp
.TP
.B ::dom::element \fImethod\fR \fIelementHandle\fR ?\fIarguments...\fR?
.br
This command implements the Element interface of the DOM specification.
The Element node is specified by \fIelementHandle\fR.  The following 
methods are supported:

.sp
\fB::dom::element configure\fR \fIelementHandle\fR \fIattribute\fR 
	?\fIvalue\fR?
.sp
This method reads or writes the value of an Element attribute. Element
attributes are:

.IP "" 10

.sp
\fB-tagName\fR
.sp
Specifies the tag name, or element type, of this element.

.sp
\fB-empty\fR
.sp
Specifies whether this element was specified as an empty element when
the document was parsed.

.IP "" 5

.sp
\fB::dom::element cget\fR \fIelementHandle\fR \fIattribute\fR
.sp
This method returns a value of an Element attribute.

.sp
\fB::dom::element getAttribute\fR \fIelementHandle\fR \fIname\fR
.sp
This method returns the value of the attribute given by \fIname\fR. If the
attribute does not exist then an empty string is returned.

.sp
\fB::dom::element setAttribute\fR \fIelementHandle\fR \fIname\fR \fIvalue\fR
.sp
This method sets the value of the attribute given by \fIname\fR. If the
attribute already exists then its value is replaced; otherwise the attribute
is created.

.sp
\fB::dom::element getAttributeNode\fR \fIelementHandle\fR \fIname\fR
.sp
This method is not implemented. 

.sp
\fB::dom::element setAttributeNode\fR \fIelementHandle\fR \fIname\fR
.sp
This method is not implemented. 

.sp
\fB::dom::element removeAttributeNode\fR \fIelementHandle\fR \fIname\fR
.sp
This method is not implemented. 

.sp
\fB::dom::element getElementsByTagName\fR \fIelementHandle\fR \fIname\fR
.sp
This method searches the specified node for child elements with a type
matching the argument \fIname\fR, and returns a Tcl variable whose value
is the list of matching nodes.

.sp
\fB::dom::element normalize\fR \fIelementHandle\fR
.sp
This method recursively coalesces Text nodes withing the children of the given
node.

.sp
.TP
.B ::dom::processinginstruction \fImethod\fR \fIhandle\fR ?\fIarguments...\fR?
.br
This command implements the ProcessingInstruction interface of the 
DOM specification.  A ProcessingInstruction node is specified by 
\fIhandle\fR.  The following methods are supported:

.sp
\fB::dom::processinginstruction configure\fR \fIhandle\fR \fIattribute\fR 
	?\fIvalue\fR?
.sp
This method reads or writes the value of a ProcessingInstruction attribute. 
ProcessingInstruction attributes are:

.IP "" 10

.sp
\fB-target\fR
.sp
Specifies the target of the ProcessingInstruction. This attribute is
read-only.

.sp
\fB-data\fR
.sp
Specifies the data of the ProcessingInstruction. 

.IP "" 5

.sp
\fB::dom::processinginstruction cget\fR \fIhandle\fR \fIattribute\fR
.sp
This method returns a value of a ProcessingInstruction attribute.

.sp
.SH LEVEL 2 INTERFACES
.sp
The following are DOM Level 2 interfaces. The specification of these 
interfaces is still at the draft stage, and may change at any time.

.sp
.TP
.B ::dom::DocumentTraversal \fImethod\fR \fIhandle\fR ?\fIarguments...\fR?
.br
This command implements the DocumentTraversal interface. 
The following methods are supported:

.sp
\fB::dom::DocumentTraversal createNodeIterator\fR \fIrootHandle\fR
	?\fB-show\fR \fIshowList\fR? ?\fB-filter\fR \fIfilterCommand\fR?
	?\fB-expandEntities\fR \fIexpandFlag\fI?
.sp
This method create a NodeIterator object and returns a handle for it. 
The handle \fIrootHandle\fR specified the node that will be iterated.
.sp
The \fB-show\fR option may be used to specify which node types appear in
the logical view of the tree. Here \fIshowList\fR is a list of node types
that are to appear, or the word "all". Valid node types are "element",
"attribute", "textNode", "CDATASection", "entityReference",
"entity", "processinginstruction", "comment", "document", "documentType",
"documentFragment", or "notation". A node type may be prefixed with "+" to 
add it to the list, or with "-" to remove it.
.sp
The \fB-filter\fR option may be used to supply a Tcl command that determines
whether nodes are included in the logical view of the tree. A handle for 
candidate nodes is appended to the command when executing the filter. If the
filter returns "1" then the node belongs to the tree's logical view; otherise
it does not.
.sp
The \fB-expandEntities\fR options determines whether entity reference nodes
are expanded. Currently this flag has no effect.

.sp
\fB::dom::DocumentTraversal createTreeWalker\fR \fIrootHandle\fR
	?\fB-show\fR \fIshowList\fR? ?\fB-filter\fR \fIfilterCommand\fR?
	?\fB-expandEntities\fR \fIexpandFlag\fI?
.sp
This method create a TreeWalker object and returns a handle for it. 
The handle \fIrootHandle\fR specified the node that will be iterated.
.sp
The \fB-show\fR option may be used to specify which node types appear in
the logical view of the tree. Here \fIshowList\fR is a list of node types
that are to appear, or the word "all". Valid node types are "element",
"attribute", "textNode", "CDATASection", "entityReference",
"entity", "processinginstruction", "comment", "document", "documentType",
"documentFragment", or "notation". A node type may be prefixed with "+" to 
add it to the list, or with "-" to remove it.
.sp
The \fB-filter\fR option may be used to supply a Tcl command that determines
whether nodes are included in the logical view of the tree. A handle for 
candidate nodes is appended to the command when executing the filter. If the
filter returns "1" then the node belongs to the tree's logical view; otherise
it does not.
.sp
The \fB-expandEntities\fR options determines whether entity reference nodes
are expanded. Currently this flag has no effect.

.sp
.TP
.B ::dom::nodeIterator \fImethod\fR \fIiteratorHandle\fR ?\fIarguments...\fR?
.br
This command implements the NodeIterator interface. 
The following methods are supported:

.sp
\fB::dom::nodeIterator configure\fR \fIiteratorHandle\fR \fIattribute\fR ?\fIvalue\fR?
.sp
This method reads or writes the value of a NodeIterator attribute. NodeIterator
attributes are:

.IP "" 10

.sp
\fB-show\fR
.sp
Specifies the list of node types in the logical view of the tree. This attribute is
read-only.

.sp
\fB-filter\fR
.sp
Specifies the filter command. This attribute is
read-only.

.sp
\fB-expandEntities\fR
.sp
Specifies whether entity references are to be expanded. This attribute is
read-only.

.IP "" 5

.sp
\fB::dom::nodeIterator cget\fR \fIiteratorHandle\fR \fIattribute\fR
.sp
This method returns a value of a NodeIterator attribute.

.sp
\fB::dom::nodeIterator nextNode\fR \fIiteratorHandle\fR 
.sp
This method returns a handle for the next node in the logical view of the tree.

.sp
\fB::dom::nodeIterator previousNode\fR \fIiteratorHandle\fR 
.sp
This method returns a handle for the previous node in the logical view of 
the tree.

.sp
.TP
.B ::dom::treeWalker \fImethod\fR \fItreeWalkerHandle\fR ?\fIarguments...\fR?
.br
This command implements the TreeWalker interface. 
The following methods are supported:

.sp
\fB::dom::treeWalker configure\fR \fItreeWalkerHandle\fR \fIattribute\fR ?\fIvalue\fR?
.sp
This method reads or writes the value of a TreeWalker attribute. TreeWalker
attributes are:

.IP "" 10

.sp
\fB-show\fR
.sp
Specifies the list of node types in the logical view of the tree. This attribute is
read-only.

.sp
\fB-filter\fR
.sp
Specifies the filter command. This attribute is
read-only.

.sp
\fB-expandEntities\fR
.sp
Specifies whether entity references are to be expanded. This attribute is
read-only.

.IP "" 5

.sp
\fB::dom::treeWalker cget\fR \fItreeWalkerHandle\fR \fIattribute\fR
.sp
This method returns a value of a TreeWalker attribute.

.sp
\fB::dom::treeWalker nextNode\fR \fItreeWalkerHandle\fR 
.sp
This method moves to and returns a handle for the next node in the logical view of the tree.

.sp
\fB::dom::treeWalker previousNode\fR \fItreeWalkerHandle\fR 
.sp
This method moves to and returns a handle for the previous node in the 
logical view of the tree.

.sp
\fB::dom::treeWalker firstChild\fR \fItreeWalkerHandle\fR 
.sp
This method moves to and returns a handle for the first child node of the 
current node in logical view of the tree.

.sp
\fB::dom::treeWalker lastChild\fR \fItreeWalkerHandle\fR 
.sp
This method moves to and returns a handle for the last child node of the 
current node in logical view of the tree.

.sp
\fB::dom::treeWalker previousSibling\fR \fItreeWalkerHandle\fR 
.sp
This method moves to and returns a handle for the previous sibling node of the 
current node in logical view of the tree.

.sp
\fB::dom::treeWalker nextSibling\fR \fItreeWalkerHandle\fR 
.sp
This method moves to and returns a handle for the next sibling node of the 
current node in logical view of the tree.

.sp
\fB::dom::treeWalker parentNode\fR \fItreeWalkerHandle\fR 
.sp
This method moves to and returns a handle for the parent node of the current 
node in logical view of the tree.







.sp
.SH NOTES

.sp
.SH BUGS
.sp
FILTER_REJECT is not implemented for Level 2 TreeWalker objects.

.sp
.SH AUTHOR
Scriptics Corporation. The Level 1 API is based on that of TclDOM, written by 
Steve Ball.
.sp
