from distutils.core import setup, Extension
from distutils.command.build_ext import build_ext
from distutils.msvccompiler import MSVCCompiler
import string

mkobjs = ['column', 'custom', 'derived', 'fileio', 'field',
          'format', 'handler', 'persist', 'remap', 'std',
          'store', 'string', 'table', 'univ', 'view', 'viewx']

class build_mkext(build_ext):
    def build_extension(self, ext):
        if ext.name == "Mk4py":
            if isinstance(self.compiler, MSVCCompiler):
                suffix = '.obj'
                if self.debug:
                    prefix = '../builds/msvc60/mklib/Debug/'
                else:
                    prefix = '../builds/msvc60/mklib/Release/'
            else:
                suffix = '.o'
                prefix = '../builds/'
            for i in range(len(ext.extra_objects)):
                nm = ext.extra_objects[i]
                if nm in mkobjs:
                    if string.find(nm, '.') == -1:
                        nm = nm + suffix
                    nm = prefix + nm
                    ext.extra_objects[i] = nm
        build_ext.build_extension(self, ext)
    

setup(name="Metakit",
      description="Python Bindings to the Metakit DB Library",
      author="Gordon McMillan / Jean-Claude Wippler",
      url="http://www.equi4.com/metakit/",
      py_modules=['metakit'],
      cmdclass = {'build_ext' : build_mkext },
      ext_modules=[Extension("Mk4py",
                             ["PyProperty.cpp",
                              "PyRowRef.cpp",
                              "PyStorage.cpp",
                              "PyView.cpp",
                              "scxx/PWOImp.cpp",
                             ],
                             include_dirs=["scxx",
                                           "../include"],
                             extra_objects=mkobjs
                            ),]
    )
               
