# PROVIDE RPC Server Services
# Created: Wed Apr 10 09:16:40 EDT 1996
# Version 1.0
# Functions available:
# NONE
# Called from: /etc/inetd
# 
proc docs {} {

Input Format:
	1-CHARACTER COMMAND CODE
	6-CHARACTER LENGTH OF DATA/COMMAND FOLLOWING (in ascii)
	DATA/COMMAND WITHOUT TRANSLATION (NO CR/LF etc.)

Output Format:
	1-CHARACTER COMMAND CODE
	6-CHARACTER LENGTH OF DATA/COMMAND FOLLOWING (in ascii)
	DATA/COMMAND WITHOUT TRANSLATION (NO CR/LF etc.)

Available Input Command Codes:
	SPACE		
		Evaluate Command as is
	P			
		Set up a proxy server to server specified in data
		The syntax for the proxy server is
		mach1@mach2@mach3@mach4
		If server name does not contain a @, then will use
		local services otherwise forward it to the appropriate
		server
	V
		Validate user connection with database
		The database is stored in /etc/rpctcl.db with the format
		ipaddress	{userlist} {allow-commands} {deny-commands}
		e.g.
		1.0.1.1		{*} {sql* open* close* gets* read* seek* eof*} {*}
		If environment variable RPCTCLDB is set and points to
		a readable file then that file will be used instead
	L
		Login to user specified in data first 
		(need not be a valid UNIX user)
Available Output Command Codes:
	SPACE
		Interpret and return data as is
	E
		Interpret data as an error
	F
		Interpret as an EOF (the server disappeared or shut-down)
	X
		Server exited (normally)
}

# Send output back to client
proc send_output {cmd} {
	global menu
	set len [string length $cmd]
	puts -nonewline stdout [format " %06d" $len]
	puts -nonewline stdout $cmd
	if {$menu(srvdebug) == 1} {
		puts $menu(srvdbgfp) "[pid] : Sending output $cmd"
		flush $menu(srvdbgfp)
	}
	flush stdout
}
# Send Control Commands back to client
proc send_control {state cmd} {
	global menu
	set len [string length $cmd]
	puts -nonewline stdout [format "%-1.1s%06d" $state $len]
	puts -nonewline stdout $cmd
	flush stdout
	if {$menu(srvdebug) == 1} {
		puts $menu(srvdbgfp) "[pid] : Sending control '$state' $cmd"
		flush $menu(srvdbgfp)
	}
}
# Loop waiting for requests
# Read request length
# Read request
# Eval Request
# Send Output Back
proc main {} {
	global menu
	set menu(srvdebug) [getenv RPCSERVDEBUG]
	set menu(srvdbgfile) [getenv RPCSERVDEBUGFILE]
	set menu(proxy) 0
	set menu(proxy,server) ""
	set menu(proxy,handle) ""
	if {$menu(srvdebug) == 1} {
		if {$menu(srvdbgfile) == ""} {
			set menu(srvdbgfile) /tmp/rpcdbg.1
		}
		set menu(srvdbgfp) [open $menu(srvdbgfile) a]
	}
	looper
}

proc rpceval {} {
	global menu
	set ret [catch {eval $menu(line)} out]
	if {$ret == 0} {
		send_output $out
	} else {
		send_control E $out
	}
}
proc looper {} {
	global menu
	while {1} {
		set len [read stdin 7]
		if {[eof stdin]} {
			send_control F EOF
			exit 0
		}
		set control [string range $len 0 0]
		if {$menu(srvdebug) == 1} {
			puts $menu(srvdbgfp) "[pid] : GOT CONTROL '$control' len '$len'"
			flush $menu(srvdbgfp)
		}
		if {[scan $len "%*c%d" len] != 1} {
			send_control E "INVALID FORMAT CONTROL '$control' DATA '$len'"
			continue
		}
		set menu(control) $control
		set menu(len) $len
		set menu(line) [read stdin $len]
		if {$menu(srvdebug) == 1} {
			puts $menu(srvdbgfp) "[pid] : GOT DATA $menu(line)"
			flush $menu(srvdbgfp)
		}
		if {[eof stdin]} {
			send_control F EOF
			exit 0
		}
		if {$menu(line) == ""} {
			send_control X EXIT
			exit 0
		}
		if {$control == " "} {
			rpceval
			continue
		}
		if {$control == "Q"} {
			rpceval
			continue
		}
		if {$control == "P"} {
			rpcproxy
			continue
		}
		send_control E "INVALID FORMAT CONTROL '$control' DATA '$len'"
		continue
	}
}
proc rpcproxy {} {
	global menu
	if {$menu(proxy) == 1} {
		send_control E "Proxy already exists with $menu(proxy,server)"
		return
	}
	set slist [string trim [split $menu(line) "@"]]
	if {$menu(srvdebug) == 1} {
		puts $menu(srvdbgfp) "[pid] : Got proxy $slist"
		flush $menu(srvdbgfp)
	}
	if {[llength $slist] == 1} {
		send_control L "LOGGED [pid]"
		return
	}
	set slist [join [lrange $slist 1 end] "@"]
	if {$menu(srvdebug) == 1} {
		puts $menu(srvdbgfp) "[pid] : Calling rpcopen $slist"
		flush $menu(srvdbgfp)
	}
	if {[catch {rpcopen $slist} handle] != 0} {
		send_control E $handle
		return
	}
	if {$menu(srvdebug) == 1} {
		puts $menu(srvdbgfp) "[pid] : Got handle from rpcopen $handle"
		flush $menu(srvdbgfp)
	}

	set menu(proxy) 1
	set menu(proxy,handle) $handle
	set menu(proxy,server) $slist
	send_output $handle
	return
}
source rpc.tcl
main
