# See the file LICENSE for redistribution information.
#
# Copyright (c) 1999
#	Sleepycat Software.  All rights reserved.
#
#	$Id: test075.tcl,v 1.1.1.1.2.2 2000/02/08 00:48:23 noriko Exp $
#
# DB Test 75: Test of DB_TRUNCATE cached page invalidation.
proc test075 { method { niter 5 } { nkeys 5 } { tnum 75 } args } {
	source ./include.tcl
	global rand_init

	set omethod [convert_method $method]
	set args [convert_args $method $args]

	cleanup $testdir
	berkdb srand $rand_init

	puts "Test075: Test of DB_TRUNCATE cached page invalidation."
	
	if { [is_record_based $method] == 1 } {
		puts "\tSkipping for method $method."
		return
	}

	# Create an env if we weren't passed one.
	set eindex [lsearch -exact $args "-env"]
	if { $eindex == -1 } {
		set deleteenv 1
		set env [eval {berkdb env -create -home} $testdir]
		error_check_good env [is_valid_env $env] TRUE
		set args "$args -env $env"
	} else {
		set deleteenv 0
	}

	set testfile test0$tnum.db

	set data "somedata"

	# Run the meat of the test five times, since we have
	# to hit a one-second clock tick and there's a probablistic
	# component here.
	for { set iter 0 } { $iter < $niter } { incr iter } { 

		puts "\tTest0$tnum: Testing iteration $iter"

		set db [eval {berkdb open -create -truncate -mode 0644}\
		    $args $omethod $testfile]
		error_check_good db_open($iter) [is_valid_db $db] TRUE
	
		if { $iter >= 1 } { 
			set lastiter [expr $iter - 1]
			set i [berkdb random_int 0 [expr $nkeys - 1]]
			set key key$lastiter$i
			
			set dbt [$db get $key]
			error_check_good keyempty$lastiter$i \
			    [lindex [lindex $dbt 0] 0] {}
		}	

		for { set i 0 } { $i < $nkeys } { incr i } {
			set key key$iter$i
			error_check_good db_put($iter$i) [$db put $key $data] 0
		}

		error_check_good db_close($iter) [$db close] 0

	}
	
	if { $deleteenv == 1 } {
		error_check_good env_close [$env close] 0
	}
}


