package Memcached::libmemcached::memcached_get;
=head1 NAME

memcached_get, memcached_mget, memcached_fetch

=head1 LIBRARY

C Client Library for memcached (libmemcached, -lmemcached)

=head1 SYNOPSIS

  #include <memcached.h>

  memcached_result_st *
  memcached_fetch_result(memcached_st *ptr, 
		       memcached_result_st *result,
		       memcached_return *error);

  char *memcached_get (memcached_st *ptr,
                       char *key, size_t key_length,
                       size_t *value_length, 
                       uint16_t *flags,
                       memcached_return *error);

  memcached_return
  memcached_mget (memcached_st *ptr, 
                  char **keys, size_t *key_length, 
                  unsigned int number_of_keys);
  char *
  memcached_get_by_key(memcached_st *ptr, 
                       char *master_key, size_t master_key_length, 
                       char *key, size_t key_length, 
                       size_t *value_length, 
                       uint16_t *flags,
                       memcached_return *error);

  memcached_return 
  memcached_mget_by_key(memcached_st *ptr, 
                        char *master_key, size_t master_key_length,
                        char **keys, size_t *key_length, 
                        unsigned int number_of_keys);

  char *memcached_fetch (memcached_st *ptr,
                         char *key, size_t *key_length, 
                         size_t *value_length,
                         uint16_t *flags, 
                         memcached_return *error);
  memcached_return 
  memcached_fetch_execute(memcached_st *ptr, 
                          unsigned int (*callback[])(memcached_st *ptr, memcached_result_st *result, void *context),
                          void *context,
                          unsigned int number_of_callbacks
                         )

=head1 DESCRIPTION

memcached_get() is used to fetch an individual value from the server. You
must pass in a key and its length to fetch the object. You must supply
three pointer variables which will give you the state of the returned
object.  A uint16_t pointer to contain whatever flags you stored with the value,
a size_t pointer which will be filled with size of of the object, and a
memcached_return pointer to hold any error. The object will be returned
upon success and NULL will be returned on failure. 

memcached_mget() is used to select multiple keys at once. For multiple key
operations it is always faster to use this function. This function always
works asynchronously. memcached_fetch() is then used to retrieve any keys
found. No error is given on keys that are not found. You must call either
memcached_fetch() or memcached_fetch_result() after a successful call to
memcached_mget(). You should continue to call these functions until they
return NULL (aka no more values). If you need to quit in the middle of a
memcached_get() call, execute a memcached_quit(). After you do this, you can
issue new queries against the server.

memcached_fetch() is used to fetch an individual value from the server. 
memcached_mget() must always be called before using this method.  You
must pass in a key and its length to fetch the object. You must supply
three pointer variables which will give you the state of the returned
object.  A uint16_t pointer to contain whatever flags you stored with the value,
a size_t pointer which will be filled with size of of the object, and a
memcached_return pointer to hold any error. The object will be returned
upon success and NULL will be returned on failure. 

memcached_fetch_result() is used to return a memcached_result_st(3) structure 
from a memcached server. The result object is forward compatible with changes
to the server. For more information please refer to the memcached_result_st(3) 
help. This function will dynamically allocate a result structure for you
if you do not pass one to the function.

memcached_fetch_execute() is a callback function for result sets. Instead
of returning the results to you for processing, it passes each of the
result sets to the list of functions you provide. It passes to the function
a memcached_st that can be cloned for use in called the cluster (it can not 
be used directly). It also passed a result set which does not need to be freed.
Finally it passes a "context". This is just a pointer to a memory reference
you supply the calling function. Currently only one value is being passed
to each function call. In the future there will be an option to allow this
to be an array.

memcached_get_by_key() and memcached_mget_by_key() behave in a similar nature
as memcached_get() and memcached_mget(). The difference is that they take
a master key that is used for determining which server an object was stored
if key partitioning was used for storage.

=head1 RETURN

All objects returned must be freed by the calling application.
memcached_get() and memcached_fetch() will return NULL on error. You must
look at the value of error to determine what the actual error was.

=head1 HOME

To find out more information please check:
L<http://tangent.org/552/libmemcached.html>

=head1 AUTHOR

Brian Aker, E<lt>brian@tangent.orgE<gt>

=head1 SEE ALSO

memcached(1) libmemcached(3) memcached_strerror(3)

=cut

1;
