package Bio::KBase::CDMI::CDMI_EntityAPIImpl;
use strict;
use Bio::KBase::Exceptions;

=head1 NAME

CDMI_EntityAPI

=head1 DESCRIPTION



=cut

#BEGIN_HEADER

use Bio::KBase::CDMI::CDMI;

our $entity_field_defs = {
    'AlignmentTree' => {
	id => 1,
		    'alignment_method' => 1,
		    'alignment_parameters' => 1,
		    'alignment_properties' => 1,
		    'tree_method' => 1,
		    'tree_parameters' => 1,
		    'tree_properties' => 1,
	
    },
    'AlleleFrequency' => {
	id => 1,
		    'source_id' => 1,
		    'position' => 1,
		    'minor_AF' => 1,
		    'minor_allele' => 1,
		    'major_AF' => 1,
		    'major_allele' => 1,
		    'obs_unit_count' => 1,
	
    },
    'Annotation' => {
	id => 1,
		    'annotator' => 1,
		    'comment' => 1,
		    'annotation_time' => 1,
	
    },
    'Assay' => {
	id => 1,
		    'source_id' => 1,
		    'assay_type' => 1,
		    'assay_type_id' => 1,
	
    },
    'AtomicRegulon' => {
	id => 1,
	
    },
    'Attribute' => {
	id => 1,
		    'description' => 1,
	
    },
    'Biomass' => {
	id => 1,
		    'mod_date' => 1,
		    'name' => 1,
	
    },
    'BiomassCompound' => {
	id => 1,
		    'coefficient' => 1,
	
    },
    'Compartment' => {
	id => 1,
		    'abbr' => 1,
		    'mod_date' => 1,
		    'name' => 1,
		    'msid' => 1,
	
    },
    'Complex' => {
	id => 1,
		    'name' => 1,
		    'msid' => 1,
		    'mod_date' => 1,
	
    },
    'Compound' => {
	id => 1,
		    'label' => 1,
		    'abbr' => 1,
		    'msid' => 1,
		    'ubiquitous' => 1,
		    'mod_date' => 1,
		    'uncharged_formula' => 1,
		    'formula' => 1,
		    'mass' => 1,
	
    },
    'Contig' => {
	id => 1,
		    'source_id' => 1,
	
    },
    'ContigChunk' => {
	id => 1,
		    'sequence' => 1,
	
    },
    'ContigSequence' => {
	id => 1,
		    'length' => 1,
	
    },
    'CoregulatedSet' => {
	id => 1,
		    'source_id' => 1,
		    'binding_location' => 1,
	
    },
    'Diagram' => {
	id => 1,
		    'name' => 1,
		    'content' => 1,
	
    },
    'EcNumber' => {
	id => 1,
		    'obsolete' => 1,
		    'replacedby' => 1,
	
    },
    'Experiment' => {
	id => 1,
		    'source' => 1,
	
    },
    'Family' => {
	id => 1,
		    'type' => 1,
		    'release' => 1,
		    'family_function' => 1,
		    'alignment' => 1,
	
    },
    'Feature' => {
	id => 1,
		    'feature_type' => 1,
		    'source_id' => 1,
		    'sequence_length' => 1,
		    'function' => 1,
		    'alias' => 1,
	
    },
    'Genome' => {
	id => 1,
		    'pegs' => 1,
		    'rnas' => 1,
		    'scientific_name' => 1,
		    'complete' => 1,
		    'prokaryotic' => 1,
		    'dna_size' => 1,
		    'contigs' => 1,
		    'domain' => 1,
		    'genetic_code' => 1,
		    'gc_content' => 1,
		    'phenotype' => 1,
		    'md5' => 1,
		    'source_id' => 1,
	
    },
    'Locality' => {
	id => 1,
		    'source_name' => 1,
		    'city' => 1,
		    'state' => 1,
		    'country' => 1,
		    'origcty' => 1,
		    'elevation' => 1,
		    'latitude' => 1,
		    'longitude' => 1,
		    'lo_accession' => 1,
	
    },
    'Media' => {
	id => 1,
		    'mod_date' => 1,
		    'name' => 1,
		    'type' => 1,
	
    },
    'Model' => {
	id => 1,
		    'mod_date' => 1,
		    'name' => 1,
		    'version' => 1,
		    'type' => 1,
		    'status' => 1,
		    'reaction_count' => 1,
		    'compound_count' => 1,
		    'annotation_count' => 1,
	
    },
    'ModelCompartment' => {
	id => 1,
		    'compartment_index' => 1,
		    'label' => 1,
		    'pH' => 1,
		    'potential' => 1,
	
    },
    'OTU' => {
	id => 1,
	
    },
    'ObservationalUnit' => {
	id => 1,
		    'source_name' => 1,
		    'source_name2' => 1,
		    'plant_id' => 1,
	
    },
    'PairSet' => {
	id => 1,
		    'score' => 1,
	
    },
    'Pairing' => {
	id => 1,
	
    },
    'ProbeSet' => {
	id => 1,
	
    },
    'ProteinSequence' => {
	id => 1,
		    'sequence' => 1,
	
    },
    'Publication' => {
	id => 1,
		    'title' => 1,
		    'link' => 1,
		    'pubdate' => 1,
	
    },
    'Reaction' => {
	id => 1,
		    'mod_date' => 1,
		    'name' => 1,
		    'msid' => 1,
		    'abbr' => 1,
		    'equation' => 1,
		    'reversibility' => 1,
	
    },
    'ReactionRule' => {
	id => 1,
		    'direction' => 1,
		    'transproton' => 1,
	
    },
    'Reagent' => {
	id => 1,
		    'stoichiometry' => 1,
		    'cofactor' => 1,
		    'compartment_index' => 1,
		    'transport_coefficient' => 1,
	
    },
    'Requirement' => {
	id => 1,
		    'direction' => 1,
		    'transproton' => 1,
		    'proton' => 1,
	
    },
    'Role' => {
	id => 1,
		    'hypothetical' => 1,
	
    },
    'SSCell' => {
	id => 1,
	
    },
    'SSRow' => {
	id => 1,
		    'curated' => 1,
		    'region' => 1,
	
    },
    'Scenario' => {
	id => 1,
		    'common_name' => 1,
	
    },
    'Source' => {
	id => 1,
	
    },
    'StudyExperiment' => {
	id => 1,
		    'source_name' => 1,
		    'design' => 1,
		    'originator' => 1,
	
    },
    'Subsystem' => {
	id => 1,
		    'version' => 1,
		    'curator' => 1,
		    'notes' => 1,
		    'description' => 1,
		    'usable' => 1,
		    'private' => 1,
		    'cluster_based' => 1,
		    'experimental' => 1,
	
    },
    'SubsystemClass' => {
	id => 1,
	
    },
    'TaxonomicGrouping' => {
	id => 1,
		    'domain' => 1,
		    'hidden' => 1,
		    'scientific_name' => 1,
		    'alias' => 1,
	
    },
    'Trait' => {
	id => 1,
		    'trait_name' => 1,
		    'unit_of_measure' => 1,
		    'TO_ID' => 1,
		    'protocol' => 1,
	
    },
    'Variant' => {
	id => 1,
		    'role_rule' => 1,
		    'code' => 1,
		    'type' => 1,
		    'comment' => 1,
	
    },

};

our $entity_field_rels = {
    'AlignmentTree' => {
    },
    'AlleleFrequency' => {
    },
    'Annotation' => {
    },
    'Assay' => {
    },
    'AtomicRegulon' => {
    },
    'Attribute' => {
    },
    'Biomass' => {
	    'name' => 'BiomassName',
    },
    'BiomassCompound' => {
    },
    'Compartment' => {
    },
    'Complex' => {
	    'name' => 'ComplexName',
    },
    'Compound' => {
    },
    'Contig' => {
    },
    'ContigChunk' => {
    },
    'ContigSequence' => {
    },
    'CoregulatedSet' => {
	    'binding_location' => 'CoregulatedSetBinding',
    },
    'Diagram' => {
	    'content' => 'DiagramContent',
    },
    'EcNumber' => {
    },
    'Experiment' => {
    },
    'Family' => {
	    'family_function' => 'FamilyFunction',
	    'alignment' => 'FamilyAlignment',
    },
    'Feature' => {
	    'alias' => 'FeatureAlias',
    },
    'Genome' => {
	    'phenotype' => 'GenomeSequencePhenotype',
    },
    'Locality' => {
    },
    'Media' => {
    },
    'Model' => {
    },
    'ModelCompartment' => {
	    'label' => 'ModelCompartmentLabel',
    },
    'OTU' => {
    },
    'ObservationalUnit' => {
	    'source_name2' => 'ObservationalUnitName2',
    },
    'PairSet' => {
    },
    'Pairing' => {
    },
    'ProbeSet' => {
    },
    'ProteinSequence' => {
    },
    'Publication' => {
    },
    'Reaction' => {
    },
    'ReactionRule' => {
    },
    'Reagent' => {
    },
    'Requirement' => {
    },
    'Role' => {
    },
    'SSCell' => {
    },
    'SSRow' => {
    },
    'Scenario' => {
    },
    'Source' => {
    },
    'StudyExperiment' => {
    },
    'Subsystem' => {
    },
    'SubsystemClass' => {
    },
    'TaxonomicGrouping' => {
	    'alias' => 'TaxonomicGroupingAlias',
    },
    'Trait' => {
    },
    'Variant' => {
	    'role_rule' => 'VariantRole',
    },

};

our $relationship_field_defs = {
    'AffectsLevelOf' => {
	to_link => 1, from_link => 1,
		    'level' => 1,
	
    },
    'IsAffectedIn' => {
	to_link => 1, from_link => 1,
		    'level' => 1,
	
    },
    'Aligns' => {
	to_link => 1, from_link => 1,
		    'begin' => 1,
		    'end' => 1,
		    'len' => 1,
		    'sequence_id' => 1,
		    'properties' => 1,
	
    },
    'IsAlignedBy' => {
	to_link => 1, from_link => 1,
		    'begin' => 1,
		    'end' => 1,
		    'len' => 1,
		    'sequence_id' => 1,
		    'properties' => 1,
	
    },
    'AssertsFunctionFor' => {
	to_link => 1, from_link => 1,
		    'function' => 1,
		    'external_id' => 1,
		    'organism' => 1,
		    'gi_number' => 1,
		    'release_date' => 1,
	
    },
    'HasAssertedFunctionFrom' => {
	to_link => 1, from_link => 1,
		    'function' => 1,
		    'external_id' => 1,
		    'organism' => 1,
		    'gi_number' => 1,
		    'release_date' => 1,
	
    },
    'Concerns' => {
	to_link => 1, from_link => 1,
	
    },
    'IsATopicOf' => {
	to_link => 1, from_link => 1,
	
    },
    'Contains' => {
	to_link => 1, from_link => 1,
	
    },
    'IsContainedIn' => {
	to_link => 1, from_link => 1,
	
    },
    'Controls' => {
	to_link => 1, from_link => 1,
	
    },
    'IsControlledUsing' => {
	to_link => 1, from_link => 1,
	
    },
    'Describes' => {
	to_link => 1, from_link => 1,
	
    },
    'IsDescribedBy' => {
	to_link => 1, from_link => 1,
	
    },
    'Displays' => {
	to_link => 1, from_link => 1,
		    'location' => 1,
	
    },
    'IsDisplayedOn' => {
	to_link => 1, from_link => 1,
		    'location' => 1,
	
    },
    'Encompasses' => {
	to_link => 1, from_link => 1,
	
    },
    'IsEncompassedIn' => {
	to_link => 1, from_link => 1,
	
    },
    'Formulated' => {
	to_link => 1, from_link => 1,
	
    },
    'WasFormulatedBy' => {
	to_link => 1, from_link => 1,
	
    },
    'GeneratedLevelsFor' => {
	to_link => 1, from_link => 1,
		    'level_vector' => 1,
	
    },
    'WasGeneratedFrom' => {
	to_link => 1, from_link => 1,
		    'level_vector' => 1,
	
    },
    'HasCompoundAliasFrom' => {
	to_link => 1, from_link => 1,
		    'alias' => 1,
	
    },
    'UsesAliasForCompound' => {
	to_link => 1, from_link => 1,
		    'alias' => 1,
	
    },
    'HasIndicatedSignalFrom' => {
	to_link => 1, from_link => 1,
		    'rma_value' => 1,
		    'level' => 1,
	
    },
    'IndicatesSignalFor' => {
	to_link => 1, from_link => 1,
		    'rma_value' => 1,
		    'level' => 1,
	
    },
    'HasMember' => {
	to_link => 1, from_link => 1,
	
    },
    'IsMemberOf' => {
	to_link => 1, from_link => 1,
	
    },
    'HasParticipant' => {
	to_link => 1, from_link => 1,
		    'type' => 1,
	
    },
    'ParticipatesIn' => {
	to_link => 1, from_link => 1,
		    'type' => 1,
	
    },
    'HasPresenceOf' => {
	to_link => 1, from_link => 1,
		    'concentration' => 1,
		    'minimum_flux' => 1,
		    'maximum_flux' => 1,
	
    },
    'IsPresentIn' => {
	to_link => 1, from_link => 1,
		    'concentration' => 1,
		    'minimum_flux' => 1,
		    'maximum_flux' => 1,
	
    },
    'HasProteinMember' => {
	to_link => 1, from_link => 1,
		    'source_id' => 1,
	
    },
    'IsProteinMemberOf' => {
	to_link => 1, from_link => 1,
		    'source_id' => 1,
	
    },
    'HasReactionAliasFrom' => {
	to_link => 1, from_link => 1,
		    'alias' => 1,
	
    },
    'UsesAliasForReaction' => {
	to_link => 1, from_link => 1,
		    'alias' => 1,
	
    },
    'HasRepresentativeOf' => {
	to_link => 1, from_link => 1,
	
    },
    'IsRepresentedIn' => {
	to_link => 1, from_link => 1,
	
    },
    'HasResultsIn' => {
	to_link => 1, from_link => 1,
		    'sequence' => 1,
	
    },
    'HasResultsFor' => {
	to_link => 1, from_link => 1,
		    'sequence' => 1,
	
    },
    'HasSection' => {
	to_link => 1, from_link => 1,
	
    },
    'IsSectionOf' => {
	to_link => 1, from_link => 1,
	
    },
    'HasStep' => {
	to_link => 1, from_link => 1,
	
    },
    'IsStepOf' => {
	to_link => 1, from_link => 1,
	
    },
    'HasTrait' => {
	to_link => 1, from_link => 1,
		    'value' => 1,
		    'statistic_type' => 1,
		    'measure_id' => 1,
	
    },
    'Measures' => {
	to_link => 1, from_link => 1,
		    'value' => 1,
		    'statistic_type' => 1,
		    'measure_id' => 1,
	
    },
    'HasUnits' => {
	to_link => 1, from_link => 1,
	
    },
    'IsLocated' => {
	to_link => 1, from_link => 1,
	
    },
    'HasUsage' => {
	to_link => 1, from_link => 1,
	
    },
    'IsUsageOf' => {
	to_link => 1, from_link => 1,
	
    },
    'HasValueFor' => {
	to_link => 1, from_link => 1,
		    'value' => 1,
	
    },
    'HasValueIn' => {
	to_link => 1, from_link => 1,
		    'value' => 1,
	
    },
    'HasVariationIn' => {
	to_link => 1, from_link => 1,
		    'position' => 1,
		    'len' => 1,
		    'data' => 1,
		    'data2' => 1,
		    'quality' => 1,
	
    },
    'IsVariedIn' => {
	to_link => 1, from_link => 1,
		    'position' => 1,
		    'len' => 1,
		    'data' => 1,
		    'data2' => 1,
		    'quality' => 1,
	
    },
    'Impacts' => {
	to_link => 1, from_link => 1,
		    'source_name' => 1,
		    'rank' => 1,
		    'pvalue' => 1,
		    'position' => 1,
	
    },
    'IsImpactedBy' => {
	to_link => 1, from_link => 1,
		    'source_name' => 1,
		    'rank' => 1,
		    'pvalue' => 1,
		    'position' => 1,
	
    },
    'Includes' => {
	to_link => 1, from_link => 1,
		    'sequence' => 1,
		    'abbreviation' => 1,
		    'auxiliary' => 1,
	
    },
    'IsIncludedIn' => {
	to_link => 1, from_link => 1,
		    'sequence' => 1,
		    'abbreviation' => 1,
		    'auxiliary' => 1,
	
    },
    'IncludesPart' => {
	to_link => 1, from_link => 1,
	
    },
    'IsPartOf' => {
	to_link => 1, from_link => 1,
	
    },
    'IndicatedLevelsFor' => {
	to_link => 1, from_link => 1,
		    'level_vector' => 1,
	
    },
    'HasLevelsFrom' => {
	to_link => 1, from_link => 1,
		    'level_vector' => 1,
	
    },
    'Involves' => {
	to_link => 1, from_link => 1,
	
    },
    'IsInvolvedIn' => {
	to_link => 1, from_link => 1,
	
    },
    'IsARequirementIn' => {
	to_link => 1, from_link => 1,
	
    },
    'IsARequirementOf' => {
	to_link => 1, from_link => 1,
	
    },
    'IsAnnotatedBy' => {
	to_link => 1, from_link => 1,
	
    },
    'Annotates' => {
	to_link => 1, from_link => 1,
	
    },
    'IsAssayOf' => {
	to_link => 1, from_link => 1,
	
    },
    'IsAssayedBy' => {
	to_link => 1, from_link => 1,
	
    },
    'IsClassFor' => {
	to_link => 1, from_link => 1,
	
    },
    'IsInClass' => {
	to_link => 1, from_link => 1,
	
    },
    'IsCollectionOf' => {
	to_link => 1, from_link => 1,
		    'representative' => 1,
	
    },
    'IsCollectedInto' => {
	to_link => 1, from_link => 1,
		    'representative' => 1,
	
    },
    'IsComposedOf' => {
	to_link => 1, from_link => 1,
	
    },
    'IsComponentOf' => {
	to_link => 1, from_link => 1,
	
    },
    'IsComprisedOf' => {
	to_link => 1, from_link => 1,
	
    },
    'Comprises' => {
	to_link => 1, from_link => 1,
	
    },
    'IsConfiguredBy' => {
	to_link => 1, from_link => 1,
	
    },
    'ReflectsStateOf' => {
	to_link => 1, from_link => 1,
	
    },
    'IsConsistentWith' => {
	to_link => 1, from_link => 1,
	
    },
    'IsConsistentTo' => {
	to_link => 1, from_link => 1,
	
    },
    'IsCoregulatedWith' => {
	to_link => 1, from_link => 1,
		    'coefficient' => 1,
	
    },
    'HasCoregulationWith' => {
	to_link => 1, from_link => 1,
		    'coefficient' => 1,
	
    },
    'IsCoupledTo' => {
	to_link => 1, from_link => 1,
		    'co_occurrence_evidence' => 1,
		    'co_expression_evidence' => 1,
	
    },
    'IsCoupledWith' => {
	to_link => 1, from_link => 1,
		    'co_occurrence_evidence' => 1,
		    'co_expression_evidence' => 1,
	
    },
    'IsDefaultFor' => {
	to_link => 1, from_link => 1,
	
    },
    'RunsByDefaultIn' => {
	to_link => 1, from_link => 1,
	
    },
    'IsDefaultLocationOf' => {
	to_link => 1, from_link => 1,
	
    },
    'HasDefaultLocation' => {
	to_link => 1, from_link => 1,
	
    },
    'IsDeterminedBy' => {
	to_link => 1, from_link => 1,
		    'inverted' => 1,
	
    },
    'Determines' => {
	to_link => 1, from_link => 1,
		    'inverted' => 1,
	
    },
    'IsDividedInto' => {
	to_link => 1, from_link => 1,
	
    },
    'IsDivisionOf' => {
	to_link => 1, from_link => 1,
	
    },
    'IsExemplarOf' => {
	to_link => 1, from_link => 1,
	
    },
    'HasAsExemplar' => {
	to_link => 1, from_link => 1,
	
    },
    'IsFamilyFor' => {
	to_link => 1, from_link => 1,
	
    },
    'DeterminesFunctionOf' => {
	to_link => 1, from_link => 1,
	
    },
    'IsFormedOf' => {
	to_link => 1, from_link => 1,
	
    },
    'IsFormedInto' => {
	to_link => 1, from_link => 1,
	
    },
    'IsFunctionalIn' => {
	to_link => 1, from_link => 1,
	
    },
    'HasFunctional' => {
	to_link => 1, from_link => 1,
	
    },
    'IsGroupFor' => {
	to_link => 1, from_link => 1,
	
    },
    'IsInGroup' => {
	to_link => 1, from_link => 1,
	
    },
    'IsImplementedBy' => {
	to_link => 1, from_link => 1,
	
    },
    'Implements' => {
	to_link => 1, from_link => 1,
	
    },
    'IsInPair' => {
	to_link => 1, from_link => 1,
	
    },
    'IsPairOf' => {
	to_link => 1, from_link => 1,
	
    },
    'IsInstantiatedBy' => {
	to_link => 1, from_link => 1,
	
    },
    'IsInstanceOf' => {
	to_link => 1, from_link => 1,
	
    },
    'IsLocatedIn' => {
	to_link => 1, from_link => 1,
		    'ordinal' => 1,
		    'begin' => 1,
		    'len' => 1,
		    'dir' => 1,
	
    },
    'IsLocusFor' => {
	to_link => 1, from_link => 1,
		    'ordinal' => 1,
		    'begin' => 1,
		    'len' => 1,
		    'dir' => 1,
	
    },
    'IsModeledBy' => {
	to_link => 1, from_link => 1,
	
    },
    'Models' => {
	to_link => 1, from_link => 1,
	
    },
    'IsOwnerOf' => {
	to_link => 1, from_link => 1,
	
    },
    'IsOwnedBy' => {
	to_link => 1, from_link => 1,
	
    },
    'IsProposedLocationOf' => {
	to_link => 1, from_link => 1,
		    'type' => 1,
	
    },
    'HasProposedLocationIn' => {
	to_link => 1, from_link => 1,
		    'type' => 1,
	
    },
    'IsProteinFor' => {
	to_link => 1, from_link => 1,
	
    },
    'Produces' => {
	to_link => 1, from_link => 1,
	
    },
    'IsRealLocationOf' => {
	to_link => 1, from_link => 1,
		    'type' => 1,
	
    },
    'HasRealLocationIn' => {
	to_link => 1, from_link => 1,
		    'type' => 1,
	
    },
    'IsReferencedBy' => {
	to_link => 1, from_link => 1,
	
    },
    'UsesReference' => {
	to_link => 1, from_link => 1,
	
    },
    'IsRegulatedIn' => {
	to_link => 1, from_link => 1,
	
    },
    'IsRegulatedSetOf' => {
	to_link => 1, from_link => 1,
	
    },
    'IsRelevantFor' => {
	to_link => 1, from_link => 1,
	
    },
    'IsRelevantTo' => {
	to_link => 1, from_link => 1,
	
    },
    'IsRepresentedBy' => {
	to_link => 1, from_link => 1,
	
    },
    'DefinedBy' => {
	to_link => 1, from_link => 1,
	
    },
    'IsRequiredBy' => {
	to_link => 1, from_link => 1,
	
    },
    'Requires' => {
	to_link => 1, from_link => 1,
	
    },
    'IsRoleOf' => {
	to_link => 1, from_link => 1,
	
    },
    'HasRole' => {
	to_link => 1, from_link => 1,
	
    },
    'IsRowOf' => {
	to_link => 1, from_link => 1,
	
    },
    'IsRoleFor' => {
	to_link => 1, from_link => 1,
	
    },
    'IsSequenceOf' => {
	to_link => 1, from_link => 1,
	
    },
    'HasAsSequence' => {
	to_link => 1, from_link => 1,
	
    },
    'IsSubInstanceOf' => {
	to_link => 1, from_link => 1,
	
    },
    'Validates' => {
	to_link => 1, from_link => 1,
	
    },
    'IsSummarizedBy' => {
	to_link => 1, from_link => 1,
		    'position' => 1,
	
    },
    'Summarizes' => {
	to_link => 1, from_link => 1,
		    'position' => 1,
	
    },
    'IsSuperclassOf' => {
	to_link => 1, from_link => 1,
	
    },
    'IsSubclassOf' => {
	to_link => 1, from_link => 1,
	
    },
    'IsTargetOf' => {
	to_link => 1, from_link => 1,
	
    },
    'Targets' => {
	to_link => 1, from_link => 1,
	
    },
    'IsTaxonomyOf' => {
	to_link => 1, from_link => 1,
	
    },
    'IsInTaxa' => {
	to_link => 1, from_link => 1,
	
    },
    'IsTerminusFor' => {
	to_link => 1, from_link => 1,
		    'group_number' => 1,
	
    },
    'HasAsTerminus' => {
	to_link => 1, from_link => 1,
		    'group_number' => 1,
	
    },
    'IsTriggeredBy' => {
	to_link => 1, from_link => 1,
		    'optional' => 1,
		    'type' => 1,
	
    },
    'Triggers' => {
	to_link => 1, from_link => 1,
		    'optional' => 1,
		    'type' => 1,
	
    },
    'IsUsedAs' => {
	to_link => 1, from_link => 1,
	
    },
    'IsUseOf' => {
	to_link => 1, from_link => 1,
	
    },
    'Manages' => {
	to_link => 1, from_link => 1,
	
    },
    'IsManagedBy' => {
	to_link => 1, from_link => 1,
	
    },
    'OperatesIn' => {
	to_link => 1, from_link => 1,
	
    },
    'IsUtilizedIn' => {
	to_link => 1, from_link => 1,
	
    },
    'Overlaps' => {
	to_link => 1, from_link => 1,
	
    },
    'IncludesPartOf' => {
	to_link => 1, from_link => 1,
	
    },
    'ParticipatesAs' => {
	to_link => 1, from_link => 1,
	
    },
    'IsParticipationOf' => {
	to_link => 1, from_link => 1,
	
    },
    'ProducedResultsFor' => {
	to_link => 1, from_link => 1,
	
    },
    'HadResultsProducedBy' => {
	to_link => 1, from_link => 1,
	
    },
    'ProjectsOnto' => {
	to_link => 1, from_link => 1,
		    'gene_context' => 1,
		    'percent_identity' => 1,
		    'score' => 1,
	
    },
    'IsProjectedOnto' => {
	to_link => 1, from_link => 1,
		    'gene_context' => 1,
		    'percent_identity' => 1,
		    'score' => 1,
	
    },
    'Provided' => {
	to_link => 1, from_link => 1,
	
    },
    'WasProvidedBy' => {
	to_link => 1, from_link => 1,
	
    },
    'Shows' => {
	to_link => 1, from_link => 1,
		    'location' => 1,
	
    },
    'IsShownOn' => {
	to_link => 1, from_link => 1,
		    'location' => 1,
	
    },
    'Submitted' => {
	to_link => 1, from_link => 1,
	
    },
    'WasSubmittedBy' => {
	to_link => 1, from_link => 1,
	
    },
    'Uses' => {
	to_link => 1, from_link => 1,
	
    },
    'IsUsedBy' => {
	to_link => 1, from_link => 1,
	
    },

};

our $relationship_field_rels = {
    'AffectsLevelOf' => {
    },
    'IsAffectedIn' => {
    },
    'Aligns' => {
    },
    'IsAlignedBy' => {
    },
    'AssertsFunctionFor' => {
    },
    'HasAssertedFunctionFrom' => {
    },
    'Concerns' => {
    },
    'IsATopicOf' => {
    },
    'Contains' => {
    },
    'IsContainedIn' => {
    },
    'Controls' => {
    },
    'IsControlledUsing' => {
    },
    'Describes' => {
    },
    'IsDescribedBy' => {
    },
    'Displays' => {
    },
    'IsDisplayedOn' => {
    },
    'Encompasses' => {
    },
    'IsEncompassedIn' => {
    },
    'Formulated' => {
    },
    'WasFormulatedBy' => {
    },
    'GeneratedLevelsFor' => {
    },
    'WasGeneratedFrom' => {
    },
    'HasCompoundAliasFrom' => {
    },
    'UsesAliasForCompound' => {
    },
    'HasIndicatedSignalFrom' => {
    },
    'IndicatesSignalFor' => {
    },
    'HasMember' => {
    },
    'IsMemberOf' => {
    },
    'HasParticipant' => {
    },
    'ParticipatesIn' => {
    },
    'HasPresenceOf' => {
    },
    'IsPresentIn' => {
    },
    'HasProteinMember' => {
    },
    'IsProteinMemberOf' => {
    },
    'HasReactionAliasFrom' => {
    },
    'UsesAliasForReaction' => {
    },
    'HasRepresentativeOf' => {
    },
    'IsRepresentedIn' => {
    },
    'HasResultsIn' => {
    },
    'HasResultsFor' => {
    },
    'HasSection' => {
    },
    'IsSectionOf' => {
    },
    'HasStep' => {
    },
    'IsStepOf' => {
    },
    'HasTrait' => {
    },
    'Measures' => {
    },
    'HasUnits' => {
    },
    'IsLocated' => {
    },
    'HasUsage' => {
    },
    'IsUsageOf' => {
    },
    'HasValueFor' => {
    },
    'HasValueIn' => {
    },
    'HasVariationIn' => {
    },
    'IsVariedIn' => {
    },
    'Impacts' => {
    },
    'IsImpactedBy' => {
    },
    'Includes' => {
    },
    'IsIncludedIn' => {
    },
    'IncludesPart' => {
    },
    'IsPartOf' => {
    },
    'IndicatedLevelsFor' => {
    },
    'HasLevelsFrom' => {
    },
    'Involves' => {
    },
    'IsInvolvedIn' => {
    },
    'IsARequirementIn' => {
    },
    'IsARequirementOf' => {
    },
    'IsAnnotatedBy' => {
    },
    'Annotates' => {
    },
    'IsAssayOf' => {
    },
    'IsAssayedBy' => {
    },
    'IsClassFor' => {
    },
    'IsInClass' => {
    },
    'IsCollectionOf' => {
    },
    'IsCollectedInto' => {
    },
    'IsComposedOf' => {
    },
    'IsComponentOf' => {
    },
    'IsComprisedOf' => {
    },
    'Comprises' => {
    },
    'IsConfiguredBy' => {
    },
    'ReflectsStateOf' => {
    },
    'IsConsistentWith' => {
    },
    'IsConsistentTo' => {
    },
    'IsCoregulatedWith' => {
    },
    'HasCoregulationWith' => {
    },
    'IsCoupledTo' => {
    },
    'IsCoupledWith' => {
    },
    'IsDefaultFor' => {
    },
    'RunsByDefaultIn' => {
    },
    'IsDefaultLocationOf' => {
    },
    'HasDefaultLocation' => {
    },
    'IsDeterminedBy' => {
    },
    'Determines' => {
    },
    'IsDividedInto' => {
    },
    'IsDivisionOf' => {
    },
    'IsExemplarOf' => {
    },
    'HasAsExemplar' => {
    },
    'IsFamilyFor' => {
    },
    'DeterminesFunctionOf' => {
    },
    'IsFormedOf' => {
    },
    'IsFormedInto' => {
    },
    'IsFunctionalIn' => {
    },
    'HasFunctional' => {
    },
    'IsGroupFor' => {
    },
    'IsInGroup' => {
    },
    'IsImplementedBy' => {
    },
    'Implements' => {
    },
    'IsInPair' => {
    },
    'IsPairOf' => {
    },
    'IsInstantiatedBy' => {
    },
    'IsInstanceOf' => {
    },
    'IsLocatedIn' => {
    },
    'IsLocusFor' => {
    },
    'IsModeledBy' => {
    },
    'Models' => {
    },
    'IsOwnerOf' => {
    },
    'IsOwnedBy' => {
    },
    'IsProposedLocationOf' => {
    },
    'HasProposedLocationIn' => {
    },
    'IsProteinFor' => {
    },
    'Produces' => {
    },
    'IsRealLocationOf' => {
    },
    'HasRealLocationIn' => {
    },
    'IsReferencedBy' => {
    },
    'UsesReference' => {
    },
    'IsRegulatedIn' => {
    },
    'IsRegulatedSetOf' => {
    },
    'IsRelevantFor' => {
    },
    'IsRelevantTo' => {
    },
    'IsRepresentedBy' => {
    },
    'DefinedBy' => {
    },
    'IsRequiredBy' => {
    },
    'Requires' => {
    },
    'IsRoleOf' => {
    },
    'HasRole' => {
    },
    'IsRowOf' => {
    },
    'IsRoleFor' => {
    },
    'IsSequenceOf' => {
    },
    'HasAsSequence' => {
    },
    'IsSubInstanceOf' => {
    },
    'Validates' => {
    },
    'IsSummarizedBy' => {
    },
    'Summarizes' => {
    },
    'IsSuperclassOf' => {
    },
    'IsSubclassOf' => {
    },
    'IsTargetOf' => {
    },
    'Targets' => {
    },
    'IsTaxonomyOf' => {
    },
    'IsInTaxa' => {
    },
    'IsTerminusFor' => {
    },
    'HasAsTerminus' => {
    },
    'IsTriggeredBy' => {
    },
    'Triggers' => {
    },
    'IsUsedAs' => {
    },
    'IsUseOf' => {
    },
    'Manages' => {
    },
    'IsManagedBy' => {
    },
    'OperatesIn' => {
    },
    'IsUtilizedIn' => {
    },
    'Overlaps' => {
    },
    'IncludesPartOf' => {
    },
    'ParticipatesAs' => {
    },
    'IsParticipationOf' => {
    },
    'ProducedResultsFor' => {
    },
    'HadResultsProducedBy' => {
    },
    'ProjectsOnto' => {
    },
    'IsProjectedOnto' => {
    },
    'Provided' => {
    },
    'WasProvidedBy' => {
    },
    'Shows' => {
    },
    'IsShownOn' => {
    },
    'Submitted' => {
    },
    'WasSubmittedBy' => {
    },
    'Uses' => {
    },
    'IsUsedBy' => {
    },

};

our $relationship_entities = {
    'AffectsLevelOf' => [ 'Experiment', 'AtomicRegulon' ],
    'IsAffectedIn' => [ 'AtomicRegulon', 'Experiment' ],
    'Aligns' => [ 'AlignmentTree', 'ProteinSequence' ],
    'IsAlignedBy' => [ 'ProteinSequence', 'AlignmentTree' ],
    'AssertsFunctionFor' => [ 'Source', 'ProteinSequence' ],
    'HasAssertedFunctionFrom' => [ 'ProteinSequence', 'Source' ],
    'Concerns' => [ 'Publication', 'ProteinSequence' ],
    'IsATopicOf' => [ 'ProteinSequence', 'Publication' ],
    'Contains' => [ 'SSCell', 'Feature' ],
    'IsContainedIn' => [ 'Feature', 'SSCell' ],
    'Controls' => [ 'Feature', 'CoregulatedSet' ],
    'IsControlledUsing' => [ 'CoregulatedSet', 'Feature' ],
    'Describes' => [ 'Subsystem', 'Variant' ],
    'IsDescribedBy' => [ 'Variant', 'Subsystem' ],
    'Displays' => [ 'Diagram', 'Reaction' ],
    'IsDisplayedOn' => [ 'Reaction', 'Diagram' ],
    'Encompasses' => [ 'Feature', 'Feature' ],
    'IsEncompassedIn' => [ 'Feature', 'Feature' ],
    'Formulated' => [ 'Source', 'CoregulatedSet' ],
    'WasFormulatedBy' => [ 'CoregulatedSet', 'Source' ],
    'GeneratedLevelsFor' => [ 'ProbeSet', 'AtomicRegulon' ],
    'WasGeneratedFrom' => [ 'AtomicRegulon', 'ProbeSet' ],
    'HasCompoundAliasFrom' => [ 'Source', 'Compound' ],
    'UsesAliasForCompound' => [ 'Compound', 'Source' ],
    'HasIndicatedSignalFrom' => [ 'Feature', 'Experiment' ],
    'IndicatesSignalFor' => [ 'Experiment', 'Feature' ],
    'HasMember' => [ 'Family', 'Feature' ],
    'IsMemberOf' => [ 'Feature', 'Family' ],
    'HasParticipant' => [ 'Scenario', 'Reaction' ],
    'ParticipatesIn' => [ 'Reaction', 'Scenario' ],
    'HasPresenceOf' => [ 'Media', 'Compound' ],
    'IsPresentIn' => [ 'Compound', 'Media' ],
    'HasProteinMember' => [ 'Family', 'ProteinSequence' ],
    'IsProteinMemberOf' => [ 'ProteinSequence', 'Family' ],
    'HasReactionAliasFrom' => [ 'Source', 'Reaction' ],
    'UsesAliasForReaction' => [ 'Reaction', 'Source' ],
    'HasRepresentativeOf' => [ 'Genome', 'Family' ],
    'IsRepresentedIn' => [ 'Family', 'Genome' ],
    'HasResultsIn' => [ 'ProbeSet', 'Experiment' ],
    'HasResultsFor' => [ 'Experiment', 'ProbeSet' ],
    'HasSection' => [ 'ContigSequence', 'ContigChunk' ],
    'IsSectionOf' => [ 'ContigChunk', 'ContigSequence' ],
    'HasStep' => [ 'Complex', 'ReactionRule' ],
    'IsStepOf' => [ 'ReactionRule', 'Complex' ],
    'HasTrait' => [ 'ObservationalUnit', 'Trait' ],
    'Measures' => [ 'Trait', 'ObservationalUnit' ],
    'HasUnits' => [ 'Locality', 'ObservationalUnit' ],
    'IsLocated' => [ 'ObservationalUnit', 'Locality' ],
    'HasUsage' => [ 'Compound', 'BiomassCompound' ],
    'IsUsageOf' => [ 'BiomassCompound', 'Compound' ],
    'HasValueFor' => [ 'Experiment', 'Attribute' ],
    'HasValueIn' => [ 'Attribute', 'Experiment' ],
    'HasVariationIn' => [ 'Contig', 'ObservationalUnit' ],
    'IsVariedIn' => [ 'ObservationalUnit', 'Contig' ],
    'Impacts' => [ 'Trait', 'Contig' ],
    'IsImpactedBy' => [ 'Contig', 'Trait' ],
    'Includes' => [ 'Subsystem', 'Role' ],
    'IsIncludedIn' => [ 'Role', 'Subsystem' ],
    'IncludesPart' => [ 'StudyExperiment', 'ObservationalUnit' ],
    'IsPartOf' => [ 'ObservationalUnit', 'StudyExperiment' ],
    'IndicatedLevelsFor' => [ 'ProbeSet', 'Feature' ],
    'HasLevelsFrom' => [ 'Feature', 'ProbeSet' ],
    'Involves' => [ 'Reaction', 'Reagent' ],
    'IsInvolvedIn' => [ 'Reagent', 'Reaction' ],
    'IsARequirementIn' => [ 'Model', 'Requirement' ],
    'IsARequirementOf' => [ 'Requirement', 'Model' ],
    'IsAnnotatedBy' => [ 'Feature', 'Annotation' ],
    'Annotates' => [ 'Annotation', 'Feature' ],
    'IsAssayOf' => [ 'Assay', 'StudyExperiment' ],
    'IsAssayedBy' => [ 'StudyExperiment', 'Assay' ],
    'IsClassFor' => [ 'SubsystemClass', 'Subsystem' ],
    'IsInClass' => [ 'Subsystem', 'SubsystemClass' ],
    'IsCollectionOf' => [ 'OTU', 'Genome' ],
    'IsCollectedInto' => [ 'Genome', 'OTU' ],
    'IsComposedOf' => [ 'Genome', 'Contig' ],
    'IsComponentOf' => [ 'Contig', 'Genome' ],
    'IsComprisedOf' => [ 'Biomass', 'BiomassCompound' ],
    'Comprises' => [ 'BiomassCompound', 'Biomass' ],
    'IsConfiguredBy' => [ 'Genome', 'AtomicRegulon' ],
    'ReflectsStateOf' => [ 'AtomicRegulon', 'Genome' ],
    'IsConsistentWith' => [ 'EcNumber', 'Role' ],
    'IsConsistentTo' => [ 'Role', 'EcNumber' ],
    'IsCoregulatedWith' => [ 'Feature', 'Feature' ],
    'HasCoregulationWith' => [ 'Feature', 'Feature' ],
    'IsCoupledTo' => [ 'Family', 'Family' ],
    'IsCoupledWith' => [ 'Family', 'Family' ],
    'IsDefaultFor' => [ 'Compartment', 'Reaction' ],
    'RunsByDefaultIn' => [ 'Reaction', 'Compartment' ],
    'IsDefaultLocationOf' => [ 'Compartment', 'Reagent' ],
    'HasDefaultLocation' => [ 'Reagent', 'Compartment' ],
    'IsDeterminedBy' => [ 'PairSet', 'Pairing' ],
    'Determines' => [ 'Pairing', 'PairSet' ],
    'IsDividedInto' => [ 'Model', 'ModelCompartment' ],
    'IsDivisionOf' => [ 'ModelCompartment', 'Model' ],
    'IsExemplarOf' => [ 'Feature', 'Role' ],
    'HasAsExemplar' => [ 'Role', 'Feature' ],
    'IsFamilyFor' => [ 'Family', 'Role' ],
    'DeterminesFunctionOf' => [ 'Role', 'Family' ],
    'IsFormedOf' => [ 'AtomicRegulon', 'Feature' ],
    'IsFormedInto' => [ 'Feature', 'AtomicRegulon' ],
    'IsFunctionalIn' => [ 'Role', 'Feature' ],
    'HasFunctional' => [ 'Feature', 'Role' ],
    'IsGroupFor' => [ 'TaxonomicGrouping', 'TaxonomicGrouping' ],
    'IsInGroup' => [ 'TaxonomicGrouping', 'TaxonomicGrouping' ],
    'IsImplementedBy' => [ 'Variant', 'SSRow' ],
    'Implements' => [ 'SSRow', 'Variant' ],
    'IsInPair' => [ 'Feature', 'Pairing' ],
    'IsPairOf' => [ 'Pairing', 'Feature' ],
    'IsInstantiatedBy' => [ 'Compartment', 'ModelCompartment' ],
    'IsInstanceOf' => [ 'ModelCompartment', 'Compartment' ],
    'IsLocatedIn' => [ 'Feature', 'Contig' ],
    'IsLocusFor' => [ 'Contig', 'Feature' ],
    'IsModeledBy' => [ 'Genome', 'Model' ],
    'Models' => [ 'Model', 'Genome' ],
    'IsOwnerOf' => [ 'Genome', 'Feature' ],
    'IsOwnedBy' => [ 'Feature', 'Genome' ],
    'IsProposedLocationOf' => [ 'Compartment', 'ReactionRule' ],
    'HasProposedLocationIn' => [ 'ReactionRule', 'Compartment' ],
    'IsProteinFor' => [ 'ProteinSequence', 'Feature' ],
    'Produces' => [ 'Feature', 'ProteinSequence' ],
    'IsRealLocationOf' => [ 'ModelCompartment', 'Requirement' ],
    'HasRealLocationIn' => [ 'Requirement', 'ModelCompartment' ],
    'IsReferencedBy' => [ 'Genome', 'ObservationalUnit' ],
    'UsesReference' => [ 'ObservationalUnit', 'Genome' ],
    'IsRegulatedIn' => [ 'Feature', 'CoregulatedSet' ],
    'IsRegulatedSetOf' => [ 'CoregulatedSet', 'Feature' ],
    'IsRelevantFor' => [ 'Diagram', 'Subsystem' ],
    'IsRelevantTo' => [ 'Subsystem', 'Diagram' ],
    'IsRepresentedBy' => [ 'TaxonomicGrouping', 'ObservationalUnit' ],
    'DefinedBy' => [ 'ObservationalUnit', 'TaxonomicGrouping' ],
    'IsRequiredBy' => [ 'Reaction', 'Requirement' ],
    'Requires' => [ 'Requirement', 'Reaction' ],
    'IsRoleOf' => [ 'Role', 'SSCell' ],
    'HasRole' => [ 'SSCell', 'Role' ],
    'IsRowOf' => [ 'SSRow', 'SSCell' ],
    'IsRoleFor' => [ 'SSCell', 'SSRow' ],
    'IsSequenceOf' => [ 'ContigSequence', 'Contig' ],
    'HasAsSequence' => [ 'Contig', 'ContigSequence' ],
    'IsSubInstanceOf' => [ 'Subsystem', 'Scenario' ],
    'Validates' => [ 'Scenario', 'Subsystem' ],
    'IsSummarizedBy' => [ 'Contig', 'AlleleFrequency' ],
    'Summarizes' => [ 'AlleleFrequency', 'Contig' ],
    'IsSuperclassOf' => [ 'SubsystemClass', 'SubsystemClass' ],
    'IsSubclassOf' => [ 'SubsystemClass', 'SubsystemClass' ],
    'IsTargetOf' => [ 'ModelCompartment', 'BiomassCompound' ],
    'Targets' => [ 'BiomassCompound', 'ModelCompartment' ],
    'IsTaxonomyOf' => [ 'TaxonomicGrouping', 'Genome' ],
    'IsInTaxa' => [ 'Genome', 'TaxonomicGrouping' ],
    'IsTerminusFor' => [ 'Compound', 'Scenario' ],
    'HasAsTerminus' => [ 'Scenario', 'Compound' ],
    'IsTriggeredBy' => [ 'Complex', 'Role' ],
    'Triggers' => [ 'Role', 'Complex' ],
    'IsUsedAs' => [ 'Reaction', 'ReactionRule' ],
    'IsUseOf' => [ 'ReactionRule', 'Reaction' ],
    'Manages' => [ 'Model', 'Biomass' ],
    'IsManagedBy' => [ 'Biomass', 'Model' ],
    'OperatesIn' => [ 'Experiment', 'Media' ],
    'IsUtilizedIn' => [ 'Media', 'Experiment' ],
    'Overlaps' => [ 'Scenario', 'Diagram' ],
    'IncludesPartOf' => [ 'Diagram', 'Scenario' ],
    'ParticipatesAs' => [ 'Compound', 'Reagent' ],
    'IsParticipationOf' => [ 'Reagent', 'Compound' ],
    'ProducedResultsFor' => [ 'ProbeSet', 'Genome' ],
    'HadResultsProducedBy' => [ 'Genome', 'ProbeSet' ],
    'ProjectsOnto' => [ 'ProteinSequence', 'ProteinSequence' ],
    'IsProjectedOnto' => [ 'ProteinSequence', 'ProteinSequence' ],
    'Provided' => [ 'Source', 'Subsystem' ],
    'WasProvidedBy' => [ 'Subsystem', 'Source' ],
    'Shows' => [ 'Diagram', 'Compound' ],
    'IsShownOn' => [ 'Compound', 'Diagram' ],
    'Submitted' => [ 'Source', 'Genome' ],
    'WasSubmittedBy' => [ 'Genome', 'Source' ],
    'Uses' => [ 'Genome', 'SSRow' ],
    'IsUsedBy' => [ 'SSRow', 'Genome' ],

};

#sub _init_instance
#{
#    my($self) = @_;
#    $self->{db} = CDMI->new(dbhost => 'seed-db-read', sock => '', DBD => '/home/parrello/FIGdisk/dist/releases/current/WinBuild/KSaplingDBD.xml');
#}

sub _validate_fields_for_entity
{
    my($self, $tbl, $fields, $ensure_id) = @_;

    my $valid_fields = $entity_field_defs->{$tbl};

    my $have_id;

    my $cdmi = $self->{db};
    my $q = $cdmi->{_dbh}->quote;

    my @rel_fields;
    my @qfields;
    my @sfields;
    my @bad_fields;
    for my $field (@$fields)
    {
	$field =~ s/-/_/g;
	if (!$valid_fields->{$field})
	{
	    push(@bad_fields, $field);
	    next;
	}
	if (my $rel = $entity_field_rels->{$tbl}->{$field})
	{
	    push(@rel_fields, [$field, $rel]);
	}
	else
	{
	    push(@sfields, $field);
	    my $qfield = $q . $field . $q;
	    $have_id = 1 if $field eq 'id';
	    push(@qfields, $qfield);
	}
    }

    if (@bad_fields)
    {
	die "The following fields are invalid in entity $tbl: @bad_fields";
    }

    if (!$have_id && ($ensure_id || @rel_fields))
    {
	unshift(@sfields, 'id');
	unshift(@qfields, $q . 'id' . $q);
    }

    return(\@sfields, \@qfields, \@rel_fields);
}

sub _validate_fields_for_relationship
{
    my($self, $tbl, $fields, $link_field) = @_;

    my $valid_fields = $relationship_field_defs->{$tbl};

    my $cdmi = $self->{db};
    my $q = $cdmi->{_dbh}->quote;

    my $have_id = 0;
    my @qfields;
    my @sfields;
    my @bad_fields;
    for my $field (@$fields)
    {
	$field =~ s/-/_/g;
	if (!$valid_fields->{$field})
	{
	    push(@bad_fields, $field);
	    next;
	}

	$have_id = 1 if $field eq $link_field;
	push(@sfields, $field);
	my $qfield = $q . $field . $q;
	push(@qfields, $qfield);
    }

    if (!$have_id)
    {
	unshift(@sfields, $link_field);
	unshift(@qfields, $q . $link_field . $q);
    }

    if (@bad_fields)
    {
	die "The following fields are invalid in relationship $tbl: @bad_fields";
    }

    return(\@sfields, \@qfields);
}

sub _query_entity
{
    my($self, $ctx, $tbl, $qry, $fields) = @_;

    my($sfields, $qfields, $rel_fields) = $self->_validate_fields_for_entity($tbl, $fields, 1);
    
    my @filter;
    my @filter_params;

    my $valid_fields = $entity_field_defs->{$tbl};
    my $field_rels = $entity_field_rels->{$tbl};
    my %valid_ops = map { $_ => 1 } ('LIKE', '<', '>', '=', '>=', '<=');
    my @bad_q;
    for my $q (@$qry)
    {
	my($field, $op, $value) = @$q;
	if (!$valid_fields->{$field})
	{
	    push(@bad_q, "Field $field does not exist in $tbl");
	    next;
	}
	if ($field_rels->{$field})
	{
	    push(@bad_q, "Field $field is stored in a secondary relation; this is not yet supported for queries.");
	    next;
	}
	if (!$valid_ops{uc($op)})
	{
	    push(@bad_q, "Operator $op is not allowed");
	    next;
	}
	push(@filter, "$field $op ?");
	push(@filter_params, $value);
    }

    if (@bad_q)
    {
	die "Errors found in query:\n" . join("\n", @bad_q);
    }

    my $cdmi = $self->{db};
    my $q = $cdmi->{_dbh}->quote;

    my $qstr = join(", ", @$qfields);

    my $filter = join(" AND ", map { "(" . $_ . ")" } @filter);
    my $qry = "SELECT $qstr FROM $q$tbl$q WHERE $filter";

    my $attrs = {};
    my $dbk = $cdmi->{_dbh};
    if ($dbk->dbms eq 'mysql')
    {
	$attrs->{mysql_use_result} = 1;
    }

    my $sth = $dbk->{_dbh}->prepare($qry, $attrs);
    
    # print STDERR "$qry\n";
    $sth->execute(@filter_params);
    my $out = $sth->fetchall_hashref('id');

    my @ids = keys %$out;

    if (@ids)
    {
	my $rel_filter = "id IN (" . join(", ", map { "?" } @ids) . ")";
	#
	# Now query for the fields that are in separate relations.
	#
	for my $ent (@$rel_fields)
	{
	    my($field, $rel) = @$ent;
	    
	    my $sth = $dbk->{_dbh}->prepare(qq(SELECT id, $field FROM $rel WHERE $rel_filter));
	    $sth->execute(@ids);
	    while (my $row = $sth->fetchrow_arrayref())
	    {
		my($id, $val) = @$row;
		push(@{$out->{$id}->{$field}}, $val);
	    }
	}
    }
    return $out;
}    

sub _get_entity
{
    my($self, $ctx, $tbl, $ids, $fields) = @_;

    my($sfields, $qfields, $rel_fields) = $self->_validate_fields_for_entity($tbl, $fields, 1);
    
    my $filter = "id IN (" . join(", ", map { '?' } @$ids) . ")";

    my $cdmi = $self->{db};
    my $q = $cdmi->{_dbh}->quote;

    my $qstr = join(", ", @$qfields);
    my $qry = "SELECT $qstr FROM $q$tbl$q WHERE $filter";

    my $attrs = {};
    my $dbk = $cdmi->{_dbh};
    if ($dbk->dbms eq 'mysql')
    {
	$attrs->{mysql_use_result} = 1;
    }

    my $sth = $dbk->{_dbh}->prepare($qry, $attrs);
    
    # print STDERR "$qry\n";
    $sth->execute(@$ids);
    my $out = $sth->fetchall_hashref('id');

    #
    # Now query for the fields that are in separate relations.
    #
    for my $ent (@$rel_fields)
    {
	my($field, $rel) = @$ent;
	my $sth = $dbk->{_dbh}->prepare(qq(SELECT id, $field FROM $rel WHERE $filter));
	$sth->execute(@$ids);
	while (my $row = $sth->fetchrow_arrayref())
	{
	    my($id, $val) = @$row;
	    push(@{$out->{$id}->{$field}}, $val);
	}
    }
    return $out;
}    

# sub _add_entities
# {
#     my($self, $ctx, $tbl, $fields, $data) = @_;

#     my($sfields, $qfields, $rel_fields) = $self->_validate_fields_for_entity($tbl, $fields, 1);
    
#     my $cdmi = $self->{db};
#     my $q = $cdmi->{_dbh}->quote;

#     my $qstr = join(", ", @$qfields);
#     my $qry = "SELECT $qstr FROM $q$tbl$q WHERE $filter";

#     my $attrs = {};
#     my $dbk = $cdmi->{_dbh};
#     if ($dbk->dbms eq 'mysql')
#     {
# 	$attrs->{mysql_use_result} = 1;
#     }
#     XXXXXXX

#     my $sth = $dbk->{_dbh}->prepare($qry, $attrs);
    
#     # print STDERR "$qry\n";
#     $sth->execute(@$ids);
#     my $out = $sth->fetchall_hashref('id');

#     #
#     # Now query for the fields that are in separate relations.
#     #
#     for my $ent (@$rel_fields)
#     {
# 	my($field, $rel) = @$ent;
# 	my $sth = $dbk->{_dbh}->prepare(qq(SELECT id, $field FROM $rel WHERE $filter));
# 	$sth->execute(@$ids);
# 	while (my $row = $sth->fetchrow_arrayref())
# 	{
# 	    my($id, $val) = @$row;
# 	    push(@{$out->{$id}->{$field}}, $val);
# 	}
#     }
#     return $out;
# }    

sub _get_relationship
{
    my($self, $ctx, $relationship, $table, $is_converse, $ids, $from_fields, $rel_fields, $to_fields) = @_;

    my($from_tbl, $to_tbl) = @{$relationship_entities->{$relationship}};
    if (!$from_tbl)
    {
	die "Unknown relationship $relationship";
    }

    my %link_name_map;
    my($from_link, $to_link);
    if ($is_converse)
    {
	($from_link, $to_link) = qw(to_link from_link);
	%link_name_map = ( from_link => 'to_link', to_link => 'from_link');
    }
    else
    {
	($from_link, $to_link) = qw(from_link to_link);
	%link_name_map = ( from_link => 'from_link', to_link => 'to_link');
    }
    for my $f (@$rel_fields)
    {
	if (!exists $link_name_map{$f})
	{
	    $link_name_map{$f} = $f;
	}
    }

    my $cdmi = $self->{db};
    my $q = $cdmi->{_dbh}->quote;

    my($from_sfields, $from_qfields, $from_relfields) = $self->_validate_fields_for_entity($from_tbl, $from_fields, 0);
    my($to_sfields, $to_qfields, $to_relfields) = $self->_validate_fields_for_entity($to_tbl, $to_fields, 0);

    my @trans_rel_fields = map { $link_name_map{$_} } @$rel_fields;
    my($rel_sfields, $rel_qfields) = $self->_validate_fields_for_relationship($relationship, \@trans_rel_fields, $from_link);
    
    my $filter = "$from_link IN (" . join(", ", map { '?' } @$ids) . ")";

    my $from = "$q$table$q r ";
    if (@$from_qfields)
    {
	$from .= "JOIN $q$from_tbl$q f ON f.id = r.$from_link ";
    }
    if (@$to_qfields)
    {
	$from .= "JOIN $q$to_tbl$q t ON t.id = r.$to_link ";
    }

    my $qstr = join(", ",
		    (map { "f.$_" } @$from_qfields),
		    (map { "t.$_" }  @$to_qfields),
		    (map { "r.$_" } @$rel_qfields));

    my $qry = "SELECT $qstr FROM $from WHERE $filter";

    my $attrs = {};
    my $dbk = $cdmi->{_dbh};
    if ($dbk->dbms eq 'mysql')
    {
	$attrs->{mysql_use_result} = 1;
    }

    my $sth = $dbk->{_dbh}->prepare($qry, $attrs);
    
    # print STDERR "$qry\n";
    $sth->execute(@$ids);
    my $res = $sth->fetchall_arrayref();

    my $out = [];

    my(%from_keys_for_rel, %to_keys_for_rel);
    for my $ent (@$res)
    {
	my($fout, $rout, $tout) = ({}, {}, {});
	for my $fld (@$from_sfields)
	{
	    my $v = shift @$ent;
	    $fout->{$fld} = $v;
	}
	for my $fld (@$to_sfields)
	{
	    my $v = shift @$ent;
	    $tout->{$fld} = $v;
	}
	for my $fld (@$rel_sfields)
	{
	    my $v = shift @$ent;
	    $rout->{$link_name_map{$fld}} = $v;
	}
	my $row = [$fout, $rout, $tout];

	if (@$from_relfields)
	{
	    push(@{$from_keys_for_rel{$fout->{id}}}, $row);
	}

	if (@$to_relfields)
	{
	    push(@{$to_keys_for_rel{$tout->{id}}}, $row);
	}

	push(@$out, $row);
    }

    if (@$from_relfields)
    {
	my %ids = keys %from_keys_for_rel;
	my @ids = keys %ids;

	my $filter = "id IN (" . join(", ", map { '?' } @ids) . ")";

	for my $ent (@$from_relfields)
	{
	    my($field, $rel) = @$ent;
	    
	    my $sth = $dbk->{_dbh}->prepare(qq(SELECT id, $field FROM $rel WHERE $filter));
	    $sth->execute(@ids);
	    while (my $row = $sth->fetchrow_arrayref())
	    {
		my($id, $val) = @$row;

		for my $row (@{$from_keys_for_rel{$id}})
		{
		    push(@{$row->[0]->{$field}}, $val);
		}
	    }
	}
    }

    if (@$to_relfields)
    {
	my %ids = keys %to_keys_for_rel;
	my @ids = keys %ids;

	my $filter = "id IN (" . join(", ", map { '?' } @ids) . ")";

	for my $ent (@$to_relfields)
	{
	    my($field, $rel) = @$ent;
	    
	    my $sth = $dbk->{_dbh}->prepare(qq(SELECT id, $field FROM $rel WHERE $filter));
	    $sth->execute(@ids);
	    while (my $row = $sth->fetchrow_arrayref())
	    {
		my($id, $val) = @$row;

		for my $row (@{$to_keys_for_rel{$id}})
		{
		    push(@{$row->[2]->{$field}}, $val);
		}
	    }
	}
    }


    return $out;
}    

sub _all_entities
{
    my($self, $ctx, $tbl, $start, $count, $fields) = @_;

    my($sfields, $qfields, $rel_fields) = $self->_validate_fields_for_entity($tbl, $fields, 1);

    my $cdmi = $self->{db};
    my $q = $cdmi->{_dbh}->quote;

    my $qstr = join(", ", @$qfields);

    my $attrs = {};
    my $dbk = $cdmi->{_dbh};
    my $limit;
    
    if ($dbk->dbms eq 'mysql')
    {
	$attrs->{mysql_use_result} = 1;
	$limit = "LIMIT $start, $count";
    }
    elsif ($dbk->dbms eq 'Pg')
    {
	$limit = "ORDER BY id LIMIT $count OFFSET $start";
    }

    my $qry = "SELECT $qstr FROM $q$tbl$q $limit";

    my $sth = $dbk->{_dbh}->prepare($qry, $attrs);
    
    # print STDERR "$qry\n";
    $sth->execute();
    my $out = $sth->fetchall_hashref('id');

    #
    # Now query for the fields that are in separate relations.
    #
    my @ids = keys %$out;
    if (@ids)
    {
	my $filter = "id IN (" . join(", ", map { '?' } @ids) . ")";
	
	for my $ent (@$rel_fields)
	{
	    my($field, $rel) = @$ent;
	    
	    my $sth = $dbk->{_dbh}->prepare(qq(SELECT id, $field FROM $rel WHERE $filter));
	    $sth->execute(@ids);
	    while (my $row = $sth->fetchrow_arrayref())
	    {
		my($id, $val) = @$row;
		push(@{$out->{$id}->{$field}}, $val);
	    }
	}
    }

    return $out;
}    

#END_HEADER

sub new
{
    my($class, @args) = @_;
    my $self = {
    };
    bless $self, $class;
    #BEGIN_CONSTRUCTOR

    my($cdmi) = @args;
    if (! $cdmi) {
	$cdmi = Bio::KBase::CDMI::CDMI->new();
    }
    $self->{db} = $cdmi;

    #END_CONSTRUCTOR

    if ($self->can('_init_instance'))
    {
	$self->_init_instance();
    }
    return $self;
}

=head1 METHODS



=head2 get_entity_AlignmentTree

  $return = $obj->get_entity_AlignmentTree($ids, $fields)

=over 4

=item Parameter and return types

=begin html

<pre>
$ids is a reference to a list where each element is a string
$fields is a reference to a list where each element is a string
$return is a reference to a hash where the key is a string and the value is a fields_AlignmentTree
fields_AlignmentTree is a reference to a hash where the following keys are defined:
	id has a value which is a string
	alignment_method has a value which is a string
	alignment_parameters has a value which is a string
	alignment_properties has a value which is a string
	tree_method has a value which is a string
	tree_parameters has a value which is a string
	tree_properties has a value which is a string

</pre>

=end html

=begin text

$ids is a reference to a list where each element is a string
$fields is a reference to a list where each element is a string
$return is a reference to a hash where the key is a string and the value is a fields_AlignmentTree
fields_AlignmentTree is a reference to a hash where the following keys are defined:
	id has a value which is a string
	alignment_method has a value which is a string
	alignment_parameters has a value which is a string
	alignment_properties has a value which is a string
	tree_method has a value which is a string
	tree_parameters has a value which is a string
	tree_properties has a value which is a string


=end text



=item Description

An alignment arranges a group of protein sequences so that they
match. Each alignment is associated with a phylogenetic tree that
describes how the sequences developed and their evolutionary distance.
The actual tree and alignment FASTA are stored in separate flat files.
The Kbase will maintain a set of alignments and associated
trees.  The majority
of these will be based on protein sequences.  We will not have a comprehensive set
but we will have tens of thousands of such alignments, and we view them as an
imporant resource to support annotation.
The alignments/trees will include the tools and parameters used to construct
them.
Access to the underlying sequences and trees in a form convenient to existing
tools will be supported.

It has the following fields:

=over 4


=item alignment_method

The name of the program used to produce the alignment.


=item alignment_parameters

The parameters given to the program when producing the alignment.


=item alignment_properties

A colon-delimited string of key-value pairs containing additional
properties of the alignment.


=item tree_method

The name of the program used to produce the tree.


=item tree_parameters

The parameters given to the program when producing the tree.


=item tree_properties

A colon-delimited string of key-value pairs containing additional
properties of the tree.



=back

=back

=cut

sub get_entity_AlignmentTree
{
    my $self = shift;
    my($ids, $fields) = @_;

    my @_bad_arguments;
    (ref($ids) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"ids\" (value was \"$ids\")");
    (ref($fields) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"fields\" (value was \"$fields\")");
    if (@_bad_arguments) {
	my $msg = "Invalid arguments passed to get_entity_AlignmentTree:\n" . join("", map { "\t$_\n" } @_bad_arguments);
	Bio::KBase::Exceptions::ArgumentValidationError->throw(error => $msg,
							       method_name => 'get_entity_AlignmentTree');
    }

    my $ctx = $Bio::KBase::CDMI::Service::CallContext;
    my($return);
    #BEGIN get_entity_AlignmentTree

    $return = $self->_get_entity($ctx, 'AlignmentTree', $ids, $fields);

    #END get_entity_AlignmentTree
    my @_bad_returns;
    (ref($return) eq 'HASH') or push(@_bad_returns, "Invalid type for return variable \"return\" (value was \"$return\")");
    if (@_bad_returns) {
	my $msg = "Invalid returns passed to get_entity_AlignmentTree:\n" . join("", map { "\t$_\n" } @_bad_returns);
	Bio::KBase::Exceptions::ArgumentValidationError->throw(error => $msg,
							       method_name => 'get_entity_AlignmentTree');
    }
    return($return);
}




=head2 query_entity_AlignmentTree

  $return = $obj->query_entity_AlignmentTree($qry, $fields)

=over 4

=item Parameter and return types

=begin html

<pre>
$qry is a reference to a list where each element is a reference to a list containing 3 items:
	0: a string
	1: a string
	2: a string
$fields is a reference to a list where each element is a string
$return is a reference to a hash where the key is a string and the value is a fields_AlignmentTree
fields_AlignmentTree is a reference to a hash where the following keys are defined:
	id has a value which is a string
	alignment_method has a value which is a string
	alignment_parameters has a value which is a string
	alignment_properties has a value which is a string
	tree_method has a value which is a string
	tree_parameters has a value which is a string
	tree_properties has a value which is a string

</pre>

=end html

=begin text

$qry is a reference to a list where each element is a reference to a list containing 3 items:
	0: a string
	1: a string
	2: a string
$fields is a reference to a list where each element is a string
$return is a reference to a hash where the key is a string and the value is a fields_AlignmentTree
fields_AlignmentTree is a reference to a hash where the following keys are defined:
	id has a value which is a string
	alignment_method has a value which is a string
	alignment_parameters has a value which is a string
	alignment_properties has a value which is a string
	tree_method has a value which is a string
	tree_parameters has a value which is a string
	tree_properties has a value which is a string


=end text



=item Description



=back

=cut

sub query_entity_AlignmentTree
{
    my $self = shift;
    my($qry, $fields) = @_;

    my @_bad_arguments;
    (ref($qry) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"qry\" (value was \"$qry\")");
    (ref($fields) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"fields\" (value was \"$fields\")");
    if (@_bad_arguments) {
	my $msg = "Invalid arguments passed to query_entity_AlignmentTree:\n" . join("", map { "\t$_\n" } @_bad_arguments);
	Bio::KBase::Exceptions::ArgumentValidationError->throw(error => $msg,
							       method_name => 'query_entity_AlignmentTree');
    }

    my $ctx = $Bio::KBase::CDMI::Service::CallContext;
    my($return);
    #BEGIN query_entity_AlignmentTree

    $return = $self->_query_entity($ctx, 'AlignmentTree', $qry, $fields);

    #END query_entity_AlignmentTree
    my @_bad_returns;
    (ref($return) eq 'HASH') or push(@_bad_returns, "Invalid type for return variable \"return\" (value was \"$return\")");
    if (@_bad_returns) {
	my $msg = "Invalid returns passed to query_entity_AlignmentTree:\n" . join("", map { "\t$_\n" } @_bad_returns);
	Bio::KBase::Exceptions::ArgumentValidationError->throw(error => $msg,
							       method_name => 'query_entity_AlignmentTree');
    }
    return($return);
}




=head2 all_entities_AlignmentTree

  $return = $obj->all_entities_AlignmentTree($start, $count, $fields)

=over 4

=item Parameter and return types

=begin html

<pre>
$start is an int
$count is an int
$fields is a reference to a list where each element is a string
$return is a reference to a hash where the key is a string and the value is a fields_AlignmentTree
fields_AlignmentTree is a reference to a hash where the following keys are defined:
	id has a value which is a string
	alignment_method has a value which is a string
	alignment_parameters has a value which is a string
	alignment_properties has a value which is a string
	tree_method has a value which is a string
	tree_parameters has a value which is a string
	tree_properties has a value which is a string

</pre>

=end html

=begin text

$start is an int
$count is an int
$fields is a reference to a list where each element is a string
$return is a reference to a hash where the key is a string and the value is a fields_AlignmentTree
fields_AlignmentTree is a reference to a hash where the following keys are defined:
	id has a value which is a string
	alignment_method has a value which is a string
	alignment_parameters has a value which is a string
	alignment_properties has a value which is a string
	tree_method has a value which is a string
	tree_parameters has a value which is a string
	tree_properties has a value which is a string


=end text



=item Description



=back

=cut

sub all_entities_AlignmentTree
{
    my $self = shift;
    my($start, $count, $fields) = @_;

    my @_bad_arguments;
    (!ref($start)) or push(@_bad_arguments, "Invalid type for argument \"start\" (value was \"$start\")");
    (!ref($count)) or push(@_bad_arguments, "Invalid type for argument \"count\" (value was \"$count\")");
    (ref($fields) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"fields\" (value was \"$fields\")");
    if (@_bad_arguments) {
	my $msg = "Invalid arguments passed to all_entities_AlignmentTree:\n" . join("", map { "\t$_\n" } @_bad_arguments);
	Bio::KBase::Exceptions::ArgumentValidationError->throw(error => $msg,
							       method_name => 'all_entities_AlignmentTree');
    }

    my $ctx = $Bio::KBase::CDMI::Service::CallContext;
    my($return);
    #BEGIN all_entities_AlignmentTree

    $return = $self->_all_entities($ctx, 'AlignmentTree', $start, $count, $fields);

    #END all_entities_AlignmentTree
    my @_bad_returns;
    (ref($return) eq 'HASH') or push(@_bad_returns, "Invalid type for return variable \"return\" (value was \"$return\")");
    if (@_bad_returns) {
	my $msg = "Invalid returns passed to all_entities_AlignmentTree:\n" . join("", map { "\t$_\n" } @_bad_returns);
	Bio::KBase::Exceptions::ArgumentValidationError->throw(error => $msg,
							       method_name => 'all_entities_AlignmentTree');
    }
    return($return);
}




=head2 get_entity_AlleleFrequency

  $return = $obj->get_entity_AlleleFrequency($ids, $fields)

=over 4

=item Parameter and return types

=begin html

<pre>
$ids is a reference to a list where each element is a string
$fields is a reference to a list where each element is a string
$return is a reference to a hash where the key is a string and the value is a fields_AlleleFrequency
fields_AlleleFrequency is a reference to a hash where the following keys are defined:
	id has a value which is a string
	source_id has a value which is a string
	position has a value which is an int
	minor_AF has a value which is a float
	minor_allele has a value which is a string
	major_AF has a value which is a float
	major_allele has a value which is a string
	obs_unit_count has a value which is an int

</pre>

=end html

=begin text

$ids is a reference to a list where each element is a string
$fields is a reference to a list where each element is a string
$return is a reference to a hash where the key is a string and the value is a fields_AlleleFrequency
fields_AlleleFrequency is a reference to a hash where the following keys are defined:
	id has a value which is a string
	source_id has a value which is a string
	position has a value which is an int
	minor_AF has a value which is a float
	minor_allele has a value which is a string
	major_AF has a value which is a float
	major_allele has a value which is a string
	obs_unit_count has a value which is an int


=end text



=item Description

An allele frequency represents a summary of the major and minor allele frequencies for a position on a chromosome.
It has the following fields:

=over 4


=item source_id

identifier for this allele in the original (source) database


=item position

Specific position on the contig where the allele occurs


=item minor_AF

Minor allele frequency.  Floating point number from 0.0 to 0.5.


=item minor_allele

Text letter representation of the minor allele. Valid values are A, C, G, and T.


=item major_AF

Major allele frequency.  Floating point number less than or equal to 1.0.


=item major_allele

Text letter representation of the major allele. Valid values are A, C, G, and T.


=item obs_unit_count

Number of observational units used to compute the allele frequencies. Indicates
the quality of the analysis.



=back

=back

=cut

sub get_entity_AlleleFrequency
{
    my $self = shift;
    my($ids, $fields) = @_;

    my @_bad_arguments;
    (ref($ids) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"ids\" (value was \"$ids\")");
    (ref($fields) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"fields\" (value was \"$fields\")");
    if (@_bad_arguments) {
	my $msg = "Invalid arguments passed to get_entity_AlleleFrequency:\n" . join("", map { "\t$_\n" } @_bad_arguments);
	Bio::KBase::Exceptions::ArgumentValidationError->throw(error => $msg,
							       method_name => 'get_entity_AlleleFrequency');
    }

    my $ctx = $Bio::KBase::CDMI::Service::CallContext;
    my($return);
    #BEGIN get_entity_AlleleFrequency

    $return = $self->_get_entity($ctx, 'AlleleFrequency', $ids, $fields);

    #END get_entity_AlleleFrequency
    my @_bad_returns;
    (ref($return) eq 'HASH') or push(@_bad_returns, "Invalid type for return variable \"return\" (value was \"$return\")");
    if (@_bad_returns) {
	my $msg = "Invalid returns passed to get_entity_AlleleFrequency:\n" . join("", map { "\t$_\n" } @_bad_returns);
	Bio::KBase::Exceptions::ArgumentValidationError->throw(error => $msg,
							       method_name => 'get_entity_AlleleFrequency');
    }
    return($return);
}




=head2 query_entity_AlleleFrequency

  $return = $obj->query_entity_AlleleFrequency($qry, $fields)

=over 4

=item Parameter and return types

=begin html

<pre>
$qry is a reference to a list where each element is a reference to a list containing 3 items:
	0: a string
	1: a string
	2: a string
$fields is a reference to a list where each element is a string
$return is a reference to a hash where the key is a string and the value is a fields_AlleleFrequency
fields_AlleleFrequency is a reference to a hash where the following keys are defined:
	id has a value which is a string
	source_id has a value which is a string
	position has a value which is an int
	minor_AF has a value which is a float
	minor_allele has a value which is a string
	major_AF has a value which is a float
	major_allele has a value which is a string
	obs_unit_count has a value which is an int

</pre>

=end html

=begin text

$qry is a reference to a list where each element is a reference to a list containing 3 items:
	0: a string
	1: a string
	2: a string
$fields is a reference to a list where each element is a string
$return is a reference to a hash where the key is a string and the value is a fields_AlleleFrequency
fields_AlleleFrequency is a reference to a hash where the following keys are defined:
	id has a value which is a string
	source_id has a value which is a string
	position has a value which is an int
	minor_AF has a value which is a float
	minor_allele has a value which is a string
	major_AF has a value which is a float
	major_allele has a value which is a string
	obs_unit_count has a value which is an int


=end text



=item Description



=back

=cut

sub query_entity_AlleleFrequency
{
    my $self = shift;
    my($qry, $fields) = @_;

    my @_bad_arguments;
    (ref($qry) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"qry\" (value was \"$qry\")");
    (ref($fields) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"fields\" (value was \"$fields\")");
    if (@_bad_arguments) {
	my $msg = "Invalid arguments passed to query_entity_AlleleFrequency:\n" . join("", map { "\t$_\n" } @_bad_arguments);
	Bio::KBase::Exceptions::ArgumentValidationError->throw(error => $msg,
							       method_name => 'query_entity_AlleleFrequency');
    }

    my $ctx = $Bio::KBase::CDMI::Service::CallContext;
    my($return);
    #BEGIN query_entity_AlleleFrequency

    $return = $self->_query_entity($ctx, 'AlleleFrequency', $qry, $fields);

    #END query_entity_AlleleFrequency
    my @_bad_returns;
    (ref($return) eq 'HASH') or push(@_bad_returns, "Invalid type for return variable \"return\" (value was \"$return\")");
    if (@_bad_returns) {
	my $msg = "Invalid returns passed to query_entity_AlleleFrequency:\n" . join("", map { "\t$_\n" } @_bad_returns);
	Bio::KBase::Exceptions::ArgumentValidationError->throw(error => $msg,
							       method_name => 'query_entity_AlleleFrequency');
    }
    return($return);
}




=head2 all_entities_AlleleFrequency

  $return = $obj->all_entities_AlleleFrequency($start, $count, $fields)

=over 4

=item Parameter and return types

=begin html

<pre>
$start is an int
$count is an int
$fields is a reference to a list where each element is a string
$return is a reference to a hash where the key is a string and the value is a fields_AlleleFrequency
fields_AlleleFrequency is a reference to a hash where the following keys are defined:
	id has a value which is a string
	source_id has a value which is a string
	position has a value which is an int
	minor_AF has a value which is a float
	minor_allele has a value which is a string
	major_AF has a value which is a float
	major_allele has a value which is a string
	obs_unit_count has a value which is an int

</pre>

=end html

=begin text

$start is an int
$count is an int
$fields is a reference to a list where each element is a string
$return is a reference to a hash where the key is a string and the value is a fields_AlleleFrequency
fields_AlleleFrequency is a reference to a hash where the following keys are defined:
	id has a value which is a string
	source_id has a value which is a string
	position has a value which is an int
	minor_AF has a value which is a float
	minor_allele has a value which is a string
	major_AF has a value which is a float
	major_allele has a value which is a string
	obs_unit_count has a value which is an int


=end text



=item Description



=back

=cut

sub all_entities_AlleleFrequency
{
    my $self = shift;
    my($start, $count, $fields) = @_;

    my @_bad_arguments;
    (!ref($start)) or push(@_bad_arguments, "Invalid type for argument \"start\" (value was \"$start\")");
    (!ref($count)) or push(@_bad_arguments, "Invalid type for argument \"count\" (value was \"$count\")");
    (ref($fields) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"fields\" (value was \"$fields\")");
    if (@_bad_arguments) {
	my $msg = "Invalid arguments passed to all_entities_AlleleFrequency:\n" . join("", map { "\t$_\n" } @_bad_arguments);
	Bio::KBase::Exceptions::ArgumentValidationError->throw(error => $msg,
							       method_name => 'all_entities_AlleleFrequency');
    }

    my $ctx = $Bio::KBase::CDMI::Service::CallContext;
    my($return);
    #BEGIN all_entities_AlleleFrequency

    $return = $self->_all_entities($ctx, 'AlleleFrequency', $start, $count, $fields);

    #END all_entities_AlleleFrequency
    my @_bad_returns;
    (ref($return) eq 'HASH') or push(@_bad_returns, "Invalid type for return variable \"return\" (value was \"$return\")");
    if (@_bad_returns) {
	my $msg = "Invalid returns passed to all_entities_AlleleFrequency:\n" . join("", map { "\t$_\n" } @_bad_returns);
	Bio::KBase::Exceptions::ArgumentValidationError->throw(error => $msg,
							       method_name => 'all_entities_AlleleFrequency');
    }
    return($return);
}




=head2 get_entity_Annotation

  $return = $obj->get_entity_Annotation($ids, $fields)

=over 4

=item Parameter and return types

=begin html

<pre>
$ids is a reference to a list where each element is a string
$fields is a reference to a list where each element is a string
$return is a reference to a hash where the key is a string and the value is a fields_Annotation
fields_Annotation is a reference to a hash where the following keys are defined:
	id has a value which is a string
	annotator has a value which is a string
	comment has a value which is a string
	annotation_time has a value which is a string

</pre>

=end html

=begin text

$ids is a reference to a list where each element is a string
$fields is a reference to a list where each element is a string
$return is a reference to a hash where the key is a string and the value is a fields_Annotation
fields_Annotation is a reference to a hash where the following keys are defined:
	id has a value which is a string
	annotator has a value which is a string
	comment has a value which is a string
	annotation_time has a value which is a string


=end text



=item Description

An annotation is a comment attached to a feature. Annotations
are used to track the history of a feature's functional assignments
and any related issues. The key is the feature ID followed by a
colon and a complemented ten-digit sequence number.

It has the following fields:

=over 4


=item annotator

name of the annotator who made the comment


=item comment

text of the annotation


=item annotation_time

date and time at which the annotation was made



=back

=back

=cut

sub get_entity_Annotation
{
    my $self = shift;
    my($ids, $fields) = @_;

    my @_bad_arguments;
    (ref($ids) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"ids\" (value was \"$ids\")");
    (ref($fields) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"fields\" (value was \"$fields\")");
    if (@_bad_arguments) {
	my $msg = "Invalid arguments passed to get_entity_Annotation:\n" . join("", map { "\t$_\n" } @_bad_arguments);
	Bio::KBase::Exceptions::ArgumentValidationError->throw(error => $msg,
							       method_name => 'get_entity_Annotation');
    }

    my $ctx = $Bio::KBase::CDMI::Service::CallContext;
    my($return);
    #BEGIN get_entity_Annotation

    $return = $self->_get_entity($ctx, 'Annotation', $ids, $fields);

    #END get_entity_Annotation
    my @_bad_returns;
    (ref($return) eq 'HASH') or push(@_bad_returns, "Invalid type for return variable \"return\" (value was \"$return\")");
    if (@_bad_returns) {
	my $msg = "Invalid returns passed to get_entity_Annotation:\n" . join("", map { "\t$_\n" } @_bad_returns);
	Bio::KBase::Exceptions::ArgumentValidationError->throw(error => $msg,
							       method_name => 'get_entity_Annotation');
    }
    return($return);
}




=head2 query_entity_Annotation

  $return = $obj->query_entity_Annotation($qry, $fields)

=over 4

=item Parameter and return types

=begin html

<pre>
$qry is a reference to a list where each element is a reference to a list containing 3 items:
	0: a string
	1: a string
	2: a string
$fields is a reference to a list where each element is a string
$return is a reference to a hash where the key is a string and the value is a fields_Annotation
fields_Annotation is a reference to a hash where the following keys are defined:
	id has a value which is a string
	annotator has a value which is a string
	comment has a value which is a string
	annotation_time has a value which is a string

</pre>

=end html

=begin text

$qry is a reference to a list where each element is a reference to a list containing 3 items:
	0: a string
	1: a string
	2: a string
$fields is a reference to a list where each element is a string
$return is a reference to a hash where the key is a string and the value is a fields_Annotation
fields_Annotation is a reference to a hash where the following keys are defined:
	id has a value which is a string
	annotator has a value which is a string
	comment has a value which is a string
	annotation_time has a value which is a string


=end text



=item Description



=back

=cut

sub query_entity_Annotation
{
    my $self = shift;
    my($qry, $fields) = @_;

    my @_bad_arguments;
    (ref($qry) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"qry\" (value was \"$qry\")");
    (ref($fields) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"fields\" (value was \"$fields\")");
    if (@_bad_arguments) {
	my $msg = "Invalid arguments passed to query_entity_Annotation:\n" . join("", map { "\t$_\n" } @_bad_arguments);
	Bio::KBase::Exceptions::ArgumentValidationError->throw(error => $msg,
							       method_name => 'query_entity_Annotation');
    }

    my $ctx = $Bio::KBase::CDMI::Service::CallContext;
    my($return);
    #BEGIN query_entity_Annotation

    $return = $self->_query_entity($ctx, 'Annotation', $qry, $fields);

    #END query_entity_Annotation
    my @_bad_returns;
    (ref($return) eq 'HASH') or push(@_bad_returns, "Invalid type for return variable \"return\" (value was \"$return\")");
    if (@_bad_returns) {
	my $msg = "Invalid returns passed to query_entity_Annotation:\n" . join("", map { "\t$_\n" } @_bad_returns);
	Bio::KBase::Exceptions::ArgumentValidationError->throw(error => $msg,
							       method_name => 'query_entity_Annotation');
    }
    return($return);
}




=head2 all_entities_Annotation

  $return = $obj->all_entities_Annotation($start, $count, $fields)

=over 4

=item Parameter and return types

=begin html

<pre>
$start is an int
$count is an int
$fields is a reference to a list where each element is a string
$return is a reference to a hash where the key is a string and the value is a fields_Annotation
fields_Annotation is a reference to a hash where the following keys are defined:
	id has a value which is a string
	annotator has a value which is a string
	comment has a value which is a string
	annotation_time has a value which is a string

</pre>

=end html

=begin text

$start is an int
$count is an int
$fields is a reference to a list where each element is a string
$return is a reference to a hash where the key is a string and the value is a fields_Annotation
fields_Annotation is a reference to a hash where the following keys are defined:
	id has a value which is a string
	annotator has a value which is a string
	comment has a value which is a string
	annotation_time has a value which is a string


=end text



=item Description



=back

=cut

sub all_entities_Annotation
{
    my $self = shift;
    my($start, $count, $fields) = @_;

    my @_bad_arguments;
    (!ref($start)) or push(@_bad_arguments, "Invalid type for argument \"start\" (value was \"$start\")");
    (!ref($count)) or push(@_bad_arguments, "Invalid type for argument \"count\" (value was \"$count\")");
    (ref($fields) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"fields\" (value was \"$fields\")");
    if (@_bad_arguments) {
	my $msg = "Invalid arguments passed to all_entities_Annotation:\n" . join("", map { "\t$_\n" } @_bad_arguments);
	Bio::KBase::Exceptions::ArgumentValidationError->throw(error => $msg,
							       method_name => 'all_entities_Annotation');
    }

    my $ctx = $Bio::KBase::CDMI::Service::CallContext;
    my($return);
    #BEGIN all_entities_Annotation

    $return = $self->_all_entities($ctx, 'Annotation', $start, $count, $fields);

    #END all_entities_Annotation
    my @_bad_returns;
    (ref($return) eq 'HASH') or push(@_bad_returns, "Invalid type for return variable \"return\" (value was \"$return\")");
    if (@_bad_returns) {
	my $msg = "Invalid returns passed to all_entities_Annotation:\n" . join("", map { "\t$_\n" } @_bad_returns);
	Bio::KBase::Exceptions::ArgumentValidationError->throw(error => $msg,
							       method_name => 'all_entities_Annotation');
    }
    return($return);
}




=head2 get_entity_Assay

  $return = $obj->get_entity_Assay($ids, $fields)

=over 4

=item Parameter and return types

=begin html

<pre>
$ids is a reference to a list where each element is a string
$fields is a reference to a list where each element is a string
$return is a reference to a hash where the key is a string and the value is a fields_Assay
fields_Assay is a reference to a hash where the following keys are defined:
	id has a value which is a string
	source_id has a value which is a string
	assay_type has a value which is a string
	assay_type_id has a value which is a string

</pre>

=end html

=begin text

$ids is a reference to a list where each element is a string
$fields is a reference to a list where each element is a string
$return is a reference to a hash where the key is a string and the value is a fields_Assay
fields_Assay is a reference to a hash where the following keys are defined:
	id has a value which is a string
	source_id has a value which is a string
	assay_type has a value which is a string
	assay_type_id has a value which is a string


=end text



=item Description

An assay is an experimental design for determining alleles at specific chromosome positions.
It has the following fields:

=over 4


=item source_id

identifier for this assay in the original (source) database


=item assay_type

Text description of the type of assay (e.g., SNP, length, sequence, categorical, array, short read, SSR marker, AFLP marker)


=item assay_type_id

source ID associated with the assay type (informational)



=back

=back

=cut

sub get_entity_Assay
{
    my $self = shift;
    my($ids, $fields) = @_;

    my @_bad_arguments;
    (ref($ids) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"ids\" (value was \"$ids\")");
    (ref($fields) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"fields\" (value was \"$fields\")");
    if (@_bad_arguments) {
	my $msg = "Invalid arguments passed to get_entity_Assay:\n" . join("", map { "\t$_\n" } @_bad_arguments);
	Bio::KBase::Exceptions::ArgumentValidationError->throw(error => $msg,
							       method_name => 'get_entity_Assay');
    }

    my $ctx = $Bio::KBase::CDMI::Service::CallContext;
    my($return);
    #BEGIN get_entity_Assay

    $return = $self->_get_entity($ctx, 'Assay', $ids, $fields);

    #END get_entity_Assay
    my @_bad_returns;
    (ref($return) eq 'HASH') or push(@_bad_returns, "Invalid type for return variable \"return\" (value was \"$return\")");
    if (@_bad_returns) {
	my $msg = "Invalid returns passed to get_entity_Assay:\n" . join("", map { "\t$_\n" } @_bad_returns);
	Bio::KBase::Exceptions::ArgumentValidationError->throw(error => $msg,
							       method_name => 'get_entity_Assay');
    }
    return($return);
}




=head2 query_entity_Assay

  $return = $obj->query_entity_Assay($qry, $fields)

=over 4

=item Parameter and return types

=begin html

<pre>
$qry is a reference to a list where each element is a reference to a list containing 3 items:
	0: a string
	1: a string
	2: a string
$fields is a reference to a list where each element is a string
$return is a reference to a hash where the key is a string and the value is a fields_Assay
fields_Assay is a reference to a hash where the following keys are defined:
	id has a value which is a string
	source_id has a value which is a string
	assay_type has a value which is a string
	assay_type_id has a value which is a string

</pre>

=end html

=begin text

$qry is a reference to a list where each element is a reference to a list containing 3 items:
	0: a string
	1: a string
	2: a string
$fields is a reference to a list where each element is a string
$return is a reference to a hash where the key is a string and the value is a fields_Assay
fields_Assay is a reference to a hash where the following keys are defined:
	id has a value which is a string
	source_id has a value which is a string
	assay_type has a value which is a string
	assay_type_id has a value which is a string


=end text



=item Description



=back

=cut

sub query_entity_Assay
{
    my $self = shift;
    my($qry, $fields) = @_;

    my @_bad_arguments;
    (ref($qry) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"qry\" (value was \"$qry\")");
    (ref($fields) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"fields\" (value was \"$fields\")");
    if (@_bad_arguments) {
	my $msg = "Invalid arguments passed to query_entity_Assay:\n" . join("", map { "\t$_\n" } @_bad_arguments);
	Bio::KBase::Exceptions::ArgumentValidationError->throw(error => $msg,
							       method_name => 'query_entity_Assay');
    }

    my $ctx = $Bio::KBase::CDMI::Service::CallContext;
    my($return);
    #BEGIN query_entity_Assay

    $return = $self->_query_entity($ctx, 'Assay', $qry, $fields);

    #END query_entity_Assay
    my @_bad_returns;
    (ref($return) eq 'HASH') or push(@_bad_returns, "Invalid type for return variable \"return\" (value was \"$return\")");
    if (@_bad_returns) {
	my $msg = "Invalid returns passed to query_entity_Assay:\n" . join("", map { "\t$_\n" } @_bad_returns);
	Bio::KBase::Exceptions::ArgumentValidationError->throw(error => $msg,
							       method_name => 'query_entity_Assay');
    }
    return($return);
}




=head2 all_entities_Assay

  $return = $obj->all_entities_Assay($start, $count, $fields)

=over 4

=item Parameter and return types

=begin html

<pre>
$start is an int
$count is an int
$fields is a reference to a list where each element is a string
$return is a reference to a hash where the key is a string and the value is a fields_Assay
fields_Assay is a reference to a hash where the following keys are defined:
	id has a value which is a string
	source_id has a value which is a string
	assay_type has a value which is a string
	assay_type_id has a value which is a string

</pre>

=end html

=begin text

$start is an int
$count is an int
$fields is a reference to a list where each element is a string
$return is a reference to a hash where the key is a string and the value is a fields_Assay
fields_Assay is a reference to a hash where the following keys are defined:
	id has a value which is a string
	source_id has a value which is a string
	assay_type has a value which is a string
	assay_type_id has a value which is a string


=end text



=item Description



=back

=cut

sub all_entities_Assay
{
    my $self = shift;
    my($start, $count, $fields) = @_;

    my @_bad_arguments;
    (!ref($start)) or push(@_bad_arguments, "Invalid type for argument \"start\" (value was \"$start\")");
    (!ref($count)) or push(@_bad_arguments, "Invalid type for argument \"count\" (value was \"$count\")");
    (ref($fields) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"fields\" (value was \"$fields\")");
    if (@_bad_arguments) {
	my $msg = "Invalid arguments passed to all_entities_Assay:\n" . join("", map { "\t$_\n" } @_bad_arguments);
	Bio::KBase::Exceptions::ArgumentValidationError->throw(error => $msg,
							       method_name => 'all_entities_Assay');
    }

    my $ctx = $Bio::KBase::CDMI::Service::CallContext;
    my($return);
    #BEGIN all_entities_Assay

    $return = $self->_all_entities($ctx, 'Assay', $start, $count, $fields);

    #END all_entities_Assay
    my @_bad_returns;
    (ref($return) eq 'HASH') or push(@_bad_returns, "Invalid type for return variable \"return\" (value was \"$return\")");
    if (@_bad_returns) {
	my $msg = "Invalid returns passed to all_entities_Assay:\n" . join("", map { "\t$_\n" } @_bad_returns);
	Bio::KBase::Exceptions::ArgumentValidationError->throw(error => $msg,
							       method_name => 'all_entities_Assay');
    }
    return($return);
}




=head2 get_entity_AtomicRegulon

  $return = $obj->get_entity_AtomicRegulon($ids, $fields)

=over 4

=item Parameter and return types

=begin html

<pre>
$ids is a reference to a list where each element is a string
$fields is a reference to a list where each element is a string
$return is a reference to a hash where the key is a string and the value is a fields_AtomicRegulon
fields_AtomicRegulon is a reference to a hash where the following keys are defined:
	id has a value which is a string

</pre>

=end html

=begin text

$ids is a reference to a list where each element is a string
$fields is a reference to a list where each element is a string
$return is a reference to a hash where the key is a string and the value is a fields_AtomicRegulon
fields_AtomicRegulon is a reference to a hash where the following keys are defined:
	id has a value which is a string


=end text



=item Description

An atomic regulon is an indivisible group of coregulated features
on a single genome. Atomic regulons are constructed so that a given feature
can only belong to one. Because of this, the expression levels for
atomic regulons represent in some sense the state of a cell.
An atomicRegulon is a set of protein-encoding genes that
are believed to have identical expression profiles (i.e.,
they will all be expressed or none will be expressed in the
vast majority of conditions).  These are sometimes referred
to as "atomic regulons".  Note that there are more common
notions of "coregulated set of genes" based on the notion
that a single regulatory mechanism impacts an entire set of
genes. Since multiple other mechanisms may impact
overlapping sets, the genes impacted by a regulatory
mechanism need not all share the same expression profile.
We use a distinct notion (CoregulatedSet) to reference sets
of genes impacted by a single regulatory mechanism (i.e.,
by a single transcription regulator).

It has the following fields:

=over 4



=back

=back

=cut

sub get_entity_AtomicRegulon
{
    my $self = shift;
    my($ids, $fields) = @_;

    my @_bad_arguments;
    (ref($ids) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"ids\" (value was \"$ids\")");
    (ref($fields) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"fields\" (value was \"$fields\")");
    if (@_bad_arguments) {
	my $msg = "Invalid arguments passed to get_entity_AtomicRegulon:\n" . join("", map { "\t$_\n" } @_bad_arguments);
	Bio::KBase::Exceptions::ArgumentValidationError->throw(error => $msg,
							       method_name => 'get_entity_AtomicRegulon');
    }

    my $ctx = $Bio::KBase::CDMI::Service::CallContext;
    my($return);
    #BEGIN get_entity_AtomicRegulon

    $return = $self->_get_entity($ctx, 'AtomicRegulon', $ids, $fields);

    #END get_entity_AtomicRegulon
    my @_bad_returns;
    (ref($return) eq 'HASH') or push(@_bad_returns, "Invalid type for return variable \"return\" (value was \"$return\")");
    if (@_bad_returns) {
	my $msg = "Invalid returns passed to get_entity_AtomicRegulon:\n" . join("", map { "\t$_\n" } @_bad_returns);
	Bio::KBase::Exceptions::ArgumentValidationError->throw(error => $msg,
							       method_name => 'get_entity_AtomicRegulon');
    }
    return($return);
}




=head2 query_entity_AtomicRegulon

  $return = $obj->query_entity_AtomicRegulon($qry, $fields)

=over 4

=item Parameter and return types

=begin html

<pre>
$qry is a reference to a list where each element is a reference to a list containing 3 items:
	0: a string
	1: a string
	2: a string
$fields is a reference to a list where each element is a string
$return is a reference to a hash where the key is a string and the value is a fields_AtomicRegulon
fields_AtomicRegulon is a reference to a hash where the following keys are defined:
	id has a value which is a string

</pre>

=end html

=begin text

$qry is a reference to a list where each element is a reference to a list containing 3 items:
	0: a string
	1: a string
	2: a string
$fields is a reference to a list where each element is a string
$return is a reference to a hash where the key is a string and the value is a fields_AtomicRegulon
fields_AtomicRegulon is a reference to a hash where the following keys are defined:
	id has a value which is a string


=end text



=item Description



=back

=cut

sub query_entity_AtomicRegulon
{
    my $self = shift;
    my($qry, $fields) = @_;

    my @_bad_arguments;
    (ref($qry) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"qry\" (value was \"$qry\")");
    (ref($fields) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"fields\" (value was \"$fields\")");
    if (@_bad_arguments) {
	my $msg = "Invalid arguments passed to query_entity_AtomicRegulon:\n" . join("", map { "\t$_\n" } @_bad_arguments);
	Bio::KBase::Exceptions::ArgumentValidationError->throw(error => $msg,
							       method_name => 'query_entity_AtomicRegulon');
    }

    my $ctx = $Bio::KBase::CDMI::Service::CallContext;
    my($return);
    #BEGIN query_entity_AtomicRegulon

    $return = $self->_query_entity($ctx, 'AtomicRegulon', $qry, $fields);

    #END query_entity_AtomicRegulon
    my @_bad_returns;
    (ref($return) eq 'HASH') or push(@_bad_returns, "Invalid type for return variable \"return\" (value was \"$return\")");
    if (@_bad_returns) {
	my $msg = "Invalid returns passed to query_entity_AtomicRegulon:\n" . join("", map { "\t$_\n" } @_bad_returns);
	Bio::KBase::Exceptions::ArgumentValidationError->throw(error => $msg,
							       method_name => 'query_entity_AtomicRegulon');
    }
    return($return);
}




=head2 all_entities_AtomicRegulon

  $return = $obj->all_entities_AtomicRegulon($start, $count, $fields)

=over 4

=item Parameter and return types

=begin html

<pre>
$start is an int
$count is an int
$fields is a reference to a list where each element is a string
$return is a reference to a hash where the key is a string and the value is a fields_AtomicRegulon
fields_AtomicRegulon is a reference to a hash where the following keys are defined:
	id has a value which is a string

</pre>

=end html

=begin text

$start is an int
$count is an int
$fields is a reference to a list where each element is a string
$return is a reference to a hash where the key is a string and the value is a fields_AtomicRegulon
fields_AtomicRegulon is a reference to a hash where the following keys are defined:
	id has a value which is a string


=end text



=item Description



=back

=cut

sub all_entities_AtomicRegulon
{
    my $self = shift;
    my($start, $count, $fields) = @_;

    my @_bad_arguments;
    (!ref($start)) or push(@_bad_arguments, "Invalid type for argument \"start\" (value was \"$start\")");
    (!ref($count)) or push(@_bad_arguments, "Invalid type for argument \"count\" (value was \"$count\")");
    (ref($fields) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"fields\" (value was \"$fields\")");
    if (@_bad_arguments) {
	my $msg = "Invalid arguments passed to all_entities_AtomicRegulon:\n" . join("", map { "\t$_\n" } @_bad_arguments);
	Bio::KBase::Exceptions::ArgumentValidationError->throw(error => $msg,
							       method_name => 'all_entities_AtomicRegulon');
    }

    my $ctx = $Bio::KBase::CDMI::Service::CallContext;
    my($return);
    #BEGIN all_entities_AtomicRegulon

    $return = $self->_all_entities($ctx, 'AtomicRegulon', $start, $count, $fields);

    #END all_entities_AtomicRegulon
    my @_bad_returns;
    (ref($return) eq 'HASH') or push(@_bad_returns, "Invalid type for return variable \"return\" (value was \"$return\")");
    if (@_bad_returns) {
	my $msg = "Invalid returns passed to all_entities_AtomicRegulon:\n" . join("", map { "\t$_\n" } @_bad_returns);
	Bio::KBase::Exceptions::ArgumentValidationError->throw(error => $msg,
							       method_name => 'all_entities_AtomicRegulon');
    }
    return($return);
}




=head2 get_entity_Attribute

  $return = $obj->get_entity_Attribute($ids, $fields)

=over 4

=item Parameter and return types

=begin html

<pre>
$ids is a reference to a list where each element is a string
$fields is a reference to a list where each element is a string
$return is a reference to a hash where the key is a string and the value is a fields_Attribute
fields_Attribute is a reference to a hash where the following keys are defined:
	id has a value which is a string
	description has a value which is a string

</pre>

=end html

=begin text

$ids is a reference to a list where each element is a string
$fields is a reference to a list where each element is a string
$return is a reference to a hash where the key is a string and the value is a fields_Attribute
fields_Attribute is a reference to a hash where the following keys are defined:
	id has a value which is a string
	description has a value which is a string


=end text



=item Description

An attribute describes a category of condition or characteristic for
an experiment. The goals of the experiment can be inferred from its values
for all the attributes of interest.
It has the following fields:

=over 4


=item description

Descriptive text indicating the nature and use of this attribute.



=back

=back

=cut

sub get_entity_Attribute
{
    my $self = shift;
    my($ids, $fields) = @_;

    my @_bad_arguments;
    (ref($ids) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"ids\" (value was \"$ids\")");
    (ref($fields) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"fields\" (value was \"$fields\")");
    if (@_bad_arguments) {
	my $msg = "Invalid arguments passed to get_entity_Attribute:\n" . join("", map { "\t$_\n" } @_bad_arguments);
	Bio::KBase::Exceptions::ArgumentValidationError->throw(error => $msg,
							       method_name => 'get_entity_Attribute');
    }

    my $ctx = $Bio::KBase::CDMI::Service::CallContext;
    my($return);
    #BEGIN get_entity_Attribute

    $return = $self->_get_entity($ctx, 'Attribute', $ids, $fields);

    #END get_entity_Attribute
    my @_bad_returns;
    (ref($return) eq 'HASH') or push(@_bad_returns, "Invalid type for return variable \"return\" (value was \"$return\")");
    if (@_bad_returns) {
	my $msg = "Invalid returns passed to get_entity_Attribute:\n" . join("", map { "\t$_\n" } @_bad_returns);
	Bio::KBase::Exceptions::ArgumentValidationError->throw(error => $msg,
							       method_name => 'get_entity_Attribute');
    }
    return($return);
}




=head2 query_entity_Attribute

  $return = $obj->query_entity_Attribute($qry, $fields)

=over 4

=item Parameter and return types

=begin html

<pre>
$qry is a reference to a list where each element is a reference to a list containing 3 items:
	0: a string
	1: a string
	2: a string
$fields is a reference to a list where each element is a string
$return is a reference to a hash where the key is a string and the value is a fields_Attribute
fields_Attribute is a reference to a hash where the following keys are defined:
	id has a value which is a string
	description has a value which is a string

</pre>

=end html

=begin text

$qry is a reference to a list where each element is a reference to a list containing 3 items:
	0: a string
	1: a string
	2: a string
$fields is a reference to a list where each element is a string
$return is a reference to a hash where the key is a string and the value is a fields_Attribute
fields_Attribute is a reference to a hash where the following keys are defined:
	id has a value which is a string
	description has a value which is a string


=end text



=item Description



=back

=cut

sub query_entity_Attribute
{
    my $self = shift;
    my($qry, $fields) = @_;

    my @_bad_arguments;
    (ref($qry) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"qry\" (value was \"$qry\")");
    (ref($fields) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"fields\" (value was \"$fields\")");
    if (@_bad_arguments) {
	my $msg = "Invalid arguments passed to query_entity_Attribute:\n" . join("", map { "\t$_\n" } @_bad_arguments);
	Bio::KBase::Exceptions::ArgumentValidationError->throw(error => $msg,
							       method_name => 'query_entity_Attribute');
    }

    my $ctx = $Bio::KBase::CDMI::Service::CallContext;
    my($return);
    #BEGIN query_entity_Attribute

    $return = $self->_query_entity($ctx, 'Attribute', $qry, $fields);

    #END query_entity_Attribute
    my @_bad_returns;
    (ref($return) eq 'HASH') or push(@_bad_returns, "Invalid type for return variable \"return\" (value was \"$return\")");
    if (@_bad_returns) {
	my $msg = "Invalid returns passed to query_entity_Attribute:\n" . join("", map { "\t$_\n" } @_bad_returns);
	Bio::KBase::Exceptions::ArgumentValidationError->throw(error => $msg,
							       method_name => 'query_entity_Attribute');
    }
    return($return);
}




=head2 all_entities_Attribute

  $return = $obj->all_entities_Attribute($start, $count, $fields)

=over 4

=item Parameter and return types

=begin html

<pre>
$start is an int
$count is an int
$fields is a reference to a list where each element is a string
$return is a reference to a hash where the key is a string and the value is a fields_Attribute
fields_Attribute is a reference to a hash where the following keys are defined:
	id has a value which is a string
	description has a value which is a string

</pre>

=end html

=begin text

$start is an int
$count is an int
$fields is a reference to a list where each element is a string
$return is a reference to a hash where the key is a string and the value is a fields_Attribute
fields_Attribute is a reference to a hash where the following keys are defined:
	id has a value which is a string
	description has a value which is a string


=end text



=item Description



=back

=cut

sub all_entities_Attribute
{
    my $self = shift;
    my($start, $count, $fields) = @_;

    my @_bad_arguments;
    (!ref($start)) or push(@_bad_arguments, "Invalid type for argument \"start\" (value was \"$start\")");
    (!ref($count)) or push(@_bad_arguments, "Invalid type for argument \"count\" (value was \"$count\")");
    (ref($fields) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"fields\" (value was \"$fields\")");
    if (@_bad_arguments) {
	my $msg = "Invalid arguments passed to all_entities_Attribute:\n" . join("", map { "\t$_\n" } @_bad_arguments);
	Bio::KBase::Exceptions::ArgumentValidationError->throw(error => $msg,
							       method_name => 'all_entities_Attribute');
    }

    my $ctx = $Bio::KBase::CDMI::Service::CallContext;
    my($return);
    #BEGIN all_entities_Attribute

    $return = $self->_all_entities($ctx, 'Attribute', $start, $count, $fields);

    #END all_entities_Attribute
    my @_bad_returns;
    (ref($return) eq 'HASH') or push(@_bad_returns, "Invalid type for return variable \"return\" (value was \"$return\")");
    if (@_bad_returns) {
	my $msg = "Invalid returns passed to all_entities_Attribute:\n" . join("", map { "\t$_\n" } @_bad_returns);
	Bio::KBase::Exceptions::ArgumentValidationError->throw(error => $msg,
							       method_name => 'all_entities_Attribute');
    }
    return($return);
}




=head2 get_entity_Biomass

  $return = $obj->get_entity_Biomass($ids, $fields)

=over 4

=item Parameter and return types

=begin html

<pre>
$ids is a reference to a list where each element is a string
$fields is a reference to a list where each element is a string
$return is a reference to a hash where the key is a string and the value is a fields_Biomass
fields_Biomass is a reference to a hash where the following keys are defined:
	id has a value which is a string
	mod_date has a value which is a string
	name has a value which is a reference to a list where each element is a string

</pre>

=end html

=begin text

$ids is a reference to a list where each element is a string
$fields is a reference to a list where each element is a string
$return is a reference to a hash where the key is a string and the value is a fields_Biomass
fields_Biomass is a reference to a hash where the following keys are defined:
	id has a value which is a string
	mod_date has a value which is a string
	name has a value which is a reference to a list where each element is a string


=end text



=item Description

A biomass is a collection of compounds in a specific
ratio and in specific compartments that are necessary for a
cell to function properly. The prediction of biomasses is key
to the functioning of the model.
It has the following fields:

=over 4


=item mod_date

last modification date of the biomass data


=item name

descriptive name for this biomass



=back

=back

=cut

sub get_entity_Biomass
{
    my $self = shift;
    my($ids, $fields) = @_;

    my @_bad_arguments;
    (ref($ids) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"ids\" (value was \"$ids\")");
    (ref($fields) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"fields\" (value was \"$fields\")");
    if (@_bad_arguments) {
	my $msg = "Invalid arguments passed to get_entity_Biomass:\n" . join("", map { "\t$_\n" } @_bad_arguments);
	Bio::KBase::Exceptions::ArgumentValidationError->throw(error => $msg,
							       method_name => 'get_entity_Biomass');
    }

    my $ctx = $Bio::KBase::CDMI::Service::CallContext;
    my($return);
    #BEGIN get_entity_Biomass

    $return = $self->_get_entity($ctx, 'Biomass', $ids, $fields);

    #END get_entity_Biomass
    my @_bad_returns;
    (ref($return) eq 'HASH') or push(@_bad_returns, "Invalid type for return variable \"return\" (value was \"$return\")");
    if (@_bad_returns) {
	my $msg = "Invalid returns passed to get_entity_Biomass:\n" . join("", map { "\t$_\n" } @_bad_returns);
	Bio::KBase::Exceptions::ArgumentValidationError->throw(error => $msg,
							       method_name => 'get_entity_Biomass');
    }
    return($return);
}




=head2 query_entity_Biomass

  $return = $obj->query_entity_Biomass($qry, $fields)

=over 4

=item Parameter and return types

=begin html

<pre>
$qry is a reference to a list where each element is a reference to a list containing 3 items:
	0: a string
	1: a string
	2: a string
$fields is a reference to a list where each element is a string
$return is a reference to a hash where the key is a string and the value is a fields_Biomass
fields_Biomass is a reference to a hash where the following keys are defined:
	id has a value which is a string
	mod_date has a value which is a string
	name has a value which is a reference to a list where each element is a string

</pre>

=end html

=begin text

$qry is a reference to a list where each element is a reference to a list containing 3 items:
	0: a string
	1: a string
	2: a string
$fields is a reference to a list where each element is a string
$return is a reference to a hash where the key is a string and the value is a fields_Biomass
fields_Biomass is a reference to a hash where the following keys are defined:
	id has a value which is a string
	mod_date has a value which is a string
	name has a value which is a reference to a list where each element is a string


=end text



=item Description



=back

=cut

sub query_entity_Biomass
{
    my $self = shift;
    my($qry, $fields) = @_;

    my @_bad_arguments;
    (ref($qry) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"qry\" (value was \"$qry\")");
    (ref($fields) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"fields\" (value was \"$fields\")");
    if (@_bad_arguments) {
	my $msg = "Invalid arguments passed to query_entity_Biomass:\n" . join("", map { "\t$_\n" } @_bad_arguments);
	Bio::KBase::Exceptions::ArgumentValidationError->throw(error => $msg,
							       method_name => 'query_entity_Biomass');
    }

    my $ctx = $Bio::KBase::CDMI::Service::CallContext;
    my($return);
    #BEGIN query_entity_Biomass

    $return = $self->_query_entity($ctx, 'Biomass', $qry, $fields);

    #END query_entity_Biomass
    my @_bad_returns;
    (ref($return) eq 'HASH') or push(@_bad_returns, "Invalid type for return variable \"return\" (value was \"$return\")");
    if (@_bad_returns) {
	my $msg = "Invalid returns passed to query_entity_Biomass:\n" . join("", map { "\t$_\n" } @_bad_returns);
	Bio::KBase::Exceptions::ArgumentValidationError->throw(error => $msg,
							       method_name => 'query_entity_Biomass');
    }
    return($return);
}




=head2 all_entities_Biomass

  $return = $obj->all_entities_Biomass($start, $count, $fields)

=over 4

=item Parameter and return types

=begin html

<pre>
$start is an int
$count is an int
$fields is a reference to a list where each element is a string
$return is a reference to a hash where the key is a string and the value is a fields_Biomass
fields_Biomass is a reference to a hash where the following keys are defined:
	id has a value which is a string
	mod_date has a value which is a string
	name has a value which is a reference to a list where each element is a string

</pre>

=end html

=begin text

$start is an int
$count is an int
$fields is a reference to a list where each element is a string
$return is a reference to a hash where the key is a string and the value is a fields_Biomass
fields_Biomass is a reference to a hash where the following keys are defined:
	id has a value which is a string
	mod_date has a value which is a string
	name has a value which is a reference to a list where each element is a string


=end text



=item Description



=back

=cut

sub all_entities_Biomass
{
    my $self = shift;
    my($start, $count, $fields) = @_;

    my @_bad_arguments;
    (!ref($start)) or push(@_bad_arguments, "Invalid type for argument \"start\" (value was \"$start\")");
    (!ref($count)) or push(@_bad_arguments, "Invalid type for argument \"count\" (value was \"$count\")");
    (ref($fields) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"fields\" (value was \"$fields\")");
    if (@_bad_arguments) {
	my $msg = "Invalid arguments passed to all_entities_Biomass:\n" . join("", map { "\t$_\n" } @_bad_arguments);
	Bio::KBase::Exceptions::ArgumentValidationError->throw(error => $msg,
							       method_name => 'all_entities_Biomass');
    }

    my $ctx = $Bio::KBase::CDMI::Service::CallContext;
    my($return);
    #BEGIN all_entities_Biomass

    $return = $self->_all_entities($ctx, 'Biomass', $start, $count, $fields);

    #END all_entities_Biomass
    my @_bad_returns;
    (ref($return) eq 'HASH') or push(@_bad_returns, "Invalid type for return variable \"return\" (value was \"$return\")");
    if (@_bad_returns) {
	my $msg = "Invalid returns passed to all_entities_Biomass:\n" . join("", map { "\t$_\n" } @_bad_returns);
	Bio::KBase::Exceptions::ArgumentValidationError->throw(error => $msg,
							       method_name => 'all_entities_Biomass');
    }
    return($return);
}




=head2 get_entity_BiomassCompound

  $return = $obj->get_entity_BiomassCompound($ids, $fields)

=over 4

=item Parameter and return types

=begin html

<pre>
$ids is a reference to a list where each element is a string
$fields is a reference to a list where each element is a string
$return is a reference to a hash where the key is a string and the value is a fields_BiomassCompound
fields_BiomassCompound is a reference to a hash where the following keys are defined:
	id has a value which is a string
	coefficient has a value which is a float

</pre>

=end html

=begin text

$ids is a reference to a list where each element is a string
$fields is a reference to a list where each element is a string
$return is a reference to a hash where the key is a string and the value is a fields_BiomassCompound
fields_BiomassCompound is a reference to a hash where the following keys are defined:
	id has a value which is a string
	coefficient has a value which is a float


=end text



=item Description

A Biomass Compound represents the occurrence of a particular
compound in a biomass.
It has the following fields:

=over 4


=item coefficient

proportion of the biomass in grams per mole that
contains this compound



=back

=back

=cut

sub get_entity_BiomassCompound
{
    my $self = shift;
    my($ids, $fields) = @_;

    my @_bad_arguments;
    (ref($ids) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"ids\" (value was \"$ids\")");
    (ref($fields) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"fields\" (value was \"$fields\")");
    if (@_bad_arguments) {
	my $msg = "Invalid arguments passed to get_entity_BiomassCompound:\n" . join("", map { "\t$_\n" } @_bad_arguments);
	Bio::KBase::Exceptions::ArgumentValidationError->throw(error => $msg,
							       method_name => 'get_entity_BiomassCompound');
    }

    my $ctx = $Bio::KBase::CDMI::Service::CallContext;
    my($return);
    #BEGIN get_entity_BiomassCompound

    $return = $self->_get_entity($ctx, 'BiomassCompound', $ids, $fields);

    #END get_entity_BiomassCompound
    my @_bad_returns;
    (ref($return) eq 'HASH') or push(@_bad_returns, "Invalid type for return variable \"return\" (value was \"$return\")");
    if (@_bad_returns) {
	my $msg = "Invalid returns passed to get_entity_BiomassCompound:\n" . join("", map { "\t$_\n" } @_bad_returns);
	Bio::KBase::Exceptions::ArgumentValidationError->throw(error => $msg,
							       method_name => 'get_entity_BiomassCompound');
    }
    return($return);
}




=head2 query_entity_BiomassCompound

  $return = $obj->query_entity_BiomassCompound($qry, $fields)

=over 4

=item Parameter and return types

=begin html

<pre>
$qry is a reference to a list where each element is a reference to a list containing 3 items:
	0: a string
	1: a string
	2: a string
$fields is a reference to a list where each element is a string
$return is a reference to a hash where the key is a string and the value is a fields_BiomassCompound
fields_BiomassCompound is a reference to a hash where the following keys are defined:
	id has a value which is a string
	coefficient has a value which is a float

</pre>

=end html

=begin text

$qry is a reference to a list where each element is a reference to a list containing 3 items:
	0: a string
	1: a string
	2: a string
$fields is a reference to a list where each element is a string
$return is a reference to a hash where the key is a string and the value is a fields_BiomassCompound
fields_BiomassCompound is a reference to a hash where the following keys are defined:
	id has a value which is a string
	coefficient has a value which is a float


=end text



=item Description



=back

=cut

sub query_entity_BiomassCompound
{
    my $self = shift;
    my($qry, $fields) = @_;

    my @_bad_arguments;
    (ref($qry) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"qry\" (value was \"$qry\")");
    (ref($fields) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"fields\" (value was \"$fields\")");
    if (@_bad_arguments) {
	my $msg = "Invalid arguments passed to query_entity_BiomassCompound:\n" . join("", map { "\t$_\n" } @_bad_arguments);
	Bio::KBase::Exceptions::ArgumentValidationError->throw(error => $msg,
							       method_name => 'query_entity_BiomassCompound');
    }

    my $ctx = $Bio::KBase::CDMI::Service::CallContext;
    my($return);
    #BEGIN query_entity_BiomassCompound

    $return = $self->_query_entity($ctx, 'BiomassCompound', $qry, $fields);

    #END query_entity_BiomassCompound
    my @_bad_returns;
    (ref($return) eq 'HASH') or push(@_bad_returns, "Invalid type for return variable \"return\" (value was \"$return\")");
    if (@_bad_returns) {
	my $msg = "Invalid returns passed to query_entity_BiomassCompound:\n" . join("", map { "\t$_\n" } @_bad_returns);
	Bio::KBase::Exceptions::ArgumentValidationError->throw(error => $msg,
							       method_name => 'query_entity_BiomassCompound');
    }
    return($return);
}




=head2 all_entities_BiomassCompound

  $return = $obj->all_entities_BiomassCompound($start, $count, $fields)

=over 4

=item Parameter and return types

=begin html

<pre>
$start is an int
$count is an int
$fields is a reference to a list where each element is a string
$return is a reference to a hash where the key is a string and the value is a fields_BiomassCompound
fields_BiomassCompound is a reference to a hash where the following keys are defined:
	id has a value which is a string
	coefficient has a value which is a float

</pre>

=end html

=begin text

$start is an int
$count is an int
$fields is a reference to a list where each element is a string
$return is a reference to a hash where the key is a string and the value is a fields_BiomassCompound
fields_BiomassCompound is a reference to a hash where the following keys are defined:
	id has a value which is a string
	coefficient has a value which is a float


=end text



=item Description



=back

=cut

sub all_entities_BiomassCompound
{
    my $self = shift;
    my($start, $count, $fields) = @_;

    my @_bad_arguments;
    (!ref($start)) or push(@_bad_arguments, "Invalid type for argument \"start\" (value was \"$start\")");
    (!ref($count)) or push(@_bad_arguments, "Invalid type for argument \"count\" (value was \"$count\")");
    (ref($fields) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"fields\" (value was \"$fields\")");
    if (@_bad_arguments) {
	my $msg = "Invalid arguments passed to all_entities_BiomassCompound:\n" . join("", map { "\t$_\n" } @_bad_arguments);
	Bio::KBase::Exceptions::ArgumentValidationError->throw(error => $msg,
							       method_name => 'all_entities_BiomassCompound');
    }

    my $ctx = $Bio::KBase::CDMI::Service::CallContext;
    my($return);
    #BEGIN all_entities_BiomassCompound

    $return = $self->_all_entities($ctx, 'BiomassCompound', $start, $count, $fields);

    #END all_entities_BiomassCompound
    my @_bad_returns;
    (ref($return) eq 'HASH') or push(@_bad_returns, "Invalid type for return variable \"return\" (value was \"$return\")");
    if (@_bad_returns) {
	my $msg = "Invalid returns passed to all_entities_BiomassCompound:\n" . join("", map { "\t$_\n" } @_bad_returns);
	Bio::KBase::Exceptions::ArgumentValidationError->throw(error => $msg,
							       method_name => 'all_entities_BiomassCompound');
    }
    return($return);
}




=head2 get_entity_Compartment

  $return = $obj->get_entity_Compartment($ids, $fields)

=over 4

=item Parameter and return types

=begin html

<pre>
$ids is a reference to a list where each element is a string
$fields is a reference to a list where each element is a string
$return is a reference to a hash where the key is a string and the value is a fields_Compartment
fields_Compartment is a reference to a hash where the following keys are defined:
	id has a value which is a string
	abbr has a value which is a string
	mod_date has a value which is a string
	name has a value which is a string
	msid has a value which is a string

</pre>

=end html

=begin text

$ids is a reference to a list where each element is a string
$fields is a reference to a list where each element is a string
$return is a reference to a hash where the key is a string and the value is a fields_Compartment
fields_Compartment is a reference to a hash where the following keys are defined:
	id has a value which is a string
	abbr has a value which is a string
	mod_date has a value which is a string
	name has a value which is a string
	msid has a value which is a string


=end text



=item Description

A compartment is a section of a single model that represents
the environment in which a reaction takes place (e.g. cell
wall).
It has the following fields:

=over 4


=item abbr

short abbreviated name for this compartment (usually
a single character)


=item mod_date

date and time of the last modification to the
compartment's definition


=item name

common name for the compartment


=item msid

common modeling ID of this compartment



=back

=back

=cut

sub get_entity_Compartment
{
    my $self = shift;
    my($ids, $fields) = @_;

    my @_bad_arguments;
    (ref($ids) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"ids\" (value was \"$ids\")");
    (ref($fields) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"fields\" (value was \"$fields\")");
    if (@_bad_arguments) {
	my $msg = "Invalid arguments passed to get_entity_Compartment:\n" . join("", map { "\t$_\n" } @_bad_arguments);
	Bio::KBase::Exceptions::ArgumentValidationError->throw(error => $msg,
							       method_name => 'get_entity_Compartment');
    }

    my $ctx = $Bio::KBase::CDMI::Service::CallContext;
    my($return);
    #BEGIN get_entity_Compartment

    $return = $self->_get_entity($ctx, 'Compartment', $ids, $fields);

    #END get_entity_Compartment
    my @_bad_returns;
    (ref($return) eq 'HASH') or push(@_bad_returns, "Invalid type for return variable \"return\" (value was \"$return\")");
    if (@_bad_returns) {
	my $msg = "Invalid returns passed to get_entity_Compartment:\n" . join("", map { "\t$_\n" } @_bad_returns);
	Bio::KBase::Exceptions::ArgumentValidationError->throw(error => $msg,
							       method_name => 'get_entity_Compartment');
    }
    return($return);
}




=head2 query_entity_Compartment

  $return = $obj->query_entity_Compartment($qry, $fields)

=over 4

=item Parameter and return types

=begin html

<pre>
$qry is a reference to a list where each element is a reference to a list containing 3 items:
	0: a string
	1: a string
	2: a string
$fields is a reference to a list where each element is a string
$return is a reference to a hash where the key is a string and the value is a fields_Compartment
fields_Compartment is a reference to a hash where the following keys are defined:
	id has a value which is a string
	abbr has a value which is a string
	mod_date has a value which is a string
	name has a value which is a string
	msid has a value which is a string

</pre>

=end html

=begin text

$qry is a reference to a list where each element is a reference to a list containing 3 items:
	0: a string
	1: a string
	2: a string
$fields is a reference to a list where each element is a string
$return is a reference to a hash where the key is a string and the value is a fields_Compartment
fields_Compartment is a reference to a hash where the following keys are defined:
	id has a value which is a string
	abbr has a value which is a string
	mod_date has a value which is a string
	name has a value which is a string
	msid has a value which is a string


=end text



=item Description



=back

=cut

sub query_entity_Compartment
{
    my $self = shift;
    my($qry, $fields) = @_;

    my @_bad_arguments;
    (ref($qry) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"qry\" (value was \"$qry\")");
    (ref($fields) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"fields\" (value was \"$fields\")");
    if (@_bad_arguments) {
	my $msg = "Invalid arguments passed to query_entity_Compartment:\n" . join("", map { "\t$_\n" } @_bad_arguments);
	Bio::KBase::Exceptions::ArgumentValidationError->throw(error => $msg,
							       method_name => 'query_entity_Compartment');
    }

    my $ctx = $Bio::KBase::CDMI::Service::CallContext;
    my($return);
    #BEGIN query_entity_Compartment

    $return = $self->_query_entity($ctx, 'Compartment', $qry, $fields);

    #END query_entity_Compartment
    my @_bad_returns;
    (ref($return) eq 'HASH') or push(@_bad_returns, "Invalid type for return variable \"return\" (value was \"$return\")");
    if (@_bad_returns) {
	my $msg = "Invalid returns passed to query_entity_Compartment:\n" . join("", map { "\t$_\n" } @_bad_returns);
	Bio::KBase::Exceptions::ArgumentValidationError->throw(error => $msg,
							       method_name => 'query_entity_Compartment');
    }
    return($return);
}




=head2 all_entities_Compartment

  $return = $obj->all_entities_Compartment($start, $count, $fields)

=over 4

=item Parameter and return types

=begin html

<pre>
$start is an int
$count is an int
$fields is a reference to a list where each element is a string
$return is a reference to a hash where the key is a string and the value is a fields_Compartment
fields_Compartment is a reference to a hash where the following keys are defined:
	id has a value which is a string
	abbr has a value which is a string
	mod_date has a value which is a string
	name has a value which is a string
	msid has a value which is a string

</pre>

=end html

=begin text

$start is an int
$count is an int
$fields is a reference to a list where each element is a string
$return is a reference to a hash where the key is a string and the value is a fields_Compartment
fields_Compartment is a reference to a hash where the following keys are defined:
	id has a value which is a string
	abbr has a value which is a string
	mod_date has a value which is a string
	name has a value which is a string
	msid has a value which is a string


=end text



=item Description



=back

=cut

sub all_entities_Compartment
{
    my $self = shift;
    my($start, $count, $fields) = @_;

    my @_bad_arguments;
    (!ref($start)) or push(@_bad_arguments, "Invalid type for argument \"start\" (value was \"$start\")");
    (!ref($count)) or push(@_bad_arguments, "Invalid type for argument \"count\" (value was \"$count\")");
    (ref($fields) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"fields\" (value was \"$fields\")");
    if (@_bad_arguments) {
	my $msg = "Invalid arguments passed to all_entities_Compartment:\n" . join("", map { "\t$_\n" } @_bad_arguments);
	Bio::KBase::Exceptions::ArgumentValidationError->throw(error => $msg,
							       method_name => 'all_entities_Compartment');
    }

    my $ctx = $Bio::KBase::CDMI::Service::CallContext;
    my($return);
    #BEGIN all_entities_Compartment

    $return = $self->_all_entities($ctx, 'Compartment', $start, $count, $fields);

    #END all_entities_Compartment
    my @_bad_returns;
    (ref($return) eq 'HASH') or push(@_bad_returns, "Invalid type for return variable \"return\" (value was \"$return\")");
    if (@_bad_returns) {
	my $msg = "Invalid returns passed to all_entities_Compartment:\n" . join("", map { "\t$_\n" } @_bad_returns);
	Bio::KBase::Exceptions::ArgumentValidationError->throw(error => $msg,
							       method_name => 'all_entities_Compartment');
    }
    return($return);
}




=head2 get_entity_Complex

  $return = $obj->get_entity_Complex($ids, $fields)

=over 4

=item Parameter and return types

=begin html

<pre>
$ids is a reference to a list where each element is a string
$fields is a reference to a list where each element is a string
$return is a reference to a hash where the key is a string and the value is a fields_Complex
fields_Complex is a reference to a hash where the following keys are defined:
	id has a value which is a string
	name has a value which is a reference to a list where each element is a string
	msid has a value which is a string
	mod_date has a value which is a string

</pre>

=end html

=begin text

$ids is a reference to a list where each element is a string
$fields is a reference to a list where each element is a string
$return is a reference to a hash where the key is a string and the value is a fields_Complex
fields_Complex is a reference to a hash where the following keys are defined:
	id has a value which is a string
	name has a value which is a reference to a list where each element is a string
	msid has a value which is a string
	mod_date has a value which is a string


=end text



=item Description

A complex is a set of chemical reactions that act in concert to
effect a role.
It has the following fields:

=over 4


=item name

name of this complex. Not all complexes have names.


=item msid

common modeling ID of this complex.


=item mod_date

date and time of the last change to this complex's definition



=back

=back

=cut

sub get_entity_Complex
{
    my $self = shift;
    my($ids, $fields) = @_;

    my @_bad_arguments;
    (ref($ids) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"ids\" (value was \"$ids\")");
    (ref($fields) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"fields\" (value was \"$fields\")");
    if (@_bad_arguments) {
	my $msg = "Invalid arguments passed to get_entity_Complex:\n" . join("", map { "\t$_\n" } @_bad_arguments);
	Bio::KBase::Exceptions::ArgumentValidationError->throw(error => $msg,
							       method_name => 'get_entity_Complex');
    }

    my $ctx = $Bio::KBase::CDMI::Service::CallContext;
    my($return);
    #BEGIN get_entity_Complex

    $return = $self->_get_entity($ctx, 'Complex', $ids, $fields);

    #END get_entity_Complex
    my @_bad_returns;
    (ref($return) eq 'HASH') or push(@_bad_returns, "Invalid type for return variable \"return\" (value was \"$return\")");
    if (@_bad_returns) {
	my $msg = "Invalid returns passed to get_entity_Complex:\n" . join("", map { "\t$_\n" } @_bad_returns);
	Bio::KBase::Exceptions::ArgumentValidationError->throw(error => $msg,
							       method_name => 'get_entity_Complex');
    }
    return($return);
}




=head2 query_entity_Complex

  $return = $obj->query_entity_Complex($qry, $fields)

=over 4

=item Parameter and return types

=begin html

<pre>
$qry is a reference to a list where each element is a reference to a list containing 3 items:
	0: a string
	1: a string
	2: a string
$fields is a reference to a list where each element is a string
$return is a reference to a hash where the key is a string and the value is a fields_Complex
fields_Complex is a reference to a hash where the following keys are defined:
	id has a value which is a string
	name has a value which is a reference to a list where each element is a string
	msid has a value which is a string
	mod_date has a value which is a string

</pre>

=end html

=begin text

$qry is a reference to a list where each element is a reference to a list containing 3 items:
	0: a string
	1: a string
	2: a string
$fields is a reference to a list where each element is a string
$return is a reference to a hash where the key is a string and the value is a fields_Complex
fields_Complex is a reference to a hash where the following keys are defined:
	id has a value which is a string
	name has a value which is a reference to a list where each element is a string
	msid has a value which is a string
	mod_date has a value which is a string


=end text



=item Description



=back

=cut

sub query_entity_Complex
{
    my $self = shift;
    my($qry, $fields) = @_;

    my @_bad_arguments;
    (ref($qry) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"qry\" (value was \"$qry\")");
    (ref($fields) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"fields\" (value was \"$fields\")");
    if (@_bad_arguments) {
	my $msg = "Invalid arguments passed to query_entity_Complex:\n" . join("", map { "\t$_\n" } @_bad_arguments);
	Bio::KBase::Exceptions::ArgumentValidationError->throw(error => $msg,
							       method_name => 'query_entity_Complex');
    }

    my $ctx = $Bio::KBase::CDMI::Service::CallContext;
    my($return);
    #BEGIN query_entity_Complex

    $return = $self->_query_entity($ctx, 'Complex', $qry, $fields);

    #END query_entity_Complex
    my @_bad_returns;
    (ref($return) eq 'HASH') or push(@_bad_returns, "Invalid type for return variable \"return\" (value was \"$return\")");
    if (@_bad_returns) {
	my $msg = "Invalid returns passed to query_entity_Complex:\n" . join("", map { "\t$_\n" } @_bad_returns);
	Bio::KBase::Exceptions::ArgumentValidationError->throw(error => $msg,
							       method_name => 'query_entity_Complex');
    }
    return($return);
}




=head2 all_entities_Complex

  $return = $obj->all_entities_Complex($start, $count, $fields)

=over 4

=item Parameter and return types

=begin html

<pre>
$start is an int
$count is an int
$fields is a reference to a list where each element is a string
$return is a reference to a hash where the key is a string and the value is a fields_Complex
fields_Complex is a reference to a hash where the following keys are defined:
	id has a value which is a string
	name has a value which is a reference to a list where each element is a string
	msid has a value which is a string
	mod_date has a value which is a string

</pre>

=end html

=begin text

$start is an int
$count is an int
$fields is a reference to a list where each element is a string
$return is a reference to a hash where the key is a string and the value is a fields_Complex
fields_Complex is a reference to a hash where the following keys are defined:
	id has a value which is a string
	name has a value which is a reference to a list where each element is a string
	msid has a value which is a string
	mod_date has a value which is a string


=end text



=item Description



=back

=cut

sub all_entities_Complex
{
    my $self = shift;
    my($start, $count, $fields) = @_;

    my @_bad_arguments;
    (!ref($start)) or push(@_bad_arguments, "Invalid type for argument \"start\" (value was \"$start\")");
    (!ref($count)) or push(@_bad_arguments, "Invalid type for argument \"count\" (value was \"$count\")");
    (ref($fields) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"fields\" (value was \"$fields\")");
    if (@_bad_arguments) {
	my $msg = "Invalid arguments passed to all_entities_Complex:\n" . join("", map { "\t$_\n" } @_bad_arguments);
	Bio::KBase::Exceptions::ArgumentValidationError->throw(error => $msg,
							       method_name => 'all_entities_Complex');
    }

    my $ctx = $Bio::KBase::CDMI::Service::CallContext;
    my($return);
    #BEGIN all_entities_Complex

    $return = $self->_all_entities($ctx, 'Complex', $start, $count, $fields);

    #END all_entities_Complex
    my @_bad_returns;
    (ref($return) eq 'HASH') or push(@_bad_returns, "Invalid type for return variable \"return\" (value was \"$return\")");
    if (@_bad_returns) {
	my $msg = "Invalid returns passed to all_entities_Complex:\n" . join("", map { "\t$_\n" } @_bad_returns);
	Bio::KBase::Exceptions::ArgumentValidationError->throw(error => $msg,
							       method_name => 'all_entities_Complex');
    }
    return($return);
}




=head2 get_entity_Compound

  $return = $obj->get_entity_Compound($ids, $fields)

=over 4

=item Parameter and return types

=begin html

<pre>
$ids is a reference to a list where each element is a string
$fields is a reference to a list where each element is a string
$return is a reference to a hash where the key is a string and the value is a fields_Compound
fields_Compound is a reference to a hash where the following keys are defined:
	id has a value which is a string
	label has a value which is a string
	abbr has a value which is a string
	msid has a value which is a string
	ubiquitous has a value which is an int
	mod_date has a value which is a string
	uncharged_formula has a value which is a string
	formula has a value which is a string
	mass has a value which is a float

</pre>

=end html

=begin text

$ids is a reference to a list where each element is a string
$fields is a reference to a list where each element is a string
$return is a reference to a hash where the key is a string and the value is a fields_Compound
fields_Compound is a reference to a hash where the following keys are defined:
	id has a value which is a string
	label has a value which is a string
	abbr has a value which is a string
	msid has a value which is a string
	ubiquitous has a value which is an int
	mod_date has a value which is a string
	uncharged_formula has a value which is a string
	formula has a value which is a string
	mass has a value which is a float


=end text



=item Description

A compound is a chemical that participates in a reaction. Both
ligands and reaction components are treated as compounds.
It has the following fields:

=over 4


=item label

primary name of the compound, for use in displaying
reactions


=item abbr

shortened abbreviation for the compound name


=item msid

common modeling ID of this compound


=item ubiquitous

TRUE if this compound is found in most reactions, else FALSE


=item mod_date

date and time of the last modification to the
compound definition


=item uncharged_formula

a electrically neutral formula for the compound


=item formula

a pH-neutral formula for the compound


=item mass

atomic mass of the compound



=back

=back

=cut

sub get_entity_Compound
{
    my $self = shift;
    my($ids, $fields) = @_;

    my @_bad_arguments;
    (ref($ids) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"ids\" (value was \"$ids\")");
    (ref($fields) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"fields\" (value was \"$fields\")");
    if (@_bad_arguments) {
	my $msg = "Invalid arguments passed to get_entity_Compound:\n" . join("", map { "\t$_\n" } @_bad_arguments);
	Bio::KBase::Exceptions::ArgumentValidationError->throw(error => $msg,
							       method_name => 'get_entity_Compound');
    }

    my $ctx = $Bio::KBase::CDMI::Service::CallContext;
    my($return);
    #BEGIN get_entity_Compound

    $return = $self->_get_entity($ctx, 'Compound', $ids, $fields);

    #END get_entity_Compound
    my @_bad_returns;
    (ref($return) eq 'HASH') or push(@_bad_returns, "Invalid type for return variable \"return\" (value was \"$return\")");
    if (@_bad_returns) {
	my $msg = "Invalid returns passed to get_entity_Compound:\n" . join("", map { "\t$_\n" } @_bad_returns);
	Bio::KBase::Exceptions::ArgumentValidationError->throw(error => $msg,
							       method_name => 'get_entity_Compound');
    }
    return($return);
}




=head2 query_entity_Compound

  $return = $obj->query_entity_Compound($qry, $fields)

=over 4

=item Parameter and return types

=begin html

<pre>
$qry is a reference to a list where each element is a reference to a list containing 3 items:
	0: a string
	1: a string
	2: a string
$fields is a reference to a list where each element is a string
$return is a reference to a hash where the key is a string and the value is a fields_Compound
fields_Compound is a reference to a hash where the following keys are defined:
	id has a value which is a string
	label has a value which is a string
	abbr has a value which is a string
	msid has a value which is a string
	ubiquitous has a value which is an int
	mod_date has a value which is a string
	uncharged_formula has a value which is a string
	formula has a value which is a string
	mass has a value which is a float

</pre>

=end html

=begin text

$qry is a reference to a list where each element is a reference to a list containing 3 items:
	0: a string
	1: a string
	2: a string
$fields is a reference to a list where each element is a string
$return is a reference to a hash where the key is a string and the value is a fields_Compound
fields_Compound is a reference to a hash where the following keys are defined:
	id has a value which is a string
	label has a value which is a string
	abbr has a value which is a string
	msid has a value which is a string
	ubiquitous has a value which is an int
	mod_date has a value which is a string
	uncharged_formula has a value which is a string
	formula has a value which is a string
	mass has a value which is a float


=end text



=item Description



=back

=cut

sub query_entity_Compound
{
    my $self = shift;
    my($qry, $fields) = @_;

    my @_bad_arguments;
    (ref($qry) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"qry\" (value was \"$qry\")");
    (ref($fields) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"fields\" (value was \"$fields\")");
    if (@_bad_arguments) {
	my $msg = "Invalid arguments passed to query_entity_Compound:\n" . join("", map { "\t$_\n" } @_bad_arguments);
	Bio::KBase::Exceptions::ArgumentValidationError->throw(error => $msg,
							       method_name => 'query_entity_Compound');
    }

    my $ctx = $Bio::KBase::CDMI::Service::CallContext;
    my($return);
    #BEGIN query_entity_Compound

    $return = $self->_query_entity($ctx, 'Compound', $qry, $fields);

    #END query_entity_Compound
    my @_bad_returns;
    (ref($return) eq 'HASH') or push(@_bad_returns, "Invalid type for return variable \"return\" (value was \"$return\")");
    if (@_bad_returns) {
	my $msg = "Invalid returns passed to query_entity_Compound:\n" . join("", map { "\t$_\n" } @_bad_returns);
	Bio::KBase::Exceptions::ArgumentValidationError->throw(error => $msg,
							       method_name => 'query_entity_Compound');
    }
    return($return);
}




=head2 all_entities_Compound

  $return = $obj->all_entities_Compound($start, $count, $fields)

=over 4

=item Parameter and return types

=begin html

<pre>
$start is an int
$count is an int
$fields is a reference to a list where each element is a string
$return is a reference to a hash where the key is a string and the value is a fields_Compound
fields_Compound is a reference to a hash where the following keys are defined:
	id has a value which is a string
	label has a value which is a string
	abbr has a value which is a string
	msid has a value which is a string
	ubiquitous has a value which is an int
	mod_date has a value which is a string
	uncharged_formula has a value which is a string
	formula has a value which is a string
	mass has a value which is a float

</pre>

=end html

=begin text

$start is an int
$count is an int
$fields is a reference to a list where each element is a string
$return is a reference to a hash where the key is a string and the value is a fields_Compound
fields_Compound is a reference to a hash where the following keys are defined:
	id has a value which is a string
	label has a value which is a string
	abbr has a value which is a string
	msid has a value which is a string
	ubiquitous has a value which is an int
	mod_date has a value which is a string
	uncharged_formula has a value which is a string
	formula has a value which is a string
	mass has a value which is a float


=end text



=item Description



=back

=cut

sub all_entities_Compound
{
    my $self = shift;
    my($start, $count, $fields) = @_;

    my @_bad_arguments;
    (!ref($start)) or push(@_bad_arguments, "Invalid type for argument \"start\" (value was \"$start\")");
    (!ref($count)) or push(@_bad_arguments, "Invalid type for argument \"count\" (value was \"$count\")");
    (ref($fields) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"fields\" (value was \"$fields\")");
    if (@_bad_arguments) {
	my $msg = "Invalid arguments passed to all_entities_Compound:\n" . join("", map { "\t$_\n" } @_bad_arguments);
	Bio::KBase::Exceptions::ArgumentValidationError->throw(error => $msg,
							       method_name => 'all_entities_Compound');
    }

    my $ctx = $Bio::KBase::CDMI::Service::CallContext;
    my($return);
    #BEGIN all_entities_Compound

    $return = $self->_all_entities($ctx, 'Compound', $start, $count, $fields);

    #END all_entities_Compound
    my @_bad_returns;
    (ref($return) eq 'HASH') or push(@_bad_returns, "Invalid type for return variable \"return\" (value was \"$return\")");
    if (@_bad_returns) {
	my $msg = "Invalid returns passed to all_entities_Compound:\n" . join("", map { "\t$_\n" } @_bad_returns);
	Bio::KBase::Exceptions::ArgumentValidationError->throw(error => $msg,
							       method_name => 'all_entities_Compound');
    }
    return($return);
}




=head2 get_entity_Contig

  $return = $obj->get_entity_Contig($ids, $fields)

=over 4

=item Parameter and return types

=begin html

<pre>
$ids is a reference to a list where each element is a string
$fields is a reference to a list where each element is a string
$return is a reference to a hash where the key is a string and the value is a fields_Contig
fields_Contig is a reference to a hash where the following keys are defined:
	id has a value which is a string
	source_id has a value which is a string

</pre>

=end html

=begin text

$ids is a reference to a list where each element is a string
$fields is a reference to a list where each element is a string
$return is a reference to a hash where the key is a string and the value is a fields_Contig
fields_Contig is a reference to a hash where the following keys are defined:
	id has a value which is a string
	source_id has a value which is a string


=end text



=item Description

A contig is thought of as composing a part of the DNA associated with a specific
genome.  It is represented as an ID (including the genome ID) and a ContigSequence.
We do not think of strings of DNA from, say, a metgenomic sample as "contigs",
since there is no associated genome (these would be considered ContigSequences).
This use of the term "ContigSequence", rather than just "DNA sequence", may turn out
to be a bad idea.  For now, you should just realize that a Contig has an associated
genome, but a ContigSequence does not.

It has the following fields:

=over 4


=item source_id

ID of this contig from the core (source) database



=back

=back

=cut

sub get_entity_Contig
{
    my $self = shift;
    my($ids, $fields) = @_;

    my @_bad_arguments;
    (ref($ids) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"ids\" (value was \"$ids\")");
    (ref($fields) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"fields\" (value was \"$fields\")");
    if (@_bad_arguments) {
	my $msg = "Invalid arguments passed to get_entity_Contig:\n" . join("", map { "\t$_\n" } @_bad_arguments);
	Bio::KBase::Exceptions::ArgumentValidationError->throw(error => $msg,
							       method_name => 'get_entity_Contig');
    }

    my $ctx = $Bio::KBase::CDMI::Service::CallContext;
    my($return);
    #BEGIN get_entity_Contig

    $return = $self->_get_entity($ctx, 'Contig', $ids, $fields);

    #END get_entity_Contig
    my @_bad_returns;
    (ref($return) eq 'HASH') or push(@_bad_returns, "Invalid type for return variable \"return\" (value was \"$return\")");
    if (@_bad_returns) {
	my $msg = "Invalid returns passed to get_entity_Contig:\n" . join("", map { "\t$_\n" } @_bad_returns);
	Bio::KBase::Exceptions::ArgumentValidationError->throw(error => $msg,
							       method_name => 'get_entity_Contig');
    }
    return($return);
}




=head2 query_entity_Contig

  $return = $obj->query_entity_Contig($qry, $fields)

=over 4

=item Parameter and return types

=begin html

<pre>
$qry is a reference to a list where each element is a reference to a list containing 3 items:
	0: a string
	1: a string
	2: a string
$fields is a reference to a list where each element is a string
$return is a reference to a hash where the key is a string and the value is a fields_Contig
fields_Contig is a reference to a hash where the following keys are defined:
	id has a value which is a string
	source_id has a value which is a string

</pre>

=end html

=begin text

$qry is a reference to a list where each element is a reference to a list containing 3 items:
	0: a string
	1: a string
	2: a string
$fields is a reference to a list where each element is a string
$return is a reference to a hash where the key is a string and the value is a fields_Contig
fields_Contig is a reference to a hash where the following keys are defined:
	id has a value which is a string
	source_id has a value which is a string


=end text



=item Description



=back

=cut

sub query_entity_Contig
{
    my $self = shift;
    my($qry, $fields) = @_;

    my @_bad_arguments;
    (ref($qry) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"qry\" (value was \"$qry\")");
    (ref($fields) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"fields\" (value was \"$fields\")");
    if (@_bad_arguments) {
	my $msg = "Invalid arguments passed to query_entity_Contig:\n" . join("", map { "\t$_\n" } @_bad_arguments);
	Bio::KBase::Exceptions::ArgumentValidationError->throw(error => $msg,
							       method_name => 'query_entity_Contig');
    }

    my $ctx = $Bio::KBase::CDMI::Service::CallContext;
    my($return);
    #BEGIN query_entity_Contig

    $return = $self->_query_entity($ctx, 'Contig', $qry, $fields);

    #END query_entity_Contig
    my @_bad_returns;
    (ref($return) eq 'HASH') or push(@_bad_returns, "Invalid type for return variable \"return\" (value was \"$return\")");
    if (@_bad_returns) {
	my $msg = "Invalid returns passed to query_entity_Contig:\n" . join("", map { "\t$_\n" } @_bad_returns);
	Bio::KBase::Exceptions::ArgumentValidationError->throw(error => $msg,
							       method_name => 'query_entity_Contig');
    }
    return($return);
}




=head2 all_entities_Contig

  $return = $obj->all_entities_Contig($start, $count, $fields)

=over 4

=item Parameter and return types

=begin html

<pre>
$start is an int
$count is an int
$fields is a reference to a list where each element is a string
$return is a reference to a hash where the key is a string and the value is a fields_Contig
fields_Contig is a reference to a hash where the following keys are defined:
	id has a value which is a string
	source_id has a value which is a string

</pre>

=end html

=begin text

$start is an int
$count is an int
$fields is a reference to a list where each element is a string
$return is a reference to a hash where the key is a string and the value is a fields_Contig
fields_Contig is a reference to a hash where the following keys are defined:
	id has a value which is a string
	source_id has a value which is a string


=end text



=item Description



=back

=cut

sub all_entities_Contig
{
    my $self = shift;
    my($start, $count, $fields) = @_;

    my @_bad_arguments;
    (!ref($start)) or push(@_bad_arguments, "Invalid type for argument \"start\" (value was \"$start\")");
    (!ref($count)) or push(@_bad_arguments, "Invalid type for argument \"count\" (value was \"$count\")");
    (ref($fields) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"fields\" (value was \"$fields\")");
    if (@_bad_arguments) {
	my $msg = "Invalid arguments passed to all_entities_Contig:\n" . join("", map { "\t$_\n" } @_bad_arguments);
	Bio::KBase::Exceptions::ArgumentValidationError->throw(error => $msg,
							       method_name => 'all_entities_Contig');
    }

    my $ctx = $Bio::KBase::CDMI::Service::CallContext;
    my($return);
    #BEGIN all_entities_Contig

    $return = $self->_all_entities($ctx, 'Contig', $start, $count, $fields);

    #END all_entities_Contig
    my @_bad_returns;
    (ref($return) eq 'HASH') or push(@_bad_returns, "Invalid type for return variable \"return\" (value was \"$return\")");
    if (@_bad_returns) {
	my $msg = "Invalid returns passed to all_entities_Contig:\n" . join("", map { "\t$_\n" } @_bad_returns);
	Bio::KBase::Exceptions::ArgumentValidationError->throw(error => $msg,
							       method_name => 'all_entities_Contig');
    }
    return($return);
}




=head2 get_entity_ContigChunk

  $return = $obj->get_entity_ContigChunk($ids, $fields)

=over 4

=item Parameter and return types

=begin html

<pre>
$ids is a reference to a list where each element is a string
$fields is a reference to a list where each element is a string
$return is a reference to a hash where the key is a string and the value is a fields_ContigChunk
fields_ContigChunk is a reference to a hash where the following keys are defined:
	id has a value which is a string
	sequence has a value which is a string

</pre>

=end html

=begin text

$ids is a reference to a list where each element is a string
$fields is a reference to a list where each element is a string
$return is a reference to a hash where the key is a string and the value is a fields_ContigChunk
fields_ContigChunk is a reference to a hash where the following keys are defined:
	id has a value which is a string
	sequence has a value which is a string


=end text



=item Description

ContigChunks are strings of DNA thought of as being a string in a 4-character alphabet
with an associated ID.  We allow a broader alphabet that includes U (for RNA) and
the standard ambiguity characters.
The notion of ContigChunk was introduced to avoid transferring/manipulating
huge contigs to access small substrings.  A ContigSequence is formed by
concatenating a set of one or more ContigChunks.  Thus, ContigChunks are the
basic units moved from the database to memory.  Their existence should be
hidden from users in most circumstances (users are expected to request
substrings of ContigSequences, and the Kbase software locates the appropriate
ContigChunks).

It has the following fields:

=over 4


=item sequence

base pairs that make up this sequence



=back

=back

=cut

sub get_entity_ContigChunk
{
    my $self = shift;
    my($ids, $fields) = @_;

    my @_bad_arguments;
    (ref($ids) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"ids\" (value was \"$ids\")");
    (ref($fields) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"fields\" (value was \"$fields\")");
    if (@_bad_arguments) {
	my $msg = "Invalid arguments passed to get_entity_ContigChunk:\n" . join("", map { "\t$_\n" } @_bad_arguments);
	Bio::KBase::Exceptions::ArgumentValidationError->throw(error => $msg,
							       method_name => 'get_entity_ContigChunk');
    }

    my $ctx = $Bio::KBase::CDMI::Service::CallContext;
    my($return);
    #BEGIN get_entity_ContigChunk

    $return = $self->_get_entity($ctx, 'ContigChunk', $ids, $fields);

    #END get_entity_ContigChunk
    my @_bad_returns;
    (ref($return) eq 'HASH') or push(@_bad_returns, "Invalid type for return variable \"return\" (value was \"$return\")");
    if (@_bad_returns) {
	my $msg = "Invalid returns passed to get_entity_ContigChunk:\n" . join("", map { "\t$_\n" } @_bad_returns);
	Bio::KBase::Exceptions::ArgumentValidationError->throw(error => $msg,
							       method_name => 'get_entity_ContigChunk');
    }
    return($return);
}




=head2 query_entity_ContigChunk

  $return = $obj->query_entity_ContigChunk($qry, $fields)

=over 4

=item Parameter and return types

=begin html

<pre>
$qry is a reference to a list where each element is a reference to a list containing 3 items:
	0: a string
	1: a string
	2: a string
$fields is a reference to a list where each element is a string
$return is a reference to a hash where the key is a string and the value is a fields_ContigChunk
fields_ContigChunk is a reference to a hash where the following keys are defined:
	id has a value which is a string
	sequence has a value which is a string

</pre>

=end html

=begin text

$qry is a reference to a list where each element is a reference to a list containing 3 items:
	0: a string
	1: a string
	2: a string
$fields is a reference to a list where each element is a string
$return is a reference to a hash where the key is a string and the value is a fields_ContigChunk
fields_ContigChunk is a reference to a hash where the following keys are defined:
	id has a value which is a string
	sequence has a value which is a string


=end text



=item Description



=back

=cut

sub query_entity_ContigChunk
{
    my $self = shift;
    my($qry, $fields) = @_;

    my @_bad_arguments;
    (ref($qry) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"qry\" (value was \"$qry\")");
    (ref($fields) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"fields\" (value was \"$fields\")");
    if (@_bad_arguments) {
	my $msg = "Invalid arguments passed to query_entity_ContigChunk:\n" . join("", map { "\t$_\n" } @_bad_arguments);
	Bio::KBase::Exceptions::ArgumentValidationError->throw(error => $msg,
							       method_name => 'query_entity_ContigChunk');
    }

    my $ctx = $Bio::KBase::CDMI::Service::CallContext;
    my($return);
    #BEGIN query_entity_ContigChunk

    $return = $self->_query_entity($ctx, 'ContigChunk', $qry, $fields);

    #END query_entity_ContigChunk
    my @_bad_returns;
    (ref($return) eq 'HASH') or push(@_bad_returns, "Invalid type for return variable \"return\" (value was \"$return\")");
    if (@_bad_returns) {
	my $msg = "Invalid returns passed to query_entity_ContigChunk:\n" . join("", map { "\t$_\n" } @_bad_returns);
	Bio::KBase::Exceptions::ArgumentValidationError->throw(error => $msg,
							       method_name => 'query_entity_ContigChunk');
    }
    return($return);
}




=head2 all_entities_ContigChunk

  $return = $obj->all_entities_ContigChunk($start, $count, $fields)

=over 4

=item Parameter and return types

=begin html

<pre>
$start is an int
$count is an int
$fields is a reference to a list where each element is a string
$return is a reference to a hash where the key is a string and the value is a fields_ContigChunk
fields_ContigChunk is a reference to a hash where the following keys are defined:
	id has a value which is a string
	sequence has a value which is a string

</pre>

=end html

=begin text

$start is an int
$count is an int
$fields is a reference to a list where each element is a string
$return is a reference to a hash where the key is a string and the value is a fields_ContigChunk
fields_ContigChunk is a reference to a hash where the following keys are defined:
	id has a value which is a string
	sequence has a value which is a string


=end text



=item Description



=back

=cut

sub all_entities_ContigChunk
{
    my $self = shift;
    my($start, $count, $fields) = @_;

    my @_bad_arguments;
    (!ref($start)) or push(@_bad_arguments, "Invalid type for argument \"start\" (value was \"$start\")");
    (!ref($count)) or push(@_bad_arguments, "Invalid type for argument \"count\" (value was \"$count\")");
    (ref($fields) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"fields\" (value was \"$fields\")");
    if (@_bad_arguments) {
	my $msg = "Invalid arguments passed to all_entities_ContigChunk:\n" . join("", map { "\t$_\n" } @_bad_arguments);
	Bio::KBase::Exceptions::ArgumentValidationError->throw(error => $msg,
							       method_name => 'all_entities_ContigChunk');
    }

    my $ctx = $Bio::KBase::CDMI::Service::CallContext;
    my($return);
    #BEGIN all_entities_ContigChunk

    $return = $self->_all_entities($ctx, 'ContigChunk', $start, $count, $fields);

    #END all_entities_ContigChunk
    my @_bad_returns;
    (ref($return) eq 'HASH') or push(@_bad_returns, "Invalid type for return variable \"return\" (value was \"$return\")");
    if (@_bad_returns) {
	my $msg = "Invalid returns passed to all_entities_ContigChunk:\n" . join("", map { "\t$_\n" } @_bad_returns);
	Bio::KBase::Exceptions::ArgumentValidationError->throw(error => $msg,
							       method_name => 'all_entities_ContigChunk');
    }
    return($return);
}




=head2 get_entity_ContigSequence

  $return = $obj->get_entity_ContigSequence($ids, $fields)

=over 4

=item Parameter and return types

=begin html

<pre>
$ids is a reference to a list where each element is a string
$fields is a reference to a list where each element is a string
$return is a reference to a hash where the key is a string and the value is a fields_ContigSequence
fields_ContigSequence is a reference to a hash where the following keys are defined:
	id has a value which is a string
	length has a value which is an int

</pre>

=end html

=begin text

$ids is a reference to a list where each element is a string
$fields is a reference to a list where each element is a string
$return is a reference to a hash where the key is a string and the value is a fields_ContigSequence
fields_ContigSequence is a reference to a hash where the following keys are defined:
	id has a value which is a string
	length has a value which is an int


=end text



=item Description

ContigSequences are strings of DNA.  Contigs have an associated
genome, but ContigSequences do not..   We can think of random samples of DNA as a set of ContigSequences.
There are no length constraints imposed on ContigSequences -- they can be either
very short or very long.  The basic unit of data that is moved to/from the database
is the ContigChunk, from which ContigSequences are formed. The key
of a ContigSequence is the sequence's MD5 identifier.

It has the following fields:

=over 4


=item length

number of base pairs in the contig



=back

=back

=cut

sub get_entity_ContigSequence
{
    my $self = shift;
    my($ids, $fields) = @_;

    my @_bad_arguments;
    (ref($ids) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"ids\" (value was \"$ids\")");
    (ref($fields) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"fields\" (value was \"$fields\")");
    if (@_bad_arguments) {
	my $msg = "Invalid arguments passed to get_entity_ContigSequence:\n" . join("", map { "\t$_\n" } @_bad_arguments);
	Bio::KBase::Exceptions::ArgumentValidationError->throw(error => $msg,
							       method_name => 'get_entity_ContigSequence');
    }

    my $ctx = $Bio::KBase::CDMI::Service::CallContext;
    my($return);
    #BEGIN get_entity_ContigSequence

    $return = $self->_get_entity($ctx, 'ContigSequence', $ids, $fields);

    #END get_entity_ContigSequence
    my @_bad_returns;
    (ref($return) eq 'HASH') or push(@_bad_returns, "Invalid type for return variable \"return\" (value was \"$return\")");
    if (@_bad_returns) {
	my $msg = "Invalid returns passed to get_entity_ContigSequence:\n" . join("", map { "\t$_\n" } @_bad_returns);
	Bio::KBase::Exceptions::ArgumentValidationError->throw(error => $msg,
							       method_name => 'get_entity_ContigSequence');
    }
    return($return);
}




=head2 query_entity_ContigSequence

  $return = $obj->query_entity_ContigSequence($qry, $fields)

=over 4

=item Parameter and return types

=begin html

<pre>
$qry is a reference to a list where each element is a reference to a list containing 3 items:
	0: a string
	1: a string
	2: a string
$fields is a reference to a list where each element is a string
$return is a reference to a hash where the key is a string and the value is a fields_ContigSequence
fields_ContigSequence is a reference to a hash where the following keys are defined:
	id has a value which is a string
	length has a value which is an int

</pre>

=end html

=begin text

$qry is a reference to a list where each element is a reference to a list containing 3 items:
	0: a string
	1: a string
	2: a string
$fields is a reference to a list where each element is a string
$return is a reference to a hash where the key is a string and the value is a fields_ContigSequence
fields_ContigSequence is a reference to a hash where the following keys are defined:
	id has a value which is a string
	length has a value which is an int


=end text



=item Description



=back

=cut

sub query_entity_ContigSequence
{
    my $self = shift;
    my($qry, $fields) = @_;

    my @_bad_arguments;
    (ref($qry) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"qry\" (value was \"$qry\")");
    (ref($fields) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"fields\" (value was \"$fields\")");
    if (@_bad_arguments) {
	my $msg = "Invalid arguments passed to query_entity_ContigSequence:\n" . join("", map { "\t$_\n" } @_bad_arguments);
	Bio::KBase::Exceptions::ArgumentValidationError->throw(error => $msg,
							       method_name => 'query_entity_ContigSequence');
    }

    my $ctx = $Bio::KBase::CDMI::Service::CallContext;
    my($return);
    #BEGIN query_entity_ContigSequence

    $return = $self->_query_entity($ctx, 'ContigSequence', $qry, $fields);

    #END query_entity_ContigSequence
    my @_bad_returns;
    (ref($return) eq 'HASH') or push(@_bad_returns, "Invalid type for return variable \"return\" (value was \"$return\")");
    if (@_bad_returns) {
	my $msg = "Invalid returns passed to query_entity_ContigSequence:\n" . join("", map { "\t$_\n" } @_bad_returns);
	Bio::KBase::Exceptions::ArgumentValidationError->throw(error => $msg,
							       method_name => 'query_entity_ContigSequence');
    }
    return($return);
}




=head2 all_entities_ContigSequence

  $return = $obj->all_entities_ContigSequence($start, $count, $fields)

=over 4

=item Parameter and return types

=begin html

<pre>
$start is an int
$count is an int
$fields is a reference to a list where each element is a string
$return is a reference to a hash where the key is a string and the value is a fields_ContigSequence
fields_ContigSequence is a reference to a hash where the following keys are defined:
	id has a value which is a string
	length has a value which is an int

</pre>

=end html

=begin text

$start is an int
$count is an int
$fields is a reference to a list where each element is a string
$return is a reference to a hash where the key is a string and the value is a fields_ContigSequence
fields_ContigSequence is a reference to a hash where the following keys are defined:
	id has a value which is a string
	length has a value which is an int


=end text



=item Description



=back

=cut

sub all_entities_ContigSequence
{
    my $self = shift;
    my($start, $count, $fields) = @_;

    my @_bad_arguments;
    (!ref($start)) or push(@_bad_arguments, "Invalid type for argument \"start\" (value was \"$start\")");
    (!ref($count)) or push(@_bad_arguments, "Invalid type for argument \"count\" (value was \"$count\")");
    (ref($fields) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"fields\" (value was \"$fields\")");
    if (@_bad_arguments) {
	my $msg = "Invalid arguments passed to all_entities_ContigSequence:\n" . join("", map { "\t$_\n" } @_bad_arguments);
	Bio::KBase::Exceptions::ArgumentValidationError->throw(error => $msg,
							       method_name => 'all_entities_ContigSequence');
    }

    my $ctx = $Bio::KBase::CDMI::Service::CallContext;
    my($return);
    #BEGIN all_entities_ContigSequence

    $return = $self->_all_entities($ctx, 'ContigSequence', $start, $count, $fields);

    #END all_entities_ContigSequence
    my @_bad_returns;
    (ref($return) eq 'HASH') or push(@_bad_returns, "Invalid type for return variable \"return\" (value was \"$return\")");
    if (@_bad_returns) {
	my $msg = "Invalid returns passed to all_entities_ContigSequence:\n" . join("", map { "\t$_\n" } @_bad_returns);
	Bio::KBase::Exceptions::ArgumentValidationError->throw(error => $msg,
							       method_name => 'all_entities_ContigSequence');
    }
    return($return);
}




=head2 get_entity_CoregulatedSet

  $return = $obj->get_entity_CoregulatedSet($ids, $fields)

=over 4

=item Parameter and return types

=begin html

<pre>
$ids is a reference to a list where each element is a string
$fields is a reference to a list where each element is a string
$return is a reference to a hash where the key is a string and the value is a fields_CoregulatedSet
fields_CoregulatedSet is a reference to a hash where the following keys are defined:
	id has a value which is a string
	source_id has a value which is a string
	binding_location has a value which is a reference to a list where each element is an int

</pre>

=end html

=begin text

$ids is a reference to a list where each element is a string
$fields is a reference to a list where each element is a string
$return is a reference to a hash where the key is a string and the value is a fields_CoregulatedSet
fields_CoregulatedSet is a reference to a hash where the following keys are defined:
	id has a value which is a string
	source_id has a value which is a string
	binding_location has a value which is a reference to a list where each element is an int


=end text



=item Description

We need to represent sets of genes that are coregulated via some
regulatory mechanism.  In particular, we wish to represent genes
that are coregulated using transcription binding sites and
corresponding transcription regulatory proteins.
We represent a coregulated set (which may, or may not, be considered
a regulon) using CoregulatedSet.

It has the following fields:

=over 4


=item source_id

original ID of this coregulated set in the source (core)
database


=item binding_location

binding location for this set's transcription factor;
there may be none of these or there may be more than one



=back

=back

=cut

sub get_entity_CoregulatedSet
{
    my $self = shift;
    my($ids, $fields) = @_;

    my @_bad_arguments;
    (ref($ids) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"ids\" (value was \"$ids\")");
    (ref($fields) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"fields\" (value was \"$fields\")");
    if (@_bad_arguments) {
	my $msg = "Invalid arguments passed to get_entity_CoregulatedSet:\n" . join("", map { "\t$_\n" } @_bad_arguments);
	Bio::KBase::Exceptions::ArgumentValidationError->throw(error => $msg,
							       method_name => 'get_entity_CoregulatedSet');
    }

    my $ctx = $Bio::KBase::CDMI::Service::CallContext;
    my($return);
    #BEGIN get_entity_CoregulatedSet

    $return = $self->_get_entity($ctx, 'CoregulatedSet', $ids, $fields);

    #END get_entity_CoregulatedSet
    my @_bad_returns;
    (ref($return) eq 'HASH') or push(@_bad_returns, "Invalid type for return variable \"return\" (value was \"$return\")");
    if (@_bad_returns) {
	my $msg = "Invalid returns passed to get_entity_CoregulatedSet:\n" . join("", map { "\t$_\n" } @_bad_returns);
	Bio::KBase::Exceptions::ArgumentValidationError->throw(error => $msg,
							       method_name => 'get_entity_CoregulatedSet');
    }
    return($return);
}




=head2 query_entity_CoregulatedSet

  $return = $obj->query_entity_CoregulatedSet($qry, $fields)

=over 4

=item Parameter and return types

=begin html

<pre>
$qry is a reference to a list where each element is a reference to a list containing 3 items:
	0: a string
	1: a string
	2: a string
$fields is a reference to a list where each element is a string
$return is a reference to a hash where the key is a string and the value is a fields_CoregulatedSet
fields_CoregulatedSet is a reference to a hash where the following keys are defined:
	id has a value which is a string
	source_id has a value which is a string
	binding_location has a value which is a reference to a list where each element is an int

</pre>

=end html

=begin text

$qry is a reference to a list where each element is a reference to a list containing 3 items:
	0: a string
	1: a string
	2: a string
$fields is a reference to a list where each element is a string
$return is a reference to a hash where the key is a string and the value is a fields_CoregulatedSet
fields_CoregulatedSet is a reference to a hash where the following keys are defined:
	id has a value which is a string
	source_id has a value which is a string
	binding_location has a value which is a reference to a list where each element is an int


=end text



=item Description



=back

=cut

sub query_entity_CoregulatedSet
{
    my $self = shift;
    my($qry, $fields) = @_;

    my @_bad_arguments;
    (ref($qry) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"qry\" (value was \"$qry\")");
    (ref($fields) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"fields\" (value was \"$fields\")");
    if (@_bad_arguments) {
	my $msg = "Invalid arguments passed to query_entity_CoregulatedSet:\n" . join("", map { "\t$_\n" } @_bad_arguments);
	Bio::KBase::Exceptions::ArgumentValidationError->throw(error => $msg,
							       method_name => 'query_entity_CoregulatedSet');
    }

    my $ctx = $Bio::KBase::CDMI::Service::CallContext;
    my($return);
    #BEGIN query_entity_CoregulatedSet

    $return = $self->_query_entity($ctx, 'CoregulatedSet', $qry, $fields);

    #END query_entity_CoregulatedSet
    my @_bad_returns;
    (ref($return) eq 'HASH') or push(@_bad_returns, "Invalid type for return variable \"return\" (value was \"$return\")");
    if (@_bad_returns) {
	my $msg = "Invalid returns passed to query_entity_CoregulatedSet:\n" . join("", map { "\t$_\n" } @_bad_returns);
	Bio::KBase::Exceptions::ArgumentValidationError->throw(error => $msg,
							       method_name => 'query_entity_CoregulatedSet');
    }
    return($return);
}




=head2 all_entities_CoregulatedSet

  $return = $obj->all_entities_CoregulatedSet($start, $count, $fields)

=over 4

=item Parameter and return types

=begin html

<pre>
$start is an int
$count is an int
$fields is a reference to a list where each element is a string
$return is a reference to a hash where the key is a string and the value is a fields_CoregulatedSet
fields_CoregulatedSet is a reference to a hash where the following keys are defined:
	id has a value which is a string
	source_id has a value which is a string
	binding_location has a value which is a reference to a list where each element is an int

</pre>

=end html

=begin text

$start is an int
$count is an int
$fields is a reference to a list where each element is a string
$return is a reference to a hash where the key is a string and the value is a fields_CoregulatedSet
fields_CoregulatedSet is a reference to a hash where the following keys are defined:
	id has a value which is a string
	source_id has a value which is a string
	binding_location has a value which is a reference to a list where each element is an int


=end text



=item Description



=back

=cut

sub all_entities_CoregulatedSet
{
    my $self = shift;
    my($start, $count, $fields) = @_;

    my @_bad_arguments;
    (!ref($start)) or push(@_bad_arguments, "Invalid type for argument \"start\" (value was \"$start\")");
    (!ref($count)) or push(@_bad_arguments, "Invalid type for argument \"count\" (value was \"$count\")");
    (ref($fields) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"fields\" (value was \"$fields\")");
    if (@_bad_arguments) {
	my $msg = "Invalid arguments passed to all_entities_CoregulatedSet:\n" . join("", map { "\t$_\n" } @_bad_arguments);
	Bio::KBase::Exceptions::ArgumentValidationError->throw(error => $msg,
							       method_name => 'all_entities_CoregulatedSet');
    }

    my $ctx = $Bio::KBase::CDMI::Service::CallContext;
    my($return);
    #BEGIN all_entities_CoregulatedSet

    $return = $self->_all_entities($ctx, 'CoregulatedSet', $start, $count, $fields);

    #END all_entities_CoregulatedSet
    my @_bad_returns;
    (ref($return) eq 'HASH') or push(@_bad_returns, "Invalid type for return variable \"return\" (value was \"$return\")");
    if (@_bad_returns) {
	my $msg = "Invalid returns passed to all_entities_CoregulatedSet:\n" . join("", map { "\t$_\n" } @_bad_returns);
	Bio::KBase::Exceptions::ArgumentValidationError->throw(error => $msg,
							       method_name => 'all_entities_CoregulatedSet');
    }
    return($return);
}




=head2 get_entity_Diagram

  $return = $obj->get_entity_Diagram($ids, $fields)

=over 4

=item Parameter and return types

=begin html

<pre>
$ids is a reference to a list where each element is a string
$fields is a reference to a list where each element is a string
$return is a reference to a hash where the key is a string and the value is a fields_Diagram
fields_Diagram is a reference to a hash where the following keys are defined:
	id has a value which is a string
	name has a value which is a string
	content has a value which is a reference to a list where each element is a string

</pre>

=end html

=begin text

$ids is a reference to a list where each element is a string
$fields is a reference to a list where each element is a string
$return is a reference to a hash where the key is a string and the value is a fields_Diagram
fields_Diagram is a reference to a hash where the following keys are defined:
	id has a value which is a string
	name has a value which is a string
	content has a value which is a reference to a list where each element is a string


=end text



=item Description

A functional diagram describes a network of chemical
reactions, often comprising a single subsystem.
It has the following fields:

=over 4


=item name

descriptive name of this diagram


=item content

content of the diagram, in PNG format



=back

=back

=cut

sub get_entity_Diagram
{
    my $self = shift;
    my($ids, $fields) = @_;

    my @_bad_arguments;
    (ref($ids) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"ids\" (value was \"$ids\")");
    (ref($fields) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"fields\" (value was \"$fields\")");
    if (@_bad_arguments) {
	my $msg = "Invalid arguments passed to get_entity_Diagram:\n" . join("", map { "\t$_\n" } @_bad_arguments);
	Bio::KBase::Exceptions::ArgumentValidationError->throw(error => $msg,
							       method_name => 'get_entity_Diagram');
    }

    my $ctx = $Bio::KBase::CDMI::Service::CallContext;
    my($return);
    #BEGIN get_entity_Diagram

    $return = $self->_get_entity($ctx, 'Diagram', $ids, $fields);

    #END get_entity_Diagram
    my @_bad_returns;
    (ref($return) eq 'HASH') or push(@_bad_returns, "Invalid type for return variable \"return\" (value was \"$return\")");
    if (@_bad_returns) {
	my $msg = "Invalid returns passed to get_entity_Diagram:\n" . join("", map { "\t$_\n" } @_bad_returns);
	Bio::KBase::Exceptions::ArgumentValidationError->throw(error => $msg,
							       method_name => 'get_entity_Diagram');
    }
    return($return);
}




=head2 query_entity_Diagram

  $return = $obj->query_entity_Diagram($qry, $fields)

=over 4

=item Parameter and return types

=begin html

<pre>
$qry is a reference to a list where each element is a reference to a list containing 3 items:
	0: a string
	1: a string
	2: a string
$fields is a reference to a list where each element is a string
$return is a reference to a hash where the key is a string and the value is a fields_Diagram
fields_Diagram is a reference to a hash where the following keys are defined:
	id has a value which is a string
	name has a value which is a string
	content has a value which is a reference to a list where each element is a string

</pre>

=end html

=begin text

$qry is a reference to a list where each element is a reference to a list containing 3 items:
	0: a string
	1: a string
	2: a string
$fields is a reference to a list where each element is a string
$return is a reference to a hash where the key is a string and the value is a fields_Diagram
fields_Diagram is a reference to a hash where the following keys are defined:
	id has a value which is a string
	name has a value which is a string
	content has a value which is a reference to a list where each element is a string


=end text



=item Description



=back

=cut

sub query_entity_Diagram
{
    my $self = shift;
    my($qry, $fields) = @_;

    my @_bad_arguments;
    (ref($qry) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"qry\" (value was \"$qry\")");
    (ref($fields) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"fields\" (value was \"$fields\")");
    if (@_bad_arguments) {
	my $msg = "Invalid arguments passed to query_entity_Diagram:\n" . join("", map { "\t$_\n" } @_bad_arguments);
	Bio::KBase::Exceptions::ArgumentValidationError->throw(error => $msg,
							       method_name => 'query_entity_Diagram');
    }

    my $ctx = $Bio::KBase::CDMI::Service::CallContext;
    my($return);
    #BEGIN query_entity_Diagram

    $return = $self->_query_entity($ctx, 'Diagram', $qry, $fields);

    #END query_entity_Diagram
    my @_bad_returns;
    (ref($return) eq 'HASH') or push(@_bad_returns, "Invalid type for return variable \"return\" (value was \"$return\")");
    if (@_bad_returns) {
	my $msg = "Invalid returns passed to query_entity_Diagram:\n" . join("", map { "\t$_\n" } @_bad_returns);
	Bio::KBase::Exceptions::ArgumentValidationError->throw(error => $msg,
							       method_name => 'query_entity_Diagram');
    }
    return($return);
}




=head2 all_entities_Diagram

  $return = $obj->all_entities_Diagram($start, $count, $fields)

=over 4

=item Parameter and return types

=begin html

<pre>
$start is an int
$count is an int
$fields is a reference to a list where each element is a string
$return is a reference to a hash where the key is a string and the value is a fields_Diagram
fields_Diagram is a reference to a hash where the following keys are defined:
	id has a value which is a string
	name has a value which is a string
	content has a value which is a reference to a list where each element is a string

</pre>

=end html

=begin text

$start is an int
$count is an int
$fields is a reference to a list where each element is a string
$return is a reference to a hash where the key is a string and the value is a fields_Diagram
fields_Diagram is a reference to a hash where the following keys are defined:
	id has a value which is a string
	name has a value which is a string
	content has a value which is a reference to a list where each element is a string


=end text



=item Description



=back

=cut

sub all_entities_Diagram
{
    my $self = shift;
    my($start, $count, $fields) = @_;

    my @_bad_arguments;
    (!ref($start)) or push(@_bad_arguments, "Invalid type for argument \"start\" (value was \"$start\")");
    (!ref($count)) or push(@_bad_arguments, "Invalid type for argument \"count\" (value was \"$count\")");
    (ref($fields) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"fields\" (value was \"$fields\")");
    if (@_bad_arguments) {
	my $msg = "Invalid arguments passed to all_entities_Diagram:\n" . join("", map { "\t$_\n" } @_bad_arguments);
	Bio::KBase::Exceptions::ArgumentValidationError->throw(error => $msg,
							       method_name => 'all_entities_Diagram');
    }

    my $ctx = $Bio::KBase::CDMI::Service::CallContext;
    my($return);
    #BEGIN all_entities_Diagram

    $return = $self->_all_entities($ctx, 'Diagram', $start, $count, $fields);

    #END all_entities_Diagram
    my @_bad_returns;
    (ref($return) eq 'HASH') or push(@_bad_returns, "Invalid type for return variable \"return\" (value was \"$return\")");
    if (@_bad_returns) {
	my $msg = "Invalid returns passed to all_entities_Diagram:\n" . join("", map { "\t$_\n" } @_bad_returns);
	Bio::KBase::Exceptions::ArgumentValidationError->throw(error => $msg,
							       method_name => 'all_entities_Diagram');
    }
    return($return);
}




=head2 get_entity_EcNumber

  $return = $obj->get_entity_EcNumber($ids, $fields)

=over 4

=item Parameter and return types

=begin html

<pre>
$ids is a reference to a list where each element is a string
$fields is a reference to a list where each element is a string
$return is a reference to a hash where the key is a string and the value is a fields_EcNumber
fields_EcNumber is a reference to a hash where the following keys are defined:
	id has a value which is a string
	obsolete has a value which is an int
	replacedby has a value which is a string

</pre>

=end html

=begin text

$ids is a reference to a list where each element is a string
$fields is a reference to a list where each element is a string
$return is a reference to a hash where the key is a string and the value is a fields_EcNumber
fields_EcNumber is a reference to a hash where the following keys are defined:
	id has a value which is a string
	obsolete has a value which is an int
	replacedby has a value which is a string


=end text



=item Description

EC numbers are assigned by the Enzyme Commission, and consist
of four numbers separated by periods, each indicating a successively
smaller cateogry of enzymes.
It has the following fields:

=over 4


=item obsolete

This boolean indicates when an EC number is obsolete.


=item replacedby

When an obsolete EC number is replaced with another EC number, this string will
hold the name of the replacement EC number.



=back

=back

=cut

sub get_entity_EcNumber
{
    my $self = shift;
    my($ids, $fields) = @_;

    my @_bad_arguments;
    (ref($ids) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"ids\" (value was \"$ids\")");
    (ref($fields) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"fields\" (value was \"$fields\")");
    if (@_bad_arguments) {
	my $msg = "Invalid arguments passed to get_entity_EcNumber:\n" . join("", map { "\t$_\n" } @_bad_arguments);
	Bio::KBase::Exceptions::ArgumentValidationError->throw(error => $msg,
							       method_name => 'get_entity_EcNumber');
    }

    my $ctx = $Bio::KBase::CDMI::Service::CallContext;
    my($return);
    #BEGIN get_entity_EcNumber

    $return = $self->_get_entity($ctx, 'EcNumber', $ids, $fields);

    #END get_entity_EcNumber
    my @_bad_returns;
    (ref($return) eq 'HASH') or push(@_bad_returns, "Invalid type for return variable \"return\" (value was \"$return\")");
    if (@_bad_returns) {
	my $msg = "Invalid returns passed to get_entity_EcNumber:\n" . join("", map { "\t$_\n" } @_bad_returns);
	Bio::KBase::Exceptions::ArgumentValidationError->throw(error => $msg,
							       method_name => 'get_entity_EcNumber');
    }
    return($return);
}




=head2 query_entity_EcNumber

  $return = $obj->query_entity_EcNumber($qry, $fields)

=over 4

=item Parameter and return types

=begin html

<pre>
$qry is a reference to a list where each element is a reference to a list containing 3 items:
	0: a string
	1: a string
	2: a string
$fields is a reference to a list where each element is a string
$return is a reference to a hash where the key is a string and the value is a fields_EcNumber
fields_EcNumber is a reference to a hash where the following keys are defined:
	id has a value which is a string
	obsolete has a value which is an int
	replacedby has a value which is a string

</pre>

=end html

=begin text

$qry is a reference to a list where each element is a reference to a list containing 3 items:
	0: a string
	1: a string
	2: a string
$fields is a reference to a list where each element is a string
$return is a reference to a hash where the key is a string and the value is a fields_EcNumber
fields_EcNumber is a reference to a hash where the following keys are defined:
	id has a value which is a string
	obsolete has a value which is an int
	replacedby has a value which is a string


=end text



=item Description



=back

=cut

sub query_entity_EcNumber
{
    my $self = shift;
    my($qry, $fields) = @_;

    my @_bad_arguments;
    (ref($qry) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"qry\" (value was \"$qry\")");
    (ref($fields) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"fields\" (value was \"$fields\")");
    if (@_bad_arguments) {
	my $msg = "Invalid arguments passed to query_entity_EcNumber:\n" . join("", map { "\t$_\n" } @_bad_arguments);
	Bio::KBase::Exceptions::ArgumentValidationError->throw(error => $msg,
							       method_name => 'query_entity_EcNumber');
    }

    my $ctx = $Bio::KBase::CDMI::Service::CallContext;
    my($return);
    #BEGIN query_entity_EcNumber

    $return = $self->_query_entity($ctx, 'EcNumber', $qry, $fields);

    #END query_entity_EcNumber
    my @_bad_returns;
    (ref($return) eq 'HASH') or push(@_bad_returns, "Invalid type for return variable \"return\" (value was \"$return\")");
    if (@_bad_returns) {
	my $msg = "Invalid returns passed to query_entity_EcNumber:\n" . join("", map { "\t$_\n" } @_bad_returns);
	Bio::KBase::Exceptions::ArgumentValidationError->throw(error => $msg,
							       method_name => 'query_entity_EcNumber');
    }
    return($return);
}




=head2 all_entities_EcNumber

  $return = $obj->all_entities_EcNumber($start, $count, $fields)

=over 4

=item Parameter and return types

=begin html

<pre>
$start is an int
$count is an int
$fields is a reference to a list where each element is a string
$return is a reference to a hash where the key is a string and the value is a fields_EcNumber
fields_EcNumber is a reference to a hash where the following keys are defined:
	id has a value which is a string
	obsolete has a value which is an int
	replacedby has a value which is a string

</pre>

=end html

=begin text

$start is an int
$count is an int
$fields is a reference to a list where each element is a string
$return is a reference to a hash where the key is a string and the value is a fields_EcNumber
fields_EcNumber is a reference to a hash where the following keys are defined:
	id has a value which is a string
	obsolete has a value which is an int
	replacedby has a value which is a string


=end text



=item Description



=back

=cut

sub all_entities_EcNumber
{
    my $self = shift;
    my($start, $count, $fields) = @_;

    my @_bad_arguments;
    (!ref($start)) or push(@_bad_arguments, "Invalid type for argument \"start\" (value was \"$start\")");
    (!ref($count)) or push(@_bad_arguments, "Invalid type for argument \"count\" (value was \"$count\")");
    (ref($fields) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"fields\" (value was \"$fields\")");
    if (@_bad_arguments) {
	my $msg = "Invalid arguments passed to all_entities_EcNumber:\n" . join("", map { "\t$_\n" } @_bad_arguments);
	Bio::KBase::Exceptions::ArgumentValidationError->throw(error => $msg,
							       method_name => 'all_entities_EcNumber');
    }

    my $ctx = $Bio::KBase::CDMI::Service::CallContext;
    my($return);
    #BEGIN all_entities_EcNumber

    $return = $self->_all_entities($ctx, 'EcNumber', $start, $count, $fields);

    #END all_entities_EcNumber
    my @_bad_returns;
    (ref($return) eq 'HASH') or push(@_bad_returns, "Invalid type for return variable \"return\" (value was \"$return\")");
    if (@_bad_returns) {
	my $msg = "Invalid returns passed to all_entities_EcNumber:\n" . join("", map { "\t$_\n" } @_bad_returns);
	Bio::KBase::Exceptions::ArgumentValidationError->throw(error => $msg,
							       method_name => 'all_entities_EcNumber');
    }
    return($return);
}




=head2 get_entity_Experiment

  $return = $obj->get_entity_Experiment($ids, $fields)

=over 4

=item Parameter and return types

=begin html

<pre>
$ids is a reference to a list where each element is a string
$fields is a reference to a list where each element is a string
$return is a reference to a hash where the key is a string and the value is a fields_Experiment
fields_Experiment is a reference to a hash where the following keys are defined:
	id has a value which is a string
	source has a value which is a string

</pre>

=end html

=begin text

$ids is a reference to a list where each element is a string
$fields is a reference to a list where each element is a string
$return is a reference to a hash where the key is a string and the value is a fields_Experiment
fields_Experiment is a reference to a hash where the following keys are defined:
	id has a value which is a string
	source has a value which is a string


=end text



=item Description

An experiment is a combination of conditions for which gene expression
information is desired. The result of the experiment is a set of expression
levels for features under the given conditions.
It has the following fields:

=over 4


=item source

Publication or lab relevant to this experiment.



=back

=back

=cut

sub get_entity_Experiment
{
    my $self = shift;
    my($ids, $fields) = @_;

    my @_bad_arguments;
    (ref($ids) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"ids\" (value was \"$ids\")");
    (ref($fields) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"fields\" (value was \"$fields\")");
    if (@_bad_arguments) {
	my $msg = "Invalid arguments passed to get_entity_Experiment:\n" . join("", map { "\t$_\n" } @_bad_arguments);
	Bio::KBase::Exceptions::ArgumentValidationError->throw(error => $msg,
							       method_name => 'get_entity_Experiment');
    }

    my $ctx = $Bio::KBase::CDMI::Service::CallContext;
    my($return);
    #BEGIN get_entity_Experiment

    $return = $self->_get_entity($ctx, 'Experiment', $ids, $fields);

    #END get_entity_Experiment
    my @_bad_returns;
    (ref($return) eq 'HASH') or push(@_bad_returns, "Invalid type for return variable \"return\" (value was \"$return\")");
    if (@_bad_returns) {
	my $msg = "Invalid returns passed to get_entity_Experiment:\n" . join("", map { "\t$_\n" } @_bad_returns);
	Bio::KBase::Exceptions::ArgumentValidationError->throw(error => $msg,
							       method_name => 'get_entity_Experiment');
    }
    return($return);
}




=head2 query_entity_Experiment

  $return = $obj->query_entity_Experiment($qry, $fields)

=over 4

=item Parameter and return types

=begin html

<pre>
$qry is a reference to a list where each element is a reference to a list containing 3 items:
	0: a string
	1: a string
	2: a string
$fields is a reference to a list where each element is a string
$return is a reference to a hash where the key is a string and the value is a fields_Experiment
fields_Experiment is a reference to a hash where the following keys are defined:
	id has a value which is a string
	source has a value which is a string

</pre>

=end html

=begin text

$qry is a reference to a list where each element is a reference to a list containing 3 items:
	0: a string
	1: a string
	2: a string
$fields is a reference to a list where each element is a string
$return is a reference to a hash where the key is a string and the value is a fields_Experiment
fields_Experiment is a reference to a hash where the following keys are defined:
	id has a value which is a string
	source has a value which is a string


=end text



=item Description



=back

=cut

sub query_entity_Experiment
{
    my $self = shift;
    my($qry, $fields) = @_;

    my @_bad_arguments;
    (ref($qry) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"qry\" (value was \"$qry\")");
    (ref($fields) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"fields\" (value was \"$fields\")");
    if (@_bad_arguments) {
	my $msg = "Invalid arguments passed to query_entity_Experiment:\n" . join("", map { "\t$_\n" } @_bad_arguments);
	Bio::KBase::Exceptions::ArgumentValidationError->throw(error => $msg,
							       method_name => 'query_entity_Experiment');
    }

    my $ctx = $Bio::KBase::CDMI::Service::CallContext;
    my($return);
    #BEGIN query_entity_Experiment

    $return = $self->_query_entity($ctx, 'Experiment', $qry, $fields);

    #END query_entity_Experiment
    my @_bad_returns;
    (ref($return) eq 'HASH') or push(@_bad_returns, "Invalid type for return variable \"return\" (value was \"$return\")");
    if (@_bad_returns) {
	my $msg = "Invalid returns passed to query_entity_Experiment:\n" . join("", map { "\t$_\n" } @_bad_returns);
	Bio::KBase::Exceptions::ArgumentValidationError->throw(error => $msg,
							       method_name => 'query_entity_Experiment');
    }
    return($return);
}




=head2 all_entities_Experiment

  $return = $obj->all_entities_Experiment($start, $count, $fields)

=over 4

=item Parameter and return types

=begin html

<pre>
$start is an int
$count is an int
$fields is a reference to a list where each element is a string
$return is a reference to a hash where the key is a string and the value is a fields_Experiment
fields_Experiment is a reference to a hash where the following keys are defined:
	id has a value which is a string
	source has a value which is a string

</pre>

=end html

=begin text

$start is an int
$count is an int
$fields is a reference to a list where each element is a string
$return is a reference to a hash where the key is a string and the value is a fields_Experiment
fields_Experiment is a reference to a hash where the following keys are defined:
	id has a value which is a string
	source has a value which is a string


=end text



=item Description



=back

=cut

sub all_entities_Experiment
{
    my $self = shift;
    my($start, $count, $fields) = @_;

    my @_bad_arguments;
    (!ref($start)) or push(@_bad_arguments, "Invalid type for argument \"start\" (value was \"$start\")");
    (!ref($count)) or push(@_bad_arguments, "Invalid type for argument \"count\" (value was \"$count\")");
    (ref($fields) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"fields\" (value was \"$fields\")");
    if (@_bad_arguments) {
	my $msg = "Invalid arguments passed to all_entities_Experiment:\n" . join("", map { "\t$_\n" } @_bad_arguments);
	Bio::KBase::Exceptions::ArgumentValidationError->throw(error => $msg,
							       method_name => 'all_entities_Experiment');
    }

    my $ctx = $Bio::KBase::CDMI::Service::CallContext;
    my($return);
    #BEGIN all_entities_Experiment

    $return = $self->_all_entities($ctx, 'Experiment', $start, $count, $fields);

    #END all_entities_Experiment
    my @_bad_returns;
    (ref($return) eq 'HASH') or push(@_bad_returns, "Invalid type for return variable \"return\" (value was \"$return\")");
    if (@_bad_returns) {
	my $msg = "Invalid returns passed to all_entities_Experiment:\n" . join("", map { "\t$_\n" } @_bad_returns);
	Bio::KBase::Exceptions::ArgumentValidationError->throw(error => $msg,
							       method_name => 'all_entities_Experiment');
    }
    return($return);
}




=head2 get_entity_Family

  $return = $obj->get_entity_Family($ids, $fields)

=over 4

=item Parameter and return types

=begin html

<pre>
$ids is a reference to a list where each element is a string
$fields is a reference to a list where each element is a string
$return is a reference to a hash where the key is a string and the value is a fields_Family
fields_Family is a reference to a hash where the following keys are defined:
	id has a value which is a string
	type has a value which is a string
	release has a value which is a string
	family_function has a value which is a reference to a list where each element is a string
	alignment has a value which is a reference to a list where each element is a string

</pre>

=end html

=begin text

$ids is a reference to a list where each element is a string
$fields is a reference to a list where each element is a string
$return is a reference to a hash where the key is a string and the value is a fields_Family
fields_Family is a reference to a hash where the following keys are defined:
	id has a value which is a string
	type has a value which is a string
	release has a value which is a string
	family_function has a value which is a reference to a list where each element is a string
	alignment has a value which is a reference to a list where each element is a string


=end text



=item Description

The Kbase will support the maintenance of protein families (as sets of Features
with associated translations).  We are initially only supporting the notion of a family
as composed of a set of isofunctional homologs.  That is, the families we
initially support should be thought of as containing protein-encoding genes whose
associated sequences all implement the same function
(we do understand that the notion of "function" is somewhat ambiguous, so let
us sweep this under the rug by calling a functional role a "primitive concept").
We currently support families in which the members are
translations of features, and we think of Features as
having an associated function. Identical protein sequences
as products of translating distinct genes may or may not
have identical functions, and we allow multiple members of
the same Family to share identical protein sequences.  This
may be justified, since in a very, very, very few cases
identical proteins do, in fact, have distinct functions.
We would prefer to reach the point where our Families are
sets of protein sequence, rather than sets of
protein-encoding Features.

It has the following fields:

=over 4


=item type

type of protein family (e.g. FIGfam, equivalog)


=item release

release number / subtype of protein family


=item family_function

optional free-form description of the family. For function-based
families, this would be the functional role for the family
members.


=item alignment

FASTA-formatted alignment of the family's protein
sequences



=back

=back

=cut

sub get_entity_Family
{
    my $self = shift;
    my($ids, $fields) = @_;

    my @_bad_arguments;
    (ref($ids) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"ids\" (value was \"$ids\")");
    (ref($fields) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"fields\" (value was \"$fields\")");
    if (@_bad_arguments) {
	my $msg = "Invalid arguments passed to get_entity_Family:\n" . join("", map { "\t$_\n" } @_bad_arguments);
	Bio::KBase::Exceptions::ArgumentValidationError->throw(error => $msg,
							       method_name => 'get_entity_Family');
    }

    my $ctx = $Bio::KBase::CDMI::Service::CallContext;
    my($return);
    #BEGIN get_entity_Family

    $return = $self->_get_entity($ctx, 'Family', $ids, $fields);

    #END get_entity_Family
    my @_bad_returns;
    (ref($return) eq 'HASH') or push(@_bad_returns, "Invalid type for return variable \"return\" (value was \"$return\")");
    if (@_bad_returns) {
	my $msg = "Invalid returns passed to get_entity_Family:\n" . join("", map { "\t$_\n" } @_bad_returns);
	Bio::KBase::Exceptions::ArgumentValidationError->throw(error => $msg,
							       method_name => 'get_entity_Family');
    }
    return($return);
}




=head2 query_entity_Family

  $return = $obj->query_entity_Family($qry, $fields)

=over 4

=item Parameter and return types

=begin html

<pre>
$qry is a reference to a list where each element is a reference to a list containing 3 items:
	0: a string
	1: a string
	2: a string
$fields is a reference to a list where each element is a string
$return is a reference to a hash where the key is a string and the value is a fields_Family
fields_Family is a reference to a hash where the following keys are defined:
	id has a value which is a string
	type has a value which is a string
	release has a value which is a string
	family_function has a value which is a reference to a list where each element is a string
	alignment has a value which is a reference to a list where each element is a string

</pre>

=end html

=begin text

$qry is a reference to a list where each element is a reference to a list containing 3 items:
	0: a string
	1: a string
	2: a string
$fields is a reference to a list where each element is a string
$return is a reference to a hash where the key is a string and the value is a fields_Family
fields_Family is a reference to a hash where the following keys are defined:
	id has a value which is a string
	type has a value which is a string
	release has a value which is a string
	family_function has a value which is a reference to a list where each element is a string
	alignment has a value which is a reference to a list where each element is a string


=end text



=item Description



=back

=cut

sub query_entity_Family
{
    my $self = shift;
    my($qry, $fields) = @_;

    my @_bad_arguments;
    (ref($qry) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"qry\" (value was \"$qry\")");
    (ref($fields) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"fields\" (value was \"$fields\")");
    if (@_bad_arguments) {
	my $msg = "Invalid arguments passed to query_entity_Family:\n" . join("", map { "\t$_\n" } @_bad_arguments);
	Bio::KBase::Exceptions::ArgumentValidationError->throw(error => $msg,
							       method_name => 'query_entity_Family');
    }

    my $ctx = $Bio::KBase::CDMI::Service::CallContext;
    my($return);
    #BEGIN query_entity_Family

    $return = $self->_query_entity($ctx, 'Family', $qry, $fields);

    #END query_entity_Family
    my @_bad_returns;
    (ref($return) eq 'HASH') or push(@_bad_returns, "Invalid type for return variable \"return\" (value was \"$return\")");
    if (@_bad_returns) {
	my $msg = "Invalid returns passed to query_entity_Family:\n" . join("", map { "\t$_\n" } @_bad_returns);
	Bio::KBase::Exceptions::ArgumentValidationError->throw(error => $msg,
							       method_name => 'query_entity_Family');
    }
    return($return);
}




=head2 all_entities_Family

  $return = $obj->all_entities_Family($start, $count, $fields)

=over 4

=item Parameter and return types

=begin html

<pre>
$start is an int
$count is an int
$fields is a reference to a list where each element is a string
$return is a reference to a hash where the key is a string and the value is a fields_Family
fields_Family is a reference to a hash where the following keys are defined:
	id has a value which is a string
	type has a value which is a string
	release has a value which is a string
	family_function has a value which is a reference to a list where each element is a string
	alignment has a value which is a reference to a list where each element is a string

</pre>

=end html

=begin text

$start is an int
$count is an int
$fields is a reference to a list where each element is a string
$return is a reference to a hash where the key is a string and the value is a fields_Family
fields_Family is a reference to a hash where the following keys are defined:
	id has a value which is a string
	type has a value which is a string
	release has a value which is a string
	family_function has a value which is a reference to a list where each element is a string
	alignment has a value which is a reference to a list where each element is a string


=end text



=item Description



=back

=cut

sub all_entities_Family
{
    my $self = shift;
    my($start, $count, $fields) = @_;

    my @_bad_arguments;
    (!ref($start)) or push(@_bad_arguments, "Invalid type for argument \"start\" (value was \"$start\")");
    (!ref($count)) or push(@_bad_arguments, "Invalid type for argument \"count\" (value was \"$count\")");
    (ref($fields) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"fields\" (value was \"$fields\")");
    if (@_bad_arguments) {
	my $msg = "Invalid arguments passed to all_entities_Family:\n" . join("", map { "\t$_\n" } @_bad_arguments);
	Bio::KBase::Exceptions::ArgumentValidationError->throw(error => $msg,
							       method_name => 'all_entities_Family');
    }

    my $ctx = $Bio::KBase::CDMI::Service::CallContext;
    my($return);
    #BEGIN all_entities_Family

    $return = $self->_all_entities($ctx, 'Family', $start, $count, $fields);

    #END all_entities_Family
    my @_bad_returns;
    (ref($return) eq 'HASH') or push(@_bad_returns, "Invalid type for return variable \"return\" (value was \"$return\")");
    if (@_bad_returns) {
	my $msg = "Invalid returns passed to all_entities_Family:\n" . join("", map { "\t$_\n" } @_bad_returns);
	Bio::KBase::Exceptions::ArgumentValidationError->throw(error => $msg,
							       method_name => 'all_entities_Family');
    }
    return($return);
}




=head2 get_entity_Feature

  $return = $obj->get_entity_Feature($ids, $fields)

=over 4

=item Parameter and return types

=begin html

<pre>
$ids is a reference to a list where each element is a string
$fields is a reference to a list where each element is a string
$return is a reference to a hash where the key is a string and the value is a fields_Feature
fields_Feature is a reference to a hash where the following keys are defined:
	id has a value which is a string
	feature_type has a value which is a string
	source_id has a value which is a string
	sequence_length has a value which is an int
	function has a value which is a string
	alias has a value which is a reference to a list where each element is a string

</pre>

=end html

=begin text

$ids is a reference to a list where each element is a string
$fields is a reference to a list where each element is a string
$return is a reference to a hash where the key is a string and the value is a fields_Feature
fields_Feature is a reference to a hash where the following keys are defined:
	id has a value which is a string
	feature_type has a value which is a string
	source_id has a value which is a string
	sequence_length has a value which is an int
	function has a value which is a string
	alias has a value which is a reference to a list where each element is a string


=end text



=item Description

A feature (sometimes also called a gene) is a part of a
genome that is of special interest. Features may be spread across
multiple DNA sequences (contigs) of a genome, but never across more
than one genome. Each feature in the database has a unique
ID that functions as its ID in this table.
Normally a Feature is just a single contigous region on a contig.
Features have types, and an appropriate choice of available types
allows the support of protein-encoding genes, exons, RNA genes,
binding sites, pathogenicity islands, or whatever.

It has the following fields:

=over 4


=item feature_type

Code indicating the type of this feature. Among the
codes currently supported are "peg" for a protein encoding
gene, "bs" for a binding site, "opr" for an operon, and so
forth.


=item source_id

ID for this feature in its original source (core)
database


=item sequence_length

Number of base pairs in this feature.


=item function

Functional assignment for this feature. This will
often indicate the feature's functional role or roles, and
may also have comments.


=item alias

alternative identifier for the feature. These are
highly unstructured, and frequently non-unique.



=back

=back

=cut

sub get_entity_Feature
{
    my $self = shift;
    my($ids, $fields) = @_;

    my @_bad_arguments;
    (ref($ids) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"ids\" (value was \"$ids\")");
    (ref($fields) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"fields\" (value was \"$fields\")");
    if (@_bad_arguments) {
	my $msg = "Invalid arguments passed to get_entity_Feature:\n" . join("", map { "\t$_\n" } @_bad_arguments);
	Bio::KBase::Exceptions::ArgumentValidationError->throw(error => $msg,
							       method_name => 'get_entity_Feature');
    }

    my $ctx = $Bio::KBase::CDMI::Service::CallContext;
    my($return);
    #BEGIN get_entity_Feature

    $return = $self->_get_entity($ctx, 'Feature', $ids, $fields);

    #END get_entity_Feature
    my @_bad_returns;
    (ref($return) eq 'HASH') or push(@_bad_returns, "Invalid type for return variable \"return\" (value was \"$return\")");
    if (@_bad_returns) {
	my $msg = "Invalid returns passed to get_entity_Feature:\n" . join("", map { "\t$_\n" } @_bad_returns);
	Bio::KBase::Exceptions::ArgumentValidationError->throw(error => $msg,
							       method_name => 'get_entity_Feature');
    }
    return($return);
}




=head2 query_entity_Feature

  $return = $obj->query_entity_Feature($qry, $fields)

=over 4

=item Parameter and return types

=begin html

<pre>
$qry is a reference to a list where each element is a reference to a list containing 3 items:
	0: a string
	1: a string
	2: a string
$fields is a reference to a list where each element is a string
$return is a reference to a hash where the key is a string and the value is a fields_Feature
fields_Feature is a reference to a hash where the following keys are defined:
	id has a value which is a string
	feature_type has a value which is a string
	source_id has a value which is a string
	sequence_length has a value which is an int
	function has a value which is a string
	alias has a value which is a reference to a list where each element is a string

</pre>

=end html

=begin text

$qry is a reference to a list where each element is a reference to a list containing 3 items:
	0: a string
	1: a string
	2: a string
$fields is a reference to a list where each element is a string
$return is a reference to a hash where the key is a string and the value is a fields_Feature
fields_Feature is a reference to a hash where the following keys are defined:
	id has a value which is a string
	feature_type has a value which is a string
	source_id has a value which is a string
	sequence_length has a value which is an int
	function has a value which is a string
	alias has a value which is a reference to a list where each element is a string


=end text



=item Description



=back

=cut

sub query_entity_Feature
{
    my $self = shift;
    my($qry, $fields) = @_;

    my @_bad_arguments;
    (ref($qry) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"qry\" (value was \"$qry\")");
    (ref($fields) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"fields\" (value was \"$fields\")");
    if (@_bad_arguments) {
	my $msg = "Invalid arguments passed to query_entity_Feature:\n" . join("", map { "\t$_\n" } @_bad_arguments);
	Bio::KBase::Exceptions::ArgumentValidationError->throw(error => $msg,
							       method_name => 'query_entity_Feature');
    }

    my $ctx = $Bio::KBase::CDMI::Service::CallContext;
    my($return);
    #BEGIN query_entity_Feature

    $return = $self->_query_entity($ctx, 'Feature', $qry, $fields);

    #END query_entity_Feature
    my @_bad_returns;
    (ref($return) eq 'HASH') or push(@_bad_returns, "Invalid type for return variable \"return\" (value was \"$return\")");
    if (@_bad_returns) {
	my $msg = "Invalid returns passed to query_entity_Feature:\n" . join("", map { "\t$_\n" } @_bad_returns);
	Bio::KBase::Exceptions::ArgumentValidationError->throw(error => $msg,
							       method_name => 'query_entity_Feature');
    }
    return($return);
}




=head2 all_entities_Feature

  $return = $obj->all_entities_Feature($start, $count, $fields)

=over 4

=item Parameter and return types

=begin html

<pre>
$start is an int
$count is an int
$fields is a reference to a list where each element is a string
$return is a reference to a hash where the key is a string and the value is a fields_Feature
fields_Feature is a reference to a hash where the following keys are defined:
	id has a value which is a string
	feature_type has a value which is a string
	source_id has a value which is a string
	sequence_length has a value which is an int
	function has a value which is a string
	alias has a value which is a reference to a list where each element is a string

</pre>

=end html

=begin text

$start is an int
$count is an int
$fields is a reference to a list where each element is a string
$return is a reference to a hash where the key is a string and the value is a fields_Feature
fields_Feature is a reference to a hash where the following keys are defined:
	id has a value which is a string
	feature_type has a value which is a string
	source_id has a value which is a string
	sequence_length has a value which is an int
	function has a value which is a string
	alias has a value which is a reference to a list where each element is a string


=end text



=item Description



=back

=cut

sub all_entities_Feature
{
    my $self = shift;
    my($start, $count, $fields) = @_;

    my @_bad_arguments;
    (!ref($start)) or push(@_bad_arguments, "Invalid type for argument \"start\" (value was \"$start\")");
    (!ref($count)) or push(@_bad_arguments, "Invalid type for argument \"count\" (value was \"$count\")");
    (ref($fields) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"fields\" (value was \"$fields\")");
    if (@_bad_arguments) {
	my $msg = "Invalid arguments passed to all_entities_Feature:\n" . join("", map { "\t$_\n" } @_bad_arguments);
	Bio::KBase::Exceptions::ArgumentValidationError->throw(error => $msg,
							       method_name => 'all_entities_Feature');
    }

    my $ctx = $Bio::KBase::CDMI::Service::CallContext;
    my($return);
    #BEGIN all_entities_Feature

    $return = $self->_all_entities($ctx, 'Feature', $start, $count, $fields);

    #END all_entities_Feature
    my @_bad_returns;
    (ref($return) eq 'HASH') or push(@_bad_returns, "Invalid type for return variable \"return\" (value was \"$return\")");
    if (@_bad_returns) {
	my $msg = "Invalid returns passed to all_entities_Feature:\n" . join("", map { "\t$_\n" } @_bad_returns);
	Bio::KBase::Exceptions::ArgumentValidationError->throw(error => $msg,
							       method_name => 'all_entities_Feature');
    }
    return($return);
}




=head2 get_entity_Genome

  $return = $obj->get_entity_Genome($ids, $fields)

=over 4

=item Parameter and return types

=begin html

<pre>
$ids is a reference to a list where each element is a string
$fields is a reference to a list where each element is a string
$return is a reference to a hash where the key is a string and the value is a fields_Genome
fields_Genome is a reference to a hash where the following keys are defined:
	id has a value which is a string
	pegs has a value which is an int
	rnas has a value which is an int
	scientific_name has a value which is a string
	complete has a value which is an int
	prokaryotic has a value which is an int
	dna_size has a value which is an int
	contigs has a value which is an int
	domain has a value which is a string
	genetic_code has a value which is an int
	gc_content has a value which is a float
	phenotype has a value which is a reference to a list where each element is a string
	md5 has a value which is a string
	source_id has a value which is a string

</pre>

=end html

=begin text

$ids is a reference to a list where each element is a string
$fields is a reference to a list where each element is a string
$return is a reference to a hash where the key is a string and the value is a fields_Genome
fields_Genome is a reference to a hash where the following keys are defined:
	id has a value which is a string
	pegs has a value which is an int
	rnas has a value which is an int
	scientific_name has a value which is a string
	complete has a value which is an int
	prokaryotic has a value which is an int
	dna_size has a value which is an int
	contigs has a value which is an int
	domain has a value which is a string
	genetic_code has a value which is an int
	gc_content has a value which is a float
	phenotype has a value which is a reference to a list where each element is a string
	md5 has a value which is a string
	source_id has a value which is a string


=end text



=item Description

The Kbase houses a large and growing set of genomes.  We often have multiple
genomes that have identical DNA.  These usually have distinct gene calls and
annotations, but not always.  We consider the Kbase to be a framework for
managing hundreds of thousands of genomes and offering the tools needed to
support compartive analysis on large sets of genomes, some of which are
virtually identical.
Each genome has an MD5 value computed from the DNA that is associated with the genome.
Hence, it is easy to recognize when you have identical genomes, perhaps annotated
by distinct groups.

It has the following fields:

=over 4


=item pegs

Number of protein encoding genes for this genome.


=item rnas

Number of RNA features found for this organism.


=item scientific_name

Full genus/species/strain name of the genome sequence.


=item complete

TRUE if the genome sequence is complete, else FALSE


=item prokaryotic

TRUE if this is a prokaryotic genome sequence, else FALSE


=item dna_size

Number of base pairs in the genome sequence.


=item contigs

Number of contigs for this genome sequence.


=item domain

Domain for this organism (Archaea, Bacteria, Eukaryota,
Virus, Plasmid, or Environmental Sample).


=item genetic_code

Genetic code number used for protein translation on most
of this genome sequence's contigs.


=item gc_content

Percent GC content present in the genome sequence's
DNA.


=item phenotype

zero or more strings describing phenotypic information
about this genome sequence


=item md5

MD5 identifier describing the genome's DNA sequence


=item source_id

identifier assigned to this genome by the original
source



=back

=back

=cut

sub get_entity_Genome
{
    my $self = shift;
    my($ids, $fields) = @_;

    my @_bad_arguments;
    (ref($ids) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"ids\" (value was \"$ids\")");
    (ref($fields) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"fields\" (value was \"$fields\")");
    if (@_bad_arguments) {
	my $msg = "Invalid arguments passed to get_entity_Genome:\n" . join("", map { "\t$_\n" } @_bad_arguments);
	Bio::KBase::Exceptions::ArgumentValidationError->throw(error => $msg,
							       method_name => 'get_entity_Genome');
    }

    my $ctx = $Bio::KBase::CDMI::Service::CallContext;
    my($return);
    #BEGIN get_entity_Genome

    $return = $self->_get_entity($ctx, 'Genome', $ids, $fields);

    #END get_entity_Genome
    my @_bad_returns;
    (ref($return) eq 'HASH') or push(@_bad_returns, "Invalid type for return variable \"return\" (value was \"$return\")");
    if (@_bad_returns) {
	my $msg = "Invalid returns passed to get_entity_Genome:\n" . join("", map { "\t$_\n" } @_bad_returns);
	Bio::KBase::Exceptions::ArgumentValidationError->throw(error => $msg,
							       method_name => 'get_entity_Genome');
    }
    return($return);
}




=head2 query_entity_Genome

  $return = $obj->query_entity_Genome($qry, $fields)

=over 4

=item Parameter and return types

=begin html

<pre>
$qry is a reference to a list where each element is a reference to a list containing 3 items:
	0: a string
	1: a string
	2: a string
$fields is a reference to a list where each element is a string
$return is a reference to a hash where the key is a string and the value is a fields_Genome
fields_Genome is a reference to a hash where the following keys are defined:
	id has a value which is a string
	pegs has a value which is an int
	rnas has a value which is an int
	scientific_name has a value which is a string
	complete has a value which is an int
	prokaryotic has a value which is an int
	dna_size has a value which is an int
	contigs has a value which is an int
	domain has a value which is a string
	genetic_code has a value which is an int
	gc_content has a value which is a float
	phenotype has a value which is a reference to a list where each element is a string
	md5 has a value which is a string
	source_id has a value which is a string

</pre>

=end html

=begin text

$qry is a reference to a list where each element is a reference to a list containing 3 items:
	0: a string
	1: a string
	2: a string
$fields is a reference to a list where each element is a string
$return is a reference to a hash where the key is a string and the value is a fields_Genome
fields_Genome is a reference to a hash where the following keys are defined:
	id has a value which is a string
	pegs has a value which is an int
	rnas has a value which is an int
	scientific_name has a value which is a string
	complete has a value which is an int
	prokaryotic has a value which is an int
	dna_size has a value which is an int
	contigs has a value which is an int
	domain has a value which is a string
	genetic_code has a value which is an int
	gc_content has a value which is a float
	phenotype has a value which is a reference to a list where each element is a string
	md5 has a value which is a string
	source_id has a value which is a string


=end text



=item Description



=back

=cut

sub query_entity_Genome
{
    my $self = shift;
    my($qry, $fields) = @_;

    my @_bad_arguments;
    (ref($qry) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"qry\" (value was \"$qry\")");
    (ref($fields) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"fields\" (value was \"$fields\")");
    if (@_bad_arguments) {
	my $msg = "Invalid arguments passed to query_entity_Genome:\n" . join("", map { "\t$_\n" } @_bad_arguments);
	Bio::KBase::Exceptions::ArgumentValidationError->throw(error => $msg,
							       method_name => 'query_entity_Genome');
    }

    my $ctx = $Bio::KBase::CDMI::Service::CallContext;
    my($return);
    #BEGIN query_entity_Genome

    $return = $self->_query_entity($ctx, 'Genome', $qry, $fields);

    #END query_entity_Genome
    my @_bad_returns;
    (ref($return) eq 'HASH') or push(@_bad_returns, "Invalid type for return variable \"return\" (value was \"$return\")");
    if (@_bad_returns) {
	my $msg = "Invalid returns passed to query_entity_Genome:\n" . join("", map { "\t$_\n" } @_bad_returns);
	Bio::KBase::Exceptions::ArgumentValidationError->throw(error => $msg,
							       method_name => 'query_entity_Genome');
    }
    return($return);
}




=head2 all_entities_Genome

  $return = $obj->all_entities_Genome($start, $count, $fields)

=over 4

=item Parameter and return types

=begin html

<pre>
$start is an int
$count is an int
$fields is a reference to a list where each element is a string
$return is a reference to a hash where the key is a string and the value is a fields_Genome
fields_Genome is a reference to a hash where the following keys are defined:
	id has a value which is a string
	pegs has a value which is an int
	rnas has a value which is an int
	scientific_name has a value which is a string
	complete has a value which is an int
	prokaryotic has a value which is an int
	dna_size has a value which is an int
	contigs has a value which is an int
	domain has a value which is a string
	genetic_code has a value which is an int
	gc_content has a value which is a float
	phenotype has a value which is a reference to a list where each element is a string
	md5 has a value which is a string
	source_id has a value which is a string

</pre>

=end html

=begin text

$start is an int
$count is an int
$fields is a reference to a list where each element is a string
$return is a reference to a hash where the key is a string and the value is a fields_Genome
fields_Genome is a reference to a hash where the following keys are defined:
	id has a value which is a string
	pegs has a value which is an int
	rnas has a value which is an int
	scientific_name has a value which is a string
	complete has a value which is an int
	prokaryotic has a value which is an int
	dna_size has a value which is an int
	contigs has a value which is an int
	domain has a value which is a string
	genetic_code has a value which is an int
	gc_content has a value which is a float
	phenotype has a value which is a reference to a list where each element is a string
	md5 has a value which is a string
	source_id has a value which is a string


=end text



=item Description



=back

=cut

sub all_entities_Genome
{
    my $self = shift;
    my($start, $count, $fields) = @_;

    my @_bad_arguments;
    (!ref($start)) or push(@_bad_arguments, "Invalid type for argument \"start\" (value was \"$start\")");
    (!ref($count)) or push(@_bad_arguments, "Invalid type for argument \"count\" (value was \"$count\")");
    (ref($fields) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"fields\" (value was \"$fields\")");
    if (@_bad_arguments) {
	my $msg = "Invalid arguments passed to all_entities_Genome:\n" . join("", map { "\t$_\n" } @_bad_arguments);
	Bio::KBase::Exceptions::ArgumentValidationError->throw(error => $msg,
							       method_name => 'all_entities_Genome');
    }

    my $ctx = $Bio::KBase::CDMI::Service::CallContext;
    my($return);
    #BEGIN all_entities_Genome

    $return = $self->_all_entities($ctx, 'Genome', $start, $count, $fields);

    #END all_entities_Genome
    my @_bad_returns;
    (ref($return) eq 'HASH') or push(@_bad_returns, "Invalid type for return variable \"return\" (value was \"$return\")");
    if (@_bad_returns) {
	my $msg = "Invalid returns passed to all_entities_Genome:\n" . join("", map { "\t$_\n" } @_bad_returns);
	Bio::KBase::Exceptions::ArgumentValidationError->throw(error => $msg,
							       method_name => 'all_entities_Genome');
    }
    return($return);
}




=head2 get_entity_Locality

  $return = $obj->get_entity_Locality($ids, $fields)

=over 4

=item Parameter and return types

=begin html

<pre>
$ids is a reference to a list where each element is a string
$fields is a reference to a list where each element is a string
$return is a reference to a hash where the key is a string and the value is a fields_Locality
fields_Locality is a reference to a hash where the following keys are defined:
	id has a value which is a string
	source_name has a value which is a string
	city has a value which is a string
	state has a value which is a string
	country has a value which is a string
	origcty has a value which is a string
	elevation has a value which is an int
	latitude has a value which is an int
	longitude has a value which is an int
	lo_accession has a value which is a string

</pre>

=end html

=begin text

$ids is a reference to a list where each element is a string
$fields is a reference to a list where each element is a string
$return is a reference to a hash where the key is a string and the value is a fields_Locality
fields_Locality is a reference to a hash where the following keys are defined:
	id has a value which is a string
	source_name has a value which is a string
	city has a value which is a string
	state has a value which is a string
	country has a value which is a string
	origcty has a value which is a string
	elevation has a value which is an int
	latitude has a value which is an int
	longitude has a value which is an int
	lo_accession has a value which is a string


=end text



=item Description

A locality is a geographic location.
It has the following fields:

=over 4


=item source_name

Name or description of the location used as a collection site.


=item city

City of the collecting site.


=item state

State or province of the collecting site.


=item country

Country of the collecting site.


=item origcty

3-letter ISO 3166-1 extended country code for the country of origin.


=item elevation

Elevation of the collecting site, expressed in meters above sea level.  Negative values are allowed.


=item latitude

Latitude of the collecting site, recorded as a decimal number.  North latitudes are positive values and south latitudes are negative numbers.


=item longitude

Longitude of the collecting site, recorded as a decimal number.  West longitudes are positive values and east longitudes are negative numbers.


=item lo_accession

gazeteer ontology term ID



=back

=back

=cut

sub get_entity_Locality
{
    my $self = shift;
    my($ids, $fields) = @_;

    my @_bad_arguments;
    (ref($ids) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"ids\" (value was \"$ids\")");
    (ref($fields) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"fields\" (value was \"$fields\")");
    if (@_bad_arguments) {
	my $msg = "Invalid arguments passed to get_entity_Locality:\n" . join("", map { "\t$_\n" } @_bad_arguments);
	Bio::KBase::Exceptions::ArgumentValidationError->throw(error => $msg,
							       method_name => 'get_entity_Locality');
    }

    my $ctx = $Bio::KBase::CDMI::Service::CallContext;
    my($return);
    #BEGIN get_entity_Locality

    $return = $self->_get_entity($ctx, 'Locality', $ids, $fields);

    #END get_entity_Locality
    my @_bad_returns;
    (ref($return) eq 'HASH') or push(@_bad_returns, "Invalid type for return variable \"return\" (value was \"$return\")");
    if (@_bad_returns) {
	my $msg = "Invalid returns passed to get_entity_Locality:\n" . join("", map { "\t$_\n" } @_bad_returns);
	Bio::KBase::Exceptions::ArgumentValidationError->throw(error => $msg,
							       method_name => 'get_entity_Locality');
    }
    return($return);
}




=head2 query_entity_Locality

  $return = $obj->query_entity_Locality($qry, $fields)

=over 4

=item Parameter and return types

=begin html

<pre>
$qry is a reference to a list where each element is a reference to a list containing 3 items:
	0: a string
	1: a string
	2: a string
$fields is a reference to a list where each element is a string
$return is a reference to a hash where the key is a string and the value is a fields_Locality
fields_Locality is a reference to a hash where the following keys are defined:
	id has a value which is a string
	source_name has a value which is a string
	city has a value which is a string
	state has a value which is a string
	country has a value which is a string
	origcty has a value which is a string
	elevation has a value which is an int
	latitude has a value which is an int
	longitude has a value which is an int
	lo_accession has a value which is a string

</pre>

=end html

=begin text

$qry is a reference to a list where each element is a reference to a list containing 3 items:
	0: a string
	1: a string
	2: a string
$fields is a reference to a list where each element is a string
$return is a reference to a hash where the key is a string and the value is a fields_Locality
fields_Locality is a reference to a hash where the following keys are defined:
	id has a value which is a string
	source_name has a value which is a string
	city has a value which is a string
	state has a value which is a string
	country has a value which is a string
	origcty has a value which is a string
	elevation has a value which is an int
	latitude has a value which is an int
	longitude has a value which is an int
	lo_accession has a value which is a string


=end text



=item Description



=back

=cut

sub query_entity_Locality
{
    my $self = shift;
    my($qry, $fields) = @_;

    my @_bad_arguments;
    (ref($qry) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"qry\" (value was \"$qry\")");
    (ref($fields) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"fields\" (value was \"$fields\")");
    if (@_bad_arguments) {
	my $msg = "Invalid arguments passed to query_entity_Locality:\n" . join("", map { "\t$_\n" } @_bad_arguments);
	Bio::KBase::Exceptions::ArgumentValidationError->throw(error => $msg,
							       method_name => 'query_entity_Locality');
    }

    my $ctx = $Bio::KBase::CDMI::Service::CallContext;
    my($return);
    #BEGIN query_entity_Locality

    $return = $self->_query_entity($ctx, 'Locality', $qry, $fields);

    #END query_entity_Locality
    my @_bad_returns;
    (ref($return) eq 'HASH') or push(@_bad_returns, "Invalid type for return variable \"return\" (value was \"$return\")");
    if (@_bad_returns) {
	my $msg = "Invalid returns passed to query_entity_Locality:\n" . join("", map { "\t$_\n" } @_bad_returns);
	Bio::KBase::Exceptions::ArgumentValidationError->throw(error => $msg,
							       method_name => 'query_entity_Locality');
    }
    return($return);
}




=head2 all_entities_Locality

  $return = $obj->all_entities_Locality($start, $count, $fields)

=over 4

=item Parameter and return types

=begin html

<pre>
$start is an int
$count is an int
$fields is a reference to a list where each element is a string
$return is a reference to a hash where the key is a string and the value is a fields_Locality
fields_Locality is a reference to a hash where the following keys are defined:
	id has a value which is a string
	source_name has a value which is a string
	city has a value which is a string
	state has a value which is a string
	country has a value which is a string
	origcty has a value which is a string
	elevation has a value which is an int
	latitude has a value which is an int
	longitude has a value which is an int
	lo_accession has a value which is a string

</pre>

=end html

=begin text

$start is an int
$count is an int
$fields is a reference to a list where each element is a string
$return is a reference to a hash where the key is a string and the value is a fields_Locality
fields_Locality is a reference to a hash where the following keys are defined:
	id has a value which is a string
	source_name has a value which is a string
	city has a value which is a string
	state has a value which is a string
	country has a value which is a string
	origcty has a value which is a string
	elevation has a value which is an int
	latitude has a value which is an int
	longitude has a value which is an int
	lo_accession has a value which is a string


=end text



=item Description



=back

=cut

sub all_entities_Locality
{
    my $self = shift;
    my($start, $count, $fields) = @_;

    my @_bad_arguments;
    (!ref($start)) or push(@_bad_arguments, "Invalid type for argument \"start\" (value was \"$start\")");
    (!ref($count)) or push(@_bad_arguments, "Invalid type for argument \"count\" (value was \"$count\")");
    (ref($fields) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"fields\" (value was \"$fields\")");
    if (@_bad_arguments) {
	my $msg = "Invalid arguments passed to all_entities_Locality:\n" . join("", map { "\t$_\n" } @_bad_arguments);
	Bio::KBase::Exceptions::ArgumentValidationError->throw(error => $msg,
							       method_name => 'all_entities_Locality');
    }

    my $ctx = $Bio::KBase::CDMI::Service::CallContext;
    my($return);
    #BEGIN all_entities_Locality

    $return = $self->_all_entities($ctx, 'Locality', $start, $count, $fields);

    #END all_entities_Locality
    my @_bad_returns;
    (ref($return) eq 'HASH') or push(@_bad_returns, "Invalid type for return variable \"return\" (value was \"$return\")");
    if (@_bad_returns) {
	my $msg = "Invalid returns passed to all_entities_Locality:\n" . join("", map { "\t$_\n" } @_bad_returns);
	Bio::KBase::Exceptions::ArgumentValidationError->throw(error => $msg,
							       method_name => 'all_entities_Locality');
    }
    return($return);
}




=head2 get_entity_Media

  $return = $obj->get_entity_Media($ids, $fields)

=over 4

=item Parameter and return types

=begin html

<pre>
$ids is a reference to a list where each element is a string
$fields is a reference to a list where each element is a string
$return is a reference to a hash where the key is a string and the value is a fields_Media
fields_Media is a reference to a hash where the following keys are defined:
	id has a value which is a string
	mod_date has a value which is a string
	name has a value which is a string
	type has a value which is a string

</pre>

=end html

=begin text

$ids is a reference to a list where each element is a string
$fields is a reference to a list where each element is a string
$return is a reference to a hash where the key is a string and the value is a fields_Media
fields_Media is a reference to a hash where the following keys are defined:
	id has a value which is a string
	mod_date has a value which is a string
	name has a value which is a string
	type has a value which is a string


=end text



=item Description

A media describes the chemical content of the solution in which cells
are grown in an experiment or for the purposes of a model. The key is the
common media name. The nature of the media is described by its relationship
to its constituent compounds.
It has the following fields:

=over 4


=item mod_date

date and time of the last modification to the media's
definition


=item name

descriptive name of the media


=item type

type of the medium (aerobic or anaerobic)



=back

=back

=cut

sub get_entity_Media
{
    my $self = shift;
    my($ids, $fields) = @_;

    my @_bad_arguments;
    (ref($ids) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"ids\" (value was \"$ids\")");
    (ref($fields) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"fields\" (value was \"$fields\")");
    if (@_bad_arguments) {
	my $msg = "Invalid arguments passed to get_entity_Media:\n" . join("", map { "\t$_\n" } @_bad_arguments);
	Bio::KBase::Exceptions::ArgumentValidationError->throw(error => $msg,
							       method_name => 'get_entity_Media');
    }

    my $ctx = $Bio::KBase::CDMI::Service::CallContext;
    my($return);
    #BEGIN get_entity_Media

    $return = $self->_get_entity($ctx, 'Media', $ids, $fields);

    #END get_entity_Media
    my @_bad_returns;
    (ref($return) eq 'HASH') or push(@_bad_returns, "Invalid type for return variable \"return\" (value was \"$return\")");
    if (@_bad_returns) {
	my $msg = "Invalid returns passed to get_entity_Media:\n" . join("", map { "\t$_\n" } @_bad_returns);
	Bio::KBase::Exceptions::ArgumentValidationError->throw(error => $msg,
							       method_name => 'get_entity_Media');
    }
    return($return);
}




=head2 query_entity_Media

  $return = $obj->query_entity_Media($qry, $fields)

=over 4

=item Parameter and return types

=begin html

<pre>
$qry is a reference to a list where each element is a reference to a list containing 3 items:
	0: a string
	1: a string
	2: a string
$fields is a reference to a list where each element is a string
$return is a reference to a hash where the key is a string and the value is a fields_Media
fields_Media is a reference to a hash where the following keys are defined:
	id has a value which is a string
	mod_date has a value which is a string
	name has a value which is a string
	type has a value which is a string

</pre>

=end html

=begin text

$qry is a reference to a list where each element is a reference to a list containing 3 items:
	0: a string
	1: a string
	2: a string
$fields is a reference to a list where each element is a string
$return is a reference to a hash where the key is a string and the value is a fields_Media
fields_Media is a reference to a hash where the following keys are defined:
	id has a value which is a string
	mod_date has a value which is a string
	name has a value which is a string
	type has a value which is a string


=end text



=item Description



=back

=cut

sub query_entity_Media
{
    my $self = shift;
    my($qry, $fields) = @_;

    my @_bad_arguments;
    (ref($qry) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"qry\" (value was \"$qry\")");
    (ref($fields) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"fields\" (value was \"$fields\")");
    if (@_bad_arguments) {
	my $msg = "Invalid arguments passed to query_entity_Media:\n" . join("", map { "\t$_\n" } @_bad_arguments);
	Bio::KBase::Exceptions::ArgumentValidationError->throw(error => $msg,
							       method_name => 'query_entity_Media');
    }

    my $ctx = $Bio::KBase::CDMI::Service::CallContext;
    my($return);
    #BEGIN query_entity_Media

    $return = $self->_query_entity($ctx, 'Media', $qry, $fields);

    #END query_entity_Media
    my @_bad_returns;
    (ref($return) eq 'HASH') or push(@_bad_returns, "Invalid type for return variable \"return\" (value was \"$return\")");
    if (@_bad_returns) {
	my $msg = "Invalid returns passed to query_entity_Media:\n" . join("", map { "\t$_\n" } @_bad_returns);
	Bio::KBase::Exceptions::ArgumentValidationError->throw(error => $msg,
							       method_name => 'query_entity_Media');
    }
    return($return);
}




=head2 all_entities_Media

  $return = $obj->all_entities_Media($start, $count, $fields)

=over 4

=item Parameter and return types

=begin html

<pre>
$start is an int
$count is an int
$fields is a reference to a list where each element is a string
$return is a reference to a hash where the key is a string and the value is a fields_Media
fields_Media is a reference to a hash where the following keys are defined:
	id has a value which is a string
	mod_date has a value which is a string
	name has a value which is a string
	type has a value which is a string

</pre>

=end html

=begin text

$start is an int
$count is an int
$fields is a reference to a list where each element is a string
$return is a reference to a hash where the key is a string and the value is a fields_Media
fields_Media is a reference to a hash where the following keys are defined:
	id has a value which is a string
	mod_date has a value which is a string
	name has a value which is a string
	type has a value which is a string


=end text



=item Description



=back

=cut

sub all_entities_Media
{
    my $self = shift;
    my($start, $count, $fields) = @_;

    my @_bad_arguments;
    (!ref($start)) or push(@_bad_arguments, "Invalid type for argument \"start\" (value was \"$start\")");
    (!ref($count)) or push(@_bad_arguments, "Invalid type for argument \"count\" (value was \"$count\")");
    (ref($fields) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"fields\" (value was \"$fields\")");
    if (@_bad_arguments) {
	my $msg = "Invalid arguments passed to all_entities_Media:\n" . join("", map { "\t$_\n" } @_bad_arguments);
	Bio::KBase::Exceptions::ArgumentValidationError->throw(error => $msg,
							       method_name => 'all_entities_Media');
    }

    my $ctx = $Bio::KBase::CDMI::Service::CallContext;
    my($return);
    #BEGIN all_entities_Media

    $return = $self->_all_entities($ctx, 'Media', $start, $count, $fields);

    #END all_entities_Media
    my @_bad_returns;
    (ref($return) eq 'HASH') or push(@_bad_returns, "Invalid type for return variable \"return\" (value was \"$return\")");
    if (@_bad_returns) {
	my $msg = "Invalid returns passed to all_entities_Media:\n" . join("", map { "\t$_\n" } @_bad_returns);
	Bio::KBase::Exceptions::ArgumentValidationError->throw(error => $msg,
							       method_name => 'all_entities_Media');
    }
    return($return);
}




=head2 get_entity_Model

  $return = $obj->get_entity_Model($ids, $fields)

=over 4

=item Parameter and return types

=begin html

<pre>
$ids is a reference to a list where each element is a string
$fields is a reference to a list where each element is a string
$return is a reference to a hash where the key is a string and the value is a fields_Model
fields_Model is a reference to a hash where the following keys are defined:
	id has a value which is a string
	mod_date has a value which is a string
	name has a value which is a string
	version has a value which is an int
	type has a value which is a string
	status has a value which is a string
	reaction_count has a value which is an int
	compound_count has a value which is an int
	annotation_count has a value which is an int

</pre>

=end html

=begin text

$ids is a reference to a list where each element is a string
$fields is a reference to a list where each element is a string
$return is a reference to a hash where the key is a string and the value is a fields_Model
fields_Model is a reference to a hash where the following keys are defined:
	id has a value which is a string
	mod_date has a value which is a string
	name has a value which is a string
	version has a value which is an int
	type has a value which is a string
	status has a value which is a string
	reaction_count has a value which is an int
	compound_count has a value which is an int
	annotation_count has a value which is an int


=end text



=item Description

A model specifies a relationship between sets of features and
reactions in a cell. It is used to simulate cell growth and gene
knockouts to validate annotations.
It has the following fields:

=over 4


=item mod_date

date and time of the last change to the model data


=item name

descriptive name of the model


=item version

revision number of the model


=item type

string indicating where the model came from
(e.g. single genome, multiple genome, or community model)


=item status

indicator of whether the model is stable, under
construction, or under reconstruction


=item reaction_count

number of reactions in the model


=item compound_count

number of compounds in the model


=item annotation_count

number of annotations used to build the model



=back

=back

=cut

sub get_entity_Model
{
    my $self = shift;
    my($ids, $fields) = @_;

    my @_bad_arguments;
    (ref($ids) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"ids\" (value was \"$ids\")");
    (ref($fields) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"fields\" (value was \"$fields\")");
    if (@_bad_arguments) {
	my $msg = "Invalid arguments passed to get_entity_Model:\n" . join("", map { "\t$_\n" } @_bad_arguments);
	Bio::KBase::Exceptions::ArgumentValidationError->throw(error => $msg,
							       method_name => 'get_entity_Model');
    }

    my $ctx = $Bio::KBase::CDMI::Service::CallContext;
    my($return);
    #BEGIN get_entity_Model

    $return = $self->_get_entity($ctx, 'Model', $ids, $fields);

    #END get_entity_Model
    my @_bad_returns;
    (ref($return) eq 'HASH') or push(@_bad_returns, "Invalid type for return variable \"return\" (value was \"$return\")");
    if (@_bad_returns) {
	my $msg = "Invalid returns passed to get_entity_Model:\n" . join("", map { "\t$_\n" } @_bad_returns);
	Bio::KBase::Exceptions::ArgumentValidationError->throw(error => $msg,
							       method_name => 'get_entity_Model');
    }
    return($return);
}




=head2 query_entity_Model

  $return = $obj->query_entity_Model($qry, $fields)

=over 4

=item Parameter and return types

=begin html

<pre>
$qry is a reference to a list where each element is a reference to a list containing 3 items:
	0: a string
	1: a string
	2: a string
$fields is a reference to a list where each element is a string
$return is a reference to a hash where the key is a string and the value is a fields_Model
fields_Model is a reference to a hash where the following keys are defined:
	id has a value which is a string
	mod_date has a value which is a string
	name has a value which is a string
	version has a value which is an int
	type has a value which is a string
	status has a value which is a string
	reaction_count has a value which is an int
	compound_count has a value which is an int
	annotation_count has a value which is an int

</pre>

=end html

=begin text

$qry is a reference to a list where each element is a reference to a list containing 3 items:
	0: a string
	1: a string
	2: a string
$fields is a reference to a list where each element is a string
$return is a reference to a hash where the key is a string and the value is a fields_Model
fields_Model is a reference to a hash where the following keys are defined:
	id has a value which is a string
	mod_date has a value which is a string
	name has a value which is a string
	version has a value which is an int
	type has a value which is a string
	status has a value which is a string
	reaction_count has a value which is an int
	compound_count has a value which is an int
	annotation_count has a value which is an int


=end text



=item Description



=back

=cut

sub query_entity_Model
{
    my $self = shift;
    my($qry, $fields) = @_;

    my @_bad_arguments;
    (ref($qry) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"qry\" (value was \"$qry\")");
    (ref($fields) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"fields\" (value was \"$fields\")");
    if (@_bad_arguments) {
	my $msg = "Invalid arguments passed to query_entity_Model:\n" . join("", map { "\t$_\n" } @_bad_arguments);
	Bio::KBase::Exceptions::ArgumentValidationError->throw(error => $msg,
							       method_name => 'query_entity_Model');
    }

    my $ctx = $Bio::KBase::CDMI::Service::CallContext;
    my($return);
    #BEGIN query_entity_Model

    $return = $self->_query_entity($ctx, 'Model', $qry, $fields);

    #END query_entity_Model
    my @_bad_returns;
    (ref($return) eq 'HASH') or push(@_bad_returns, "Invalid type for return variable \"return\" (value was \"$return\")");
    if (@_bad_returns) {
	my $msg = "Invalid returns passed to query_entity_Model:\n" . join("", map { "\t$_\n" } @_bad_returns);
	Bio::KBase::Exceptions::ArgumentValidationError->throw(error => $msg,
							       method_name => 'query_entity_Model');
    }
    return($return);
}




=head2 all_entities_Model

  $return = $obj->all_entities_Model($start, $count, $fields)

=over 4

=item Parameter and return types

=begin html

<pre>
$start is an int
$count is an int
$fields is a reference to a list where each element is a string
$return is a reference to a hash where the key is a string and the value is a fields_Model
fields_Model is a reference to a hash where the following keys are defined:
	id has a value which is a string
	mod_date has a value which is a string
	name has a value which is a string
	version has a value which is an int
	type has a value which is a string
	status has a value which is a string
	reaction_count has a value which is an int
	compound_count has a value which is an int
	annotation_count has a value which is an int

</pre>

=end html

=begin text

$start is an int
$count is an int
$fields is a reference to a list where each element is a string
$return is a reference to a hash where the key is a string and the value is a fields_Model
fields_Model is a reference to a hash where the following keys are defined:
	id has a value which is a string
	mod_date has a value which is a string
	name has a value which is a string
	version has a value which is an int
	type has a value which is a string
	status has a value which is a string
	reaction_count has a value which is an int
	compound_count has a value which is an int
	annotation_count has a value which is an int


=end text



=item Description



=back

=cut

sub all_entities_Model
{
    my $self = shift;
    my($start, $count, $fields) = @_;

    my @_bad_arguments;
    (!ref($start)) or push(@_bad_arguments, "Invalid type for argument \"start\" (value was \"$start\")");
    (!ref($count)) or push(@_bad_arguments, "Invalid type for argument \"count\" (value was \"$count\")");
    (ref($fields) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"fields\" (value was \"$fields\")");
    if (@_bad_arguments) {
	my $msg = "Invalid arguments passed to all_entities_Model:\n" . join("", map { "\t$_\n" } @_bad_arguments);
	Bio::KBase::Exceptions::ArgumentValidationError->throw(error => $msg,
							       method_name => 'all_entities_Model');
    }

    my $ctx = $Bio::KBase::CDMI::Service::CallContext;
    my($return);
    #BEGIN all_entities_Model

    $return = $self->_all_entities($ctx, 'Model', $start, $count, $fields);

    #END all_entities_Model
    my @_bad_returns;
    (ref($return) eq 'HASH') or push(@_bad_returns, "Invalid type for return variable \"return\" (value was \"$return\")");
    if (@_bad_returns) {
	my $msg = "Invalid returns passed to all_entities_Model:\n" . join("", map { "\t$_\n" } @_bad_returns);
	Bio::KBase::Exceptions::ArgumentValidationError->throw(error => $msg,
							       method_name => 'all_entities_Model');
    }
    return($return);
}




=head2 get_entity_ModelCompartment

  $return = $obj->get_entity_ModelCompartment($ids, $fields)

=over 4

=item Parameter and return types

=begin html

<pre>
$ids is a reference to a list where each element is a string
$fields is a reference to a list where each element is a string
$return is a reference to a hash where the key is a string and the value is a fields_ModelCompartment
fields_ModelCompartment is a reference to a hash where the following keys are defined:
	id has a value which is a string
	compartment_index has a value which is an int
	label has a value which is a reference to a list where each element is a string
	pH has a value which is a float
	potential has a value which is a float

</pre>

=end html

=begin text

$ids is a reference to a list where each element is a string
$fields is a reference to a list where each element is a string
$return is a reference to a hash where the key is a string and the value is a fields_ModelCompartment
fields_ModelCompartment is a reference to a hash where the following keys are defined:
	id has a value which is a string
	compartment_index has a value which is an int
	label has a value which is a reference to a list where each element is a string
	pH has a value which is a float
	potential has a value which is a float


=end text



=item Description

The Model Compartment represents a section of a cell
(e.g. cell wall, cytoplasm) as it appears in a specific
model.
It has the following fields:

=over 4


=item compartment_index

number used to distinguish between different
instances of the same type of compartment in a single
model. Within a model, any two instances of the same
compartment must have difference compartment index
values.


=item label

description used to differentiate between instances
of the same compartment in a single model


=item pH

pH used to determine proton balance in this
compartment


=item potential

ask Chris



=back

=back

=cut

sub get_entity_ModelCompartment
{
    my $self = shift;
    my($ids, $fields) = @_;

    my @_bad_arguments;
    (ref($ids) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"ids\" (value was \"$ids\")");
    (ref($fields) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"fields\" (value was \"$fields\")");
    if (@_bad_arguments) {
	my $msg = "Invalid arguments passed to get_entity_ModelCompartment:\n" . join("", map { "\t$_\n" } @_bad_arguments);
	Bio::KBase::Exceptions::ArgumentValidationError->throw(error => $msg,
							       method_name => 'get_entity_ModelCompartment');
    }

    my $ctx = $Bio::KBase::CDMI::Service::CallContext;
    my($return);
    #BEGIN get_entity_ModelCompartment

    $return = $self->_get_entity($ctx, 'ModelCompartment', $ids, $fields);

    #END get_entity_ModelCompartment
    my @_bad_returns;
    (ref($return) eq 'HASH') or push(@_bad_returns, "Invalid type for return variable \"return\" (value was \"$return\")");
    if (@_bad_returns) {
	my $msg = "Invalid returns passed to get_entity_ModelCompartment:\n" . join("", map { "\t$_\n" } @_bad_returns);
	Bio::KBase::Exceptions::ArgumentValidationError->throw(error => $msg,
							       method_name => 'get_entity_ModelCompartment');
    }
    return($return);
}




=head2 query_entity_ModelCompartment

  $return = $obj->query_entity_ModelCompartment($qry, $fields)

=over 4

=item Parameter and return types

=begin html

<pre>
$qry is a reference to a list where each element is a reference to a list containing 3 items:
	0: a string
	1: a string
	2: a string
$fields is a reference to a list where each element is a string
$return is a reference to a hash where the key is a string and the value is a fields_ModelCompartment
fields_ModelCompartment is a reference to a hash where the following keys are defined:
	id has a value which is a string
	compartment_index has a value which is an int
	label has a value which is a reference to a list where each element is a string
	pH has a value which is a float
	potential has a value which is a float

</pre>

=end html

=begin text

$qry is a reference to a list where each element is a reference to a list containing 3 items:
	0: a string
	1: a string
	2: a string
$fields is a reference to a list where each element is a string
$return is a reference to a hash where the key is a string and the value is a fields_ModelCompartment
fields_ModelCompartment is a reference to a hash where the following keys are defined:
	id has a value which is a string
	compartment_index has a value which is an int
	label has a value which is a reference to a list where each element is a string
	pH has a value which is a float
	potential has a value which is a float


=end text



=item Description



=back

=cut

sub query_entity_ModelCompartment
{
    my $self = shift;
    my($qry, $fields) = @_;

    my @_bad_arguments;
    (ref($qry) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"qry\" (value was \"$qry\")");
    (ref($fields) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"fields\" (value was \"$fields\")");
    if (@_bad_arguments) {
	my $msg = "Invalid arguments passed to query_entity_ModelCompartment:\n" . join("", map { "\t$_\n" } @_bad_arguments);
	Bio::KBase::Exceptions::ArgumentValidationError->throw(error => $msg,
							       method_name => 'query_entity_ModelCompartment');
    }

    my $ctx = $Bio::KBase::CDMI::Service::CallContext;
    my($return);
    #BEGIN query_entity_ModelCompartment

    $return = $self->_query_entity($ctx, 'ModelCompartment', $qry, $fields);

    #END query_entity_ModelCompartment
    my @_bad_returns;
    (ref($return) eq 'HASH') or push(@_bad_returns, "Invalid type for return variable \"return\" (value was \"$return\")");
    if (@_bad_returns) {
	my $msg = "Invalid returns passed to query_entity_ModelCompartment:\n" . join("", map { "\t$_\n" } @_bad_returns);
	Bio::KBase::Exceptions::ArgumentValidationError->throw(error => $msg,
							       method_name => 'query_entity_ModelCompartment');
    }
    return($return);
}




=head2 all_entities_ModelCompartment

  $return = $obj->all_entities_ModelCompartment($start, $count, $fields)

=over 4

=item Parameter and return types

=begin html

<pre>
$start is an int
$count is an int
$fields is a reference to a list where each element is a string
$return is a reference to a hash where the key is a string and the value is a fields_ModelCompartment
fields_ModelCompartment is a reference to a hash where the following keys are defined:
	id has a value which is a string
	compartment_index has a value which is an int
	label has a value which is a reference to a list where each element is a string
	pH has a value which is a float
	potential has a value which is a float

</pre>

=end html

=begin text

$start is an int
$count is an int
$fields is a reference to a list where each element is a string
$return is a reference to a hash where the key is a string and the value is a fields_ModelCompartment
fields_ModelCompartment is a reference to a hash where the following keys are defined:
	id has a value which is a string
	compartment_index has a value which is an int
	label has a value which is a reference to a list where each element is a string
	pH has a value which is a float
	potential has a value which is a float


=end text



=item Description



=back

=cut

sub all_entities_ModelCompartment
{
    my $self = shift;
    my($start, $count, $fields) = @_;

    my @_bad_arguments;
    (!ref($start)) or push(@_bad_arguments, "Invalid type for argument \"start\" (value was \"$start\")");
    (!ref($count)) or push(@_bad_arguments, "Invalid type for argument \"count\" (value was \"$count\")");
    (ref($fields) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"fields\" (value was \"$fields\")");
    if (@_bad_arguments) {
	my $msg = "Invalid arguments passed to all_entities_ModelCompartment:\n" . join("", map { "\t$_\n" } @_bad_arguments);
	Bio::KBase::Exceptions::ArgumentValidationError->throw(error => $msg,
							       method_name => 'all_entities_ModelCompartment');
    }

    my $ctx = $Bio::KBase::CDMI::Service::CallContext;
    my($return);
    #BEGIN all_entities_ModelCompartment

    $return = $self->_all_entities($ctx, 'ModelCompartment', $start, $count, $fields);

    #END all_entities_ModelCompartment
    my @_bad_returns;
    (ref($return) eq 'HASH') or push(@_bad_returns, "Invalid type for return variable \"return\" (value was \"$return\")");
    if (@_bad_returns) {
	my $msg = "Invalid returns passed to all_entities_ModelCompartment:\n" . join("", map { "\t$_\n" } @_bad_returns);
	Bio::KBase::Exceptions::ArgumentValidationError->throw(error => $msg,
							       method_name => 'all_entities_ModelCompartment');
    }
    return($return);
}




=head2 get_entity_OTU

  $return = $obj->get_entity_OTU($ids, $fields)

=over 4

=item Parameter and return types

=begin html

<pre>
$ids is a reference to a list where each element is a string
$fields is a reference to a list where each element is a string
$return is a reference to a hash where the key is a string and the value is a fields_OTU
fields_OTU is a reference to a hash where the following keys are defined:
	id has a value which is a string

</pre>

=end html

=begin text

$ids is a reference to a list where each element is a string
$fields is a reference to a list where each element is a string
$return is a reference to a hash where the key is a string and the value is a fields_OTU
fields_OTU is a reference to a hash where the following keys are defined:
	id has a value which is a string


=end text



=item Description

An OTU (Organism Taxonomic Unit) is a named group of related
genomes.
It has the following fields:

=over 4



=back

=back

=cut

sub get_entity_OTU
{
    my $self = shift;
    my($ids, $fields) = @_;

    my @_bad_arguments;
    (ref($ids) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"ids\" (value was \"$ids\")");
    (ref($fields) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"fields\" (value was \"$fields\")");
    if (@_bad_arguments) {
	my $msg = "Invalid arguments passed to get_entity_OTU:\n" . join("", map { "\t$_\n" } @_bad_arguments);
	Bio::KBase::Exceptions::ArgumentValidationError->throw(error => $msg,
							       method_name => 'get_entity_OTU');
    }

    my $ctx = $Bio::KBase::CDMI::Service::CallContext;
    my($return);
    #BEGIN get_entity_OTU

    $return = $self->_get_entity($ctx, 'OTU', $ids, $fields);

    #END get_entity_OTU
    my @_bad_returns;
    (ref($return) eq 'HASH') or push(@_bad_returns, "Invalid type for return variable \"return\" (value was \"$return\")");
    if (@_bad_returns) {
	my $msg = "Invalid returns passed to get_entity_OTU:\n" . join("", map { "\t$_\n" } @_bad_returns);
	Bio::KBase::Exceptions::ArgumentValidationError->throw(error => $msg,
							       method_name => 'get_entity_OTU');
    }
    return($return);
}




=head2 query_entity_OTU

  $return = $obj->query_entity_OTU($qry, $fields)

=over 4

=item Parameter and return types

=begin html

<pre>
$qry is a reference to a list where each element is a reference to a list containing 3 items:
	0: a string
	1: a string
	2: a string
$fields is a reference to a list where each element is a string
$return is a reference to a hash where the key is a string and the value is a fields_OTU
fields_OTU is a reference to a hash where the following keys are defined:
	id has a value which is a string

</pre>

=end html

=begin text

$qry is a reference to a list where each element is a reference to a list containing 3 items:
	0: a string
	1: a string
	2: a string
$fields is a reference to a list where each element is a string
$return is a reference to a hash where the key is a string and the value is a fields_OTU
fields_OTU is a reference to a hash where the following keys are defined:
	id has a value which is a string


=end text



=item Description



=back

=cut

sub query_entity_OTU
{
    my $self = shift;
    my($qry, $fields) = @_;

    my @_bad_arguments;
    (ref($qry) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"qry\" (value was \"$qry\")");
    (ref($fields) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"fields\" (value was \"$fields\")");
    if (@_bad_arguments) {
	my $msg = "Invalid arguments passed to query_entity_OTU:\n" . join("", map { "\t$_\n" } @_bad_arguments);
	Bio::KBase::Exceptions::ArgumentValidationError->throw(error => $msg,
							       method_name => 'query_entity_OTU');
    }

    my $ctx = $Bio::KBase::CDMI::Service::CallContext;
    my($return);
    #BEGIN query_entity_OTU

    $return = $self->_query_entity($ctx, 'OTU', $qry, $fields);

    #END query_entity_OTU
    my @_bad_returns;
    (ref($return) eq 'HASH') or push(@_bad_returns, "Invalid type for return variable \"return\" (value was \"$return\")");
    if (@_bad_returns) {
	my $msg = "Invalid returns passed to query_entity_OTU:\n" . join("", map { "\t$_\n" } @_bad_returns);
	Bio::KBase::Exceptions::ArgumentValidationError->throw(error => $msg,
							       method_name => 'query_entity_OTU');
    }
    return($return);
}




=head2 all_entities_OTU

  $return = $obj->all_entities_OTU($start, $count, $fields)

=over 4

=item Parameter and return types

=begin html

<pre>
$start is an int
$count is an int
$fields is a reference to a list where each element is a string
$return is a reference to a hash where the key is a string and the value is a fields_OTU
fields_OTU is a reference to a hash where the following keys are defined:
	id has a value which is a string

</pre>

=end html

=begin text

$start is an int
$count is an int
$fields is a reference to a list where each element is a string
$return is a reference to a hash where the key is a string and the value is a fields_OTU
fields_OTU is a reference to a hash where the following keys are defined:
	id has a value which is a string


=end text



=item Description



=back

=cut

sub all_entities_OTU
{
    my $self = shift;
    my($start, $count, $fields) = @_;

    my @_bad_arguments;
    (!ref($start)) or push(@_bad_arguments, "Invalid type for argument \"start\" (value was \"$start\")");
    (!ref($count)) or push(@_bad_arguments, "Invalid type for argument \"count\" (value was \"$count\")");
    (ref($fields) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"fields\" (value was \"$fields\")");
    if (@_bad_arguments) {
	my $msg = "Invalid arguments passed to all_entities_OTU:\n" . join("", map { "\t$_\n" } @_bad_arguments);
	Bio::KBase::Exceptions::ArgumentValidationError->throw(error => $msg,
							       method_name => 'all_entities_OTU');
    }

    my $ctx = $Bio::KBase::CDMI::Service::CallContext;
    my($return);
    #BEGIN all_entities_OTU

    $return = $self->_all_entities($ctx, 'OTU', $start, $count, $fields);

    #END all_entities_OTU
    my @_bad_returns;
    (ref($return) eq 'HASH') or push(@_bad_returns, "Invalid type for return variable \"return\" (value was \"$return\")");
    if (@_bad_returns) {
	my $msg = "Invalid returns passed to all_entities_OTU:\n" . join("", map { "\t$_\n" } @_bad_returns);
	Bio::KBase::Exceptions::ArgumentValidationError->throw(error => $msg,
							       method_name => 'all_entities_OTU');
    }
    return($return);
}




=head2 get_entity_ObservationalUnit

  $return = $obj->get_entity_ObservationalUnit($ids, $fields)

=over 4

=item Parameter and return types

=begin html

<pre>
$ids is a reference to a list where each element is a string
$fields is a reference to a list where each element is a string
$return is a reference to a hash where the key is a string and the value is a fields_ObservationalUnit
fields_ObservationalUnit is a reference to a hash where the following keys are defined:
	id has a value which is a string
	source_name has a value which is a string
	source_name2 has a value which is a reference to a list where each element is a string
	plant_id has a value which is a string

</pre>

=end html

=begin text

$ids is a reference to a list where each element is a string
$fields is a reference to a list where each element is a string
$return is a reference to a hash where the key is a string and the value is a fields_ObservationalUnit
fields_ObservationalUnit is a reference to a hash where the following keys are defined:
	id has a value which is a string
	source_name has a value which is a string
	source_name2 has a value which is a reference to a list where each element is a string
	plant_id has a value which is a string


=end text



=item Description

An ObservationalUnit is an individual plant that 1) is part of an experiment or study, 2) has measured traits, and 3) is assayed for the purpose of determining alleles.  
It has the following fields:

=over 4


=item source_name

Name/ID by which the observational unit may be known by the originator and is used in queries.


=item source_name2

Secondary name/ID by which the observational unit may be known and is queried.


=item plant_id

ID of the plant that was tested to produce this
observational unit. Observational units with the same plant
ID are different assays of a single physical organism.



=back

=back

=cut

sub get_entity_ObservationalUnit
{
    my $self = shift;
    my($ids, $fields) = @_;

    my @_bad_arguments;
    (ref($ids) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"ids\" (value was \"$ids\")");
    (ref($fields) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"fields\" (value was \"$fields\")");
    if (@_bad_arguments) {
	my $msg = "Invalid arguments passed to get_entity_ObservationalUnit:\n" . join("", map { "\t$_\n" } @_bad_arguments);
	Bio::KBase::Exceptions::ArgumentValidationError->throw(error => $msg,
							       method_name => 'get_entity_ObservationalUnit');
    }

    my $ctx = $Bio::KBase::CDMI::Service::CallContext;
    my($return);
    #BEGIN get_entity_ObservationalUnit

    $return = $self->_get_entity($ctx, 'ObservationalUnit', $ids, $fields);

    #END get_entity_ObservationalUnit
    my @_bad_returns;
    (ref($return) eq 'HASH') or push(@_bad_returns, "Invalid type for return variable \"return\" (value was \"$return\")");
    if (@_bad_returns) {
	my $msg = "Invalid returns passed to get_entity_ObservationalUnit:\n" . join("", map { "\t$_\n" } @_bad_returns);
	Bio::KBase::Exceptions::ArgumentValidationError->throw(error => $msg,
							       method_name => 'get_entity_ObservationalUnit');
    }
    return($return);
}




=head2 query_entity_ObservationalUnit

  $return = $obj->query_entity_ObservationalUnit($qry, $fields)

=over 4

=item Parameter and return types

=begin html

<pre>
$qry is a reference to a list where each element is a reference to a list containing 3 items:
	0: a string
	1: a string
	2: a string
$fields is a reference to a list where each element is a string
$return is a reference to a hash where the key is a string and the value is a fields_ObservationalUnit
fields_ObservationalUnit is a reference to a hash where the following keys are defined:
	id has a value which is a string
	source_name has a value which is a string
	source_name2 has a value which is a reference to a list where each element is a string
	plant_id has a value which is a string

</pre>

=end html

=begin text

$qry is a reference to a list where each element is a reference to a list containing 3 items:
	0: a string
	1: a string
	2: a string
$fields is a reference to a list where each element is a string
$return is a reference to a hash where the key is a string and the value is a fields_ObservationalUnit
fields_ObservationalUnit is a reference to a hash where the following keys are defined:
	id has a value which is a string
	source_name has a value which is a string
	source_name2 has a value which is a reference to a list where each element is a string
	plant_id has a value which is a string


=end text



=item Description



=back

=cut

sub query_entity_ObservationalUnit
{
    my $self = shift;
    my($qry, $fields) = @_;

    my @_bad_arguments;
    (ref($qry) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"qry\" (value was \"$qry\")");
    (ref($fields) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"fields\" (value was \"$fields\")");
    if (@_bad_arguments) {
	my $msg = "Invalid arguments passed to query_entity_ObservationalUnit:\n" . join("", map { "\t$_\n" } @_bad_arguments);
	Bio::KBase::Exceptions::ArgumentValidationError->throw(error => $msg,
							       method_name => 'query_entity_ObservationalUnit');
    }

    my $ctx = $Bio::KBase::CDMI::Service::CallContext;
    my($return);
    #BEGIN query_entity_ObservationalUnit

    $return = $self->_query_entity($ctx, 'ObservationalUnit', $qry, $fields);

    #END query_entity_ObservationalUnit
    my @_bad_returns;
    (ref($return) eq 'HASH') or push(@_bad_returns, "Invalid type for return variable \"return\" (value was \"$return\")");
    if (@_bad_returns) {
	my $msg = "Invalid returns passed to query_entity_ObservationalUnit:\n" . join("", map { "\t$_\n" } @_bad_returns);
	Bio::KBase::Exceptions::ArgumentValidationError->throw(error => $msg,
							       method_name => 'query_entity_ObservationalUnit');
    }
    return($return);
}




=head2 all_entities_ObservationalUnit

  $return = $obj->all_entities_ObservationalUnit($start, $count, $fields)

=over 4

=item Parameter and return types

=begin html

<pre>
$start is an int
$count is an int
$fields is a reference to a list where each element is a string
$return is a reference to a hash where the key is a string and the value is a fields_ObservationalUnit
fields_ObservationalUnit is a reference to a hash where the following keys are defined:
	id has a value which is a string
	source_name has a value which is a string
	source_name2 has a value which is a reference to a list where each element is a string
	plant_id has a value which is a string

</pre>

=end html

=begin text

$start is an int
$count is an int
$fields is a reference to a list where each element is a string
$return is a reference to a hash where the key is a string and the value is a fields_ObservationalUnit
fields_ObservationalUnit is a reference to a hash where the following keys are defined:
	id has a value which is a string
	source_name has a value which is a string
	source_name2 has a value which is a reference to a list where each element is a string
	plant_id has a value which is a string


=end text



=item Description



=back

=cut

sub all_entities_ObservationalUnit
{
    my $self = shift;
    my($start, $count, $fields) = @_;

    my @_bad_arguments;
    (!ref($start)) or push(@_bad_arguments, "Invalid type for argument \"start\" (value was \"$start\")");
    (!ref($count)) or push(@_bad_arguments, "Invalid type for argument \"count\" (value was \"$count\")");
    (ref($fields) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"fields\" (value was \"$fields\")");
    if (@_bad_arguments) {
	my $msg = "Invalid arguments passed to all_entities_ObservationalUnit:\n" . join("", map { "\t$_\n" } @_bad_arguments);
	Bio::KBase::Exceptions::ArgumentValidationError->throw(error => $msg,
							       method_name => 'all_entities_ObservationalUnit');
    }

    my $ctx = $Bio::KBase::CDMI::Service::CallContext;
    my($return);
    #BEGIN all_entities_ObservationalUnit

    $return = $self->_all_entities($ctx, 'ObservationalUnit', $start, $count, $fields);

    #END all_entities_ObservationalUnit
    my @_bad_returns;
    (ref($return) eq 'HASH') or push(@_bad_returns, "Invalid type for return variable \"return\" (value was \"$return\")");
    if (@_bad_returns) {
	my $msg = "Invalid returns passed to all_entities_ObservationalUnit:\n" . join("", map { "\t$_\n" } @_bad_returns);
	Bio::KBase::Exceptions::ArgumentValidationError->throw(error => $msg,
							       method_name => 'all_entities_ObservationalUnit');
    }
    return($return);
}




=head2 get_entity_PairSet

  $return = $obj->get_entity_PairSet($ids, $fields)

=over 4

=item Parameter and return types

=begin html

<pre>
$ids is a reference to a list where each element is a string
$fields is a reference to a list where each element is a string
$return is a reference to a hash where the key is a string and the value is a fields_PairSet
fields_PairSet is a reference to a hash where the following keys are defined:
	id has a value which is a string
	score has a value which is an int

</pre>

=end html

=begin text

$ids is a reference to a list where each element is a string
$fields is a reference to a list where each element is a string
$return is a reference to a hash where the key is a string and the value is a fields_PairSet
fields_PairSet is a reference to a hash where the following keys are defined:
	id has a value which is a string
	score has a value which is an int


=end text



=item Description

A PairSet is a precompute set of pairs or genes.  Each pair occurs close to
one another of the chromosome.  We believe that all of the first members
of the pairs correspond to one another (are quite similar), as do all of
the second members of the pairs.  These pairs (from prokaryotic genomes)
offer on of the most powerful clues relating to uncharacterized genes/peroteins.

It has the following fields:

=over 4


=item score

Score for this evidence set. The score indicates the
number of significantly different genomes represented by the
pairings.



=back

=back

=cut

sub get_entity_PairSet
{
    my $self = shift;
    my($ids, $fields) = @_;

    my @_bad_arguments;
    (ref($ids) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"ids\" (value was \"$ids\")");
    (ref($fields) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"fields\" (value was \"$fields\")");
    if (@_bad_arguments) {
	my $msg = "Invalid arguments passed to get_entity_PairSet:\n" . join("", map { "\t$_\n" } @_bad_arguments);
	Bio::KBase::Exceptions::ArgumentValidationError->throw(error => $msg,
							       method_name => 'get_entity_PairSet');
    }

    my $ctx = $Bio::KBase::CDMI::Service::CallContext;
    my($return);
    #BEGIN get_entity_PairSet

    $return = $self->_get_entity($ctx, 'PairSet', $ids, $fields);

    #END get_entity_PairSet
    my @_bad_returns;
    (ref($return) eq 'HASH') or push(@_bad_returns, "Invalid type for return variable \"return\" (value was \"$return\")");
    if (@_bad_returns) {
	my $msg = "Invalid returns passed to get_entity_PairSet:\n" . join("", map { "\t$_\n" } @_bad_returns);
	Bio::KBase::Exceptions::ArgumentValidationError->throw(error => $msg,
							       method_name => 'get_entity_PairSet');
    }
    return($return);
}




=head2 query_entity_PairSet

  $return = $obj->query_entity_PairSet($qry, $fields)

=over 4

=item Parameter and return types

=begin html

<pre>
$qry is a reference to a list where each element is a reference to a list containing 3 items:
	0: a string
	1: a string
	2: a string
$fields is a reference to a list where each element is a string
$return is a reference to a hash where the key is a string and the value is a fields_PairSet
fields_PairSet is a reference to a hash where the following keys are defined:
	id has a value which is a string
	score has a value which is an int

</pre>

=end html

=begin text

$qry is a reference to a list where each element is a reference to a list containing 3 items:
	0: a string
	1: a string
	2: a string
$fields is a reference to a list where each element is a string
$return is a reference to a hash where the key is a string and the value is a fields_PairSet
fields_PairSet is a reference to a hash where the following keys are defined:
	id has a value which is a string
	score has a value which is an int


=end text



=item Description



=back

=cut

sub query_entity_PairSet
{
    my $self = shift;
    my($qry, $fields) = @_;

    my @_bad_arguments;
    (ref($qry) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"qry\" (value was \"$qry\")");
    (ref($fields) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"fields\" (value was \"$fields\")");
    if (@_bad_arguments) {
	my $msg = "Invalid arguments passed to query_entity_PairSet:\n" . join("", map { "\t$_\n" } @_bad_arguments);
	Bio::KBase::Exceptions::ArgumentValidationError->throw(error => $msg,
							       method_name => 'query_entity_PairSet');
    }

    my $ctx = $Bio::KBase::CDMI::Service::CallContext;
    my($return);
    #BEGIN query_entity_PairSet

    $return = $self->_query_entity($ctx, 'PairSet', $qry, $fields);

    #END query_entity_PairSet
    my @_bad_returns;
    (ref($return) eq 'HASH') or push(@_bad_returns, "Invalid type for return variable \"return\" (value was \"$return\")");
    if (@_bad_returns) {
	my $msg = "Invalid returns passed to query_entity_PairSet:\n" . join("", map { "\t$_\n" } @_bad_returns);
	Bio::KBase::Exceptions::ArgumentValidationError->throw(error => $msg,
							       method_name => 'query_entity_PairSet');
    }
    return($return);
}




=head2 all_entities_PairSet

  $return = $obj->all_entities_PairSet($start, $count, $fields)

=over 4

=item Parameter and return types

=begin html

<pre>
$start is an int
$count is an int
$fields is a reference to a list where each element is a string
$return is a reference to a hash where the key is a string and the value is a fields_PairSet
fields_PairSet is a reference to a hash where the following keys are defined:
	id has a value which is a string
	score has a value which is an int

</pre>

=end html

=begin text

$start is an int
$count is an int
$fields is a reference to a list where each element is a string
$return is a reference to a hash where the key is a string and the value is a fields_PairSet
fields_PairSet is a reference to a hash where the following keys are defined:
	id has a value which is a string
	score has a value which is an int


=end text



=item Description



=back

=cut

sub all_entities_PairSet
{
    my $self = shift;
    my($start, $count, $fields) = @_;

    my @_bad_arguments;
    (!ref($start)) or push(@_bad_arguments, "Invalid type for argument \"start\" (value was \"$start\")");
    (!ref($count)) or push(@_bad_arguments, "Invalid type for argument \"count\" (value was \"$count\")");
    (ref($fields) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"fields\" (value was \"$fields\")");
    if (@_bad_arguments) {
	my $msg = "Invalid arguments passed to all_entities_PairSet:\n" . join("", map { "\t$_\n" } @_bad_arguments);
	Bio::KBase::Exceptions::ArgumentValidationError->throw(error => $msg,
							       method_name => 'all_entities_PairSet');
    }

    my $ctx = $Bio::KBase::CDMI::Service::CallContext;
    my($return);
    #BEGIN all_entities_PairSet

    $return = $self->_all_entities($ctx, 'PairSet', $start, $count, $fields);

    #END all_entities_PairSet
    my @_bad_returns;
    (ref($return) eq 'HASH') or push(@_bad_returns, "Invalid type for return variable \"return\" (value was \"$return\")");
    if (@_bad_returns) {
	my $msg = "Invalid returns passed to all_entities_PairSet:\n" . join("", map { "\t$_\n" } @_bad_returns);
	Bio::KBase::Exceptions::ArgumentValidationError->throw(error => $msg,
							       method_name => 'all_entities_PairSet');
    }
    return($return);
}




=head2 get_entity_Pairing

  $return = $obj->get_entity_Pairing($ids, $fields)

=over 4

=item Parameter and return types

=begin html

<pre>
$ids is a reference to a list where each element is a string
$fields is a reference to a list where each element is a string
$return is a reference to a hash where the key is a string and the value is a fields_Pairing
fields_Pairing is a reference to a hash where the following keys are defined:
	id has a value which is a string

</pre>

=end html

=begin text

$ids is a reference to a list where each element is a string
$fields is a reference to a list where each element is a string
$return is a reference to a hash where the key is a string and the value is a fields_Pairing
fields_Pairing is a reference to a hash where the following keys are defined:
	id has a value which is a string


=end text



=item Description

A pairing indicates that two features are found
close together in a genome. Not all possible pairings are stored in
the database; only those that are considered for some reason to be
significant for annotation purposes.The key of the pairing is the
concatenation of the feature IDs in alphabetical order with an
intervening colon.
It has the following fields:

=over 4



=back

=back

=cut

sub get_entity_Pairing
{
    my $self = shift;
    my($ids, $fields) = @_;

    my @_bad_arguments;
    (ref($ids) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"ids\" (value was \"$ids\")");
    (ref($fields) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"fields\" (value was \"$fields\")");
    if (@_bad_arguments) {
	my $msg = "Invalid arguments passed to get_entity_Pairing:\n" . join("", map { "\t$_\n" } @_bad_arguments);
	Bio::KBase::Exceptions::ArgumentValidationError->throw(error => $msg,
							       method_name => 'get_entity_Pairing');
    }

    my $ctx = $Bio::KBase::CDMI::Service::CallContext;
    my($return);
    #BEGIN get_entity_Pairing

    $return = $self->_get_entity($ctx, 'Pairing', $ids, $fields);

    #END get_entity_Pairing
    my @_bad_returns;
    (ref($return) eq 'HASH') or push(@_bad_returns, "Invalid type for return variable \"return\" (value was \"$return\")");
    if (@_bad_returns) {
	my $msg = "Invalid returns passed to get_entity_Pairing:\n" . join("", map { "\t$_\n" } @_bad_returns);
	Bio::KBase::Exceptions::ArgumentValidationError->throw(error => $msg,
							       method_name => 'get_entity_Pairing');
    }
    return($return);
}




=head2 query_entity_Pairing

  $return = $obj->query_entity_Pairing($qry, $fields)

=over 4

=item Parameter and return types

=begin html

<pre>
$qry is a reference to a list where each element is a reference to a list containing 3 items:
	0: a string
	1: a string
	2: a string
$fields is a reference to a list where each element is a string
$return is a reference to a hash where the key is a string and the value is a fields_Pairing
fields_Pairing is a reference to a hash where the following keys are defined:
	id has a value which is a string

</pre>

=end html

=begin text

$qry is a reference to a list where each element is a reference to a list containing 3 items:
	0: a string
	1: a string
	2: a string
$fields is a reference to a list where each element is a string
$return is a reference to a hash where the key is a string and the value is a fields_Pairing
fields_Pairing is a reference to a hash where the following keys are defined:
	id has a value which is a string


=end text



=item Description



=back

=cut

sub query_entity_Pairing
{
    my $self = shift;
    my($qry, $fields) = @_;

    my @_bad_arguments;
    (ref($qry) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"qry\" (value was \"$qry\")");
    (ref($fields) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"fields\" (value was \"$fields\")");
    if (@_bad_arguments) {
	my $msg = "Invalid arguments passed to query_entity_Pairing:\n" . join("", map { "\t$_\n" } @_bad_arguments);
	Bio::KBase::Exceptions::ArgumentValidationError->throw(error => $msg,
							       method_name => 'query_entity_Pairing');
    }

    my $ctx = $Bio::KBase::CDMI::Service::CallContext;
    my($return);
    #BEGIN query_entity_Pairing

    $return = $self->_query_entity($ctx, 'Pairing', $qry, $fields);

    #END query_entity_Pairing
    my @_bad_returns;
    (ref($return) eq 'HASH') or push(@_bad_returns, "Invalid type for return variable \"return\" (value was \"$return\")");
    if (@_bad_returns) {
	my $msg = "Invalid returns passed to query_entity_Pairing:\n" . join("", map { "\t$_\n" } @_bad_returns);
	Bio::KBase::Exceptions::ArgumentValidationError->throw(error => $msg,
							       method_name => 'query_entity_Pairing');
    }
    return($return);
}




=head2 all_entities_Pairing

  $return = $obj->all_entities_Pairing($start, $count, $fields)

=over 4

=item Parameter and return types

=begin html

<pre>
$start is an int
$count is an int
$fields is a reference to a list where each element is a string
$return is a reference to a hash where the key is a string and the value is a fields_Pairing
fields_Pairing is a reference to a hash where the following keys are defined:
	id has a value which is a string

</pre>

=end html

=begin text

$start is an int
$count is an int
$fields is a reference to a list where each element is a string
$return is a reference to a hash where the key is a string and the value is a fields_Pairing
fields_Pairing is a reference to a hash where the following keys are defined:
	id has a value which is a string


=end text



=item Description



=back

=cut

sub all_entities_Pairing
{
    my $self = shift;
    my($start, $count, $fields) = @_;

    my @_bad_arguments;
    (!ref($start)) or push(@_bad_arguments, "Invalid type for argument \"start\" (value was \"$start\")");
    (!ref($count)) or push(@_bad_arguments, "Invalid type for argument \"count\" (value was \"$count\")");
    (ref($fields) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"fields\" (value was \"$fields\")");
    if (@_bad_arguments) {
	my $msg = "Invalid arguments passed to all_entities_Pairing:\n" . join("", map { "\t$_\n" } @_bad_arguments);
	Bio::KBase::Exceptions::ArgumentValidationError->throw(error => $msg,
							       method_name => 'all_entities_Pairing');
    }

    my $ctx = $Bio::KBase::CDMI::Service::CallContext;
    my($return);
    #BEGIN all_entities_Pairing

    $return = $self->_all_entities($ctx, 'Pairing', $start, $count, $fields);

    #END all_entities_Pairing
    my @_bad_returns;
    (ref($return) eq 'HASH') or push(@_bad_returns, "Invalid type for return variable \"return\" (value was \"$return\")");
    if (@_bad_returns) {
	my $msg = "Invalid returns passed to all_entities_Pairing:\n" . join("", map { "\t$_\n" } @_bad_returns);
	Bio::KBase::Exceptions::ArgumentValidationError->throw(error => $msg,
							       method_name => 'all_entities_Pairing');
    }
    return($return);
}




=head2 get_entity_ProbeSet

  $return = $obj->get_entity_ProbeSet($ids, $fields)

=over 4

=item Parameter and return types

=begin html

<pre>
$ids is a reference to a list where each element is a string
$fields is a reference to a list where each element is a string
$return is a reference to a hash where the key is a string and the value is a fields_ProbeSet
fields_ProbeSet is a reference to a hash where the following keys are defined:
	id has a value which is a string

</pre>

=end html

=begin text

$ids is a reference to a list where each element is a string
$fields is a reference to a list where each element is a string
$return is a reference to a hash where the key is a string and the value is a fields_ProbeSet
fields_ProbeSet is a reference to a hash where the following keys are defined:
	id has a value which is a string


=end text



=item Description

A probe set is a device containing multiple probe sequences for use
in gene expression experiments.
It has the following fields:

=over 4



=back

=back

=cut

sub get_entity_ProbeSet
{
    my $self = shift;
    my($ids, $fields) = @_;

    my @_bad_arguments;
    (ref($ids) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"ids\" (value was \"$ids\")");
    (ref($fields) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"fields\" (value was \"$fields\")");
    if (@_bad_arguments) {
	my $msg = "Invalid arguments passed to get_entity_ProbeSet:\n" . join("", map { "\t$_\n" } @_bad_arguments);
	Bio::KBase::Exceptions::ArgumentValidationError->throw(error => $msg,
							       method_name => 'get_entity_ProbeSet');
    }

    my $ctx = $Bio::KBase::CDMI::Service::CallContext;
    my($return);
    #BEGIN get_entity_ProbeSet

    $return = $self->_get_entity($ctx, 'ProbeSet', $ids, $fields);

    #END get_entity_ProbeSet
    my @_bad_returns;
    (ref($return) eq 'HASH') or push(@_bad_returns, "Invalid type for return variable \"return\" (value was \"$return\")");
    if (@_bad_returns) {
	my $msg = "Invalid returns passed to get_entity_ProbeSet:\n" . join("", map { "\t$_\n" } @_bad_returns);
	Bio::KBase::Exceptions::ArgumentValidationError->throw(error => $msg,
							       method_name => 'get_entity_ProbeSet');
    }
    return($return);
}




=head2 query_entity_ProbeSet

  $return = $obj->query_entity_ProbeSet($qry, $fields)

=over 4

=item Parameter and return types

=begin html

<pre>
$qry is a reference to a list where each element is a reference to a list containing 3 items:
	0: a string
	1: a string
	2: a string
$fields is a reference to a list where each element is a string
$return is a reference to a hash where the key is a string and the value is a fields_ProbeSet
fields_ProbeSet is a reference to a hash where the following keys are defined:
	id has a value which is a string

</pre>

=end html

=begin text

$qry is a reference to a list where each element is a reference to a list containing 3 items:
	0: a string
	1: a string
	2: a string
$fields is a reference to a list where each element is a string
$return is a reference to a hash where the key is a string and the value is a fields_ProbeSet
fields_ProbeSet is a reference to a hash where the following keys are defined:
	id has a value which is a string


=end text



=item Description



=back

=cut

sub query_entity_ProbeSet
{
    my $self = shift;
    my($qry, $fields) = @_;

    my @_bad_arguments;
    (ref($qry) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"qry\" (value was \"$qry\")");
    (ref($fields) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"fields\" (value was \"$fields\")");
    if (@_bad_arguments) {
	my $msg = "Invalid arguments passed to query_entity_ProbeSet:\n" . join("", map { "\t$_\n" } @_bad_arguments);
	Bio::KBase::Exceptions::ArgumentValidationError->throw(error => $msg,
							       method_name => 'query_entity_ProbeSet');
    }

    my $ctx = $Bio::KBase::CDMI::Service::CallContext;
    my($return);
    #BEGIN query_entity_ProbeSet

    $return = $self->_query_entity($ctx, 'ProbeSet', $qry, $fields);

    #END query_entity_ProbeSet
    my @_bad_returns;
    (ref($return) eq 'HASH') or push(@_bad_returns, "Invalid type for return variable \"return\" (value was \"$return\")");
    if (@_bad_returns) {
	my $msg = "Invalid returns passed to query_entity_ProbeSet:\n" . join("", map { "\t$_\n" } @_bad_returns);
	Bio::KBase::Exceptions::ArgumentValidationError->throw(error => $msg,
							       method_name => 'query_entity_ProbeSet');
    }
    return($return);
}




=head2 all_entities_ProbeSet

  $return = $obj->all_entities_ProbeSet($start, $count, $fields)

=over 4

=item Parameter and return types

=begin html

<pre>
$start is an int
$count is an int
$fields is a reference to a list where each element is a string
$return is a reference to a hash where the key is a string and the value is a fields_ProbeSet
fields_ProbeSet is a reference to a hash where the following keys are defined:
	id has a value which is a string

</pre>

=end html

=begin text

$start is an int
$count is an int
$fields is a reference to a list where each element is a string
$return is a reference to a hash where the key is a string and the value is a fields_ProbeSet
fields_ProbeSet is a reference to a hash where the following keys are defined:
	id has a value which is a string


=end text



=item Description



=back

=cut

sub all_entities_ProbeSet
{
    my $self = shift;
    my($start, $count, $fields) = @_;

    my @_bad_arguments;
    (!ref($start)) or push(@_bad_arguments, "Invalid type for argument \"start\" (value was \"$start\")");
    (!ref($count)) or push(@_bad_arguments, "Invalid type for argument \"count\" (value was \"$count\")");
    (ref($fields) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"fields\" (value was \"$fields\")");
    if (@_bad_arguments) {
	my $msg = "Invalid arguments passed to all_entities_ProbeSet:\n" . join("", map { "\t$_\n" } @_bad_arguments);
	Bio::KBase::Exceptions::ArgumentValidationError->throw(error => $msg,
							       method_name => 'all_entities_ProbeSet');
    }

    my $ctx = $Bio::KBase::CDMI::Service::CallContext;
    my($return);
    #BEGIN all_entities_ProbeSet

    $return = $self->_all_entities($ctx, 'ProbeSet', $start, $count, $fields);

    #END all_entities_ProbeSet
    my @_bad_returns;
    (ref($return) eq 'HASH') or push(@_bad_returns, "Invalid type for return variable \"return\" (value was \"$return\")");
    if (@_bad_returns) {
	my $msg = "Invalid returns passed to all_entities_ProbeSet:\n" . join("", map { "\t$_\n" } @_bad_returns);
	Bio::KBase::Exceptions::ArgumentValidationError->throw(error => $msg,
							       method_name => 'all_entities_ProbeSet');
    }
    return($return);
}




=head2 get_entity_ProteinSequence

  $return = $obj->get_entity_ProteinSequence($ids, $fields)

=over 4

=item Parameter and return types

=begin html

<pre>
$ids is a reference to a list where each element is a string
$fields is a reference to a list where each element is a string
$return is a reference to a hash where the key is a string and the value is a fields_ProteinSequence
fields_ProteinSequence is a reference to a hash where the following keys are defined:
	id has a value which is a string
	sequence has a value which is a string

</pre>

=end html

=begin text

$ids is a reference to a list where each element is a string
$fields is a reference to a list where each element is a string
$return is a reference to a hash where the key is a string and the value is a fields_ProteinSequence
fields_ProteinSequence is a reference to a hash where the following keys are defined:
	id has a value which is a string
	sequence has a value which is a string


=end text



=item Description

We use the concept of ProteinSequence as an amino acid string with an associated
MD5 value.  It is easy to access the set of Features that relate to a ProteinSequence.
While function is still associated with Features (and may be for some time), publications
are associated with ProteinSequences (and the inferred impact on Features is through
the relationship connecting ProteinSequences to Features).

It has the following fields:

=over 4


=item sequence

The sequence contains the letters corresponding to
the protein's amino acids.



=back

=back

=cut

sub get_entity_ProteinSequence
{
    my $self = shift;
    my($ids, $fields) = @_;

    my @_bad_arguments;
    (ref($ids) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"ids\" (value was \"$ids\")");
    (ref($fields) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"fields\" (value was \"$fields\")");
    if (@_bad_arguments) {
	my $msg = "Invalid arguments passed to get_entity_ProteinSequence:\n" . join("", map { "\t$_\n" } @_bad_arguments);
	Bio::KBase::Exceptions::ArgumentValidationError->throw(error => $msg,
							       method_name => 'get_entity_ProteinSequence');
    }

    my $ctx = $Bio::KBase::CDMI::Service::CallContext;
    my($return);
    #BEGIN get_entity_ProteinSequence

    $return = $self->_get_entity($ctx, 'ProteinSequence', $ids, $fields);

    #END get_entity_ProteinSequence
    my @_bad_returns;
    (ref($return) eq 'HASH') or push(@_bad_returns, "Invalid type for return variable \"return\" (value was \"$return\")");
    if (@_bad_returns) {
	my $msg = "Invalid returns passed to get_entity_ProteinSequence:\n" . join("", map { "\t$_\n" } @_bad_returns);
	Bio::KBase::Exceptions::ArgumentValidationError->throw(error => $msg,
							       method_name => 'get_entity_ProteinSequence');
    }
    return($return);
}




=head2 query_entity_ProteinSequence

  $return = $obj->query_entity_ProteinSequence($qry, $fields)

=over 4

=item Parameter and return types

=begin html

<pre>
$qry is a reference to a list where each element is a reference to a list containing 3 items:
	0: a string
	1: a string
	2: a string
$fields is a reference to a list where each element is a string
$return is a reference to a hash where the key is a string and the value is a fields_ProteinSequence
fields_ProteinSequence is a reference to a hash where the following keys are defined:
	id has a value which is a string
	sequence has a value which is a string

</pre>

=end html

=begin text

$qry is a reference to a list where each element is a reference to a list containing 3 items:
	0: a string
	1: a string
	2: a string
$fields is a reference to a list where each element is a string
$return is a reference to a hash where the key is a string and the value is a fields_ProteinSequence
fields_ProteinSequence is a reference to a hash where the following keys are defined:
	id has a value which is a string
	sequence has a value which is a string


=end text



=item Description



=back

=cut

sub query_entity_ProteinSequence
{
    my $self = shift;
    my($qry, $fields) = @_;

    my @_bad_arguments;
    (ref($qry) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"qry\" (value was \"$qry\")");
    (ref($fields) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"fields\" (value was \"$fields\")");
    if (@_bad_arguments) {
	my $msg = "Invalid arguments passed to query_entity_ProteinSequence:\n" . join("", map { "\t$_\n" } @_bad_arguments);
	Bio::KBase::Exceptions::ArgumentValidationError->throw(error => $msg,
							       method_name => 'query_entity_ProteinSequence');
    }

    my $ctx = $Bio::KBase::CDMI::Service::CallContext;
    my($return);
    #BEGIN query_entity_ProteinSequence

    $return = $self->_query_entity($ctx, 'ProteinSequence', $qry, $fields);

    #END query_entity_ProteinSequence
    my @_bad_returns;
    (ref($return) eq 'HASH') or push(@_bad_returns, "Invalid type for return variable \"return\" (value was \"$return\")");
    if (@_bad_returns) {
	my $msg = "Invalid returns passed to query_entity_ProteinSequence:\n" . join("", map { "\t$_\n" } @_bad_returns);
	Bio::KBase::Exceptions::ArgumentValidationError->throw(error => $msg,
							       method_name => 'query_entity_ProteinSequence');
    }
    return($return);
}




=head2 all_entities_ProteinSequence

  $return = $obj->all_entities_ProteinSequence($start, $count, $fields)

=over 4

=item Parameter and return types

=begin html

<pre>
$start is an int
$count is an int
$fields is a reference to a list where each element is a string
$return is a reference to a hash where the key is a string and the value is a fields_ProteinSequence
fields_ProteinSequence is a reference to a hash where the following keys are defined:
	id has a value which is a string
	sequence has a value which is a string

</pre>

=end html

=begin text

$start is an int
$count is an int
$fields is a reference to a list where each element is a string
$return is a reference to a hash where the key is a string and the value is a fields_ProteinSequence
fields_ProteinSequence is a reference to a hash where the following keys are defined:
	id has a value which is a string
	sequence has a value which is a string


=end text



=item Description



=back

=cut

sub all_entities_ProteinSequence
{
    my $self = shift;
    my($start, $count, $fields) = @_;

    my @_bad_arguments;
    (!ref($start)) or push(@_bad_arguments, "Invalid type for argument \"start\" (value was \"$start\")");
    (!ref($count)) or push(@_bad_arguments, "Invalid type for argument \"count\" (value was \"$count\")");
    (ref($fields) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"fields\" (value was \"$fields\")");
    if (@_bad_arguments) {
	my $msg = "Invalid arguments passed to all_entities_ProteinSequence:\n" . join("", map { "\t$_\n" } @_bad_arguments);
	Bio::KBase::Exceptions::ArgumentValidationError->throw(error => $msg,
							       method_name => 'all_entities_ProteinSequence');
    }

    my $ctx = $Bio::KBase::CDMI::Service::CallContext;
    my($return);
    #BEGIN all_entities_ProteinSequence

    $return = $self->_all_entities($ctx, 'ProteinSequence', $start, $count, $fields);

    #END all_entities_ProteinSequence
    my @_bad_returns;
    (ref($return) eq 'HASH') or push(@_bad_returns, "Invalid type for return variable \"return\" (value was \"$return\")");
    if (@_bad_returns) {
	my $msg = "Invalid returns passed to all_entities_ProteinSequence:\n" . join("", map { "\t$_\n" } @_bad_returns);
	Bio::KBase::Exceptions::ArgumentValidationError->throw(error => $msg,
							       method_name => 'all_entities_ProteinSequence');
    }
    return($return);
}




=head2 get_entity_Publication

  $return = $obj->get_entity_Publication($ids, $fields)

=over 4

=item Parameter and return types

=begin html

<pre>
$ids is a reference to a list where each element is a string
$fields is a reference to a list where each element is a string
$return is a reference to a hash where the key is a string and the value is a fields_Publication
fields_Publication is a reference to a hash where the following keys are defined:
	id has a value which is a string
	title has a value which is a string
	link has a value which is a string
	pubdate has a value which is a string

</pre>

=end html

=begin text

$ids is a reference to a list where each element is a string
$fields is a reference to a list where each element is a string
$return is a reference to a hash where the key is a string and the value is a fields_Publication
fields_Publication is a reference to a hash where the following keys are defined:
	id has a value which is a string
	title has a value which is a string
	link has a value which is a string
	pubdate has a value which is a string


=end text



=item Description

Annotators attach publications to ProteinSequences.  The criteria we have used
to gather such connections is a bit nonstandard.  We have sought to attach publications
to ProteinSequences when the publication includes an expert asserting a belief or estimate
of function.  The paper may not be the original characterization.  Further, it may not
even discuss a sequence protein (much of the literature is very valuable, but reports
work on proteins in strains that have not yet been sequenced).  On the other hand,
reports of sequencing regions of a chromosome (with no specific assertion of a
clear function) should not be attached.  The attached publications give an ID (usually a
Pubmed ID),  a URL to the paper (when we have it), and a title (when we have it).

It has the following fields:

=over 4


=item title

title of the article, or (unknown) if the title is not known


=item link

URL of the article


=item pubdate

publication date of the article



=back

=back

=cut

sub get_entity_Publication
{
    my $self = shift;
    my($ids, $fields) = @_;

    my @_bad_arguments;
    (ref($ids) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"ids\" (value was \"$ids\")");
    (ref($fields) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"fields\" (value was \"$fields\")");
    if (@_bad_arguments) {
	my $msg = "Invalid arguments passed to get_entity_Publication:\n" . join("", map { "\t$_\n" } @_bad_arguments);
	Bio::KBase::Exceptions::ArgumentValidationError->throw(error => $msg,
							       method_name => 'get_entity_Publication');
    }

    my $ctx = $Bio::KBase::CDMI::Service::CallContext;
    my($return);
    #BEGIN get_entity_Publication

    $return = $self->_get_entity($ctx, 'Publication', $ids, $fields);

    #END get_entity_Publication
    my @_bad_returns;
    (ref($return) eq 'HASH') or push(@_bad_returns, "Invalid type for return variable \"return\" (value was \"$return\")");
    if (@_bad_returns) {
	my $msg = "Invalid returns passed to get_entity_Publication:\n" . join("", map { "\t$_\n" } @_bad_returns);
	Bio::KBase::Exceptions::ArgumentValidationError->throw(error => $msg,
							       method_name => 'get_entity_Publication');
    }
    return($return);
}




=head2 query_entity_Publication

  $return = $obj->query_entity_Publication($qry, $fields)

=over 4

=item Parameter and return types

=begin html

<pre>
$qry is a reference to a list where each element is a reference to a list containing 3 items:
	0: a string
	1: a string
	2: a string
$fields is a reference to a list where each element is a string
$return is a reference to a hash where the key is a string and the value is a fields_Publication
fields_Publication is a reference to a hash where the following keys are defined:
	id has a value which is a string
	title has a value which is a string
	link has a value which is a string
	pubdate has a value which is a string

</pre>

=end html

=begin text

$qry is a reference to a list where each element is a reference to a list containing 3 items:
	0: a string
	1: a string
	2: a string
$fields is a reference to a list where each element is a string
$return is a reference to a hash where the key is a string and the value is a fields_Publication
fields_Publication is a reference to a hash where the following keys are defined:
	id has a value which is a string
	title has a value which is a string
	link has a value which is a string
	pubdate has a value which is a string


=end text



=item Description



=back

=cut

sub query_entity_Publication
{
    my $self = shift;
    my($qry, $fields) = @_;

    my @_bad_arguments;
    (ref($qry) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"qry\" (value was \"$qry\")");
    (ref($fields) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"fields\" (value was \"$fields\")");
    if (@_bad_arguments) {
	my $msg = "Invalid arguments passed to query_entity_Publication:\n" . join("", map { "\t$_\n" } @_bad_arguments);
	Bio::KBase::Exceptions::ArgumentValidationError->throw(error => $msg,
							       method_name => 'query_entity_Publication');
    }

    my $ctx = $Bio::KBase::CDMI::Service::CallContext;
    my($return);
    #BEGIN query_entity_Publication

    $return = $self->_query_entity($ctx, 'Publication', $qry, $fields);

    #END query_entity_Publication
    my @_bad_returns;
    (ref($return) eq 'HASH') or push(@_bad_returns, "Invalid type for return variable \"return\" (value was \"$return\")");
    if (@_bad_returns) {
	my $msg = "Invalid returns passed to query_entity_Publication:\n" . join("", map { "\t$_\n" } @_bad_returns);
	Bio::KBase::Exceptions::ArgumentValidationError->throw(error => $msg,
							       method_name => 'query_entity_Publication');
    }
    return($return);
}




=head2 all_entities_Publication

  $return = $obj->all_entities_Publication($start, $count, $fields)

=over 4

=item Parameter and return types

=begin html

<pre>
$start is an int
$count is an int
$fields is a reference to a list where each element is a string
$return is a reference to a hash where the key is a string and the value is a fields_Publication
fields_Publication is a reference to a hash where the following keys are defined:
	id has a value which is a string
	title has a value which is a string
	link has a value which is a string
	pubdate has a value which is a string

</pre>

=end html

=begin text

$start is an int
$count is an int
$fields is a reference to a list where each element is a string
$return is a reference to a hash where the key is a string and the value is a fields_Publication
fields_Publication is a reference to a hash where the following keys are defined:
	id has a value which is a string
	title has a value which is a string
	link has a value which is a string
	pubdate has a value which is a string


=end text



=item Description



=back

=cut

sub all_entities_Publication
{
    my $self = shift;
    my($start, $count, $fields) = @_;

    my @_bad_arguments;
    (!ref($start)) or push(@_bad_arguments, "Invalid type for argument \"start\" (value was \"$start\")");
    (!ref($count)) or push(@_bad_arguments, "Invalid type for argument \"count\" (value was \"$count\")");
    (ref($fields) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"fields\" (value was \"$fields\")");
    if (@_bad_arguments) {
	my $msg = "Invalid arguments passed to all_entities_Publication:\n" . join("", map { "\t$_\n" } @_bad_arguments);
	Bio::KBase::Exceptions::ArgumentValidationError->throw(error => $msg,
							       method_name => 'all_entities_Publication');
    }

    my $ctx = $Bio::KBase::CDMI::Service::CallContext;
    my($return);
    #BEGIN all_entities_Publication

    $return = $self->_all_entities($ctx, 'Publication', $start, $count, $fields);

    #END all_entities_Publication
    my @_bad_returns;
    (ref($return) eq 'HASH') or push(@_bad_returns, "Invalid type for return variable \"return\" (value was \"$return\")");
    if (@_bad_returns) {
	my $msg = "Invalid returns passed to all_entities_Publication:\n" . join("", map { "\t$_\n" } @_bad_returns);
	Bio::KBase::Exceptions::ArgumentValidationError->throw(error => $msg,
							       method_name => 'all_entities_Publication');
    }
    return($return);
}




=head2 get_entity_Reaction

  $return = $obj->get_entity_Reaction($ids, $fields)

=over 4

=item Parameter and return types

=begin html

<pre>
$ids is a reference to a list where each element is a string
$fields is a reference to a list where each element is a string
$return is a reference to a hash where the key is a string and the value is a fields_Reaction
fields_Reaction is a reference to a hash where the following keys are defined:
	id has a value which is a string
	mod_date has a value which is a string
	name has a value which is a string
	msid has a value which is a string
	abbr has a value which is a string
	equation has a value which is a string
	reversibility has a value which is a string

</pre>

=end html

=begin text

$ids is a reference to a list where each element is a string
$fields is a reference to a list where each element is a string
$return is a reference to a hash where the key is a string and the value is a fields_Reaction
fields_Reaction is a reference to a hash where the following keys are defined:
	id has a value which is a string
	mod_date has a value which is a string
	name has a value which is a string
	msid has a value which is a string
	abbr has a value which is a string
	equation has a value which is a string
	reversibility has a value which is a string


=end text



=item Description

A reaction is a chemical process that converts one set of
compounds (substrate) to another set (products).
It has the following fields:

=over 4


=item mod_date

date and time of the last modification to this reaction's
definition


=item name

descriptive name of this reaction


=item msid

common modeling ID of this reaction


=item abbr

abbreviated name of this reaction


=item equation

displayable formula for the reaction


=item reversibility

direction of this reaction (> for forward-only,
< for backward-only, = for bidirectional)



=back

=back

=cut

sub get_entity_Reaction
{
    my $self = shift;
    my($ids, $fields) = @_;

    my @_bad_arguments;
    (ref($ids) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"ids\" (value was \"$ids\")");
    (ref($fields) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"fields\" (value was \"$fields\")");
    if (@_bad_arguments) {
	my $msg = "Invalid arguments passed to get_entity_Reaction:\n" . join("", map { "\t$_\n" } @_bad_arguments);
	Bio::KBase::Exceptions::ArgumentValidationError->throw(error => $msg,
							       method_name => 'get_entity_Reaction');
    }

    my $ctx = $Bio::KBase::CDMI::Service::CallContext;
    my($return);
    #BEGIN get_entity_Reaction

    $return = $self->_get_entity($ctx, 'Reaction', $ids, $fields);

    #END get_entity_Reaction
    my @_bad_returns;
    (ref($return) eq 'HASH') or push(@_bad_returns, "Invalid type for return variable \"return\" (value was \"$return\")");
    if (@_bad_returns) {
	my $msg = "Invalid returns passed to get_entity_Reaction:\n" . join("", map { "\t$_\n" } @_bad_returns);
	Bio::KBase::Exceptions::ArgumentValidationError->throw(error => $msg,
							       method_name => 'get_entity_Reaction');
    }
    return($return);
}




=head2 query_entity_Reaction

  $return = $obj->query_entity_Reaction($qry, $fields)

=over 4

=item Parameter and return types

=begin html

<pre>
$qry is a reference to a list where each element is a reference to a list containing 3 items:
	0: a string
	1: a string
	2: a string
$fields is a reference to a list where each element is a string
$return is a reference to a hash where the key is a string and the value is a fields_Reaction
fields_Reaction is a reference to a hash where the following keys are defined:
	id has a value which is a string
	mod_date has a value which is a string
	name has a value which is a string
	msid has a value which is a string
	abbr has a value which is a string
	equation has a value which is a string
	reversibility has a value which is a string

</pre>

=end html

=begin text

$qry is a reference to a list where each element is a reference to a list containing 3 items:
	0: a string
	1: a string
	2: a string
$fields is a reference to a list where each element is a string
$return is a reference to a hash where the key is a string and the value is a fields_Reaction
fields_Reaction is a reference to a hash where the following keys are defined:
	id has a value which is a string
	mod_date has a value which is a string
	name has a value which is a string
	msid has a value which is a string
	abbr has a value which is a string
	equation has a value which is a string
	reversibility has a value which is a string


=end text



=item Description



=back

=cut

sub query_entity_Reaction
{
    my $self = shift;
    my($qry, $fields) = @_;

    my @_bad_arguments;
    (ref($qry) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"qry\" (value was \"$qry\")");
    (ref($fields) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"fields\" (value was \"$fields\")");
    if (@_bad_arguments) {
	my $msg = "Invalid arguments passed to query_entity_Reaction:\n" . join("", map { "\t$_\n" } @_bad_arguments);
	Bio::KBase::Exceptions::ArgumentValidationError->throw(error => $msg,
							       method_name => 'query_entity_Reaction');
    }

    my $ctx = $Bio::KBase::CDMI::Service::CallContext;
    my($return);
    #BEGIN query_entity_Reaction

    $return = $self->_query_entity($ctx, 'Reaction', $qry, $fields);

    #END query_entity_Reaction
    my @_bad_returns;
    (ref($return) eq 'HASH') or push(@_bad_returns, "Invalid type for return variable \"return\" (value was \"$return\")");
    if (@_bad_returns) {
	my $msg = "Invalid returns passed to query_entity_Reaction:\n" . join("", map { "\t$_\n" } @_bad_returns);
	Bio::KBase::Exceptions::ArgumentValidationError->throw(error => $msg,
							       method_name => 'query_entity_Reaction');
    }
    return($return);
}




=head2 all_entities_Reaction

  $return = $obj->all_entities_Reaction($start, $count, $fields)

=over 4

=item Parameter and return types

=begin html

<pre>
$start is an int
$count is an int
$fields is a reference to a list where each element is a string
$return is a reference to a hash where the key is a string and the value is a fields_Reaction
fields_Reaction is a reference to a hash where the following keys are defined:
	id has a value which is a string
	mod_date has a value which is a string
	name has a value which is a string
	msid has a value which is a string
	abbr has a value which is a string
	equation has a value which is a string
	reversibility has a value which is a string

</pre>

=end html

=begin text

$start is an int
$count is an int
$fields is a reference to a list where each element is a string
$return is a reference to a hash where the key is a string and the value is a fields_Reaction
fields_Reaction is a reference to a hash where the following keys are defined:
	id has a value which is a string
	mod_date has a value which is a string
	name has a value which is a string
	msid has a value which is a string
	abbr has a value which is a string
	equation has a value which is a string
	reversibility has a value which is a string


=end text



=item Description



=back

=cut

sub all_entities_Reaction
{
    my $self = shift;
    my($start, $count, $fields) = @_;

    my @_bad_arguments;
    (!ref($start)) or push(@_bad_arguments, "Invalid type for argument \"start\" (value was \"$start\")");
    (!ref($count)) or push(@_bad_arguments, "Invalid type for argument \"count\" (value was \"$count\")");
    (ref($fields) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"fields\" (value was \"$fields\")");
    if (@_bad_arguments) {
	my $msg = "Invalid arguments passed to all_entities_Reaction:\n" . join("", map { "\t$_\n" } @_bad_arguments);
	Bio::KBase::Exceptions::ArgumentValidationError->throw(error => $msg,
							       method_name => 'all_entities_Reaction');
    }

    my $ctx = $Bio::KBase::CDMI::Service::CallContext;
    my($return);
    #BEGIN all_entities_Reaction

    $return = $self->_all_entities($ctx, 'Reaction', $start, $count, $fields);

    #END all_entities_Reaction
    my @_bad_returns;
    (ref($return) eq 'HASH') or push(@_bad_returns, "Invalid type for return variable \"return\" (value was \"$return\")");
    if (@_bad_returns) {
	my $msg = "Invalid returns passed to all_entities_Reaction:\n" . join("", map { "\t$_\n" } @_bad_returns);
	Bio::KBase::Exceptions::ArgumentValidationError->throw(error => $msg,
							       method_name => 'all_entities_Reaction');
    }
    return($return);
}




=head2 get_entity_ReactionRule

  $return = $obj->get_entity_ReactionRule($ids, $fields)

=over 4

=item Parameter and return types

=begin html

<pre>
$ids is a reference to a list where each element is a string
$fields is a reference to a list where each element is a string
$return is a reference to a hash where the key is a string and the value is a fields_ReactionRule
fields_ReactionRule is a reference to a hash where the following keys are defined:
	id has a value which is a string
	direction has a value which is a string
	transproton has a value which is a float

</pre>

=end html

=begin text

$ids is a reference to a list where each element is a string
$fields is a reference to a list where each element is a string
$return is a reference to a hash where the key is a string and the value is a fields_ReactionRule
fields_ReactionRule is a reference to a hash where the following keys are defined:
	id has a value which is a string
	direction has a value which is a string
	transproton has a value which is a float


=end text



=item Description

A reaction rule represents the way a reaction takes place
within the context of a complex.
It has the following fields:

=over 4


=item direction

reaction directionality (> for forward, < for
backward, = for bidirectional) with respect to this complex


=item transproton

ask Chris



=back

=back

=cut

sub get_entity_ReactionRule
{
    my $self = shift;
    my($ids, $fields) = @_;

    my @_bad_arguments;
    (ref($ids) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"ids\" (value was \"$ids\")");
    (ref($fields) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"fields\" (value was \"$fields\")");
    if (@_bad_arguments) {
	my $msg = "Invalid arguments passed to get_entity_ReactionRule:\n" . join("", map { "\t$_\n" } @_bad_arguments);
	Bio::KBase::Exceptions::ArgumentValidationError->throw(error => $msg,
							       method_name => 'get_entity_ReactionRule');
    }

    my $ctx = $Bio::KBase::CDMI::Service::CallContext;
    my($return);
    #BEGIN get_entity_ReactionRule

    $return = $self->_get_entity($ctx, 'ReactionRule', $ids, $fields);

    #END get_entity_ReactionRule
    my @_bad_returns;
    (ref($return) eq 'HASH') or push(@_bad_returns, "Invalid type for return variable \"return\" (value was \"$return\")");
    if (@_bad_returns) {
	my $msg = "Invalid returns passed to get_entity_ReactionRule:\n" . join("", map { "\t$_\n" } @_bad_returns);
	Bio::KBase::Exceptions::ArgumentValidationError->throw(error => $msg,
							       method_name => 'get_entity_ReactionRule');
    }
    return($return);
}




=head2 query_entity_ReactionRule

  $return = $obj->query_entity_ReactionRule($qry, $fields)

=over 4

=item Parameter and return types

=begin html

<pre>
$qry is a reference to a list where each element is a reference to a list containing 3 items:
	0: a string
	1: a string
	2: a string
$fields is a reference to a list where each element is a string
$return is a reference to a hash where the key is a string and the value is a fields_ReactionRule
fields_ReactionRule is a reference to a hash where the following keys are defined:
	id has a value which is a string
	direction has a value which is a string
	transproton has a value which is a float

</pre>

=end html

=begin text

$qry is a reference to a list where each element is a reference to a list containing 3 items:
	0: a string
	1: a string
	2: a string
$fields is a reference to a list where each element is a string
$return is a reference to a hash where the key is a string and the value is a fields_ReactionRule
fields_ReactionRule is a reference to a hash where the following keys are defined:
	id has a value which is a string
	direction has a value which is a string
	transproton has a value which is a float


=end text



=item Description



=back

=cut

sub query_entity_ReactionRule
{
    my $self = shift;
    my($qry, $fields) = @_;

    my @_bad_arguments;
    (ref($qry) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"qry\" (value was \"$qry\")");
    (ref($fields) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"fields\" (value was \"$fields\")");
    if (@_bad_arguments) {
	my $msg = "Invalid arguments passed to query_entity_ReactionRule:\n" . join("", map { "\t$_\n" } @_bad_arguments);
	Bio::KBase::Exceptions::ArgumentValidationError->throw(error => $msg,
							       method_name => 'query_entity_ReactionRule');
    }

    my $ctx = $Bio::KBase::CDMI::Service::CallContext;
    my($return);
    #BEGIN query_entity_ReactionRule

    $return = $self->_query_entity($ctx, 'ReactionRule', $qry, $fields);

    #END query_entity_ReactionRule
    my @_bad_returns;
    (ref($return) eq 'HASH') or push(@_bad_returns, "Invalid type for return variable \"return\" (value was \"$return\")");
    if (@_bad_returns) {
	my $msg = "Invalid returns passed to query_entity_ReactionRule:\n" . join("", map { "\t$_\n" } @_bad_returns);
	Bio::KBase::Exceptions::ArgumentValidationError->throw(error => $msg,
							       method_name => 'query_entity_ReactionRule');
    }
    return($return);
}




=head2 all_entities_ReactionRule

  $return = $obj->all_entities_ReactionRule($start, $count, $fields)

=over 4

=item Parameter and return types

=begin html

<pre>
$start is an int
$count is an int
$fields is a reference to a list where each element is a string
$return is a reference to a hash where the key is a string and the value is a fields_ReactionRule
fields_ReactionRule is a reference to a hash where the following keys are defined:
	id has a value which is a string
	direction has a value which is a string
	transproton has a value which is a float

</pre>

=end html

=begin text

$start is an int
$count is an int
$fields is a reference to a list where each element is a string
$return is a reference to a hash where the key is a string and the value is a fields_ReactionRule
fields_ReactionRule is a reference to a hash where the following keys are defined:
	id has a value which is a string
	direction has a value which is a string
	transproton has a value which is a float


=end text



=item Description



=back

=cut

sub all_entities_ReactionRule
{
    my $self = shift;
    my($start, $count, $fields) = @_;

    my @_bad_arguments;
    (!ref($start)) or push(@_bad_arguments, "Invalid type for argument \"start\" (value was \"$start\")");
    (!ref($count)) or push(@_bad_arguments, "Invalid type for argument \"count\" (value was \"$count\")");
    (ref($fields) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"fields\" (value was \"$fields\")");
    if (@_bad_arguments) {
	my $msg = "Invalid arguments passed to all_entities_ReactionRule:\n" . join("", map { "\t$_\n" } @_bad_arguments);
	Bio::KBase::Exceptions::ArgumentValidationError->throw(error => $msg,
							       method_name => 'all_entities_ReactionRule');
    }

    my $ctx = $Bio::KBase::CDMI::Service::CallContext;
    my($return);
    #BEGIN all_entities_ReactionRule

    $return = $self->_all_entities($ctx, 'ReactionRule', $start, $count, $fields);

    #END all_entities_ReactionRule
    my @_bad_returns;
    (ref($return) eq 'HASH') or push(@_bad_returns, "Invalid type for return variable \"return\" (value was \"$return\")");
    if (@_bad_returns) {
	my $msg = "Invalid returns passed to all_entities_ReactionRule:\n" . join("", map { "\t$_\n" } @_bad_returns);
	Bio::KBase::Exceptions::ArgumentValidationError->throw(error => $msg,
							       method_name => 'all_entities_ReactionRule');
    }
    return($return);
}




=head2 get_entity_Reagent

  $return = $obj->get_entity_Reagent($ids, $fields)

=over 4

=item Parameter and return types

=begin html

<pre>
$ids is a reference to a list where each element is a string
$fields is a reference to a list where each element is a string
$return is a reference to a hash where the key is a string and the value is a fields_Reagent
fields_Reagent is a reference to a hash where the following keys are defined:
	id has a value which is a string
	stoichiometry has a value which is a float
	cofactor has a value which is an int
	compartment_index has a value which is an int
	transport_coefficient has a value which is a float

</pre>

=end html

=begin text

$ids is a reference to a list where each element is a string
$fields is a reference to a list where each element is a string
$return is a reference to a hash where the key is a string and the value is a fields_Reagent
fields_Reagent is a reference to a hash where the following keys are defined:
	id has a value which is a string
	stoichiometry has a value which is a float
	cofactor has a value which is an int
	compartment_index has a value which is an int
	transport_coefficient has a value which is a float


=end text



=item Description

This entity represents a compound as it is used by
a specific reaction. A reaction involves many compounds, and a
compound can be involved in many reactions. The reagent
describes the use of the compound by a specific reaction.
It has the following fields:

=over 4


=item stoichiometry

Number of molecules of the compound that participate
in a single instance of the reaction. For example, if a
reaction produces two water molecules, the stoichiometry of
water for the reaction would be two. When a reaction is
written on paper in chemical notation, the stoichiometry is
the number next to the chemical formula of the
compound. The value is negative for substrates and positive
for products.


=item cofactor

TRUE if the compound is a cofactor; FALSE if it is a major
component of the reaction.


=item compartment_index

Abstract number that groups this reagent into a
compartment. Each group can then be assigned to real
compartments when doing comparative analysis.


=item transport_coefficient

Number of reagents of this type transported.
A positive value implies transport into the reactions
default compartment; a negative value implies export
to the reagent's specified compartment.



=back

=back

=cut

sub get_entity_Reagent
{
    my $self = shift;
    my($ids, $fields) = @_;

    my @_bad_arguments;
    (ref($ids) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"ids\" (value was \"$ids\")");
    (ref($fields) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"fields\" (value was \"$fields\")");
    if (@_bad_arguments) {
	my $msg = "Invalid arguments passed to get_entity_Reagent:\n" . join("", map { "\t$_\n" } @_bad_arguments);
	Bio::KBase::Exceptions::ArgumentValidationError->throw(error => $msg,
							       method_name => 'get_entity_Reagent');
    }

    my $ctx = $Bio::KBase::CDMI::Service::CallContext;
    my($return);
    #BEGIN get_entity_Reagent

    $return = $self->_get_entity($ctx, 'Reagent', $ids, $fields);

    #END get_entity_Reagent
    my @_bad_returns;
    (ref($return) eq 'HASH') or push(@_bad_returns, "Invalid type for return variable \"return\" (value was \"$return\")");
    if (@_bad_returns) {
	my $msg = "Invalid returns passed to get_entity_Reagent:\n" . join("", map { "\t$_\n" } @_bad_returns);
	Bio::KBase::Exceptions::ArgumentValidationError->throw(error => $msg,
							       method_name => 'get_entity_Reagent');
    }
    return($return);
}




=head2 query_entity_Reagent

  $return = $obj->query_entity_Reagent($qry, $fields)

=over 4

=item Parameter and return types

=begin html

<pre>
$qry is a reference to a list where each element is a reference to a list containing 3 items:
	0: a string
	1: a string
	2: a string
$fields is a reference to a list where each element is a string
$return is a reference to a hash where the key is a string and the value is a fields_Reagent
fields_Reagent is a reference to a hash where the following keys are defined:
	id has a value which is a string
	stoichiometry has a value which is a float
	cofactor has a value which is an int
	compartment_index has a value which is an int
	transport_coefficient has a value which is a float

</pre>

=end html

=begin text

$qry is a reference to a list where each element is a reference to a list containing 3 items:
	0: a string
	1: a string
	2: a string
$fields is a reference to a list where each element is a string
$return is a reference to a hash where the key is a string and the value is a fields_Reagent
fields_Reagent is a reference to a hash where the following keys are defined:
	id has a value which is a string
	stoichiometry has a value which is a float
	cofactor has a value which is an int
	compartment_index has a value which is an int
	transport_coefficient has a value which is a float


=end text



=item Description



=back

=cut

sub query_entity_Reagent
{
    my $self = shift;
    my($qry, $fields) = @_;

    my @_bad_arguments;
    (ref($qry) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"qry\" (value was \"$qry\")");
    (ref($fields) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"fields\" (value was \"$fields\")");
    if (@_bad_arguments) {
	my $msg = "Invalid arguments passed to query_entity_Reagent:\n" . join("", map { "\t$_\n" } @_bad_arguments);
	Bio::KBase::Exceptions::ArgumentValidationError->throw(error => $msg,
							       method_name => 'query_entity_Reagent');
    }

    my $ctx = $Bio::KBase::CDMI::Service::CallContext;
    my($return);
    #BEGIN query_entity_Reagent

    $return = $self->_query_entity($ctx, 'Reagent', $qry, $fields);

    #END query_entity_Reagent
    my @_bad_returns;
    (ref($return) eq 'HASH') or push(@_bad_returns, "Invalid type for return variable \"return\" (value was \"$return\")");
    if (@_bad_returns) {
	my $msg = "Invalid returns passed to query_entity_Reagent:\n" . join("", map { "\t$_\n" } @_bad_returns);
	Bio::KBase::Exceptions::ArgumentValidationError->throw(error => $msg,
							       method_name => 'query_entity_Reagent');
    }
    return($return);
}




=head2 all_entities_Reagent

  $return = $obj->all_entities_Reagent($start, $count, $fields)

=over 4

=item Parameter and return types

=begin html

<pre>
$start is an int
$count is an int
$fields is a reference to a list where each element is a string
$return is a reference to a hash where the key is a string and the value is a fields_Reagent
fields_Reagent is a reference to a hash where the following keys are defined:
	id has a value which is a string
	stoichiometry has a value which is a float
	cofactor has a value which is an int
	compartment_index has a value which is an int
	transport_coefficient has a value which is a float

</pre>

=end html

=begin text

$start is an int
$count is an int
$fields is a reference to a list where each element is a string
$return is a reference to a hash where the key is a string and the value is a fields_Reagent
fields_Reagent is a reference to a hash where the following keys are defined:
	id has a value which is a string
	stoichiometry has a value which is a float
	cofactor has a value which is an int
	compartment_index has a value which is an int
	transport_coefficient has a value which is a float


=end text



=item Description



=back

=cut

sub all_entities_Reagent
{
    my $self = shift;
    my($start, $count, $fields) = @_;

    my @_bad_arguments;
    (!ref($start)) or push(@_bad_arguments, "Invalid type for argument \"start\" (value was \"$start\")");
    (!ref($count)) or push(@_bad_arguments, "Invalid type for argument \"count\" (value was \"$count\")");
    (ref($fields) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"fields\" (value was \"$fields\")");
    if (@_bad_arguments) {
	my $msg = "Invalid arguments passed to all_entities_Reagent:\n" . join("", map { "\t$_\n" } @_bad_arguments);
	Bio::KBase::Exceptions::ArgumentValidationError->throw(error => $msg,
							       method_name => 'all_entities_Reagent');
    }

    my $ctx = $Bio::KBase::CDMI::Service::CallContext;
    my($return);
    #BEGIN all_entities_Reagent

    $return = $self->_all_entities($ctx, 'Reagent', $start, $count, $fields);

    #END all_entities_Reagent
    my @_bad_returns;
    (ref($return) eq 'HASH') or push(@_bad_returns, "Invalid type for return variable \"return\" (value was \"$return\")");
    if (@_bad_returns) {
	my $msg = "Invalid returns passed to all_entities_Reagent:\n" . join("", map { "\t$_\n" } @_bad_returns);
	Bio::KBase::Exceptions::ArgumentValidationError->throw(error => $msg,
							       method_name => 'all_entities_Reagent');
    }
    return($return);
}




=head2 get_entity_Requirement

  $return = $obj->get_entity_Requirement($ids, $fields)

=over 4

=item Parameter and return types

=begin html

<pre>
$ids is a reference to a list where each element is a string
$fields is a reference to a list where each element is a string
$return is a reference to a hash where the key is a string and the value is a fields_Requirement
fields_Requirement is a reference to a hash where the following keys are defined:
	id has a value which is a string
	direction has a value which is a string
	transproton has a value which is a float
	proton has a value which is a float

</pre>

=end html

=begin text

$ids is a reference to a list where each element is a string
$fields is a reference to a list where each element is a string
$return is a reference to a hash where the key is a string and the value is a fields_Requirement
fields_Requirement is a reference to a hash where the following keys are defined:
	id has a value which is a string
	direction has a value which is a string
	transproton has a value which is a float
	proton has a value which is a float


=end text



=item Description

A requirement describes the way a reaction fits
into a model.
It has the following fields:

=over 4


=item direction

reaction directionality (> for forward, < for
backward, = for bidirectional) with respect to this model


=item transproton

ask Chris


=item proton

ask Chris



=back

=back

=cut

sub get_entity_Requirement
{
    my $self = shift;
    my($ids, $fields) = @_;

    my @_bad_arguments;
    (ref($ids) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"ids\" (value was \"$ids\")");
    (ref($fields) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"fields\" (value was \"$fields\")");
    if (@_bad_arguments) {
	my $msg = "Invalid arguments passed to get_entity_Requirement:\n" . join("", map { "\t$_\n" } @_bad_arguments);
	Bio::KBase::Exceptions::ArgumentValidationError->throw(error => $msg,
							       method_name => 'get_entity_Requirement');
    }

    my $ctx = $Bio::KBase::CDMI::Service::CallContext;
    my($return);
    #BEGIN get_entity_Requirement

    $return = $self->_get_entity($ctx, 'Requirement', $ids, $fields);

    #END get_entity_Requirement
    my @_bad_returns;
    (ref($return) eq 'HASH') or push(@_bad_returns, "Invalid type for return variable \"return\" (value was \"$return\")");
    if (@_bad_returns) {
	my $msg = "Invalid returns passed to get_entity_Requirement:\n" . join("", map { "\t$_\n" } @_bad_returns);
	Bio::KBase::Exceptions::ArgumentValidationError->throw(error => $msg,
							       method_name => 'get_entity_Requirement');
    }
    return($return);
}




=head2 query_entity_Requirement

  $return = $obj->query_entity_Requirement($qry, $fields)

=over 4

=item Parameter and return types

=begin html

<pre>
$qry is a reference to a list where each element is a reference to a list containing 3 items:
	0: a string
	1: a string
	2: a string
$fields is a reference to a list where each element is a string
$return is a reference to a hash where the key is a string and the value is a fields_Requirement
fields_Requirement is a reference to a hash where the following keys are defined:
	id has a value which is a string
	direction has a value which is a string
	transproton has a value which is a float
	proton has a value which is a float

</pre>

=end html

=begin text

$qry is a reference to a list where each element is a reference to a list containing 3 items:
	0: a string
	1: a string
	2: a string
$fields is a reference to a list where each element is a string
$return is a reference to a hash where the key is a string and the value is a fields_Requirement
fields_Requirement is a reference to a hash where the following keys are defined:
	id has a value which is a string
	direction has a value which is a string
	transproton has a value which is a float
	proton has a value which is a float


=end text



=item Description



=back

=cut

sub query_entity_Requirement
{
    my $self = shift;
    my($qry, $fields) = @_;

    my @_bad_arguments;
    (ref($qry) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"qry\" (value was \"$qry\")");
    (ref($fields) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"fields\" (value was \"$fields\")");
    if (@_bad_arguments) {
	my $msg = "Invalid arguments passed to query_entity_Requirement:\n" . join("", map { "\t$_\n" } @_bad_arguments);
	Bio::KBase::Exceptions::ArgumentValidationError->throw(error => $msg,
							       method_name => 'query_entity_Requirement');
    }

    my $ctx = $Bio::KBase::CDMI::Service::CallContext;
    my($return);
    #BEGIN query_entity_Requirement

    $return = $self->_query_entity($ctx, 'Requirement', $qry, $fields);

    #END query_entity_Requirement
    my @_bad_returns;
    (ref($return) eq 'HASH') or push(@_bad_returns, "Invalid type for return variable \"return\" (value was \"$return\")");
    if (@_bad_returns) {
	my $msg = "Invalid returns passed to query_entity_Requirement:\n" . join("", map { "\t$_\n" } @_bad_returns);
	Bio::KBase::Exceptions::ArgumentValidationError->throw(error => $msg,
							       method_name => 'query_entity_Requirement');
    }
    return($return);
}




=head2 all_entities_Requirement

  $return = $obj->all_entities_Requirement($start, $count, $fields)

=over 4

=item Parameter and return types

=begin html

<pre>
$start is an int
$count is an int
$fields is a reference to a list where each element is a string
$return is a reference to a hash where the key is a string and the value is a fields_Requirement
fields_Requirement is a reference to a hash where the following keys are defined:
	id has a value which is a string
	direction has a value which is a string
	transproton has a value which is a float
	proton has a value which is a float

</pre>

=end html

=begin text

$start is an int
$count is an int
$fields is a reference to a list where each element is a string
$return is a reference to a hash where the key is a string and the value is a fields_Requirement
fields_Requirement is a reference to a hash where the following keys are defined:
	id has a value which is a string
	direction has a value which is a string
	transproton has a value which is a float
	proton has a value which is a float


=end text



=item Description



=back

=cut

sub all_entities_Requirement
{
    my $self = shift;
    my($start, $count, $fields) = @_;

    my @_bad_arguments;
    (!ref($start)) or push(@_bad_arguments, "Invalid type for argument \"start\" (value was \"$start\")");
    (!ref($count)) or push(@_bad_arguments, "Invalid type for argument \"count\" (value was \"$count\")");
    (ref($fields) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"fields\" (value was \"$fields\")");
    if (@_bad_arguments) {
	my $msg = "Invalid arguments passed to all_entities_Requirement:\n" . join("", map { "\t$_\n" } @_bad_arguments);
	Bio::KBase::Exceptions::ArgumentValidationError->throw(error => $msg,
							       method_name => 'all_entities_Requirement');
    }

    my $ctx = $Bio::KBase::CDMI::Service::CallContext;
    my($return);
    #BEGIN all_entities_Requirement

    $return = $self->_all_entities($ctx, 'Requirement', $start, $count, $fields);

    #END all_entities_Requirement
    my @_bad_returns;
    (ref($return) eq 'HASH') or push(@_bad_returns, "Invalid type for return variable \"return\" (value was \"$return\")");
    if (@_bad_returns) {
	my $msg = "Invalid returns passed to all_entities_Requirement:\n" . join("", map { "\t$_\n" } @_bad_returns);
	Bio::KBase::Exceptions::ArgumentValidationError->throw(error => $msg,
							       method_name => 'all_entities_Requirement');
    }
    return($return);
}




=head2 get_entity_Role

  $return = $obj->get_entity_Role($ids, $fields)

=over 4

=item Parameter and return types

=begin html

<pre>
$ids is a reference to a list where each element is a string
$fields is a reference to a list where each element is a string
$return is a reference to a hash where the key is a string and the value is a fields_Role
fields_Role is a reference to a hash where the following keys are defined:
	id has a value which is a string
	hypothetical has a value which is an int

</pre>

=end html

=begin text

$ids is a reference to a list where each element is a string
$fields is a reference to a list where each element is a string
$return is a reference to a hash where the key is a string and the value is a fields_Role
fields_Role is a reference to a hash where the following keys are defined:
	id has a value which is a string
	hypothetical has a value which is an int


=end text



=item Description

A role describes a biological function that may be fulfilled
by a feature. One of the main goals of the database is to assign
features to roles. Most roles are effected by the construction of
proteins. Some, however, deal with functional regulation and message
transmission.
It has the following fields:

=over 4


=item hypothetical

TRUE if a role is hypothetical, else FALSE



=back

=back

=cut

sub get_entity_Role
{
    my $self = shift;
    my($ids, $fields) = @_;

    my @_bad_arguments;
    (ref($ids) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"ids\" (value was \"$ids\")");
    (ref($fields) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"fields\" (value was \"$fields\")");
    if (@_bad_arguments) {
	my $msg = "Invalid arguments passed to get_entity_Role:\n" . join("", map { "\t$_\n" } @_bad_arguments);
	Bio::KBase::Exceptions::ArgumentValidationError->throw(error => $msg,
							       method_name => 'get_entity_Role');
    }

    my $ctx = $Bio::KBase::CDMI::Service::CallContext;
    my($return);
    #BEGIN get_entity_Role

    $return = $self->_get_entity($ctx, 'Role', $ids, $fields);

    #END get_entity_Role
    my @_bad_returns;
    (ref($return) eq 'HASH') or push(@_bad_returns, "Invalid type for return variable \"return\" (value was \"$return\")");
    if (@_bad_returns) {
	my $msg = "Invalid returns passed to get_entity_Role:\n" . join("", map { "\t$_\n" } @_bad_returns);
	Bio::KBase::Exceptions::ArgumentValidationError->throw(error => $msg,
							       method_name => 'get_entity_Role');
    }
    return($return);
}




=head2 query_entity_Role

  $return = $obj->query_entity_Role($qry, $fields)

=over 4

=item Parameter and return types

=begin html

<pre>
$qry is a reference to a list where each element is a reference to a list containing 3 items:
	0: a string
	1: a string
	2: a string
$fields is a reference to a list where each element is a string
$return is a reference to a hash where the key is a string and the value is a fields_Role
fields_Role is a reference to a hash where the following keys are defined:
	id has a value which is a string
	hypothetical has a value which is an int

</pre>

=end html

=begin text

$qry is a reference to a list where each element is a reference to a list containing 3 items:
	0: a string
	1: a string
	2: a string
$fields is a reference to a list where each element is a string
$return is a reference to a hash where the key is a string and the value is a fields_Role
fields_Role is a reference to a hash where the following keys are defined:
	id has a value which is a string
	hypothetical has a value which is an int


=end text



=item Description



=back

=cut

sub query_entity_Role
{
    my $self = shift;
    my($qry, $fields) = @_;

    my @_bad_arguments;
    (ref($qry) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"qry\" (value was \"$qry\")");
    (ref($fields) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"fields\" (value was \"$fields\")");
    if (@_bad_arguments) {
	my $msg = "Invalid arguments passed to query_entity_Role:\n" . join("", map { "\t$_\n" } @_bad_arguments);
	Bio::KBase::Exceptions::ArgumentValidationError->throw(error => $msg,
							       method_name => 'query_entity_Role');
    }

    my $ctx = $Bio::KBase::CDMI::Service::CallContext;
    my($return);
    #BEGIN query_entity_Role

    $return = $self->_query_entity($ctx, 'Role', $qry, $fields);

    #END query_entity_Role
    my @_bad_returns;
    (ref($return) eq 'HASH') or push(@_bad_returns, "Invalid type for return variable \"return\" (value was \"$return\")");
    if (@_bad_returns) {
	my $msg = "Invalid returns passed to query_entity_Role:\n" . join("", map { "\t$_\n" } @_bad_returns);
	Bio::KBase::Exceptions::ArgumentValidationError->throw(error => $msg,
							       method_name => 'query_entity_Role');
    }
    return($return);
}




=head2 all_entities_Role

  $return = $obj->all_entities_Role($start, $count, $fields)

=over 4

=item Parameter and return types

=begin html

<pre>
$start is an int
$count is an int
$fields is a reference to a list where each element is a string
$return is a reference to a hash where the key is a string and the value is a fields_Role
fields_Role is a reference to a hash where the following keys are defined:
	id has a value which is a string
	hypothetical has a value which is an int

</pre>

=end html

=begin text

$start is an int
$count is an int
$fields is a reference to a list where each element is a string
$return is a reference to a hash where the key is a string and the value is a fields_Role
fields_Role is a reference to a hash where the following keys are defined:
	id has a value which is a string
	hypothetical has a value which is an int


=end text



=item Description



=back

=cut

sub all_entities_Role
{
    my $self = shift;
    my($start, $count, $fields) = @_;

    my @_bad_arguments;
    (!ref($start)) or push(@_bad_arguments, "Invalid type for argument \"start\" (value was \"$start\")");
    (!ref($count)) or push(@_bad_arguments, "Invalid type for argument \"count\" (value was \"$count\")");
    (ref($fields) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"fields\" (value was \"$fields\")");
    if (@_bad_arguments) {
	my $msg = "Invalid arguments passed to all_entities_Role:\n" . join("", map { "\t$_\n" } @_bad_arguments);
	Bio::KBase::Exceptions::ArgumentValidationError->throw(error => $msg,
							       method_name => 'all_entities_Role');
    }

    my $ctx = $Bio::KBase::CDMI::Service::CallContext;
    my($return);
    #BEGIN all_entities_Role

    $return = $self->_all_entities($ctx, 'Role', $start, $count, $fields);

    #END all_entities_Role
    my @_bad_returns;
    (ref($return) eq 'HASH') or push(@_bad_returns, "Invalid type for return variable \"return\" (value was \"$return\")");
    if (@_bad_returns) {
	my $msg = "Invalid returns passed to all_entities_Role:\n" . join("", map { "\t$_\n" } @_bad_returns);
	Bio::KBase::Exceptions::ArgumentValidationError->throw(error => $msg,
							       method_name => 'all_entities_Role');
    }
    return($return);
}




=head2 get_entity_SSCell

  $return = $obj->get_entity_SSCell($ids, $fields)

=over 4

=item Parameter and return types

=begin html

<pre>
$ids is a reference to a list where each element is a string
$fields is a reference to a list where each element is a string
$return is a reference to a hash where the key is a string and the value is a fields_SSCell
fields_SSCell is a reference to a hash where the following keys are defined:
	id has a value which is a string

</pre>

=end html

=begin text

$ids is a reference to a list where each element is a string
$fields is a reference to a list where each element is a string
$return is a reference to a hash where the key is a string and the value is a fields_SSCell
fields_SSCell is a reference to a hash where the following keys are defined:
	id has a value which is a string


=end text



=item Description

An SSCell (SpreadSheet Cell) represents a role as it occurs
in a subsystem spreadsheet row. The key is a colon-delimited triple
containing an MD5 hash of the subsystem ID followed by a genome ID
(with optional region string) and a role abbreviation.
It has the following fields:

=over 4



=back

=back

=cut

sub get_entity_SSCell
{
    my $self = shift;
    my($ids, $fields) = @_;

    my @_bad_arguments;
    (ref($ids) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"ids\" (value was \"$ids\")");
    (ref($fields) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"fields\" (value was \"$fields\")");
    if (@_bad_arguments) {
	my $msg = "Invalid arguments passed to get_entity_SSCell:\n" . join("", map { "\t$_\n" } @_bad_arguments);
	Bio::KBase::Exceptions::ArgumentValidationError->throw(error => $msg,
							       method_name => 'get_entity_SSCell');
    }

    my $ctx = $Bio::KBase::CDMI::Service::CallContext;
    my($return);
    #BEGIN get_entity_SSCell

    $return = $self->_get_entity($ctx, 'SSCell', $ids, $fields);

    #END get_entity_SSCell
    my @_bad_returns;
    (ref($return) eq 'HASH') or push(@_bad_returns, "Invalid type for return variable \"return\" (value was \"$return\")");
    if (@_bad_returns) {
	my $msg = "Invalid returns passed to get_entity_SSCell:\n" . join("", map { "\t$_\n" } @_bad_returns);
	Bio::KBase::Exceptions::ArgumentValidationError->throw(error => $msg,
							       method_name => 'get_entity_SSCell');
    }
    return($return);
}




=head2 query_entity_SSCell

  $return = $obj->query_entity_SSCell($qry, $fields)

=over 4

=item Parameter and return types

=begin html

<pre>
$qry is a reference to a list where each element is a reference to a list containing 3 items:
	0: a string
	1: a string
	2: a string
$fields is a reference to a list where each element is a string
$return is a reference to a hash where the key is a string and the value is a fields_SSCell
fields_SSCell is a reference to a hash where the following keys are defined:
	id has a value which is a string

</pre>

=end html

=begin text

$qry is a reference to a list where each element is a reference to a list containing 3 items:
	0: a string
	1: a string
	2: a string
$fields is a reference to a list where each element is a string
$return is a reference to a hash where the key is a string and the value is a fields_SSCell
fields_SSCell is a reference to a hash where the following keys are defined:
	id has a value which is a string


=end text



=item Description



=back

=cut

sub query_entity_SSCell
{
    my $self = shift;
    my($qry, $fields) = @_;

    my @_bad_arguments;
    (ref($qry) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"qry\" (value was \"$qry\")");
    (ref($fields) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"fields\" (value was \"$fields\")");
    if (@_bad_arguments) {
	my $msg = "Invalid arguments passed to query_entity_SSCell:\n" . join("", map { "\t$_\n" } @_bad_arguments);
	Bio::KBase::Exceptions::ArgumentValidationError->throw(error => $msg,
							       method_name => 'query_entity_SSCell');
    }

    my $ctx = $Bio::KBase::CDMI::Service::CallContext;
    my($return);
    #BEGIN query_entity_SSCell

    $return = $self->_query_entity($ctx, 'SSCell', $qry, $fields);

    #END query_entity_SSCell
    my @_bad_returns;
    (ref($return) eq 'HASH') or push(@_bad_returns, "Invalid type for return variable \"return\" (value was \"$return\")");
    if (@_bad_returns) {
	my $msg = "Invalid returns passed to query_entity_SSCell:\n" . join("", map { "\t$_\n" } @_bad_returns);
	Bio::KBase::Exceptions::ArgumentValidationError->throw(error => $msg,
							       method_name => 'query_entity_SSCell');
    }
    return($return);
}




=head2 all_entities_SSCell

  $return = $obj->all_entities_SSCell($start, $count, $fields)

=over 4

=item Parameter and return types

=begin html

<pre>
$start is an int
$count is an int
$fields is a reference to a list where each element is a string
$return is a reference to a hash where the key is a string and the value is a fields_SSCell
fields_SSCell is a reference to a hash where the following keys are defined:
	id has a value which is a string

</pre>

=end html

=begin text

$start is an int
$count is an int
$fields is a reference to a list where each element is a string
$return is a reference to a hash where the key is a string and the value is a fields_SSCell
fields_SSCell is a reference to a hash where the following keys are defined:
	id has a value which is a string


=end text



=item Description



=back

=cut

sub all_entities_SSCell
{
    my $self = shift;
    my($start, $count, $fields) = @_;

    my @_bad_arguments;
    (!ref($start)) or push(@_bad_arguments, "Invalid type for argument \"start\" (value was \"$start\")");
    (!ref($count)) or push(@_bad_arguments, "Invalid type for argument \"count\" (value was \"$count\")");
    (ref($fields) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"fields\" (value was \"$fields\")");
    if (@_bad_arguments) {
	my $msg = "Invalid arguments passed to all_entities_SSCell:\n" . join("", map { "\t$_\n" } @_bad_arguments);
	Bio::KBase::Exceptions::ArgumentValidationError->throw(error => $msg,
							       method_name => 'all_entities_SSCell');
    }

    my $ctx = $Bio::KBase::CDMI::Service::CallContext;
    my($return);
    #BEGIN all_entities_SSCell

    $return = $self->_all_entities($ctx, 'SSCell', $start, $count, $fields);

    #END all_entities_SSCell
    my @_bad_returns;
    (ref($return) eq 'HASH') or push(@_bad_returns, "Invalid type for return variable \"return\" (value was \"$return\")");
    if (@_bad_returns) {
	my $msg = "Invalid returns passed to all_entities_SSCell:\n" . join("", map { "\t$_\n" } @_bad_returns);
	Bio::KBase::Exceptions::ArgumentValidationError->throw(error => $msg,
							       method_name => 'all_entities_SSCell');
    }
    return($return);
}




=head2 get_entity_SSRow

  $return = $obj->get_entity_SSRow($ids, $fields)

=over 4

=item Parameter and return types

=begin html

<pre>
$ids is a reference to a list where each element is a string
$fields is a reference to a list where each element is a string
$return is a reference to a hash where the key is a string and the value is a fields_SSRow
fields_SSRow is a reference to a hash where the following keys are defined:
	id has a value which is a string
	curated has a value which is an int
	region has a value which is a string

</pre>

=end html

=begin text

$ids is a reference to a list where each element is a string
$fields is a reference to a list where each element is a string
$return is a reference to a hash where the key is a string and the value is a fields_SSRow
fields_SSRow is a reference to a hash where the following keys are defined:
	id has a value which is a string
	curated has a value which is an int
	region has a value which is a string


=end text



=item Description

An SSRow (that is, a row in a subsystem spreadsheet) represents a collection of
functional roles present in the Features of a single Genome.  The roles are part
of a designated subsystem, and the fids associated with each role are included in the row,
That is, a row amounts to an instance of a subsystem as it exists in a specific, designated
genome.

It has the following fields:

=over 4


=item curated

This flag is TRUE if the assignment of the molecular
machine has been curated, and FALSE if it was made by an
automated program.


=item region

Region in the genome for which the machine is relevant.
Normally, this is an empty string, indicating that the machine
covers the whole genome. If a subsystem has multiple machines
for a genome, this contains a location string describing the
region occupied by this particular machine.



=back

=back

=cut

sub get_entity_SSRow
{
    my $self = shift;
    my($ids, $fields) = @_;

    my @_bad_arguments;
    (ref($ids) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"ids\" (value was \"$ids\")");
    (ref($fields) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"fields\" (value was \"$fields\")");
    if (@_bad_arguments) {
	my $msg = "Invalid arguments passed to get_entity_SSRow:\n" . join("", map { "\t$_\n" } @_bad_arguments);
	Bio::KBase::Exceptions::ArgumentValidationError->throw(error => $msg,
							       method_name => 'get_entity_SSRow');
    }

    my $ctx = $Bio::KBase::CDMI::Service::CallContext;
    my($return);
    #BEGIN get_entity_SSRow

    $return = $self->_get_entity($ctx, 'SSRow', $ids, $fields);

    #END get_entity_SSRow
    my @_bad_returns;
    (ref($return) eq 'HASH') or push(@_bad_returns, "Invalid type for return variable \"return\" (value was \"$return\")");
    if (@_bad_returns) {
	my $msg = "Invalid returns passed to get_entity_SSRow:\n" . join("", map { "\t$_\n" } @_bad_returns);
	Bio::KBase::Exceptions::ArgumentValidationError->throw(error => $msg,
							       method_name => 'get_entity_SSRow');
    }
    return($return);
}




=head2 query_entity_SSRow

  $return = $obj->query_entity_SSRow($qry, $fields)

=over 4

=item Parameter and return types

=begin html

<pre>
$qry is a reference to a list where each element is a reference to a list containing 3 items:
	0: a string
	1: a string
	2: a string
$fields is a reference to a list where each element is a string
$return is a reference to a hash where the key is a string and the value is a fields_SSRow
fields_SSRow is a reference to a hash where the following keys are defined:
	id has a value which is a string
	curated has a value which is an int
	region has a value which is a string

</pre>

=end html

=begin text

$qry is a reference to a list where each element is a reference to a list containing 3 items:
	0: a string
	1: a string
	2: a string
$fields is a reference to a list where each element is a string
$return is a reference to a hash where the key is a string and the value is a fields_SSRow
fields_SSRow is a reference to a hash where the following keys are defined:
	id has a value which is a string
	curated has a value which is an int
	region has a value which is a string


=end text



=item Description



=back

=cut

sub query_entity_SSRow
{
    my $self = shift;
    my($qry, $fields) = @_;

    my @_bad_arguments;
    (ref($qry) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"qry\" (value was \"$qry\")");
    (ref($fields) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"fields\" (value was \"$fields\")");
    if (@_bad_arguments) {
	my $msg = "Invalid arguments passed to query_entity_SSRow:\n" . join("", map { "\t$_\n" } @_bad_arguments);
	Bio::KBase::Exceptions::ArgumentValidationError->throw(error => $msg,
							       method_name => 'query_entity_SSRow');
    }

    my $ctx = $Bio::KBase::CDMI::Service::CallContext;
    my($return);
    #BEGIN query_entity_SSRow

    $return = $self->_query_entity($ctx, 'SSRow', $qry, $fields);

    #END query_entity_SSRow
    my @_bad_returns;
    (ref($return) eq 'HASH') or push(@_bad_returns, "Invalid type for return variable \"return\" (value was \"$return\")");
    if (@_bad_returns) {
	my $msg = "Invalid returns passed to query_entity_SSRow:\n" . join("", map { "\t$_\n" } @_bad_returns);
	Bio::KBase::Exceptions::ArgumentValidationError->throw(error => $msg,
							       method_name => 'query_entity_SSRow');
    }
    return($return);
}




=head2 all_entities_SSRow

  $return = $obj->all_entities_SSRow($start, $count, $fields)

=over 4

=item Parameter and return types

=begin html

<pre>
$start is an int
$count is an int
$fields is a reference to a list where each element is a string
$return is a reference to a hash where the key is a string and the value is a fields_SSRow
fields_SSRow is a reference to a hash where the following keys are defined:
	id has a value which is a string
	curated has a value which is an int
	region has a value which is a string

</pre>

=end html

=begin text

$start is an int
$count is an int
$fields is a reference to a list where each element is a string
$return is a reference to a hash where the key is a string and the value is a fields_SSRow
fields_SSRow is a reference to a hash where the following keys are defined:
	id has a value which is a string
	curated has a value which is an int
	region has a value which is a string


=end text



=item Description



=back

=cut

sub all_entities_SSRow
{
    my $self = shift;
    my($start, $count, $fields) = @_;

    my @_bad_arguments;
    (!ref($start)) or push(@_bad_arguments, "Invalid type for argument \"start\" (value was \"$start\")");
    (!ref($count)) or push(@_bad_arguments, "Invalid type for argument \"count\" (value was \"$count\")");
    (ref($fields) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"fields\" (value was \"$fields\")");
    if (@_bad_arguments) {
	my $msg = "Invalid arguments passed to all_entities_SSRow:\n" . join("", map { "\t$_\n" } @_bad_arguments);
	Bio::KBase::Exceptions::ArgumentValidationError->throw(error => $msg,
							       method_name => 'all_entities_SSRow');
    }

    my $ctx = $Bio::KBase::CDMI::Service::CallContext;
    my($return);
    #BEGIN all_entities_SSRow

    $return = $self->_all_entities($ctx, 'SSRow', $start, $count, $fields);

    #END all_entities_SSRow
    my @_bad_returns;
    (ref($return) eq 'HASH') or push(@_bad_returns, "Invalid type for return variable \"return\" (value was \"$return\")");
    if (@_bad_returns) {
	my $msg = "Invalid returns passed to all_entities_SSRow:\n" . join("", map { "\t$_\n" } @_bad_returns);
	Bio::KBase::Exceptions::ArgumentValidationError->throw(error => $msg,
							       method_name => 'all_entities_SSRow');
    }
    return($return);
}




=head2 get_entity_Scenario

  $return = $obj->get_entity_Scenario($ids, $fields)

=over 4

=item Parameter and return types

=begin html

<pre>
$ids is a reference to a list where each element is a string
$fields is a reference to a list where each element is a string
$return is a reference to a hash where the key is a string and the value is a fields_Scenario
fields_Scenario is a reference to a hash where the following keys are defined:
	id has a value which is a string
	common_name has a value which is a string

</pre>

=end html

=begin text

$ids is a reference to a list where each element is a string
$fields is a reference to a list where each element is a string
$return is a reference to a hash where the key is a string and the value is a fields_Scenario
fields_Scenario is a reference to a hash where the following keys are defined:
	id has a value which is a string
	common_name has a value which is a string


=end text



=item Description

A scenario is a partial instance of a subsystem with a
defined set of reactions. Each scenario converts input compounds to
output compounds using reactions. The scenario may use all of the
reactions controlled by a subsystem or only some, and may also
incorporate additional reactions. Because scenario names are not
unique, the actual scenario ID is a number.
It has the following fields:

=over 4


=item common_name

Common name of the scenario. The name, rather than the ID
number, is usually displayed everywhere.



=back

=back

=cut

sub get_entity_Scenario
{
    my $self = shift;
    my($ids, $fields) = @_;

    my @_bad_arguments;
    (ref($ids) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"ids\" (value was \"$ids\")");
    (ref($fields) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"fields\" (value was \"$fields\")");
    if (@_bad_arguments) {
	my $msg = "Invalid arguments passed to get_entity_Scenario:\n" . join("", map { "\t$_\n" } @_bad_arguments);
	Bio::KBase::Exceptions::ArgumentValidationError->throw(error => $msg,
							       method_name => 'get_entity_Scenario');
    }

    my $ctx = $Bio::KBase::CDMI::Service::CallContext;
    my($return);
    #BEGIN get_entity_Scenario

    $return = $self->_get_entity($ctx, 'Scenario', $ids, $fields);

    #END get_entity_Scenario
    my @_bad_returns;
    (ref($return) eq 'HASH') or push(@_bad_returns, "Invalid type for return variable \"return\" (value was \"$return\")");
    if (@_bad_returns) {
	my $msg = "Invalid returns passed to get_entity_Scenario:\n" . join("", map { "\t$_\n" } @_bad_returns);
	Bio::KBase::Exceptions::ArgumentValidationError->throw(error => $msg,
							       method_name => 'get_entity_Scenario');
    }
    return($return);
}




=head2 query_entity_Scenario

  $return = $obj->query_entity_Scenario($qry, $fields)

=over 4

=item Parameter and return types

=begin html

<pre>
$qry is a reference to a list where each element is a reference to a list containing 3 items:
	0: a string
	1: a string
	2: a string
$fields is a reference to a list where each element is a string
$return is a reference to a hash where the key is a string and the value is a fields_Scenario
fields_Scenario is a reference to a hash where the following keys are defined:
	id has a value which is a string
	common_name has a value which is a string

</pre>

=end html

=begin text

$qry is a reference to a list where each element is a reference to a list containing 3 items:
	0: a string
	1: a string
	2: a string
$fields is a reference to a list where each element is a string
$return is a reference to a hash where the key is a string and the value is a fields_Scenario
fields_Scenario is a reference to a hash where the following keys are defined:
	id has a value which is a string
	common_name has a value which is a string


=end text



=item Description



=back

=cut

sub query_entity_Scenario
{
    my $self = shift;
    my($qry, $fields) = @_;

    my @_bad_arguments;
    (ref($qry) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"qry\" (value was \"$qry\")");
    (ref($fields) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"fields\" (value was \"$fields\")");
    if (@_bad_arguments) {
	my $msg = "Invalid arguments passed to query_entity_Scenario:\n" . join("", map { "\t$_\n" } @_bad_arguments);
	Bio::KBase::Exceptions::ArgumentValidationError->throw(error => $msg,
							       method_name => 'query_entity_Scenario');
    }

    my $ctx = $Bio::KBase::CDMI::Service::CallContext;
    my($return);
    #BEGIN query_entity_Scenario

    $return = $self->_query_entity($ctx, 'Scenario', $qry, $fields);

    #END query_entity_Scenario
    my @_bad_returns;
    (ref($return) eq 'HASH') or push(@_bad_returns, "Invalid type for return variable \"return\" (value was \"$return\")");
    if (@_bad_returns) {
	my $msg = "Invalid returns passed to query_entity_Scenario:\n" . join("", map { "\t$_\n" } @_bad_returns);
	Bio::KBase::Exceptions::ArgumentValidationError->throw(error => $msg,
							       method_name => 'query_entity_Scenario');
    }
    return($return);
}




=head2 all_entities_Scenario

  $return = $obj->all_entities_Scenario($start, $count, $fields)

=over 4

=item Parameter and return types

=begin html

<pre>
$start is an int
$count is an int
$fields is a reference to a list where each element is a string
$return is a reference to a hash where the key is a string and the value is a fields_Scenario
fields_Scenario is a reference to a hash where the following keys are defined:
	id has a value which is a string
	common_name has a value which is a string

</pre>

=end html

=begin text

$start is an int
$count is an int
$fields is a reference to a list where each element is a string
$return is a reference to a hash where the key is a string and the value is a fields_Scenario
fields_Scenario is a reference to a hash where the following keys are defined:
	id has a value which is a string
	common_name has a value which is a string


=end text



=item Description



=back

=cut

sub all_entities_Scenario
{
    my $self = shift;
    my($start, $count, $fields) = @_;

    my @_bad_arguments;
    (!ref($start)) or push(@_bad_arguments, "Invalid type for argument \"start\" (value was \"$start\")");
    (!ref($count)) or push(@_bad_arguments, "Invalid type for argument \"count\" (value was \"$count\")");
    (ref($fields) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"fields\" (value was \"$fields\")");
    if (@_bad_arguments) {
	my $msg = "Invalid arguments passed to all_entities_Scenario:\n" . join("", map { "\t$_\n" } @_bad_arguments);
	Bio::KBase::Exceptions::ArgumentValidationError->throw(error => $msg,
							       method_name => 'all_entities_Scenario');
    }

    my $ctx = $Bio::KBase::CDMI::Service::CallContext;
    my($return);
    #BEGIN all_entities_Scenario

    $return = $self->_all_entities($ctx, 'Scenario', $start, $count, $fields);

    #END all_entities_Scenario
    my @_bad_returns;
    (ref($return) eq 'HASH') or push(@_bad_returns, "Invalid type for return variable \"return\" (value was \"$return\")");
    if (@_bad_returns) {
	my $msg = "Invalid returns passed to all_entities_Scenario:\n" . join("", map { "\t$_\n" } @_bad_returns);
	Bio::KBase::Exceptions::ArgumentValidationError->throw(error => $msg,
							       method_name => 'all_entities_Scenario');
    }
    return($return);
}




=head2 get_entity_Source

  $return = $obj->get_entity_Source($ids, $fields)

=over 4

=item Parameter and return types

=begin html

<pre>
$ids is a reference to a list where each element is a string
$fields is a reference to a list where each element is a string
$return is a reference to a hash where the key is a string and the value is a fields_Source
fields_Source is a reference to a hash where the following keys are defined:
	id has a value which is a string

</pre>

=end html

=begin text

$ids is a reference to a list where each element is a string
$fields is a reference to a list where each element is a string
$return is a reference to a hash where the key is a string and the value is a fields_Source
fields_Source is a reference to a hash where the following keys are defined:
	id has a value which is a string


=end text



=item Description

A source is a user or organization that is permitted to
assign its own identifiers or to submit bioinformatic objects
to the database.
It has the following fields:

=over 4



=back

=back

=cut

sub get_entity_Source
{
    my $self = shift;
    my($ids, $fields) = @_;

    my @_bad_arguments;
    (ref($ids) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"ids\" (value was \"$ids\")");
    (ref($fields) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"fields\" (value was \"$fields\")");
    if (@_bad_arguments) {
	my $msg = "Invalid arguments passed to get_entity_Source:\n" . join("", map { "\t$_\n" } @_bad_arguments);
	Bio::KBase::Exceptions::ArgumentValidationError->throw(error => $msg,
							       method_name => 'get_entity_Source');
    }

    my $ctx = $Bio::KBase::CDMI::Service::CallContext;
    my($return);
    #BEGIN get_entity_Source

    $return = $self->_get_entity($ctx, 'Source', $ids, $fields);

    #END get_entity_Source
    my @_bad_returns;
    (ref($return) eq 'HASH') or push(@_bad_returns, "Invalid type for return variable \"return\" (value was \"$return\")");
    if (@_bad_returns) {
	my $msg = "Invalid returns passed to get_entity_Source:\n" . join("", map { "\t$_\n" } @_bad_returns);
	Bio::KBase::Exceptions::ArgumentValidationError->throw(error => $msg,
							       method_name => 'get_entity_Source');
    }
    return($return);
}




=head2 query_entity_Source

  $return = $obj->query_entity_Source($qry, $fields)

=over 4

=item Parameter and return types

=begin html

<pre>
$qry is a reference to a list where each element is a reference to a list containing 3 items:
	0: a string
	1: a string
	2: a string
$fields is a reference to a list where each element is a string
$return is a reference to a hash where the key is a string and the value is a fields_Source
fields_Source is a reference to a hash where the following keys are defined:
	id has a value which is a string

</pre>

=end html

=begin text

$qry is a reference to a list where each element is a reference to a list containing 3 items:
	0: a string
	1: a string
	2: a string
$fields is a reference to a list where each element is a string
$return is a reference to a hash where the key is a string and the value is a fields_Source
fields_Source is a reference to a hash where the following keys are defined:
	id has a value which is a string


=end text



=item Description



=back

=cut

sub query_entity_Source
{
    my $self = shift;
    my($qry, $fields) = @_;

    my @_bad_arguments;
    (ref($qry) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"qry\" (value was \"$qry\")");
    (ref($fields) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"fields\" (value was \"$fields\")");
    if (@_bad_arguments) {
	my $msg = "Invalid arguments passed to query_entity_Source:\n" . join("", map { "\t$_\n" } @_bad_arguments);
	Bio::KBase::Exceptions::ArgumentValidationError->throw(error => $msg,
							       method_name => 'query_entity_Source');
    }

    my $ctx = $Bio::KBase::CDMI::Service::CallContext;
    my($return);
    #BEGIN query_entity_Source

    $return = $self->_query_entity($ctx, 'Source', $qry, $fields);

    #END query_entity_Source
    my @_bad_returns;
    (ref($return) eq 'HASH') or push(@_bad_returns, "Invalid type for return variable \"return\" (value was \"$return\")");
    if (@_bad_returns) {
	my $msg = "Invalid returns passed to query_entity_Source:\n" . join("", map { "\t$_\n" } @_bad_returns);
	Bio::KBase::Exceptions::ArgumentValidationError->throw(error => $msg,
							       method_name => 'query_entity_Source');
    }
    return($return);
}




=head2 all_entities_Source

  $return = $obj->all_entities_Source($start, $count, $fields)

=over 4

=item Parameter and return types

=begin html

<pre>
$start is an int
$count is an int
$fields is a reference to a list where each element is a string
$return is a reference to a hash where the key is a string and the value is a fields_Source
fields_Source is a reference to a hash where the following keys are defined:
	id has a value which is a string

</pre>

=end html

=begin text

$start is an int
$count is an int
$fields is a reference to a list where each element is a string
$return is a reference to a hash where the key is a string and the value is a fields_Source
fields_Source is a reference to a hash where the following keys are defined:
	id has a value which is a string


=end text



=item Description



=back

=cut

sub all_entities_Source
{
    my $self = shift;
    my($start, $count, $fields) = @_;

    my @_bad_arguments;
    (!ref($start)) or push(@_bad_arguments, "Invalid type for argument \"start\" (value was \"$start\")");
    (!ref($count)) or push(@_bad_arguments, "Invalid type for argument \"count\" (value was \"$count\")");
    (ref($fields) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"fields\" (value was \"$fields\")");
    if (@_bad_arguments) {
	my $msg = "Invalid arguments passed to all_entities_Source:\n" . join("", map { "\t$_\n" } @_bad_arguments);
	Bio::KBase::Exceptions::ArgumentValidationError->throw(error => $msg,
							       method_name => 'all_entities_Source');
    }

    my $ctx = $Bio::KBase::CDMI::Service::CallContext;
    my($return);
    #BEGIN all_entities_Source

    $return = $self->_all_entities($ctx, 'Source', $start, $count, $fields);

    #END all_entities_Source
    my @_bad_returns;
    (ref($return) eq 'HASH') or push(@_bad_returns, "Invalid type for return variable \"return\" (value was \"$return\")");
    if (@_bad_returns) {
	my $msg = "Invalid returns passed to all_entities_Source:\n" . join("", map { "\t$_\n" } @_bad_returns);
	Bio::KBase::Exceptions::ArgumentValidationError->throw(error => $msg,
							       method_name => 'all_entities_Source');
    }
    return($return);
}




=head2 get_entity_StudyExperiment

  $return = $obj->get_entity_StudyExperiment($ids, $fields)

=over 4

=item Parameter and return types

=begin html

<pre>
$ids is a reference to a list where each element is a string
$fields is a reference to a list where each element is a string
$return is a reference to a hash where the key is a string and the value is a fields_StudyExperiment
fields_StudyExperiment is a reference to a hash where the following keys are defined:
	id has a value which is a string
	source_name has a value which is a string
	design has a value which is a string
	originator has a value which is a string

</pre>

=end html

=begin text

$ids is a reference to a list where each element is a string
$fields is a reference to a list where each element is a string
$return is a reference to a hash where the key is a string and the value is a fields_StudyExperiment
fields_StudyExperiment is a reference to a hash where the following keys are defined:
	id has a value which is a string
	source_name has a value which is a string
	design has a value which is a string
	originator has a value which is a string


=end text



=item Description

An Experiment is a collection of observational units with one originator that are part of a specific study.  An experiment may be conducted at more than one location and in more than one season or year.
It has the following fields:

=over 4


=item source_name

Name/ID by which the experiment is known at the source.  


=item design

Design of the experiment including the numbers and types of observational units, traits, replicates, sampling plan, and analysis that are planned.


=item originator

Name of the individual or program that are the originators of the experiment.



=back

=back

=cut

sub get_entity_StudyExperiment
{
    my $self = shift;
    my($ids, $fields) = @_;

    my @_bad_arguments;
    (ref($ids) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"ids\" (value was \"$ids\")");
    (ref($fields) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"fields\" (value was \"$fields\")");
    if (@_bad_arguments) {
	my $msg = "Invalid arguments passed to get_entity_StudyExperiment:\n" . join("", map { "\t$_\n" } @_bad_arguments);
	Bio::KBase::Exceptions::ArgumentValidationError->throw(error => $msg,
							       method_name => 'get_entity_StudyExperiment');
    }

    my $ctx = $Bio::KBase::CDMI::Service::CallContext;
    my($return);
    #BEGIN get_entity_StudyExperiment

    $return = $self->_get_entity($ctx, 'StudyExperiment', $ids, $fields);

    #END get_entity_StudyExperiment
    my @_bad_returns;
    (ref($return) eq 'HASH') or push(@_bad_returns, "Invalid type for return variable \"return\" (value was \"$return\")");
    if (@_bad_returns) {
	my $msg = "Invalid returns passed to get_entity_StudyExperiment:\n" . join("", map { "\t$_\n" } @_bad_returns);
	Bio::KBase::Exceptions::ArgumentValidationError->throw(error => $msg,
							       method_name => 'get_entity_StudyExperiment');
    }
    return($return);
}




=head2 query_entity_StudyExperiment

  $return = $obj->query_entity_StudyExperiment($qry, $fields)

=over 4

=item Parameter and return types

=begin html

<pre>
$qry is a reference to a list where each element is a reference to a list containing 3 items:
	0: a string
	1: a string
	2: a string
$fields is a reference to a list where each element is a string
$return is a reference to a hash where the key is a string and the value is a fields_StudyExperiment
fields_StudyExperiment is a reference to a hash where the following keys are defined:
	id has a value which is a string
	source_name has a value which is a string
	design has a value which is a string
	originator has a value which is a string

</pre>

=end html

=begin text

$qry is a reference to a list where each element is a reference to a list containing 3 items:
	0: a string
	1: a string
	2: a string
$fields is a reference to a list where each element is a string
$return is a reference to a hash where the key is a string and the value is a fields_StudyExperiment
fields_StudyExperiment is a reference to a hash where the following keys are defined:
	id has a value which is a string
	source_name has a value which is a string
	design has a value which is a string
	originator has a value which is a string


=end text



=item Description



=back

=cut

sub query_entity_StudyExperiment
{
    my $self = shift;
    my($qry, $fields) = @_;

    my @_bad_arguments;
    (ref($qry) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"qry\" (value was \"$qry\")");
    (ref($fields) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"fields\" (value was \"$fields\")");
    if (@_bad_arguments) {
	my $msg = "Invalid arguments passed to query_entity_StudyExperiment:\n" . join("", map { "\t$_\n" } @_bad_arguments);
	Bio::KBase::Exceptions::ArgumentValidationError->throw(error => $msg,
							       method_name => 'query_entity_StudyExperiment');
    }

    my $ctx = $Bio::KBase::CDMI::Service::CallContext;
    my($return);
    #BEGIN query_entity_StudyExperiment

    $return = $self->_query_entity($ctx, 'StudyExperiment', $qry, $fields);

    #END query_entity_StudyExperiment
    my @_bad_returns;
    (ref($return) eq 'HASH') or push(@_bad_returns, "Invalid type for return variable \"return\" (value was \"$return\")");
    if (@_bad_returns) {
	my $msg = "Invalid returns passed to query_entity_StudyExperiment:\n" . join("", map { "\t$_\n" } @_bad_returns);
	Bio::KBase::Exceptions::ArgumentValidationError->throw(error => $msg,
							       method_name => 'query_entity_StudyExperiment');
    }
    return($return);
}




=head2 all_entities_StudyExperiment

  $return = $obj->all_entities_StudyExperiment($start, $count, $fields)

=over 4

=item Parameter and return types

=begin html

<pre>
$start is an int
$count is an int
$fields is a reference to a list where each element is a string
$return is a reference to a hash where the key is a string and the value is a fields_StudyExperiment
fields_StudyExperiment is a reference to a hash where the following keys are defined:
	id has a value which is a string
	source_name has a value which is a string
	design has a value which is a string
	originator has a value which is a string

</pre>

=end html

=begin text

$start is an int
$count is an int
$fields is a reference to a list where each element is a string
$return is a reference to a hash where the key is a string and the value is a fields_StudyExperiment
fields_StudyExperiment is a reference to a hash where the following keys are defined:
	id has a value which is a string
	source_name has a value which is a string
	design has a value which is a string
	originator has a value which is a string


=end text



=item Description



=back

=cut

sub all_entities_StudyExperiment
{
    my $self = shift;
    my($start, $count, $fields) = @_;

    my @_bad_arguments;
    (!ref($start)) or push(@_bad_arguments, "Invalid type for argument \"start\" (value was \"$start\")");
    (!ref($count)) or push(@_bad_arguments, "Invalid type for argument \"count\" (value was \"$count\")");
    (ref($fields) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"fields\" (value was \"$fields\")");
    if (@_bad_arguments) {
	my $msg = "Invalid arguments passed to all_entities_StudyExperiment:\n" . join("", map { "\t$_\n" } @_bad_arguments);
	Bio::KBase::Exceptions::ArgumentValidationError->throw(error => $msg,
							       method_name => 'all_entities_StudyExperiment');
    }

    my $ctx = $Bio::KBase::CDMI::Service::CallContext;
    my($return);
    #BEGIN all_entities_StudyExperiment

    $return = $self->_all_entities($ctx, 'StudyExperiment', $start, $count, $fields);

    #END all_entities_StudyExperiment
    my @_bad_returns;
    (ref($return) eq 'HASH') or push(@_bad_returns, "Invalid type for return variable \"return\" (value was \"$return\")");
    if (@_bad_returns) {
	my $msg = "Invalid returns passed to all_entities_StudyExperiment:\n" . join("", map { "\t$_\n" } @_bad_returns);
	Bio::KBase::Exceptions::ArgumentValidationError->throw(error => $msg,
							       method_name => 'all_entities_StudyExperiment');
    }
    return($return);
}




=head2 get_entity_Subsystem

  $return = $obj->get_entity_Subsystem($ids, $fields)

=over 4

=item Parameter and return types

=begin html

<pre>
$ids is a reference to a list where each element is a string
$fields is a reference to a list where each element is a string
$return is a reference to a hash where the key is a string and the value is a fields_Subsystem
fields_Subsystem is a reference to a hash where the following keys are defined:
	id has a value which is a string
	version has a value which is an int
	curator has a value which is a string
	notes has a value which is a string
	description has a value which is a string
	usable has a value which is an int
	private has a value which is an int
	cluster_based has a value which is an int
	experimental has a value which is an int

</pre>

=end html

=begin text

$ids is a reference to a list where each element is a string
$fields is a reference to a list where each element is a string
$return is a reference to a hash where the key is a string and the value is a fields_Subsystem
fields_Subsystem is a reference to a hash where the following keys are defined:
	id has a value which is a string
	version has a value which is an int
	curator has a value which is a string
	notes has a value which is a string
	description has a value which is a string
	usable has a value which is an int
	private has a value which is an int
	cluster_based has a value which is an int
	experimental has a value which is an int


=end text



=item Description

A subsystem is a set of functional roles that have been annotated simultaneously (e.g.,
the roles present in a specific pathway), with an associated subsystem spreadsheet
which encodes the fids in each genome that implement the functional roles in the
subsystem.

It has the following fields:

=over 4


=item version

version number for the subsystem. This value is
incremented each time the subsystem is backed up.


=item curator

name of the person currently in charge of the
subsystem


=item notes

descriptive notes about the subsystem


=item description

description of the subsystem's function in the
cell


=item usable

TRUE if this is a usable subsystem, else FALSE. An
unusable subsystem is one that is experimental or is of
such low quality that it can negatively affect analysis.


=item private

TRUE if this is a private subsystem, else FALSE. A
private subsystem has valid data, but is not considered ready
for general distribution.


=item cluster_based

TRUE if this is a clustering-based subsystem, else
FALSE. A clustering-based subsystem is one in which there is
functional-coupling evidence that genes belong together, but
we do not yet know what they do.


=item experimental

TRUE if this is an experimental subsystem, else FALSE.
An experimental subsystem is designed for investigation and
is not yet ready to be used in comparative analysis and
annotation.



=back

=back

=cut

sub get_entity_Subsystem
{
    my $self = shift;
    my($ids, $fields) = @_;

    my @_bad_arguments;
    (ref($ids) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"ids\" (value was \"$ids\")");
    (ref($fields) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"fields\" (value was \"$fields\")");
    if (@_bad_arguments) {
	my $msg = "Invalid arguments passed to get_entity_Subsystem:\n" . join("", map { "\t$_\n" } @_bad_arguments);
	Bio::KBase::Exceptions::ArgumentValidationError->throw(error => $msg,
							       method_name => 'get_entity_Subsystem');
    }

    my $ctx = $Bio::KBase::CDMI::Service::CallContext;
    my($return);
    #BEGIN get_entity_Subsystem

    $return = $self->_get_entity($ctx, 'Subsystem', $ids, $fields);

    #END get_entity_Subsystem
    my @_bad_returns;
    (ref($return) eq 'HASH') or push(@_bad_returns, "Invalid type for return variable \"return\" (value was \"$return\")");
    if (@_bad_returns) {
	my $msg = "Invalid returns passed to get_entity_Subsystem:\n" . join("", map { "\t$_\n" } @_bad_returns);
	Bio::KBase::Exceptions::ArgumentValidationError->throw(error => $msg,
							       method_name => 'get_entity_Subsystem');
    }
    return($return);
}




=head2 query_entity_Subsystem

  $return = $obj->query_entity_Subsystem($qry, $fields)

=over 4

=item Parameter and return types

=begin html

<pre>
$qry is a reference to a list where each element is a reference to a list containing 3 items:
	0: a string
	1: a string
	2: a string
$fields is a reference to a list where each element is a string
$return is a reference to a hash where the key is a string and the value is a fields_Subsystem
fields_Subsystem is a reference to a hash where the following keys are defined:
	id has a value which is a string
	version has a value which is an int
	curator has a value which is a string
	notes has a value which is a string
	description has a value which is a string
	usable has a value which is an int
	private has a value which is an int
	cluster_based has a value which is an int
	experimental has a value which is an int

</pre>

=end html

=begin text

$qry is a reference to a list where each element is a reference to a list containing 3 items:
	0: a string
	1: a string
	2: a string
$fields is a reference to a list where each element is a string
$return is a reference to a hash where the key is a string and the value is a fields_Subsystem
fields_Subsystem is a reference to a hash where the following keys are defined:
	id has a value which is a string
	version has a value which is an int
	curator has a value which is a string
	notes has a value which is a string
	description has a value which is a string
	usable has a value which is an int
	private has a value which is an int
	cluster_based has a value which is an int
	experimental has a value which is an int


=end text



=item Description



=back

=cut

sub query_entity_Subsystem
{
    my $self = shift;
    my($qry, $fields) = @_;

    my @_bad_arguments;
    (ref($qry) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"qry\" (value was \"$qry\")");
    (ref($fields) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"fields\" (value was \"$fields\")");
    if (@_bad_arguments) {
	my $msg = "Invalid arguments passed to query_entity_Subsystem:\n" . join("", map { "\t$_\n" } @_bad_arguments);
	Bio::KBase::Exceptions::ArgumentValidationError->throw(error => $msg,
							       method_name => 'query_entity_Subsystem');
    }

    my $ctx = $Bio::KBase::CDMI::Service::CallContext;
    my($return);
    #BEGIN query_entity_Subsystem

    $return = $self->_query_entity($ctx, 'Subsystem', $qry, $fields);

    #END query_entity_Subsystem
    my @_bad_returns;
    (ref($return) eq 'HASH') or push(@_bad_returns, "Invalid type for return variable \"return\" (value was \"$return\")");
    if (@_bad_returns) {
	my $msg = "Invalid returns passed to query_entity_Subsystem:\n" . join("", map { "\t$_\n" } @_bad_returns);
	Bio::KBase::Exceptions::ArgumentValidationError->throw(error => $msg,
							       method_name => 'query_entity_Subsystem');
    }
    return($return);
}




=head2 all_entities_Subsystem

  $return = $obj->all_entities_Subsystem($start, $count, $fields)

=over 4

=item Parameter and return types

=begin html

<pre>
$start is an int
$count is an int
$fields is a reference to a list where each element is a string
$return is a reference to a hash where the key is a string and the value is a fields_Subsystem
fields_Subsystem is a reference to a hash where the following keys are defined:
	id has a value which is a string
	version has a value which is an int
	curator has a value which is a string
	notes has a value which is a string
	description has a value which is a string
	usable has a value which is an int
	private has a value which is an int
	cluster_based has a value which is an int
	experimental has a value which is an int

</pre>

=end html

=begin text

$start is an int
$count is an int
$fields is a reference to a list where each element is a string
$return is a reference to a hash where the key is a string and the value is a fields_Subsystem
fields_Subsystem is a reference to a hash where the following keys are defined:
	id has a value which is a string
	version has a value which is an int
	curator has a value which is a string
	notes has a value which is a string
	description has a value which is a string
	usable has a value which is an int
	private has a value which is an int
	cluster_based has a value which is an int
	experimental has a value which is an int


=end text



=item Description



=back

=cut

sub all_entities_Subsystem
{
    my $self = shift;
    my($start, $count, $fields) = @_;

    my @_bad_arguments;
    (!ref($start)) or push(@_bad_arguments, "Invalid type for argument \"start\" (value was \"$start\")");
    (!ref($count)) or push(@_bad_arguments, "Invalid type for argument \"count\" (value was \"$count\")");
    (ref($fields) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"fields\" (value was \"$fields\")");
    if (@_bad_arguments) {
	my $msg = "Invalid arguments passed to all_entities_Subsystem:\n" . join("", map { "\t$_\n" } @_bad_arguments);
	Bio::KBase::Exceptions::ArgumentValidationError->throw(error => $msg,
							       method_name => 'all_entities_Subsystem');
    }

    my $ctx = $Bio::KBase::CDMI::Service::CallContext;
    my($return);
    #BEGIN all_entities_Subsystem

    $return = $self->_all_entities($ctx, 'Subsystem', $start, $count, $fields);

    #END all_entities_Subsystem
    my @_bad_returns;
    (ref($return) eq 'HASH') or push(@_bad_returns, "Invalid type for return variable \"return\" (value was \"$return\")");
    if (@_bad_returns) {
	my $msg = "Invalid returns passed to all_entities_Subsystem:\n" . join("", map { "\t$_\n" } @_bad_returns);
	Bio::KBase::Exceptions::ArgumentValidationError->throw(error => $msg,
							       method_name => 'all_entities_Subsystem');
    }
    return($return);
}




=head2 get_entity_SubsystemClass

  $return = $obj->get_entity_SubsystemClass($ids, $fields)

=over 4

=item Parameter and return types

=begin html

<pre>
$ids is a reference to a list where each element is a string
$fields is a reference to a list where each element is a string
$return is a reference to a hash where the key is a string and the value is a fields_SubsystemClass
fields_SubsystemClass is a reference to a hash where the following keys are defined:
	id has a value which is a string

</pre>

=end html

=begin text

$ids is a reference to a list where each element is a string
$fields is a reference to a list where each element is a string
$return is a reference to a hash where the key is a string and the value is a fields_SubsystemClass
fields_SubsystemClass is a reference to a hash where the following keys are defined:
	id has a value which is a string


=end text



=item Description

Subsystem classes impose a hierarchical organization on the
subsystems.
It has the following fields:

=over 4



=back

=back

=cut

sub get_entity_SubsystemClass
{
    my $self = shift;
    my($ids, $fields) = @_;

    my @_bad_arguments;
    (ref($ids) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"ids\" (value was \"$ids\")");
    (ref($fields) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"fields\" (value was \"$fields\")");
    if (@_bad_arguments) {
	my $msg = "Invalid arguments passed to get_entity_SubsystemClass:\n" . join("", map { "\t$_\n" } @_bad_arguments);
	Bio::KBase::Exceptions::ArgumentValidationError->throw(error => $msg,
							       method_name => 'get_entity_SubsystemClass');
    }

    my $ctx = $Bio::KBase::CDMI::Service::CallContext;
    my($return);
    #BEGIN get_entity_SubsystemClass

    $return = $self->_get_entity($ctx, 'SubsystemClass', $ids, $fields);

    #END get_entity_SubsystemClass
    my @_bad_returns;
    (ref($return) eq 'HASH') or push(@_bad_returns, "Invalid type for return variable \"return\" (value was \"$return\")");
    if (@_bad_returns) {
	my $msg = "Invalid returns passed to get_entity_SubsystemClass:\n" . join("", map { "\t$_\n" } @_bad_returns);
	Bio::KBase::Exceptions::ArgumentValidationError->throw(error => $msg,
							       method_name => 'get_entity_SubsystemClass');
    }
    return($return);
}




=head2 query_entity_SubsystemClass

  $return = $obj->query_entity_SubsystemClass($qry, $fields)

=over 4

=item Parameter and return types

=begin html

<pre>
$qry is a reference to a list where each element is a reference to a list containing 3 items:
	0: a string
	1: a string
	2: a string
$fields is a reference to a list where each element is a string
$return is a reference to a hash where the key is a string and the value is a fields_SubsystemClass
fields_SubsystemClass is a reference to a hash where the following keys are defined:
	id has a value which is a string

</pre>

=end html

=begin text

$qry is a reference to a list where each element is a reference to a list containing 3 items:
	0: a string
	1: a string
	2: a string
$fields is a reference to a list where each element is a string
$return is a reference to a hash where the key is a string and the value is a fields_SubsystemClass
fields_SubsystemClass is a reference to a hash where the following keys are defined:
	id has a value which is a string


=end text



=item Description



=back

=cut

sub query_entity_SubsystemClass
{
    my $self = shift;
    my($qry, $fields) = @_;

    my @_bad_arguments;
    (ref($qry) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"qry\" (value was \"$qry\")");
    (ref($fields) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"fields\" (value was \"$fields\")");
    if (@_bad_arguments) {
	my $msg = "Invalid arguments passed to query_entity_SubsystemClass:\n" . join("", map { "\t$_\n" } @_bad_arguments);
	Bio::KBase::Exceptions::ArgumentValidationError->throw(error => $msg,
							       method_name => 'query_entity_SubsystemClass');
    }

    my $ctx = $Bio::KBase::CDMI::Service::CallContext;
    my($return);
    #BEGIN query_entity_SubsystemClass

    $return = $self->_query_entity($ctx, 'SubsystemClass', $qry, $fields);

    #END query_entity_SubsystemClass
    my @_bad_returns;
    (ref($return) eq 'HASH') or push(@_bad_returns, "Invalid type for return variable \"return\" (value was \"$return\")");
    if (@_bad_returns) {
	my $msg = "Invalid returns passed to query_entity_SubsystemClass:\n" . join("", map { "\t$_\n" } @_bad_returns);
	Bio::KBase::Exceptions::ArgumentValidationError->throw(error => $msg,
							       method_name => 'query_entity_SubsystemClass');
    }
    return($return);
}




=head2 all_entities_SubsystemClass

  $return = $obj->all_entities_SubsystemClass($start, $count, $fields)

=over 4

=item Parameter and return types

=begin html

<pre>
$start is an int
$count is an int
$fields is a reference to a list where each element is a string
$return is a reference to a hash where the key is a string and the value is a fields_SubsystemClass
fields_SubsystemClass is a reference to a hash where the following keys are defined:
	id has a value which is a string

</pre>

=end html

=begin text

$start is an int
$count is an int
$fields is a reference to a list where each element is a string
$return is a reference to a hash where the key is a string and the value is a fields_SubsystemClass
fields_SubsystemClass is a reference to a hash where the following keys are defined:
	id has a value which is a string


=end text



=item Description



=back

=cut

sub all_entities_SubsystemClass
{
    my $self = shift;
    my($start, $count, $fields) = @_;

    my @_bad_arguments;
    (!ref($start)) or push(@_bad_arguments, "Invalid type for argument \"start\" (value was \"$start\")");
    (!ref($count)) or push(@_bad_arguments, "Invalid type for argument \"count\" (value was \"$count\")");
    (ref($fields) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"fields\" (value was \"$fields\")");
    if (@_bad_arguments) {
	my $msg = "Invalid arguments passed to all_entities_SubsystemClass:\n" . join("", map { "\t$_\n" } @_bad_arguments);
	Bio::KBase::Exceptions::ArgumentValidationError->throw(error => $msg,
							       method_name => 'all_entities_SubsystemClass');
    }

    my $ctx = $Bio::KBase::CDMI::Service::CallContext;
    my($return);
    #BEGIN all_entities_SubsystemClass

    $return = $self->_all_entities($ctx, 'SubsystemClass', $start, $count, $fields);

    #END all_entities_SubsystemClass
    my @_bad_returns;
    (ref($return) eq 'HASH') or push(@_bad_returns, "Invalid type for return variable \"return\" (value was \"$return\")");
    if (@_bad_returns) {
	my $msg = "Invalid returns passed to all_entities_SubsystemClass:\n" . join("", map { "\t$_\n" } @_bad_returns);
	Bio::KBase::Exceptions::ArgumentValidationError->throw(error => $msg,
							       method_name => 'all_entities_SubsystemClass');
    }
    return($return);
}




=head2 get_entity_TaxonomicGrouping

  $return = $obj->get_entity_TaxonomicGrouping($ids, $fields)

=over 4

=item Parameter and return types

=begin html

<pre>
$ids is a reference to a list where each element is a string
$fields is a reference to a list where each element is a string
$return is a reference to a hash where the key is a string and the value is a fields_TaxonomicGrouping
fields_TaxonomicGrouping is a reference to a hash where the following keys are defined:
	id has a value which is a string
	domain has a value which is an int
	hidden has a value which is an int
	scientific_name has a value which is a string
	alias has a value which is a reference to a list where each element is a string

</pre>

=end html

=begin text

$ids is a reference to a list where each element is a string
$fields is a reference to a list where each element is a string
$return is a reference to a hash where the key is a string and the value is a fields_TaxonomicGrouping
fields_TaxonomicGrouping is a reference to a hash where the following keys are defined:
	id has a value which is a string
	domain has a value which is an int
	hidden has a value which is an int
	scientific_name has a value which is a string
	alias has a value which is a reference to a list where each element is a string


=end text



=item Description

We associate with most genomes a "taxonomy" based on the NCBI taxonomy.
This includes, for each genome, a list of ever larger taxonomic groups.

It has the following fields:

=over 4


=item domain

TRUE if this is a domain grouping, else FALSE.


=item hidden

TRUE if this is a hidden grouping, else FALSE. Hidden groupings
are not typically shown in a lineage list.


=item scientific_name

Primary scientific name for this grouping. This is the name used
when displaying a taxonomy.


=item alias

Alternate name for this grouping. A grouping
may have many alternate names. The scientific name should also
be in this list.



=back

=back

=cut

sub get_entity_TaxonomicGrouping
{
    my $self = shift;
    my($ids, $fields) = @_;

    my @_bad_arguments;
    (ref($ids) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"ids\" (value was \"$ids\")");
    (ref($fields) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"fields\" (value was \"$fields\")");
    if (@_bad_arguments) {
	my $msg = "Invalid arguments passed to get_entity_TaxonomicGrouping:\n" . join("", map { "\t$_\n" } @_bad_arguments);
	Bio::KBase::Exceptions::ArgumentValidationError->throw(error => $msg,
							       method_name => 'get_entity_TaxonomicGrouping');
    }

    my $ctx = $Bio::KBase::CDMI::Service::CallContext;
    my($return);
    #BEGIN get_entity_TaxonomicGrouping

    $return = $self->_get_entity($ctx, 'TaxonomicGrouping', $ids, $fields);

    #END get_entity_TaxonomicGrouping
    my @_bad_returns;
    (ref($return) eq 'HASH') or push(@_bad_returns, "Invalid type for return variable \"return\" (value was \"$return\")");
    if (@_bad_returns) {
	my $msg = "Invalid returns passed to get_entity_TaxonomicGrouping:\n" . join("", map { "\t$_\n" } @_bad_returns);
	Bio::KBase::Exceptions::ArgumentValidationError->throw(error => $msg,
							       method_name => 'get_entity_TaxonomicGrouping');
    }
    return($return);
}




=head2 query_entity_TaxonomicGrouping

  $return = $obj->query_entity_TaxonomicGrouping($qry, $fields)

=over 4

=item Parameter and return types

=begin html

<pre>
$qry is a reference to a list where each element is a reference to a list containing 3 items:
	0: a string
	1: a string
	2: a string
$fields is a reference to a list where each element is a string
$return is a reference to a hash where the key is a string and the value is a fields_TaxonomicGrouping
fields_TaxonomicGrouping is a reference to a hash where the following keys are defined:
	id has a value which is a string
	domain has a value which is an int
	hidden has a value which is an int
	scientific_name has a value which is a string
	alias has a value which is a reference to a list where each element is a string

</pre>

=end html

=begin text

$qry is a reference to a list where each element is a reference to a list containing 3 items:
	0: a string
	1: a string
	2: a string
$fields is a reference to a list where each element is a string
$return is a reference to a hash where the key is a string and the value is a fields_TaxonomicGrouping
fields_TaxonomicGrouping is a reference to a hash where the following keys are defined:
	id has a value which is a string
	domain has a value which is an int
	hidden has a value which is an int
	scientific_name has a value which is a string
	alias has a value which is a reference to a list where each element is a string


=end text



=item Description



=back

=cut

sub query_entity_TaxonomicGrouping
{
    my $self = shift;
    my($qry, $fields) = @_;

    my @_bad_arguments;
    (ref($qry) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"qry\" (value was \"$qry\")");
    (ref($fields) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"fields\" (value was \"$fields\")");
    if (@_bad_arguments) {
	my $msg = "Invalid arguments passed to query_entity_TaxonomicGrouping:\n" . join("", map { "\t$_\n" } @_bad_arguments);
	Bio::KBase::Exceptions::ArgumentValidationError->throw(error => $msg,
							       method_name => 'query_entity_TaxonomicGrouping');
    }

    my $ctx = $Bio::KBase::CDMI::Service::CallContext;
    my($return);
    #BEGIN query_entity_TaxonomicGrouping

    $return = $self->_query_entity($ctx, 'TaxonomicGrouping', $qry, $fields);

    #END query_entity_TaxonomicGrouping
    my @_bad_returns;
    (ref($return) eq 'HASH') or push(@_bad_returns, "Invalid type for return variable \"return\" (value was \"$return\")");
    if (@_bad_returns) {
	my $msg = "Invalid returns passed to query_entity_TaxonomicGrouping:\n" . join("", map { "\t$_\n" } @_bad_returns);
	Bio::KBase::Exceptions::ArgumentValidationError->throw(error => $msg,
							       method_name => 'query_entity_TaxonomicGrouping');
    }
    return($return);
}




=head2 all_entities_TaxonomicGrouping

  $return = $obj->all_entities_TaxonomicGrouping($start, $count, $fields)

=over 4

=item Parameter and return types

=begin html

<pre>
$start is an int
$count is an int
$fields is a reference to a list where each element is a string
$return is a reference to a hash where the key is a string and the value is a fields_TaxonomicGrouping
fields_TaxonomicGrouping is a reference to a hash where the following keys are defined:
	id has a value which is a string
	domain has a value which is an int
	hidden has a value which is an int
	scientific_name has a value which is a string
	alias has a value which is a reference to a list where each element is a string

</pre>

=end html

=begin text

$start is an int
$count is an int
$fields is a reference to a list where each element is a string
$return is a reference to a hash where the key is a string and the value is a fields_TaxonomicGrouping
fields_TaxonomicGrouping is a reference to a hash where the following keys are defined:
	id has a value which is a string
	domain has a value which is an int
	hidden has a value which is an int
	scientific_name has a value which is a string
	alias has a value which is a reference to a list where each element is a string


=end text



=item Description



=back

=cut

sub all_entities_TaxonomicGrouping
{
    my $self = shift;
    my($start, $count, $fields) = @_;

    my @_bad_arguments;
    (!ref($start)) or push(@_bad_arguments, "Invalid type for argument \"start\" (value was \"$start\")");
    (!ref($count)) or push(@_bad_arguments, "Invalid type for argument \"count\" (value was \"$count\")");
    (ref($fields) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"fields\" (value was \"$fields\")");
    if (@_bad_arguments) {
	my $msg = "Invalid arguments passed to all_entities_TaxonomicGrouping:\n" . join("", map { "\t$_\n" } @_bad_arguments);
	Bio::KBase::Exceptions::ArgumentValidationError->throw(error => $msg,
							       method_name => 'all_entities_TaxonomicGrouping');
    }

    my $ctx = $Bio::KBase::CDMI::Service::CallContext;
    my($return);
    #BEGIN all_entities_TaxonomicGrouping

    $return = $self->_all_entities($ctx, 'TaxonomicGrouping', $start, $count, $fields);

    #END all_entities_TaxonomicGrouping
    my @_bad_returns;
    (ref($return) eq 'HASH') or push(@_bad_returns, "Invalid type for return variable \"return\" (value was \"$return\")");
    if (@_bad_returns) {
	my $msg = "Invalid returns passed to all_entities_TaxonomicGrouping:\n" . join("", map { "\t$_\n" } @_bad_returns);
	Bio::KBase::Exceptions::ArgumentValidationError->throw(error => $msg,
							       method_name => 'all_entities_TaxonomicGrouping');
    }
    return($return);
}




=head2 get_entity_Trait

  $return = $obj->get_entity_Trait($ids, $fields)

=over 4

=item Parameter and return types

=begin html

<pre>
$ids is a reference to a list where each element is a string
$fields is a reference to a list where each element is a string
$return is a reference to a hash where the key is a string and the value is a fields_Trait
fields_Trait is a reference to a hash where the following keys are defined:
	id has a value which is a string
	trait_name has a value which is a string
	unit_of_measure has a value which is a string
	TO_ID has a value which is a string
	protocol has a value which is a string

</pre>

=end html

=begin text

$ids is a reference to a list where each element is a string
$fields is a reference to a list where each element is a string
$return is a reference to a hash where the key is a string and the value is a fields_Trait
fields_Trait is a reference to a hash where the following keys are defined:
	id has a value which is a string
	trait_name has a value which is a string
	unit_of_measure has a value which is a string
	TO_ID has a value which is a string
	protocol has a value which is a string


=end text



=item Description

A Trait is a phenotypic quality that can be measured or observed for an observational unit.  Examples include height, sugar content, color, or cold tolerance.
It has the following fields:

=over 4


=item trait_name

Text name or description of the trait


=item unit_of_measure

The units of measure used when determining this trait.  If multiple units of measure are applicable, each has its own row in the database.  


=item TO_ID

Trait Ontology term ID (http://www.gramene.org/plant-ontology/)


=item protocol

A thorough description of how the trait was collected, and if a rating, the minimum and maximum values



=back

=back

=cut

sub get_entity_Trait
{
    my $self = shift;
    my($ids, $fields) = @_;

    my @_bad_arguments;
    (ref($ids) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"ids\" (value was \"$ids\")");
    (ref($fields) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"fields\" (value was \"$fields\")");
    if (@_bad_arguments) {
	my $msg = "Invalid arguments passed to get_entity_Trait:\n" . join("", map { "\t$_\n" } @_bad_arguments);
	Bio::KBase::Exceptions::ArgumentValidationError->throw(error => $msg,
							       method_name => 'get_entity_Trait');
    }

    my $ctx = $Bio::KBase::CDMI::Service::CallContext;
    my($return);
    #BEGIN get_entity_Trait

    $return = $self->_get_entity($ctx, 'Trait', $ids, $fields);

    #END get_entity_Trait
    my @_bad_returns;
    (ref($return) eq 'HASH') or push(@_bad_returns, "Invalid type for return variable \"return\" (value was \"$return\")");
    if (@_bad_returns) {
	my $msg = "Invalid returns passed to get_entity_Trait:\n" . join("", map { "\t$_\n" } @_bad_returns);
	Bio::KBase::Exceptions::ArgumentValidationError->throw(error => $msg,
							       method_name => 'get_entity_Trait');
    }
    return($return);
}




=head2 query_entity_Trait

  $return = $obj->query_entity_Trait($qry, $fields)

=over 4

=item Parameter and return types

=begin html

<pre>
$qry is a reference to a list where each element is a reference to a list containing 3 items:
	0: a string
	1: a string
	2: a string
$fields is a reference to a list where each element is a string
$return is a reference to a hash where the key is a string and the value is a fields_Trait
fields_Trait is a reference to a hash where the following keys are defined:
	id has a value which is a string
	trait_name has a value which is a string
	unit_of_measure has a value which is a string
	TO_ID has a value which is a string
	protocol has a value which is a string

</pre>

=end html

=begin text

$qry is a reference to a list where each element is a reference to a list containing 3 items:
	0: a string
	1: a string
	2: a string
$fields is a reference to a list where each element is a string
$return is a reference to a hash where the key is a string and the value is a fields_Trait
fields_Trait is a reference to a hash where the following keys are defined:
	id has a value which is a string
	trait_name has a value which is a string
	unit_of_measure has a value which is a string
	TO_ID has a value which is a string
	protocol has a value which is a string


=end text



=item Description



=back

=cut

sub query_entity_Trait
{
    my $self = shift;
    my($qry, $fields) = @_;

    my @_bad_arguments;
    (ref($qry) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"qry\" (value was \"$qry\")");
    (ref($fields) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"fields\" (value was \"$fields\")");
    if (@_bad_arguments) {
	my $msg = "Invalid arguments passed to query_entity_Trait:\n" . join("", map { "\t$_\n" } @_bad_arguments);
	Bio::KBase::Exceptions::ArgumentValidationError->throw(error => $msg,
							       method_name => 'query_entity_Trait');
    }

    my $ctx = $Bio::KBase::CDMI::Service::CallContext;
    my($return);
    #BEGIN query_entity_Trait

    $return = $self->_query_entity($ctx, 'Trait', $qry, $fields);

    #END query_entity_Trait
    my @_bad_returns;
    (ref($return) eq 'HASH') or push(@_bad_returns, "Invalid type for return variable \"return\" (value was \"$return\")");
    if (@_bad_returns) {
	my $msg = "Invalid returns passed to query_entity_Trait:\n" . join("", map { "\t$_\n" } @_bad_returns);
	Bio::KBase::Exceptions::ArgumentValidationError->throw(error => $msg,
							       method_name => 'query_entity_Trait');
    }
    return($return);
}




=head2 all_entities_Trait

  $return = $obj->all_entities_Trait($start, $count, $fields)

=over 4

=item Parameter and return types

=begin html

<pre>
$start is an int
$count is an int
$fields is a reference to a list where each element is a string
$return is a reference to a hash where the key is a string and the value is a fields_Trait
fields_Trait is a reference to a hash where the following keys are defined:
	id has a value which is a string
	trait_name has a value which is a string
	unit_of_measure has a value which is a string
	TO_ID has a value which is a string
	protocol has a value which is a string

</pre>

=end html

=begin text

$start is an int
$count is an int
$fields is a reference to a list where each element is a string
$return is a reference to a hash where the key is a string and the value is a fields_Trait
fields_Trait is a reference to a hash where the following keys are defined:
	id has a value which is a string
	trait_name has a value which is a string
	unit_of_measure has a value which is a string
	TO_ID has a value which is a string
	protocol has a value which is a string


=end text



=item Description



=back

=cut

sub all_entities_Trait
{
    my $self = shift;
    my($start, $count, $fields) = @_;

    my @_bad_arguments;
    (!ref($start)) or push(@_bad_arguments, "Invalid type for argument \"start\" (value was \"$start\")");
    (!ref($count)) or push(@_bad_arguments, "Invalid type for argument \"count\" (value was \"$count\")");
    (ref($fields) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"fields\" (value was \"$fields\")");
    if (@_bad_arguments) {
	my $msg = "Invalid arguments passed to all_entities_Trait:\n" . join("", map { "\t$_\n" } @_bad_arguments);
	Bio::KBase::Exceptions::ArgumentValidationError->throw(error => $msg,
							       method_name => 'all_entities_Trait');
    }

    my $ctx = $Bio::KBase::CDMI::Service::CallContext;
    my($return);
    #BEGIN all_entities_Trait

    $return = $self->_all_entities($ctx, 'Trait', $start, $count, $fields);

    #END all_entities_Trait
    my @_bad_returns;
    (ref($return) eq 'HASH') or push(@_bad_returns, "Invalid type for return variable \"return\" (value was \"$return\")");
    if (@_bad_returns) {
	my $msg = "Invalid returns passed to all_entities_Trait:\n" . join("", map { "\t$_\n" } @_bad_returns);
	Bio::KBase::Exceptions::ArgumentValidationError->throw(error => $msg,
							       method_name => 'all_entities_Trait');
    }
    return($return);
}




=head2 get_entity_Variant

  $return = $obj->get_entity_Variant($ids, $fields)

=over 4

=item Parameter and return types

=begin html

<pre>
$ids is a reference to a list where each element is a string
$fields is a reference to a list where each element is a string
$return is a reference to a hash where the key is a string and the value is a fields_Variant
fields_Variant is a reference to a hash where the following keys are defined:
	id has a value which is a string
	role_rule has a value which is a reference to a list where each element is a string
	code has a value which is a string
	type has a value which is a string
	comment has a value which is a string

</pre>

=end html

=begin text

$ids is a reference to a list where each element is a string
$fields is a reference to a list where each element is a string
$return is a reference to a hash where the key is a string and the value is a fields_Variant
fields_Variant is a reference to a hash where the following keys are defined:
	id has a value which is a string
	role_rule has a value which is a reference to a list where each element is a string
	code has a value which is a string
	type has a value which is a string
	comment has a value which is a string


=end text



=item Description

Each subsystem may include the designation of distinct variants.  Thus,
there may be three closely-related, but distinguishable forms of histidine
degradation.  Each form would be called a "variant", with an associated code,
and all genomes implementing a specific variant can easily be accessed.

It has the following fields:

=over 4


=item role_rule

a space-delimited list of role IDs, in alphabetical order,
that represents a possible list of non-auxiliary roles applicable to
this variant. The roles are identified by their abbreviations. A
variant may have multiple role rules.


=item code

the variant code all by itself


=item type

variant type indicating the quality of the subsystem
support. A type of "vacant" means that the subsystem
does not appear to be implemented by the variant. A
type of "incomplete" means that the subsystem appears to be
missing many reactions. In all other cases, the type is
"normal".


=item comment

commentary text about the variant



=back

=back

=cut

sub get_entity_Variant
{
    my $self = shift;
    my($ids, $fields) = @_;

    my @_bad_arguments;
    (ref($ids) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"ids\" (value was \"$ids\")");
    (ref($fields) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"fields\" (value was \"$fields\")");
    if (@_bad_arguments) {
	my $msg = "Invalid arguments passed to get_entity_Variant:\n" . join("", map { "\t$_\n" } @_bad_arguments);
	Bio::KBase::Exceptions::ArgumentValidationError->throw(error => $msg,
							       method_name => 'get_entity_Variant');
    }

    my $ctx = $Bio::KBase::CDMI::Service::CallContext;
    my($return);
    #BEGIN get_entity_Variant

    $return = $self->_get_entity($ctx, 'Variant', $ids, $fields);

    #END get_entity_Variant
    my @_bad_returns;
    (ref($return) eq 'HASH') or push(@_bad_returns, "Invalid type for return variable \"return\" (value was \"$return\")");
    if (@_bad_returns) {
	my $msg = "Invalid returns passed to get_entity_Variant:\n" . join("", map { "\t$_\n" } @_bad_returns);
	Bio::KBase::Exceptions::ArgumentValidationError->throw(error => $msg,
							       method_name => 'get_entity_Variant');
    }
    return($return);
}




=head2 query_entity_Variant

  $return = $obj->query_entity_Variant($qry, $fields)

=over 4

=item Parameter and return types

=begin html

<pre>
$qry is a reference to a list where each element is a reference to a list containing 3 items:
	0: a string
	1: a string
	2: a string
$fields is a reference to a list where each element is a string
$return is a reference to a hash where the key is a string and the value is a fields_Variant
fields_Variant is a reference to a hash where the following keys are defined:
	id has a value which is a string
	role_rule has a value which is a reference to a list where each element is a string
	code has a value which is a string
	type has a value which is a string
	comment has a value which is a string

</pre>

=end html

=begin text

$qry is a reference to a list where each element is a reference to a list containing 3 items:
	0: a string
	1: a string
	2: a string
$fields is a reference to a list where each element is a string
$return is a reference to a hash where the key is a string and the value is a fields_Variant
fields_Variant is a reference to a hash where the following keys are defined:
	id has a value which is a string
	role_rule has a value which is a reference to a list where each element is a string
	code has a value which is a string
	type has a value which is a string
	comment has a value which is a string


=end text



=item Description



=back

=cut

sub query_entity_Variant
{
    my $self = shift;
    my($qry, $fields) = @_;

    my @_bad_arguments;
    (ref($qry) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"qry\" (value was \"$qry\")");
    (ref($fields) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"fields\" (value was \"$fields\")");
    if (@_bad_arguments) {
	my $msg = "Invalid arguments passed to query_entity_Variant:\n" . join("", map { "\t$_\n" } @_bad_arguments);
	Bio::KBase::Exceptions::ArgumentValidationError->throw(error => $msg,
							       method_name => 'query_entity_Variant');
    }

    my $ctx = $Bio::KBase::CDMI::Service::CallContext;
    my($return);
    #BEGIN query_entity_Variant

    $return = $self->_query_entity($ctx, 'Variant', $qry, $fields);

    #END query_entity_Variant
    my @_bad_returns;
    (ref($return) eq 'HASH') or push(@_bad_returns, "Invalid type for return variable \"return\" (value was \"$return\")");
    if (@_bad_returns) {
	my $msg = "Invalid returns passed to query_entity_Variant:\n" . join("", map { "\t$_\n" } @_bad_returns);
	Bio::KBase::Exceptions::ArgumentValidationError->throw(error => $msg,
							       method_name => 'query_entity_Variant');
    }
    return($return);
}




=head2 all_entities_Variant

  $return = $obj->all_entities_Variant($start, $count, $fields)

=over 4

=item Parameter and return types

=begin html

<pre>
$start is an int
$count is an int
$fields is a reference to a list where each element is a string
$return is a reference to a hash where the key is a string and the value is a fields_Variant
fields_Variant is a reference to a hash where the following keys are defined:
	id has a value which is a string
	role_rule has a value which is a reference to a list where each element is a string
	code has a value which is a string
	type has a value which is a string
	comment has a value which is a string

</pre>

=end html

=begin text

$start is an int
$count is an int
$fields is a reference to a list where each element is a string
$return is a reference to a hash where the key is a string and the value is a fields_Variant
fields_Variant is a reference to a hash where the following keys are defined:
	id has a value which is a string
	role_rule has a value which is a reference to a list where each element is a string
	code has a value which is a string
	type has a value which is a string
	comment has a value which is a string


=end text



=item Description



=back

=cut

sub all_entities_Variant
{
    my $self = shift;
    my($start, $count, $fields) = @_;

    my @_bad_arguments;
    (!ref($start)) or push(@_bad_arguments, "Invalid type for argument \"start\" (value was \"$start\")");
    (!ref($count)) or push(@_bad_arguments, "Invalid type for argument \"count\" (value was \"$count\")");
    (ref($fields) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"fields\" (value was \"$fields\")");
    if (@_bad_arguments) {
	my $msg = "Invalid arguments passed to all_entities_Variant:\n" . join("", map { "\t$_\n" } @_bad_arguments);
	Bio::KBase::Exceptions::ArgumentValidationError->throw(error => $msg,
							       method_name => 'all_entities_Variant');
    }

    my $ctx = $Bio::KBase::CDMI::Service::CallContext;
    my($return);
    #BEGIN all_entities_Variant

    $return = $self->_all_entities($ctx, 'Variant', $start, $count, $fields);

    #END all_entities_Variant
    my @_bad_returns;
    (ref($return) eq 'HASH') or push(@_bad_returns, "Invalid type for return variable \"return\" (value was \"$return\")");
    if (@_bad_returns) {
	my $msg = "Invalid returns passed to all_entities_Variant:\n" . join("", map { "\t$_\n" } @_bad_returns);
	Bio::KBase::Exceptions::ArgumentValidationError->throw(error => $msg,
							       method_name => 'all_entities_Variant');
    }
    return($return);
}




=head2 get_relationship_AffectsLevelOf

  $return = $obj->get_relationship_AffectsLevelOf($ids, $from_fields, $rel_fields, $to_fields)

=over 4

=item Parameter and return types

=begin html

<pre>
$ids is a reference to a list where each element is a string
$from_fields is a reference to a list where each element is a string
$rel_fields is a reference to a list where each element is a string
$to_fields is a reference to a list where each element is a string
$return is a reference to a list where each element is a reference to a list containing 3 items:
	0: a fields_Experiment
	1: a fields_AffectsLevelOf
	2: a fields_AtomicRegulon
fields_Experiment is a reference to a hash where the following keys are defined:
	id has a value which is a string
	source has a value which is a string
fields_AffectsLevelOf is a reference to a hash where the following keys are defined:
	id has a value which is a string
	level has a value which is an int
fields_AtomicRegulon is a reference to a hash where the following keys are defined:
	id has a value which is a string

</pre>

=end html

=begin text

$ids is a reference to a list where each element is a string
$from_fields is a reference to a list where each element is a string
$rel_fields is a reference to a list where each element is a string
$to_fields is a reference to a list where each element is a string
$return is a reference to a list where each element is a reference to a list containing 3 items:
	0: a fields_Experiment
	1: a fields_AffectsLevelOf
	2: a fields_AtomicRegulon
fields_Experiment is a reference to a hash where the following keys are defined:
	id has a value which is a string
	source has a value which is a string
fields_AffectsLevelOf is a reference to a hash where the following keys are defined:
	id has a value which is a string
	level has a value which is an int
fields_AtomicRegulon is a reference to a hash where the following keys are defined:
	id has a value which is a string


=end text



=item Description

This relationship indicates the expression level of an atomic regulon
for a given experiment.
It has the following fields:

=over 4


=item level

Indication of whether the feature is expressed (1), not expressed (-1),
or unknown (0).



=back

=back

=cut

sub get_relationship_AffectsLevelOf
{
    my $self = shift;
    my($ids, $from_fields, $rel_fields, $to_fields) = @_;

    my @_bad_arguments;
    (ref($ids) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"ids\" (value was \"$ids\")");
    (ref($from_fields) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"from_fields\" (value was \"$from_fields\")");
    (ref($rel_fields) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"rel_fields\" (value was \"$rel_fields\")");
    (ref($to_fields) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"to_fields\" (value was \"$to_fields\")");
    if (@_bad_arguments) {
	my $msg = "Invalid arguments passed to get_relationship_AffectsLevelOf:\n" . join("", map { "\t$_\n" } @_bad_arguments);
	Bio::KBase::Exceptions::ArgumentValidationError->throw(error => $msg,
							       method_name => 'get_relationship_AffectsLevelOf');
    }

    my $ctx = $Bio::KBase::CDMI::Service::CallContext;
    my($return);
    #BEGIN get_relationship_AffectsLevelOf

    $return = $self->_get_relationship($ctx, 'AffectsLevelOf', 'AffectsLevelOf', 0, $ids, $from_fields, $rel_fields, $to_fields);
	
    #END get_relationship_AffectsLevelOf
    my @_bad_returns;
    (ref($return) eq 'ARRAY') or push(@_bad_returns, "Invalid type for return variable \"return\" (value was \"$return\")");
    if (@_bad_returns) {
	my $msg = "Invalid returns passed to get_relationship_AffectsLevelOf:\n" . join("", map { "\t$_\n" } @_bad_returns);
	Bio::KBase::Exceptions::ArgumentValidationError->throw(error => $msg,
							       method_name => 'get_relationship_AffectsLevelOf');
    }
    return($return);
}




=head2 get_relationship_IsAffectedIn

  $return = $obj->get_relationship_IsAffectedIn($ids, $from_fields, $rel_fields, $to_fields)

=over 4

=item Parameter and return types

=begin html

<pre>
$ids is a reference to a list where each element is a string
$from_fields is a reference to a list where each element is a string
$rel_fields is a reference to a list where each element is a string
$to_fields is a reference to a list where each element is a string
$return is a reference to a list where each element is a reference to a list containing 3 items:
	0: a fields_AtomicRegulon
	1: a fields_AffectsLevelOf
	2: a fields_Experiment
fields_AtomicRegulon is a reference to a hash where the following keys are defined:
	id has a value which is a string
fields_AffectsLevelOf is a reference to a hash where the following keys are defined:
	id has a value which is a string
	level has a value which is an int
fields_Experiment is a reference to a hash where the following keys are defined:
	id has a value which is a string
	source has a value which is a string

</pre>

=end html

=begin text

$ids is a reference to a list where each element is a string
$from_fields is a reference to a list where each element is a string
$rel_fields is a reference to a list where each element is a string
$to_fields is a reference to a list where each element is a string
$return is a reference to a list where each element is a reference to a list containing 3 items:
	0: a fields_AtomicRegulon
	1: a fields_AffectsLevelOf
	2: a fields_Experiment
fields_AtomicRegulon is a reference to a hash where the following keys are defined:
	id has a value which is a string
fields_AffectsLevelOf is a reference to a hash where the following keys are defined:
	id has a value which is a string
	level has a value which is an int
fields_Experiment is a reference to a hash where the following keys are defined:
	id has a value which is a string
	source has a value which is a string


=end text



=item Description



=back

=cut

sub get_relationship_IsAffectedIn
{
    my $self = shift;
    my($ids, $from_fields, $rel_fields, $to_fields) = @_;

    my @_bad_arguments;
    (ref($ids) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"ids\" (value was \"$ids\")");
    (ref($from_fields) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"from_fields\" (value was \"$from_fields\")");
    (ref($rel_fields) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"rel_fields\" (value was \"$rel_fields\")");
    (ref($to_fields) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"to_fields\" (value was \"$to_fields\")");
    if (@_bad_arguments) {
	my $msg = "Invalid arguments passed to get_relationship_IsAffectedIn:\n" . join("", map { "\t$_\n" } @_bad_arguments);
	Bio::KBase::Exceptions::ArgumentValidationError->throw(error => $msg,
							       method_name => 'get_relationship_IsAffectedIn');
    }

    my $ctx = $Bio::KBase::CDMI::Service::CallContext;
    my($return);
    #BEGIN get_relationship_IsAffectedIn

    $return = $self->_get_relationship($ctx, 'IsAffectedIn', 'AffectsLevelOf', 1, $ids, $from_fields, $rel_fields, $to_fields);
	
    #END get_relationship_IsAffectedIn
    my @_bad_returns;
    (ref($return) eq 'ARRAY') or push(@_bad_returns, "Invalid type for return variable \"return\" (value was \"$return\")");
    if (@_bad_returns) {
	my $msg = "Invalid returns passed to get_relationship_IsAffectedIn:\n" . join("", map { "\t$_\n" } @_bad_returns);
	Bio::KBase::Exceptions::ArgumentValidationError->throw(error => $msg,
							       method_name => 'get_relationship_IsAffectedIn');
    }
    return($return);
}




=head2 get_relationship_Aligns

  $return = $obj->get_relationship_Aligns($ids, $from_fields, $rel_fields, $to_fields)

=over 4

=item Parameter and return types

=begin html

<pre>
$ids is a reference to a list where each element is a string
$from_fields is a reference to a list where each element is a string
$rel_fields is a reference to a list where each element is a string
$to_fields is a reference to a list where each element is a string
$return is a reference to a list where each element is a reference to a list containing 3 items:
	0: a fields_AlignmentTree
	1: a fields_Aligns
	2: a fields_ProteinSequence
fields_AlignmentTree is a reference to a hash where the following keys are defined:
	id has a value which is a string
	alignment_method has a value which is a string
	alignment_parameters has a value which is a string
	alignment_properties has a value which is a string
	tree_method has a value which is a string
	tree_parameters has a value which is a string
	tree_properties has a value which is a string
fields_Aligns is a reference to a hash where the following keys are defined:
	id has a value which is a string
	begin has a value which is an int
	end has a value which is an int
	len has a value which is an int
	sequence_id has a value which is a string
	properties has a value which is a string
fields_ProteinSequence is a reference to a hash where the following keys are defined:
	id has a value which is a string
	sequence has a value which is a string

</pre>

=end html

=begin text

$ids is a reference to a list where each element is a string
$from_fields is a reference to a list where each element is a string
$rel_fields is a reference to a list where each element is a string
$to_fields is a reference to a list where each element is a string
$return is a reference to a list where each element is a reference to a list containing 3 items:
	0: a fields_AlignmentTree
	1: a fields_Aligns
	2: a fields_ProteinSequence
fields_AlignmentTree is a reference to a hash where the following keys are defined:
	id has a value which is a string
	alignment_method has a value which is a string
	alignment_parameters has a value which is a string
	alignment_properties has a value which is a string
	tree_method has a value which is a string
	tree_parameters has a value which is a string
	tree_properties has a value which is a string
fields_Aligns is a reference to a hash where the following keys are defined:
	id has a value which is a string
	begin has a value which is an int
	end has a value which is an int
	len has a value which is an int
	sequence_id has a value which is a string
	properties has a value which is a string
fields_ProteinSequence is a reference to a hash where the following keys are defined:
	id has a value which is a string
	sequence has a value which is a string


=end text



=item Description

This relationship connects each alignment to its constituent protein
sequences. Each alignment contains many protein sequences, and a single
sequence can be in many alignments. Parts of a single protein can occur
in multiple places in an alignment. The sequence-id field is used to
keep these unique, and is the string that represents the sequence in the
alignment and tree text.
It has the following fields:

=over 4


=item begin

location within the sequence at which the aligned portion begins


=item end

location within the sequence at which the aligned portion ends


=item len

length of the sequence within the alignment


=item sequence_id

identifier for this sequence in the alignment


=item properties

additional information about this sequence's participation in the
alignment



=back

=back

=cut

sub get_relationship_Aligns
{
    my $self = shift;
    my($ids, $from_fields, $rel_fields, $to_fields) = @_;

    my @_bad_arguments;
    (ref($ids) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"ids\" (value was \"$ids\")");
    (ref($from_fields) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"from_fields\" (value was \"$from_fields\")");
    (ref($rel_fields) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"rel_fields\" (value was \"$rel_fields\")");
    (ref($to_fields) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"to_fields\" (value was \"$to_fields\")");
    if (@_bad_arguments) {
	my $msg = "Invalid arguments passed to get_relationship_Aligns:\n" . join("", map { "\t$_\n" } @_bad_arguments);
	Bio::KBase::Exceptions::ArgumentValidationError->throw(error => $msg,
							       method_name => 'get_relationship_Aligns');
    }

    my $ctx = $Bio::KBase::CDMI::Service::CallContext;
    my($return);
    #BEGIN get_relationship_Aligns

    $return = $self->_get_relationship($ctx, 'Aligns', 'Aligns', 0, $ids, $from_fields, $rel_fields, $to_fields);
	
    #END get_relationship_Aligns
    my @_bad_returns;
    (ref($return) eq 'ARRAY') or push(@_bad_returns, "Invalid type for return variable \"return\" (value was \"$return\")");
    if (@_bad_returns) {
	my $msg = "Invalid returns passed to get_relationship_Aligns:\n" . join("", map { "\t$_\n" } @_bad_returns);
	Bio::KBase::Exceptions::ArgumentValidationError->throw(error => $msg,
							       method_name => 'get_relationship_Aligns');
    }
    return($return);
}




=head2 get_relationship_IsAlignedBy

  $return = $obj->get_relationship_IsAlignedBy($ids, $from_fields, $rel_fields, $to_fields)

=over 4

=item Parameter and return types

=begin html

<pre>
$ids is a reference to a list where each element is a string
$from_fields is a reference to a list where each element is a string
$rel_fields is a reference to a list where each element is a string
$to_fields is a reference to a list where each element is a string
$return is a reference to a list where each element is a reference to a list containing 3 items:
	0: a fields_ProteinSequence
	1: a fields_Aligns
	2: a fields_AlignmentTree
fields_ProteinSequence is a reference to a hash where the following keys are defined:
	id has a value which is a string
	sequence has a value which is a string
fields_Aligns is a reference to a hash where the following keys are defined:
	id has a value which is a string
	begin has a value which is an int
	end has a value which is an int
	len has a value which is an int
	sequence_id has a value which is a string
	properties has a value which is a string
fields_AlignmentTree is a reference to a hash where the following keys are defined:
	id has a value which is a string
	alignment_method has a value which is a string
	alignment_parameters has a value which is a string
	alignment_properties has a value which is a string
	tree_method has a value which is a string
	tree_parameters has a value which is a string
	tree_properties has a value which is a string

</pre>

=end html

=begin text

$ids is a reference to a list where each element is a string
$from_fields is a reference to a list where each element is a string
$rel_fields is a reference to a list where each element is a string
$to_fields is a reference to a list where each element is a string
$return is a reference to a list where each element is a reference to a list containing 3 items:
	0: a fields_ProteinSequence
	1: a fields_Aligns
	2: a fields_AlignmentTree
fields_ProteinSequence is a reference to a hash where the following keys are defined:
	id has a value which is a string
	sequence has a value which is a string
fields_Aligns is a reference to a hash where the following keys are defined:
	id has a value which is a string
	begin has a value which is an int
	end has a value which is an int
	len has a value which is an int
	sequence_id has a value which is a string
	properties has a value which is a string
fields_AlignmentTree is a reference to a hash where the following keys are defined:
	id has a value which is a string
	alignment_method has a value which is a string
	alignment_parameters has a value which is a string
	alignment_properties has a value which is a string
	tree_method has a value which is a string
	tree_parameters has a value which is a string
	tree_properties has a value which is a string


=end text



=item Description



=back

=cut

sub get_relationship_IsAlignedBy
{
    my $self = shift;
    my($ids, $from_fields, $rel_fields, $to_fields) = @_;

    my @_bad_arguments;
    (ref($ids) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"ids\" (value was \"$ids\")");
    (ref($from_fields) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"from_fields\" (value was \"$from_fields\")");
    (ref($rel_fields) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"rel_fields\" (value was \"$rel_fields\")");
    (ref($to_fields) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"to_fields\" (value was \"$to_fields\")");
    if (@_bad_arguments) {
	my $msg = "Invalid arguments passed to get_relationship_IsAlignedBy:\n" . join("", map { "\t$_\n" } @_bad_arguments);
	Bio::KBase::Exceptions::ArgumentValidationError->throw(error => $msg,
							       method_name => 'get_relationship_IsAlignedBy');
    }

    my $ctx = $Bio::KBase::CDMI::Service::CallContext;
    my($return);
    #BEGIN get_relationship_IsAlignedBy

    $return = $self->_get_relationship($ctx, 'IsAlignedBy', 'Aligns', 1, $ids, $from_fields, $rel_fields, $to_fields);
	
    #END get_relationship_IsAlignedBy
    my @_bad_returns;
    (ref($return) eq 'ARRAY') or push(@_bad_returns, "Invalid type for return variable \"return\" (value was \"$return\")");
    if (@_bad_returns) {
	my $msg = "Invalid returns passed to get_relationship_IsAlignedBy:\n" . join("", map { "\t$_\n" } @_bad_returns);
	Bio::KBase::Exceptions::ArgumentValidationError->throw(error => $msg,
							       method_name => 'get_relationship_IsAlignedBy');
    }
    return($return);
}




=head2 get_relationship_AssertsFunctionFor

  $return = $obj->get_relationship_AssertsFunctionFor($ids, $from_fields, $rel_fields, $to_fields)

=over 4

=item Parameter and return types

=begin html

<pre>
$ids is a reference to a list where each element is a string
$from_fields is a reference to a list where each element is a string
$rel_fields is a reference to a list where each element is a string
$to_fields is a reference to a list where each element is a string
$return is a reference to a list where each element is a reference to a list containing 3 items:
	0: a fields_Source
	1: a fields_AssertsFunctionFor
	2: a fields_ProteinSequence
fields_Source is a reference to a hash where the following keys are defined:
	id has a value which is a string
fields_AssertsFunctionFor is a reference to a hash where the following keys are defined:
	id has a value which is a string
	function has a value which is a string
	external_id has a value which is a string
	organism has a value which is a string
	gi_number has a value which is an int
	release_date has a value which is a string
fields_ProteinSequence is a reference to a hash where the following keys are defined:
	id has a value which is a string
	sequence has a value which is a string

</pre>

=end html

=begin text

$ids is a reference to a list where each element is a string
$from_fields is a reference to a list where each element is a string
$rel_fields is a reference to a list where each element is a string
$to_fields is a reference to a list where each element is a string
$return is a reference to a list where each element is a reference to a list containing 3 items:
	0: a fields_Source
	1: a fields_AssertsFunctionFor
	2: a fields_ProteinSequence
fields_Source is a reference to a hash where the following keys are defined:
	id has a value which is a string
fields_AssertsFunctionFor is a reference to a hash where the following keys are defined:
	id has a value which is a string
	function has a value which is a string
	external_id has a value which is a string
	organism has a value which is a string
	gi_number has a value which is an int
	release_date has a value which is a string
fields_ProteinSequence is a reference to a hash where the following keys are defined:
	id has a value which is a string
	sequence has a value which is a string


=end text



=item Description

Sources (users) can make assertions about protein sequence function.
The assertion is associated with an external identifier.
It has the following fields:

=over 4


=item function

text of the assertion made about the identifier.
It may be an empty string, indicating the function is unknown.


=item external_id

external identifier used in making the assertion


=item organism

organism name associated with this assertion. If the
assertion is not associated with a specific organism, this
will be an empty string.


=item gi_number

NCBI GI number associated with the asserted identifier


=item release_date

date and time the assertion was downloaded



=back

=back

=cut

sub get_relationship_AssertsFunctionFor
{
    my $self = shift;
    my($ids, $from_fields, $rel_fields, $to_fields) = @_;

    my @_bad_arguments;
    (ref($ids) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"ids\" (value was \"$ids\")");
    (ref($from_fields) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"from_fields\" (value was \"$from_fields\")");
    (ref($rel_fields) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"rel_fields\" (value was \"$rel_fields\")");
    (ref($to_fields) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"to_fields\" (value was \"$to_fields\")");
    if (@_bad_arguments) {
	my $msg = "Invalid arguments passed to get_relationship_AssertsFunctionFor:\n" . join("", map { "\t$_\n" } @_bad_arguments);
	Bio::KBase::Exceptions::ArgumentValidationError->throw(error => $msg,
							       method_name => 'get_relationship_AssertsFunctionFor');
    }

    my $ctx = $Bio::KBase::CDMI::Service::CallContext;
    my($return);
    #BEGIN get_relationship_AssertsFunctionFor

    $return = $self->_get_relationship($ctx, 'AssertsFunctionFor', 'AssertsFunctionFor', 0, $ids, $from_fields, $rel_fields, $to_fields);
	
    #END get_relationship_AssertsFunctionFor
    my @_bad_returns;
    (ref($return) eq 'ARRAY') or push(@_bad_returns, "Invalid type for return variable \"return\" (value was \"$return\")");
    if (@_bad_returns) {
	my $msg = "Invalid returns passed to get_relationship_AssertsFunctionFor:\n" . join("", map { "\t$_\n" } @_bad_returns);
	Bio::KBase::Exceptions::ArgumentValidationError->throw(error => $msg,
							       method_name => 'get_relationship_AssertsFunctionFor');
    }
    return($return);
}




=head2 get_relationship_HasAssertedFunctionFrom

  $return = $obj->get_relationship_HasAssertedFunctionFrom($ids, $from_fields, $rel_fields, $to_fields)

=over 4

=item Parameter and return types

=begin html

<pre>
$ids is a reference to a list where each element is a string
$from_fields is a reference to a list where each element is a string
$rel_fields is a reference to a list where each element is a string
$to_fields is a reference to a list where each element is a string
$return is a reference to a list where each element is a reference to a list containing 3 items:
	0: a fields_ProteinSequence
	1: a fields_AssertsFunctionFor
	2: a fields_Source
fields_ProteinSequence is a reference to a hash where the following keys are defined:
	id has a value which is a string
	sequence has a value which is a string
fields_AssertsFunctionFor is a reference to a hash where the following keys are defined:
	id has a value which is a string
	function has a value which is a string
	external_id has a value which is a string
	organism has a value which is a string
	gi_number has a value which is an int
	release_date has a value which is a string
fields_Source is a reference to a hash where the following keys are defined:
	id has a value which is a string

</pre>

=end html

=begin text

$ids is a reference to a list where each element is a string
$from_fields is a reference to a list where each element is a string
$rel_fields is a reference to a list where each element is a string
$to_fields is a reference to a list where each element is a string
$return is a reference to a list where each element is a reference to a list containing 3 items:
	0: a fields_ProteinSequence
	1: a fields_AssertsFunctionFor
	2: a fields_Source
fields_ProteinSequence is a reference to a hash where the following keys are defined:
	id has a value which is a string
	sequence has a value which is a string
fields_AssertsFunctionFor is a reference to a hash where the following keys are defined:
	id has a value which is a string
	function has a value which is a string
	external_id has a value which is a string
	organism has a value which is a string
	gi_number has a value which is an int
	release_date has a value which is a string
fields_Source is a reference to a hash where the following keys are defined:
	id has a value which is a string


=end text



=item Description



=back

=cut

sub get_relationship_HasAssertedFunctionFrom
{
    my $self = shift;
    my($ids, $from_fields, $rel_fields, $to_fields) = @_;

    my @_bad_arguments;
    (ref($ids) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"ids\" (value was \"$ids\")");
    (ref($from_fields) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"from_fields\" (value was \"$from_fields\")");
    (ref($rel_fields) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"rel_fields\" (value was \"$rel_fields\")");
    (ref($to_fields) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"to_fields\" (value was \"$to_fields\")");
    if (@_bad_arguments) {
	my $msg = "Invalid arguments passed to get_relationship_HasAssertedFunctionFrom:\n" . join("", map { "\t$_\n" } @_bad_arguments);
	Bio::KBase::Exceptions::ArgumentValidationError->throw(error => $msg,
							       method_name => 'get_relationship_HasAssertedFunctionFrom');
    }

    my $ctx = $Bio::KBase::CDMI::Service::CallContext;
    my($return);
    #BEGIN get_relationship_HasAssertedFunctionFrom

    $return = $self->_get_relationship($ctx, 'HasAssertedFunctionFrom', 'AssertsFunctionFor', 1, $ids, $from_fields, $rel_fields, $to_fields);
	
    #END get_relationship_HasAssertedFunctionFrom
    my @_bad_returns;
    (ref($return) eq 'ARRAY') or push(@_bad_returns, "Invalid type for return variable \"return\" (value was \"$return\")");
    if (@_bad_returns) {
	my $msg = "Invalid returns passed to get_relationship_HasAssertedFunctionFrom:\n" . join("", map { "\t$_\n" } @_bad_returns);
	Bio::KBase::Exceptions::ArgumentValidationError->throw(error => $msg,
							       method_name => 'get_relationship_HasAssertedFunctionFrom');
    }
    return($return);
}




=head2 get_relationship_Concerns

  $return = $obj->get_relationship_Concerns($ids, $from_fields, $rel_fields, $to_fields)

=over 4

=item Parameter and return types

=begin html

<pre>
$ids is a reference to a list where each element is a string
$from_fields is a reference to a list where each element is a string
$rel_fields is a reference to a list where each element is a string
$to_fields is a reference to a list where each element is a string
$return is a reference to a list where each element is a reference to a list containing 3 items:
	0: a fields_Publication
	1: a fields_Concerns
	2: a fields_ProteinSequence
fields_Publication is a reference to a hash where the following keys are defined:
	id has a value which is a string
	title has a value which is a string
	link has a value which is a string
	pubdate has a value which is a string
fields_Concerns is a reference to a hash where the following keys are defined:
	id has a value which is a string
fields_ProteinSequence is a reference to a hash where the following keys are defined:
	id has a value which is a string
	sequence has a value which is a string

</pre>

=end html

=begin text

$ids is a reference to a list where each element is a string
$from_fields is a reference to a list where each element is a string
$rel_fields is a reference to a list where each element is a string
$to_fields is a reference to a list where each element is a string
$return is a reference to a list where each element is a reference to a list containing 3 items:
	0: a fields_Publication
	1: a fields_Concerns
	2: a fields_ProteinSequence
fields_Publication is a reference to a hash where the following keys are defined:
	id has a value which is a string
	title has a value which is a string
	link has a value which is a string
	pubdate has a value which is a string
fields_Concerns is a reference to a hash where the following keys are defined:
	id has a value which is a string
fields_ProteinSequence is a reference to a hash where the following keys are defined:
	id has a value which is a string
	sequence has a value which is a string


=end text



=item Description

This relationship connects a publication to the protein
sequences it describes.
It has the following fields:

=over 4



=back

=back

=cut

sub get_relationship_Concerns
{
    my $self = shift;
    my($ids, $from_fields, $rel_fields, $to_fields) = @_;

    my @_bad_arguments;
    (ref($ids) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"ids\" (value was \"$ids\")");
    (ref($from_fields) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"from_fields\" (value was \"$from_fields\")");
    (ref($rel_fields) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"rel_fields\" (value was \"$rel_fields\")");
    (ref($to_fields) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"to_fields\" (value was \"$to_fields\")");
    if (@_bad_arguments) {
	my $msg = "Invalid arguments passed to get_relationship_Concerns:\n" . join("", map { "\t$_\n" } @_bad_arguments);
	Bio::KBase::Exceptions::ArgumentValidationError->throw(error => $msg,
							       method_name => 'get_relationship_Concerns');
    }

    my $ctx = $Bio::KBase::CDMI::Service::CallContext;
    my($return);
    #BEGIN get_relationship_Concerns

    $return = $self->_get_relationship($ctx, 'Concerns', 'Concerns', 0, $ids, $from_fields, $rel_fields, $to_fields);
	
    #END get_relationship_Concerns
    my @_bad_returns;
    (ref($return) eq 'ARRAY') or push(@_bad_returns, "Invalid type for return variable \"return\" (value was \"$return\")");
    if (@_bad_returns) {
	my $msg = "Invalid returns passed to get_relationship_Concerns:\n" . join("", map { "\t$_\n" } @_bad_returns);
	Bio::KBase::Exceptions::ArgumentValidationError->throw(error => $msg,
							       method_name => 'get_relationship_Concerns');
    }
    return($return);
}




=head2 get_relationship_IsATopicOf

  $return = $obj->get_relationship_IsATopicOf($ids, $from_fields, $rel_fields, $to_fields)

=over 4

=item Parameter and return types

=begin html

<pre>
$ids is a reference to a list where each element is a string
$from_fields is a reference to a list where each element is a string
$rel_fields is a reference to a list where each element is a string
$to_fields is a reference to a list where each element is a string
$return is a reference to a list where each element is a reference to a list containing 3 items:
	0: a fields_ProteinSequence
	1: a fields_Concerns
	2: a fields_Publication
fields_ProteinSequence is a reference to a hash where the following keys are defined:
	id has a value which is a string
	sequence has a value which is a string
fields_Concerns is a reference to a hash where the following keys are defined:
	id has a value which is a string
fields_Publication is a reference to a hash where the following keys are defined:
	id has a value which is a string
	title has a value which is a string
	link has a value which is a string
	pubdate has a value which is a string

</pre>

=end html

=begin text

$ids is a reference to a list where each element is a string
$from_fields is a reference to a list where each element is a string
$rel_fields is a reference to a list where each element is a string
$to_fields is a reference to a list where each element is a string
$return is a reference to a list where each element is a reference to a list containing 3 items:
	0: a fields_ProteinSequence
	1: a fields_Concerns
	2: a fields_Publication
fields_ProteinSequence is a reference to a hash where the following keys are defined:
	id has a value which is a string
	sequence has a value which is a string
fields_Concerns is a reference to a hash where the following keys are defined:
	id has a value which is a string
fields_Publication is a reference to a hash where the following keys are defined:
	id has a value which is a string
	title has a value which is a string
	link has a value which is a string
	pubdate has a value which is a string


=end text



=item Description



=back

=cut

sub get_relationship_IsATopicOf
{
    my $self = shift;
    my($ids, $from_fields, $rel_fields, $to_fields) = @_;

    my @_bad_arguments;
    (ref($ids) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"ids\" (value was \"$ids\")");
    (ref($from_fields) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"from_fields\" (value was \"$from_fields\")");
    (ref($rel_fields) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"rel_fields\" (value was \"$rel_fields\")");
    (ref($to_fields) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"to_fields\" (value was \"$to_fields\")");
    if (@_bad_arguments) {
	my $msg = "Invalid arguments passed to get_relationship_IsATopicOf:\n" . join("", map { "\t$_\n" } @_bad_arguments);
	Bio::KBase::Exceptions::ArgumentValidationError->throw(error => $msg,
							       method_name => 'get_relationship_IsATopicOf');
    }

    my $ctx = $Bio::KBase::CDMI::Service::CallContext;
    my($return);
    #BEGIN get_relationship_IsATopicOf

    $return = $self->_get_relationship($ctx, 'IsATopicOf', 'Concerns', 1, $ids, $from_fields, $rel_fields, $to_fields);
	
    #END get_relationship_IsATopicOf
    my @_bad_returns;
    (ref($return) eq 'ARRAY') or push(@_bad_returns, "Invalid type for return variable \"return\" (value was \"$return\")");
    if (@_bad_returns) {
	my $msg = "Invalid returns passed to get_relationship_IsATopicOf:\n" . join("", map { "\t$_\n" } @_bad_returns);
	Bio::KBase::Exceptions::ArgumentValidationError->throw(error => $msg,
							       method_name => 'get_relationship_IsATopicOf');
    }
    return($return);
}




=head2 get_relationship_Contains

  $return = $obj->get_relationship_Contains($ids, $from_fields, $rel_fields, $to_fields)

=over 4

=item Parameter and return types

=begin html

<pre>
$ids is a reference to a list where each element is a string
$from_fields is a reference to a list where each element is a string
$rel_fields is a reference to a list where each element is a string
$to_fields is a reference to a list where each element is a string
$return is a reference to a list where each element is a reference to a list containing 3 items:
	0: a fields_SSCell
	1: a fields_Contains
	2: a fields_Feature
fields_SSCell is a reference to a hash where the following keys are defined:
	id has a value which is a string
fields_Contains is a reference to a hash where the following keys are defined:
	id has a value which is a string
fields_Feature is a reference to a hash where the following keys are defined:
	id has a value which is a string
	feature_type has a value which is a string
	source_id has a value which is a string
	sequence_length has a value which is an int
	function has a value which is a string
	alias has a value which is a reference to a list where each element is a string

</pre>

=end html

=begin text

$ids is a reference to a list where each element is a string
$from_fields is a reference to a list where each element is a string
$rel_fields is a reference to a list where each element is a string
$to_fields is a reference to a list where each element is a string
$return is a reference to a list where each element is a reference to a list containing 3 items:
	0: a fields_SSCell
	1: a fields_Contains
	2: a fields_Feature
fields_SSCell is a reference to a hash where the following keys are defined:
	id has a value which is a string
fields_Contains is a reference to a hash where the following keys are defined:
	id has a value which is a string
fields_Feature is a reference to a hash where the following keys are defined:
	id has a value which is a string
	feature_type has a value which is a string
	source_id has a value which is a string
	sequence_length has a value which is an int
	function has a value which is a string
	alias has a value which is a reference to a list where each element is a string


=end text



=item Description

This relationship connects a subsystem spreadsheet cell to the features
that occur in it. A feature may occur in many machine roles and a
machine role may contain many features. The subsystem annotation
process is essentially the maintenance of this relationship.
It has the following fields:

=over 4



=back

=back

=cut

sub get_relationship_Contains
{
    my $self = shift;
    my($ids, $from_fields, $rel_fields, $to_fields) = @_;

    my @_bad_arguments;
    (ref($ids) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"ids\" (value was \"$ids\")");
    (ref($from_fields) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"from_fields\" (value was \"$from_fields\")");
    (ref($rel_fields) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"rel_fields\" (value was \"$rel_fields\")");
    (ref($to_fields) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"to_fields\" (value was \"$to_fields\")");
    if (@_bad_arguments) {
	my $msg = "Invalid arguments passed to get_relationship_Contains:\n" . join("", map { "\t$_\n" } @_bad_arguments);
	Bio::KBase::Exceptions::ArgumentValidationError->throw(error => $msg,
							       method_name => 'get_relationship_Contains');
    }

    my $ctx = $Bio::KBase::CDMI::Service::CallContext;
    my($return);
    #BEGIN get_relationship_Contains

    $return = $self->_get_relationship($ctx, 'Contains', 'Contains', 0, $ids, $from_fields, $rel_fields, $to_fields);
	
    #END get_relationship_Contains
    my @_bad_returns;
    (ref($return) eq 'ARRAY') or push(@_bad_returns, "Invalid type for return variable \"return\" (value was \"$return\")");
    if (@_bad_returns) {
	my $msg = "Invalid returns passed to get_relationship_Contains:\n" . join("", map { "\t$_\n" } @_bad_returns);
	Bio::KBase::Exceptions::ArgumentValidationError->throw(error => $msg,
							       method_name => 'get_relationship_Contains');
    }
    return($return);
}




=head2 get_relationship_IsContainedIn

  $return = $obj->get_relationship_IsContainedIn($ids, $from_fields, $rel_fields, $to_fields)

=over 4

=item Parameter and return types

=begin html

<pre>
$ids is a reference to a list where each element is a string
$from_fields is a reference to a list where each element is a string
$rel_fields is a reference to a list where each element is a string
$to_fields is a reference to a list where each element is a string
$return is a reference to a list where each element is a reference to a list containing 3 items:
	0: a fields_Feature
	1: a fields_Contains
	2: a fields_SSCell
fields_Feature is a reference to a hash where the following keys are defined:
	id has a value which is a string
	feature_type has a value which is a string
	source_id has a value which is a string
	sequence_length has a value which is an int
	function has a value which is a string
	alias has a value which is a reference to a list where each element is a string
fields_Contains is a reference to a hash where the following keys are defined:
	id has a value which is a string
fields_SSCell is a reference to a hash where the following keys are defined:
	id has a value which is a string

</pre>

=end html

=begin text

$ids is a reference to a list where each element is a string
$from_fields is a reference to a list where each element is a string
$rel_fields is a reference to a list where each element is a string
$to_fields is a reference to a list where each element is a string
$return is a reference to a list where each element is a reference to a list containing 3 items:
	0: a fields_Feature
	1: a fields_Contains
	2: a fields_SSCell
fields_Feature is a reference to a hash where the following keys are defined:
	id has a value which is a string
	feature_type has a value which is a string
	source_id has a value which is a string
	sequence_length has a value which is an int
	function has a value which is a string
	alias has a value which is a reference to a list where each element is a string
fields_Contains is a reference to a hash where the following keys are defined:
	id has a value which is a string
fields_SSCell is a reference to a hash where the following keys are defined:
	id has a value which is a string


=end text



=item Description



=back

=cut

sub get_relationship_IsContainedIn
{
    my $self = shift;
    my($ids, $from_fields, $rel_fields, $to_fields) = @_;

    my @_bad_arguments;
    (ref($ids) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"ids\" (value was \"$ids\")");
    (ref($from_fields) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"from_fields\" (value was \"$from_fields\")");
    (ref($rel_fields) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"rel_fields\" (value was \"$rel_fields\")");
    (ref($to_fields) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"to_fields\" (value was \"$to_fields\")");
    if (@_bad_arguments) {
	my $msg = "Invalid arguments passed to get_relationship_IsContainedIn:\n" . join("", map { "\t$_\n" } @_bad_arguments);
	Bio::KBase::Exceptions::ArgumentValidationError->throw(error => $msg,
							       method_name => 'get_relationship_IsContainedIn');
    }

    my $ctx = $Bio::KBase::CDMI::Service::CallContext;
    my($return);
    #BEGIN get_relationship_IsContainedIn

    $return = $self->_get_relationship($ctx, 'IsContainedIn', 'Contains', 1, $ids, $from_fields, $rel_fields, $to_fields);
	
    #END get_relationship_IsContainedIn
    my @_bad_returns;
    (ref($return) eq 'ARRAY') or push(@_bad_returns, "Invalid type for return variable \"return\" (value was \"$return\")");
    if (@_bad_returns) {
	my $msg = "Invalid returns passed to get_relationship_IsContainedIn:\n" . join("", map { "\t$_\n" } @_bad_returns);
	Bio::KBase::Exceptions::ArgumentValidationError->throw(error => $msg,
							       method_name => 'get_relationship_IsContainedIn');
    }
    return($return);
}




=head2 get_relationship_Controls

  $return = $obj->get_relationship_Controls($ids, $from_fields, $rel_fields, $to_fields)

=over 4

=item Parameter and return types

=begin html

<pre>
$ids is a reference to a list where each element is a string
$from_fields is a reference to a list where each element is a string
$rel_fields is a reference to a list where each element is a string
$to_fields is a reference to a list where each element is a string
$return is a reference to a list where each element is a reference to a list containing 3 items:
	0: a fields_Feature
	1: a fields_Controls
	2: a fields_CoregulatedSet
fields_Feature is a reference to a hash where the following keys are defined:
	id has a value which is a string
	feature_type has a value which is a string
	source_id has a value which is a string
	sequence_length has a value which is an int
	function has a value which is a string
	alias has a value which is a reference to a list where each element is a string
fields_Controls is a reference to a hash where the following keys are defined:
	id has a value which is a string
fields_CoregulatedSet is a reference to a hash where the following keys are defined:
	id has a value which is a string
	source_id has a value which is a string
	binding_location has a value which is a reference to a list where each element is an int

</pre>

=end html

=begin text

$ids is a reference to a list where each element is a string
$from_fields is a reference to a list where each element is a string
$rel_fields is a reference to a list where each element is a string
$to_fields is a reference to a list where each element is a string
$return is a reference to a list where each element is a reference to a list containing 3 items:
	0: a fields_Feature
	1: a fields_Controls
	2: a fields_CoregulatedSet
fields_Feature is a reference to a hash where the following keys are defined:
	id has a value which is a string
	feature_type has a value which is a string
	source_id has a value which is a string
	sequence_length has a value which is an int
	function has a value which is a string
	alias has a value which is a reference to a list where each element is a string
fields_Controls is a reference to a hash where the following keys are defined:
	id has a value which is a string
fields_CoregulatedSet is a reference to a hash where the following keys are defined:
	id has a value which is a string
	source_id has a value which is a string
	binding_location has a value which is a reference to a list where each element is an int


=end text



=item Description

This relationship connects a coregulated set to the
features that are used as its transcription factors.
It has the following fields:

=over 4



=back

=back

=cut

sub get_relationship_Controls
{
    my $self = shift;
    my($ids, $from_fields, $rel_fields, $to_fields) = @_;

    my @_bad_arguments;
    (ref($ids) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"ids\" (value was \"$ids\")");
    (ref($from_fields) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"from_fields\" (value was \"$from_fields\")");
    (ref($rel_fields) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"rel_fields\" (value was \"$rel_fields\")");
    (ref($to_fields) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"to_fields\" (value was \"$to_fields\")");
    if (@_bad_arguments) {
	my $msg = "Invalid arguments passed to get_relationship_Controls:\n" . join("", map { "\t$_\n" } @_bad_arguments);
	Bio::KBase::Exceptions::ArgumentValidationError->throw(error => $msg,
							       method_name => 'get_relationship_Controls');
    }

    my $ctx = $Bio::KBase::CDMI::Service::CallContext;
    my($return);
    #BEGIN get_relationship_Controls

    $return = $self->_get_relationship($ctx, 'Controls', 'Controls', 0, $ids, $from_fields, $rel_fields, $to_fields);
	
    #END get_relationship_Controls
    my @_bad_returns;
    (ref($return) eq 'ARRAY') or push(@_bad_returns, "Invalid type for return variable \"return\" (value was \"$return\")");
    if (@_bad_returns) {
	my $msg = "Invalid returns passed to get_relationship_Controls:\n" . join("", map { "\t$_\n" } @_bad_returns);
	Bio::KBase::Exceptions::ArgumentValidationError->throw(error => $msg,
							       method_name => 'get_relationship_Controls');
    }
    return($return);
}




=head2 get_relationship_IsControlledUsing

  $return = $obj->get_relationship_IsControlledUsing($ids, $from_fields, $rel_fields, $to_fields)

=over 4

=item Parameter and return types

=begin html

<pre>
$ids is a reference to a list where each element is a string
$from_fields is a reference to a list where each element is a string
$rel_fields is a reference to a list where each element is a string
$to_fields is a reference to a list where each element is a string
$return is a reference to a list where each element is a reference to a list containing 3 items:
	0: a fields_CoregulatedSet
	1: a fields_Controls
	2: a fields_Feature
fields_CoregulatedSet is a reference to a hash where the following keys are defined:
	id has a value which is a string
	source_id has a value which is a string
	binding_location has a value which is a reference to a list where each element is an int
fields_Controls is a reference to a hash where the following keys are defined:
	id has a value which is a string
fields_Feature is a reference to a hash where the following keys are defined:
	id has a value which is a string
	feature_type has a value which is a string
	source_id has a value which is a string
	sequence_length has a value which is an int
	function has a value which is a string
	alias has a value which is a reference to a list where each element is a string

</pre>

=end html

=begin text

$ids is a reference to a list where each element is a string
$from_fields is a reference to a list where each element is a string
$rel_fields is a reference to a list where each element is a string
$to_fields is a reference to a list where each element is a string
$return is a reference to a list where each element is a reference to a list containing 3 items:
	0: a fields_CoregulatedSet
	1: a fields_Controls
	2: a fields_Feature
fields_CoregulatedSet is a reference to a hash where the following keys are defined:
	id has a value which is a string
	source_id has a value which is a string
	binding_location has a value which is a reference to a list where each element is an int
fields_Controls is a reference to a hash where the following keys are defined:
	id has a value which is a string
fields_Feature is a reference to a hash where the following keys are defined:
	id has a value which is a string
	feature_type has a value which is a string
	source_id has a value which is a string
	sequence_length has a value which is an int
	function has a value which is a string
	alias has a value which is a reference to a list where each element is a string


=end text



=item Description



=back

=cut

sub get_relationship_IsControlledUsing
{
    my $self = shift;
    my($ids, $from_fields, $rel_fields, $to_fields) = @_;

    my @_bad_arguments;
    (ref($ids) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"ids\" (value was \"$ids\")");
    (ref($from_fields) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"from_fields\" (value was \"$from_fields\")");
    (ref($rel_fields) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"rel_fields\" (value was \"$rel_fields\")");
    (ref($to_fields) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"to_fields\" (value was \"$to_fields\")");
    if (@_bad_arguments) {
	my $msg = "Invalid arguments passed to get_relationship_IsControlledUsing:\n" . join("", map { "\t$_\n" } @_bad_arguments);
	Bio::KBase::Exceptions::ArgumentValidationError->throw(error => $msg,
							       method_name => 'get_relationship_IsControlledUsing');
    }

    my $ctx = $Bio::KBase::CDMI::Service::CallContext;
    my($return);
    #BEGIN get_relationship_IsControlledUsing

    $return = $self->_get_relationship($ctx, 'IsControlledUsing', 'Controls', 1, $ids, $from_fields, $rel_fields, $to_fields);
	
    #END get_relationship_IsControlledUsing
    my @_bad_returns;
    (ref($return) eq 'ARRAY') or push(@_bad_returns, "Invalid type for return variable \"return\" (value was \"$return\")");
    if (@_bad_returns) {
	my $msg = "Invalid returns passed to get_relationship_IsControlledUsing:\n" . join("", map { "\t$_\n" } @_bad_returns);
	Bio::KBase::Exceptions::ArgumentValidationError->throw(error => $msg,
							       method_name => 'get_relationship_IsControlledUsing');
    }
    return($return);
}




=head2 get_relationship_Describes

  $return = $obj->get_relationship_Describes($ids, $from_fields, $rel_fields, $to_fields)

=over 4

=item Parameter and return types

=begin html

<pre>
$ids is a reference to a list where each element is a string
$from_fields is a reference to a list where each element is a string
$rel_fields is a reference to a list where each element is a string
$to_fields is a reference to a list where each element is a string
$return is a reference to a list where each element is a reference to a list containing 3 items:
	0: a fields_Subsystem
	1: a fields_Describes
	2: a fields_Variant
fields_Subsystem is a reference to a hash where the following keys are defined:
	id has a value which is a string
	version has a value which is an int
	curator has a value which is a string
	notes has a value which is a string
	description has a value which is a string
	usable has a value which is an int
	private has a value which is an int
	cluster_based has a value which is an int
	experimental has a value which is an int
fields_Describes is a reference to a hash where the following keys are defined:
	id has a value which is a string
fields_Variant is a reference to a hash where the following keys are defined:
	id has a value which is a string
	role_rule has a value which is a reference to a list where each element is a string
	code has a value which is a string
	type has a value which is a string
	comment has a value which is a string

</pre>

=end html

=begin text

$ids is a reference to a list where each element is a string
$from_fields is a reference to a list where each element is a string
$rel_fields is a reference to a list where each element is a string
$to_fields is a reference to a list where each element is a string
$return is a reference to a list where each element is a reference to a list containing 3 items:
	0: a fields_Subsystem
	1: a fields_Describes
	2: a fields_Variant
fields_Subsystem is a reference to a hash where the following keys are defined:
	id has a value which is a string
	version has a value which is an int
	curator has a value which is a string
	notes has a value which is a string
	description has a value which is a string
	usable has a value which is an int
	private has a value which is an int
	cluster_based has a value which is an int
	experimental has a value which is an int
fields_Describes is a reference to a hash where the following keys are defined:
	id has a value which is a string
fields_Variant is a reference to a hash where the following keys are defined:
	id has a value which is a string
	role_rule has a value which is a reference to a list where each element is a string
	code has a value which is a string
	type has a value which is a string
	comment has a value which is a string


=end text



=item Description

This relationship connects a subsystem to the individual
variants used to implement it. Each variant contains a slightly
different subset of the roles in the parent subsystem.
It has the following fields:

=over 4



=back

=back

=cut

sub get_relationship_Describes
{
    my $self = shift;
    my($ids, $from_fields, $rel_fields, $to_fields) = @_;

    my @_bad_arguments;
    (ref($ids) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"ids\" (value was \"$ids\")");
    (ref($from_fields) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"from_fields\" (value was \"$from_fields\")");
    (ref($rel_fields) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"rel_fields\" (value was \"$rel_fields\")");
    (ref($to_fields) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"to_fields\" (value was \"$to_fields\")");
    if (@_bad_arguments) {
	my $msg = "Invalid arguments passed to get_relationship_Describes:\n" . join("", map { "\t$_\n" } @_bad_arguments);
	Bio::KBase::Exceptions::ArgumentValidationError->throw(error => $msg,
							       method_name => 'get_relationship_Describes');
    }

    my $ctx = $Bio::KBase::CDMI::Service::CallContext;
    my($return);
    #BEGIN get_relationship_Describes

    $return = $self->_get_relationship($ctx, 'Describes', 'Describes', 0, $ids, $from_fields, $rel_fields, $to_fields);
	
    #END get_relationship_Describes
    my @_bad_returns;
    (ref($return) eq 'ARRAY') or push(@_bad_returns, "Invalid type for return variable \"return\" (value was \"$return\")");
    if (@_bad_returns) {
	my $msg = "Invalid returns passed to get_relationship_Describes:\n" . join("", map { "\t$_\n" } @_bad_returns);
	Bio::KBase::Exceptions::ArgumentValidationError->throw(error => $msg,
							       method_name => 'get_relationship_Describes');
    }
    return($return);
}




=head2 get_relationship_IsDescribedBy

  $return = $obj->get_relationship_IsDescribedBy($ids, $from_fields, $rel_fields, $to_fields)

=over 4

=item Parameter and return types

=begin html

<pre>
$ids is a reference to a list where each element is a string
$from_fields is a reference to a list where each element is a string
$rel_fields is a reference to a list where each element is a string
$to_fields is a reference to a list where each element is a string
$return is a reference to a list where each element is a reference to a list containing 3 items:
	0: a fields_Variant
	1: a fields_Describes
	2: a fields_Subsystem
fields_Variant is a reference to a hash where the following keys are defined:
	id has a value which is a string
	role_rule has a value which is a reference to a list where each element is a string
	code has a value which is a string
	type has a value which is a string
	comment has a value which is a string
fields_Describes is a reference to a hash where the following keys are defined:
	id has a value which is a string
fields_Subsystem is a reference to a hash where the following keys are defined:
	id has a value which is a string
	version has a value which is an int
	curator has a value which is a string
	notes has a value which is a string
	description has a value which is a string
	usable has a value which is an int
	private has a value which is an int
	cluster_based has a value which is an int
	experimental has a value which is an int

</pre>

=end html

=begin text

$ids is a reference to a list where each element is a string
$from_fields is a reference to a list where each element is a string
$rel_fields is a reference to a list where each element is a string
$to_fields is a reference to a list where each element is a string
$return is a reference to a list where each element is a reference to a list containing 3 items:
	0: a fields_Variant
	1: a fields_Describes
	2: a fields_Subsystem
fields_Variant is a reference to a hash where the following keys are defined:
	id has a value which is a string
	role_rule has a value which is a reference to a list where each element is a string
	code has a value which is a string
	type has a value which is a string
	comment has a value which is a string
fields_Describes is a reference to a hash where the following keys are defined:
	id has a value which is a string
fields_Subsystem is a reference to a hash where the following keys are defined:
	id has a value which is a string
	version has a value which is an int
	curator has a value which is a string
	notes has a value which is a string
	description has a value which is a string
	usable has a value which is an int
	private has a value which is an int
	cluster_based has a value which is an int
	experimental has a value which is an int


=end text



=item Description



=back

=cut

sub get_relationship_IsDescribedBy
{
    my $self = shift;
    my($ids, $from_fields, $rel_fields, $to_fields) = @_;

    my @_bad_arguments;
    (ref($ids) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"ids\" (value was \"$ids\")");
    (ref($from_fields) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"from_fields\" (value was \"$from_fields\")");
    (ref($rel_fields) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"rel_fields\" (value was \"$rel_fields\")");
    (ref($to_fields) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"to_fields\" (value was \"$to_fields\")");
    if (@_bad_arguments) {
	my $msg = "Invalid arguments passed to get_relationship_IsDescribedBy:\n" . join("", map { "\t$_\n" } @_bad_arguments);
	Bio::KBase::Exceptions::ArgumentValidationError->throw(error => $msg,
							       method_name => 'get_relationship_IsDescribedBy');
    }

    my $ctx = $Bio::KBase::CDMI::Service::CallContext;
    my($return);
    #BEGIN get_relationship_IsDescribedBy

    $return = $self->_get_relationship($ctx, 'IsDescribedBy', 'Describes', 1, $ids, $from_fields, $rel_fields, $to_fields);
	
    #END get_relationship_IsDescribedBy
    my @_bad_returns;
    (ref($return) eq 'ARRAY') or push(@_bad_returns, "Invalid type for return variable \"return\" (value was \"$return\")");
    if (@_bad_returns) {
	my $msg = "Invalid returns passed to get_relationship_IsDescribedBy:\n" . join("", map { "\t$_\n" } @_bad_returns);
	Bio::KBase::Exceptions::ArgumentValidationError->throw(error => $msg,
							       method_name => 'get_relationship_IsDescribedBy');
    }
    return($return);
}




=head2 get_relationship_Displays

  $return = $obj->get_relationship_Displays($ids, $from_fields, $rel_fields, $to_fields)

=over 4

=item Parameter and return types

=begin html

<pre>
$ids is a reference to a list where each element is a string
$from_fields is a reference to a list where each element is a string
$rel_fields is a reference to a list where each element is a string
$to_fields is a reference to a list where each element is a string
$return is a reference to a list where each element is a reference to a list containing 3 items:
	0: a fields_Diagram
	1: a fields_Displays
	2: a fields_Reaction
fields_Diagram is a reference to a hash where the following keys are defined:
	id has a value which is a string
	name has a value which is a string
	content has a value which is a reference to a list where each element is a string
fields_Displays is a reference to a hash where the following keys are defined:
	id has a value which is a string
	location has a value which is a rectangle
rectangle is a string
fields_Reaction is a reference to a hash where the following keys are defined:
	id has a value which is a string
	mod_date has a value which is a string
	name has a value which is a string
	msid has a value which is a string
	abbr has a value which is a string
	equation has a value which is a string
	reversibility has a value which is a string

</pre>

=end html

=begin text

$ids is a reference to a list where each element is a string
$from_fields is a reference to a list where each element is a string
$rel_fields is a reference to a list where each element is a string
$to_fields is a reference to a list where each element is a string
$return is a reference to a list where each element is a reference to a list containing 3 items:
	0: a fields_Diagram
	1: a fields_Displays
	2: a fields_Reaction
fields_Diagram is a reference to a hash where the following keys are defined:
	id has a value which is a string
	name has a value which is a string
	content has a value which is a reference to a list where each element is a string
fields_Displays is a reference to a hash where the following keys are defined:
	id has a value which is a string
	location has a value which is a rectangle
rectangle is a string
fields_Reaction is a reference to a hash where the following keys are defined:
	id has a value which is a string
	mod_date has a value which is a string
	name has a value which is a string
	msid has a value which is a string
	abbr has a value which is a string
	equation has a value which is a string
	reversibility has a value which is a string


=end text



=item Description

This relationship connects a diagram to its reactions. A
diagram shows multiple reactions, and a reaction can be on many
diagrams.
It has the following fields:

=over 4


=item location

Location of the reaction's node on the diagram.



=back

=back

=cut

sub get_relationship_Displays
{
    my $self = shift;
    my($ids, $from_fields, $rel_fields, $to_fields) = @_;

    my @_bad_arguments;
    (ref($ids) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"ids\" (value was \"$ids\")");
    (ref($from_fields) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"from_fields\" (value was \"$from_fields\")");
    (ref($rel_fields) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"rel_fields\" (value was \"$rel_fields\")");
    (ref($to_fields) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"to_fields\" (value was \"$to_fields\")");
    if (@_bad_arguments) {
	my $msg = "Invalid arguments passed to get_relationship_Displays:\n" . join("", map { "\t$_\n" } @_bad_arguments);
	Bio::KBase::Exceptions::ArgumentValidationError->throw(error => $msg,
							       method_name => 'get_relationship_Displays');
    }

    my $ctx = $Bio::KBase::CDMI::Service::CallContext;
    my($return);
    #BEGIN get_relationship_Displays

    $return = $self->_get_relationship($ctx, 'Displays', 'Displays', 0, $ids, $from_fields, $rel_fields, $to_fields);
	
    #END get_relationship_Displays
    my @_bad_returns;
    (ref($return) eq 'ARRAY') or push(@_bad_returns, "Invalid type for return variable \"return\" (value was \"$return\")");
    if (@_bad_returns) {
	my $msg = "Invalid returns passed to get_relationship_Displays:\n" . join("", map { "\t$_\n" } @_bad_returns);
	Bio::KBase::Exceptions::ArgumentValidationError->throw(error => $msg,
							       method_name => 'get_relationship_Displays');
    }
    return($return);
}




=head2 get_relationship_IsDisplayedOn

  $return = $obj->get_relationship_IsDisplayedOn($ids, $from_fields, $rel_fields, $to_fields)

=over 4

=item Parameter and return types

=begin html

<pre>
$ids is a reference to a list where each element is a string
$from_fields is a reference to a list where each element is a string
$rel_fields is a reference to a list where each element is a string
$to_fields is a reference to a list where each element is a string
$return is a reference to a list where each element is a reference to a list containing 3 items:
	0: a fields_Reaction
	1: a fields_Displays
	2: a fields_Diagram
fields_Reaction is a reference to a hash where the following keys are defined:
	id has a value which is a string
	mod_date has a value which is a string
	name has a value which is a string
	msid has a value which is a string
	abbr has a value which is a string
	equation has a value which is a string
	reversibility has a value which is a string
fields_Displays is a reference to a hash where the following keys are defined:
	id has a value which is a string
	location has a value which is a rectangle
rectangle is a string
fields_Diagram is a reference to a hash where the following keys are defined:
	id has a value which is a string
	name has a value which is a string
	content has a value which is a reference to a list where each element is a string

</pre>

=end html

=begin text

$ids is a reference to a list where each element is a string
$from_fields is a reference to a list where each element is a string
$rel_fields is a reference to a list where each element is a string
$to_fields is a reference to a list where each element is a string
$return is a reference to a list where each element is a reference to a list containing 3 items:
	0: a fields_Reaction
	1: a fields_Displays
	2: a fields_Diagram
fields_Reaction is a reference to a hash where the following keys are defined:
	id has a value which is a string
	mod_date has a value which is a string
	name has a value which is a string
	msid has a value which is a string
	abbr has a value which is a string
	equation has a value which is a string
	reversibility has a value which is a string
fields_Displays is a reference to a hash where the following keys are defined:
	id has a value which is a string
	location has a value which is a rectangle
rectangle is a string
fields_Diagram is a reference to a hash where the following keys are defined:
	id has a value which is a string
	name has a value which is a string
	content has a value which is a reference to a list where each element is a string


=end text



=item Description



=back

=cut

sub get_relationship_IsDisplayedOn
{
    my $self = shift;
    my($ids, $from_fields, $rel_fields, $to_fields) = @_;

    my @_bad_arguments;
    (ref($ids) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"ids\" (value was \"$ids\")");
    (ref($from_fields) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"from_fields\" (value was \"$from_fields\")");
    (ref($rel_fields) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"rel_fields\" (value was \"$rel_fields\")");
    (ref($to_fields) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"to_fields\" (value was \"$to_fields\")");
    if (@_bad_arguments) {
	my $msg = "Invalid arguments passed to get_relationship_IsDisplayedOn:\n" . join("", map { "\t$_\n" } @_bad_arguments);
	Bio::KBase::Exceptions::ArgumentValidationError->throw(error => $msg,
							       method_name => 'get_relationship_IsDisplayedOn');
    }

    my $ctx = $Bio::KBase::CDMI::Service::CallContext;
    my($return);
    #BEGIN get_relationship_IsDisplayedOn

    $return = $self->_get_relationship($ctx, 'IsDisplayedOn', 'Displays', 1, $ids, $from_fields, $rel_fields, $to_fields);
	
    #END get_relationship_IsDisplayedOn
    my @_bad_returns;
    (ref($return) eq 'ARRAY') or push(@_bad_returns, "Invalid type for return variable \"return\" (value was \"$return\")");
    if (@_bad_returns) {
	my $msg = "Invalid returns passed to get_relationship_IsDisplayedOn:\n" . join("", map { "\t$_\n" } @_bad_returns);
	Bio::KBase::Exceptions::ArgumentValidationError->throw(error => $msg,
							       method_name => 'get_relationship_IsDisplayedOn');
    }
    return($return);
}




=head2 get_relationship_Encompasses

  $return = $obj->get_relationship_Encompasses($ids, $from_fields, $rel_fields, $to_fields)

=over 4

=item Parameter and return types

=begin html

<pre>
$ids is a reference to a list where each element is a string
$from_fields is a reference to a list where each element is a string
$rel_fields is a reference to a list where each element is a string
$to_fields is a reference to a list where each element is a string
$return is a reference to a list where each element is a reference to a list containing 3 items:
	0: a fields_Feature
	1: a fields_Encompasses
	2: a fields_Feature
fields_Feature is a reference to a hash where the following keys are defined:
	id has a value which is a string
	feature_type has a value which is a string
	source_id has a value which is a string
	sequence_length has a value which is an int
	function has a value which is a string
	alias has a value which is a reference to a list where each element is a string
fields_Encompasses is a reference to a hash where the following keys are defined:
	id has a value which is a string

</pre>

=end html

=begin text

$ids is a reference to a list where each element is a string
$from_fields is a reference to a list where each element is a string
$rel_fields is a reference to a list where each element is a string
$to_fields is a reference to a list where each element is a string
$return is a reference to a list where each element is a reference to a list containing 3 items:
	0: a fields_Feature
	1: a fields_Encompasses
	2: a fields_Feature
fields_Feature is a reference to a hash where the following keys are defined:
	id has a value which is a string
	feature_type has a value which is a string
	source_id has a value which is a string
	sequence_length has a value which is an int
	function has a value which is a string
	alias has a value which is a reference to a list where each element is a string
fields_Encompasses is a reference to a hash where the following keys are defined:
	id has a value which is a string


=end text



=item Description

This relationship connects a feature to a related
feature; for example, it would connect a gene to its
constituent splice variants, and the splice variants to their
exons.
It has the following fields:

=over 4



=back

=back

=cut

sub get_relationship_Encompasses
{
    my $self = shift;
    my($ids, $from_fields, $rel_fields, $to_fields) = @_;

    my @_bad_arguments;
    (ref($ids) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"ids\" (value was \"$ids\")");
    (ref($from_fields) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"from_fields\" (value was \"$from_fields\")");
    (ref($rel_fields) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"rel_fields\" (value was \"$rel_fields\")");
    (ref($to_fields) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"to_fields\" (value was \"$to_fields\")");
    if (@_bad_arguments) {
	my $msg = "Invalid arguments passed to get_relationship_Encompasses:\n" . join("", map { "\t$_\n" } @_bad_arguments);
	Bio::KBase::Exceptions::ArgumentValidationError->throw(error => $msg,
							       method_name => 'get_relationship_Encompasses');
    }

    my $ctx = $Bio::KBase::CDMI::Service::CallContext;
    my($return);
    #BEGIN get_relationship_Encompasses

    $return = $self->_get_relationship($ctx, 'Encompasses', 'Encompasses', 0, $ids, $from_fields, $rel_fields, $to_fields);
	
    #END get_relationship_Encompasses
    my @_bad_returns;
    (ref($return) eq 'ARRAY') or push(@_bad_returns, "Invalid type for return variable \"return\" (value was \"$return\")");
    if (@_bad_returns) {
	my $msg = "Invalid returns passed to get_relationship_Encompasses:\n" . join("", map { "\t$_\n" } @_bad_returns);
	Bio::KBase::Exceptions::ArgumentValidationError->throw(error => $msg,
							       method_name => 'get_relationship_Encompasses');
    }
    return($return);
}




=head2 get_relationship_IsEncompassedIn

  $return = $obj->get_relationship_IsEncompassedIn($ids, $from_fields, $rel_fields, $to_fields)

=over 4

=item Parameter and return types

=begin html

<pre>
$ids is a reference to a list where each element is a string
$from_fields is a reference to a list where each element is a string
$rel_fields is a reference to a list where each element is a string
$to_fields is a reference to a list where each element is a string
$return is a reference to a list where each element is a reference to a list containing 3 items:
	0: a fields_Feature
	1: a fields_Encompasses
	2: a fields_Feature
fields_Feature is a reference to a hash where the following keys are defined:
	id has a value which is a string
	feature_type has a value which is a string
	source_id has a value which is a string
	sequence_length has a value which is an int
	function has a value which is a string
	alias has a value which is a reference to a list where each element is a string
fields_Encompasses is a reference to a hash where the following keys are defined:
	id has a value which is a string

</pre>

=end html

=begin text

$ids is a reference to a list where each element is a string
$from_fields is a reference to a list where each element is a string
$rel_fields is a reference to a list where each element is a string
$to_fields is a reference to a list where each element is a string
$return is a reference to a list where each element is a reference to a list containing 3 items:
	0: a fields_Feature
	1: a fields_Encompasses
	2: a fields_Feature
fields_Feature is a reference to a hash where the following keys are defined:
	id has a value which is a string
	feature_type has a value which is a string
	source_id has a value which is a string
	sequence_length has a value which is an int
	function has a value which is a string
	alias has a value which is a reference to a list where each element is a string
fields_Encompasses is a reference to a hash where the following keys are defined:
	id has a value which is a string


=end text



=item Description



=back

=cut

sub get_relationship_IsEncompassedIn
{
    my $self = shift;
    my($ids, $from_fields, $rel_fields, $to_fields) = @_;

    my @_bad_arguments;
    (ref($ids) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"ids\" (value was \"$ids\")");
    (ref($from_fields) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"from_fields\" (value was \"$from_fields\")");
    (ref($rel_fields) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"rel_fields\" (value was \"$rel_fields\")");
    (ref($to_fields) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"to_fields\" (value was \"$to_fields\")");
    if (@_bad_arguments) {
	my $msg = "Invalid arguments passed to get_relationship_IsEncompassedIn:\n" . join("", map { "\t$_\n" } @_bad_arguments);
	Bio::KBase::Exceptions::ArgumentValidationError->throw(error => $msg,
							       method_name => 'get_relationship_IsEncompassedIn');
    }

    my $ctx = $Bio::KBase::CDMI::Service::CallContext;
    my($return);
    #BEGIN get_relationship_IsEncompassedIn

    $return = $self->_get_relationship($ctx, 'IsEncompassedIn', 'Encompasses', 1, $ids, $from_fields, $rel_fields, $to_fields);
	
    #END get_relationship_IsEncompassedIn
    my @_bad_returns;
    (ref($return) eq 'ARRAY') or push(@_bad_returns, "Invalid type for return variable \"return\" (value was \"$return\")");
    if (@_bad_returns) {
	my $msg = "Invalid returns passed to get_relationship_IsEncompassedIn:\n" . join("", map { "\t$_\n" } @_bad_returns);
	Bio::KBase::Exceptions::ArgumentValidationError->throw(error => $msg,
							       method_name => 'get_relationship_IsEncompassedIn');
    }
    return($return);
}




=head2 get_relationship_Formulated

  $return = $obj->get_relationship_Formulated($ids, $from_fields, $rel_fields, $to_fields)

=over 4

=item Parameter and return types

=begin html

<pre>
$ids is a reference to a list where each element is a string
$from_fields is a reference to a list where each element is a string
$rel_fields is a reference to a list where each element is a string
$to_fields is a reference to a list where each element is a string
$return is a reference to a list where each element is a reference to a list containing 3 items:
	0: a fields_Source
	1: a fields_Formulated
	2: a fields_CoregulatedSet
fields_Source is a reference to a hash where the following keys are defined:
	id has a value which is a string
fields_Formulated is a reference to a hash where the following keys are defined:
	id has a value which is a string
fields_CoregulatedSet is a reference to a hash where the following keys are defined:
	id has a value which is a string
	source_id has a value which is a string
	binding_location has a value which is a reference to a list where each element is an int

</pre>

=end html

=begin text

$ids is a reference to a list where each element is a string
$from_fields is a reference to a list where each element is a string
$rel_fields is a reference to a list where each element is a string
$to_fields is a reference to a list where each element is a string
$return is a reference to a list where each element is a reference to a list containing 3 items:
	0: a fields_Source
	1: a fields_Formulated
	2: a fields_CoregulatedSet
fields_Source is a reference to a hash where the following keys are defined:
	id has a value which is a string
fields_Formulated is a reference to a hash where the following keys are defined:
	id has a value which is a string
fields_CoregulatedSet is a reference to a hash where the following keys are defined:
	id has a value which is a string
	source_id has a value which is a string
	binding_location has a value which is a reference to a list where each element is an int


=end text



=item Description

This relationship connects a coregulated set to the
source organization that originally computed it.
It has the following fields:

=over 4



=back

=back

=cut

sub get_relationship_Formulated
{
    my $self = shift;
    my($ids, $from_fields, $rel_fields, $to_fields) = @_;

    my @_bad_arguments;
    (ref($ids) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"ids\" (value was \"$ids\")");
    (ref($from_fields) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"from_fields\" (value was \"$from_fields\")");
    (ref($rel_fields) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"rel_fields\" (value was \"$rel_fields\")");
    (ref($to_fields) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"to_fields\" (value was \"$to_fields\")");
    if (@_bad_arguments) {
	my $msg = "Invalid arguments passed to get_relationship_Formulated:\n" . join("", map { "\t$_\n" } @_bad_arguments);
	Bio::KBase::Exceptions::ArgumentValidationError->throw(error => $msg,
							       method_name => 'get_relationship_Formulated');
    }

    my $ctx = $Bio::KBase::CDMI::Service::CallContext;
    my($return);
    #BEGIN get_relationship_Formulated

    $return = $self->_get_relationship($ctx, 'Formulated', 'Formulated', 0, $ids, $from_fields, $rel_fields, $to_fields);
	
    #END get_relationship_Formulated
    my @_bad_returns;
    (ref($return) eq 'ARRAY') or push(@_bad_returns, "Invalid type for return variable \"return\" (value was \"$return\")");
    if (@_bad_returns) {
	my $msg = "Invalid returns passed to get_relationship_Formulated:\n" . join("", map { "\t$_\n" } @_bad_returns);
	Bio::KBase::Exceptions::ArgumentValidationError->throw(error => $msg,
							       method_name => 'get_relationship_Formulated');
    }
    return($return);
}




=head2 get_relationship_WasFormulatedBy

  $return = $obj->get_relationship_WasFormulatedBy($ids, $from_fields, $rel_fields, $to_fields)

=over 4

=item Parameter and return types

=begin html

<pre>
$ids is a reference to a list where each element is a string
$from_fields is a reference to a list where each element is a string
$rel_fields is a reference to a list where each element is a string
$to_fields is a reference to a list where each element is a string
$return is a reference to a list where each element is a reference to a list containing 3 items:
	0: a fields_CoregulatedSet
	1: a fields_Formulated
	2: a fields_Source
fields_CoregulatedSet is a reference to a hash where the following keys are defined:
	id has a value which is a string
	source_id has a value which is a string
	binding_location has a value which is a reference to a list where each element is an int
fields_Formulated is a reference to a hash where the following keys are defined:
	id has a value which is a string
fields_Source is a reference to a hash where the following keys are defined:
	id has a value which is a string

</pre>

=end html

=begin text

$ids is a reference to a list where each element is a string
$from_fields is a reference to a list where each element is a string
$rel_fields is a reference to a list where each element is a string
$to_fields is a reference to a list where each element is a string
$return is a reference to a list where each element is a reference to a list containing 3 items:
	0: a fields_CoregulatedSet
	1: a fields_Formulated
	2: a fields_Source
fields_CoregulatedSet is a reference to a hash where the following keys are defined:
	id has a value which is a string
	source_id has a value which is a string
	binding_location has a value which is a reference to a list where each element is an int
fields_Formulated is a reference to a hash where the following keys are defined:
	id has a value which is a string
fields_Source is a reference to a hash where the following keys are defined:
	id has a value which is a string


=end text



=item Description



=back

=cut

sub get_relationship_WasFormulatedBy
{
    my $self = shift;
    my($ids, $from_fields, $rel_fields, $to_fields) = @_;

    my @_bad_arguments;
    (ref($ids) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"ids\" (value was \"$ids\")");
    (ref($from_fields) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"from_fields\" (value was \"$from_fields\")");
    (ref($rel_fields) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"rel_fields\" (value was \"$rel_fields\")");
    (ref($to_fields) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"to_fields\" (value was \"$to_fields\")");
    if (@_bad_arguments) {
	my $msg = "Invalid arguments passed to get_relationship_WasFormulatedBy:\n" . join("", map { "\t$_\n" } @_bad_arguments);
	Bio::KBase::Exceptions::ArgumentValidationError->throw(error => $msg,
							       method_name => 'get_relationship_WasFormulatedBy');
    }

    my $ctx = $Bio::KBase::CDMI::Service::CallContext;
    my($return);
    #BEGIN get_relationship_WasFormulatedBy

    $return = $self->_get_relationship($ctx, 'WasFormulatedBy', 'Formulated', 1, $ids, $from_fields, $rel_fields, $to_fields);
	
    #END get_relationship_WasFormulatedBy
    my @_bad_returns;
    (ref($return) eq 'ARRAY') or push(@_bad_returns, "Invalid type for return variable \"return\" (value was \"$return\")");
    if (@_bad_returns) {
	my $msg = "Invalid returns passed to get_relationship_WasFormulatedBy:\n" . join("", map { "\t$_\n" } @_bad_returns);
	Bio::KBase::Exceptions::ArgumentValidationError->throw(error => $msg,
							       method_name => 'get_relationship_WasFormulatedBy');
    }
    return($return);
}




=head2 get_relationship_GeneratedLevelsFor

  $return = $obj->get_relationship_GeneratedLevelsFor($ids, $from_fields, $rel_fields, $to_fields)

=over 4

=item Parameter and return types

=begin html

<pre>
$ids is a reference to a list where each element is a string
$from_fields is a reference to a list where each element is a string
$rel_fields is a reference to a list where each element is a string
$to_fields is a reference to a list where each element is a string
$return is a reference to a list where each element is a reference to a list containing 3 items:
	0: a fields_ProbeSet
	1: a fields_GeneratedLevelsFor
	2: a fields_AtomicRegulon
fields_ProbeSet is a reference to a hash where the following keys are defined:
	id has a value which is a string
fields_GeneratedLevelsFor is a reference to a hash where the following keys are defined:
	id has a value which is a string
	level_vector has a value which is a countVector
countVector is a string
fields_AtomicRegulon is a reference to a hash where the following keys are defined:
	id has a value which is a string

</pre>

=end html

=begin text

$ids is a reference to a list where each element is a string
$from_fields is a reference to a list where each element is a string
$rel_fields is a reference to a list where each element is a string
$to_fields is a reference to a list where each element is a string
$return is a reference to a list where each element is a reference to a list containing 3 items:
	0: a fields_ProbeSet
	1: a fields_GeneratedLevelsFor
	2: a fields_AtomicRegulon
fields_ProbeSet is a reference to a hash where the following keys are defined:
	id has a value which is a string
fields_GeneratedLevelsFor is a reference to a hash where the following keys are defined:
	id has a value which is a string
	level_vector has a value which is a countVector
countVector is a string
fields_AtomicRegulon is a reference to a hash where the following keys are defined:
	id has a value which is a string


=end text



=item Description

This relationship connects an atomic regulon to a probe set from which experimental
data was produced for its features. It contains a vector of the expression levels.
It has the following fields:

=over 4


=item level_vector

Vector of expression levels (-1, 0, 1) for the experiments, in
sequence order.



=back

=back

=cut

sub get_relationship_GeneratedLevelsFor
{
    my $self = shift;
    my($ids, $from_fields, $rel_fields, $to_fields) = @_;

    my @_bad_arguments;
    (ref($ids) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"ids\" (value was \"$ids\")");
    (ref($from_fields) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"from_fields\" (value was \"$from_fields\")");
    (ref($rel_fields) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"rel_fields\" (value was \"$rel_fields\")");
    (ref($to_fields) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"to_fields\" (value was \"$to_fields\")");
    if (@_bad_arguments) {
	my $msg = "Invalid arguments passed to get_relationship_GeneratedLevelsFor:\n" . join("", map { "\t$_\n" } @_bad_arguments);
	Bio::KBase::Exceptions::ArgumentValidationError->throw(error => $msg,
							       method_name => 'get_relationship_GeneratedLevelsFor');
    }

    my $ctx = $Bio::KBase::CDMI::Service::CallContext;
    my($return);
    #BEGIN get_relationship_GeneratedLevelsFor

    $return = $self->_get_relationship($ctx, 'GeneratedLevelsFor', 'GeneratedLevelsFor', 0, $ids, $from_fields, $rel_fields, $to_fields);
	
    #END get_relationship_GeneratedLevelsFor
    my @_bad_returns;
    (ref($return) eq 'ARRAY') or push(@_bad_returns, "Invalid type for return variable \"return\" (value was \"$return\")");
    if (@_bad_returns) {
	my $msg = "Invalid returns passed to get_relationship_GeneratedLevelsFor:\n" . join("", map { "\t$_\n" } @_bad_returns);
	Bio::KBase::Exceptions::ArgumentValidationError->throw(error => $msg,
							       method_name => 'get_relationship_GeneratedLevelsFor');
    }
    return($return);
}




=head2 get_relationship_WasGeneratedFrom

  $return = $obj->get_relationship_WasGeneratedFrom($ids, $from_fields, $rel_fields, $to_fields)

=over 4

=item Parameter and return types

=begin html

<pre>
$ids is a reference to a list where each element is a string
$from_fields is a reference to a list where each element is a string
$rel_fields is a reference to a list where each element is a string
$to_fields is a reference to a list where each element is a string
$return is a reference to a list where each element is a reference to a list containing 3 items:
	0: a fields_AtomicRegulon
	1: a fields_GeneratedLevelsFor
	2: a fields_ProbeSet
fields_AtomicRegulon is a reference to a hash where the following keys are defined:
	id has a value which is a string
fields_GeneratedLevelsFor is a reference to a hash where the following keys are defined:
	id has a value which is a string
	level_vector has a value which is a countVector
countVector is a string
fields_ProbeSet is a reference to a hash where the following keys are defined:
	id has a value which is a string

</pre>

=end html

=begin text

$ids is a reference to a list where each element is a string
$from_fields is a reference to a list where each element is a string
$rel_fields is a reference to a list where each element is a string
$to_fields is a reference to a list where each element is a string
$return is a reference to a list where each element is a reference to a list containing 3 items:
	0: a fields_AtomicRegulon
	1: a fields_GeneratedLevelsFor
	2: a fields_ProbeSet
fields_AtomicRegulon is a reference to a hash where the following keys are defined:
	id has a value which is a string
fields_GeneratedLevelsFor is a reference to a hash where the following keys are defined:
	id has a value which is a string
	level_vector has a value which is a countVector
countVector is a string
fields_ProbeSet is a reference to a hash where the following keys are defined:
	id has a value which is a string


=end text



=item Description



=back

=cut

sub get_relationship_WasGeneratedFrom
{
    my $self = shift;
    my($ids, $from_fields, $rel_fields, $to_fields) = @_;

    my @_bad_arguments;
    (ref($ids) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"ids\" (value was \"$ids\")");
    (ref($from_fields) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"from_fields\" (value was \"$from_fields\")");
    (ref($rel_fields) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"rel_fields\" (value was \"$rel_fields\")");
    (ref($to_fields) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"to_fields\" (value was \"$to_fields\")");
    if (@_bad_arguments) {
	my $msg = "Invalid arguments passed to get_relationship_WasGeneratedFrom:\n" . join("", map { "\t$_\n" } @_bad_arguments);
	Bio::KBase::Exceptions::ArgumentValidationError->throw(error => $msg,
							       method_name => 'get_relationship_WasGeneratedFrom');
    }

    my $ctx = $Bio::KBase::CDMI::Service::CallContext;
    my($return);
    #BEGIN get_relationship_WasGeneratedFrom

    $return = $self->_get_relationship($ctx, 'WasGeneratedFrom', 'GeneratedLevelsFor', 1, $ids, $from_fields, $rel_fields, $to_fields);
	
    #END get_relationship_WasGeneratedFrom
    my @_bad_returns;
    (ref($return) eq 'ARRAY') or push(@_bad_returns, "Invalid type for return variable \"return\" (value was \"$return\")");
    if (@_bad_returns) {
	my $msg = "Invalid returns passed to get_relationship_WasGeneratedFrom:\n" . join("", map { "\t$_\n" } @_bad_returns);
	Bio::KBase::Exceptions::ArgumentValidationError->throw(error => $msg,
							       method_name => 'get_relationship_WasGeneratedFrom');
    }
    return($return);
}




=head2 get_relationship_HasCompoundAliasFrom

  $return = $obj->get_relationship_HasCompoundAliasFrom($ids, $from_fields, $rel_fields, $to_fields)

=over 4

=item Parameter and return types

=begin html

<pre>
$ids is a reference to a list where each element is a string
$from_fields is a reference to a list where each element is a string
$rel_fields is a reference to a list where each element is a string
$to_fields is a reference to a list where each element is a string
$return is a reference to a list where each element is a reference to a list containing 3 items:
	0: a fields_Source
	1: a fields_HasCompoundAliasFrom
	2: a fields_Compound
fields_Source is a reference to a hash where the following keys are defined:
	id has a value which is a string
fields_HasCompoundAliasFrom is a reference to a hash where the following keys are defined:
	id has a value which is a string
	alias has a value which is a string
fields_Compound is a reference to a hash where the following keys are defined:
	id has a value which is a string
	label has a value which is a string
	abbr has a value which is a string
	msid has a value which is a string
	ubiquitous has a value which is an int
	mod_date has a value which is a string
	uncharged_formula has a value which is a string
	formula has a value which is a string
	mass has a value which is a float

</pre>

=end html

=begin text

$ids is a reference to a list where each element is a string
$from_fields is a reference to a list where each element is a string
$rel_fields is a reference to a list where each element is a string
$to_fields is a reference to a list where each element is a string
$return is a reference to a list where each element is a reference to a list containing 3 items:
	0: a fields_Source
	1: a fields_HasCompoundAliasFrom
	2: a fields_Compound
fields_Source is a reference to a hash where the following keys are defined:
	id has a value which is a string
fields_HasCompoundAliasFrom is a reference to a hash where the following keys are defined:
	id has a value which is a string
	alias has a value which is a string
fields_Compound is a reference to a hash where the following keys are defined:
	id has a value which is a string
	label has a value which is a string
	abbr has a value which is a string
	msid has a value which is a string
	ubiquitous has a value which is an int
	mod_date has a value which is a string
	uncharged_formula has a value which is a string
	formula has a value which is a string
	mass has a value which is a float


=end text



=item Description

This relationship connects a source (database or organization)
with the compounds for which it has assigned names (aliases).
The alias itself is stored as intersection data.
It has the following fields:

=over 4


=item alias

alias for the compound assigned by the source



=back

=back

=cut

sub get_relationship_HasCompoundAliasFrom
{
    my $self = shift;
    my($ids, $from_fields, $rel_fields, $to_fields) = @_;

    my @_bad_arguments;
    (ref($ids) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"ids\" (value was \"$ids\")");
    (ref($from_fields) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"from_fields\" (value was \"$from_fields\")");
    (ref($rel_fields) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"rel_fields\" (value was \"$rel_fields\")");
    (ref($to_fields) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"to_fields\" (value was \"$to_fields\")");
    if (@_bad_arguments) {
	my $msg = "Invalid arguments passed to get_relationship_HasCompoundAliasFrom:\n" . join("", map { "\t$_\n" } @_bad_arguments);
	Bio::KBase::Exceptions::ArgumentValidationError->throw(error => $msg,
							       method_name => 'get_relationship_HasCompoundAliasFrom');
    }

    my $ctx = $Bio::KBase::CDMI::Service::CallContext;
    my($return);
    #BEGIN get_relationship_HasCompoundAliasFrom

    $return = $self->_get_relationship($ctx, 'HasCompoundAliasFrom', 'HasCompoundAliasFrom', 0, $ids, $from_fields, $rel_fields, $to_fields);
	
    #END get_relationship_HasCompoundAliasFrom
    my @_bad_returns;
    (ref($return) eq 'ARRAY') or push(@_bad_returns, "Invalid type for return variable \"return\" (value was \"$return\")");
    if (@_bad_returns) {
	my $msg = "Invalid returns passed to get_relationship_HasCompoundAliasFrom:\n" . join("", map { "\t$_\n" } @_bad_returns);
	Bio::KBase::Exceptions::ArgumentValidationError->throw(error => $msg,
							       method_name => 'get_relationship_HasCompoundAliasFrom');
    }
    return($return);
}




=head2 get_relationship_UsesAliasForCompound

  $return = $obj->get_relationship_UsesAliasForCompound($ids, $from_fields, $rel_fields, $to_fields)

=over 4

=item Parameter and return types

=begin html

<pre>
$ids is a reference to a list where each element is a string
$from_fields is a reference to a list where each element is a string
$rel_fields is a reference to a list where each element is a string
$to_fields is a reference to a list where each element is a string
$return is a reference to a list where each element is a reference to a list containing 3 items:
	0: a fields_Compound
	1: a fields_HasCompoundAliasFrom
	2: a fields_Source
fields_Compound is a reference to a hash where the following keys are defined:
	id has a value which is a string
	label has a value which is a string
	abbr has a value which is a string
	msid has a value which is a string
	ubiquitous has a value which is an int
	mod_date has a value which is a string
	uncharged_formula has a value which is a string
	formula has a value which is a string
	mass has a value which is a float
fields_HasCompoundAliasFrom is a reference to a hash where the following keys are defined:
	id has a value which is a string
	alias has a value which is a string
fields_Source is a reference to a hash where the following keys are defined:
	id has a value which is a string

</pre>

=end html

=begin text

$ids is a reference to a list where each element is a string
$from_fields is a reference to a list where each element is a string
$rel_fields is a reference to a list where each element is a string
$to_fields is a reference to a list where each element is a string
$return is a reference to a list where each element is a reference to a list containing 3 items:
	0: a fields_Compound
	1: a fields_HasCompoundAliasFrom
	2: a fields_Source
fields_Compound is a reference to a hash where the following keys are defined:
	id has a value which is a string
	label has a value which is a string
	abbr has a value which is a string
	msid has a value which is a string
	ubiquitous has a value which is an int
	mod_date has a value which is a string
	uncharged_formula has a value which is a string
	formula has a value which is a string
	mass has a value which is a float
fields_HasCompoundAliasFrom is a reference to a hash where the following keys are defined:
	id has a value which is a string
	alias has a value which is a string
fields_Source is a reference to a hash where the following keys are defined:
	id has a value which is a string


=end text



=item Description



=back

=cut

sub get_relationship_UsesAliasForCompound
{
    my $self = shift;
    my($ids, $from_fields, $rel_fields, $to_fields) = @_;

    my @_bad_arguments;
    (ref($ids) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"ids\" (value was \"$ids\")");
    (ref($from_fields) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"from_fields\" (value was \"$from_fields\")");
    (ref($rel_fields) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"rel_fields\" (value was \"$rel_fields\")");
    (ref($to_fields) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"to_fields\" (value was \"$to_fields\")");
    if (@_bad_arguments) {
	my $msg = "Invalid arguments passed to get_relationship_UsesAliasForCompound:\n" . join("", map { "\t$_\n" } @_bad_arguments);
	Bio::KBase::Exceptions::ArgumentValidationError->throw(error => $msg,
							       method_name => 'get_relationship_UsesAliasForCompound');
    }

    my $ctx = $Bio::KBase::CDMI::Service::CallContext;
    my($return);
    #BEGIN get_relationship_UsesAliasForCompound

    $return = $self->_get_relationship($ctx, 'UsesAliasForCompound', 'HasCompoundAliasFrom', 1, $ids, $from_fields, $rel_fields, $to_fields);
	
    #END get_relationship_UsesAliasForCompound
    my @_bad_returns;
    (ref($return) eq 'ARRAY') or push(@_bad_returns, "Invalid type for return variable \"return\" (value was \"$return\")");
    if (@_bad_returns) {
	my $msg = "Invalid returns passed to get_relationship_UsesAliasForCompound:\n" . join("", map { "\t$_\n" } @_bad_returns);
	Bio::KBase::Exceptions::ArgumentValidationError->throw(error => $msg,
							       method_name => 'get_relationship_UsesAliasForCompound');
    }
    return($return);
}




=head2 get_relationship_HasIndicatedSignalFrom

  $return = $obj->get_relationship_HasIndicatedSignalFrom($ids, $from_fields, $rel_fields, $to_fields)

=over 4

=item Parameter and return types

=begin html

<pre>
$ids is a reference to a list where each element is a string
$from_fields is a reference to a list where each element is a string
$rel_fields is a reference to a list where each element is a string
$to_fields is a reference to a list where each element is a string
$return is a reference to a list where each element is a reference to a list containing 3 items:
	0: a fields_Feature
	1: a fields_HasIndicatedSignalFrom
	2: a fields_Experiment
fields_Feature is a reference to a hash where the following keys are defined:
	id has a value which is a string
	feature_type has a value which is a string
	source_id has a value which is a string
	sequence_length has a value which is an int
	function has a value which is a string
	alias has a value which is a reference to a list where each element is a string
fields_HasIndicatedSignalFrom is a reference to a hash where the following keys are defined:
	id has a value which is a string
	rma_value has a value which is a float
	level has a value which is an int
fields_Experiment is a reference to a hash where the following keys are defined:
	id has a value which is a string
	source has a value which is a string

</pre>

=end html

=begin text

$ids is a reference to a list where each element is a string
$from_fields is a reference to a list where each element is a string
$rel_fields is a reference to a list where each element is a string
$to_fields is a reference to a list where each element is a string
$return is a reference to a list where each element is a reference to a list containing 3 items:
	0: a fields_Feature
	1: a fields_HasIndicatedSignalFrom
	2: a fields_Experiment
fields_Feature is a reference to a hash where the following keys are defined:
	id has a value which is a string
	feature_type has a value which is a string
	source_id has a value which is a string
	sequence_length has a value which is an int
	function has a value which is a string
	alias has a value which is a reference to a list where each element is a string
fields_HasIndicatedSignalFrom is a reference to a hash where the following keys are defined:
	id has a value which is a string
	rma_value has a value which is a float
	level has a value which is an int
fields_Experiment is a reference to a hash where the following keys are defined:
	id has a value which is a string
	source has a value which is a string


=end text



=item Description

This relationship connects an experiment to a feature. The feature
expression levels inferred from the experimental results are stored here.
It has the following fields:

=over 4


=item rma_value

Normalized expression value for this feature under the experiment's
conditions.


=item level

Indication of whether the feature is expressed (1), not expressed (-1),
or unknown (0).



=back

=back

=cut

sub get_relationship_HasIndicatedSignalFrom
{
    my $self = shift;
    my($ids, $from_fields, $rel_fields, $to_fields) = @_;

    my @_bad_arguments;
    (ref($ids) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"ids\" (value was \"$ids\")");
    (ref($from_fields) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"from_fields\" (value was \"$from_fields\")");
    (ref($rel_fields) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"rel_fields\" (value was \"$rel_fields\")");
    (ref($to_fields) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"to_fields\" (value was \"$to_fields\")");
    if (@_bad_arguments) {
	my $msg = "Invalid arguments passed to get_relationship_HasIndicatedSignalFrom:\n" . join("", map { "\t$_\n" } @_bad_arguments);
	Bio::KBase::Exceptions::ArgumentValidationError->throw(error => $msg,
							       method_name => 'get_relationship_HasIndicatedSignalFrom');
    }

    my $ctx = $Bio::KBase::CDMI::Service::CallContext;
    my($return);
    #BEGIN get_relationship_HasIndicatedSignalFrom

    $return = $self->_get_relationship($ctx, 'HasIndicatedSignalFrom', 'HasIndicatedSignalFrom', 0, $ids, $from_fields, $rel_fields, $to_fields);
	
    #END get_relationship_HasIndicatedSignalFrom
    my @_bad_returns;
    (ref($return) eq 'ARRAY') or push(@_bad_returns, "Invalid type for return variable \"return\" (value was \"$return\")");
    if (@_bad_returns) {
	my $msg = "Invalid returns passed to get_relationship_HasIndicatedSignalFrom:\n" . join("", map { "\t$_\n" } @_bad_returns);
	Bio::KBase::Exceptions::ArgumentValidationError->throw(error => $msg,
							       method_name => 'get_relationship_HasIndicatedSignalFrom');
    }
    return($return);
}




=head2 get_relationship_IndicatesSignalFor

  $return = $obj->get_relationship_IndicatesSignalFor($ids, $from_fields, $rel_fields, $to_fields)

=over 4

=item Parameter and return types

=begin html

<pre>
$ids is a reference to a list where each element is a string
$from_fields is a reference to a list where each element is a string
$rel_fields is a reference to a list where each element is a string
$to_fields is a reference to a list where each element is a string
$return is a reference to a list where each element is a reference to a list containing 3 items:
	0: a fields_Experiment
	1: a fields_HasIndicatedSignalFrom
	2: a fields_Feature
fields_Experiment is a reference to a hash where the following keys are defined:
	id has a value which is a string
	source has a value which is a string
fields_HasIndicatedSignalFrom is a reference to a hash where the following keys are defined:
	id has a value which is a string
	rma_value has a value which is a float
	level has a value which is an int
fields_Feature is a reference to a hash where the following keys are defined:
	id has a value which is a string
	feature_type has a value which is a string
	source_id has a value which is a string
	sequence_length has a value which is an int
	function has a value which is a string
	alias has a value which is a reference to a list where each element is a string

</pre>

=end html

=begin text

$ids is a reference to a list where each element is a string
$from_fields is a reference to a list where each element is a string
$rel_fields is a reference to a list where each element is a string
$to_fields is a reference to a list where each element is a string
$return is a reference to a list where each element is a reference to a list containing 3 items:
	0: a fields_Experiment
	1: a fields_HasIndicatedSignalFrom
	2: a fields_Feature
fields_Experiment is a reference to a hash where the following keys are defined:
	id has a value which is a string
	source has a value which is a string
fields_HasIndicatedSignalFrom is a reference to a hash where the following keys are defined:
	id has a value which is a string
	rma_value has a value which is a float
	level has a value which is an int
fields_Feature is a reference to a hash where the following keys are defined:
	id has a value which is a string
	feature_type has a value which is a string
	source_id has a value which is a string
	sequence_length has a value which is an int
	function has a value which is a string
	alias has a value which is a reference to a list where each element is a string


=end text



=item Description



=back

=cut

sub get_relationship_IndicatesSignalFor
{
    my $self = shift;
    my($ids, $from_fields, $rel_fields, $to_fields) = @_;

    my @_bad_arguments;
    (ref($ids) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"ids\" (value was \"$ids\")");
    (ref($from_fields) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"from_fields\" (value was \"$from_fields\")");
    (ref($rel_fields) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"rel_fields\" (value was \"$rel_fields\")");
    (ref($to_fields) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"to_fields\" (value was \"$to_fields\")");
    if (@_bad_arguments) {
	my $msg = "Invalid arguments passed to get_relationship_IndicatesSignalFor:\n" . join("", map { "\t$_\n" } @_bad_arguments);
	Bio::KBase::Exceptions::ArgumentValidationError->throw(error => $msg,
							       method_name => 'get_relationship_IndicatesSignalFor');
    }

    my $ctx = $Bio::KBase::CDMI::Service::CallContext;
    my($return);
    #BEGIN get_relationship_IndicatesSignalFor

    $return = $self->_get_relationship($ctx, 'IndicatesSignalFor', 'HasIndicatedSignalFrom', 1, $ids, $from_fields, $rel_fields, $to_fields);
	
    #END get_relationship_IndicatesSignalFor
    my @_bad_returns;
    (ref($return) eq 'ARRAY') or push(@_bad_returns, "Invalid type for return variable \"return\" (value was \"$return\")");
    if (@_bad_returns) {
	my $msg = "Invalid returns passed to get_relationship_IndicatesSignalFor:\n" . join("", map { "\t$_\n" } @_bad_returns);
	Bio::KBase::Exceptions::ArgumentValidationError->throw(error => $msg,
							       method_name => 'get_relationship_IndicatesSignalFor');
    }
    return($return);
}




=head2 get_relationship_HasMember

  $return = $obj->get_relationship_HasMember($ids, $from_fields, $rel_fields, $to_fields)

=over 4

=item Parameter and return types

=begin html

<pre>
$ids is a reference to a list where each element is a string
$from_fields is a reference to a list where each element is a string
$rel_fields is a reference to a list where each element is a string
$to_fields is a reference to a list where each element is a string
$return is a reference to a list where each element is a reference to a list containing 3 items:
	0: a fields_Family
	1: a fields_HasMember
	2: a fields_Feature
fields_Family is a reference to a hash where the following keys are defined:
	id has a value which is a string
	type has a value which is a string
	release has a value which is a string
	family_function has a value which is a reference to a list where each element is a string
	alignment has a value which is a reference to a list where each element is a string
fields_HasMember is a reference to a hash where the following keys are defined:
	id has a value which is a string
fields_Feature is a reference to a hash where the following keys are defined:
	id has a value which is a string
	feature_type has a value which is a string
	source_id has a value which is a string
	sequence_length has a value which is an int
	function has a value which is a string
	alias has a value which is a reference to a list where each element is a string

</pre>

=end html

=begin text

$ids is a reference to a list where each element is a string
$from_fields is a reference to a list where each element is a string
$rel_fields is a reference to a list where each element is a string
$to_fields is a reference to a list where each element is a string
$return is a reference to a list where each element is a reference to a list containing 3 items:
	0: a fields_Family
	1: a fields_HasMember
	2: a fields_Feature
fields_Family is a reference to a hash where the following keys are defined:
	id has a value which is a string
	type has a value which is a string
	release has a value which is a string
	family_function has a value which is a reference to a list where each element is a string
	alignment has a value which is a reference to a list where each element is a string
fields_HasMember is a reference to a hash where the following keys are defined:
	id has a value which is a string
fields_Feature is a reference to a hash where the following keys are defined:
	id has a value which is a string
	feature_type has a value which is a string
	source_id has a value which is a string
	sequence_length has a value which is an int
	function has a value which is a string
	alias has a value which is a reference to a list where each element is a string


=end text



=item Description

This relationship connects each feature family to its
constituent features. A family always has many features, and a
single feature can be found in many families.
It has the following fields:

=over 4



=back

=back

=cut

sub get_relationship_HasMember
{
    my $self = shift;
    my($ids, $from_fields, $rel_fields, $to_fields) = @_;

    my @_bad_arguments;
    (ref($ids) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"ids\" (value was \"$ids\")");
    (ref($from_fields) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"from_fields\" (value was \"$from_fields\")");
    (ref($rel_fields) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"rel_fields\" (value was \"$rel_fields\")");
    (ref($to_fields) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"to_fields\" (value was \"$to_fields\")");
    if (@_bad_arguments) {
	my $msg = "Invalid arguments passed to get_relationship_HasMember:\n" . join("", map { "\t$_\n" } @_bad_arguments);
	Bio::KBase::Exceptions::ArgumentValidationError->throw(error => $msg,
							       method_name => 'get_relationship_HasMember');
    }

    my $ctx = $Bio::KBase::CDMI::Service::CallContext;
    my($return);
    #BEGIN get_relationship_HasMember

    $return = $self->_get_relationship($ctx, 'HasMember', 'HasMember', 0, $ids, $from_fields, $rel_fields, $to_fields);
	
    #END get_relationship_HasMember
    my @_bad_returns;
    (ref($return) eq 'ARRAY') or push(@_bad_returns, "Invalid type for return variable \"return\" (value was \"$return\")");
    if (@_bad_returns) {
	my $msg = "Invalid returns passed to get_relationship_HasMember:\n" . join("", map { "\t$_\n" } @_bad_returns);
	Bio::KBase::Exceptions::ArgumentValidationError->throw(error => $msg,
							       method_name => 'get_relationship_HasMember');
    }
    return($return);
}




=head2 get_relationship_IsMemberOf

  $return = $obj->get_relationship_IsMemberOf($ids, $from_fields, $rel_fields, $to_fields)

=over 4

=item Parameter and return types

=begin html

<pre>
$ids is a reference to a list where each element is a string
$from_fields is a reference to a list where each element is a string
$rel_fields is a reference to a list where each element is a string
$to_fields is a reference to a list where each element is a string
$return is a reference to a list where each element is a reference to a list containing 3 items:
	0: a fields_Feature
	1: a fields_HasMember
	2: a fields_Family
fields_Feature is a reference to a hash where the following keys are defined:
	id has a value which is a string
	feature_type has a value which is a string
	source_id has a value which is a string
	sequence_length has a value which is an int
	function has a value which is a string
	alias has a value which is a reference to a list where each element is a string
fields_HasMember is a reference to a hash where the following keys are defined:
	id has a value which is a string
fields_Family is a reference to a hash where the following keys are defined:
	id has a value which is a string
	type has a value which is a string
	release has a value which is a string
	family_function has a value which is a reference to a list where each element is a string
	alignment has a value which is a reference to a list where each element is a string

</pre>

=end html

=begin text

$ids is a reference to a list where each element is a string
$from_fields is a reference to a list where each element is a string
$rel_fields is a reference to a list where each element is a string
$to_fields is a reference to a list where each element is a string
$return is a reference to a list where each element is a reference to a list containing 3 items:
	0: a fields_Feature
	1: a fields_HasMember
	2: a fields_Family
fields_Feature is a reference to a hash where the following keys are defined:
	id has a value which is a string
	feature_type has a value which is a string
	source_id has a value which is a string
	sequence_length has a value which is an int
	function has a value which is a string
	alias has a value which is a reference to a list where each element is a string
fields_HasMember is a reference to a hash where the following keys are defined:
	id has a value which is a string
fields_Family is a reference to a hash where the following keys are defined:
	id has a value which is a string
	type has a value which is a string
	release has a value which is a string
	family_function has a value which is a reference to a list where each element is a string
	alignment has a value which is a reference to a list where each element is a string


=end text



=item Description



=back

=cut

sub get_relationship_IsMemberOf
{
    my $self = shift;
    my($ids, $from_fields, $rel_fields, $to_fields) = @_;

    my @_bad_arguments;
    (ref($ids) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"ids\" (value was \"$ids\")");
    (ref($from_fields) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"from_fields\" (value was \"$from_fields\")");
    (ref($rel_fields) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"rel_fields\" (value was \"$rel_fields\")");
    (ref($to_fields) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"to_fields\" (value was \"$to_fields\")");
    if (@_bad_arguments) {
	my $msg = "Invalid arguments passed to get_relationship_IsMemberOf:\n" . join("", map { "\t$_\n" } @_bad_arguments);
	Bio::KBase::Exceptions::ArgumentValidationError->throw(error => $msg,
							       method_name => 'get_relationship_IsMemberOf');
    }

    my $ctx = $Bio::KBase::CDMI::Service::CallContext;
    my($return);
    #BEGIN get_relationship_IsMemberOf

    $return = $self->_get_relationship($ctx, 'IsMemberOf', 'HasMember', 1, $ids, $from_fields, $rel_fields, $to_fields);
	
    #END get_relationship_IsMemberOf
    my @_bad_returns;
    (ref($return) eq 'ARRAY') or push(@_bad_returns, "Invalid type for return variable \"return\" (value was \"$return\")");
    if (@_bad_returns) {
	my $msg = "Invalid returns passed to get_relationship_IsMemberOf:\n" . join("", map { "\t$_\n" } @_bad_returns);
	Bio::KBase::Exceptions::ArgumentValidationError->throw(error => $msg,
							       method_name => 'get_relationship_IsMemberOf');
    }
    return($return);
}




=head2 get_relationship_HasParticipant

  $return = $obj->get_relationship_HasParticipant($ids, $from_fields, $rel_fields, $to_fields)

=over 4

=item Parameter and return types

=begin html

<pre>
$ids is a reference to a list where each element is a string
$from_fields is a reference to a list where each element is a string
$rel_fields is a reference to a list where each element is a string
$to_fields is a reference to a list where each element is a string
$return is a reference to a list where each element is a reference to a list containing 3 items:
	0: a fields_Scenario
	1: a fields_HasParticipant
	2: a fields_Reaction
fields_Scenario is a reference to a hash where the following keys are defined:
	id has a value which is a string
	common_name has a value which is a string
fields_HasParticipant is a reference to a hash where the following keys are defined:
	id has a value which is a string
	type has a value which is an int
fields_Reaction is a reference to a hash where the following keys are defined:
	id has a value which is a string
	mod_date has a value which is a string
	name has a value which is a string
	msid has a value which is a string
	abbr has a value which is a string
	equation has a value which is a string
	reversibility has a value which is a string

</pre>

=end html

=begin text

$ids is a reference to a list where each element is a string
$from_fields is a reference to a list where each element is a string
$rel_fields is a reference to a list where each element is a string
$to_fields is a reference to a list where each element is a string
$return is a reference to a list where each element is a reference to a list containing 3 items:
	0: a fields_Scenario
	1: a fields_HasParticipant
	2: a fields_Reaction
fields_Scenario is a reference to a hash where the following keys are defined:
	id has a value which is a string
	common_name has a value which is a string
fields_HasParticipant is a reference to a hash where the following keys are defined:
	id has a value which is a string
	type has a value which is an int
fields_Reaction is a reference to a hash where the following keys are defined:
	id has a value which is a string
	mod_date has a value which is a string
	name has a value which is a string
	msid has a value which is a string
	abbr has a value which is a string
	equation has a value which is a string
	reversibility has a value which is a string


=end text



=item Description

A scenario consists of many participant reactions that
convert the input compounds to output compounds. A single reaction
may participate in many scenarios.
It has the following fields:

=over 4


=item type

Indicates the type of participaton. If 0, the
reaction is in the main pathway of the scenario. If 1, the
reaction is necessary to make the model work but is not in
the subsystem. If 2, the reaction is part of the subsystem
but should not be included in the modelling process.



=back

=back

=cut

sub get_relationship_HasParticipant
{
    my $self = shift;
    my($ids, $from_fields, $rel_fields, $to_fields) = @_;

    my @_bad_arguments;
    (ref($ids) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"ids\" (value was \"$ids\")");
    (ref($from_fields) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"from_fields\" (value was \"$from_fields\")");
    (ref($rel_fields) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"rel_fields\" (value was \"$rel_fields\")");
    (ref($to_fields) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"to_fields\" (value was \"$to_fields\")");
    if (@_bad_arguments) {
	my $msg = "Invalid arguments passed to get_relationship_HasParticipant:\n" . join("", map { "\t$_\n" } @_bad_arguments);
	Bio::KBase::Exceptions::ArgumentValidationError->throw(error => $msg,
							       method_name => 'get_relationship_HasParticipant');
    }

    my $ctx = $Bio::KBase::CDMI::Service::CallContext;
    my($return);
    #BEGIN get_relationship_HasParticipant

    $return = $self->_get_relationship($ctx, 'HasParticipant', 'HasParticipant', 0, $ids, $from_fields, $rel_fields, $to_fields);
	
    #END get_relationship_HasParticipant
    my @_bad_returns;
    (ref($return) eq 'ARRAY') or push(@_bad_returns, "Invalid type for return variable \"return\" (value was \"$return\")");
    if (@_bad_returns) {
	my $msg = "Invalid returns passed to get_relationship_HasParticipant:\n" . join("", map { "\t$_\n" } @_bad_returns);
	Bio::KBase::Exceptions::ArgumentValidationError->throw(error => $msg,
							       method_name => 'get_relationship_HasParticipant');
    }
    return($return);
}




=head2 get_relationship_ParticipatesIn

  $return = $obj->get_relationship_ParticipatesIn($ids, $from_fields, $rel_fields, $to_fields)

=over 4

=item Parameter and return types

=begin html

<pre>
$ids is a reference to a list where each element is a string
$from_fields is a reference to a list where each element is a string
$rel_fields is a reference to a list where each element is a string
$to_fields is a reference to a list where each element is a string
$return is a reference to a list where each element is a reference to a list containing 3 items:
	0: a fields_Reaction
	1: a fields_HasParticipant
	2: a fields_Scenario
fields_Reaction is a reference to a hash where the following keys are defined:
	id has a value which is a string
	mod_date has a value which is a string
	name has a value which is a string
	msid has a value which is a string
	abbr has a value which is a string
	equation has a value which is a string
	reversibility has a value which is a string
fields_HasParticipant is a reference to a hash where the following keys are defined:
	id has a value which is a string
	type has a value which is an int
fields_Scenario is a reference to a hash where the following keys are defined:
	id has a value which is a string
	common_name has a value which is a string

</pre>

=end html

=begin text

$ids is a reference to a list where each element is a string
$from_fields is a reference to a list where each element is a string
$rel_fields is a reference to a list where each element is a string
$to_fields is a reference to a list where each element is a string
$return is a reference to a list where each element is a reference to a list containing 3 items:
	0: a fields_Reaction
	1: a fields_HasParticipant
	2: a fields_Scenario
fields_Reaction is a reference to a hash where the following keys are defined:
	id has a value which is a string
	mod_date has a value which is a string
	name has a value which is a string
	msid has a value which is a string
	abbr has a value which is a string
	equation has a value which is a string
	reversibility has a value which is a string
fields_HasParticipant is a reference to a hash where the following keys are defined:
	id has a value which is a string
	type has a value which is an int
fields_Scenario is a reference to a hash where the following keys are defined:
	id has a value which is a string
	common_name has a value which is a string


=end text



=item Description



=back

=cut

sub get_relationship_ParticipatesIn
{
    my $self = shift;
    my($ids, $from_fields, $rel_fields, $to_fields) = @_;

    my @_bad_arguments;
    (ref($ids) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"ids\" (value was \"$ids\")");
    (ref($from_fields) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"from_fields\" (value was \"$from_fields\")");
    (ref($rel_fields) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"rel_fields\" (value was \"$rel_fields\")");
    (ref($to_fields) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"to_fields\" (value was \"$to_fields\")");
    if (@_bad_arguments) {
	my $msg = "Invalid arguments passed to get_relationship_ParticipatesIn:\n" . join("", map { "\t$_\n" } @_bad_arguments);
	Bio::KBase::Exceptions::ArgumentValidationError->throw(error => $msg,
							       method_name => 'get_relationship_ParticipatesIn');
    }

    my $ctx = $Bio::KBase::CDMI::Service::CallContext;
    my($return);
    #BEGIN get_relationship_ParticipatesIn

    $return = $self->_get_relationship($ctx, 'ParticipatesIn', 'HasParticipant', 1, $ids, $from_fields, $rel_fields, $to_fields);
	
    #END get_relationship_ParticipatesIn
    my @_bad_returns;
    (ref($return) eq 'ARRAY') or push(@_bad_returns, "Invalid type for return variable \"return\" (value was \"$return\")");
    if (@_bad_returns) {
	my $msg = "Invalid returns passed to get_relationship_ParticipatesIn:\n" . join("", map { "\t$_\n" } @_bad_returns);
	Bio::KBase::Exceptions::ArgumentValidationError->throw(error => $msg,
							       method_name => 'get_relationship_ParticipatesIn');
    }
    return($return);
}




=head2 get_relationship_HasPresenceOf

  $return = $obj->get_relationship_HasPresenceOf($ids, $from_fields, $rel_fields, $to_fields)

=over 4

=item Parameter and return types

=begin html

<pre>
$ids is a reference to a list where each element is a string
$from_fields is a reference to a list where each element is a string
$rel_fields is a reference to a list where each element is a string
$to_fields is a reference to a list where each element is a string
$return is a reference to a list where each element is a reference to a list containing 3 items:
	0: a fields_Media
	1: a fields_HasPresenceOf
	2: a fields_Compound
fields_Media is a reference to a hash where the following keys are defined:
	id has a value which is a string
	mod_date has a value which is a string
	name has a value which is a string
	type has a value which is a string
fields_HasPresenceOf is a reference to a hash where the following keys are defined:
	id has a value which is a string
	concentration has a value which is a float
	minimum_flux has a value which is a float
	maximum_flux has a value which is a float
fields_Compound is a reference to a hash where the following keys are defined:
	id has a value which is a string
	label has a value which is a string
	abbr has a value which is a string
	msid has a value which is a string
	ubiquitous has a value which is an int
	mod_date has a value which is a string
	uncharged_formula has a value which is a string
	formula has a value which is a string
	mass has a value which is a float

</pre>

=end html

=begin text

$ids is a reference to a list where each element is a string
$from_fields is a reference to a list where each element is a string
$rel_fields is a reference to a list where each element is a string
$to_fields is a reference to a list where each element is a string
$return is a reference to a list where each element is a reference to a list containing 3 items:
	0: a fields_Media
	1: a fields_HasPresenceOf
	2: a fields_Compound
fields_Media is a reference to a hash where the following keys are defined:
	id has a value which is a string
	mod_date has a value which is a string
	name has a value which is a string
	type has a value which is a string
fields_HasPresenceOf is a reference to a hash where the following keys are defined:
	id has a value which is a string
	concentration has a value which is a float
	minimum_flux has a value which is a float
	maximum_flux has a value which is a float
fields_Compound is a reference to a hash where the following keys are defined:
	id has a value which is a string
	label has a value which is a string
	abbr has a value which is a string
	msid has a value which is a string
	ubiquitous has a value which is an int
	mod_date has a value which is a string
	uncharged_formula has a value which is a string
	formula has a value which is a string
	mass has a value which is a float


=end text



=item Description

This relationship connects a media to the compounds that
occur in it. The intersection data describes how much of each
compound can be found.
It has the following fields:

=over 4


=item concentration

concentration of the compound in the media


=item minimum_flux

minimum flux of the compound for this media


=item maximum_flux

maximum flux of the compound for this media



=back

=back

=cut

sub get_relationship_HasPresenceOf
{
    my $self = shift;
    my($ids, $from_fields, $rel_fields, $to_fields) = @_;

    my @_bad_arguments;
    (ref($ids) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"ids\" (value was \"$ids\")");
    (ref($from_fields) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"from_fields\" (value was \"$from_fields\")");
    (ref($rel_fields) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"rel_fields\" (value was \"$rel_fields\")");
    (ref($to_fields) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"to_fields\" (value was \"$to_fields\")");
    if (@_bad_arguments) {
	my $msg = "Invalid arguments passed to get_relationship_HasPresenceOf:\n" . join("", map { "\t$_\n" } @_bad_arguments);
	Bio::KBase::Exceptions::ArgumentValidationError->throw(error => $msg,
							       method_name => 'get_relationship_HasPresenceOf');
    }

    my $ctx = $Bio::KBase::CDMI::Service::CallContext;
    my($return);
    #BEGIN get_relationship_HasPresenceOf

    $return = $self->_get_relationship($ctx, 'HasPresenceOf', 'HasPresenceOf', 0, $ids, $from_fields, $rel_fields, $to_fields);
	
    #END get_relationship_HasPresenceOf
    my @_bad_returns;
    (ref($return) eq 'ARRAY') or push(@_bad_returns, "Invalid type for return variable \"return\" (value was \"$return\")");
    if (@_bad_returns) {
	my $msg = "Invalid returns passed to get_relationship_HasPresenceOf:\n" . join("", map { "\t$_\n" } @_bad_returns);
	Bio::KBase::Exceptions::ArgumentValidationError->throw(error => $msg,
							       method_name => 'get_relationship_HasPresenceOf');
    }
    return($return);
}




=head2 get_relationship_IsPresentIn

  $return = $obj->get_relationship_IsPresentIn($ids, $from_fields, $rel_fields, $to_fields)

=over 4

=item Parameter and return types

=begin html

<pre>
$ids is a reference to a list where each element is a string
$from_fields is a reference to a list where each element is a string
$rel_fields is a reference to a list where each element is a string
$to_fields is a reference to a list where each element is a string
$return is a reference to a list where each element is a reference to a list containing 3 items:
	0: a fields_Compound
	1: a fields_HasPresenceOf
	2: a fields_Media
fields_Compound is a reference to a hash where the following keys are defined:
	id has a value which is a string
	label has a value which is a string
	abbr has a value which is a string
	msid has a value which is a string
	ubiquitous has a value which is an int
	mod_date has a value which is a string
	uncharged_formula has a value which is a string
	formula has a value which is a string
	mass has a value which is a float
fields_HasPresenceOf is a reference to a hash where the following keys are defined:
	id has a value which is a string
	concentration has a value which is a float
	minimum_flux has a value which is a float
	maximum_flux has a value which is a float
fields_Media is a reference to a hash where the following keys are defined:
	id has a value which is a string
	mod_date has a value which is a string
	name has a value which is a string
	type has a value which is a string

</pre>

=end html

=begin text

$ids is a reference to a list where each element is a string
$from_fields is a reference to a list where each element is a string
$rel_fields is a reference to a list where each element is a string
$to_fields is a reference to a list where each element is a string
$return is a reference to a list where each element is a reference to a list containing 3 items:
	0: a fields_Compound
	1: a fields_HasPresenceOf
	2: a fields_Media
fields_Compound is a reference to a hash where the following keys are defined:
	id has a value which is a string
	label has a value which is a string
	abbr has a value which is a string
	msid has a value which is a string
	ubiquitous has a value which is an int
	mod_date has a value which is a string
	uncharged_formula has a value which is a string
	formula has a value which is a string
	mass has a value which is a float
fields_HasPresenceOf is a reference to a hash where the following keys are defined:
	id has a value which is a string
	concentration has a value which is a float
	minimum_flux has a value which is a float
	maximum_flux has a value which is a float
fields_Media is a reference to a hash where the following keys are defined:
	id has a value which is a string
	mod_date has a value which is a string
	name has a value which is a string
	type has a value which is a string


=end text



=item Description



=back

=cut

sub get_relationship_IsPresentIn
{
    my $self = shift;
    my($ids, $from_fields, $rel_fields, $to_fields) = @_;

    my @_bad_arguments;
    (ref($ids) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"ids\" (value was \"$ids\")");
    (ref($from_fields) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"from_fields\" (value was \"$from_fields\")");
    (ref($rel_fields) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"rel_fields\" (value was \"$rel_fields\")");
    (ref($to_fields) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"to_fields\" (value was \"$to_fields\")");
    if (@_bad_arguments) {
	my $msg = "Invalid arguments passed to get_relationship_IsPresentIn:\n" . join("", map { "\t$_\n" } @_bad_arguments);
	Bio::KBase::Exceptions::ArgumentValidationError->throw(error => $msg,
							       method_name => 'get_relationship_IsPresentIn');
    }

    my $ctx = $Bio::KBase::CDMI::Service::CallContext;
    my($return);
    #BEGIN get_relationship_IsPresentIn

    $return = $self->_get_relationship($ctx, 'IsPresentIn', 'HasPresenceOf', 1, $ids, $from_fields, $rel_fields, $to_fields);
	
    #END get_relationship_IsPresentIn
    my @_bad_returns;
    (ref($return) eq 'ARRAY') or push(@_bad_returns, "Invalid type for return variable \"return\" (value was \"$return\")");
    if (@_bad_returns) {
	my $msg = "Invalid returns passed to get_relationship_IsPresentIn:\n" . join("", map { "\t$_\n" } @_bad_returns);
	Bio::KBase::Exceptions::ArgumentValidationError->throw(error => $msg,
							       method_name => 'get_relationship_IsPresentIn');
    }
    return($return);
}




=head2 get_relationship_HasProteinMember

  $return = $obj->get_relationship_HasProteinMember($ids, $from_fields, $rel_fields, $to_fields)

=over 4

=item Parameter and return types

=begin html

<pre>
$ids is a reference to a list where each element is a string
$from_fields is a reference to a list where each element is a string
$rel_fields is a reference to a list where each element is a string
$to_fields is a reference to a list where each element is a string
$return is a reference to a list where each element is a reference to a list containing 3 items:
	0: a fields_Family
	1: a fields_HasProteinMember
	2: a fields_ProteinSequence
fields_Family is a reference to a hash where the following keys are defined:
	id has a value which is a string
	type has a value which is a string
	release has a value which is a string
	family_function has a value which is a reference to a list where each element is a string
	alignment has a value which is a reference to a list where each element is a string
fields_HasProteinMember is a reference to a hash where the following keys are defined:
	id has a value which is a string
	source_id has a value which is a string
fields_ProteinSequence is a reference to a hash where the following keys are defined:
	id has a value which is a string
	sequence has a value which is a string

</pre>

=end html

=begin text

$ids is a reference to a list where each element is a string
$from_fields is a reference to a list where each element is a string
$rel_fields is a reference to a list where each element is a string
$to_fields is a reference to a list where each element is a string
$return is a reference to a list where each element is a reference to a list containing 3 items:
	0: a fields_Family
	1: a fields_HasProteinMember
	2: a fields_ProteinSequence
fields_Family is a reference to a hash where the following keys are defined:
	id has a value which is a string
	type has a value which is a string
	release has a value which is a string
	family_function has a value which is a reference to a list where each element is a string
	alignment has a value which is a reference to a list where each element is a string
fields_HasProteinMember is a reference to a hash where the following keys are defined:
	id has a value which is a string
	source_id has a value which is a string
fields_ProteinSequence is a reference to a hash where the following keys are defined:
	id has a value which is a string
	sequence has a value which is a string


=end text



=item Description

This relationship connects each feature family to its
constituent protein sequences. A family always has many protein sequences,
and a single sequence can be found in many families.
It has the following fields:

=over 4


=item source_id

Native identifier used for the protein in the definition
of the family. This will be its ID in the alignment, if one
exists.



=back

=back

=cut

sub get_relationship_HasProteinMember
{
    my $self = shift;
    my($ids, $from_fields, $rel_fields, $to_fields) = @_;

    my @_bad_arguments;
    (ref($ids) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"ids\" (value was \"$ids\")");
    (ref($from_fields) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"from_fields\" (value was \"$from_fields\")");
    (ref($rel_fields) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"rel_fields\" (value was \"$rel_fields\")");
    (ref($to_fields) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"to_fields\" (value was \"$to_fields\")");
    if (@_bad_arguments) {
	my $msg = "Invalid arguments passed to get_relationship_HasProteinMember:\n" . join("", map { "\t$_\n" } @_bad_arguments);
	Bio::KBase::Exceptions::ArgumentValidationError->throw(error => $msg,
							       method_name => 'get_relationship_HasProteinMember');
    }

    my $ctx = $Bio::KBase::CDMI::Service::CallContext;
    my($return);
    #BEGIN get_relationship_HasProteinMember

    $return = $self->_get_relationship($ctx, 'HasProteinMember', 'HasProteinMember', 0, $ids, $from_fields, $rel_fields, $to_fields);
	
    #END get_relationship_HasProteinMember
    my @_bad_returns;
    (ref($return) eq 'ARRAY') or push(@_bad_returns, "Invalid type for return variable \"return\" (value was \"$return\")");
    if (@_bad_returns) {
	my $msg = "Invalid returns passed to get_relationship_HasProteinMember:\n" . join("", map { "\t$_\n" } @_bad_returns);
	Bio::KBase::Exceptions::ArgumentValidationError->throw(error => $msg,
							       method_name => 'get_relationship_HasProteinMember');
    }
    return($return);
}




=head2 get_relationship_IsProteinMemberOf

  $return = $obj->get_relationship_IsProteinMemberOf($ids, $from_fields, $rel_fields, $to_fields)

=over 4

=item Parameter and return types

=begin html

<pre>
$ids is a reference to a list where each element is a string
$from_fields is a reference to a list where each element is a string
$rel_fields is a reference to a list where each element is a string
$to_fields is a reference to a list where each element is a string
$return is a reference to a list where each element is a reference to a list containing 3 items:
	0: a fields_ProteinSequence
	1: a fields_HasProteinMember
	2: a fields_Family
fields_ProteinSequence is a reference to a hash where the following keys are defined:
	id has a value which is a string
	sequence has a value which is a string
fields_HasProteinMember is a reference to a hash where the following keys are defined:
	id has a value which is a string
	source_id has a value which is a string
fields_Family is a reference to a hash where the following keys are defined:
	id has a value which is a string
	type has a value which is a string
	release has a value which is a string
	family_function has a value which is a reference to a list where each element is a string
	alignment has a value which is a reference to a list where each element is a string

</pre>

=end html

=begin text

$ids is a reference to a list where each element is a string
$from_fields is a reference to a list where each element is a string
$rel_fields is a reference to a list where each element is a string
$to_fields is a reference to a list where each element is a string
$return is a reference to a list where each element is a reference to a list containing 3 items:
	0: a fields_ProteinSequence
	1: a fields_HasProteinMember
	2: a fields_Family
fields_ProteinSequence is a reference to a hash where the following keys are defined:
	id has a value which is a string
	sequence has a value which is a string
fields_HasProteinMember is a reference to a hash where the following keys are defined:
	id has a value which is a string
	source_id has a value which is a string
fields_Family is a reference to a hash where the following keys are defined:
	id has a value which is a string
	type has a value which is a string
	release has a value which is a string
	family_function has a value which is a reference to a list where each element is a string
	alignment has a value which is a reference to a list where each element is a string


=end text



=item Description



=back

=cut

sub get_relationship_IsProteinMemberOf
{
    my $self = shift;
    my($ids, $from_fields, $rel_fields, $to_fields) = @_;

    my @_bad_arguments;
    (ref($ids) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"ids\" (value was \"$ids\")");
    (ref($from_fields) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"from_fields\" (value was \"$from_fields\")");
    (ref($rel_fields) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"rel_fields\" (value was \"$rel_fields\")");
    (ref($to_fields) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"to_fields\" (value was \"$to_fields\")");
    if (@_bad_arguments) {
	my $msg = "Invalid arguments passed to get_relationship_IsProteinMemberOf:\n" . join("", map { "\t$_\n" } @_bad_arguments);
	Bio::KBase::Exceptions::ArgumentValidationError->throw(error => $msg,
							       method_name => 'get_relationship_IsProteinMemberOf');
    }

    my $ctx = $Bio::KBase::CDMI::Service::CallContext;
    my($return);
    #BEGIN get_relationship_IsProteinMemberOf

    $return = $self->_get_relationship($ctx, 'IsProteinMemberOf', 'HasProteinMember', 1, $ids, $from_fields, $rel_fields, $to_fields);
	
    #END get_relationship_IsProteinMemberOf
    my @_bad_returns;
    (ref($return) eq 'ARRAY') or push(@_bad_returns, "Invalid type for return variable \"return\" (value was \"$return\")");
    if (@_bad_returns) {
	my $msg = "Invalid returns passed to get_relationship_IsProteinMemberOf:\n" . join("", map { "\t$_\n" } @_bad_returns);
	Bio::KBase::Exceptions::ArgumentValidationError->throw(error => $msg,
							       method_name => 'get_relationship_IsProteinMemberOf');
    }
    return($return);
}




=head2 get_relationship_HasReactionAliasFrom

  $return = $obj->get_relationship_HasReactionAliasFrom($ids, $from_fields, $rel_fields, $to_fields)

=over 4

=item Parameter and return types

=begin html

<pre>
$ids is a reference to a list where each element is a string
$from_fields is a reference to a list where each element is a string
$rel_fields is a reference to a list where each element is a string
$to_fields is a reference to a list where each element is a string
$return is a reference to a list where each element is a reference to a list containing 3 items:
	0: a fields_Source
	1: a fields_HasReactionAliasFrom
	2: a fields_Reaction
fields_Source is a reference to a hash where the following keys are defined:
	id has a value which is a string
fields_HasReactionAliasFrom is a reference to a hash where the following keys are defined:
	id has a value which is a string
	alias has a value which is a string
fields_Reaction is a reference to a hash where the following keys are defined:
	id has a value which is a string
	mod_date has a value which is a string
	name has a value which is a string
	msid has a value which is a string
	abbr has a value which is a string
	equation has a value which is a string
	reversibility has a value which is a string

</pre>

=end html

=begin text

$ids is a reference to a list where each element is a string
$from_fields is a reference to a list where each element is a string
$rel_fields is a reference to a list where each element is a string
$to_fields is a reference to a list where each element is a string
$return is a reference to a list where each element is a reference to a list containing 3 items:
	0: a fields_Source
	1: a fields_HasReactionAliasFrom
	2: a fields_Reaction
fields_Source is a reference to a hash where the following keys are defined:
	id has a value which is a string
fields_HasReactionAliasFrom is a reference to a hash where the following keys are defined:
	id has a value which is a string
	alias has a value which is a string
fields_Reaction is a reference to a hash where the following keys are defined:
	id has a value which is a string
	mod_date has a value which is a string
	name has a value which is a string
	msid has a value which is a string
	abbr has a value which is a string
	equation has a value which is a string
	reversibility has a value which is a string


=end text



=item Description

This relationship connects a source (database or organization)
with the reactions for which it has assigned names (aliases).
The alias itself is stored as intersection data.
It has the following fields:

=over 4


=item alias

alias for the reaction assigned by the source



=back

=back

=cut

sub get_relationship_HasReactionAliasFrom
{
    my $self = shift;
    my($ids, $from_fields, $rel_fields, $to_fields) = @_;

    my @_bad_arguments;
    (ref($ids) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"ids\" (value was \"$ids\")");
    (ref($from_fields) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"from_fields\" (value was \"$from_fields\")");
    (ref($rel_fields) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"rel_fields\" (value was \"$rel_fields\")");
    (ref($to_fields) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"to_fields\" (value was \"$to_fields\")");
    if (@_bad_arguments) {
	my $msg = "Invalid arguments passed to get_relationship_HasReactionAliasFrom:\n" . join("", map { "\t$_\n" } @_bad_arguments);
	Bio::KBase::Exceptions::ArgumentValidationError->throw(error => $msg,
							       method_name => 'get_relationship_HasReactionAliasFrom');
    }

    my $ctx = $Bio::KBase::CDMI::Service::CallContext;
    my($return);
    #BEGIN get_relationship_HasReactionAliasFrom

    $return = $self->_get_relationship($ctx, 'HasReactionAliasFrom', 'HasReactionAliasFrom', 0, $ids, $from_fields, $rel_fields, $to_fields);
	
    #END get_relationship_HasReactionAliasFrom
    my @_bad_returns;
    (ref($return) eq 'ARRAY') or push(@_bad_returns, "Invalid type for return variable \"return\" (value was \"$return\")");
    if (@_bad_returns) {
	my $msg = "Invalid returns passed to get_relationship_HasReactionAliasFrom:\n" . join("", map { "\t$_\n" } @_bad_returns);
	Bio::KBase::Exceptions::ArgumentValidationError->throw(error => $msg,
							       method_name => 'get_relationship_HasReactionAliasFrom');
    }
    return($return);
}




=head2 get_relationship_UsesAliasForReaction

  $return = $obj->get_relationship_UsesAliasForReaction($ids, $from_fields, $rel_fields, $to_fields)

=over 4

=item Parameter and return types

=begin html

<pre>
$ids is a reference to a list where each element is a string
$from_fields is a reference to a list where each element is a string
$rel_fields is a reference to a list where each element is a string
$to_fields is a reference to a list where each element is a string
$return is a reference to a list where each element is a reference to a list containing 3 items:
	0: a fields_Reaction
	1: a fields_HasReactionAliasFrom
	2: a fields_Source
fields_Reaction is a reference to a hash where the following keys are defined:
	id has a value which is a string
	mod_date has a value which is a string
	name has a value which is a string
	msid has a value which is a string
	abbr has a value which is a string
	equation has a value which is a string
	reversibility has a value which is a string
fields_HasReactionAliasFrom is a reference to a hash where the following keys are defined:
	id has a value which is a string
	alias has a value which is a string
fields_Source is a reference to a hash where the following keys are defined:
	id has a value which is a string

</pre>

=end html

=begin text

$ids is a reference to a list where each element is a string
$from_fields is a reference to a list where each element is a string
$rel_fields is a reference to a list where each element is a string
$to_fields is a reference to a list where each element is a string
$return is a reference to a list where each element is a reference to a list containing 3 items:
	0: a fields_Reaction
	1: a fields_HasReactionAliasFrom
	2: a fields_Source
fields_Reaction is a reference to a hash where the following keys are defined:
	id has a value which is a string
	mod_date has a value which is a string
	name has a value which is a string
	msid has a value which is a string
	abbr has a value which is a string
	equation has a value which is a string
	reversibility has a value which is a string
fields_HasReactionAliasFrom is a reference to a hash where the following keys are defined:
	id has a value which is a string
	alias has a value which is a string
fields_Source is a reference to a hash where the following keys are defined:
	id has a value which is a string


=end text



=item Description



=back

=cut

sub get_relationship_UsesAliasForReaction
{
    my $self = shift;
    my($ids, $from_fields, $rel_fields, $to_fields) = @_;

    my @_bad_arguments;
    (ref($ids) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"ids\" (value was \"$ids\")");
    (ref($from_fields) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"from_fields\" (value was \"$from_fields\")");
    (ref($rel_fields) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"rel_fields\" (value was \"$rel_fields\")");
    (ref($to_fields) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"to_fields\" (value was \"$to_fields\")");
    if (@_bad_arguments) {
	my $msg = "Invalid arguments passed to get_relationship_UsesAliasForReaction:\n" . join("", map { "\t$_\n" } @_bad_arguments);
	Bio::KBase::Exceptions::ArgumentValidationError->throw(error => $msg,
							       method_name => 'get_relationship_UsesAliasForReaction');
    }

    my $ctx = $Bio::KBase::CDMI::Service::CallContext;
    my($return);
    #BEGIN get_relationship_UsesAliasForReaction

    $return = $self->_get_relationship($ctx, 'UsesAliasForReaction', 'HasReactionAliasFrom', 1, $ids, $from_fields, $rel_fields, $to_fields);
	
    #END get_relationship_UsesAliasForReaction
    my @_bad_returns;
    (ref($return) eq 'ARRAY') or push(@_bad_returns, "Invalid type for return variable \"return\" (value was \"$return\")");
    if (@_bad_returns) {
	my $msg = "Invalid returns passed to get_relationship_UsesAliasForReaction:\n" . join("", map { "\t$_\n" } @_bad_returns);
	Bio::KBase::Exceptions::ArgumentValidationError->throw(error => $msg,
							       method_name => 'get_relationship_UsesAliasForReaction');
    }
    return($return);
}




=head2 get_relationship_HasRepresentativeOf

  $return = $obj->get_relationship_HasRepresentativeOf($ids, $from_fields, $rel_fields, $to_fields)

=over 4

=item Parameter and return types

=begin html

<pre>
$ids is a reference to a list where each element is a string
$from_fields is a reference to a list where each element is a string
$rel_fields is a reference to a list where each element is a string
$to_fields is a reference to a list where each element is a string
$return is a reference to a list where each element is a reference to a list containing 3 items:
	0: a fields_Genome
	1: a fields_HasRepresentativeOf
	2: a fields_Family
fields_Genome is a reference to a hash where the following keys are defined:
	id has a value which is a string
	pegs has a value which is an int
	rnas has a value which is an int
	scientific_name has a value which is a string
	complete has a value which is an int
	prokaryotic has a value which is an int
	dna_size has a value which is an int
	contigs has a value which is an int
	domain has a value which is a string
	genetic_code has a value which is an int
	gc_content has a value which is a float
	phenotype has a value which is a reference to a list where each element is a string
	md5 has a value which is a string
	source_id has a value which is a string
fields_HasRepresentativeOf is a reference to a hash where the following keys are defined:
	id has a value which is a string
fields_Family is a reference to a hash where the following keys are defined:
	id has a value which is a string
	type has a value which is a string
	release has a value which is a string
	family_function has a value which is a reference to a list where each element is a string
	alignment has a value which is a reference to a list where each element is a string

</pre>

=end html

=begin text

$ids is a reference to a list where each element is a string
$from_fields is a reference to a list where each element is a string
$rel_fields is a reference to a list where each element is a string
$to_fields is a reference to a list where each element is a string
$return is a reference to a list where each element is a reference to a list containing 3 items:
	0: a fields_Genome
	1: a fields_HasRepresentativeOf
	2: a fields_Family
fields_Genome is a reference to a hash where the following keys are defined:
	id has a value which is a string
	pegs has a value which is an int
	rnas has a value which is an int
	scientific_name has a value which is a string
	complete has a value which is an int
	prokaryotic has a value which is an int
	dna_size has a value which is an int
	contigs has a value which is an int
	domain has a value which is a string
	genetic_code has a value which is an int
	gc_content has a value which is a float
	phenotype has a value which is a reference to a list where each element is a string
	md5 has a value which is a string
	source_id has a value which is a string
fields_HasRepresentativeOf is a reference to a hash where the following keys are defined:
	id has a value which is a string
fields_Family is a reference to a hash where the following keys are defined:
	id has a value which is a string
	type has a value which is a string
	release has a value which is a string
	family_function has a value which is a reference to a list where each element is a string
	alignment has a value which is a reference to a list where each element is a string


=end text



=item Description

This relationship connects a genome to the FIGfam protein families
for which it has representative proteins. This information can be computed
from other relationships, but it is provided explicitly to allow fast access
to a genome's FIGfam profile.
It has the following fields:

=over 4



=back

=back

=cut

sub get_relationship_HasRepresentativeOf
{
    my $self = shift;
    my($ids, $from_fields, $rel_fields, $to_fields) = @_;

    my @_bad_arguments;
    (ref($ids) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"ids\" (value was \"$ids\")");
    (ref($from_fields) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"from_fields\" (value was \"$from_fields\")");
    (ref($rel_fields) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"rel_fields\" (value was \"$rel_fields\")");
    (ref($to_fields) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"to_fields\" (value was \"$to_fields\")");
    if (@_bad_arguments) {
	my $msg = "Invalid arguments passed to get_relationship_HasRepresentativeOf:\n" . join("", map { "\t$_\n" } @_bad_arguments);
	Bio::KBase::Exceptions::ArgumentValidationError->throw(error => $msg,
							       method_name => 'get_relationship_HasRepresentativeOf');
    }

    my $ctx = $Bio::KBase::CDMI::Service::CallContext;
    my($return);
    #BEGIN get_relationship_HasRepresentativeOf

    $return = $self->_get_relationship($ctx, 'HasRepresentativeOf', 'HasRepresentativeOf', 0, $ids, $from_fields, $rel_fields, $to_fields);
	
    #END get_relationship_HasRepresentativeOf
    my @_bad_returns;
    (ref($return) eq 'ARRAY') or push(@_bad_returns, "Invalid type for return variable \"return\" (value was \"$return\")");
    if (@_bad_returns) {
	my $msg = "Invalid returns passed to get_relationship_HasRepresentativeOf:\n" . join("", map { "\t$_\n" } @_bad_returns);
	Bio::KBase::Exceptions::ArgumentValidationError->throw(error => $msg,
							       method_name => 'get_relationship_HasRepresentativeOf');
    }
    return($return);
}




=head2 get_relationship_IsRepresentedIn

  $return = $obj->get_relationship_IsRepresentedIn($ids, $from_fields, $rel_fields, $to_fields)

=over 4

=item Parameter and return types

=begin html

<pre>
$ids is a reference to a list where each element is a string
$from_fields is a reference to a list where each element is a string
$rel_fields is a reference to a list where each element is a string
$to_fields is a reference to a list where each element is a string
$return is a reference to a list where each element is a reference to a list containing 3 items:
	0: a fields_Family
	1: a fields_HasRepresentativeOf
	2: a fields_Genome
fields_Family is a reference to a hash where the following keys are defined:
	id has a value which is a string
	type has a value which is a string
	release has a value which is a string
	family_function has a value which is a reference to a list where each element is a string
	alignment has a value which is a reference to a list where each element is a string
fields_HasRepresentativeOf is a reference to a hash where the following keys are defined:
	id has a value which is a string
fields_Genome is a reference to a hash where the following keys are defined:
	id has a value which is a string
	pegs has a value which is an int
	rnas has a value which is an int
	scientific_name has a value which is a string
	complete has a value which is an int
	prokaryotic has a value which is an int
	dna_size has a value which is an int
	contigs has a value which is an int
	domain has a value which is a string
	genetic_code has a value which is an int
	gc_content has a value which is a float
	phenotype has a value which is a reference to a list where each element is a string
	md5 has a value which is a string
	source_id has a value which is a string

</pre>

=end html

=begin text

$ids is a reference to a list where each element is a string
$from_fields is a reference to a list where each element is a string
$rel_fields is a reference to a list where each element is a string
$to_fields is a reference to a list where each element is a string
$return is a reference to a list where each element is a reference to a list containing 3 items:
	0: a fields_Family
	1: a fields_HasRepresentativeOf
	2: a fields_Genome
fields_Family is a reference to a hash where the following keys are defined:
	id has a value which is a string
	type has a value which is a string
	release has a value which is a string
	family_function has a value which is a reference to a list where each element is a string
	alignment has a value which is a reference to a list where each element is a string
fields_HasRepresentativeOf is a reference to a hash where the following keys are defined:
	id has a value which is a string
fields_Genome is a reference to a hash where the following keys are defined:
	id has a value which is a string
	pegs has a value which is an int
	rnas has a value which is an int
	scientific_name has a value which is a string
	complete has a value which is an int
	prokaryotic has a value which is an int
	dna_size has a value which is an int
	contigs has a value which is an int
	domain has a value which is a string
	genetic_code has a value which is an int
	gc_content has a value which is a float
	phenotype has a value which is a reference to a list where each element is a string
	md5 has a value which is a string
	source_id has a value which is a string


=end text



=item Description



=back

=cut

sub get_relationship_IsRepresentedIn
{
    my $self = shift;
    my($ids, $from_fields, $rel_fields, $to_fields) = @_;

    my @_bad_arguments;
    (ref($ids) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"ids\" (value was \"$ids\")");
    (ref($from_fields) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"from_fields\" (value was \"$from_fields\")");
    (ref($rel_fields) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"rel_fields\" (value was \"$rel_fields\")");
    (ref($to_fields) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"to_fields\" (value was \"$to_fields\")");
    if (@_bad_arguments) {
	my $msg = "Invalid arguments passed to get_relationship_IsRepresentedIn:\n" . join("", map { "\t$_\n" } @_bad_arguments);
	Bio::KBase::Exceptions::ArgumentValidationError->throw(error => $msg,
							       method_name => 'get_relationship_IsRepresentedIn');
    }

    my $ctx = $Bio::KBase::CDMI::Service::CallContext;
    my($return);
    #BEGIN get_relationship_IsRepresentedIn

    $return = $self->_get_relationship($ctx, 'IsRepresentedIn', 'HasRepresentativeOf', 1, $ids, $from_fields, $rel_fields, $to_fields);
	
    #END get_relationship_IsRepresentedIn
    my @_bad_returns;
    (ref($return) eq 'ARRAY') or push(@_bad_returns, "Invalid type for return variable \"return\" (value was \"$return\")");
    if (@_bad_returns) {
	my $msg = "Invalid returns passed to get_relationship_IsRepresentedIn:\n" . join("", map { "\t$_\n" } @_bad_returns);
	Bio::KBase::Exceptions::ArgumentValidationError->throw(error => $msg,
							       method_name => 'get_relationship_IsRepresentedIn');
    }
    return($return);
}




=head2 get_relationship_HasResultsIn

  $return = $obj->get_relationship_HasResultsIn($ids, $from_fields, $rel_fields, $to_fields)

=over 4

=item Parameter and return types

=begin html

<pre>
$ids is a reference to a list where each element is a string
$from_fields is a reference to a list where each element is a string
$rel_fields is a reference to a list where each element is a string
$to_fields is a reference to a list where each element is a string
$return is a reference to a list where each element is a reference to a list containing 3 items:
	0: a fields_ProbeSet
	1: a fields_HasResultsIn
	2: a fields_Experiment
fields_ProbeSet is a reference to a hash where the following keys are defined:
	id has a value which is a string
fields_HasResultsIn is a reference to a hash where the following keys are defined:
	id has a value which is a string
	sequence has a value which is an int
fields_Experiment is a reference to a hash where the following keys are defined:
	id has a value which is a string
	source has a value which is a string

</pre>

=end html

=begin text

$ids is a reference to a list where each element is a string
$from_fields is a reference to a list where each element is a string
$rel_fields is a reference to a list where each element is a string
$to_fields is a reference to a list where each element is a string
$return is a reference to a list where each element is a reference to a list containing 3 items:
	0: a fields_ProbeSet
	1: a fields_HasResultsIn
	2: a fields_Experiment
fields_ProbeSet is a reference to a hash where the following keys are defined:
	id has a value which is a string
fields_HasResultsIn is a reference to a hash where the following keys are defined:
	id has a value which is a string
	sequence has a value which is an int
fields_Experiment is a reference to a hash where the following keys are defined:
	id has a value which is a string
	source has a value which is a string


=end text



=item Description

This relationship connects a probe set to the experiments that were
applied to it.
It has the following fields:

=over 4


=item sequence

Sequence number of this experiment in the various result vectors.



=back

=back

=cut

sub get_relationship_HasResultsIn
{
    my $self = shift;
    my($ids, $from_fields, $rel_fields, $to_fields) = @_;

    my @_bad_arguments;
    (ref($ids) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"ids\" (value was \"$ids\")");
    (ref($from_fields) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"from_fields\" (value was \"$from_fields\")");
    (ref($rel_fields) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"rel_fields\" (value was \"$rel_fields\")");
    (ref($to_fields) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"to_fields\" (value was \"$to_fields\")");
    if (@_bad_arguments) {
	my $msg = "Invalid arguments passed to get_relationship_HasResultsIn:\n" . join("", map { "\t$_\n" } @_bad_arguments);
	Bio::KBase::Exceptions::ArgumentValidationError->throw(error => $msg,
							       method_name => 'get_relationship_HasResultsIn');
    }

    my $ctx = $Bio::KBase::CDMI::Service::CallContext;
    my($return);
    #BEGIN get_relationship_HasResultsIn

    $return = $self->_get_relationship($ctx, 'HasResultsIn', 'HasResultsIn', 0, $ids, $from_fields, $rel_fields, $to_fields);
	
    #END get_relationship_HasResultsIn
    my @_bad_returns;
    (ref($return) eq 'ARRAY') or push(@_bad_returns, "Invalid type for return variable \"return\" (value was \"$return\")");
    if (@_bad_returns) {
	my $msg = "Invalid returns passed to get_relationship_HasResultsIn:\n" . join("", map { "\t$_\n" } @_bad_returns);
	Bio::KBase::Exceptions::ArgumentValidationError->throw(error => $msg,
							       method_name => 'get_relationship_HasResultsIn');
    }
    return($return);
}




=head2 get_relationship_HasResultsFor

  $return = $obj->get_relationship_HasResultsFor($ids, $from_fields, $rel_fields, $to_fields)

=over 4

=item Parameter and return types

=begin html

<pre>
$ids is a reference to a list where each element is a string
$from_fields is a reference to a list where each element is a string
$rel_fields is a reference to a list where each element is a string
$to_fields is a reference to a list where each element is a string
$return is a reference to a list where each element is a reference to a list containing 3 items:
	0: a fields_Experiment
	1: a fields_HasResultsIn
	2: a fields_ProbeSet
fields_Experiment is a reference to a hash where the following keys are defined:
	id has a value which is a string
	source has a value which is a string
fields_HasResultsIn is a reference to a hash where the following keys are defined:
	id has a value which is a string
	sequence has a value which is an int
fields_ProbeSet is a reference to a hash where the following keys are defined:
	id has a value which is a string

</pre>

=end html

=begin text

$ids is a reference to a list where each element is a string
$from_fields is a reference to a list where each element is a string
$rel_fields is a reference to a list where each element is a string
$to_fields is a reference to a list where each element is a string
$return is a reference to a list where each element is a reference to a list containing 3 items:
	0: a fields_Experiment
	1: a fields_HasResultsIn
	2: a fields_ProbeSet
fields_Experiment is a reference to a hash where the following keys are defined:
	id has a value which is a string
	source has a value which is a string
fields_HasResultsIn is a reference to a hash where the following keys are defined:
	id has a value which is a string
	sequence has a value which is an int
fields_ProbeSet is a reference to a hash where the following keys are defined:
	id has a value which is a string


=end text



=item Description



=back

=cut

sub get_relationship_HasResultsFor
{
    my $self = shift;
    my($ids, $from_fields, $rel_fields, $to_fields) = @_;

    my @_bad_arguments;
    (ref($ids) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"ids\" (value was \"$ids\")");
    (ref($from_fields) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"from_fields\" (value was \"$from_fields\")");
    (ref($rel_fields) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"rel_fields\" (value was \"$rel_fields\")");
    (ref($to_fields) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"to_fields\" (value was \"$to_fields\")");
    if (@_bad_arguments) {
	my $msg = "Invalid arguments passed to get_relationship_HasResultsFor:\n" . join("", map { "\t$_\n" } @_bad_arguments);
	Bio::KBase::Exceptions::ArgumentValidationError->throw(error => $msg,
							       method_name => 'get_relationship_HasResultsFor');
    }

    my $ctx = $Bio::KBase::CDMI::Service::CallContext;
    my($return);
    #BEGIN get_relationship_HasResultsFor

    $return = $self->_get_relationship($ctx, 'HasResultsFor', 'HasResultsIn', 1, $ids, $from_fields, $rel_fields, $to_fields);
	
    #END get_relationship_HasResultsFor
    my @_bad_returns;
    (ref($return) eq 'ARRAY') or push(@_bad_returns, "Invalid type for return variable \"return\" (value was \"$return\")");
    if (@_bad_returns) {
	my $msg = "Invalid returns passed to get_relationship_HasResultsFor:\n" . join("", map { "\t$_\n" } @_bad_returns);
	Bio::KBase::Exceptions::ArgumentValidationError->throw(error => $msg,
							       method_name => 'get_relationship_HasResultsFor');
    }
    return($return);
}




=head2 get_relationship_HasSection

  $return = $obj->get_relationship_HasSection($ids, $from_fields, $rel_fields, $to_fields)

=over 4

=item Parameter and return types

=begin html

<pre>
$ids is a reference to a list where each element is a string
$from_fields is a reference to a list where each element is a string
$rel_fields is a reference to a list where each element is a string
$to_fields is a reference to a list where each element is a string
$return is a reference to a list where each element is a reference to a list containing 3 items:
	0: a fields_ContigSequence
	1: a fields_HasSection
	2: a fields_ContigChunk
fields_ContigSequence is a reference to a hash where the following keys are defined:
	id has a value which is a string
	length has a value which is an int
fields_HasSection is a reference to a hash where the following keys are defined:
	id has a value which is a string
fields_ContigChunk is a reference to a hash where the following keys are defined:
	id has a value which is a string
	sequence has a value which is a string

</pre>

=end html

=begin text

$ids is a reference to a list where each element is a string
$from_fields is a reference to a list where each element is a string
$rel_fields is a reference to a list where each element is a string
$to_fields is a reference to a list where each element is a string
$return is a reference to a list where each element is a reference to a list containing 3 items:
	0: a fields_ContigSequence
	1: a fields_HasSection
	2: a fields_ContigChunk
fields_ContigSequence is a reference to a hash where the following keys are defined:
	id has a value which is a string
	length has a value which is an int
fields_HasSection is a reference to a hash where the following keys are defined:
	id has a value which is a string
fields_ContigChunk is a reference to a hash where the following keys are defined:
	id has a value which is a string
	sequence has a value which is a string


=end text



=item Description

This relationship connects a contig's sequence to its DNA
sequences.
It has the following fields:

=over 4



=back

=back

=cut

sub get_relationship_HasSection
{
    my $self = shift;
    my($ids, $from_fields, $rel_fields, $to_fields) = @_;

    my @_bad_arguments;
    (ref($ids) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"ids\" (value was \"$ids\")");
    (ref($from_fields) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"from_fields\" (value was \"$from_fields\")");
    (ref($rel_fields) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"rel_fields\" (value was \"$rel_fields\")");
    (ref($to_fields) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"to_fields\" (value was \"$to_fields\")");
    if (@_bad_arguments) {
	my $msg = "Invalid arguments passed to get_relationship_HasSection:\n" . join("", map { "\t$_\n" } @_bad_arguments);
	Bio::KBase::Exceptions::ArgumentValidationError->throw(error => $msg,
							       method_name => 'get_relationship_HasSection');
    }

    my $ctx = $Bio::KBase::CDMI::Service::CallContext;
    my($return);
    #BEGIN get_relationship_HasSection

    $return = $self->_get_relationship($ctx, 'HasSection', 'HasSection', 0, $ids, $from_fields, $rel_fields, $to_fields);
	
    #END get_relationship_HasSection
    my @_bad_returns;
    (ref($return) eq 'ARRAY') or push(@_bad_returns, "Invalid type for return variable \"return\" (value was \"$return\")");
    if (@_bad_returns) {
	my $msg = "Invalid returns passed to get_relationship_HasSection:\n" . join("", map { "\t$_\n" } @_bad_returns);
	Bio::KBase::Exceptions::ArgumentValidationError->throw(error => $msg,
							       method_name => 'get_relationship_HasSection');
    }
    return($return);
}




=head2 get_relationship_IsSectionOf

  $return = $obj->get_relationship_IsSectionOf($ids, $from_fields, $rel_fields, $to_fields)

=over 4

=item Parameter and return types

=begin html

<pre>
$ids is a reference to a list where each element is a string
$from_fields is a reference to a list where each element is a string
$rel_fields is a reference to a list where each element is a string
$to_fields is a reference to a list where each element is a string
$return is a reference to a list where each element is a reference to a list containing 3 items:
	0: a fields_ContigChunk
	1: a fields_HasSection
	2: a fields_ContigSequence
fields_ContigChunk is a reference to a hash where the following keys are defined:
	id has a value which is a string
	sequence has a value which is a string
fields_HasSection is a reference to a hash where the following keys are defined:
	id has a value which is a string
fields_ContigSequence is a reference to a hash where the following keys are defined:
	id has a value which is a string
	length has a value which is an int

</pre>

=end html

=begin text

$ids is a reference to a list where each element is a string
$from_fields is a reference to a list where each element is a string
$rel_fields is a reference to a list where each element is a string
$to_fields is a reference to a list where each element is a string
$return is a reference to a list where each element is a reference to a list containing 3 items:
	0: a fields_ContigChunk
	1: a fields_HasSection
	2: a fields_ContigSequence
fields_ContigChunk is a reference to a hash where the following keys are defined:
	id has a value which is a string
	sequence has a value which is a string
fields_HasSection is a reference to a hash where the following keys are defined:
	id has a value which is a string
fields_ContigSequence is a reference to a hash where the following keys are defined:
	id has a value which is a string
	length has a value which is an int


=end text



=item Description



=back

=cut

sub get_relationship_IsSectionOf
{
    my $self = shift;
    my($ids, $from_fields, $rel_fields, $to_fields) = @_;

    my @_bad_arguments;
    (ref($ids) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"ids\" (value was \"$ids\")");
    (ref($from_fields) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"from_fields\" (value was \"$from_fields\")");
    (ref($rel_fields) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"rel_fields\" (value was \"$rel_fields\")");
    (ref($to_fields) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"to_fields\" (value was \"$to_fields\")");
    if (@_bad_arguments) {
	my $msg = "Invalid arguments passed to get_relationship_IsSectionOf:\n" . join("", map { "\t$_\n" } @_bad_arguments);
	Bio::KBase::Exceptions::ArgumentValidationError->throw(error => $msg,
							       method_name => 'get_relationship_IsSectionOf');
    }

    my $ctx = $Bio::KBase::CDMI::Service::CallContext;
    my($return);
    #BEGIN get_relationship_IsSectionOf

    $return = $self->_get_relationship($ctx, 'IsSectionOf', 'HasSection', 1, $ids, $from_fields, $rel_fields, $to_fields);
	
    #END get_relationship_IsSectionOf
    my @_bad_returns;
    (ref($return) eq 'ARRAY') or push(@_bad_returns, "Invalid type for return variable \"return\" (value was \"$return\")");
    if (@_bad_returns) {
	my $msg = "Invalid returns passed to get_relationship_IsSectionOf:\n" . join("", map { "\t$_\n" } @_bad_returns);
	Bio::KBase::Exceptions::ArgumentValidationError->throw(error => $msg,
							       method_name => 'get_relationship_IsSectionOf');
    }
    return($return);
}




=head2 get_relationship_HasStep

  $return = $obj->get_relationship_HasStep($ids, $from_fields, $rel_fields, $to_fields)

=over 4

=item Parameter and return types

=begin html

<pre>
$ids is a reference to a list where each element is a string
$from_fields is a reference to a list where each element is a string
$rel_fields is a reference to a list where each element is a string
$to_fields is a reference to a list where each element is a string
$return is a reference to a list where each element is a reference to a list containing 3 items:
	0: a fields_Complex
	1: a fields_HasStep
	2: a fields_ReactionRule
fields_Complex is a reference to a hash where the following keys are defined:
	id has a value which is a string
	name has a value which is a reference to a list where each element is a string
	msid has a value which is a string
	mod_date has a value which is a string
fields_HasStep is a reference to a hash where the following keys are defined:
	id has a value which is a string
fields_ReactionRule is a reference to a hash where the following keys are defined:
	id has a value which is a string
	direction has a value which is a string
	transproton has a value which is a float

</pre>

=end html

=begin text

$ids is a reference to a list where each element is a string
$from_fields is a reference to a list where each element is a string
$rel_fields is a reference to a list where each element is a string
$to_fields is a reference to a list where each element is a string
$return is a reference to a list where each element is a reference to a list containing 3 items:
	0: a fields_Complex
	1: a fields_HasStep
	2: a fields_ReactionRule
fields_Complex is a reference to a hash where the following keys are defined:
	id has a value which is a string
	name has a value which is a reference to a list where each element is a string
	msid has a value which is a string
	mod_date has a value which is a string
fields_HasStep is a reference to a hash where the following keys are defined:
	id has a value which is a string
fields_ReactionRule is a reference to a hash where the following keys are defined:
	id has a value which is a string
	direction has a value which is a string
	transproton has a value which is a float


=end text



=item Description

This relationship connects a complex to the reaction
rules for the reactions that work together to make the complex
happen.
It has the following fields:

=over 4



=back

=back

=cut

sub get_relationship_HasStep
{
    my $self = shift;
    my($ids, $from_fields, $rel_fields, $to_fields) = @_;

    my @_bad_arguments;
    (ref($ids) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"ids\" (value was \"$ids\")");
    (ref($from_fields) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"from_fields\" (value was \"$from_fields\")");
    (ref($rel_fields) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"rel_fields\" (value was \"$rel_fields\")");
    (ref($to_fields) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"to_fields\" (value was \"$to_fields\")");
    if (@_bad_arguments) {
	my $msg = "Invalid arguments passed to get_relationship_HasStep:\n" . join("", map { "\t$_\n" } @_bad_arguments);
	Bio::KBase::Exceptions::ArgumentValidationError->throw(error => $msg,
							       method_name => 'get_relationship_HasStep');
    }

    my $ctx = $Bio::KBase::CDMI::Service::CallContext;
    my($return);
    #BEGIN get_relationship_HasStep

    $return = $self->_get_relationship($ctx, 'HasStep', 'HasStep', 0, $ids, $from_fields, $rel_fields, $to_fields);
	
    #END get_relationship_HasStep
    my @_bad_returns;
    (ref($return) eq 'ARRAY') or push(@_bad_returns, "Invalid type for return variable \"return\" (value was \"$return\")");
    if (@_bad_returns) {
	my $msg = "Invalid returns passed to get_relationship_HasStep:\n" . join("", map { "\t$_\n" } @_bad_returns);
	Bio::KBase::Exceptions::ArgumentValidationError->throw(error => $msg,
							       method_name => 'get_relationship_HasStep');
    }
    return($return);
}




=head2 get_relationship_IsStepOf

  $return = $obj->get_relationship_IsStepOf($ids, $from_fields, $rel_fields, $to_fields)

=over 4

=item Parameter and return types

=begin html

<pre>
$ids is a reference to a list where each element is a string
$from_fields is a reference to a list where each element is a string
$rel_fields is a reference to a list where each element is a string
$to_fields is a reference to a list where each element is a string
$return is a reference to a list where each element is a reference to a list containing 3 items:
	0: a fields_ReactionRule
	1: a fields_HasStep
	2: a fields_Complex
fields_ReactionRule is a reference to a hash where the following keys are defined:
	id has a value which is a string
	direction has a value which is a string
	transproton has a value which is a float
fields_HasStep is a reference to a hash where the following keys are defined:
	id has a value which is a string
fields_Complex is a reference to a hash where the following keys are defined:
	id has a value which is a string
	name has a value which is a reference to a list where each element is a string
	msid has a value which is a string
	mod_date has a value which is a string

</pre>

=end html

=begin text

$ids is a reference to a list where each element is a string
$from_fields is a reference to a list where each element is a string
$rel_fields is a reference to a list where each element is a string
$to_fields is a reference to a list where each element is a string
$return is a reference to a list where each element is a reference to a list containing 3 items:
	0: a fields_ReactionRule
	1: a fields_HasStep
	2: a fields_Complex
fields_ReactionRule is a reference to a hash where the following keys are defined:
	id has a value which is a string
	direction has a value which is a string
	transproton has a value which is a float
fields_HasStep is a reference to a hash where the following keys are defined:
	id has a value which is a string
fields_Complex is a reference to a hash where the following keys are defined:
	id has a value which is a string
	name has a value which is a reference to a list where each element is a string
	msid has a value which is a string
	mod_date has a value which is a string


=end text



=item Description



=back

=cut

sub get_relationship_IsStepOf
{
    my $self = shift;
    my($ids, $from_fields, $rel_fields, $to_fields) = @_;

    my @_bad_arguments;
    (ref($ids) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"ids\" (value was \"$ids\")");
    (ref($from_fields) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"from_fields\" (value was \"$from_fields\")");
    (ref($rel_fields) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"rel_fields\" (value was \"$rel_fields\")");
    (ref($to_fields) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"to_fields\" (value was \"$to_fields\")");
    if (@_bad_arguments) {
	my $msg = "Invalid arguments passed to get_relationship_IsStepOf:\n" . join("", map { "\t$_\n" } @_bad_arguments);
	Bio::KBase::Exceptions::ArgumentValidationError->throw(error => $msg,
							       method_name => 'get_relationship_IsStepOf');
    }

    my $ctx = $Bio::KBase::CDMI::Service::CallContext;
    my($return);
    #BEGIN get_relationship_IsStepOf

    $return = $self->_get_relationship($ctx, 'IsStepOf', 'HasStep', 1, $ids, $from_fields, $rel_fields, $to_fields);
	
    #END get_relationship_IsStepOf
    my @_bad_returns;
    (ref($return) eq 'ARRAY') or push(@_bad_returns, "Invalid type for return variable \"return\" (value was \"$return\")");
    if (@_bad_returns) {
	my $msg = "Invalid returns passed to get_relationship_IsStepOf:\n" . join("", map { "\t$_\n" } @_bad_returns);
	Bio::KBase::Exceptions::ArgumentValidationError->throw(error => $msg,
							       method_name => 'get_relationship_IsStepOf');
    }
    return($return);
}




=head2 get_relationship_HasTrait

  $return = $obj->get_relationship_HasTrait($ids, $from_fields, $rel_fields, $to_fields)

=over 4

=item Parameter and return types

=begin html

<pre>
$ids is a reference to a list where each element is a string
$from_fields is a reference to a list where each element is a string
$rel_fields is a reference to a list where each element is a string
$to_fields is a reference to a list where each element is a string
$return is a reference to a list where each element is a reference to a list containing 3 items:
	0: a fields_ObservationalUnit
	1: a fields_HasTrait
	2: a fields_Trait
fields_ObservationalUnit is a reference to a hash where the following keys are defined:
	id has a value which is a string
	source_name has a value which is a string
	source_name2 has a value which is a reference to a list where each element is a string
	plant_id has a value which is a string
fields_HasTrait is a reference to a hash where the following keys are defined:
	id has a value which is a string
	value has a value which is a float
	statistic_type has a value which is a string
	measure_id has a value which is a string
fields_Trait is a reference to a hash where the following keys are defined:
	id has a value which is a string
	trait_name has a value which is a string
	unit_of_measure has a value which is a string
	TO_ID has a value which is a string
	protocol has a value which is a string

</pre>

=end html

=begin text

$ids is a reference to a list where each element is a string
$from_fields is a reference to a list where each element is a string
$rel_fields is a reference to a list where each element is a string
$to_fields is a reference to a list where each element is a string
$return is a reference to a list where each element is a reference to a list containing 3 items:
	0: a fields_ObservationalUnit
	1: a fields_HasTrait
	2: a fields_Trait
fields_ObservationalUnit is a reference to a hash where the following keys are defined:
	id has a value which is a string
	source_name has a value which is a string
	source_name2 has a value which is a reference to a list where each element is a string
	plant_id has a value which is a string
fields_HasTrait is a reference to a hash where the following keys are defined:
	id has a value which is a string
	value has a value which is a float
	statistic_type has a value which is a string
	measure_id has a value which is a string
fields_Trait is a reference to a hash where the following keys are defined:
	id has a value which is a string
	trait_name has a value which is a string
	unit_of_measure has a value which is a string
	TO_ID has a value which is a string
	protocol has a value which is a string


=end text



=item Description

This relationship contains the measurement values of a trait on a specific observational Unit
It has the following fields:

=over 4


=item value

value of the trait measurement


=item statistic_type

text description of the statistic type (e.g. mean, median)


=item measure_id

internal ID given to this measurement



=back

=back

=cut

sub get_relationship_HasTrait
{
    my $self = shift;
    my($ids, $from_fields, $rel_fields, $to_fields) = @_;

    my @_bad_arguments;
    (ref($ids) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"ids\" (value was \"$ids\")");
    (ref($from_fields) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"from_fields\" (value was \"$from_fields\")");
    (ref($rel_fields) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"rel_fields\" (value was \"$rel_fields\")");
    (ref($to_fields) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"to_fields\" (value was \"$to_fields\")");
    if (@_bad_arguments) {
	my $msg = "Invalid arguments passed to get_relationship_HasTrait:\n" . join("", map { "\t$_\n" } @_bad_arguments);
	Bio::KBase::Exceptions::ArgumentValidationError->throw(error => $msg,
							       method_name => 'get_relationship_HasTrait');
    }

    my $ctx = $Bio::KBase::CDMI::Service::CallContext;
    my($return);
    #BEGIN get_relationship_HasTrait

    $return = $self->_get_relationship($ctx, 'HasTrait', 'HasTrait', 0, $ids, $from_fields, $rel_fields, $to_fields);
	
    #END get_relationship_HasTrait
    my @_bad_returns;
    (ref($return) eq 'ARRAY') or push(@_bad_returns, "Invalid type for return variable \"return\" (value was \"$return\")");
    if (@_bad_returns) {
	my $msg = "Invalid returns passed to get_relationship_HasTrait:\n" . join("", map { "\t$_\n" } @_bad_returns);
	Bio::KBase::Exceptions::ArgumentValidationError->throw(error => $msg,
							       method_name => 'get_relationship_HasTrait');
    }
    return($return);
}




=head2 get_relationship_Measures

  $return = $obj->get_relationship_Measures($ids, $from_fields, $rel_fields, $to_fields)

=over 4

=item Parameter and return types

=begin html

<pre>
$ids is a reference to a list where each element is a string
$from_fields is a reference to a list where each element is a string
$rel_fields is a reference to a list where each element is a string
$to_fields is a reference to a list where each element is a string
$return is a reference to a list where each element is a reference to a list containing 3 items:
	0: a fields_Trait
	1: a fields_HasTrait
	2: a fields_ObservationalUnit
fields_Trait is a reference to a hash where the following keys are defined:
	id has a value which is a string
	trait_name has a value which is a string
	unit_of_measure has a value which is a string
	TO_ID has a value which is a string
	protocol has a value which is a string
fields_HasTrait is a reference to a hash where the following keys are defined:
	id has a value which is a string
	value has a value which is a float
	statistic_type has a value which is a string
	measure_id has a value which is a string
fields_ObservationalUnit is a reference to a hash where the following keys are defined:
	id has a value which is a string
	source_name has a value which is a string
	source_name2 has a value which is a reference to a list where each element is a string
	plant_id has a value which is a string

</pre>

=end html

=begin text

$ids is a reference to a list where each element is a string
$from_fields is a reference to a list where each element is a string
$rel_fields is a reference to a list where each element is a string
$to_fields is a reference to a list where each element is a string
$return is a reference to a list where each element is a reference to a list containing 3 items:
	0: a fields_Trait
	1: a fields_HasTrait
	2: a fields_ObservationalUnit
fields_Trait is a reference to a hash where the following keys are defined:
	id has a value which is a string
	trait_name has a value which is a string
	unit_of_measure has a value which is a string
	TO_ID has a value which is a string
	protocol has a value which is a string
fields_HasTrait is a reference to a hash where the following keys are defined:
	id has a value which is a string
	value has a value which is a float
	statistic_type has a value which is a string
	measure_id has a value which is a string
fields_ObservationalUnit is a reference to a hash where the following keys are defined:
	id has a value which is a string
	source_name has a value which is a string
	source_name2 has a value which is a reference to a list where each element is a string
	plant_id has a value which is a string


=end text



=item Description



=back

=cut

sub get_relationship_Measures
{
    my $self = shift;
    my($ids, $from_fields, $rel_fields, $to_fields) = @_;

    my @_bad_arguments;
    (ref($ids) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"ids\" (value was \"$ids\")");
    (ref($from_fields) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"from_fields\" (value was \"$from_fields\")");
    (ref($rel_fields) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"rel_fields\" (value was \"$rel_fields\")");
    (ref($to_fields) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"to_fields\" (value was \"$to_fields\")");
    if (@_bad_arguments) {
	my $msg = "Invalid arguments passed to get_relationship_Measures:\n" . join("", map { "\t$_\n" } @_bad_arguments);
	Bio::KBase::Exceptions::ArgumentValidationError->throw(error => $msg,
							       method_name => 'get_relationship_Measures');
    }

    my $ctx = $Bio::KBase::CDMI::Service::CallContext;
    my($return);
    #BEGIN get_relationship_Measures

    $return = $self->_get_relationship($ctx, 'Measures', 'HasTrait', 1, $ids, $from_fields, $rel_fields, $to_fields);
	
    #END get_relationship_Measures
    my @_bad_returns;
    (ref($return) eq 'ARRAY') or push(@_bad_returns, "Invalid type for return variable \"return\" (value was \"$return\")");
    if (@_bad_returns) {
	my $msg = "Invalid returns passed to get_relationship_Measures:\n" . join("", map { "\t$_\n" } @_bad_returns);
	Bio::KBase::Exceptions::ArgumentValidationError->throw(error => $msg,
							       method_name => 'get_relationship_Measures');
    }
    return($return);
}




=head2 get_relationship_HasUnits

  $return = $obj->get_relationship_HasUnits($ids, $from_fields, $rel_fields, $to_fields)

=over 4

=item Parameter and return types

=begin html

<pre>
$ids is a reference to a list where each element is a string
$from_fields is a reference to a list where each element is a string
$rel_fields is a reference to a list where each element is a string
$to_fields is a reference to a list where each element is a string
$return is a reference to a list where each element is a reference to a list containing 3 items:
	0: a fields_Locality
	1: a fields_HasUnits
	2: a fields_ObservationalUnit
fields_Locality is a reference to a hash where the following keys are defined:
	id has a value which is a string
	source_name has a value which is a string
	city has a value which is a string
	state has a value which is a string
	country has a value which is a string
	origcty has a value which is a string
	elevation has a value which is an int
	latitude has a value which is an int
	longitude has a value which is an int
	lo_accession has a value which is a string
fields_HasUnits is a reference to a hash where the following keys are defined:
	id has a value which is a string
fields_ObservationalUnit is a reference to a hash where the following keys are defined:
	id has a value which is a string
	source_name has a value which is a string
	source_name2 has a value which is a reference to a list where each element is a string
	plant_id has a value which is a string

</pre>

=end html

=begin text

$ids is a reference to a list where each element is a string
$from_fields is a reference to a list where each element is a string
$rel_fields is a reference to a list where each element is a string
$to_fields is a reference to a list where each element is a string
$return is a reference to a list where each element is a reference to a list containing 3 items:
	0: a fields_Locality
	1: a fields_HasUnits
	2: a fields_ObservationalUnit
fields_Locality is a reference to a hash where the following keys are defined:
	id has a value which is a string
	source_name has a value which is a string
	city has a value which is a string
	state has a value which is a string
	country has a value which is a string
	origcty has a value which is a string
	elevation has a value which is an int
	latitude has a value which is an int
	longitude has a value which is an int
	lo_accession has a value which is a string
fields_HasUnits is a reference to a hash where the following keys are defined:
	id has a value which is a string
fields_ObservationalUnit is a reference to a hash where the following keys are defined:
	id has a value which is a string
	source_name has a value which is a string
	source_name2 has a value which is a reference to a list where each element is a string
	plant_id has a value which is a string


=end text



=item Description

This relationship associates observational units with the
geographic location where the unit is planted.
It has the following fields:

=over 4



=back

=back

=cut

sub get_relationship_HasUnits
{
    my $self = shift;
    my($ids, $from_fields, $rel_fields, $to_fields) = @_;

    my @_bad_arguments;
    (ref($ids) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"ids\" (value was \"$ids\")");
    (ref($from_fields) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"from_fields\" (value was \"$from_fields\")");
    (ref($rel_fields) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"rel_fields\" (value was \"$rel_fields\")");
    (ref($to_fields) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"to_fields\" (value was \"$to_fields\")");
    if (@_bad_arguments) {
	my $msg = "Invalid arguments passed to get_relationship_HasUnits:\n" . join("", map { "\t$_\n" } @_bad_arguments);
	Bio::KBase::Exceptions::ArgumentValidationError->throw(error => $msg,
							       method_name => 'get_relationship_HasUnits');
    }

    my $ctx = $Bio::KBase::CDMI::Service::CallContext;
    my($return);
    #BEGIN get_relationship_HasUnits

    $return = $self->_get_relationship($ctx, 'HasUnits', 'HasUnits', 0, $ids, $from_fields, $rel_fields, $to_fields);
	
    #END get_relationship_HasUnits
    my @_bad_returns;
    (ref($return) eq 'ARRAY') or push(@_bad_returns, "Invalid type for return variable \"return\" (value was \"$return\")");
    if (@_bad_returns) {
	my $msg = "Invalid returns passed to get_relationship_HasUnits:\n" . join("", map { "\t$_\n" } @_bad_returns);
	Bio::KBase::Exceptions::ArgumentValidationError->throw(error => $msg,
							       method_name => 'get_relationship_HasUnits');
    }
    return($return);
}




=head2 get_relationship_IsLocated

  $return = $obj->get_relationship_IsLocated($ids, $from_fields, $rel_fields, $to_fields)

=over 4

=item Parameter and return types

=begin html

<pre>
$ids is a reference to a list where each element is a string
$from_fields is a reference to a list where each element is a string
$rel_fields is a reference to a list where each element is a string
$to_fields is a reference to a list where each element is a string
$return is a reference to a list where each element is a reference to a list containing 3 items:
	0: a fields_ObservationalUnit
	1: a fields_HasUnits
	2: a fields_Locality
fields_ObservationalUnit is a reference to a hash where the following keys are defined:
	id has a value which is a string
	source_name has a value which is a string
	source_name2 has a value which is a reference to a list where each element is a string
	plant_id has a value which is a string
fields_HasUnits is a reference to a hash where the following keys are defined:
	id has a value which is a string
fields_Locality is a reference to a hash where the following keys are defined:
	id has a value which is a string
	source_name has a value which is a string
	city has a value which is a string
	state has a value which is a string
	country has a value which is a string
	origcty has a value which is a string
	elevation has a value which is an int
	latitude has a value which is an int
	longitude has a value which is an int
	lo_accession has a value which is a string

</pre>

=end html

=begin text

$ids is a reference to a list where each element is a string
$from_fields is a reference to a list where each element is a string
$rel_fields is a reference to a list where each element is a string
$to_fields is a reference to a list where each element is a string
$return is a reference to a list where each element is a reference to a list containing 3 items:
	0: a fields_ObservationalUnit
	1: a fields_HasUnits
	2: a fields_Locality
fields_ObservationalUnit is a reference to a hash where the following keys are defined:
	id has a value which is a string
	source_name has a value which is a string
	source_name2 has a value which is a reference to a list where each element is a string
	plant_id has a value which is a string
fields_HasUnits is a reference to a hash where the following keys are defined:
	id has a value which is a string
fields_Locality is a reference to a hash where the following keys are defined:
	id has a value which is a string
	source_name has a value which is a string
	city has a value which is a string
	state has a value which is a string
	country has a value which is a string
	origcty has a value which is a string
	elevation has a value which is an int
	latitude has a value which is an int
	longitude has a value which is an int
	lo_accession has a value which is a string


=end text



=item Description



=back

=cut

sub get_relationship_IsLocated
{
    my $self = shift;
    my($ids, $from_fields, $rel_fields, $to_fields) = @_;

    my @_bad_arguments;
    (ref($ids) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"ids\" (value was \"$ids\")");
    (ref($from_fields) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"from_fields\" (value was \"$from_fields\")");
    (ref($rel_fields) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"rel_fields\" (value was \"$rel_fields\")");
    (ref($to_fields) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"to_fields\" (value was \"$to_fields\")");
    if (@_bad_arguments) {
	my $msg = "Invalid arguments passed to get_relationship_IsLocated:\n" . join("", map { "\t$_\n" } @_bad_arguments);
	Bio::KBase::Exceptions::ArgumentValidationError->throw(error => $msg,
							       method_name => 'get_relationship_IsLocated');
    }

    my $ctx = $Bio::KBase::CDMI::Service::CallContext;
    my($return);
    #BEGIN get_relationship_IsLocated

    $return = $self->_get_relationship($ctx, 'IsLocated', 'HasUnits', 1, $ids, $from_fields, $rel_fields, $to_fields);
	
    #END get_relationship_IsLocated
    my @_bad_returns;
    (ref($return) eq 'ARRAY') or push(@_bad_returns, "Invalid type for return variable \"return\" (value was \"$return\")");
    if (@_bad_returns) {
	my $msg = "Invalid returns passed to get_relationship_IsLocated:\n" . join("", map { "\t$_\n" } @_bad_returns);
	Bio::KBase::Exceptions::ArgumentValidationError->throw(error => $msg,
							       method_name => 'get_relationship_IsLocated');
    }
    return($return);
}




=head2 get_relationship_HasUsage

  $return = $obj->get_relationship_HasUsage($ids, $from_fields, $rel_fields, $to_fields)

=over 4

=item Parameter and return types

=begin html

<pre>
$ids is a reference to a list where each element is a string
$from_fields is a reference to a list where each element is a string
$rel_fields is a reference to a list where each element is a string
$to_fields is a reference to a list where each element is a string
$return is a reference to a list where each element is a reference to a list containing 3 items:
	0: a fields_Compound
	1: a fields_HasUsage
	2: a fields_BiomassCompound
fields_Compound is a reference to a hash where the following keys are defined:
	id has a value which is a string
	label has a value which is a string
	abbr has a value which is a string
	msid has a value which is a string
	ubiquitous has a value which is an int
	mod_date has a value which is a string
	uncharged_formula has a value which is a string
	formula has a value which is a string
	mass has a value which is a float
fields_HasUsage is a reference to a hash where the following keys are defined:
	id has a value which is a string
fields_BiomassCompound is a reference to a hash where the following keys are defined:
	id has a value which is a string
	coefficient has a value which is a float

</pre>

=end html

=begin text

$ids is a reference to a list where each element is a string
$from_fields is a reference to a list where each element is a string
$rel_fields is a reference to a list where each element is a string
$to_fields is a reference to a list where each element is a string
$return is a reference to a list where each element is a reference to a list containing 3 items:
	0: a fields_Compound
	1: a fields_HasUsage
	2: a fields_BiomassCompound
fields_Compound is a reference to a hash where the following keys are defined:
	id has a value which is a string
	label has a value which is a string
	abbr has a value which is a string
	msid has a value which is a string
	ubiquitous has a value which is an int
	mod_date has a value which is a string
	uncharged_formula has a value which is a string
	formula has a value which is a string
	mass has a value which is a float
fields_HasUsage is a reference to a hash where the following keys are defined:
	id has a value which is a string
fields_BiomassCompound is a reference to a hash where the following keys are defined:
	id has a value which is a string
	coefficient has a value which is a float


=end text



=item Description

This relationship connects a biomass compound specification
to the compounds for which it is relevant.
It has the following fields:

=over 4



=back

=back

=cut

sub get_relationship_HasUsage
{
    my $self = shift;
    my($ids, $from_fields, $rel_fields, $to_fields) = @_;

    my @_bad_arguments;
    (ref($ids) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"ids\" (value was \"$ids\")");
    (ref($from_fields) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"from_fields\" (value was \"$from_fields\")");
    (ref($rel_fields) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"rel_fields\" (value was \"$rel_fields\")");
    (ref($to_fields) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"to_fields\" (value was \"$to_fields\")");
    if (@_bad_arguments) {
	my $msg = "Invalid arguments passed to get_relationship_HasUsage:\n" . join("", map { "\t$_\n" } @_bad_arguments);
	Bio::KBase::Exceptions::ArgumentValidationError->throw(error => $msg,
							       method_name => 'get_relationship_HasUsage');
    }

    my $ctx = $Bio::KBase::CDMI::Service::CallContext;
    my($return);
    #BEGIN get_relationship_HasUsage

    $return = $self->_get_relationship($ctx, 'HasUsage', 'HasUsage', 0, $ids, $from_fields, $rel_fields, $to_fields);
	
    #END get_relationship_HasUsage
    my @_bad_returns;
    (ref($return) eq 'ARRAY') or push(@_bad_returns, "Invalid type for return variable \"return\" (value was \"$return\")");
    if (@_bad_returns) {
	my $msg = "Invalid returns passed to get_relationship_HasUsage:\n" . join("", map { "\t$_\n" } @_bad_returns);
	Bio::KBase::Exceptions::ArgumentValidationError->throw(error => $msg,
							       method_name => 'get_relationship_HasUsage');
    }
    return($return);
}




=head2 get_relationship_IsUsageOf

  $return = $obj->get_relationship_IsUsageOf($ids, $from_fields, $rel_fields, $to_fields)

=over 4

=item Parameter and return types

=begin html

<pre>
$ids is a reference to a list where each element is a string
$from_fields is a reference to a list where each element is a string
$rel_fields is a reference to a list where each element is a string
$to_fields is a reference to a list where each element is a string
$return is a reference to a list where each element is a reference to a list containing 3 items:
	0: a fields_BiomassCompound
	1: a fields_HasUsage
	2: a fields_Compound
fields_BiomassCompound is a reference to a hash where the following keys are defined:
	id has a value which is a string
	coefficient has a value which is a float
fields_HasUsage is a reference to a hash where the following keys are defined:
	id has a value which is a string
fields_Compound is a reference to a hash where the following keys are defined:
	id has a value which is a string
	label has a value which is a string
	abbr has a value which is a string
	msid has a value which is a string
	ubiquitous has a value which is an int
	mod_date has a value which is a string
	uncharged_formula has a value which is a string
	formula has a value which is a string
	mass has a value which is a float

</pre>

=end html

=begin text

$ids is a reference to a list where each element is a string
$from_fields is a reference to a list where each element is a string
$rel_fields is a reference to a list where each element is a string
$to_fields is a reference to a list where each element is a string
$return is a reference to a list where each element is a reference to a list containing 3 items:
	0: a fields_BiomassCompound
	1: a fields_HasUsage
	2: a fields_Compound
fields_BiomassCompound is a reference to a hash where the following keys are defined:
	id has a value which is a string
	coefficient has a value which is a float
fields_HasUsage is a reference to a hash where the following keys are defined:
	id has a value which is a string
fields_Compound is a reference to a hash where the following keys are defined:
	id has a value which is a string
	label has a value which is a string
	abbr has a value which is a string
	msid has a value which is a string
	ubiquitous has a value which is an int
	mod_date has a value which is a string
	uncharged_formula has a value which is a string
	formula has a value which is a string
	mass has a value which is a float


=end text



=item Description



=back

=cut

sub get_relationship_IsUsageOf
{
    my $self = shift;
    my($ids, $from_fields, $rel_fields, $to_fields) = @_;

    my @_bad_arguments;
    (ref($ids) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"ids\" (value was \"$ids\")");
    (ref($from_fields) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"from_fields\" (value was \"$from_fields\")");
    (ref($rel_fields) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"rel_fields\" (value was \"$rel_fields\")");
    (ref($to_fields) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"to_fields\" (value was \"$to_fields\")");
    if (@_bad_arguments) {
	my $msg = "Invalid arguments passed to get_relationship_IsUsageOf:\n" . join("", map { "\t$_\n" } @_bad_arguments);
	Bio::KBase::Exceptions::ArgumentValidationError->throw(error => $msg,
							       method_name => 'get_relationship_IsUsageOf');
    }

    my $ctx = $Bio::KBase::CDMI::Service::CallContext;
    my($return);
    #BEGIN get_relationship_IsUsageOf

    $return = $self->_get_relationship($ctx, 'IsUsageOf', 'HasUsage', 1, $ids, $from_fields, $rel_fields, $to_fields);
	
    #END get_relationship_IsUsageOf
    my @_bad_returns;
    (ref($return) eq 'ARRAY') or push(@_bad_returns, "Invalid type for return variable \"return\" (value was \"$return\")");
    if (@_bad_returns) {
	my $msg = "Invalid returns passed to get_relationship_IsUsageOf:\n" . join("", map { "\t$_\n" } @_bad_returns);
	Bio::KBase::Exceptions::ArgumentValidationError->throw(error => $msg,
							       method_name => 'get_relationship_IsUsageOf');
    }
    return($return);
}




=head2 get_relationship_HasValueFor

  $return = $obj->get_relationship_HasValueFor($ids, $from_fields, $rel_fields, $to_fields)

=over 4

=item Parameter and return types

=begin html

<pre>
$ids is a reference to a list where each element is a string
$from_fields is a reference to a list where each element is a string
$rel_fields is a reference to a list where each element is a string
$to_fields is a reference to a list where each element is a string
$return is a reference to a list where each element is a reference to a list containing 3 items:
	0: a fields_Experiment
	1: a fields_HasValueFor
	2: a fields_Attribute
fields_Experiment is a reference to a hash where the following keys are defined:
	id has a value which is a string
	source has a value which is a string
fields_HasValueFor is a reference to a hash where the following keys are defined:
	id has a value which is a string
	value has a value which is a string
fields_Attribute is a reference to a hash where the following keys are defined:
	id has a value which is a string
	description has a value which is a string

</pre>

=end html

=begin text

$ids is a reference to a list where each element is a string
$from_fields is a reference to a list where each element is a string
$rel_fields is a reference to a list where each element is a string
$to_fields is a reference to a list where each element is a string
$return is a reference to a list where each element is a reference to a list containing 3 items:
	0: a fields_Experiment
	1: a fields_HasValueFor
	2: a fields_Attribute
fields_Experiment is a reference to a hash where the following keys are defined:
	id has a value which is a string
	source has a value which is a string
fields_HasValueFor is a reference to a hash where the following keys are defined:
	id has a value which is a string
	value has a value which is a string
fields_Attribute is a reference to a hash where the following keys are defined:
	id has a value which is a string
	description has a value which is a string


=end text



=item Description

This relationship connects an experiment to its attributes. The attribute
values are stored here.
It has the following fields:

=over 4


=item value

Value of this attribute in the given experiment. This is always encoded
as a string, but may in fact be a number.



=back

=back

=cut

sub get_relationship_HasValueFor
{
    my $self = shift;
    my($ids, $from_fields, $rel_fields, $to_fields) = @_;

    my @_bad_arguments;
    (ref($ids) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"ids\" (value was \"$ids\")");
    (ref($from_fields) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"from_fields\" (value was \"$from_fields\")");
    (ref($rel_fields) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"rel_fields\" (value was \"$rel_fields\")");
    (ref($to_fields) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"to_fields\" (value was \"$to_fields\")");
    if (@_bad_arguments) {
	my $msg = "Invalid arguments passed to get_relationship_HasValueFor:\n" . join("", map { "\t$_\n" } @_bad_arguments);
	Bio::KBase::Exceptions::ArgumentValidationError->throw(error => $msg,
							       method_name => 'get_relationship_HasValueFor');
    }

    my $ctx = $Bio::KBase::CDMI::Service::CallContext;
    my($return);
    #BEGIN get_relationship_HasValueFor

    $return = $self->_get_relationship($ctx, 'HasValueFor', 'HasValueFor', 0, $ids, $from_fields, $rel_fields, $to_fields);
	
    #END get_relationship_HasValueFor
    my @_bad_returns;
    (ref($return) eq 'ARRAY') or push(@_bad_returns, "Invalid type for return variable \"return\" (value was \"$return\")");
    if (@_bad_returns) {
	my $msg = "Invalid returns passed to get_relationship_HasValueFor:\n" . join("", map { "\t$_\n" } @_bad_returns);
	Bio::KBase::Exceptions::ArgumentValidationError->throw(error => $msg,
							       method_name => 'get_relationship_HasValueFor');
    }
    return($return);
}




=head2 get_relationship_HasValueIn

  $return = $obj->get_relationship_HasValueIn($ids, $from_fields, $rel_fields, $to_fields)

=over 4

=item Parameter and return types

=begin html

<pre>
$ids is a reference to a list where each element is a string
$from_fields is a reference to a list where each element is a string
$rel_fields is a reference to a list where each element is a string
$to_fields is a reference to a list where each element is a string
$return is a reference to a list where each element is a reference to a list containing 3 items:
	0: a fields_Attribute
	1: a fields_HasValueFor
	2: a fields_Experiment
fields_Attribute is a reference to a hash where the following keys are defined:
	id has a value which is a string
	description has a value which is a string
fields_HasValueFor is a reference to a hash where the following keys are defined:
	id has a value which is a string
	value has a value which is a string
fields_Experiment is a reference to a hash where the following keys are defined:
	id has a value which is a string
	source has a value which is a string

</pre>

=end html

=begin text

$ids is a reference to a list where each element is a string
$from_fields is a reference to a list where each element is a string
$rel_fields is a reference to a list where each element is a string
$to_fields is a reference to a list where each element is a string
$return is a reference to a list where each element is a reference to a list containing 3 items:
	0: a fields_Attribute
	1: a fields_HasValueFor
	2: a fields_Experiment
fields_Attribute is a reference to a hash where the following keys are defined:
	id has a value which is a string
	description has a value which is a string
fields_HasValueFor is a reference to a hash where the following keys are defined:
	id has a value which is a string
	value has a value which is a string
fields_Experiment is a reference to a hash where the following keys are defined:
	id has a value which is a string
	source has a value which is a string


=end text



=item Description



=back

=cut

sub get_relationship_HasValueIn
{
    my $self = shift;
    my($ids, $from_fields, $rel_fields, $to_fields) = @_;

    my @_bad_arguments;
    (ref($ids) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"ids\" (value was \"$ids\")");
    (ref($from_fields) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"from_fields\" (value was \"$from_fields\")");
    (ref($rel_fields) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"rel_fields\" (value was \"$rel_fields\")");
    (ref($to_fields) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"to_fields\" (value was \"$to_fields\")");
    if (@_bad_arguments) {
	my $msg = "Invalid arguments passed to get_relationship_HasValueIn:\n" . join("", map { "\t$_\n" } @_bad_arguments);
	Bio::KBase::Exceptions::ArgumentValidationError->throw(error => $msg,
							       method_name => 'get_relationship_HasValueIn');
    }

    my $ctx = $Bio::KBase::CDMI::Service::CallContext;
    my($return);
    #BEGIN get_relationship_HasValueIn

    $return = $self->_get_relationship($ctx, 'HasValueIn', 'HasValueFor', 1, $ids, $from_fields, $rel_fields, $to_fields);
	
    #END get_relationship_HasValueIn
    my @_bad_returns;
    (ref($return) eq 'ARRAY') or push(@_bad_returns, "Invalid type for return variable \"return\" (value was \"$return\")");
    if (@_bad_returns) {
	my $msg = "Invalid returns passed to get_relationship_HasValueIn:\n" . join("", map { "\t$_\n" } @_bad_returns);
	Bio::KBase::Exceptions::ArgumentValidationError->throw(error => $msg,
							       method_name => 'get_relationship_HasValueIn');
    }
    return($return);
}




=head2 get_relationship_HasVariationIn

  $return = $obj->get_relationship_HasVariationIn($ids, $from_fields, $rel_fields, $to_fields)

=over 4

=item Parameter and return types

=begin html

<pre>
$ids is a reference to a list where each element is a string
$from_fields is a reference to a list where each element is a string
$rel_fields is a reference to a list where each element is a string
$to_fields is a reference to a list where each element is a string
$return is a reference to a list where each element is a reference to a list containing 3 items:
	0: a fields_Contig
	1: a fields_HasVariationIn
	2: a fields_ObservationalUnit
fields_Contig is a reference to a hash where the following keys are defined:
	id has a value which is a string
	source_id has a value which is a string
fields_HasVariationIn is a reference to a hash where the following keys are defined:
	id has a value which is a string
	position has a value which is an int
	len has a value which is an int
	data has a value which is a string
	data2 has a value which is a string
	quality has a value which is a float
fields_ObservationalUnit is a reference to a hash where the following keys are defined:
	id has a value which is a string
	source_name has a value which is a string
	source_name2 has a value which is a reference to a list where each element is a string
	plant_id has a value which is a string

</pre>

=end html

=begin text

$ids is a reference to a list where each element is a string
$from_fields is a reference to a list where each element is a string
$rel_fields is a reference to a list where each element is a string
$to_fields is a reference to a list where each element is a string
$return is a reference to a list where each element is a reference to a list containing 3 items:
	0: a fields_Contig
	1: a fields_HasVariationIn
	2: a fields_ObservationalUnit
fields_Contig is a reference to a hash where the following keys are defined:
	id has a value which is a string
	source_id has a value which is a string
fields_HasVariationIn is a reference to a hash where the following keys are defined:
	id has a value which is a string
	position has a value which is an int
	len has a value which is an int
	data has a value which is a string
	data2 has a value which is a string
	quality has a value which is a float
fields_ObservationalUnit is a reference to a hash where the following keys are defined:
	id has a value which is a string
	source_name has a value which is a string
	source_name2 has a value which is a reference to a list where each element is a string
	plant_id has a value which is a string


=end text



=item Description

This relationship defines an observational unit's DNA variation
from a contig in the reference genome.
It has the following fields:

=over 4


=item position

Position of this variation in the reference contig.


=item len

Length of the variation in the reference contig. A length
of zero indicates an insertion.


=item data

Replacement DNA for the variation on the primary chromosome. An
empty string indicates a deletion. The primary chromosome is chosen
arbitrarily among the two chromosomes of a plant's chromosome pair
(one coming from the mother and one from the father).


=item data2

Replacement DNA for the variation on the secondary chromosome.
This will frequently be the same as the primary chromosome string.


=item quality

Quality score assigned to this variation.



=back

=back

=cut

sub get_relationship_HasVariationIn
{
    my $self = shift;
    my($ids, $from_fields, $rel_fields, $to_fields) = @_;

    my @_bad_arguments;
    (ref($ids) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"ids\" (value was \"$ids\")");
    (ref($from_fields) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"from_fields\" (value was \"$from_fields\")");
    (ref($rel_fields) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"rel_fields\" (value was \"$rel_fields\")");
    (ref($to_fields) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"to_fields\" (value was \"$to_fields\")");
    if (@_bad_arguments) {
	my $msg = "Invalid arguments passed to get_relationship_HasVariationIn:\n" . join("", map { "\t$_\n" } @_bad_arguments);
	Bio::KBase::Exceptions::ArgumentValidationError->throw(error => $msg,
							       method_name => 'get_relationship_HasVariationIn');
    }

    my $ctx = $Bio::KBase::CDMI::Service::CallContext;
    my($return);
    #BEGIN get_relationship_HasVariationIn

    $return = $self->_get_relationship($ctx, 'HasVariationIn', 'HasVariationIn', 0, $ids, $from_fields, $rel_fields, $to_fields);
	
    #END get_relationship_HasVariationIn
    my @_bad_returns;
    (ref($return) eq 'ARRAY') or push(@_bad_returns, "Invalid type for return variable \"return\" (value was \"$return\")");
    if (@_bad_returns) {
	my $msg = "Invalid returns passed to get_relationship_HasVariationIn:\n" . join("", map { "\t$_\n" } @_bad_returns);
	Bio::KBase::Exceptions::ArgumentValidationError->throw(error => $msg,
							       method_name => 'get_relationship_HasVariationIn');
    }
    return($return);
}




=head2 get_relationship_IsVariedIn

  $return = $obj->get_relationship_IsVariedIn($ids, $from_fields, $rel_fields, $to_fields)

=over 4

=item Parameter and return types

=begin html

<pre>
$ids is a reference to a list where each element is a string
$from_fields is a reference to a list where each element is a string
$rel_fields is a reference to a list where each element is a string
$to_fields is a reference to a list where each element is a string
$return is a reference to a list where each element is a reference to a list containing 3 items:
	0: a fields_ObservationalUnit
	1: a fields_HasVariationIn
	2: a fields_Contig
fields_ObservationalUnit is a reference to a hash where the following keys are defined:
	id has a value which is a string
	source_name has a value which is a string
	source_name2 has a value which is a reference to a list where each element is a string
	plant_id has a value which is a string
fields_HasVariationIn is a reference to a hash where the following keys are defined:
	id has a value which is a string
	position has a value which is an int
	len has a value which is an int
	data has a value which is a string
	data2 has a value which is a string
	quality has a value which is a float
fields_Contig is a reference to a hash where the following keys are defined:
	id has a value which is a string
	source_id has a value which is a string

</pre>

=end html

=begin text

$ids is a reference to a list where each element is a string
$from_fields is a reference to a list where each element is a string
$rel_fields is a reference to a list where each element is a string
$to_fields is a reference to a list where each element is a string
$return is a reference to a list where each element is a reference to a list containing 3 items:
	0: a fields_ObservationalUnit
	1: a fields_HasVariationIn
	2: a fields_Contig
fields_ObservationalUnit is a reference to a hash where the following keys are defined:
	id has a value which is a string
	source_name has a value which is a string
	source_name2 has a value which is a reference to a list where each element is a string
	plant_id has a value which is a string
fields_HasVariationIn is a reference to a hash where the following keys are defined:
	id has a value which is a string
	position has a value which is an int
	len has a value which is an int
	data has a value which is a string
	data2 has a value which is a string
	quality has a value which is a float
fields_Contig is a reference to a hash where the following keys are defined:
	id has a value which is a string
	source_id has a value which is a string


=end text



=item Description



=back

=cut

sub get_relationship_IsVariedIn
{
    my $self = shift;
    my($ids, $from_fields, $rel_fields, $to_fields) = @_;

    my @_bad_arguments;
    (ref($ids) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"ids\" (value was \"$ids\")");
    (ref($from_fields) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"from_fields\" (value was \"$from_fields\")");
    (ref($rel_fields) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"rel_fields\" (value was \"$rel_fields\")");
    (ref($to_fields) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"to_fields\" (value was \"$to_fields\")");
    if (@_bad_arguments) {
	my $msg = "Invalid arguments passed to get_relationship_IsVariedIn:\n" . join("", map { "\t$_\n" } @_bad_arguments);
	Bio::KBase::Exceptions::ArgumentValidationError->throw(error => $msg,
							       method_name => 'get_relationship_IsVariedIn');
    }

    my $ctx = $Bio::KBase::CDMI::Service::CallContext;
    my($return);
    #BEGIN get_relationship_IsVariedIn

    $return = $self->_get_relationship($ctx, 'IsVariedIn', 'HasVariationIn', 1, $ids, $from_fields, $rel_fields, $to_fields);
	
    #END get_relationship_IsVariedIn
    my @_bad_returns;
    (ref($return) eq 'ARRAY') or push(@_bad_returns, "Invalid type for return variable \"return\" (value was \"$return\")");
    if (@_bad_returns) {
	my $msg = "Invalid returns passed to get_relationship_IsVariedIn:\n" . join("", map { "\t$_\n" } @_bad_returns);
	Bio::KBase::Exceptions::ArgumentValidationError->throw(error => $msg,
							       method_name => 'get_relationship_IsVariedIn');
    }
    return($return);
}




=head2 get_relationship_Impacts

  $return = $obj->get_relationship_Impacts($ids, $from_fields, $rel_fields, $to_fields)

=over 4

=item Parameter and return types

=begin html

<pre>
$ids is a reference to a list where each element is a string
$from_fields is a reference to a list where each element is a string
$rel_fields is a reference to a list where each element is a string
$to_fields is a reference to a list where each element is a string
$return is a reference to a list where each element is a reference to a list containing 3 items:
	0: a fields_Trait
	1: a fields_Impacts
	2: a fields_Contig
fields_Trait is a reference to a hash where the following keys are defined:
	id has a value which is a string
	trait_name has a value which is a string
	unit_of_measure has a value which is a string
	TO_ID has a value which is a string
	protocol has a value which is a string
fields_Impacts is a reference to a hash where the following keys are defined:
	id has a value which is a string
	source_name has a value which is a string
	rank has a value which is an int
	pvalue has a value which is a float
	position has a value which is an int
fields_Contig is a reference to a hash where the following keys are defined:
	id has a value which is a string
	source_id has a value which is a string

</pre>

=end html

=begin text

$ids is a reference to a list where each element is a string
$from_fields is a reference to a list where each element is a string
$rel_fields is a reference to a list where each element is a string
$to_fields is a reference to a list where each element is a string
$return is a reference to a list where each element is a reference to a list containing 3 items:
	0: a fields_Trait
	1: a fields_Impacts
	2: a fields_Contig
fields_Trait is a reference to a hash where the following keys are defined:
	id has a value which is a string
	trait_name has a value which is a string
	unit_of_measure has a value which is a string
	TO_ID has a value which is a string
	protocol has a value which is a string
fields_Impacts is a reference to a hash where the following keys are defined:
	id has a value which is a string
	source_name has a value which is a string
	rank has a value which is an int
	pvalue has a value which is a float
	position has a value which is an int
fields_Contig is a reference to a hash where the following keys are defined:
	id has a value which is a string
	source_id has a value which is a string


=end text



=item Description

This relationship contains the best scoring statistical correlations between measured traits and the responsible alleles.
It has the following fields:

=over 4


=item source_name

Name of the study which analyzed the data and determined that a variation has impact on a trait


=item rank

Rank of the position among all positions correlated with this trait.


=item pvalue

P-value of the correlation between the variation and the trait


=item position

Position in the reference contig where the trait
has an impact.



=back

=back

=cut

sub get_relationship_Impacts
{
    my $self = shift;
    my($ids, $from_fields, $rel_fields, $to_fields) = @_;

    my @_bad_arguments;
    (ref($ids) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"ids\" (value was \"$ids\")");
    (ref($from_fields) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"from_fields\" (value was \"$from_fields\")");
    (ref($rel_fields) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"rel_fields\" (value was \"$rel_fields\")");
    (ref($to_fields) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"to_fields\" (value was \"$to_fields\")");
    if (@_bad_arguments) {
	my $msg = "Invalid arguments passed to get_relationship_Impacts:\n" . join("", map { "\t$_\n" } @_bad_arguments);
	Bio::KBase::Exceptions::ArgumentValidationError->throw(error => $msg,
							       method_name => 'get_relationship_Impacts');
    }

    my $ctx = $Bio::KBase::CDMI::Service::CallContext;
    my($return);
    #BEGIN get_relationship_Impacts

    $return = $self->_get_relationship($ctx, 'Impacts', 'Impacts', 0, $ids, $from_fields, $rel_fields, $to_fields);
	
    #END get_relationship_Impacts
    my @_bad_returns;
    (ref($return) eq 'ARRAY') or push(@_bad_returns, "Invalid type for return variable \"return\" (value was \"$return\")");
    if (@_bad_returns) {
	my $msg = "Invalid returns passed to get_relationship_Impacts:\n" . join("", map { "\t$_\n" } @_bad_returns);
	Bio::KBase::Exceptions::ArgumentValidationError->throw(error => $msg,
							       method_name => 'get_relationship_Impacts');
    }
    return($return);
}




=head2 get_relationship_IsImpactedBy

  $return = $obj->get_relationship_IsImpactedBy($ids, $from_fields, $rel_fields, $to_fields)

=over 4

=item Parameter and return types

=begin html

<pre>
$ids is a reference to a list where each element is a string
$from_fields is a reference to a list where each element is a string
$rel_fields is a reference to a list where each element is a string
$to_fields is a reference to a list where each element is a string
$return is a reference to a list where each element is a reference to a list containing 3 items:
	0: a fields_Contig
	1: a fields_Impacts
	2: a fields_Trait
fields_Contig is a reference to a hash where the following keys are defined:
	id has a value which is a string
	source_id has a value which is a string
fields_Impacts is a reference to a hash where the following keys are defined:
	id has a value which is a string
	source_name has a value which is a string
	rank has a value which is an int
	pvalue has a value which is a float
	position has a value which is an int
fields_Trait is a reference to a hash where the following keys are defined:
	id has a value which is a string
	trait_name has a value which is a string
	unit_of_measure has a value which is a string
	TO_ID has a value which is a string
	protocol has a value which is a string

</pre>

=end html

=begin text

$ids is a reference to a list where each element is a string
$from_fields is a reference to a list where each element is a string
$rel_fields is a reference to a list where each element is a string
$to_fields is a reference to a list where each element is a string
$return is a reference to a list where each element is a reference to a list containing 3 items:
	0: a fields_Contig
	1: a fields_Impacts
	2: a fields_Trait
fields_Contig is a reference to a hash where the following keys are defined:
	id has a value which is a string
	source_id has a value which is a string
fields_Impacts is a reference to a hash where the following keys are defined:
	id has a value which is a string
	source_name has a value which is a string
	rank has a value which is an int
	pvalue has a value which is a float
	position has a value which is an int
fields_Trait is a reference to a hash where the following keys are defined:
	id has a value which is a string
	trait_name has a value which is a string
	unit_of_measure has a value which is a string
	TO_ID has a value which is a string
	protocol has a value which is a string


=end text



=item Description



=back

=cut

sub get_relationship_IsImpactedBy
{
    my $self = shift;
    my($ids, $from_fields, $rel_fields, $to_fields) = @_;

    my @_bad_arguments;
    (ref($ids) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"ids\" (value was \"$ids\")");
    (ref($from_fields) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"from_fields\" (value was \"$from_fields\")");
    (ref($rel_fields) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"rel_fields\" (value was \"$rel_fields\")");
    (ref($to_fields) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"to_fields\" (value was \"$to_fields\")");
    if (@_bad_arguments) {
	my $msg = "Invalid arguments passed to get_relationship_IsImpactedBy:\n" . join("", map { "\t$_\n" } @_bad_arguments);
	Bio::KBase::Exceptions::ArgumentValidationError->throw(error => $msg,
							       method_name => 'get_relationship_IsImpactedBy');
    }

    my $ctx = $Bio::KBase::CDMI::Service::CallContext;
    my($return);
    #BEGIN get_relationship_IsImpactedBy

    $return = $self->_get_relationship($ctx, 'IsImpactedBy', 'Impacts', 1, $ids, $from_fields, $rel_fields, $to_fields);
	
    #END get_relationship_IsImpactedBy
    my @_bad_returns;
    (ref($return) eq 'ARRAY') or push(@_bad_returns, "Invalid type for return variable \"return\" (value was \"$return\")");
    if (@_bad_returns) {
	my $msg = "Invalid returns passed to get_relationship_IsImpactedBy:\n" . join("", map { "\t$_\n" } @_bad_returns);
	Bio::KBase::Exceptions::ArgumentValidationError->throw(error => $msg,
							       method_name => 'get_relationship_IsImpactedBy');
    }
    return($return);
}




=head2 get_relationship_Includes

  $return = $obj->get_relationship_Includes($ids, $from_fields, $rel_fields, $to_fields)

=over 4

=item Parameter and return types

=begin html

<pre>
$ids is a reference to a list where each element is a string
$from_fields is a reference to a list where each element is a string
$rel_fields is a reference to a list where each element is a string
$to_fields is a reference to a list where each element is a string
$return is a reference to a list where each element is a reference to a list containing 3 items:
	0: a fields_Subsystem
	1: a fields_Includes
	2: a fields_Role
fields_Subsystem is a reference to a hash where the following keys are defined:
	id has a value which is a string
	version has a value which is an int
	curator has a value which is a string
	notes has a value which is a string
	description has a value which is a string
	usable has a value which is an int
	private has a value which is an int
	cluster_based has a value which is an int
	experimental has a value which is an int
fields_Includes is a reference to a hash where the following keys are defined:
	id has a value which is a string
	sequence has a value which is an int
	abbreviation has a value which is a string
	auxiliary has a value which is an int
fields_Role is a reference to a hash where the following keys are defined:
	id has a value which is a string
	hypothetical has a value which is an int

</pre>

=end html

=begin text

$ids is a reference to a list where each element is a string
$from_fields is a reference to a list where each element is a string
$rel_fields is a reference to a list where each element is a string
$to_fields is a reference to a list where each element is a string
$return is a reference to a list where each element is a reference to a list containing 3 items:
	0: a fields_Subsystem
	1: a fields_Includes
	2: a fields_Role
fields_Subsystem is a reference to a hash where the following keys are defined:
	id has a value which is a string
	version has a value which is an int
	curator has a value which is a string
	notes has a value which is a string
	description has a value which is a string
	usable has a value which is an int
	private has a value which is an int
	cluster_based has a value which is an int
	experimental has a value which is an int
fields_Includes is a reference to a hash where the following keys are defined:
	id has a value which is a string
	sequence has a value which is an int
	abbreviation has a value which is a string
	auxiliary has a value which is an int
fields_Role is a reference to a hash where the following keys are defined:
	id has a value which is a string
	hypothetical has a value which is an int


=end text



=item Description

A subsystem is defined by its roles. The subsystem's variants
contain slightly different sets of roles, but all of the roles in a
variant must be connected to the parent subsystem by this
relationship. A subsystem always has at least one role, and a role
always belongs to at least one subsystem.
It has the following fields:

=over 4


=item sequence

Sequence number of the role within the subsystem.
When the roles are formed into a variant, they will
generally appear in sequence order.


=item abbreviation

Abbreviation for this role in this subsystem. The
abbreviations are used in columnar displays, and they also
appear on diagrams.


=item auxiliary

TRUE if this is an auxiliary role, or FALSE if this role
is a functioning part of the subsystem.



=back

=back

=cut

sub get_relationship_Includes
{
    my $self = shift;
    my($ids, $from_fields, $rel_fields, $to_fields) = @_;

    my @_bad_arguments;
    (ref($ids) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"ids\" (value was \"$ids\")");
    (ref($from_fields) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"from_fields\" (value was \"$from_fields\")");
    (ref($rel_fields) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"rel_fields\" (value was \"$rel_fields\")");
    (ref($to_fields) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"to_fields\" (value was \"$to_fields\")");
    if (@_bad_arguments) {
	my $msg = "Invalid arguments passed to get_relationship_Includes:\n" . join("", map { "\t$_\n" } @_bad_arguments);
	Bio::KBase::Exceptions::ArgumentValidationError->throw(error => $msg,
							       method_name => 'get_relationship_Includes');
    }

    my $ctx = $Bio::KBase::CDMI::Service::CallContext;
    my($return);
    #BEGIN get_relationship_Includes

    $return = $self->_get_relationship($ctx, 'Includes', 'Includes', 0, $ids, $from_fields, $rel_fields, $to_fields);
	
    #END get_relationship_Includes
    my @_bad_returns;
    (ref($return) eq 'ARRAY') or push(@_bad_returns, "Invalid type for return variable \"return\" (value was \"$return\")");
    if (@_bad_returns) {
	my $msg = "Invalid returns passed to get_relationship_Includes:\n" . join("", map { "\t$_\n" } @_bad_returns);
	Bio::KBase::Exceptions::ArgumentValidationError->throw(error => $msg,
							       method_name => 'get_relationship_Includes');
    }
    return($return);
}




=head2 get_relationship_IsIncludedIn

  $return = $obj->get_relationship_IsIncludedIn($ids, $from_fields, $rel_fields, $to_fields)

=over 4

=item Parameter and return types

=begin html

<pre>
$ids is a reference to a list where each element is a string
$from_fields is a reference to a list where each element is a string
$rel_fields is a reference to a list where each element is a string
$to_fields is a reference to a list where each element is a string
$return is a reference to a list where each element is a reference to a list containing 3 items:
	0: a fields_Role
	1: a fields_Includes
	2: a fields_Subsystem
fields_Role is a reference to a hash where the following keys are defined:
	id has a value which is a string
	hypothetical has a value which is an int
fields_Includes is a reference to a hash where the following keys are defined:
	id has a value which is a string
	sequence has a value which is an int
	abbreviation has a value which is a string
	auxiliary has a value which is an int
fields_Subsystem is a reference to a hash where the following keys are defined:
	id has a value which is a string
	version has a value which is an int
	curator has a value which is a string
	notes has a value which is a string
	description has a value which is a string
	usable has a value which is an int
	private has a value which is an int
	cluster_based has a value which is an int
	experimental has a value which is an int

</pre>

=end html

=begin text

$ids is a reference to a list where each element is a string
$from_fields is a reference to a list where each element is a string
$rel_fields is a reference to a list where each element is a string
$to_fields is a reference to a list where each element is a string
$return is a reference to a list where each element is a reference to a list containing 3 items:
	0: a fields_Role
	1: a fields_Includes
	2: a fields_Subsystem
fields_Role is a reference to a hash where the following keys are defined:
	id has a value which is a string
	hypothetical has a value which is an int
fields_Includes is a reference to a hash where the following keys are defined:
	id has a value which is a string
	sequence has a value which is an int
	abbreviation has a value which is a string
	auxiliary has a value which is an int
fields_Subsystem is a reference to a hash where the following keys are defined:
	id has a value which is a string
	version has a value which is an int
	curator has a value which is a string
	notes has a value which is a string
	description has a value which is a string
	usable has a value which is an int
	private has a value which is an int
	cluster_based has a value which is an int
	experimental has a value which is an int


=end text



=item Description



=back

=cut

sub get_relationship_IsIncludedIn
{
    my $self = shift;
    my($ids, $from_fields, $rel_fields, $to_fields) = @_;

    my @_bad_arguments;
    (ref($ids) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"ids\" (value was \"$ids\")");
    (ref($from_fields) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"from_fields\" (value was \"$from_fields\")");
    (ref($rel_fields) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"rel_fields\" (value was \"$rel_fields\")");
    (ref($to_fields) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"to_fields\" (value was \"$to_fields\")");
    if (@_bad_arguments) {
	my $msg = "Invalid arguments passed to get_relationship_IsIncludedIn:\n" . join("", map { "\t$_\n" } @_bad_arguments);
	Bio::KBase::Exceptions::ArgumentValidationError->throw(error => $msg,
							       method_name => 'get_relationship_IsIncludedIn');
    }

    my $ctx = $Bio::KBase::CDMI::Service::CallContext;
    my($return);
    #BEGIN get_relationship_IsIncludedIn

    $return = $self->_get_relationship($ctx, 'IsIncludedIn', 'Includes', 1, $ids, $from_fields, $rel_fields, $to_fields);
	
    #END get_relationship_IsIncludedIn
    my @_bad_returns;
    (ref($return) eq 'ARRAY') or push(@_bad_returns, "Invalid type for return variable \"return\" (value was \"$return\")");
    if (@_bad_returns) {
	my $msg = "Invalid returns passed to get_relationship_IsIncludedIn:\n" . join("", map { "\t$_\n" } @_bad_returns);
	Bio::KBase::Exceptions::ArgumentValidationError->throw(error => $msg,
							       method_name => 'get_relationship_IsIncludedIn');
    }
    return($return);
}




=head2 get_relationship_IncludesPart

  $return = $obj->get_relationship_IncludesPart($ids, $from_fields, $rel_fields, $to_fields)

=over 4

=item Parameter and return types

=begin html

<pre>
$ids is a reference to a list where each element is a string
$from_fields is a reference to a list where each element is a string
$rel_fields is a reference to a list where each element is a string
$to_fields is a reference to a list where each element is a string
$return is a reference to a list where each element is a reference to a list containing 3 items:
	0: a fields_StudyExperiment
	1: a fields_IncludesPart
	2: a fields_ObservationalUnit
fields_StudyExperiment is a reference to a hash where the following keys are defined:
	id has a value which is a string
	source_name has a value which is a string
	design has a value which is a string
	originator has a value which is a string
fields_IncludesPart is a reference to a hash where the following keys are defined:
	id has a value which is a string
fields_ObservationalUnit is a reference to a hash where the following keys are defined:
	id has a value which is a string
	source_name has a value which is a string
	source_name2 has a value which is a reference to a list where each element is a string
	plant_id has a value which is a string

</pre>

=end html

=begin text

$ids is a reference to a list where each element is a string
$from_fields is a reference to a list where each element is a string
$rel_fields is a reference to a list where each element is a string
$to_fields is a reference to a list where each element is a string
$return is a reference to a list where each element is a reference to a list containing 3 items:
	0: a fields_StudyExperiment
	1: a fields_IncludesPart
	2: a fields_ObservationalUnit
fields_StudyExperiment is a reference to a hash where the following keys are defined:
	id has a value which is a string
	source_name has a value which is a string
	design has a value which is a string
	originator has a value which is a string
fields_IncludesPart is a reference to a hash where the following keys are defined:
	id has a value which is a string
fields_ObservationalUnit is a reference to a hash where the following keys are defined:
	id has a value which is a string
	source_name has a value which is a string
	source_name2 has a value which is a reference to a list where each element is a string
	plant_id has a value which is a string


=end text



=item Description

This relationship associates observational units with the
experiments that generated the data on them.
It has the following fields:

=over 4



=back

=back

=cut

sub get_relationship_IncludesPart
{
    my $self = shift;
    my($ids, $from_fields, $rel_fields, $to_fields) = @_;

    my @_bad_arguments;
    (ref($ids) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"ids\" (value was \"$ids\")");
    (ref($from_fields) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"from_fields\" (value was \"$from_fields\")");
    (ref($rel_fields) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"rel_fields\" (value was \"$rel_fields\")");
    (ref($to_fields) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"to_fields\" (value was \"$to_fields\")");
    if (@_bad_arguments) {
	my $msg = "Invalid arguments passed to get_relationship_IncludesPart:\n" . join("", map { "\t$_\n" } @_bad_arguments);
	Bio::KBase::Exceptions::ArgumentValidationError->throw(error => $msg,
							       method_name => 'get_relationship_IncludesPart');
    }

    my $ctx = $Bio::KBase::CDMI::Service::CallContext;
    my($return);
    #BEGIN get_relationship_IncludesPart

    $return = $self->_get_relationship($ctx, 'IncludesPart', 'IncludesPart', 0, $ids, $from_fields, $rel_fields, $to_fields);
	
    #END get_relationship_IncludesPart
    my @_bad_returns;
    (ref($return) eq 'ARRAY') or push(@_bad_returns, "Invalid type for return variable \"return\" (value was \"$return\")");
    if (@_bad_returns) {
	my $msg = "Invalid returns passed to get_relationship_IncludesPart:\n" . join("", map { "\t$_\n" } @_bad_returns);
	Bio::KBase::Exceptions::ArgumentValidationError->throw(error => $msg,
							       method_name => 'get_relationship_IncludesPart');
    }
    return($return);
}




=head2 get_relationship_IsPartOf

  $return = $obj->get_relationship_IsPartOf($ids, $from_fields, $rel_fields, $to_fields)

=over 4

=item Parameter and return types

=begin html

<pre>
$ids is a reference to a list where each element is a string
$from_fields is a reference to a list where each element is a string
$rel_fields is a reference to a list where each element is a string
$to_fields is a reference to a list where each element is a string
$return is a reference to a list where each element is a reference to a list containing 3 items:
	0: a fields_ObservationalUnit
	1: a fields_IncludesPart
	2: a fields_StudyExperiment
fields_ObservationalUnit is a reference to a hash where the following keys are defined:
	id has a value which is a string
	source_name has a value which is a string
	source_name2 has a value which is a reference to a list where each element is a string
	plant_id has a value which is a string
fields_IncludesPart is a reference to a hash where the following keys are defined:
	id has a value which is a string
fields_StudyExperiment is a reference to a hash where the following keys are defined:
	id has a value which is a string
	source_name has a value which is a string
	design has a value which is a string
	originator has a value which is a string

</pre>

=end html

=begin text

$ids is a reference to a list where each element is a string
$from_fields is a reference to a list where each element is a string
$rel_fields is a reference to a list where each element is a string
$to_fields is a reference to a list where each element is a string
$return is a reference to a list where each element is a reference to a list containing 3 items:
	0: a fields_ObservationalUnit
	1: a fields_IncludesPart
	2: a fields_StudyExperiment
fields_ObservationalUnit is a reference to a hash where the following keys are defined:
	id has a value which is a string
	source_name has a value which is a string
	source_name2 has a value which is a reference to a list where each element is a string
	plant_id has a value which is a string
fields_IncludesPart is a reference to a hash where the following keys are defined:
	id has a value which is a string
fields_StudyExperiment is a reference to a hash where the following keys are defined:
	id has a value which is a string
	source_name has a value which is a string
	design has a value which is a string
	originator has a value which is a string


=end text



=item Description



=back

=cut

sub get_relationship_IsPartOf
{
    my $self = shift;
    my($ids, $from_fields, $rel_fields, $to_fields) = @_;

    my @_bad_arguments;
    (ref($ids) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"ids\" (value was \"$ids\")");
    (ref($from_fields) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"from_fields\" (value was \"$from_fields\")");
    (ref($rel_fields) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"rel_fields\" (value was \"$rel_fields\")");
    (ref($to_fields) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"to_fields\" (value was \"$to_fields\")");
    if (@_bad_arguments) {
	my $msg = "Invalid arguments passed to get_relationship_IsPartOf:\n" . join("", map { "\t$_\n" } @_bad_arguments);
	Bio::KBase::Exceptions::ArgumentValidationError->throw(error => $msg,
							       method_name => 'get_relationship_IsPartOf');
    }

    my $ctx = $Bio::KBase::CDMI::Service::CallContext;
    my($return);
    #BEGIN get_relationship_IsPartOf

    $return = $self->_get_relationship($ctx, 'IsPartOf', 'IncludesPart', 1, $ids, $from_fields, $rel_fields, $to_fields);
	
    #END get_relationship_IsPartOf
    my @_bad_returns;
    (ref($return) eq 'ARRAY') or push(@_bad_returns, "Invalid type for return variable \"return\" (value was \"$return\")");
    if (@_bad_returns) {
	my $msg = "Invalid returns passed to get_relationship_IsPartOf:\n" . join("", map { "\t$_\n" } @_bad_returns);
	Bio::KBase::Exceptions::ArgumentValidationError->throw(error => $msg,
							       method_name => 'get_relationship_IsPartOf');
    }
    return($return);
}




=head2 get_relationship_IndicatedLevelsFor

  $return = $obj->get_relationship_IndicatedLevelsFor($ids, $from_fields, $rel_fields, $to_fields)

=over 4

=item Parameter and return types

=begin html

<pre>
$ids is a reference to a list where each element is a string
$from_fields is a reference to a list where each element is a string
$rel_fields is a reference to a list where each element is a string
$to_fields is a reference to a list where each element is a string
$return is a reference to a list where each element is a reference to a list containing 3 items:
	0: a fields_ProbeSet
	1: a fields_IndicatedLevelsFor
	2: a fields_Feature
fields_ProbeSet is a reference to a hash where the following keys are defined:
	id has a value which is a string
fields_IndicatedLevelsFor is a reference to a hash where the following keys are defined:
	id has a value which is a string
	level_vector has a value which is a countVector
countVector is a string
fields_Feature is a reference to a hash where the following keys are defined:
	id has a value which is a string
	feature_type has a value which is a string
	source_id has a value which is a string
	sequence_length has a value which is an int
	function has a value which is a string
	alias has a value which is a reference to a list where each element is a string

</pre>

=end html

=begin text

$ids is a reference to a list where each element is a string
$from_fields is a reference to a list where each element is a string
$rel_fields is a reference to a list where each element is a string
$to_fields is a reference to a list where each element is a string
$return is a reference to a list where each element is a reference to a list containing 3 items:
	0: a fields_ProbeSet
	1: a fields_IndicatedLevelsFor
	2: a fields_Feature
fields_ProbeSet is a reference to a hash where the following keys are defined:
	id has a value which is a string
fields_IndicatedLevelsFor is a reference to a hash where the following keys are defined:
	id has a value which is a string
	level_vector has a value which is a countVector
countVector is a string
fields_Feature is a reference to a hash where the following keys are defined:
	id has a value which is a string
	feature_type has a value which is a string
	source_id has a value which is a string
	sequence_length has a value which is an int
	function has a value which is a string
	alias has a value which is a reference to a list where each element is a string


=end text



=item Description

This relationship connects a feature to a probe set from which experimental
data was produced for the feature. It contains a vector of the expression levels.
It has the following fields:

=over 4


=item level_vector

Vector of expression levels (-1, 0, 1) for the experiments, in
sequence order.



=back

=back

=cut

sub get_relationship_IndicatedLevelsFor
{
    my $self = shift;
    my($ids, $from_fields, $rel_fields, $to_fields) = @_;

    my @_bad_arguments;
    (ref($ids) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"ids\" (value was \"$ids\")");
    (ref($from_fields) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"from_fields\" (value was \"$from_fields\")");
    (ref($rel_fields) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"rel_fields\" (value was \"$rel_fields\")");
    (ref($to_fields) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"to_fields\" (value was \"$to_fields\")");
    if (@_bad_arguments) {
	my $msg = "Invalid arguments passed to get_relationship_IndicatedLevelsFor:\n" . join("", map { "\t$_\n" } @_bad_arguments);
	Bio::KBase::Exceptions::ArgumentValidationError->throw(error => $msg,
							       method_name => 'get_relationship_IndicatedLevelsFor');
    }

    my $ctx = $Bio::KBase::CDMI::Service::CallContext;
    my($return);
    #BEGIN get_relationship_IndicatedLevelsFor

    $return = $self->_get_relationship($ctx, 'IndicatedLevelsFor', 'IndicatedLevelsFor', 0, $ids, $from_fields, $rel_fields, $to_fields);
	
    #END get_relationship_IndicatedLevelsFor
    my @_bad_returns;
    (ref($return) eq 'ARRAY') or push(@_bad_returns, "Invalid type for return variable \"return\" (value was \"$return\")");
    if (@_bad_returns) {
	my $msg = "Invalid returns passed to get_relationship_IndicatedLevelsFor:\n" . join("", map { "\t$_\n" } @_bad_returns);
	Bio::KBase::Exceptions::ArgumentValidationError->throw(error => $msg,
							       method_name => 'get_relationship_IndicatedLevelsFor');
    }
    return($return);
}




=head2 get_relationship_HasLevelsFrom

  $return = $obj->get_relationship_HasLevelsFrom($ids, $from_fields, $rel_fields, $to_fields)

=over 4

=item Parameter and return types

=begin html

<pre>
$ids is a reference to a list where each element is a string
$from_fields is a reference to a list where each element is a string
$rel_fields is a reference to a list where each element is a string
$to_fields is a reference to a list where each element is a string
$return is a reference to a list where each element is a reference to a list containing 3 items:
	0: a fields_Feature
	1: a fields_IndicatedLevelsFor
	2: a fields_ProbeSet
fields_Feature is a reference to a hash where the following keys are defined:
	id has a value which is a string
	feature_type has a value which is a string
	source_id has a value which is a string
	sequence_length has a value which is an int
	function has a value which is a string
	alias has a value which is a reference to a list where each element is a string
fields_IndicatedLevelsFor is a reference to a hash where the following keys are defined:
	id has a value which is a string
	level_vector has a value which is a countVector
countVector is a string
fields_ProbeSet is a reference to a hash where the following keys are defined:
	id has a value which is a string

</pre>

=end html

=begin text

$ids is a reference to a list where each element is a string
$from_fields is a reference to a list where each element is a string
$rel_fields is a reference to a list where each element is a string
$to_fields is a reference to a list where each element is a string
$return is a reference to a list where each element is a reference to a list containing 3 items:
	0: a fields_Feature
	1: a fields_IndicatedLevelsFor
	2: a fields_ProbeSet
fields_Feature is a reference to a hash where the following keys are defined:
	id has a value which is a string
	feature_type has a value which is a string
	source_id has a value which is a string
	sequence_length has a value which is an int
	function has a value which is a string
	alias has a value which is a reference to a list where each element is a string
fields_IndicatedLevelsFor is a reference to a hash where the following keys are defined:
	id has a value which is a string
	level_vector has a value which is a countVector
countVector is a string
fields_ProbeSet is a reference to a hash where the following keys are defined:
	id has a value which is a string


=end text



=item Description



=back

=cut

sub get_relationship_HasLevelsFrom
{
    my $self = shift;
    my($ids, $from_fields, $rel_fields, $to_fields) = @_;

    my @_bad_arguments;
    (ref($ids) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"ids\" (value was \"$ids\")");
    (ref($from_fields) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"from_fields\" (value was \"$from_fields\")");
    (ref($rel_fields) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"rel_fields\" (value was \"$rel_fields\")");
    (ref($to_fields) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"to_fields\" (value was \"$to_fields\")");
    if (@_bad_arguments) {
	my $msg = "Invalid arguments passed to get_relationship_HasLevelsFrom:\n" . join("", map { "\t$_\n" } @_bad_arguments);
	Bio::KBase::Exceptions::ArgumentValidationError->throw(error => $msg,
							       method_name => 'get_relationship_HasLevelsFrom');
    }

    my $ctx = $Bio::KBase::CDMI::Service::CallContext;
    my($return);
    #BEGIN get_relationship_HasLevelsFrom

    $return = $self->_get_relationship($ctx, 'HasLevelsFrom', 'IndicatedLevelsFor', 1, $ids, $from_fields, $rel_fields, $to_fields);
	
    #END get_relationship_HasLevelsFrom
    my @_bad_returns;
    (ref($return) eq 'ARRAY') or push(@_bad_returns, "Invalid type for return variable \"return\" (value was \"$return\")");
    if (@_bad_returns) {
	my $msg = "Invalid returns passed to get_relationship_HasLevelsFrom:\n" . join("", map { "\t$_\n" } @_bad_returns);
	Bio::KBase::Exceptions::ArgumentValidationError->throw(error => $msg,
							       method_name => 'get_relationship_HasLevelsFrom');
    }
    return($return);
}




=head2 get_relationship_Involves

  $return = $obj->get_relationship_Involves($ids, $from_fields, $rel_fields, $to_fields)

=over 4

=item Parameter and return types

=begin html

<pre>
$ids is a reference to a list where each element is a string
$from_fields is a reference to a list where each element is a string
$rel_fields is a reference to a list where each element is a string
$to_fields is a reference to a list where each element is a string
$return is a reference to a list where each element is a reference to a list containing 3 items:
	0: a fields_Reaction
	1: a fields_Involves
	2: a fields_Reagent
fields_Reaction is a reference to a hash where the following keys are defined:
	id has a value which is a string
	mod_date has a value which is a string
	name has a value which is a string
	msid has a value which is a string
	abbr has a value which is a string
	equation has a value which is a string
	reversibility has a value which is a string
fields_Involves is a reference to a hash where the following keys are defined:
	id has a value which is a string
fields_Reagent is a reference to a hash where the following keys are defined:
	id has a value which is a string
	stoichiometry has a value which is a float
	cofactor has a value which is an int
	compartment_index has a value which is an int
	transport_coefficient has a value which is a float

</pre>

=end html

=begin text

$ids is a reference to a list where each element is a string
$from_fields is a reference to a list where each element is a string
$rel_fields is a reference to a list where each element is a string
$to_fields is a reference to a list where each element is a string
$return is a reference to a list where each element is a reference to a list containing 3 items:
	0: a fields_Reaction
	1: a fields_Involves
	2: a fields_Reagent
fields_Reaction is a reference to a hash where the following keys are defined:
	id has a value which is a string
	mod_date has a value which is a string
	name has a value which is a string
	msid has a value which is a string
	abbr has a value which is a string
	equation has a value which is a string
	reversibility has a value which is a string
fields_Involves is a reference to a hash where the following keys are defined:
	id has a value which is a string
fields_Reagent is a reference to a hash where the following keys are defined:
	id has a value which is a string
	stoichiometry has a value which is a float
	cofactor has a value which is an int
	compartment_index has a value which is an int
	transport_coefficient has a value which is a float


=end text



=item Description

This relationship connects a reaction to the
reagents representing the compounds that participate in it.
It has the following fields:

=over 4



=back

=back

=cut

sub get_relationship_Involves
{
    my $self = shift;
    my($ids, $from_fields, $rel_fields, $to_fields) = @_;

    my @_bad_arguments;
    (ref($ids) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"ids\" (value was \"$ids\")");
    (ref($from_fields) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"from_fields\" (value was \"$from_fields\")");
    (ref($rel_fields) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"rel_fields\" (value was \"$rel_fields\")");
    (ref($to_fields) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"to_fields\" (value was \"$to_fields\")");
    if (@_bad_arguments) {
	my $msg = "Invalid arguments passed to get_relationship_Involves:\n" . join("", map { "\t$_\n" } @_bad_arguments);
	Bio::KBase::Exceptions::ArgumentValidationError->throw(error => $msg,
							       method_name => 'get_relationship_Involves');
    }

    my $ctx = $Bio::KBase::CDMI::Service::CallContext;
    my($return);
    #BEGIN get_relationship_Involves

    $return = $self->_get_relationship($ctx, 'Involves', 'Involves', 0, $ids, $from_fields, $rel_fields, $to_fields);
	
    #END get_relationship_Involves
    my @_bad_returns;
    (ref($return) eq 'ARRAY') or push(@_bad_returns, "Invalid type for return variable \"return\" (value was \"$return\")");
    if (@_bad_returns) {
	my $msg = "Invalid returns passed to get_relationship_Involves:\n" . join("", map { "\t$_\n" } @_bad_returns);
	Bio::KBase::Exceptions::ArgumentValidationError->throw(error => $msg,
							       method_name => 'get_relationship_Involves');
    }
    return($return);
}




=head2 get_relationship_IsInvolvedIn

  $return = $obj->get_relationship_IsInvolvedIn($ids, $from_fields, $rel_fields, $to_fields)

=over 4

=item Parameter and return types

=begin html

<pre>
$ids is a reference to a list where each element is a string
$from_fields is a reference to a list where each element is a string
$rel_fields is a reference to a list where each element is a string
$to_fields is a reference to a list where each element is a string
$return is a reference to a list where each element is a reference to a list containing 3 items:
	0: a fields_Reagent
	1: a fields_Involves
	2: a fields_Reaction
fields_Reagent is a reference to a hash where the following keys are defined:
	id has a value which is a string
	stoichiometry has a value which is a float
	cofactor has a value which is an int
	compartment_index has a value which is an int
	transport_coefficient has a value which is a float
fields_Involves is a reference to a hash where the following keys are defined:
	id has a value which is a string
fields_Reaction is a reference to a hash where the following keys are defined:
	id has a value which is a string
	mod_date has a value which is a string
	name has a value which is a string
	msid has a value which is a string
	abbr has a value which is a string
	equation has a value which is a string
	reversibility has a value which is a string

</pre>

=end html

=begin text

$ids is a reference to a list where each element is a string
$from_fields is a reference to a list where each element is a string
$rel_fields is a reference to a list where each element is a string
$to_fields is a reference to a list where each element is a string
$return is a reference to a list where each element is a reference to a list containing 3 items:
	0: a fields_Reagent
	1: a fields_Involves
	2: a fields_Reaction
fields_Reagent is a reference to a hash where the following keys are defined:
	id has a value which is a string
	stoichiometry has a value which is a float
	cofactor has a value which is an int
	compartment_index has a value which is an int
	transport_coefficient has a value which is a float
fields_Involves is a reference to a hash where the following keys are defined:
	id has a value which is a string
fields_Reaction is a reference to a hash where the following keys are defined:
	id has a value which is a string
	mod_date has a value which is a string
	name has a value which is a string
	msid has a value which is a string
	abbr has a value which is a string
	equation has a value which is a string
	reversibility has a value which is a string


=end text



=item Description



=back

=cut

sub get_relationship_IsInvolvedIn
{
    my $self = shift;
    my($ids, $from_fields, $rel_fields, $to_fields) = @_;

    my @_bad_arguments;
    (ref($ids) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"ids\" (value was \"$ids\")");
    (ref($from_fields) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"from_fields\" (value was \"$from_fields\")");
    (ref($rel_fields) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"rel_fields\" (value was \"$rel_fields\")");
    (ref($to_fields) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"to_fields\" (value was \"$to_fields\")");
    if (@_bad_arguments) {
	my $msg = "Invalid arguments passed to get_relationship_IsInvolvedIn:\n" . join("", map { "\t$_\n" } @_bad_arguments);
	Bio::KBase::Exceptions::ArgumentValidationError->throw(error => $msg,
							       method_name => 'get_relationship_IsInvolvedIn');
    }

    my $ctx = $Bio::KBase::CDMI::Service::CallContext;
    my($return);
    #BEGIN get_relationship_IsInvolvedIn

    $return = $self->_get_relationship($ctx, 'IsInvolvedIn', 'Involves', 1, $ids, $from_fields, $rel_fields, $to_fields);
	
    #END get_relationship_IsInvolvedIn
    my @_bad_returns;
    (ref($return) eq 'ARRAY') or push(@_bad_returns, "Invalid type for return variable \"return\" (value was \"$return\")");
    if (@_bad_returns) {
	my $msg = "Invalid returns passed to get_relationship_IsInvolvedIn:\n" . join("", map { "\t$_\n" } @_bad_returns);
	Bio::KBase::Exceptions::ArgumentValidationError->throw(error => $msg,
							       method_name => 'get_relationship_IsInvolvedIn');
    }
    return($return);
}




=head2 get_relationship_IsARequirementIn

  $return = $obj->get_relationship_IsARequirementIn($ids, $from_fields, $rel_fields, $to_fields)

=over 4

=item Parameter and return types

=begin html

<pre>
$ids is a reference to a list where each element is a string
$from_fields is a reference to a list where each element is a string
$rel_fields is a reference to a list where each element is a string
$to_fields is a reference to a list where each element is a string
$return is a reference to a list where each element is a reference to a list containing 3 items:
	0: a fields_Model
	1: a fields_IsARequirementIn
	2: a fields_Requirement
fields_Model is a reference to a hash where the following keys are defined:
	id has a value which is a string
	mod_date has a value which is a string
	name has a value which is a string
	version has a value which is an int
	type has a value which is a string
	status has a value which is a string
	reaction_count has a value which is an int
	compound_count has a value which is an int
	annotation_count has a value which is an int
fields_IsARequirementIn is a reference to a hash where the following keys are defined:
	id has a value which is a string
fields_Requirement is a reference to a hash where the following keys are defined:
	id has a value which is a string
	direction has a value which is a string
	transproton has a value which is a float
	proton has a value which is a float

</pre>

=end html

=begin text

$ids is a reference to a list where each element is a string
$from_fields is a reference to a list where each element is a string
$rel_fields is a reference to a list where each element is a string
$to_fields is a reference to a list where each element is a string
$return is a reference to a list where each element is a reference to a list containing 3 items:
	0: a fields_Model
	1: a fields_IsARequirementIn
	2: a fields_Requirement
fields_Model is a reference to a hash where the following keys are defined:
	id has a value which is a string
	mod_date has a value which is a string
	name has a value which is a string
	version has a value which is an int
	type has a value which is a string
	status has a value which is a string
	reaction_count has a value which is an int
	compound_count has a value which is an int
	annotation_count has a value which is an int
fields_IsARequirementIn is a reference to a hash where the following keys are defined:
	id has a value which is a string
fields_Requirement is a reference to a hash where the following keys are defined:
	id has a value which is a string
	direction has a value which is a string
	transproton has a value which is a float
	proton has a value which is a float


=end text



=item Description

This relationship connects a model to its requirements.
A requirement represents the use of a reaction in a single model.
It has the following fields:

=over 4



=back

=back

=cut

sub get_relationship_IsARequirementIn
{
    my $self = shift;
    my($ids, $from_fields, $rel_fields, $to_fields) = @_;

    my @_bad_arguments;
    (ref($ids) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"ids\" (value was \"$ids\")");
    (ref($from_fields) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"from_fields\" (value was \"$from_fields\")");
    (ref($rel_fields) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"rel_fields\" (value was \"$rel_fields\")");
    (ref($to_fields) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"to_fields\" (value was \"$to_fields\")");
    if (@_bad_arguments) {
	my $msg = "Invalid arguments passed to get_relationship_IsARequirementIn:\n" . join("", map { "\t$_\n" } @_bad_arguments);
	Bio::KBase::Exceptions::ArgumentValidationError->throw(error => $msg,
							       method_name => 'get_relationship_IsARequirementIn');
    }

    my $ctx = $Bio::KBase::CDMI::Service::CallContext;
    my($return);
    #BEGIN get_relationship_IsARequirementIn

    $return = $self->_get_relationship($ctx, 'IsARequirementIn', 'IsARequirementIn', 0, $ids, $from_fields, $rel_fields, $to_fields);
	
    #END get_relationship_IsARequirementIn
    my @_bad_returns;
    (ref($return) eq 'ARRAY') or push(@_bad_returns, "Invalid type for return variable \"return\" (value was \"$return\")");
    if (@_bad_returns) {
	my $msg = "Invalid returns passed to get_relationship_IsARequirementIn:\n" . join("", map { "\t$_\n" } @_bad_returns);
	Bio::KBase::Exceptions::ArgumentValidationError->throw(error => $msg,
							       method_name => 'get_relationship_IsARequirementIn');
    }
    return($return);
}




=head2 get_relationship_IsARequirementOf

  $return = $obj->get_relationship_IsARequirementOf($ids, $from_fields, $rel_fields, $to_fields)

=over 4

=item Parameter and return types

=begin html

<pre>
$ids is a reference to a list where each element is a string
$from_fields is a reference to a list where each element is a string
$rel_fields is a reference to a list where each element is a string
$to_fields is a reference to a list where each element is a string
$return is a reference to a list where each element is a reference to a list containing 3 items:
	0: a fields_Requirement
	1: a fields_IsARequirementIn
	2: a fields_Model
fields_Requirement is a reference to a hash where the following keys are defined:
	id has a value which is a string
	direction has a value which is a string
	transproton has a value which is a float
	proton has a value which is a float
fields_IsARequirementIn is a reference to a hash where the following keys are defined:
	id has a value which is a string
fields_Model is a reference to a hash where the following keys are defined:
	id has a value which is a string
	mod_date has a value which is a string
	name has a value which is a string
	version has a value which is an int
	type has a value which is a string
	status has a value which is a string
	reaction_count has a value which is an int
	compound_count has a value which is an int
	annotation_count has a value which is an int

</pre>

=end html

=begin text

$ids is a reference to a list where each element is a string
$from_fields is a reference to a list where each element is a string
$rel_fields is a reference to a list where each element is a string
$to_fields is a reference to a list where each element is a string
$return is a reference to a list where each element is a reference to a list containing 3 items:
	0: a fields_Requirement
	1: a fields_IsARequirementIn
	2: a fields_Model
fields_Requirement is a reference to a hash where the following keys are defined:
	id has a value which is a string
	direction has a value which is a string
	transproton has a value which is a float
	proton has a value which is a float
fields_IsARequirementIn is a reference to a hash where the following keys are defined:
	id has a value which is a string
fields_Model is a reference to a hash where the following keys are defined:
	id has a value which is a string
	mod_date has a value which is a string
	name has a value which is a string
	version has a value which is an int
	type has a value which is a string
	status has a value which is a string
	reaction_count has a value which is an int
	compound_count has a value which is an int
	annotation_count has a value which is an int


=end text



=item Description



=back

=cut

sub get_relationship_IsARequirementOf
{
    my $self = shift;
    my($ids, $from_fields, $rel_fields, $to_fields) = @_;

    my @_bad_arguments;
    (ref($ids) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"ids\" (value was \"$ids\")");
    (ref($from_fields) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"from_fields\" (value was \"$from_fields\")");
    (ref($rel_fields) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"rel_fields\" (value was \"$rel_fields\")");
    (ref($to_fields) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"to_fields\" (value was \"$to_fields\")");
    if (@_bad_arguments) {
	my $msg = "Invalid arguments passed to get_relationship_IsARequirementOf:\n" . join("", map { "\t$_\n" } @_bad_arguments);
	Bio::KBase::Exceptions::ArgumentValidationError->throw(error => $msg,
							       method_name => 'get_relationship_IsARequirementOf');
    }

    my $ctx = $Bio::KBase::CDMI::Service::CallContext;
    my($return);
    #BEGIN get_relationship_IsARequirementOf

    $return = $self->_get_relationship($ctx, 'IsARequirementOf', 'IsARequirementIn', 1, $ids, $from_fields, $rel_fields, $to_fields);
	
    #END get_relationship_IsARequirementOf
    my @_bad_returns;
    (ref($return) eq 'ARRAY') or push(@_bad_returns, "Invalid type for return variable \"return\" (value was \"$return\")");
    if (@_bad_returns) {
	my $msg = "Invalid returns passed to get_relationship_IsARequirementOf:\n" . join("", map { "\t$_\n" } @_bad_returns);
	Bio::KBase::Exceptions::ArgumentValidationError->throw(error => $msg,
							       method_name => 'get_relationship_IsARequirementOf');
    }
    return($return);
}




=head2 get_relationship_IsAnnotatedBy

  $return = $obj->get_relationship_IsAnnotatedBy($ids, $from_fields, $rel_fields, $to_fields)

=over 4

=item Parameter and return types

=begin html

<pre>
$ids is a reference to a list where each element is a string
$from_fields is a reference to a list where each element is a string
$rel_fields is a reference to a list where each element is a string
$to_fields is a reference to a list where each element is a string
$return is a reference to a list where each element is a reference to a list containing 3 items:
	0: a fields_Feature
	1: a fields_IsAnnotatedBy
	2: a fields_Annotation
fields_Feature is a reference to a hash where the following keys are defined:
	id has a value which is a string
	feature_type has a value which is a string
	source_id has a value which is a string
	sequence_length has a value which is an int
	function has a value which is a string
	alias has a value which is a reference to a list where each element is a string
fields_IsAnnotatedBy is a reference to a hash where the following keys are defined:
	id has a value which is a string
fields_Annotation is a reference to a hash where the following keys are defined:
	id has a value which is a string
	annotator has a value which is a string
	comment has a value which is a string
	annotation_time has a value which is a string

</pre>

=end html

=begin text

$ids is a reference to a list where each element is a string
$from_fields is a reference to a list where each element is a string
$rel_fields is a reference to a list where each element is a string
$to_fields is a reference to a list where each element is a string
$return is a reference to a list where each element is a reference to a list containing 3 items:
	0: a fields_Feature
	1: a fields_IsAnnotatedBy
	2: a fields_Annotation
fields_Feature is a reference to a hash where the following keys are defined:
	id has a value which is a string
	feature_type has a value which is a string
	source_id has a value which is a string
	sequence_length has a value which is an int
	function has a value which is a string
	alias has a value which is a reference to a list where each element is a string
fields_IsAnnotatedBy is a reference to a hash where the following keys are defined:
	id has a value which is a string
fields_Annotation is a reference to a hash where the following keys are defined:
	id has a value which is a string
	annotator has a value which is a string
	comment has a value which is a string
	annotation_time has a value which is a string


=end text



=item Description

This relationship connects a feature to its annotations. A
feature may have multiple annotations, but an annotation belongs to
only one feature.
It has the following fields:

=over 4



=back

=back

=cut

sub get_relationship_IsAnnotatedBy
{
    my $self = shift;
    my($ids, $from_fields, $rel_fields, $to_fields) = @_;

    my @_bad_arguments;
    (ref($ids) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"ids\" (value was \"$ids\")");
    (ref($from_fields) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"from_fields\" (value was \"$from_fields\")");
    (ref($rel_fields) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"rel_fields\" (value was \"$rel_fields\")");
    (ref($to_fields) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"to_fields\" (value was \"$to_fields\")");
    if (@_bad_arguments) {
	my $msg = "Invalid arguments passed to get_relationship_IsAnnotatedBy:\n" . join("", map { "\t$_\n" } @_bad_arguments);
	Bio::KBase::Exceptions::ArgumentValidationError->throw(error => $msg,
							       method_name => 'get_relationship_IsAnnotatedBy');
    }

    my $ctx = $Bio::KBase::CDMI::Service::CallContext;
    my($return);
    #BEGIN get_relationship_IsAnnotatedBy

    $return = $self->_get_relationship($ctx, 'IsAnnotatedBy', 'IsAnnotatedBy', 0, $ids, $from_fields, $rel_fields, $to_fields);
	
    #END get_relationship_IsAnnotatedBy
    my @_bad_returns;
    (ref($return) eq 'ARRAY') or push(@_bad_returns, "Invalid type for return variable \"return\" (value was \"$return\")");
    if (@_bad_returns) {
	my $msg = "Invalid returns passed to get_relationship_IsAnnotatedBy:\n" . join("", map { "\t$_\n" } @_bad_returns);
	Bio::KBase::Exceptions::ArgumentValidationError->throw(error => $msg,
							       method_name => 'get_relationship_IsAnnotatedBy');
    }
    return($return);
}




=head2 get_relationship_Annotates

  $return = $obj->get_relationship_Annotates($ids, $from_fields, $rel_fields, $to_fields)

=over 4

=item Parameter and return types

=begin html

<pre>
$ids is a reference to a list where each element is a string
$from_fields is a reference to a list where each element is a string
$rel_fields is a reference to a list where each element is a string
$to_fields is a reference to a list where each element is a string
$return is a reference to a list where each element is a reference to a list containing 3 items:
	0: a fields_Annotation
	1: a fields_IsAnnotatedBy
	2: a fields_Feature
fields_Annotation is a reference to a hash where the following keys are defined:
	id has a value which is a string
	annotator has a value which is a string
	comment has a value which is a string
	annotation_time has a value which is a string
fields_IsAnnotatedBy is a reference to a hash where the following keys are defined:
	id has a value which is a string
fields_Feature is a reference to a hash where the following keys are defined:
	id has a value which is a string
	feature_type has a value which is a string
	source_id has a value which is a string
	sequence_length has a value which is an int
	function has a value which is a string
	alias has a value which is a reference to a list where each element is a string

</pre>

=end html

=begin text

$ids is a reference to a list where each element is a string
$from_fields is a reference to a list where each element is a string
$rel_fields is a reference to a list where each element is a string
$to_fields is a reference to a list where each element is a string
$return is a reference to a list where each element is a reference to a list containing 3 items:
	0: a fields_Annotation
	1: a fields_IsAnnotatedBy
	2: a fields_Feature
fields_Annotation is a reference to a hash where the following keys are defined:
	id has a value which is a string
	annotator has a value which is a string
	comment has a value which is a string
	annotation_time has a value which is a string
fields_IsAnnotatedBy is a reference to a hash where the following keys are defined:
	id has a value which is a string
fields_Feature is a reference to a hash where the following keys are defined:
	id has a value which is a string
	feature_type has a value which is a string
	source_id has a value which is a string
	sequence_length has a value which is an int
	function has a value which is a string
	alias has a value which is a reference to a list where each element is a string


=end text



=item Description



=back

=cut

sub get_relationship_Annotates
{
    my $self = shift;
    my($ids, $from_fields, $rel_fields, $to_fields) = @_;

    my @_bad_arguments;
    (ref($ids) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"ids\" (value was \"$ids\")");
    (ref($from_fields) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"from_fields\" (value was \"$from_fields\")");
    (ref($rel_fields) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"rel_fields\" (value was \"$rel_fields\")");
    (ref($to_fields) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"to_fields\" (value was \"$to_fields\")");
    if (@_bad_arguments) {
	my $msg = "Invalid arguments passed to get_relationship_Annotates:\n" . join("", map { "\t$_\n" } @_bad_arguments);
	Bio::KBase::Exceptions::ArgumentValidationError->throw(error => $msg,
							       method_name => 'get_relationship_Annotates');
    }

    my $ctx = $Bio::KBase::CDMI::Service::CallContext;
    my($return);
    #BEGIN get_relationship_Annotates

    $return = $self->_get_relationship($ctx, 'Annotates', 'IsAnnotatedBy', 1, $ids, $from_fields, $rel_fields, $to_fields);
	
    #END get_relationship_Annotates
    my @_bad_returns;
    (ref($return) eq 'ARRAY') or push(@_bad_returns, "Invalid type for return variable \"return\" (value was \"$return\")");
    if (@_bad_returns) {
	my $msg = "Invalid returns passed to get_relationship_Annotates:\n" . join("", map { "\t$_\n" } @_bad_returns);
	Bio::KBase::Exceptions::ArgumentValidationError->throw(error => $msg,
							       method_name => 'get_relationship_Annotates');
    }
    return($return);
}




=head2 get_relationship_IsAssayOf

  $return = $obj->get_relationship_IsAssayOf($ids, $from_fields, $rel_fields, $to_fields)

=over 4

=item Parameter and return types

=begin html

<pre>
$ids is a reference to a list where each element is a string
$from_fields is a reference to a list where each element is a string
$rel_fields is a reference to a list where each element is a string
$to_fields is a reference to a list where each element is a string
$return is a reference to a list where each element is a reference to a list containing 3 items:
	0: a fields_Assay
	1: a fields_IsAssayOf
	2: a fields_StudyExperiment
fields_Assay is a reference to a hash where the following keys are defined:
	id has a value which is a string
	source_id has a value which is a string
	assay_type has a value which is a string
	assay_type_id has a value which is a string
fields_IsAssayOf is a reference to a hash where the following keys are defined:
	id has a value which is a string
fields_StudyExperiment is a reference to a hash where the following keys are defined:
	id has a value which is a string
	source_name has a value which is a string
	design has a value which is a string
	originator has a value which is a string

</pre>

=end html

=begin text

$ids is a reference to a list where each element is a string
$from_fields is a reference to a list where each element is a string
$rel_fields is a reference to a list where each element is a string
$to_fields is a reference to a list where each element is a string
$return is a reference to a list where each element is a reference to a list containing 3 items:
	0: a fields_Assay
	1: a fields_IsAssayOf
	2: a fields_StudyExperiment
fields_Assay is a reference to a hash where the following keys are defined:
	id has a value which is a string
	source_id has a value which is a string
	assay_type has a value which is a string
	assay_type_id has a value which is a string
fields_IsAssayOf is a reference to a hash where the following keys are defined:
	id has a value which is a string
fields_StudyExperiment is a reference to a hash where the following keys are defined:
	id has a value which is a string
	source_name has a value which is a string
	design has a value which is a string
	originator has a value which is a string


=end text



=item Description

This relationship associates each assay with the relevant
experiments.
It has the following fields:

=over 4



=back

=back

=cut

sub get_relationship_IsAssayOf
{
    my $self = shift;
    my($ids, $from_fields, $rel_fields, $to_fields) = @_;

    my @_bad_arguments;
    (ref($ids) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"ids\" (value was \"$ids\")");
    (ref($from_fields) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"from_fields\" (value was \"$from_fields\")");
    (ref($rel_fields) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"rel_fields\" (value was \"$rel_fields\")");
    (ref($to_fields) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"to_fields\" (value was \"$to_fields\")");
    if (@_bad_arguments) {
	my $msg = "Invalid arguments passed to get_relationship_IsAssayOf:\n" . join("", map { "\t$_\n" } @_bad_arguments);
	Bio::KBase::Exceptions::ArgumentValidationError->throw(error => $msg,
							       method_name => 'get_relationship_IsAssayOf');
    }

    my $ctx = $Bio::KBase::CDMI::Service::CallContext;
    my($return);
    #BEGIN get_relationship_IsAssayOf

    $return = $self->_get_relationship($ctx, 'IsAssayOf', 'IsAssayOf', 0, $ids, $from_fields, $rel_fields, $to_fields);
	
    #END get_relationship_IsAssayOf
    my @_bad_returns;
    (ref($return) eq 'ARRAY') or push(@_bad_returns, "Invalid type for return variable \"return\" (value was \"$return\")");
    if (@_bad_returns) {
	my $msg = "Invalid returns passed to get_relationship_IsAssayOf:\n" . join("", map { "\t$_\n" } @_bad_returns);
	Bio::KBase::Exceptions::ArgumentValidationError->throw(error => $msg,
							       method_name => 'get_relationship_IsAssayOf');
    }
    return($return);
}




=head2 get_relationship_IsAssayedBy

  $return = $obj->get_relationship_IsAssayedBy($ids, $from_fields, $rel_fields, $to_fields)

=over 4

=item Parameter and return types

=begin html

<pre>
$ids is a reference to a list where each element is a string
$from_fields is a reference to a list where each element is a string
$rel_fields is a reference to a list where each element is a string
$to_fields is a reference to a list where each element is a string
$return is a reference to a list where each element is a reference to a list containing 3 items:
	0: a fields_StudyExperiment
	1: a fields_IsAssayOf
	2: a fields_Assay
fields_StudyExperiment is a reference to a hash where the following keys are defined:
	id has a value which is a string
	source_name has a value which is a string
	design has a value which is a string
	originator has a value which is a string
fields_IsAssayOf is a reference to a hash where the following keys are defined:
	id has a value which is a string
fields_Assay is a reference to a hash where the following keys are defined:
	id has a value which is a string
	source_id has a value which is a string
	assay_type has a value which is a string
	assay_type_id has a value which is a string

</pre>

=end html

=begin text

$ids is a reference to a list where each element is a string
$from_fields is a reference to a list where each element is a string
$rel_fields is a reference to a list where each element is a string
$to_fields is a reference to a list where each element is a string
$return is a reference to a list where each element is a reference to a list containing 3 items:
	0: a fields_StudyExperiment
	1: a fields_IsAssayOf
	2: a fields_Assay
fields_StudyExperiment is a reference to a hash where the following keys are defined:
	id has a value which is a string
	source_name has a value which is a string
	design has a value which is a string
	originator has a value which is a string
fields_IsAssayOf is a reference to a hash where the following keys are defined:
	id has a value which is a string
fields_Assay is a reference to a hash where the following keys are defined:
	id has a value which is a string
	source_id has a value which is a string
	assay_type has a value which is a string
	assay_type_id has a value which is a string


=end text



=item Description



=back

=cut

sub get_relationship_IsAssayedBy
{
    my $self = shift;
    my($ids, $from_fields, $rel_fields, $to_fields) = @_;

    my @_bad_arguments;
    (ref($ids) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"ids\" (value was \"$ids\")");
    (ref($from_fields) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"from_fields\" (value was \"$from_fields\")");
    (ref($rel_fields) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"rel_fields\" (value was \"$rel_fields\")");
    (ref($to_fields) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"to_fields\" (value was \"$to_fields\")");
    if (@_bad_arguments) {
	my $msg = "Invalid arguments passed to get_relationship_IsAssayedBy:\n" . join("", map { "\t$_\n" } @_bad_arguments);
	Bio::KBase::Exceptions::ArgumentValidationError->throw(error => $msg,
							       method_name => 'get_relationship_IsAssayedBy');
    }

    my $ctx = $Bio::KBase::CDMI::Service::CallContext;
    my($return);
    #BEGIN get_relationship_IsAssayedBy

    $return = $self->_get_relationship($ctx, 'IsAssayedBy', 'IsAssayOf', 1, $ids, $from_fields, $rel_fields, $to_fields);
	
    #END get_relationship_IsAssayedBy
    my @_bad_returns;
    (ref($return) eq 'ARRAY') or push(@_bad_returns, "Invalid type for return variable \"return\" (value was \"$return\")");
    if (@_bad_returns) {
	my $msg = "Invalid returns passed to get_relationship_IsAssayedBy:\n" . join("", map { "\t$_\n" } @_bad_returns);
	Bio::KBase::Exceptions::ArgumentValidationError->throw(error => $msg,
							       method_name => 'get_relationship_IsAssayedBy');
    }
    return($return);
}




=head2 get_relationship_IsClassFor

  $return = $obj->get_relationship_IsClassFor($ids, $from_fields, $rel_fields, $to_fields)

=over 4

=item Parameter and return types

=begin html

<pre>
$ids is a reference to a list where each element is a string
$from_fields is a reference to a list where each element is a string
$rel_fields is a reference to a list where each element is a string
$to_fields is a reference to a list where each element is a string
$return is a reference to a list where each element is a reference to a list containing 3 items:
	0: a fields_SubsystemClass
	1: a fields_IsClassFor
	2: a fields_Subsystem
fields_SubsystemClass is a reference to a hash where the following keys are defined:
	id has a value which is a string
fields_IsClassFor is a reference to a hash where the following keys are defined:
	id has a value which is a string
fields_Subsystem is a reference to a hash where the following keys are defined:
	id has a value which is a string
	version has a value which is an int
	curator has a value which is a string
	notes has a value which is a string
	description has a value which is a string
	usable has a value which is an int
	private has a value which is an int
	cluster_based has a value which is an int
	experimental has a value which is an int

</pre>

=end html

=begin text

$ids is a reference to a list where each element is a string
$from_fields is a reference to a list where each element is a string
$rel_fields is a reference to a list where each element is a string
$to_fields is a reference to a list where each element is a string
$return is a reference to a list where each element is a reference to a list containing 3 items:
	0: a fields_SubsystemClass
	1: a fields_IsClassFor
	2: a fields_Subsystem
fields_SubsystemClass is a reference to a hash where the following keys are defined:
	id has a value which is a string
fields_IsClassFor is a reference to a hash where the following keys are defined:
	id has a value which is a string
fields_Subsystem is a reference to a hash where the following keys are defined:
	id has a value which is a string
	version has a value which is an int
	curator has a value which is a string
	notes has a value which is a string
	description has a value which is a string
	usable has a value which is an int
	private has a value which is an int
	cluster_based has a value which is an int
	experimental has a value which is an int


=end text



=item Description

This relationship connects each subsystem class with the
subsystems that belong to it. A class can contain many subsystems,
but a subsystem is only in one class. Some subsystems are not in any
class, but this is usually a temporary condition.
It has the following fields:

=over 4



=back

=back

=cut

sub get_relationship_IsClassFor
{
    my $self = shift;
    my($ids, $from_fields, $rel_fields, $to_fields) = @_;

    my @_bad_arguments;
    (ref($ids) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"ids\" (value was \"$ids\")");
    (ref($from_fields) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"from_fields\" (value was \"$from_fields\")");
    (ref($rel_fields) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"rel_fields\" (value was \"$rel_fields\")");
    (ref($to_fields) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"to_fields\" (value was \"$to_fields\")");
    if (@_bad_arguments) {
	my $msg = "Invalid arguments passed to get_relationship_IsClassFor:\n" . join("", map { "\t$_\n" } @_bad_arguments);
	Bio::KBase::Exceptions::ArgumentValidationError->throw(error => $msg,
							       method_name => 'get_relationship_IsClassFor');
    }

    my $ctx = $Bio::KBase::CDMI::Service::CallContext;
    my($return);
    #BEGIN get_relationship_IsClassFor

    $return = $self->_get_relationship($ctx, 'IsClassFor', 'IsClassFor', 0, $ids, $from_fields, $rel_fields, $to_fields);
	
    #END get_relationship_IsClassFor
    my @_bad_returns;
    (ref($return) eq 'ARRAY') or push(@_bad_returns, "Invalid type for return variable \"return\" (value was \"$return\")");
    if (@_bad_returns) {
	my $msg = "Invalid returns passed to get_relationship_IsClassFor:\n" . join("", map { "\t$_\n" } @_bad_returns);
	Bio::KBase::Exceptions::ArgumentValidationError->throw(error => $msg,
							       method_name => 'get_relationship_IsClassFor');
    }
    return($return);
}




=head2 get_relationship_IsInClass

  $return = $obj->get_relationship_IsInClass($ids, $from_fields, $rel_fields, $to_fields)

=over 4

=item Parameter and return types

=begin html

<pre>
$ids is a reference to a list where each element is a string
$from_fields is a reference to a list where each element is a string
$rel_fields is a reference to a list where each element is a string
$to_fields is a reference to a list where each element is a string
$return is a reference to a list where each element is a reference to a list containing 3 items:
	0: a fields_Subsystem
	1: a fields_IsClassFor
	2: a fields_SubsystemClass
fields_Subsystem is a reference to a hash where the following keys are defined:
	id has a value which is a string
	version has a value which is an int
	curator has a value which is a string
	notes has a value which is a string
	description has a value which is a string
	usable has a value which is an int
	private has a value which is an int
	cluster_based has a value which is an int
	experimental has a value which is an int
fields_IsClassFor is a reference to a hash where the following keys are defined:
	id has a value which is a string
fields_SubsystemClass is a reference to a hash where the following keys are defined:
	id has a value which is a string

</pre>

=end html

=begin text

$ids is a reference to a list where each element is a string
$from_fields is a reference to a list where each element is a string
$rel_fields is a reference to a list where each element is a string
$to_fields is a reference to a list where each element is a string
$return is a reference to a list where each element is a reference to a list containing 3 items:
	0: a fields_Subsystem
	1: a fields_IsClassFor
	2: a fields_SubsystemClass
fields_Subsystem is a reference to a hash where the following keys are defined:
	id has a value which is a string
	version has a value which is an int
	curator has a value which is a string
	notes has a value which is a string
	description has a value which is a string
	usable has a value which is an int
	private has a value which is an int
	cluster_based has a value which is an int
	experimental has a value which is an int
fields_IsClassFor is a reference to a hash where the following keys are defined:
	id has a value which is a string
fields_SubsystemClass is a reference to a hash where the following keys are defined:
	id has a value which is a string


=end text



=item Description



=back

=cut

sub get_relationship_IsInClass
{
    my $self = shift;
    my($ids, $from_fields, $rel_fields, $to_fields) = @_;

    my @_bad_arguments;
    (ref($ids) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"ids\" (value was \"$ids\")");
    (ref($from_fields) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"from_fields\" (value was \"$from_fields\")");
    (ref($rel_fields) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"rel_fields\" (value was \"$rel_fields\")");
    (ref($to_fields) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"to_fields\" (value was \"$to_fields\")");
    if (@_bad_arguments) {
	my $msg = "Invalid arguments passed to get_relationship_IsInClass:\n" . join("", map { "\t$_\n" } @_bad_arguments);
	Bio::KBase::Exceptions::ArgumentValidationError->throw(error => $msg,
							       method_name => 'get_relationship_IsInClass');
    }

    my $ctx = $Bio::KBase::CDMI::Service::CallContext;
    my($return);
    #BEGIN get_relationship_IsInClass

    $return = $self->_get_relationship($ctx, 'IsInClass', 'IsClassFor', 1, $ids, $from_fields, $rel_fields, $to_fields);
	
    #END get_relationship_IsInClass
    my @_bad_returns;
    (ref($return) eq 'ARRAY') or push(@_bad_returns, "Invalid type for return variable \"return\" (value was \"$return\")");
    if (@_bad_returns) {
	my $msg = "Invalid returns passed to get_relationship_IsInClass:\n" . join("", map { "\t$_\n" } @_bad_returns);
	Bio::KBase::Exceptions::ArgumentValidationError->throw(error => $msg,
							       method_name => 'get_relationship_IsInClass');
    }
    return($return);
}




=head2 get_relationship_IsCollectionOf

  $return = $obj->get_relationship_IsCollectionOf($ids, $from_fields, $rel_fields, $to_fields)

=over 4

=item Parameter and return types

=begin html

<pre>
$ids is a reference to a list where each element is a string
$from_fields is a reference to a list where each element is a string
$rel_fields is a reference to a list where each element is a string
$to_fields is a reference to a list where each element is a string
$return is a reference to a list where each element is a reference to a list containing 3 items:
	0: a fields_OTU
	1: a fields_IsCollectionOf
	2: a fields_Genome
fields_OTU is a reference to a hash where the following keys are defined:
	id has a value which is a string
fields_IsCollectionOf is a reference to a hash where the following keys are defined:
	id has a value which is a string
	representative has a value which is an int
fields_Genome is a reference to a hash where the following keys are defined:
	id has a value which is a string
	pegs has a value which is an int
	rnas has a value which is an int
	scientific_name has a value which is a string
	complete has a value which is an int
	prokaryotic has a value which is an int
	dna_size has a value which is an int
	contigs has a value which is an int
	domain has a value which is a string
	genetic_code has a value which is an int
	gc_content has a value which is a float
	phenotype has a value which is a reference to a list where each element is a string
	md5 has a value which is a string
	source_id has a value which is a string

</pre>

=end html

=begin text

$ids is a reference to a list where each element is a string
$from_fields is a reference to a list where each element is a string
$rel_fields is a reference to a list where each element is a string
$to_fields is a reference to a list where each element is a string
$return is a reference to a list where each element is a reference to a list containing 3 items:
	0: a fields_OTU
	1: a fields_IsCollectionOf
	2: a fields_Genome
fields_OTU is a reference to a hash where the following keys are defined:
	id has a value which is a string
fields_IsCollectionOf is a reference to a hash where the following keys are defined:
	id has a value which is a string
	representative has a value which is an int
fields_Genome is a reference to a hash where the following keys are defined:
	id has a value which is a string
	pegs has a value which is an int
	rnas has a value which is an int
	scientific_name has a value which is a string
	complete has a value which is an int
	prokaryotic has a value which is an int
	dna_size has a value which is an int
	contigs has a value which is an int
	domain has a value which is a string
	genetic_code has a value which is an int
	gc_content has a value which is a float
	phenotype has a value which is a reference to a list where each element is a string
	md5 has a value which is a string
	source_id has a value which is a string


=end text



=item Description

A genome belongs to only one genome set. For each set, this relationship marks the genome to be used as its representative.
It has the following fields:

=over 4


=item representative

TRUE for the representative genome of the set, else FALSE.



=back

=back

=cut

sub get_relationship_IsCollectionOf
{
    my $self = shift;
    my($ids, $from_fields, $rel_fields, $to_fields) = @_;

    my @_bad_arguments;
    (ref($ids) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"ids\" (value was \"$ids\")");
    (ref($from_fields) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"from_fields\" (value was \"$from_fields\")");
    (ref($rel_fields) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"rel_fields\" (value was \"$rel_fields\")");
    (ref($to_fields) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"to_fields\" (value was \"$to_fields\")");
    if (@_bad_arguments) {
	my $msg = "Invalid arguments passed to get_relationship_IsCollectionOf:\n" . join("", map { "\t$_\n" } @_bad_arguments);
	Bio::KBase::Exceptions::ArgumentValidationError->throw(error => $msg,
							       method_name => 'get_relationship_IsCollectionOf');
    }

    my $ctx = $Bio::KBase::CDMI::Service::CallContext;
    my($return);
    #BEGIN get_relationship_IsCollectionOf

    $return = $self->_get_relationship($ctx, 'IsCollectionOf', 'IsCollectionOf', 0, $ids, $from_fields, $rel_fields, $to_fields);
	
    #END get_relationship_IsCollectionOf
    my @_bad_returns;
    (ref($return) eq 'ARRAY') or push(@_bad_returns, "Invalid type for return variable \"return\" (value was \"$return\")");
    if (@_bad_returns) {
	my $msg = "Invalid returns passed to get_relationship_IsCollectionOf:\n" . join("", map { "\t$_\n" } @_bad_returns);
	Bio::KBase::Exceptions::ArgumentValidationError->throw(error => $msg,
							       method_name => 'get_relationship_IsCollectionOf');
    }
    return($return);
}




=head2 get_relationship_IsCollectedInto

  $return = $obj->get_relationship_IsCollectedInto($ids, $from_fields, $rel_fields, $to_fields)

=over 4

=item Parameter and return types

=begin html

<pre>
$ids is a reference to a list where each element is a string
$from_fields is a reference to a list where each element is a string
$rel_fields is a reference to a list where each element is a string
$to_fields is a reference to a list where each element is a string
$return is a reference to a list where each element is a reference to a list containing 3 items:
	0: a fields_Genome
	1: a fields_IsCollectionOf
	2: a fields_OTU
fields_Genome is a reference to a hash where the following keys are defined:
	id has a value which is a string
	pegs has a value which is an int
	rnas has a value which is an int
	scientific_name has a value which is a string
	complete has a value which is an int
	prokaryotic has a value which is an int
	dna_size has a value which is an int
	contigs has a value which is an int
	domain has a value which is a string
	genetic_code has a value which is an int
	gc_content has a value which is a float
	phenotype has a value which is a reference to a list where each element is a string
	md5 has a value which is a string
	source_id has a value which is a string
fields_IsCollectionOf is a reference to a hash where the following keys are defined:
	id has a value which is a string
	representative has a value which is an int
fields_OTU is a reference to a hash where the following keys are defined:
	id has a value which is a string

</pre>

=end html

=begin text

$ids is a reference to a list where each element is a string
$from_fields is a reference to a list where each element is a string
$rel_fields is a reference to a list where each element is a string
$to_fields is a reference to a list where each element is a string
$return is a reference to a list where each element is a reference to a list containing 3 items:
	0: a fields_Genome
	1: a fields_IsCollectionOf
	2: a fields_OTU
fields_Genome is a reference to a hash where the following keys are defined:
	id has a value which is a string
	pegs has a value which is an int
	rnas has a value which is an int
	scientific_name has a value which is a string
	complete has a value which is an int
	prokaryotic has a value which is an int
	dna_size has a value which is an int
	contigs has a value which is an int
	domain has a value which is a string
	genetic_code has a value which is an int
	gc_content has a value which is a float
	phenotype has a value which is a reference to a list where each element is a string
	md5 has a value which is a string
	source_id has a value which is a string
fields_IsCollectionOf is a reference to a hash where the following keys are defined:
	id has a value which is a string
	representative has a value which is an int
fields_OTU is a reference to a hash where the following keys are defined:
	id has a value which is a string


=end text



=item Description



=back

=cut

sub get_relationship_IsCollectedInto
{
    my $self = shift;
    my($ids, $from_fields, $rel_fields, $to_fields) = @_;

    my @_bad_arguments;
    (ref($ids) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"ids\" (value was \"$ids\")");
    (ref($from_fields) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"from_fields\" (value was \"$from_fields\")");
    (ref($rel_fields) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"rel_fields\" (value was \"$rel_fields\")");
    (ref($to_fields) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"to_fields\" (value was \"$to_fields\")");
    if (@_bad_arguments) {
	my $msg = "Invalid arguments passed to get_relationship_IsCollectedInto:\n" . join("", map { "\t$_\n" } @_bad_arguments);
	Bio::KBase::Exceptions::ArgumentValidationError->throw(error => $msg,
							       method_name => 'get_relationship_IsCollectedInto');
    }

    my $ctx = $Bio::KBase::CDMI::Service::CallContext;
    my($return);
    #BEGIN get_relationship_IsCollectedInto

    $return = $self->_get_relationship($ctx, 'IsCollectedInto', 'IsCollectionOf', 1, $ids, $from_fields, $rel_fields, $to_fields);
	
    #END get_relationship_IsCollectedInto
    my @_bad_returns;
    (ref($return) eq 'ARRAY') or push(@_bad_returns, "Invalid type for return variable \"return\" (value was \"$return\")");
    if (@_bad_returns) {
	my $msg = "Invalid returns passed to get_relationship_IsCollectedInto:\n" . join("", map { "\t$_\n" } @_bad_returns);
	Bio::KBase::Exceptions::ArgumentValidationError->throw(error => $msg,
							       method_name => 'get_relationship_IsCollectedInto');
    }
    return($return);
}




=head2 get_relationship_IsComposedOf

  $return = $obj->get_relationship_IsComposedOf($ids, $from_fields, $rel_fields, $to_fields)

=over 4

=item Parameter and return types

=begin html

<pre>
$ids is a reference to a list where each element is a string
$from_fields is a reference to a list where each element is a string
$rel_fields is a reference to a list where each element is a string
$to_fields is a reference to a list where each element is a string
$return is a reference to a list where each element is a reference to a list containing 3 items:
	0: a fields_Genome
	1: a fields_IsComposedOf
	2: a fields_Contig
fields_Genome is a reference to a hash where the following keys are defined:
	id has a value which is a string
	pegs has a value which is an int
	rnas has a value which is an int
	scientific_name has a value which is a string
	complete has a value which is an int
	prokaryotic has a value which is an int
	dna_size has a value which is an int
	contigs has a value which is an int
	domain has a value which is a string
	genetic_code has a value which is an int
	gc_content has a value which is a float
	phenotype has a value which is a reference to a list where each element is a string
	md5 has a value which is a string
	source_id has a value which is a string
fields_IsComposedOf is a reference to a hash where the following keys are defined:
	id has a value which is a string
fields_Contig is a reference to a hash where the following keys are defined:
	id has a value which is a string
	source_id has a value which is a string

</pre>

=end html

=begin text

$ids is a reference to a list where each element is a string
$from_fields is a reference to a list where each element is a string
$rel_fields is a reference to a list where each element is a string
$to_fields is a reference to a list where each element is a string
$return is a reference to a list where each element is a reference to a list containing 3 items:
	0: a fields_Genome
	1: a fields_IsComposedOf
	2: a fields_Contig
fields_Genome is a reference to a hash where the following keys are defined:
	id has a value which is a string
	pegs has a value which is an int
	rnas has a value which is an int
	scientific_name has a value which is a string
	complete has a value which is an int
	prokaryotic has a value which is an int
	dna_size has a value which is an int
	contigs has a value which is an int
	domain has a value which is a string
	genetic_code has a value which is an int
	gc_content has a value which is a float
	phenotype has a value which is a reference to a list where each element is a string
	md5 has a value which is a string
	source_id has a value which is a string
fields_IsComposedOf is a reference to a hash where the following keys are defined:
	id has a value which is a string
fields_Contig is a reference to a hash where the following keys are defined:
	id has a value which is a string
	source_id has a value which is a string


=end text



=item Description

This relationship connects a genome to its
constituent contigs. Unlike contig sequences, a
contig belongs to only one genome.
It has the following fields:

=over 4



=back

=back

=cut

sub get_relationship_IsComposedOf
{
    my $self = shift;
    my($ids, $from_fields, $rel_fields, $to_fields) = @_;

    my @_bad_arguments;
    (ref($ids) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"ids\" (value was \"$ids\")");
    (ref($from_fields) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"from_fields\" (value was \"$from_fields\")");
    (ref($rel_fields) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"rel_fields\" (value was \"$rel_fields\")");
    (ref($to_fields) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"to_fields\" (value was \"$to_fields\")");
    if (@_bad_arguments) {
	my $msg = "Invalid arguments passed to get_relationship_IsComposedOf:\n" . join("", map { "\t$_\n" } @_bad_arguments);
	Bio::KBase::Exceptions::ArgumentValidationError->throw(error => $msg,
							       method_name => 'get_relationship_IsComposedOf');
    }

    my $ctx = $Bio::KBase::CDMI::Service::CallContext;
    my($return);
    #BEGIN get_relationship_IsComposedOf

    $return = $self->_get_relationship($ctx, 'IsComposedOf', 'IsComposedOf', 0, $ids, $from_fields, $rel_fields, $to_fields);
	
    #END get_relationship_IsComposedOf
    my @_bad_returns;
    (ref($return) eq 'ARRAY') or push(@_bad_returns, "Invalid type for return variable \"return\" (value was \"$return\")");
    if (@_bad_returns) {
	my $msg = "Invalid returns passed to get_relationship_IsComposedOf:\n" . join("", map { "\t$_\n" } @_bad_returns);
	Bio::KBase::Exceptions::ArgumentValidationError->throw(error => $msg,
							       method_name => 'get_relationship_IsComposedOf');
    }
    return($return);
}




=head2 get_relationship_IsComponentOf

  $return = $obj->get_relationship_IsComponentOf($ids, $from_fields, $rel_fields, $to_fields)

=over 4

=item Parameter and return types

=begin html

<pre>
$ids is a reference to a list where each element is a string
$from_fields is a reference to a list where each element is a string
$rel_fields is a reference to a list where each element is a string
$to_fields is a reference to a list where each element is a string
$return is a reference to a list where each element is a reference to a list containing 3 items:
	0: a fields_Contig
	1: a fields_IsComposedOf
	2: a fields_Genome
fields_Contig is a reference to a hash where the following keys are defined:
	id has a value which is a string
	source_id has a value which is a string
fields_IsComposedOf is a reference to a hash where the following keys are defined:
	id has a value which is a string
fields_Genome is a reference to a hash where the following keys are defined:
	id has a value which is a string
	pegs has a value which is an int
	rnas has a value which is an int
	scientific_name has a value which is a string
	complete has a value which is an int
	prokaryotic has a value which is an int
	dna_size has a value which is an int
	contigs has a value which is an int
	domain has a value which is a string
	genetic_code has a value which is an int
	gc_content has a value which is a float
	phenotype has a value which is a reference to a list where each element is a string
	md5 has a value which is a string
	source_id has a value which is a string

</pre>

=end html

=begin text

$ids is a reference to a list where each element is a string
$from_fields is a reference to a list where each element is a string
$rel_fields is a reference to a list where each element is a string
$to_fields is a reference to a list where each element is a string
$return is a reference to a list where each element is a reference to a list containing 3 items:
	0: a fields_Contig
	1: a fields_IsComposedOf
	2: a fields_Genome
fields_Contig is a reference to a hash where the following keys are defined:
	id has a value which is a string
	source_id has a value which is a string
fields_IsComposedOf is a reference to a hash where the following keys are defined:
	id has a value which is a string
fields_Genome is a reference to a hash where the following keys are defined:
	id has a value which is a string
	pegs has a value which is an int
	rnas has a value which is an int
	scientific_name has a value which is a string
	complete has a value which is an int
	prokaryotic has a value which is an int
	dna_size has a value which is an int
	contigs has a value which is an int
	domain has a value which is a string
	genetic_code has a value which is an int
	gc_content has a value which is a float
	phenotype has a value which is a reference to a list where each element is a string
	md5 has a value which is a string
	source_id has a value which is a string


=end text



=item Description



=back

=cut

sub get_relationship_IsComponentOf
{
    my $self = shift;
    my($ids, $from_fields, $rel_fields, $to_fields) = @_;

    my @_bad_arguments;
    (ref($ids) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"ids\" (value was \"$ids\")");
    (ref($from_fields) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"from_fields\" (value was \"$from_fields\")");
    (ref($rel_fields) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"rel_fields\" (value was \"$rel_fields\")");
    (ref($to_fields) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"to_fields\" (value was \"$to_fields\")");
    if (@_bad_arguments) {
	my $msg = "Invalid arguments passed to get_relationship_IsComponentOf:\n" . join("", map { "\t$_\n" } @_bad_arguments);
	Bio::KBase::Exceptions::ArgumentValidationError->throw(error => $msg,
							       method_name => 'get_relationship_IsComponentOf');
    }

    my $ctx = $Bio::KBase::CDMI::Service::CallContext;
    my($return);
    #BEGIN get_relationship_IsComponentOf

    $return = $self->_get_relationship($ctx, 'IsComponentOf', 'IsComposedOf', 1, $ids, $from_fields, $rel_fields, $to_fields);
	
    #END get_relationship_IsComponentOf
    my @_bad_returns;
    (ref($return) eq 'ARRAY') or push(@_bad_returns, "Invalid type for return variable \"return\" (value was \"$return\")");
    if (@_bad_returns) {
	my $msg = "Invalid returns passed to get_relationship_IsComponentOf:\n" . join("", map { "\t$_\n" } @_bad_returns);
	Bio::KBase::Exceptions::ArgumentValidationError->throw(error => $msg,
							       method_name => 'get_relationship_IsComponentOf');
    }
    return($return);
}




=head2 get_relationship_IsComprisedOf

  $return = $obj->get_relationship_IsComprisedOf($ids, $from_fields, $rel_fields, $to_fields)

=over 4

=item Parameter and return types

=begin html

<pre>
$ids is a reference to a list where each element is a string
$from_fields is a reference to a list where each element is a string
$rel_fields is a reference to a list where each element is a string
$to_fields is a reference to a list where each element is a string
$return is a reference to a list where each element is a reference to a list containing 3 items:
	0: a fields_Biomass
	1: a fields_IsComprisedOf
	2: a fields_BiomassCompound
fields_Biomass is a reference to a hash where the following keys are defined:
	id has a value which is a string
	mod_date has a value which is a string
	name has a value which is a reference to a list where each element is a string
fields_IsComprisedOf is a reference to a hash where the following keys are defined:
	id has a value which is a string
fields_BiomassCompound is a reference to a hash where the following keys are defined:
	id has a value which is a string
	coefficient has a value which is a float

</pre>

=end html

=begin text

$ids is a reference to a list where each element is a string
$from_fields is a reference to a list where each element is a string
$rel_fields is a reference to a list where each element is a string
$to_fields is a reference to a list where each element is a string
$return is a reference to a list where each element is a reference to a list containing 3 items:
	0: a fields_Biomass
	1: a fields_IsComprisedOf
	2: a fields_BiomassCompound
fields_Biomass is a reference to a hash where the following keys are defined:
	id has a value which is a string
	mod_date has a value which is a string
	name has a value which is a reference to a list where each element is a string
fields_IsComprisedOf is a reference to a hash where the following keys are defined:
	id has a value which is a string
fields_BiomassCompound is a reference to a hash where the following keys are defined:
	id has a value which is a string
	coefficient has a value which is a float


=end text



=item Description

This relationship connects a biomass to the compound
specifications that define it.
It has the following fields:

=over 4



=back

=back

=cut

sub get_relationship_IsComprisedOf
{
    my $self = shift;
    my($ids, $from_fields, $rel_fields, $to_fields) = @_;

    my @_bad_arguments;
    (ref($ids) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"ids\" (value was \"$ids\")");
    (ref($from_fields) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"from_fields\" (value was \"$from_fields\")");
    (ref($rel_fields) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"rel_fields\" (value was \"$rel_fields\")");
    (ref($to_fields) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"to_fields\" (value was \"$to_fields\")");
    if (@_bad_arguments) {
	my $msg = "Invalid arguments passed to get_relationship_IsComprisedOf:\n" . join("", map { "\t$_\n" } @_bad_arguments);
	Bio::KBase::Exceptions::ArgumentValidationError->throw(error => $msg,
							       method_name => 'get_relationship_IsComprisedOf');
    }

    my $ctx = $Bio::KBase::CDMI::Service::CallContext;
    my($return);
    #BEGIN get_relationship_IsComprisedOf

    $return = $self->_get_relationship($ctx, 'IsComprisedOf', 'IsComprisedOf', 0, $ids, $from_fields, $rel_fields, $to_fields);
	
    #END get_relationship_IsComprisedOf
    my @_bad_returns;
    (ref($return) eq 'ARRAY') or push(@_bad_returns, "Invalid type for return variable \"return\" (value was \"$return\")");
    if (@_bad_returns) {
	my $msg = "Invalid returns passed to get_relationship_IsComprisedOf:\n" . join("", map { "\t$_\n" } @_bad_returns);
	Bio::KBase::Exceptions::ArgumentValidationError->throw(error => $msg,
							       method_name => 'get_relationship_IsComprisedOf');
    }
    return($return);
}




=head2 get_relationship_Comprises

  $return = $obj->get_relationship_Comprises($ids, $from_fields, $rel_fields, $to_fields)

=over 4

=item Parameter and return types

=begin html

<pre>
$ids is a reference to a list where each element is a string
$from_fields is a reference to a list where each element is a string
$rel_fields is a reference to a list where each element is a string
$to_fields is a reference to a list where each element is a string
$return is a reference to a list where each element is a reference to a list containing 3 items:
	0: a fields_BiomassCompound
	1: a fields_IsComprisedOf
	2: a fields_Biomass
fields_BiomassCompound is a reference to a hash where the following keys are defined:
	id has a value which is a string
	coefficient has a value which is a float
fields_IsComprisedOf is a reference to a hash where the following keys are defined:
	id has a value which is a string
fields_Biomass is a reference to a hash where the following keys are defined:
	id has a value which is a string
	mod_date has a value which is a string
	name has a value which is a reference to a list where each element is a string

</pre>

=end html

=begin text

$ids is a reference to a list where each element is a string
$from_fields is a reference to a list where each element is a string
$rel_fields is a reference to a list where each element is a string
$to_fields is a reference to a list where each element is a string
$return is a reference to a list where each element is a reference to a list containing 3 items:
	0: a fields_BiomassCompound
	1: a fields_IsComprisedOf
	2: a fields_Biomass
fields_BiomassCompound is a reference to a hash where the following keys are defined:
	id has a value which is a string
	coefficient has a value which is a float
fields_IsComprisedOf is a reference to a hash where the following keys are defined:
	id has a value which is a string
fields_Biomass is a reference to a hash where the following keys are defined:
	id has a value which is a string
	mod_date has a value which is a string
	name has a value which is a reference to a list where each element is a string


=end text



=item Description



=back

=cut

sub get_relationship_Comprises
{
    my $self = shift;
    my($ids, $from_fields, $rel_fields, $to_fields) = @_;

    my @_bad_arguments;
    (ref($ids) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"ids\" (value was \"$ids\")");
    (ref($from_fields) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"from_fields\" (value was \"$from_fields\")");
    (ref($rel_fields) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"rel_fields\" (value was \"$rel_fields\")");
    (ref($to_fields) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"to_fields\" (value was \"$to_fields\")");
    if (@_bad_arguments) {
	my $msg = "Invalid arguments passed to get_relationship_Comprises:\n" . join("", map { "\t$_\n" } @_bad_arguments);
	Bio::KBase::Exceptions::ArgumentValidationError->throw(error => $msg,
							       method_name => 'get_relationship_Comprises');
    }

    my $ctx = $Bio::KBase::CDMI::Service::CallContext;
    my($return);
    #BEGIN get_relationship_Comprises

    $return = $self->_get_relationship($ctx, 'Comprises', 'IsComprisedOf', 1, $ids, $from_fields, $rel_fields, $to_fields);
	
    #END get_relationship_Comprises
    my @_bad_returns;
    (ref($return) eq 'ARRAY') or push(@_bad_returns, "Invalid type for return variable \"return\" (value was \"$return\")");
    if (@_bad_returns) {
	my $msg = "Invalid returns passed to get_relationship_Comprises:\n" . join("", map { "\t$_\n" } @_bad_returns);
	Bio::KBase::Exceptions::ArgumentValidationError->throw(error => $msg,
							       method_name => 'get_relationship_Comprises');
    }
    return($return);
}




=head2 get_relationship_IsConfiguredBy

  $return = $obj->get_relationship_IsConfiguredBy($ids, $from_fields, $rel_fields, $to_fields)

=over 4

=item Parameter and return types

=begin html

<pre>
$ids is a reference to a list where each element is a string
$from_fields is a reference to a list where each element is a string
$rel_fields is a reference to a list where each element is a string
$to_fields is a reference to a list where each element is a string
$return is a reference to a list where each element is a reference to a list containing 3 items:
	0: a fields_Genome
	1: a fields_IsConfiguredBy
	2: a fields_AtomicRegulon
fields_Genome is a reference to a hash where the following keys are defined:
	id has a value which is a string
	pegs has a value which is an int
	rnas has a value which is an int
	scientific_name has a value which is a string
	complete has a value which is an int
	prokaryotic has a value which is an int
	dna_size has a value which is an int
	contigs has a value which is an int
	domain has a value which is a string
	genetic_code has a value which is an int
	gc_content has a value which is a float
	phenotype has a value which is a reference to a list where each element is a string
	md5 has a value which is a string
	source_id has a value which is a string
fields_IsConfiguredBy is a reference to a hash where the following keys are defined:
	id has a value which is a string
fields_AtomicRegulon is a reference to a hash where the following keys are defined:
	id has a value which is a string

</pre>

=end html

=begin text

$ids is a reference to a list where each element is a string
$from_fields is a reference to a list where each element is a string
$rel_fields is a reference to a list where each element is a string
$to_fields is a reference to a list where each element is a string
$return is a reference to a list where each element is a reference to a list containing 3 items:
	0: a fields_Genome
	1: a fields_IsConfiguredBy
	2: a fields_AtomicRegulon
fields_Genome is a reference to a hash where the following keys are defined:
	id has a value which is a string
	pegs has a value which is an int
	rnas has a value which is an int
	scientific_name has a value which is a string
	complete has a value which is an int
	prokaryotic has a value which is an int
	dna_size has a value which is an int
	contigs has a value which is an int
	domain has a value which is a string
	genetic_code has a value which is an int
	gc_content has a value which is a float
	phenotype has a value which is a reference to a list where each element is a string
	md5 has a value which is a string
	source_id has a value which is a string
fields_IsConfiguredBy is a reference to a hash where the following keys are defined:
	id has a value which is a string
fields_AtomicRegulon is a reference to a hash where the following keys are defined:
	id has a value which is a string


=end text



=item Description

This relationship connects a genome to the atomic regulons that
describe its state.
It has the following fields:

=over 4



=back

=back

=cut

sub get_relationship_IsConfiguredBy
{
    my $self = shift;
    my($ids, $from_fields, $rel_fields, $to_fields) = @_;

    my @_bad_arguments;
    (ref($ids) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"ids\" (value was \"$ids\")");
    (ref($from_fields) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"from_fields\" (value was \"$from_fields\")");
    (ref($rel_fields) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"rel_fields\" (value was \"$rel_fields\")");
    (ref($to_fields) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"to_fields\" (value was \"$to_fields\")");
    if (@_bad_arguments) {
	my $msg = "Invalid arguments passed to get_relationship_IsConfiguredBy:\n" . join("", map { "\t$_\n" } @_bad_arguments);
	Bio::KBase::Exceptions::ArgumentValidationError->throw(error => $msg,
							       method_name => 'get_relationship_IsConfiguredBy');
    }

    my $ctx = $Bio::KBase::CDMI::Service::CallContext;
    my($return);
    #BEGIN get_relationship_IsConfiguredBy

    $return = $self->_get_relationship($ctx, 'IsConfiguredBy', 'IsConfiguredBy', 0, $ids, $from_fields, $rel_fields, $to_fields);
	
    #END get_relationship_IsConfiguredBy
    my @_bad_returns;
    (ref($return) eq 'ARRAY') or push(@_bad_returns, "Invalid type for return variable \"return\" (value was \"$return\")");
    if (@_bad_returns) {
	my $msg = "Invalid returns passed to get_relationship_IsConfiguredBy:\n" . join("", map { "\t$_\n" } @_bad_returns);
	Bio::KBase::Exceptions::ArgumentValidationError->throw(error => $msg,
							       method_name => 'get_relationship_IsConfiguredBy');
    }
    return($return);
}




=head2 get_relationship_ReflectsStateOf

  $return = $obj->get_relationship_ReflectsStateOf($ids, $from_fields, $rel_fields, $to_fields)

=over 4

=item Parameter and return types

=begin html

<pre>
$ids is a reference to a list where each element is a string
$from_fields is a reference to a list where each element is a string
$rel_fields is a reference to a list where each element is a string
$to_fields is a reference to a list where each element is a string
$return is a reference to a list where each element is a reference to a list containing 3 items:
	0: a fields_AtomicRegulon
	1: a fields_IsConfiguredBy
	2: a fields_Genome
fields_AtomicRegulon is a reference to a hash where the following keys are defined:
	id has a value which is a string
fields_IsConfiguredBy is a reference to a hash where the following keys are defined:
	id has a value which is a string
fields_Genome is a reference to a hash where the following keys are defined:
	id has a value which is a string
	pegs has a value which is an int
	rnas has a value which is an int
	scientific_name has a value which is a string
	complete has a value which is an int
	prokaryotic has a value which is an int
	dna_size has a value which is an int
	contigs has a value which is an int
	domain has a value which is a string
	genetic_code has a value which is an int
	gc_content has a value which is a float
	phenotype has a value which is a reference to a list where each element is a string
	md5 has a value which is a string
	source_id has a value which is a string

</pre>

=end html

=begin text

$ids is a reference to a list where each element is a string
$from_fields is a reference to a list where each element is a string
$rel_fields is a reference to a list where each element is a string
$to_fields is a reference to a list where each element is a string
$return is a reference to a list where each element is a reference to a list containing 3 items:
	0: a fields_AtomicRegulon
	1: a fields_IsConfiguredBy
	2: a fields_Genome
fields_AtomicRegulon is a reference to a hash where the following keys are defined:
	id has a value which is a string
fields_IsConfiguredBy is a reference to a hash where the following keys are defined:
	id has a value which is a string
fields_Genome is a reference to a hash where the following keys are defined:
	id has a value which is a string
	pegs has a value which is an int
	rnas has a value which is an int
	scientific_name has a value which is a string
	complete has a value which is an int
	prokaryotic has a value which is an int
	dna_size has a value which is an int
	contigs has a value which is an int
	domain has a value which is a string
	genetic_code has a value which is an int
	gc_content has a value which is a float
	phenotype has a value which is a reference to a list where each element is a string
	md5 has a value which is a string
	source_id has a value which is a string


=end text



=item Description



=back

=cut

sub get_relationship_ReflectsStateOf
{
    my $self = shift;
    my($ids, $from_fields, $rel_fields, $to_fields) = @_;

    my @_bad_arguments;
    (ref($ids) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"ids\" (value was \"$ids\")");
    (ref($from_fields) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"from_fields\" (value was \"$from_fields\")");
    (ref($rel_fields) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"rel_fields\" (value was \"$rel_fields\")");
    (ref($to_fields) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"to_fields\" (value was \"$to_fields\")");
    if (@_bad_arguments) {
	my $msg = "Invalid arguments passed to get_relationship_ReflectsStateOf:\n" . join("", map { "\t$_\n" } @_bad_arguments);
	Bio::KBase::Exceptions::ArgumentValidationError->throw(error => $msg,
							       method_name => 'get_relationship_ReflectsStateOf');
    }

    my $ctx = $Bio::KBase::CDMI::Service::CallContext;
    my($return);
    #BEGIN get_relationship_ReflectsStateOf

    $return = $self->_get_relationship($ctx, 'ReflectsStateOf', 'IsConfiguredBy', 1, $ids, $from_fields, $rel_fields, $to_fields);
	
    #END get_relationship_ReflectsStateOf
    my @_bad_returns;
    (ref($return) eq 'ARRAY') or push(@_bad_returns, "Invalid type for return variable \"return\" (value was \"$return\")");
    if (@_bad_returns) {
	my $msg = "Invalid returns passed to get_relationship_ReflectsStateOf:\n" . join("", map { "\t$_\n" } @_bad_returns);
	Bio::KBase::Exceptions::ArgumentValidationError->throw(error => $msg,
							       method_name => 'get_relationship_ReflectsStateOf');
    }
    return($return);
}




=head2 get_relationship_IsConsistentWith

  $return = $obj->get_relationship_IsConsistentWith($ids, $from_fields, $rel_fields, $to_fields)

=over 4

=item Parameter and return types

=begin html

<pre>
$ids is a reference to a list where each element is a string
$from_fields is a reference to a list where each element is a string
$rel_fields is a reference to a list where each element is a string
$to_fields is a reference to a list where each element is a string
$return is a reference to a list where each element is a reference to a list containing 3 items:
	0: a fields_EcNumber
	1: a fields_IsConsistentWith
	2: a fields_Role
fields_EcNumber is a reference to a hash where the following keys are defined:
	id has a value which is a string
	obsolete has a value which is an int
	replacedby has a value which is a string
fields_IsConsistentWith is a reference to a hash where the following keys are defined:
	id has a value which is a string
fields_Role is a reference to a hash where the following keys are defined:
	id has a value which is a string
	hypothetical has a value which is an int

</pre>

=end html

=begin text

$ids is a reference to a list where each element is a string
$from_fields is a reference to a list where each element is a string
$rel_fields is a reference to a list where each element is a string
$to_fields is a reference to a list where each element is a string
$return is a reference to a list where each element is a reference to a list containing 3 items:
	0: a fields_EcNumber
	1: a fields_IsConsistentWith
	2: a fields_Role
fields_EcNumber is a reference to a hash where the following keys are defined:
	id has a value which is a string
	obsolete has a value which is an int
	replacedby has a value which is a string
fields_IsConsistentWith is a reference to a hash where the following keys are defined:
	id has a value which is a string
fields_Role is a reference to a hash where the following keys are defined:
	id has a value which is a string
	hypothetical has a value which is an int


=end text



=item Description

This relationship connects a functional role to the EC numbers consistent
with the chemistry described in the role.
It has the following fields:

=over 4



=back

=back

=cut

sub get_relationship_IsConsistentWith
{
    my $self = shift;
    my($ids, $from_fields, $rel_fields, $to_fields) = @_;

    my @_bad_arguments;
    (ref($ids) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"ids\" (value was \"$ids\")");
    (ref($from_fields) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"from_fields\" (value was \"$from_fields\")");
    (ref($rel_fields) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"rel_fields\" (value was \"$rel_fields\")");
    (ref($to_fields) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"to_fields\" (value was \"$to_fields\")");
    if (@_bad_arguments) {
	my $msg = "Invalid arguments passed to get_relationship_IsConsistentWith:\n" . join("", map { "\t$_\n" } @_bad_arguments);
	Bio::KBase::Exceptions::ArgumentValidationError->throw(error => $msg,
							       method_name => 'get_relationship_IsConsistentWith');
    }

    my $ctx = $Bio::KBase::CDMI::Service::CallContext;
    my($return);
    #BEGIN get_relationship_IsConsistentWith

    $return = $self->_get_relationship($ctx, 'IsConsistentWith', 'IsConsistentWith', 0, $ids, $from_fields, $rel_fields, $to_fields);
	
    #END get_relationship_IsConsistentWith
    my @_bad_returns;
    (ref($return) eq 'ARRAY') or push(@_bad_returns, "Invalid type for return variable \"return\" (value was \"$return\")");
    if (@_bad_returns) {
	my $msg = "Invalid returns passed to get_relationship_IsConsistentWith:\n" . join("", map { "\t$_\n" } @_bad_returns);
	Bio::KBase::Exceptions::ArgumentValidationError->throw(error => $msg,
							       method_name => 'get_relationship_IsConsistentWith');
    }
    return($return);
}




=head2 get_relationship_IsConsistentTo

  $return = $obj->get_relationship_IsConsistentTo($ids, $from_fields, $rel_fields, $to_fields)

=over 4

=item Parameter and return types

=begin html

<pre>
$ids is a reference to a list where each element is a string
$from_fields is a reference to a list where each element is a string
$rel_fields is a reference to a list where each element is a string
$to_fields is a reference to a list where each element is a string
$return is a reference to a list where each element is a reference to a list containing 3 items:
	0: a fields_Role
	1: a fields_IsConsistentWith
	2: a fields_EcNumber
fields_Role is a reference to a hash where the following keys are defined:
	id has a value which is a string
	hypothetical has a value which is an int
fields_IsConsistentWith is a reference to a hash where the following keys are defined:
	id has a value which is a string
fields_EcNumber is a reference to a hash where the following keys are defined:
	id has a value which is a string
	obsolete has a value which is an int
	replacedby has a value which is a string

</pre>

=end html

=begin text

$ids is a reference to a list where each element is a string
$from_fields is a reference to a list where each element is a string
$rel_fields is a reference to a list where each element is a string
$to_fields is a reference to a list where each element is a string
$return is a reference to a list where each element is a reference to a list containing 3 items:
	0: a fields_Role
	1: a fields_IsConsistentWith
	2: a fields_EcNumber
fields_Role is a reference to a hash where the following keys are defined:
	id has a value which is a string
	hypothetical has a value which is an int
fields_IsConsistentWith is a reference to a hash where the following keys are defined:
	id has a value which is a string
fields_EcNumber is a reference to a hash where the following keys are defined:
	id has a value which is a string
	obsolete has a value which is an int
	replacedby has a value which is a string


=end text



=item Description



=back

=cut

sub get_relationship_IsConsistentTo
{
    my $self = shift;
    my($ids, $from_fields, $rel_fields, $to_fields) = @_;

    my @_bad_arguments;
    (ref($ids) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"ids\" (value was \"$ids\")");
    (ref($from_fields) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"from_fields\" (value was \"$from_fields\")");
    (ref($rel_fields) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"rel_fields\" (value was \"$rel_fields\")");
    (ref($to_fields) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"to_fields\" (value was \"$to_fields\")");
    if (@_bad_arguments) {
	my $msg = "Invalid arguments passed to get_relationship_IsConsistentTo:\n" . join("", map { "\t$_\n" } @_bad_arguments);
	Bio::KBase::Exceptions::ArgumentValidationError->throw(error => $msg,
							       method_name => 'get_relationship_IsConsistentTo');
    }

    my $ctx = $Bio::KBase::CDMI::Service::CallContext;
    my($return);
    #BEGIN get_relationship_IsConsistentTo

    $return = $self->_get_relationship($ctx, 'IsConsistentTo', 'IsConsistentWith', 1, $ids, $from_fields, $rel_fields, $to_fields);
	
    #END get_relationship_IsConsistentTo
    my @_bad_returns;
    (ref($return) eq 'ARRAY') or push(@_bad_returns, "Invalid type for return variable \"return\" (value was \"$return\")");
    if (@_bad_returns) {
	my $msg = "Invalid returns passed to get_relationship_IsConsistentTo:\n" . join("", map { "\t$_\n" } @_bad_returns);
	Bio::KBase::Exceptions::ArgumentValidationError->throw(error => $msg,
							       method_name => 'get_relationship_IsConsistentTo');
    }
    return($return);
}




=head2 get_relationship_IsCoregulatedWith

  $return = $obj->get_relationship_IsCoregulatedWith($ids, $from_fields, $rel_fields, $to_fields)

=over 4

=item Parameter and return types

=begin html

<pre>
$ids is a reference to a list where each element is a string
$from_fields is a reference to a list where each element is a string
$rel_fields is a reference to a list where each element is a string
$to_fields is a reference to a list where each element is a string
$return is a reference to a list where each element is a reference to a list containing 3 items:
	0: a fields_Feature
	1: a fields_IsCoregulatedWith
	2: a fields_Feature
fields_Feature is a reference to a hash where the following keys are defined:
	id has a value which is a string
	feature_type has a value which is a string
	source_id has a value which is a string
	sequence_length has a value which is an int
	function has a value which is a string
	alias has a value which is a reference to a list where each element is a string
fields_IsCoregulatedWith is a reference to a hash where the following keys are defined:
	id has a value which is a string
	coefficient has a value which is a float

</pre>

=end html

=begin text

$ids is a reference to a list where each element is a string
$from_fields is a reference to a list where each element is a string
$rel_fields is a reference to a list where each element is a string
$to_fields is a reference to a list where each element is a string
$return is a reference to a list where each element is a reference to a list containing 3 items:
	0: a fields_Feature
	1: a fields_IsCoregulatedWith
	2: a fields_Feature
fields_Feature is a reference to a hash where the following keys are defined:
	id has a value which is a string
	feature_type has a value which is a string
	source_id has a value which is a string
	sequence_length has a value which is an int
	function has a value which is a string
	alias has a value which is a reference to a list where each element is a string
fields_IsCoregulatedWith is a reference to a hash where the following keys are defined:
	id has a value which is a string
	coefficient has a value which is a float


=end text



=item Description

This relationship connects a feature with another feature in the
same genome with which it appears to be coregulated as a result of
expression data analysis.
It has the following fields:

=over 4


=item coefficient

Pearson correlation coefficient for this coregulation.



=back

=back

=cut

sub get_relationship_IsCoregulatedWith
{
    my $self = shift;
    my($ids, $from_fields, $rel_fields, $to_fields) = @_;

    my @_bad_arguments;
    (ref($ids) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"ids\" (value was \"$ids\")");
    (ref($from_fields) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"from_fields\" (value was \"$from_fields\")");
    (ref($rel_fields) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"rel_fields\" (value was \"$rel_fields\")");
    (ref($to_fields) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"to_fields\" (value was \"$to_fields\")");
    if (@_bad_arguments) {
	my $msg = "Invalid arguments passed to get_relationship_IsCoregulatedWith:\n" . join("", map { "\t$_\n" } @_bad_arguments);
	Bio::KBase::Exceptions::ArgumentValidationError->throw(error => $msg,
							       method_name => 'get_relationship_IsCoregulatedWith');
    }

    my $ctx = $Bio::KBase::CDMI::Service::CallContext;
    my($return);
    #BEGIN get_relationship_IsCoregulatedWith

    $return = $self->_get_relationship($ctx, 'IsCoregulatedWith', 'IsCoregulatedWith', 0, $ids, $from_fields, $rel_fields, $to_fields);
	
    #END get_relationship_IsCoregulatedWith
    my @_bad_returns;
    (ref($return) eq 'ARRAY') or push(@_bad_returns, "Invalid type for return variable \"return\" (value was \"$return\")");
    if (@_bad_returns) {
	my $msg = "Invalid returns passed to get_relationship_IsCoregulatedWith:\n" . join("", map { "\t$_\n" } @_bad_returns);
	Bio::KBase::Exceptions::ArgumentValidationError->throw(error => $msg,
							       method_name => 'get_relationship_IsCoregulatedWith');
    }
    return($return);
}




=head2 get_relationship_HasCoregulationWith

  $return = $obj->get_relationship_HasCoregulationWith($ids, $from_fields, $rel_fields, $to_fields)

=over 4

=item Parameter and return types

=begin html

<pre>
$ids is a reference to a list where each element is a string
$from_fields is a reference to a list where each element is a string
$rel_fields is a reference to a list where each element is a string
$to_fields is a reference to a list where each element is a string
$return is a reference to a list where each element is a reference to a list containing 3 items:
	0: a fields_Feature
	1: a fields_IsCoregulatedWith
	2: a fields_Feature
fields_Feature is a reference to a hash where the following keys are defined:
	id has a value which is a string
	feature_type has a value which is a string
	source_id has a value which is a string
	sequence_length has a value which is an int
	function has a value which is a string
	alias has a value which is a reference to a list where each element is a string
fields_IsCoregulatedWith is a reference to a hash where the following keys are defined:
	id has a value which is a string
	coefficient has a value which is a float

</pre>

=end html

=begin text

$ids is a reference to a list where each element is a string
$from_fields is a reference to a list where each element is a string
$rel_fields is a reference to a list where each element is a string
$to_fields is a reference to a list where each element is a string
$return is a reference to a list where each element is a reference to a list containing 3 items:
	0: a fields_Feature
	1: a fields_IsCoregulatedWith
	2: a fields_Feature
fields_Feature is a reference to a hash where the following keys are defined:
	id has a value which is a string
	feature_type has a value which is a string
	source_id has a value which is a string
	sequence_length has a value which is an int
	function has a value which is a string
	alias has a value which is a reference to a list where each element is a string
fields_IsCoregulatedWith is a reference to a hash where the following keys are defined:
	id has a value which is a string
	coefficient has a value which is a float


=end text



=item Description



=back

=cut

sub get_relationship_HasCoregulationWith
{
    my $self = shift;
    my($ids, $from_fields, $rel_fields, $to_fields) = @_;

    my @_bad_arguments;
    (ref($ids) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"ids\" (value was \"$ids\")");
    (ref($from_fields) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"from_fields\" (value was \"$from_fields\")");
    (ref($rel_fields) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"rel_fields\" (value was \"$rel_fields\")");
    (ref($to_fields) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"to_fields\" (value was \"$to_fields\")");
    if (@_bad_arguments) {
	my $msg = "Invalid arguments passed to get_relationship_HasCoregulationWith:\n" . join("", map { "\t$_\n" } @_bad_arguments);
	Bio::KBase::Exceptions::ArgumentValidationError->throw(error => $msg,
							       method_name => 'get_relationship_HasCoregulationWith');
    }

    my $ctx = $Bio::KBase::CDMI::Service::CallContext;
    my($return);
    #BEGIN get_relationship_HasCoregulationWith

    $return = $self->_get_relationship($ctx, 'HasCoregulationWith', 'IsCoregulatedWith', 1, $ids, $from_fields, $rel_fields, $to_fields);
	
    #END get_relationship_HasCoregulationWith
    my @_bad_returns;
    (ref($return) eq 'ARRAY') or push(@_bad_returns, "Invalid type for return variable \"return\" (value was \"$return\")");
    if (@_bad_returns) {
	my $msg = "Invalid returns passed to get_relationship_HasCoregulationWith:\n" . join("", map { "\t$_\n" } @_bad_returns);
	Bio::KBase::Exceptions::ArgumentValidationError->throw(error => $msg,
							       method_name => 'get_relationship_HasCoregulationWith');
    }
    return($return);
}




=head2 get_relationship_IsCoupledTo

  $return = $obj->get_relationship_IsCoupledTo($ids, $from_fields, $rel_fields, $to_fields)

=over 4

=item Parameter and return types

=begin html

<pre>
$ids is a reference to a list where each element is a string
$from_fields is a reference to a list where each element is a string
$rel_fields is a reference to a list where each element is a string
$to_fields is a reference to a list where each element is a string
$return is a reference to a list where each element is a reference to a list containing 3 items:
	0: a fields_Family
	1: a fields_IsCoupledTo
	2: a fields_Family
fields_Family is a reference to a hash where the following keys are defined:
	id has a value which is a string
	type has a value which is a string
	release has a value which is a string
	family_function has a value which is a reference to a list where each element is a string
	alignment has a value which is a reference to a list where each element is a string
fields_IsCoupledTo is a reference to a hash where the following keys are defined:
	id has a value which is a string
	co_occurrence_evidence has a value which is an int
	co_expression_evidence has a value which is an int

</pre>

=end html

=begin text

$ids is a reference to a list where each element is a string
$from_fields is a reference to a list where each element is a string
$rel_fields is a reference to a list where each element is a string
$to_fields is a reference to a list where each element is a string
$return is a reference to a list where each element is a reference to a list containing 3 items:
	0: a fields_Family
	1: a fields_IsCoupledTo
	2: a fields_Family
fields_Family is a reference to a hash where the following keys are defined:
	id has a value which is a string
	type has a value which is a string
	release has a value which is a string
	family_function has a value which is a reference to a list where each element is a string
	alignment has a value which is a reference to a list where each element is a string
fields_IsCoupledTo is a reference to a hash where the following keys are defined:
	id has a value which is a string
	co_occurrence_evidence has a value which is an int
	co_expression_evidence has a value which is an int


=end text



=item Description

This relationship connects two FIGfams that we believe to be related
either because their members occur in proximity on chromosomes or because
the members are expressed together. Such a relationship is evidence the
functions of the FIGfams are themselves related. This relationship is
commutative; only the instance in which the first FIGfam has a lower ID
than the second is stored.
It has the following fields:

=over 4


=item co_occurrence_evidence

number of times members of the two FIGfams occur close to each
other on chromosomes


=item co_expression_evidence

number of times members of the two FIGfams are co-expressed in
expression data experiments



=back

=back

=cut

sub get_relationship_IsCoupledTo
{
    my $self = shift;
    my($ids, $from_fields, $rel_fields, $to_fields) = @_;

    my @_bad_arguments;
    (ref($ids) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"ids\" (value was \"$ids\")");
    (ref($from_fields) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"from_fields\" (value was \"$from_fields\")");
    (ref($rel_fields) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"rel_fields\" (value was \"$rel_fields\")");
    (ref($to_fields) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"to_fields\" (value was \"$to_fields\")");
    if (@_bad_arguments) {
	my $msg = "Invalid arguments passed to get_relationship_IsCoupledTo:\n" . join("", map { "\t$_\n" } @_bad_arguments);
	Bio::KBase::Exceptions::ArgumentValidationError->throw(error => $msg,
							       method_name => 'get_relationship_IsCoupledTo');
    }

    my $ctx = $Bio::KBase::CDMI::Service::CallContext;
    my($return);
    #BEGIN get_relationship_IsCoupledTo

    $return = $self->_get_relationship($ctx, 'IsCoupledTo', 'IsCoupledTo', 0, $ids, $from_fields, $rel_fields, $to_fields);
	
    #END get_relationship_IsCoupledTo
    my @_bad_returns;
    (ref($return) eq 'ARRAY') or push(@_bad_returns, "Invalid type for return variable \"return\" (value was \"$return\")");
    if (@_bad_returns) {
	my $msg = "Invalid returns passed to get_relationship_IsCoupledTo:\n" . join("", map { "\t$_\n" } @_bad_returns);
	Bio::KBase::Exceptions::ArgumentValidationError->throw(error => $msg,
							       method_name => 'get_relationship_IsCoupledTo');
    }
    return($return);
}




=head2 get_relationship_IsCoupledWith

  $return = $obj->get_relationship_IsCoupledWith($ids, $from_fields, $rel_fields, $to_fields)

=over 4

=item Parameter and return types

=begin html

<pre>
$ids is a reference to a list where each element is a string
$from_fields is a reference to a list where each element is a string
$rel_fields is a reference to a list where each element is a string
$to_fields is a reference to a list where each element is a string
$return is a reference to a list where each element is a reference to a list containing 3 items:
	0: a fields_Family
	1: a fields_IsCoupledTo
	2: a fields_Family
fields_Family is a reference to a hash where the following keys are defined:
	id has a value which is a string
	type has a value which is a string
	release has a value which is a string
	family_function has a value which is a reference to a list where each element is a string
	alignment has a value which is a reference to a list where each element is a string
fields_IsCoupledTo is a reference to a hash where the following keys are defined:
	id has a value which is a string
	co_occurrence_evidence has a value which is an int
	co_expression_evidence has a value which is an int

</pre>

=end html

=begin text

$ids is a reference to a list where each element is a string
$from_fields is a reference to a list where each element is a string
$rel_fields is a reference to a list where each element is a string
$to_fields is a reference to a list where each element is a string
$return is a reference to a list where each element is a reference to a list containing 3 items:
	0: a fields_Family
	1: a fields_IsCoupledTo
	2: a fields_Family
fields_Family is a reference to a hash where the following keys are defined:
	id has a value which is a string
	type has a value which is a string
	release has a value which is a string
	family_function has a value which is a reference to a list where each element is a string
	alignment has a value which is a reference to a list where each element is a string
fields_IsCoupledTo is a reference to a hash where the following keys are defined:
	id has a value which is a string
	co_occurrence_evidence has a value which is an int
	co_expression_evidence has a value which is an int


=end text



=item Description



=back

=cut

sub get_relationship_IsCoupledWith
{
    my $self = shift;
    my($ids, $from_fields, $rel_fields, $to_fields) = @_;

    my @_bad_arguments;
    (ref($ids) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"ids\" (value was \"$ids\")");
    (ref($from_fields) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"from_fields\" (value was \"$from_fields\")");
    (ref($rel_fields) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"rel_fields\" (value was \"$rel_fields\")");
    (ref($to_fields) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"to_fields\" (value was \"$to_fields\")");
    if (@_bad_arguments) {
	my $msg = "Invalid arguments passed to get_relationship_IsCoupledWith:\n" . join("", map { "\t$_\n" } @_bad_arguments);
	Bio::KBase::Exceptions::ArgumentValidationError->throw(error => $msg,
							       method_name => 'get_relationship_IsCoupledWith');
    }

    my $ctx = $Bio::KBase::CDMI::Service::CallContext;
    my($return);
    #BEGIN get_relationship_IsCoupledWith

    $return = $self->_get_relationship($ctx, 'IsCoupledWith', 'IsCoupledTo', 1, $ids, $from_fields, $rel_fields, $to_fields);
	
    #END get_relationship_IsCoupledWith
    my @_bad_returns;
    (ref($return) eq 'ARRAY') or push(@_bad_returns, "Invalid type for return variable \"return\" (value was \"$return\")");
    if (@_bad_returns) {
	my $msg = "Invalid returns passed to get_relationship_IsCoupledWith:\n" . join("", map { "\t$_\n" } @_bad_returns);
	Bio::KBase::Exceptions::ArgumentValidationError->throw(error => $msg,
							       method_name => 'get_relationship_IsCoupledWith');
    }
    return($return);
}




=head2 get_relationship_IsDefaultFor

  $return = $obj->get_relationship_IsDefaultFor($ids, $from_fields, $rel_fields, $to_fields)

=over 4

=item Parameter and return types

=begin html

<pre>
$ids is a reference to a list where each element is a string
$from_fields is a reference to a list where each element is a string
$rel_fields is a reference to a list where each element is a string
$to_fields is a reference to a list where each element is a string
$return is a reference to a list where each element is a reference to a list containing 3 items:
	0: a fields_Compartment
	1: a fields_IsDefaultFor
	2: a fields_Reaction
fields_Compartment is a reference to a hash where the following keys are defined:
	id has a value which is a string
	abbr has a value which is a string
	mod_date has a value which is a string
	name has a value which is a string
	msid has a value which is a string
fields_IsDefaultFor is a reference to a hash where the following keys are defined:
	id has a value which is a string
fields_Reaction is a reference to a hash where the following keys are defined:
	id has a value which is a string
	mod_date has a value which is a string
	name has a value which is a string
	msid has a value which is a string
	abbr has a value which is a string
	equation has a value which is a string
	reversibility has a value which is a string

</pre>

=end html

=begin text

$ids is a reference to a list where each element is a string
$from_fields is a reference to a list where each element is a string
$rel_fields is a reference to a list where each element is a string
$to_fields is a reference to a list where each element is a string
$return is a reference to a list where each element is a reference to a list containing 3 items:
	0: a fields_Compartment
	1: a fields_IsDefaultFor
	2: a fields_Reaction
fields_Compartment is a reference to a hash where the following keys are defined:
	id has a value which is a string
	abbr has a value which is a string
	mod_date has a value which is a string
	name has a value which is a string
	msid has a value which is a string
fields_IsDefaultFor is a reference to a hash where the following keys are defined:
	id has a value which is a string
fields_Reaction is a reference to a hash where the following keys are defined:
	id has a value which is a string
	mod_date has a value which is a string
	name has a value which is a string
	msid has a value which is a string
	abbr has a value which is a string
	equation has a value which is a string
	reversibility has a value which is a string


=end text



=item Description

This relationship connects a reaction to the compartment
in which it runs by default.
It has the following fields:

=over 4



=back

=back

=cut

sub get_relationship_IsDefaultFor
{
    my $self = shift;
    my($ids, $from_fields, $rel_fields, $to_fields) = @_;

    my @_bad_arguments;
    (ref($ids) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"ids\" (value was \"$ids\")");
    (ref($from_fields) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"from_fields\" (value was \"$from_fields\")");
    (ref($rel_fields) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"rel_fields\" (value was \"$rel_fields\")");
    (ref($to_fields) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"to_fields\" (value was \"$to_fields\")");
    if (@_bad_arguments) {
	my $msg = "Invalid arguments passed to get_relationship_IsDefaultFor:\n" . join("", map { "\t$_\n" } @_bad_arguments);
	Bio::KBase::Exceptions::ArgumentValidationError->throw(error => $msg,
							       method_name => 'get_relationship_IsDefaultFor');
    }

    my $ctx = $Bio::KBase::CDMI::Service::CallContext;
    my($return);
    #BEGIN get_relationship_IsDefaultFor

    $return = $self->_get_relationship($ctx, 'IsDefaultFor', 'IsDefaultFor', 0, $ids, $from_fields, $rel_fields, $to_fields);
	
    #END get_relationship_IsDefaultFor
    my @_bad_returns;
    (ref($return) eq 'ARRAY') or push(@_bad_returns, "Invalid type for return variable \"return\" (value was \"$return\")");
    if (@_bad_returns) {
	my $msg = "Invalid returns passed to get_relationship_IsDefaultFor:\n" . join("", map { "\t$_\n" } @_bad_returns);
	Bio::KBase::Exceptions::ArgumentValidationError->throw(error => $msg,
							       method_name => 'get_relationship_IsDefaultFor');
    }
    return($return);
}




=head2 get_relationship_RunsByDefaultIn

  $return = $obj->get_relationship_RunsByDefaultIn($ids, $from_fields, $rel_fields, $to_fields)

=over 4

=item Parameter and return types

=begin html

<pre>
$ids is a reference to a list where each element is a string
$from_fields is a reference to a list where each element is a string
$rel_fields is a reference to a list where each element is a string
$to_fields is a reference to a list where each element is a string
$return is a reference to a list where each element is a reference to a list containing 3 items:
	0: a fields_Reaction
	1: a fields_IsDefaultFor
	2: a fields_Compartment
fields_Reaction is a reference to a hash where the following keys are defined:
	id has a value which is a string
	mod_date has a value which is a string
	name has a value which is a string
	msid has a value which is a string
	abbr has a value which is a string
	equation has a value which is a string
	reversibility has a value which is a string
fields_IsDefaultFor is a reference to a hash where the following keys are defined:
	id has a value which is a string
fields_Compartment is a reference to a hash where the following keys are defined:
	id has a value which is a string
	abbr has a value which is a string
	mod_date has a value which is a string
	name has a value which is a string
	msid has a value which is a string

</pre>

=end html

=begin text

$ids is a reference to a list where each element is a string
$from_fields is a reference to a list where each element is a string
$rel_fields is a reference to a list where each element is a string
$to_fields is a reference to a list where each element is a string
$return is a reference to a list where each element is a reference to a list containing 3 items:
	0: a fields_Reaction
	1: a fields_IsDefaultFor
	2: a fields_Compartment
fields_Reaction is a reference to a hash where the following keys are defined:
	id has a value which is a string
	mod_date has a value which is a string
	name has a value which is a string
	msid has a value which is a string
	abbr has a value which is a string
	equation has a value which is a string
	reversibility has a value which is a string
fields_IsDefaultFor is a reference to a hash where the following keys are defined:
	id has a value which is a string
fields_Compartment is a reference to a hash where the following keys are defined:
	id has a value which is a string
	abbr has a value which is a string
	mod_date has a value which is a string
	name has a value which is a string
	msid has a value which is a string


=end text



=item Description



=back

=cut

sub get_relationship_RunsByDefaultIn
{
    my $self = shift;
    my($ids, $from_fields, $rel_fields, $to_fields) = @_;

    my @_bad_arguments;
    (ref($ids) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"ids\" (value was \"$ids\")");
    (ref($from_fields) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"from_fields\" (value was \"$from_fields\")");
    (ref($rel_fields) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"rel_fields\" (value was \"$rel_fields\")");
    (ref($to_fields) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"to_fields\" (value was \"$to_fields\")");
    if (@_bad_arguments) {
	my $msg = "Invalid arguments passed to get_relationship_RunsByDefaultIn:\n" . join("", map { "\t$_\n" } @_bad_arguments);
	Bio::KBase::Exceptions::ArgumentValidationError->throw(error => $msg,
							       method_name => 'get_relationship_RunsByDefaultIn');
    }

    my $ctx = $Bio::KBase::CDMI::Service::CallContext;
    my($return);
    #BEGIN get_relationship_RunsByDefaultIn

    $return = $self->_get_relationship($ctx, 'RunsByDefaultIn', 'IsDefaultFor', 1, $ids, $from_fields, $rel_fields, $to_fields);
	
    #END get_relationship_RunsByDefaultIn
    my @_bad_returns;
    (ref($return) eq 'ARRAY') or push(@_bad_returns, "Invalid type for return variable \"return\" (value was \"$return\")");
    if (@_bad_returns) {
	my $msg = "Invalid returns passed to get_relationship_RunsByDefaultIn:\n" . join("", map { "\t$_\n" } @_bad_returns);
	Bio::KBase::Exceptions::ArgumentValidationError->throw(error => $msg,
							       method_name => 'get_relationship_RunsByDefaultIn');
    }
    return($return);
}




=head2 get_relationship_IsDefaultLocationOf

  $return = $obj->get_relationship_IsDefaultLocationOf($ids, $from_fields, $rel_fields, $to_fields)

=over 4

=item Parameter and return types

=begin html

<pre>
$ids is a reference to a list where each element is a string
$from_fields is a reference to a list where each element is a string
$rel_fields is a reference to a list where each element is a string
$to_fields is a reference to a list where each element is a string
$return is a reference to a list where each element is a reference to a list containing 3 items:
	0: a fields_Compartment
	1: a fields_IsDefaultLocationOf
	2: a fields_Reagent
fields_Compartment is a reference to a hash where the following keys are defined:
	id has a value which is a string
	abbr has a value which is a string
	mod_date has a value which is a string
	name has a value which is a string
	msid has a value which is a string
fields_IsDefaultLocationOf is a reference to a hash where the following keys are defined:
	id has a value which is a string
fields_Reagent is a reference to a hash where the following keys are defined:
	id has a value which is a string
	stoichiometry has a value which is a float
	cofactor has a value which is an int
	compartment_index has a value which is an int
	transport_coefficient has a value which is a float

</pre>

=end html

=begin text

$ids is a reference to a list where each element is a string
$from_fields is a reference to a list where each element is a string
$rel_fields is a reference to a list where each element is a string
$to_fields is a reference to a list where each element is a string
$return is a reference to a list where each element is a reference to a list containing 3 items:
	0: a fields_Compartment
	1: a fields_IsDefaultLocationOf
	2: a fields_Reagent
fields_Compartment is a reference to a hash where the following keys are defined:
	id has a value which is a string
	abbr has a value which is a string
	mod_date has a value which is a string
	name has a value which is a string
	msid has a value which is a string
fields_IsDefaultLocationOf is a reference to a hash where the following keys are defined:
	id has a value which is a string
fields_Reagent is a reference to a hash where the following keys are defined:
	id has a value which is a string
	stoichiometry has a value which is a float
	cofactor has a value which is an int
	compartment_index has a value which is an int
	transport_coefficient has a value which is a float


=end text



=item Description

This relationship connects a reagent to the compartment
which is its default location during the reaction.
It has the following fields:

=over 4



=back

=back

=cut

sub get_relationship_IsDefaultLocationOf
{
    my $self = shift;
    my($ids, $from_fields, $rel_fields, $to_fields) = @_;

    my @_bad_arguments;
    (ref($ids) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"ids\" (value was \"$ids\")");
    (ref($from_fields) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"from_fields\" (value was \"$from_fields\")");
    (ref($rel_fields) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"rel_fields\" (value was \"$rel_fields\")");
    (ref($to_fields) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"to_fields\" (value was \"$to_fields\")");
    if (@_bad_arguments) {
	my $msg = "Invalid arguments passed to get_relationship_IsDefaultLocationOf:\n" . join("", map { "\t$_\n" } @_bad_arguments);
	Bio::KBase::Exceptions::ArgumentValidationError->throw(error => $msg,
							       method_name => 'get_relationship_IsDefaultLocationOf');
    }

    my $ctx = $Bio::KBase::CDMI::Service::CallContext;
    my($return);
    #BEGIN get_relationship_IsDefaultLocationOf

    $return = $self->_get_relationship($ctx, 'IsDefaultLocationOf', 'IsDefaultLocationOf', 0, $ids, $from_fields, $rel_fields, $to_fields);
	
    #END get_relationship_IsDefaultLocationOf
    my @_bad_returns;
    (ref($return) eq 'ARRAY') or push(@_bad_returns, "Invalid type for return variable \"return\" (value was \"$return\")");
    if (@_bad_returns) {
	my $msg = "Invalid returns passed to get_relationship_IsDefaultLocationOf:\n" . join("", map { "\t$_\n" } @_bad_returns);
	Bio::KBase::Exceptions::ArgumentValidationError->throw(error => $msg,
							       method_name => 'get_relationship_IsDefaultLocationOf');
    }
    return($return);
}




=head2 get_relationship_HasDefaultLocation

  $return = $obj->get_relationship_HasDefaultLocation($ids, $from_fields, $rel_fields, $to_fields)

=over 4

=item Parameter and return types

=begin html

<pre>
$ids is a reference to a list where each element is a string
$from_fields is a reference to a list where each element is a string
$rel_fields is a reference to a list where each element is a string
$to_fields is a reference to a list where each element is a string
$return is a reference to a list where each element is a reference to a list containing 3 items:
	0: a fields_Reagent
	1: a fields_IsDefaultLocationOf
	2: a fields_Compartment
fields_Reagent is a reference to a hash where the following keys are defined:
	id has a value which is a string
	stoichiometry has a value which is a float
	cofactor has a value which is an int
	compartment_index has a value which is an int
	transport_coefficient has a value which is a float
fields_IsDefaultLocationOf is a reference to a hash where the following keys are defined:
	id has a value which is a string
fields_Compartment is a reference to a hash where the following keys are defined:
	id has a value which is a string
	abbr has a value which is a string
	mod_date has a value which is a string
	name has a value which is a string
	msid has a value which is a string

</pre>

=end html

=begin text

$ids is a reference to a list where each element is a string
$from_fields is a reference to a list where each element is a string
$rel_fields is a reference to a list where each element is a string
$to_fields is a reference to a list where each element is a string
$return is a reference to a list where each element is a reference to a list containing 3 items:
	0: a fields_Reagent
	1: a fields_IsDefaultLocationOf
	2: a fields_Compartment
fields_Reagent is a reference to a hash where the following keys are defined:
	id has a value which is a string
	stoichiometry has a value which is a float
	cofactor has a value which is an int
	compartment_index has a value which is an int
	transport_coefficient has a value which is a float
fields_IsDefaultLocationOf is a reference to a hash where the following keys are defined:
	id has a value which is a string
fields_Compartment is a reference to a hash where the following keys are defined:
	id has a value which is a string
	abbr has a value which is a string
	mod_date has a value which is a string
	name has a value which is a string
	msid has a value which is a string


=end text



=item Description



=back

=cut

sub get_relationship_HasDefaultLocation
{
    my $self = shift;
    my($ids, $from_fields, $rel_fields, $to_fields) = @_;

    my @_bad_arguments;
    (ref($ids) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"ids\" (value was \"$ids\")");
    (ref($from_fields) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"from_fields\" (value was \"$from_fields\")");
    (ref($rel_fields) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"rel_fields\" (value was \"$rel_fields\")");
    (ref($to_fields) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"to_fields\" (value was \"$to_fields\")");
    if (@_bad_arguments) {
	my $msg = "Invalid arguments passed to get_relationship_HasDefaultLocation:\n" . join("", map { "\t$_\n" } @_bad_arguments);
	Bio::KBase::Exceptions::ArgumentValidationError->throw(error => $msg,
							       method_name => 'get_relationship_HasDefaultLocation');
    }

    my $ctx = $Bio::KBase::CDMI::Service::CallContext;
    my($return);
    #BEGIN get_relationship_HasDefaultLocation

    $return = $self->_get_relationship($ctx, 'HasDefaultLocation', 'IsDefaultLocationOf', 1, $ids, $from_fields, $rel_fields, $to_fields);
	
    #END get_relationship_HasDefaultLocation
    my @_bad_returns;
    (ref($return) eq 'ARRAY') or push(@_bad_returns, "Invalid type for return variable \"return\" (value was \"$return\")");
    if (@_bad_returns) {
	my $msg = "Invalid returns passed to get_relationship_HasDefaultLocation:\n" . join("", map { "\t$_\n" } @_bad_returns);
	Bio::KBase::Exceptions::ArgumentValidationError->throw(error => $msg,
							       method_name => 'get_relationship_HasDefaultLocation');
    }
    return($return);
}




=head2 get_relationship_IsDeterminedBy

  $return = $obj->get_relationship_IsDeterminedBy($ids, $from_fields, $rel_fields, $to_fields)

=over 4

=item Parameter and return types

=begin html

<pre>
$ids is a reference to a list where each element is a string
$from_fields is a reference to a list where each element is a string
$rel_fields is a reference to a list where each element is a string
$to_fields is a reference to a list where each element is a string
$return is a reference to a list where each element is a reference to a list containing 3 items:
	0: a fields_PairSet
	1: a fields_IsDeterminedBy
	2: a fields_Pairing
fields_PairSet is a reference to a hash where the following keys are defined:
	id has a value which is a string
	score has a value which is an int
fields_IsDeterminedBy is a reference to a hash where the following keys are defined:
	id has a value which is a string
	inverted has a value which is an int
fields_Pairing is a reference to a hash where the following keys are defined:
	id has a value which is a string

</pre>

=end html

=begin text

$ids is a reference to a list where each element is a string
$from_fields is a reference to a list where each element is a string
$rel_fields is a reference to a list where each element is a string
$to_fields is a reference to a list where each element is a string
$return is a reference to a list where each element is a reference to a list containing 3 items:
	0: a fields_PairSet
	1: a fields_IsDeterminedBy
	2: a fields_Pairing
fields_PairSet is a reference to a hash where the following keys are defined:
	id has a value which is a string
	score has a value which is an int
fields_IsDeterminedBy is a reference to a hash where the following keys are defined:
	id has a value which is a string
	inverted has a value which is an int
fields_Pairing is a reference to a hash where the following keys are defined:
	id has a value which is a string


=end text



=item Description

A functional coupling evidence set exists because it has
pairings in it, and this relationship connects the evidence set to
its constituent pairings. A pairing cam belong to multiple evidence
sets.
It has the following fields:

=over 4


=item inverted

A pairing is an unordered pair of protein sequences,
but its similarity to other pairings in a pair set is
ordered. Let (A,B) be a pairing and (X,Y) be another pairing
in the same set. If this flag is FALSE, then (A =~ X) and (B
=~ Y). If this flag is TRUE, then (A =~ Y) and (B =~
X).



=back

=back

=cut

sub get_relationship_IsDeterminedBy
{
    my $self = shift;
    my($ids, $from_fields, $rel_fields, $to_fields) = @_;

    my @_bad_arguments;
    (ref($ids) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"ids\" (value was \"$ids\")");
    (ref($from_fields) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"from_fields\" (value was \"$from_fields\")");
    (ref($rel_fields) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"rel_fields\" (value was \"$rel_fields\")");
    (ref($to_fields) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"to_fields\" (value was \"$to_fields\")");
    if (@_bad_arguments) {
	my $msg = "Invalid arguments passed to get_relationship_IsDeterminedBy:\n" . join("", map { "\t$_\n" } @_bad_arguments);
	Bio::KBase::Exceptions::ArgumentValidationError->throw(error => $msg,
							       method_name => 'get_relationship_IsDeterminedBy');
    }

    my $ctx = $Bio::KBase::CDMI::Service::CallContext;
    my($return);
    #BEGIN get_relationship_IsDeterminedBy

    $return = $self->_get_relationship($ctx, 'IsDeterminedBy', 'IsDeterminedBy', 0, $ids, $from_fields, $rel_fields, $to_fields);
	
    #END get_relationship_IsDeterminedBy
    my @_bad_returns;
    (ref($return) eq 'ARRAY') or push(@_bad_returns, "Invalid type for return variable \"return\" (value was \"$return\")");
    if (@_bad_returns) {
	my $msg = "Invalid returns passed to get_relationship_IsDeterminedBy:\n" . join("", map { "\t$_\n" } @_bad_returns);
	Bio::KBase::Exceptions::ArgumentValidationError->throw(error => $msg,
							       method_name => 'get_relationship_IsDeterminedBy');
    }
    return($return);
}




=head2 get_relationship_Determines

  $return = $obj->get_relationship_Determines($ids, $from_fields, $rel_fields, $to_fields)

=over 4

=item Parameter and return types

=begin html

<pre>
$ids is a reference to a list where each element is a string
$from_fields is a reference to a list where each element is a string
$rel_fields is a reference to a list where each element is a string
$to_fields is a reference to a list where each element is a string
$return is a reference to a list where each element is a reference to a list containing 3 items:
	0: a fields_Pairing
	1: a fields_IsDeterminedBy
	2: a fields_PairSet
fields_Pairing is a reference to a hash where the following keys are defined:
	id has a value which is a string
fields_IsDeterminedBy is a reference to a hash where the following keys are defined:
	id has a value which is a string
	inverted has a value which is an int
fields_PairSet is a reference to a hash where the following keys are defined:
	id has a value which is a string
	score has a value which is an int

</pre>

=end html

=begin text

$ids is a reference to a list where each element is a string
$from_fields is a reference to a list where each element is a string
$rel_fields is a reference to a list where each element is a string
$to_fields is a reference to a list where each element is a string
$return is a reference to a list where each element is a reference to a list containing 3 items:
	0: a fields_Pairing
	1: a fields_IsDeterminedBy
	2: a fields_PairSet
fields_Pairing is a reference to a hash where the following keys are defined:
	id has a value which is a string
fields_IsDeterminedBy is a reference to a hash where the following keys are defined:
	id has a value which is a string
	inverted has a value which is an int
fields_PairSet is a reference to a hash where the following keys are defined:
	id has a value which is a string
	score has a value which is an int


=end text



=item Description



=back

=cut

sub get_relationship_Determines
{
    my $self = shift;
    my($ids, $from_fields, $rel_fields, $to_fields) = @_;

    my @_bad_arguments;
    (ref($ids) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"ids\" (value was \"$ids\")");
    (ref($from_fields) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"from_fields\" (value was \"$from_fields\")");
    (ref($rel_fields) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"rel_fields\" (value was \"$rel_fields\")");
    (ref($to_fields) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"to_fields\" (value was \"$to_fields\")");
    if (@_bad_arguments) {
	my $msg = "Invalid arguments passed to get_relationship_Determines:\n" . join("", map { "\t$_\n" } @_bad_arguments);
	Bio::KBase::Exceptions::ArgumentValidationError->throw(error => $msg,
							       method_name => 'get_relationship_Determines');
    }

    my $ctx = $Bio::KBase::CDMI::Service::CallContext;
    my($return);
    #BEGIN get_relationship_Determines

    $return = $self->_get_relationship($ctx, 'Determines', 'IsDeterminedBy', 1, $ids, $from_fields, $rel_fields, $to_fields);
	
    #END get_relationship_Determines
    my @_bad_returns;
    (ref($return) eq 'ARRAY') or push(@_bad_returns, "Invalid type for return variable \"return\" (value was \"$return\")");
    if (@_bad_returns) {
	my $msg = "Invalid returns passed to get_relationship_Determines:\n" . join("", map { "\t$_\n" } @_bad_returns);
	Bio::KBase::Exceptions::ArgumentValidationError->throw(error => $msg,
							       method_name => 'get_relationship_Determines');
    }
    return($return);
}




=head2 get_relationship_IsDividedInto

  $return = $obj->get_relationship_IsDividedInto($ids, $from_fields, $rel_fields, $to_fields)

=over 4

=item Parameter and return types

=begin html

<pre>
$ids is a reference to a list where each element is a string
$from_fields is a reference to a list where each element is a string
$rel_fields is a reference to a list where each element is a string
$to_fields is a reference to a list where each element is a string
$return is a reference to a list where each element is a reference to a list containing 3 items:
	0: a fields_Model
	1: a fields_IsDividedInto
	2: a fields_ModelCompartment
fields_Model is a reference to a hash where the following keys are defined:
	id has a value which is a string
	mod_date has a value which is a string
	name has a value which is a string
	version has a value which is an int
	type has a value which is a string
	status has a value which is a string
	reaction_count has a value which is an int
	compound_count has a value which is an int
	annotation_count has a value which is an int
fields_IsDividedInto is a reference to a hash where the following keys are defined:
	id has a value which is a string
fields_ModelCompartment is a reference to a hash where the following keys are defined:
	id has a value which is a string
	compartment_index has a value which is an int
	label has a value which is a reference to a list where each element is a string
	pH has a value which is a float
	potential has a value which is a float

</pre>

=end html

=begin text

$ids is a reference to a list where each element is a string
$from_fields is a reference to a list where each element is a string
$rel_fields is a reference to a list where each element is a string
$to_fields is a reference to a list where each element is a string
$return is a reference to a list where each element is a reference to a list containing 3 items:
	0: a fields_Model
	1: a fields_IsDividedInto
	2: a fields_ModelCompartment
fields_Model is a reference to a hash where the following keys are defined:
	id has a value which is a string
	mod_date has a value which is a string
	name has a value which is a string
	version has a value which is an int
	type has a value which is a string
	status has a value which is a string
	reaction_count has a value which is an int
	compound_count has a value which is an int
	annotation_count has a value which is an int
fields_IsDividedInto is a reference to a hash where the following keys are defined:
	id has a value which is a string
fields_ModelCompartment is a reference to a hash where the following keys are defined:
	id has a value which is a string
	compartment_index has a value which is an int
	label has a value which is a reference to a list where each element is a string
	pH has a value which is a float
	potential has a value which is a float


=end text



=item Description

This relationship connects a model to the cell compartments
that participate in the model.
It has the following fields:

=over 4



=back

=back

=cut

sub get_relationship_IsDividedInto
{
    my $self = shift;
    my($ids, $from_fields, $rel_fields, $to_fields) = @_;

    my @_bad_arguments;
    (ref($ids) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"ids\" (value was \"$ids\")");
    (ref($from_fields) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"from_fields\" (value was \"$from_fields\")");
    (ref($rel_fields) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"rel_fields\" (value was \"$rel_fields\")");
    (ref($to_fields) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"to_fields\" (value was \"$to_fields\")");
    if (@_bad_arguments) {
	my $msg = "Invalid arguments passed to get_relationship_IsDividedInto:\n" . join("", map { "\t$_\n" } @_bad_arguments);
	Bio::KBase::Exceptions::ArgumentValidationError->throw(error => $msg,
							       method_name => 'get_relationship_IsDividedInto');
    }

    my $ctx = $Bio::KBase::CDMI::Service::CallContext;
    my($return);
    #BEGIN get_relationship_IsDividedInto

    $return = $self->_get_relationship($ctx, 'IsDividedInto', 'IsDividedInto', 0, $ids, $from_fields, $rel_fields, $to_fields);
	
    #END get_relationship_IsDividedInto
    my @_bad_returns;
    (ref($return) eq 'ARRAY') or push(@_bad_returns, "Invalid type for return variable \"return\" (value was \"$return\")");
    if (@_bad_returns) {
	my $msg = "Invalid returns passed to get_relationship_IsDividedInto:\n" . join("", map { "\t$_\n" } @_bad_returns);
	Bio::KBase::Exceptions::ArgumentValidationError->throw(error => $msg,
							       method_name => 'get_relationship_IsDividedInto');
    }
    return($return);
}




=head2 get_relationship_IsDivisionOf

  $return = $obj->get_relationship_IsDivisionOf($ids, $from_fields, $rel_fields, $to_fields)

=over 4

=item Parameter and return types

=begin html

<pre>
$ids is a reference to a list where each element is a string
$from_fields is a reference to a list where each element is a string
$rel_fields is a reference to a list where each element is a string
$to_fields is a reference to a list where each element is a string
$return is a reference to a list where each element is a reference to a list containing 3 items:
	0: a fields_ModelCompartment
	1: a fields_IsDividedInto
	2: a fields_Model
fields_ModelCompartment is a reference to a hash where the following keys are defined:
	id has a value which is a string
	compartment_index has a value which is an int
	label has a value which is a reference to a list where each element is a string
	pH has a value which is a float
	potential has a value which is a float
fields_IsDividedInto is a reference to a hash where the following keys are defined:
	id has a value which is a string
fields_Model is a reference to a hash where the following keys are defined:
	id has a value which is a string
	mod_date has a value which is a string
	name has a value which is a string
	version has a value which is an int
	type has a value which is a string
	status has a value which is a string
	reaction_count has a value which is an int
	compound_count has a value which is an int
	annotation_count has a value which is an int

</pre>

=end html

=begin text

$ids is a reference to a list where each element is a string
$from_fields is a reference to a list where each element is a string
$rel_fields is a reference to a list where each element is a string
$to_fields is a reference to a list where each element is a string
$return is a reference to a list where each element is a reference to a list containing 3 items:
	0: a fields_ModelCompartment
	1: a fields_IsDividedInto
	2: a fields_Model
fields_ModelCompartment is a reference to a hash where the following keys are defined:
	id has a value which is a string
	compartment_index has a value which is an int
	label has a value which is a reference to a list where each element is a string
	pH has a value which is a float
	potential has a value which is a float
fields_IsDividedInto is a reference to a hash where the following keys are defined:
	id has a value which is a string
fields_Model is a reference to a hash where the following keys are defined:
	id has a value which is a string
	mod_date has a value which is a string
	name has a value which is a string
	version has a value which is an int
	type has a value which is a string
	status has a value which is a string
	reaction_count has a value which is an int
	compound_count has a value which is an int
	annotation_count has a value which is an int


=end text



=item Description



=back

=cut

sub get_relationship_IsDivisionOf
{
    my $self = shift;
    my($ids, $from_fields, $rel_fields, $to_fields) = @_;

    my @_bad_arguments;
    (ref($ids) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"ids\" (value was \"$ids\")");
    (ref($from_fields) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"from_fields\" (value was \"$from_fields\")");
    (ref($rel_fields) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"rel_fields\" (value was \"$rel_fields\")");
    (ref($to_fields) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"to_fields\" (value was \"$to_fields\")");
    if (@_bad_arguments) {
	my $msg = "Invalid arguments passed to get_relationship_IsDivisionOf:\n" . join("", map { "\t$_\n" } @_bad_arguments);
	Bio::KBase::Exceptions::ArgumentValidationError->throw(error => $msg,
							       method_name => 'get_relationship_IsDivisionOf');
    }

    my $ctx = $Bio::KBase::CDMI::Service::CallContext;
    my($return);
    #BEGIN get_relationship_IsDivisionOf

    $return = $self->_get_relationship($ctx, 'IsDivisionOf', 'IsDividedInto', 1, $ids, $from_fields, $rel_fields, $to_fields);
	
    #END get_relationship_IsDivisionOf
    my @_bad_returns;
    (ref($return) eq 'ARRAY') or push(@_bad_returns, "Invalid type for return variable \"return\" (value was \"$return\")");
    if (@_bad_returns) {
	my $msg = "Invalid returns passed to get_relationship_IsDivisionOf:\n" . join("", map { "\t$_\n" } @_bad_returns);
	Bio::KBase::Exceptions::ArgumentValidationError->throw(error => $msg,
							       method_name => 'get_relationship_IsDivisionOf');
    }
    return($return);
}




=head2 get_relationship_IsExemplarOf

  $return = $obj->get_relationship_IsExemplarOf($ids, $from_fields, $rel_fields, $to_fields)

=over 4

=item Parameter and return types

=begin html

<pre>
$ids is a reference to a list where each element is a string
$from_fields is a reference to a list where each element is a string
$rel_fields is a reference to a list where each element is a string
$to_fields is a reference to a list where each element is a string
$return is a reference to a list where each element is a reference to a list containing 3 items:
	0: a fields_Feature
	1: a fields_IsExemplarOf
	2: a fields_Role
fields_Feature is a reference to a hash where the following keys are defined:
	id has a value which is a string
	feature_type has a value which is a string
	source_id has a value which is a string
	sequence_length has a value which is an int
	function has a value which is a string
	alias has a value which is a reference to a list where each element is a string
fields_IsExemplarOf is a reference to a hash where the following keys are defined:
	id has a value which is a string
fields_Role is a reference to a hash where the following keys are defined:
	id has a value which is a string
	hypothetical has a value which is an int

</pre>

=end html

=begin text

$ids is a reference to a list where each element is a string
$from_fields is a reference to a list where each element is a string
$rel_fields is a reference to a list where each element is a string
$to_fields is a reference to a list where each element is a string
$return is a reference to a list where each element is a reference to a list containing 3 items:
	0: a fields_Feature
	1: a fields_IsExemplarOf
	2: a fields_Role
fields_Feature is a reference to a hash where the following keys are defined:
	id has a value which is a string
	feature_type has a value which is a string
	source_id has a value which is a string
	sequence_length has a value which is an int
	function has a value which is a string
	alias has a value which is a reference to a list where each element is a string
fields_IsExemplarOf is a reference to a hash where the following keys are defined:
	id has a value which is a string
fields_Role is a reference to a hash where the following keys are defined:
	id has a value which is a string
	hypothetical has a value which is an int


=end text



=item Description

This relationship links a role to a feature that provides a typical
example of how the role is implemented.
It has the following fields:

=over 4



=back

=back

=cut

sub get_relationship_IsExemplarOf
{
    my $self = shift;
    my($ids, $from_fields, $rel_fields, $to_fields) = @_;

    my @_bad_arguments;
    (ref($ids) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"ids\" (value was \"$ids\")");
    (ref($from_fields) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"from_fields\" (value was \"$from_fields\")");
    (ref($rel_fields) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"rel_fields\" (value was \"$rel_fields\")");
    (ref($to_fields) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"to_fields\" (value was \"$to_fields\")");
    if (@_bad_arguments) {
	my $msg = "Invalid arguments passed to get_relationship_IsExemplarOf:\n" . join("", map { "\t$_\n" } @_bad_arguments);
	Bio::KBase::Exceptions::ArgumentValidationError->throw(error => $msg,
							       method_name => 'get_relationship_IsExemplarOf');
    }

    my $ctx = $Bio::KBase::CDMI::Service::CallContext;
    my($return);
    #BEGIN get_relationship_IsExemplarOf

    $return = $self->_get_relationship($ctx, 'IsExemplarOf', 'IsExemplarOf', 0, $ids, $from_fields, $rel_fields, $to_fields);
	
    #END get_relationship_IsExemplarOf
    my @_bad_returns;
    (ref($return) eq 'ARRAY') or push(@_bad_returns, "Invalid type for return variable \"return\" (value was \"$return\")");
    if (@_bad_returns) {
	my $msg = "Invalid returns passed to get_relationship_IsExemplarOf:\n" . join("", map { "\t$_\n" } @_bad_returns);
	Bio::KBase::Exceptions::ArgumentValidationError->throw(error => $msg,
							       method_name => 'get_relationship_IsExemplarOf');
    }
    return($return);
}




=head2 get_relationship_HasAsExemplar

  $return = $obj->get_relationship_HasAsExemplar($ids, $from_fields, $rel_fields, $to_fields)

=over 4

=item Parameter and return types

=begin html

<pre>
$ids is a reference to a list where each element is a string
$from_fields is a reference to a list where each element is a string
$rel_fields is a reference to a list where each element is a string
$to_fields is a reference to a list where each element is a string
$return is a reference to a list where each element is a reference to a list containing 3 items:
	0: a fields_Role
	1: a fields_IsExemplarOf
	2: a fields_Feature
fields_Role is a reference to a hash where the following keys are defined:
	id has a value which is a string
	hypothetical has a value which is an int
fields_IsExemplarOf is a reference to a hash where the following keys are defined:
	id has a value which is a string
fields_Feature is a reference to a hash where the following keys are defined:
	id has a value which is a string
	feature_type has a value which is a string
	source_id has a value which is a string
	sequence_length has a value which is an int
	function has a value which is a string
	alias has a value which is a reference to a list where each element is a string

</pre>

=end html

=begin text

$ids is a reference to a list where each element is a string
$from_fields is a reference to a list where each element is a string
$rel_fields is a reference to a list where each element is a string
$to_fields is a reference to a list where each element is a string
$return is a reference to a list where each element is a reference to a list containing 3 items:
	0: a fields_Role
	1: a fields_IsExemplarOf
	2: a fields_Feature
fields_Role is a reference to a hash where the following keys are defined:
	id has a value which is a string
	hypothetical has a value which is an int
fields_IsExemplarOf is a reference to a hash where the following keys are defined:
	id has a value which is a string
fields_Feature is a reference to a hash where the following keys are defined:
	id has a value which is a string
	feature_type has a value which is a string
	source_id has a value which is a string
	sequence_length has a value which is an int
	function has a value which is a string
	alias has a value which is a reference to a list where each element is a string


=end text



=item Description



=back

=cut

sub get_relationship_HasAsExemplar
{
    my $self = shift;
    my($ids, $from_fields, $rel_fields, $to_fields) = @_;

    my @_bad_arguments;
    (ref($ids) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"ids\" (value was \"$ids\")");
    (ref($from_fields) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"from_fields\" (value was \"$from_fields\")");
    (ref($rel_fields) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"rel_fields\" (value was \"$rel_fields\")");
    (ref($to_fields) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"to_fields\" (value was \"$to_fields\")");
    if (@_bad_arguments) {
	my $msg = "Invalid arguments passed to get_relationship_HasAsExemplar:\n" . join("", map { "\t$_\n" } @_bad_arguments);
	Bio::KBase::Exceptions::ArgumentValidationError->throw(error => $msg,
							       method_name => 'get_relationship_HasAsExemplar');
    }

    my $ctx = $Bio::KBase::CDMI::Service::CallContext;
    my($return);
    #BEGIN get_relationship_HasAsExemplar

    $return = $self->_get_relationship($ctx, 'HasAsExemplar', 'IsExemplarOf', 1, $ids, $from_fields, $rel_fields, $to_fields);
	
    #END get_relationship_HasAsExemplar
    my @_bad_returns;
    (ref($return) eq 'ARRAY') or push(@_bad_returns, "Invalid type for return variable \"return\" (value was \"$return\")");
    if (@_bad_returns) {
	my $msg = "Invalid returns passed to get_relationship_HasAsExemplar:\n" . join("", map { "\t$_\n" } @_bad_returns);
	Bio::KBase::Exceptions::ArgumentValidationError->throw(error => $msg,
							       method_name => 'get_relationship_HasAsExemplar');
    }
    return($return);
}




=head2 get_relationship_IsFamilyFor

  $return = $obj->get_relationship_IsFamilyFor($ids, $from_fields, $rel_fields, $to_fields)

=over 4

=item Parameter and return types

=begin html

<pre>
$ids is a reference to a list where each element is a string
$from_fields is a reference to a list where each element is a string
$rel_fields is a reference to a list where each element is a string
$to_fields is a reference to a list where each element is a string
$return is a reference to a list where each element is a reference to a list containing 3 items:
	0: a fields_Family
	1: a fields_IsFamilyFor
	2: a fields_Role
fields_Family is a reference to a hash where the following keys are defined:
	id has a value which is a string
	type has a value which is a string
	release has a value which is a string
	family_function has a value which is a reference to a list where each element is a string
	alignment has a value which is a reference to a list where each element is a string
fields_IsFamilyFor is a reference to a hash where the following keys are defined:
	id has a value which is a string
fields_Role is a reference to a hash where the following keys are defined:
	id has a value which is a string
	hypothetical has a value which is an int

</pre>

=end html

=begin text

$ids is a reference to a list where each element is a string
$from_fields is a reference to a list where each element is a string
$rel_fields is a reference to a list where each element is a string
$to_fields is a reference to a list where each element is a string
$return is a reference to a list where each element is a reference to a list containing 3 items:
	0: a fields_Family
	1: a fields_IsFamilyFor
	2: a fields_Role
fields_Family is a reference to a hash where the following keys are defined:
	id has a value which is a string
	type has a value which is a string
	release has a value which is a string
	family_function has a value which is a reference to a list where each element is a string
	alignment has a value which is a reference to a list where each element is a string
fields_IsFamilyFor is a reference to a hash where the following keys are defined:
	id has a value which is a string
fields_Role is a reference to a hash where the following keys are defined:
	id has a value which is a string
	hypothetical has a value which is an int


=end text



=item Description

This relationship connects an isofunctional family to the roles that
make up its assigned function.
It has the following fields:

=over 4



=back

=back

=cut

sub get_relationship_IsFamilyFor
{
    my $self = shift;
    my($ids, $from_fields, $rel_fields, $to_fields) = @_;

    my @_bad_arguments;
    (ref($ids) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"ids\" (value was \"$ids\")");
    (ref($from_fields) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"from_fields\" (value was \"$from_fields\")");
    (ref($rel_fields) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"rel_fields\" (value was \"$rel_fields\")");
    (ref($to_fields) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"to_fields\" (value was \"$to_fields\")");
    if (@_bad_arguments) {
	my $msg = "Invalid arguments passed to get_relationship_IsFamilyFor:\n" . join("", map { "\t$_\n" } @_bad_arguments);
	Bio::KBase::Exceptions::ArgumentValidationError->throw(error => $msg,
							       method_name => 'get_relationship_IsFamilyFor');
    }

    my $ctx = $Bio::KBase::CDMI::Service::CallContext;
    my($return);
    #BEGIN get_relationship_IsFamilyFor

    $return = $self->_get_relationship($ctx, 'IsFamilyFor', 'IsFamilyFor', 0, $ids, $from_fields, $rel_fields, $to_fields);
	
    #END get_relationship_IsFamilyFor
    my @_bad_returns;
    (ref($return) eq 'ARRAY') or push(@_bad_returns, "Invalid type for return variable \"return\" (value was \"$return\")");
    if (@_bad_returns) {
	my $msg = "Invalid returns passed to get_relationship_IsFamilyFor:\n" . join("", map { "\t$_\n" } @_bad_returns);
	Bio::KBase::Exceptions::ArgumentValidationError->throw(error => $msg,
							       method_name => 'get_relationship_IsFamilyFor');
    }
    return($return);
}




=head2 get_relationship_DeterminesFunctionOf

  $return = $obj->get_relationship_DeterminesFunctionOf($ids, $from_fields, $rel_fields, $to_fields)

=over 4

=item Parameter and return types

=begin html

<pre>
$ids is a reference to a list where each element is a string
$from_fields is a reference to a list where each element is a string
$rel_fields is a reference to a list where each element is a string
$to_fields is a reference to a list where each element is a string
$return is a reference to a list where each element is a reference to a list containing 3 items:
	0: a fields_Role
	1: a fields_IsFamilyFor
	2: a fields_Family
fields_Role is a reference to a hash where the following keys are defined:
	id has a value which is a string
	hypothetical has a value which is an int
fields_IsFamilyFor is a reference to a hash where the following keys are defined:
	id has a value which is a string
fields_Family is a reference to a hash where the following keys are defined:
	id has a value which is a string
	type has a value which is a string
	release has a value which is a string
	family_function has a value which is a reference to a list where each element is a string
	alignment has a value which is a reference to a list where each element is a string

</pre>

=end html

=begin text

$ids is a reference to a list where each element is a string
$from_fields is a reference to a list where each element is a string
$rel_fields is a reference to a list where each element is a string
$to_fields is a reference to a list where each element is a string
$return is a reference to a list where each element is a reference to a list containing 3 items:
	0: a fields_Role
	1: a fields_IsFamilyFor
	2: a fields_Family
fields_Role is a reference to a hash where the following keys are defined:
	id has a value which is a string
	hypothetical has a value which is an int
fields_IsFamilyFor is a reference to a hash where the following keys are defined:
	id has a value which is a string
fields_Family is a reference to a hash where the following keys are defined:
	id has a value which is a string
	type has a value which is a string
	release has a value which is a string
	family_function has a value which is a reference to a list where each element is a string
	alignment has a value which is a reference to a list where each element is a string


=end text



=item Description



=back

=cut

sub get_relationship_DeterminesFunctionOf
{
    my $self = shift;
    my($ids, $from_fields, $rel_fields, $to_fields) = @_;

    my @_bad_arguments;
    (ref($ids) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"ids\" (value was \"$ids\")");
    (ref($from_fields) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"from_fields\" (value was \"$from_fields\")");
    (ref($rel_fields) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"rel_fields\" (value was \"$rel_fields\")");
    (ref($to_fields) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"to_fields\" (value was \"$to_fields\")");
    if (@_bad_arguments) {
	my $msg = "Invalid arguments passed to get_relationship_DeterminesFunctionOf:\n" . join("", map { "\t$_\n" } @_bad_arguments);
	Bio::KBase::Exceptions::ArgumentValidationError->throw(error => $msg,
							       method_name => 'get_relationship_DeterminesFunctionOf');
    }

    my $ctx = $Bio::KBase::CDMI::Service::CallContext;
    my($return);
    #BEGIN get_relationship_DeterminesFunctionOf

    $return = $self->_get_relationship($ctx, 'DeterminesFunctionOf', 'IsFamilyFor', 1, $ids, $from_fields, $rel_fields, $to_fields);
	
    #END get_relationship_DeterminesFunctionOf
    my @_bad_returns;
    (ref($return) eq 'ARRAY') or push(@_bad_returns, "Invalid type for return variable \"return\" (value was \"$return\")");
    if (@_bad_returns) {
	my $msg = "Invalid returns passed to get_relationship_DeterminesFunctionOf:\n" . join("", map { "\t$_\n" } @_bad_returns);
	Bio::KBase::Exceptions::ArgumentValidationError->throw(error => $msg,
							       method_name => 'get_relationship_DeterminesFunctionOf');
    }
    return($return);
}




=head2 get_relationship_IsFormedOf

  $return = $obj->get_relationship_IsFormedOf($ids, $from_fields, $rel_fields, $to_fields)

=over 4

=item Parameter and return types

=begin html

<pre>
$ids is a reference to a list where each element is a string
$from_fields is a reference to a list where each element is a string
$rel_fields is a reference to a list where each element is a string
$to_fields is a reference to a list where each element is a string
$return is a reference to a list where each element is a reference to a list containing 3 items:
	0: a fields_AtomicRegulon
	1: a fields_IsFormedOf
	2: a fields_Feature
fields_AtomicRegulon is a reference to a hash where the following keys are defined:
	id has a value which is a string
fields_IsFormedOf is a reference to a hash where the following keys are defined:
	id has a value which is a string
fields_Feature is a reference to a hash where the following keys are defined:
	id has a value which is a string
	feature_type has a value which is a string
	source_id has a value which is a string
	sequence_length has a value which is an int
	function has a value which is a string
	alias has a value which is a reference to a list where each element is a string

</pre>

=end html

=begin text

$ids is a reference to a list where each element is a string
$from_fields is a reference to a list where each element is a string
$rel_fields is a reference to a list where each element is a string
$to_fields is a reference to a list where each element is a string
$return is a reference to a list where each element is a reference to a list containing 3 items:
	0: a fields_AtomicRegulon
	1: a fields_IsFormedOf
	2: a fields_Feature
fields_AtomicRegulon is a reference to a hash where the following keys are defined:
	id has a value which is a string
fields_IsFormedOf is a reference to a hash where the following keys are defined:
	id has a value which is a string
fields_Feature is a reference to a hash where the following keys are defined:
	id has a value which is a string
	feature_type has a value which is a string
	source_id has a value which is a string
	sequence_length has a value which is an int
	function has a value which is a string
	alias has a value which is a reference to a list where each element is a string


=end text



=item Description

This relationship connects each feature to the atomic regulon to
which it belongs.
It has the following fields:

=over 4



=back

=back

=cut

sub get_relationship_IsFormedOf
{
    my $self = shift;
    my($ids, $from_fields, $rel_fields, $to_fields) = @_;

    my @_bad_arguments;
    (ref($ids) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"ids\" (value was \"$ids\")");
    (ref($from_fields) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"from_fields\" (value was \"$from_fields\")");
    (ref($rel_fields) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"rel_fields\" (value was \"$rel_fields\")");
    (ref($to_fields) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"to_fields\" (value was \"$to_fields\")");
    if (@_bad_arguments) {
	my $msg = "Invalid arguments passed to get_relationship_IsFormedOf:\n" . join("", map { "\t$_\n" } @_bad_arguments);
	Bio::KBase::Exceptions::ArgumentValidationError->throw(error => $msg,
							       method_name => 'get_relationship_IsFormedOf');
    }

    my $ctx = $Bio::KBase::CDMI::Service::CallContext;
    my($return);
    #BEGIN get_relationship_IsFormedOf

    $return = $self->_get_relationship($ctx, 'IsFormedOf', 'IsFormedOf', 0, $ids, $from_fields, $rel_fields, $to_fields);
	
    #END get_relationship_IsFormedOf
    my @_bad_returns;
    (ref($return) eq 'ARRAY') or push(@_bad_returns, "Invalid type for return variable \"return\" (value was \"$return\")");
    if (@_bad_returns) {
	my $msg = "Invalid returns passed to get_relationship_IsFormedOf:\n" . join("", map { "\t$_\n" } @_bad_returns);
	Bio::KBase::Exceptions::ArgumentValidationError->throw(error => $msg,
							       method_name => 'get_relationship_IsFormedOf');
    }
    return($return);
}




=head2 get_relationship_IsFormedInto

  $return = $obj->get_relationship_IsFormedInto($ids, $from_fields, $rel_fields, $to_fields)

=over 4

=item Parameter and return types

=begin html

<pre>
$ids is a reference to a list where each element is a string
$from_fields is a reference to a list where each element is a string
$rel_fields is a reference to a list where each element is a string
$to_fields is a reference to a list where each element is a string
$return is a reference to a list where each element is a reference to a list containing 3 items:
	0: a fields_Feature
	1: a fields_IsFormedOf
	2: a fields_AtomicRegulon
fields_Feature is a reference to a hash where the following keys are defined:
	id has a value which is a string
	feature_type has a value which is a string
	source_id has a value which is a string
	sequence_length has a value which is an int
	function has a value which is a string
	alias has a value which is a reference to a list where each element is a string
fields_IsFormedOf is a reference to a hash where the following keys are defined:
	id has a value which is a string
fields_AtomicRegulon is a reference to a hash where the following keys are defined:
	id has a value which is a string

</pre>

=end html

=begin text

$ids is a reference to a list where each element is a string
$from_fields is a reference to a list where each element is a string
$rel_fields is a reference to a list where each element is a string
$to_fields is a reference to a list where each element is a string
$return is a reference to a list where each element is a reference to a list containing 3 items:
	0: a fields_Feature
	1: a fields_IsFormedOf
	2: a fields_AtomicRegulon
fields_Feature is a reference to a hash where the following keys are defined:
	id has a value which is a string
	feature_type has a value which is a string
	source_id has a value which is a string
	sequence_length has a value which is an int
	function has a value which is a string
	alias has a value which is a reference to a list where each element is a string
fields_IsFormedOf is a reference to a hash where the following keys are defined:
	id has a value which is a string
fields_AtomicRegulon is a reference to a hash where the following keys are defined:
	id has a value which is a string


=end text



=item Description



=back

=cut

sub get_relationship_IsFormedInto
{
    my $self = shift;
    my($ids, $from_fields, $rel_fields, $to_fields) = @_;

    my @_bad_arguments;
    (ref($ids) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"ids\" (value was \"$ids\")");
    (ref($from_fields) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"from_fields\" (value was \"$from_fields\")");
    (ref($rel_fields) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"rel_fields\" (value was \"$rel_fields\")");
    (ref($to_fields) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"to_fields\" (value was \"$to_fields\")");
    if (@_bad_arguments) {
	my $msg = "Invalid arguments passed to get_relationship_IsFormedInto:\n" . join("", map { "\t$_\n" } @_bad_arguments);
	Bio::KBase::Exceptions::ArgumentValidationError->throw(error => $msg,
							       method_name => 'get_relationship_IsFormedInto');
    }

    my $ctx = $Bio::KBase::CDMI::Service::CallContext;
    my($return);
    #BEGIN get_relationship_IsFormedInto

    $return = $self->_get_relationship($ctx, 'IsFormedInto', 'IsFormedOf', 1, $ids, $from_fields, $rel_fields, $to_fields);
	
    #END get_relationship_IsFormedInto
    my @_bad_returns;
    (ref($return) eq 'ARRAY') or push(@_bad_returns, "Invalid type for return variable \"return\" (value was \"$return\")");
    if (@_bad_returns) {
	my $msg = "Invalid returns passed to get_relationship_IsFormedInto:\n" . join("", map { "\t$_\n" } @_bad_returns);
	Bio::KBase::Exceptions::ArgumentValidationError->throw(error => $msg,
							       method_name => 'get_relationship_IsFormedInto');
    }
    return($return);
}




=head2 get_relationship_IsFunctionalIn

  $return = $obj->get_relationship_IsFunctionalIn($ids, $from_fields, $rel_fields, $to_fields)

=over 4

=item Parameter and return types

=begin html

<pre>
$ids is a reference to a list where each element is a string
$from_fields is a reference to a list where each element is a string
$rel_fields is a reference to a list where each element is a string
$to_fields is a reference to a list where each element is a string
$return is a reference to a list where each element is a reference to a list containing 3 items:
	0: a fields_Role
	1: a fields_IsFunctionalIn
	2: a fields_Feature
fields_Role is a reference to a hash where the following keys are defined:
	id has a value which is a string
	hypothetical has a value which is an int
fields_IsFunctionalIn is a reference to a hash where the following keys are defined:
	id has a value which is a string
fields_Feature is a reference to a hash where the following keys are defined:
	id has a value which is a string
	feature_type has a value which is a string
	source_id has a value which is a string
	sequence_length has a value which is an int
	function has a value which is a string
	alias has a value which is a reference to a list where each element is a string

</pre>

=end html

=begin text

$ids is a reference to a list where each element is a string
$from_fields is a reference to a list where each element is a string
$rel_fields is a reference to a list where each element is a string
$to_fields is a reference to a list where each element is a string
$return is a reference to a list where each element is a reference to a list containing 3 items:
	0: a fields_Role
	1: a fields_IsFunctionalIn
	2: a fields_Feature
fields_Role is a reference to a hash where the following keys are defined:
	id has a value which is a string
	hypothetical has a value which is an int
fields_IsFunctionalIn is a reference to a hash where the following keys are defined:
	id has a value which is a string
fields_Feature is a reference to a hash where the following keys are defined:
	id has a value which is a string
	feature_type has a value which is a string
	source_id has a value which is a string
	sequence_length has a value which is an int
	function has a value which is a string
	alias has a value which is a reference to a list where each element is a string


=end text



=item Description

This relationship connects a role with the features in which
it plays a functional part.
It has the following fields:

=over 4



=back

=back

=cut

sub get_relationship_IsFunctionalIn
{
    my $self = shift;
    my($ids, $from_fields, $rel_fields, $to_fields) = @_;

    my @_bad_arguments;
    (ref($ids) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"ids\" (value was \"$ids\")");
    (ref($from_fields) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"from_fields\" (value was \"$from_fields\")");
    (ref($rel_fields) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"rel_fields\" (value was \"$rel_fields\")");
    (ref($to_fields) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"to_fields\" (value was \"$to_fields\")");
    if (@_bad_arguments) {
	my $msg = "Invalid arguments passed to get_relationship_IsFunctionalIn:\n" . join("", map { "\t$_\n" } @_bad_arguments);
	Bio::KBase::Exceptions::ArgumentValidationError->throw(error => $msg,
							       method_name => 'get_relationship_IsFunctionalIn');
    }

    my $ctx = $Bio::KBase::CDMI::Service::CallContext;
    my($return);
    #BEGIN get_relationship_IsFunctionalIn

    $return = $self->_get_relationship($ctx, 'IsFunctionalIn', 'IsFunctionalIn', 0, $ids, $from_fields, $rel_fields, $to_fields);
	
    #END get_relationship_IsFunctionalIn
    my @_bad_returns;
    (ref($return) eq 'ARRAY') or push(@_bad_returns, "Invalid type for return variable \"return\" (value was \"$return\")");
    if (@_bad_returns) {
	my $msg = "Invalid returns passed to get_relationship_IsFunctionalIn:\n" . join("", map { "\t$_\n" } @_bad_returns);
	Bio::KBase::Exceptions::ArgumentValidationError->throw(error => $msg,
							       method_name => 'get_relationship_IsFunctionalIn');
    }
    return($return);
}




=head2 get_relationship_HasFunctional

  $return = $obj->get_relationship_HasFunctional($ids, $from_fields, $rel_fields, $to_fields)

=over 4

=item Parameter and return types

=begin html

<pre>
$ids is a reference to a list where each element is a string
$from_fields is a reference to a list where each element is a string
$rel_fields is a reference to a list where each element is a string
$to_fields is a reference to a list where each element is a string
$return is a reference to a list where each element is a reference to a list containing 3 items:
	0: a fields_Feature
	1: a fields_IsFunctionalIn
	2: a fields_Role
fields_Feature is a reference to a hash where the following keys are defined:
	id has a value which is a string
	feature_type has a value which is a string
	source_id has a value which is a string
	sequence_length has a value which is an int
	function has a value which is a string
	alias has a value which is a reference to a list where each element is a string
fields_IsFunctionalIn is a reference to a hash where the following keys are defined:
	id has a value which is a string
fields_Role is a reference to a hash where the following keys are defined:
	id has a value which is a string
	hypothetical has a value which is an int

</pre>

=end html

=begin text

$ids is a reference to a list where each element is a string
$from_fields is a reference to a list where each element is a string
$rel_fields is a reference to a list where each element is a string
$to_fields is a reference to a list where each element is a string
$return is a reference to a list where each element is a reference to a list containing 3 items:
	0: a fields_Feature
	1: a fields_IsFunctionalIn
	2: a fields_Role
fields_Feature is a reference to a hash where the following keys are defined:
	id has a value which is a string
	feature_type has a value which is a string
	source_id has a value which is a string
	sequence_length has a value which is an int
	function has a value which is a string
	alias has a value which is a reference to a list where each element is a string
fields_IsFunctionalIn is a reference to a hash where the following keys are defined:
	id has a value which is a string
fields_Role is a reference to a hash where the following keys are defined:
	id has a value which is a string
	hypothetical has a value which is an int


=end text



=item Description



=back

=cut

sub get_relationship_HasFunctional
{
    my $self = shift;
    my($ids, $from_fields, $rel_fields, $to_fields) = @_;

    my @_bad_arguments;
    (ref($ids) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"ids\" (value was \"$ids\")");
    (ref($from_fields) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"from_fields\" (value was \"$from_fields\")");
    (ref($rel_fields) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"rel_fields\" (value was \"$rel_fields\")");
    (ref($to_fields) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"to_fields\" (value was \"$to_fields\")");
    if (@_bad_arguments) {
	my $msg = "Invalid arguments passed to get_relationship_HasFunctional:\n" . join("", map { "\t$_\n" } @_bad_arguments);
	Bio::KBase::Exceptions::ArgumentValidationError->throw(error => $msg,
							       method_name => 'get_relationship_HasFunctional');
    }

    my $ctx = $Bio::KBase::CDMI::Service::CallContext;
    my($return);
    #BEGIN get_relationship_HasFunctional

    $return = $self->_get_relationship($ctx, 'HasFunctional', 'IsFunctionalIn', 1, $ids, $from_fields, $rel_fields, $to_fields);
	
    #END get_relationship_HasFunctional
    my @_bad_returns;
    (ref($return) eq 'ARRAY') or push(@_bad_returns, "Invalid type for return variable \"return\" (value was \"$return\")");
    if (@_bad_returns) {
	my $msg = "Invalid returns passed to get_relationship_HasFunctional:\n" . join("", map { "\t$_\n" } @_bad_returns);
	Bio::KBase::Exceptions::ArgumentValidationError->throw(error => $msg,
							       method_name => 'get_relationship_HasFunctional');
    }
    return($return);
}




=head2 get_relationship_IsGroupFor

  $return = $obj->get_relationship_IsGroupFor($ids, $from_fields, $rel_fields, $to_fields)

=over 4

=item Parameter and return types

=begin html

<pre>
$ids is a reference to a list where each element is a string
$from_fields is a reference to a list where each element is a string
$rel_fields is a reference to a list where each element is a string
$to_fields is a reference to a list where each element is a string
$return is a reference to a list where each element is a reference to a list containing 3 items:
	0: a fields_TaxonomicGrouping
	1: a fields_IsGroupFor
	2: a fields_TaxonomicGrouping
fields_TaxonomicGrouping is a reference to a hash where the following keys are defined:
	id has a value which is a string
	domain has a value which is an int
	hidden has a value which is an int
	scientific_name has a value which is a string
	alias has a value which is a reference to a list where each element is a string
fields_IsGroupFor is a reference to a hash where the following keys are defined:
	id has a value which is a string

</pre>

=end html

=begin text

$ids is a reference to a list where each element is a string
$from_fields is a reference to a list where each element is a string
$rel_fields is a reference to a list where each element is a string
$to_fields is a reference to a list where each element is a string
$return is a reference to a list where each element is a reference to a list containing 3 items:
	0: a fields_TaxonomicGrouping
	1: a fields_IsGroupFor
	2: a fields_TaxonomicGrouping
fields_TaxonomicGrouping is a reference to a hash where the following keys are defined:
	id has a value which is a string
	domain has a value which is an int
	hidden has a value which is an int
	scientific_name has a value which is a string
	alias has a value which is a reference to a list where each element is a string
fields_IsGroupFor is a reference to a hash where the following keys are defined:
	id has a value which is a string


=end text



=item Description

The recursive IsGroupFor relationship organizes
taxonomic groupings into a hierarchy based on the standard organism
taxonomy.
It has the following fields:

=over 4



=back

=back

=cut

sub get_relationship_IsGroupFor
{
    my $self = shift;
    my($ids, $from_fields, $rel_fields, $to_fields) = @_;

    my @_bad_arguments;
    (ref($ids) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"ids\" (value was \"$ids\")");
    (ref($from_fields) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"from_fields\" (value was \"$from_fields\")");
    (ref($rel_fields) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"rel_fields\" (value was \"$rel_fields\")");
    (ref($to_fields) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"to_fields\" (value was \"$to_fields\")");
    if (@_bad_arguments) {
	my $msg = "Invalid arguments passed to get_relationship_IsGroupFor:\n" . join("", map { "\t$_\n" } @_bad_arguments);
	Bio::KBase::Exceptions::ArgumentValidationError->throw(error => $msg,
							       method_name => 'get_relationship_IsGroupFor');
    }

    my $ctx = $Bio::KBase::CDMI::Service::CallContext;
    my($return);
    #BEGIN get_relationship_IsGroupFor

    $return = $self->_get_relationship($ctx, 'IsGroupFor', 'IsGroupFor', 0, $ids, $from_fields, $rel_fields, $to_fields);
	
    #END get_relationship_IsGroupFor
    my @_bad_returns;
    (ref($return) eq 'ARRAY') or push(@_bad_returns, "Invalid type for return variable \"return\" (value was \"$return\")");
    if (@_bad_returns) {
	my $msg = "Invalid returns passed to get_relationship_IsGroupFor:\n" . join("", map { "\t$_\n" } @_bad_returns);
	Bio::KBase::Exceptions::ArgumentValidationError->throw(error => $msg,
							       method_name => 'get_relationship_IsGroupFor');
    }
    return($return);
}




=head2 get_relationship_IsInGroup

  $return = $obj->get_relationship_IsInGroup($ids, $from_fields, $rel_fields, $to_fields)

=over 4

=item Parameter and return types

=begin html

<pre>
$ids is a reference to a list where each element is a string
$from_fields is a reference to a list where each element is a string
$rel_fields is a reference to a list where each element is a string
$to_fields is a reference to a list where each element is a string
$return is a reference to a list where each element is a reference to a list containing 3 items:
	0: a fields_TaxonomicGrouping
	1: a fields_IsGroupFor
	2: a fields_TaxonomicGrouping
fields_TaxonomicGrouping is a reference to a hash where the following keys are defined:
	id has a value which is a string
	domain has a value which is an int
	hidden has a value which is an int
	scientific_name has a value which is a string
	alias has a value which is a reference to a list where each element is a string
fields_IsGroupFor is a reference to a hash where the following keys are defined:
	id has a value which is a string

</pre>

=end html

=begin text

$ids is a reference to a list where each element is a string
$from_fields is a reference to a list where each element is a string
$rel_fields is a reference to a list where each element is a string
$to_fields is a reference to a list where each element is a string
$return is a reference to a list where each element is a reference to a list containing 3 items:
	0: a fields_TaxonomicGrouping
	1: a fields_IsGroupFor
	2: a fields_TaxonomicGrouping
fields_TaxonomicGrouping is a reference to a hash where the following keys are defined:
	id has a value which is a string
	domain has a value which is an int
	hidden has a value which is an int
	scientific_name has a value which is a string
	alias has a value which is a reference to a list where each element is a string
fields_IsGroupFor is a reference to a hash where the following keys are defined:
	id has a value which is a string


=end text



=item Description



=back

=cut

sub get_relationship_IsInGroup
{
    my $self = shift;
    my($ids, $from_fields, $rel_fields, $to_fields) = @_;

    my @_bad_arguments;
    (ref($ids) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"ids\" (value was \"$ids\")");
    (ref($from_fields) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"from_fields\" (value was \"$from_fields\")");
    (ref($rel_fields) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"rel_fields\" (value was \"$rel_fields\")");
    (ref($to_fields) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"to_fields\" (value was \"$to_fields\")");
    if (@_bad_arguments) {
	my $msg = "Invalid arguments passed to get_relationship_IsInGroup:\n" . join("", map { "\t$_\n" } @_bad_arguments);
	Bio::KBase::Exceptions::ArgumentValidationError->throw(error => $msg,
							       method_name => 'get_relationship_IsInGroup');
    }

    my $ctx = $Bio::KBase::CDMI::Service::CallContext;
    my($return);
    #BEGIN get_relationship_IsInGroup

    $return = $self->_get_relationship($ctx, 'IsInGroup', 'IsGroupFor', 1, $ids, $from_fields, $rel_fields, $to_fields);
	
    #END get_relationship_IsInGroup
    my @_bad_returns;
    (ref($return) eq 'ARRAY') or push(@_bad_returns, "Invalid type for return variable \"return\" (value was \"$return\")");
    if (@_bad_returns) {
	my $msg = "Invalid returns passed to get_relationship_IsInGroup:\n" . join("", map { "\t$_\n" } @_bad_returns);
	Bio::KBase::Exceptions::ArgumentValidationError->throw(error => $msg,
							       method_name => 'get_relationship_IsInGroup');
    }
    return($return);
}




=head2 get_relationship_IsImplementedBy

  $return = $obj->get_relationship_IsImplementedBy($ids, $from_fields, $rel_fields, $to_fields)

=over 4

=item Parameter and return types

=begin html

<pre>
$ids is a reference to a list where each element is a string
$from_fields is a reference to a list where each element is a string
$rel_fields is a reference to a list where each element is a string
$to_fields is a reference to a list where each element is a string
$return is a reference to a list where each element is a reference to a list containing 3 items:
	0: a fields_Variant
	1: a fields_IsImplementedBy
	2: a fields_SSRow
fields_Variant is a reference to a hash where the following keys are defined:
	id has a value which is a string
	role_rule has a value which is a reference to a list where each element is a string
	code has a value which is a string
	type has a value which is a string
	comment has a value which is a string
fields_IsImplementedBy is a reference to a hash where the following keys are defined:
	id has a value which is a string
fields_SSRow is a reference to a hash where the following keys are defined:
	id has a value which is a string
	curated has a value which is an int
	region has a value which is a string

</pre>

=end html

=begin text

$ids is a reference to a list where each element is a string
$from_fields is a reference to a list where each element is a string
$rel_fields is a reference to a list where each element is a string
$to_fields is a reference to a list where each element is a string
$return is a reference to a list where each element is a reference to a list containing 3 items:
	0: a fields_Variant
	1: a fields_IsImplementedBy
	2: a fields_SSRow
fields_Variant is a reference to a hash where the following keys are defined:
	id has a value which is a string
	role_rule has a value which is a reference to a list where each element is a string
	code has a value which is a string
	type has a value which is a string
	comment has a value which is a string
fields_IsImplementedBy is a reference to a hash where the following keys are defined:
	id has a value which is a string
fields_SSRow is a reference to a hash where the following keys are defined:
	id has a value which is a string
	curated has a value which is an int
	region has a value which is a string


=end text



=item Description

This relationship connects a variant to the physical machines
that implement it in the genomes. A variant is implemented by many
machines, but a machine belongs to only one variant.
It has the following fields:

=over 4



=back

=back

=cut

sub get_relationship_IsImplementedBy
{
    my $self = shift;
    my($ids, $from_fields, $rel_fields, $to_fields) = @_;

    my @_bad_arguments;
    (ref($ids) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"ids\" (value was \"$ids\")");
    (ref($from_fields) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"from_fields\" (value was \"$from_fields\")");
    (ref($rel_fields) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"rel_fields\" (value was \"$rel_fields\")");
    (ref($to_fields) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"to_fields\" (value was \"$to_fields\")");
    if (@_bad_arguments) {
	my $msg = "Invalid arguments passed to get_relationship_IsImplementedBy:\n" . join("", map { "\t$_\n" } @_bad_arguments);
	Bio::KBase::Exceptions::ArgumentValidationError->throw(error => $msg,
							       method_name => 'get_relationship_IsImplementedBy');
    }

    my $ctx = $Bio::KBase::CDMI::Service::CallContext;
    my($return);
    #BEGIN get_relationship_IsImplementedBy

    $return = $self->_get_relationship($ctx, 'IsImplementedBy', 'IsImplementedBy', 0, $ids, $from_fields, $rel_fields, $to_fields);
	
    #END get_relationship_IsImplementedBy
    my @_bad_returns;
    (ref($return) eq 'ARRAY') or push(@_bad_returns, "Invalid type for return variable \"return\" (value was \"$return\")");
    if (@_bad_returns) {
	my $msg = "Invalid returns passed to get_relationship_IsImplementedBy:\n" . join("", map { "\t$_\n" } @_bad_returns);
	Bio::KBase::Exceptions::ArgumentValidationError->throw(error => $msg,
							       method_name => 'get_relationship_IsImplementedBy');
    }
    return($return);
}




=head2 get_relationship_Implements

  $return = $obj->get_relationship_Implements($ids, $from_fields, $rel_fields, $to_fields)

=over 4

=item Parameter and return types

=begin html

<pre>
$ids is a reference to a list where each element is a string
$from_fields is a reference to a list where each element is a string
$rel_fields is a reference to a list where each element is a string
$to_fields is a reference to a list where each element is a string
$return is a reference to a list where each element is a reference to a list containing 3 items:
	0: a fields_SSRow
	1: a fields_IsImplementedBy
	2: a fields_Variant
fields_SSRow is a reference to a hash where the following keys are defined:
	id has a value which is a string
	curated has a value which is an int
	region has a value which is a string
fields_IsImplementedBy is a reference to a hash where the following keys are defined:
	id has a value which is a string
fields_Variant is a reference to a hash where the following keys are defined:
	id has a value which is a string
	role_rule has a value which is a reference to a list where each element is a string
	code has a value which is a string
	type has a value which is a string
	comment has a value which is a string

</pre>

=end html

=begin text

$ids is a reference to a list where each element is a string
$from_fields is a reference to a list where each element is a string
$rel_fields is a reference to a list where each element is a string
$to_fields is a reference to a list where each element is a string
$return is a reference to a list where each element is a reference to a list containing 3 items:
	0: a fields_SSRow
	1: a fields_IsImplementedBy
	2: a fields_Variant
fields_SSRow is a reference to a hash where the following keys are defined:
	id has a value which is a string
	curated has a value which is an int
	region has a value which is a string
fields_IsImplementedBy is a reference to a hash where the following keys are defined:
	id has a value which is a string
fields_Variant is a reference to a hash where the following keys are defined:
	id has a value which is a string
	role_rule has a value which is a reference to a list where each element is a string
	code has a value which is a string
	type has a value which is a string
	comment has a value which is a string


=end text



=item Description



=back

=cut

sub get_relationship_Implements
{
    my $self = shift;
    my($ids, $from_fields, $rel_fields, $to_fields) = @_;

    my @_bad_arguments;
    (ref($ids) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"ids\" (value was \"$ids\")");
    (ref($from_fields) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"from_fields\" (value was \"$from_fields\")");
    (ref($rel_fields) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"rel_fields\" (value was \"$rel_fields\")");
    (ref($to_fields) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"to_fields\" (value was \"$to_fields\")");
    if (@_bad_arguments) {
	my $msg = "Invalid arguments passed to get_relationship_Implements:\n" . join("", map { "\t$_\n" } @_bad_arguments);
	Bio::KBase::Exceptions::ArgumentValidationError->throw(error => $msg,
							       method_name => 'get_relationship_Implements');
    }

    my $ctx = $Bio::KBase::CDMI::Service::CallContext;
    my($return);
    #BEGIN get_relationship_Implements

    $return = $self->_get_relationship($ctx, 'Implements', 'IsImplementedBy', 1, $ids, $from_fields, $rel_fields, $to_fields);
	
    #END get_relationship_Implements
    my @_bad_returns;
    (ref($return) eq 'ARRAY') or push(@_bad_returns, "Invalid type for return variable \"return\" (value was \"$return\")");
    if (@_bad_returns) {
	my $msg = "Invalid returns passed to get_relationship_Implements:\n" . join("", map { "\t$_\n" } @_bad_returns);
	Bio::KBase::Exceptions::ArgumentValidationError->throw(error => $msg,
							       method_name => 'get_relationship_Implements');
    }
    return($return);
}




=head2 get_relationship_IsInPair

  $return = $obj->get_relationship_IsInPair($ids, $from_fields, $rel_fields, $to_fields)

=over 4

=item Parameter and return types

=begin html

<pre>
$ids is a reference to a list where each element is a string
$from_fields is a reference to a list where each element is a string
$rel_fields is a reference to a list where each element is a string
$to_fields is a reference to a list where each element is a string
$return is a reference to a list where each element is a reference to a list containing 3 items:
	0: a fields_Feature
	1: a fields_IsInPair
	2: a fields_Pairing
fields_Feature is a reference to a hash where the following keys are defined:
	id has a value which is a string
	feature_type has a value which is a string
	source_id has a value which is a string
	sequence_length has a value which is an int
	function has a value which is a string
	alias has a value which is a reference to a list where each element is a string
fields_IsInPair is a reference to a hash where the following keys are defined:
	id has a value which is a string
fields_Pairing is a reference to a hash where the following keys are defined:
	id has a value which is a string

</pre>

=end html

=begin text

$ids is a reference to a list where each element is a string
$from_fields is a reference to a list where each element is a string
$rel_fields is a reference to a list where each element is a string
$to_fields is a reference to a list where each element is a string
$return is a reference to a list where each element is a reference to a list containing 3 items:
	0: a fields_Feature
	1: a fields_IsInPair
	2: a fields_Pairing
fields_Feature is a reference to a hash where the following keys are defined:
	id has a value which is a string
	feature_type has a value which is a string
	source_id has a value which is a string
	sequence_length has a value which is an int
	function has a value which is a string
	alias has a value which is a reference to a list where each element is a string
fields_IsInPair is a reference to a hash where the following keys are defined:
	id has a value which is a string
fields_Pairing is a reference to a hash where the following keys are defined:
	id has a value which is a string


=end text



=item Description

A pairing contains exactly two protein sequences. A protein
sequence can belong to multiple pairings. When going from a protein
sequence to its pairings, they are presented in alphabetical order
by sequence key.
It has the following fields:

=over 4



=back

=back

=cut

sub get_relationship_IsInPair
{
    my $self = shift;
    my($ids, $from_fields, $rel_fields, $to_fields) = @_;

    my @_bad_arguments;
    (ref($ids) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"ids\" (value was \"$ids\")");
    (ref($from_fields) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"from_fields\" (value was \"$from_fields\")");
    (ref($rel_fields) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"rel_fields\" (value was \"$rel_fields\")");
    (ref($to_fields) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"to_fields\" (value was \"$to_fields\")");
    if (@_bad_arguments) {
	my $msg = "Invalid arguments passed to get_relationship_IsInPair:\n" . join("", map { "\t$_\n" } @_bad_arguments);
	Bio::KBase::Exceptions::ArgumentValidationError->throw(error => $msg,
							       method_name => 'get_relationship_IsInPair');
    }

    my $ctx = $Bio::KBase::CDMI::Service::CallContext;
    my($return);
    #BEGIN get_relationship_IsInPair

    $return = $self->_get_relationship($ctx, 'IsInPair', 'IsInPair', 0, $ids, $from_fields, $rel_fields, $to_fields);
	
    #END get_relationship_IsInPair
    my @_bad_returns;
    (ref($return) eq 'ARRAY') or push(@_bad_returns, "Invalid type for return variable \"return\" (value was \"$return\")");
    if (@_bad_returns) {
	my $msg = "Invalid returns passed to get_relationship_IsInPair:\n" . join("", map { "\t$_\n" } @_bad_returns);
	Bio::KBase::Exceptions::ArgumentValidationError->throw(error => $msg,
							       method_name => 'get_relationship_IsInPair');
    }
    return($return);
}




=head2 get_relationship_IsPairOf

  $return = $obj->get_relationship_IsPairOf($ids, $from_fields, $rel_fields, $to_fields)

=over 4

=item Parameter and return types

=begin html

<pre>
$ids is a reference to a list where each element is a string
$from_fields is a reference to a list where each element is a string
$rel_fields is a reference to a list where each element is a string
$to_fields is a reference to a list where each element is a string
$return is a reference to a list where each element is a reference to a list containing 3 items:
	0: a fields_Pairing
	1: a fields_IsInPair
	2: a fields_Feature
fields_Pairing is a reference to a hash where the following keys are defined:
	id has a value which is a string
fields_IsInPair is a reference to a hash where the following keys are defined:
	id has a value which is a string
fields_Feature is a reference to a hash where the following keys are defined:
	id has a value which is a string
	feature_type has a value which is a string
	source_id has a value which is a string
	sequence_length has a value which is an int
	function has a value which is a string
	alias has a value which is a reference to a list where each element is a string

</pre>

=end html

=begin text

$ids is a reference to a list where each element is a string
$from_fields is a reference to a list where each element is a string
$rel_fields is a reference to a list where each element is a string
$to_fields is a reference to a list where each element is a string
$return is a reference to a list where each element is a reference to a list containing 3 items:
	0: a fields_Pairing
	1: a fields_IsInPair
	2: a fields_Feature
fields_Pairing is a reference to a hash where the following keys are defined:
	id has a value which is a string
fields_IsInPair is a reference to a hash where the following keys are defined:
	id has a value which is a string
fields_Feature is a reference to a hash where the following keys are defined:
	id has a value which is a string
	feature_type has a value which is a string
	source_id has a value which is a string
	sequence_length has a value which is an int
	function has a value which is a string
	alias has a value which is a reference to a list where each element is a string


=end text



=item Description



=back

=cut

sub get_relationship_IsPairOf
{
    my $self = shift;
    my($ids, $from_fields, $rel_fields, $to_fields) = @_;

    my @_bad_arguments;
    (ref($ids) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"ids\" (value was \"$ids\")");
    (ref($from_fields) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"from_fields\" (value was \"$from_fields\")");
    (ref($rel_fields) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"rel_fields\" (value was \"$rel_fields\")");
    (ref($to_fields) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"to_fields\" (value was \"$to_fields\")");
    if (@_bad_arguments) {
	my $msg = "Invalid arguments passed to get_relationship_IsPairOf:\n" . join("", map { "\t$_\n" } @_bad_arguments);
	Bio::KBase::Exceptions::ArgumentValidationError->throw(error => $msg,
							       method_name => 'get_relationship_IsPairOf');
    }

    my $ctx = $Bio::KBase::CDMI::Service::CallContext;
    my($return);
    #BEGIN get_relationship_IsPairOf

    $return = $self->_get_relationship($ctx, 'IsPairOf', 'IsInPair', 1, $ids, $from_fields, $rel_fields, $to_fields);
	
    #END get_relationship_IsPairOf
    my @_bad_returns;
    (ref($return) eq 'ARRAY') or push(@_bad_returns, "Invalid type for return variable \"return\" (value was \"$return\")");
    if (@_bad_returns) {
	my $msg = "Invalid returns passed to get_relationship_IsPairOf:\n" . join("", map { "\t$_\n" } @_bad_returns);
	Bio::KBase::Exceptions::ArgumentValidationError->throw(error => $msg,
							       method_name => 'get_relationship_IsPairOf');
    }
    return($return);
}




=head2 get_relationship_IsInstantiatedBy

  $return = $obj->get_relationship_IsInstantiatedBy($ids, $from_fields, $rel_fields, $to_fields)

=over 4

=item Parameter and return types

=begin html

<pre>
$ids is a reference to a list where each element is a string
$from_fields is a reference to a list where each element is a string
$rel_fields is a reference to a list where each element is a string
$to_fields is a reference to a list where each element is a string
$return is a reference to a list where each element is a reference to a list containing 3 items:
	0: a fields_Compartment
	1: a fields_IsInstantiatedBy
	2: a fields_ModelCompartment
fields_Compartment is a reference to a hash where the following keys are defined:
	id has a value which is a string
	abbr has a value which is a string
	mod_date has a value which is a string
	name has a value which is a string
	msid has a value which is a string
fields_IsInstantiatedBy is a reference to a hash where the following keys are defined:
	id has a value which is a string
fields_ModelCompartment is a reference to a hash where the following keys are defined:
	id has a value which is a string
	compartment_index has a value which is an int
	label has a value which is a reference to a list where each element is a string
	pH has a value which is a float
	potential has a value which is a float

</pre>

=end html

=begin text

$ids is a reference to a list where each element is a string
$from_fields is a reference to a list where each element is a string
$rel_fields is a reference to a list where each element is a string
$to_fields is a reference to a list where each element is a string
$return is a reference to a list where each element is a reference to a list containing 3 items:
	0: a fields_Compartment
	1: a fields_IsInstantiatedBy
	2: a fields_ModelCompartment
fields_Compartment is a reference to a hash where the following keys are defined:
	id has a value which is a string
	abbr has a value which is a string
	mod_date has a value which is a string
	name has a value which is a string
	msid has a value which is a string
fields_IsInstantiatedBy is a reference to a hash where the following keys are defined:
	id has a value which is a string
fields_ModelCompartment is a reference to a hash where the following keys are defined:
	id has a value which is a string
	compartment_index has a value which is an int
	label has a value which is a reference to a list where each element is a string
	pH has a value which is a float
	potential has a value which is a float


=end text



=item Description

This relationship connects a compartment to the instances
of that compartment that occur in models.
It has the following fields:

=over 4



=back

=back

=cut

sub get_relationship_IsInstantiatedBy
{
    my $self = shift;
    my($ids, $from_fields, $rel_fields, $to_fields) = @_;

    my @_bad_arguments;
    (ref($ids) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"ids\" (value was \"$ids\")");
    (ref($from_fields) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"from_fields\" (value was \"$from_fields\")");
    (ref($rel_fields) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"rel_fields\" (value was \"$rel_fields\")");
    (ref($to_fields) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"to_fields\" (value was \"$to_fields\")");
    if (@_bad_arguments) {
	my $msg = "Invalid arguments passed to get_relationship_IsInstantiatedBy:\n" . join("", map { "\t$_\n" } @_bad_arguments);
	Bio::KBase::Exceptions::ArgumentValidationError->throw(error => $msg,
							       method_name => 'get_relationship_IsInstantiatedBy');
    }

    my $ctx = $Bio::KBase::CDMI::Service::CallContext;
    my($return);
    #BEGIN get_relationship_IsInstantiatedBy

    $return = $self->_get_relationship($ctx, 'IsInstantiatedBy', 'IsInstantiatedBy', 0, $ids, $from_fields, $rel_fields, $to_fields);
	
    #END get_relationship_IsInstantiatedBy
    my @_bad_returns;
    (ref($return) eq 'ARRAY') or push(@_bad_returns, "Invalid type for return variable \"return\" (value was \"$return\")");
    if (@_bad_returns) {
	my $msg = "Invalid returns passed to get_relationship_IsInstantiatedBy:\n" . join("", map { "\t$_\n" } @_bad_returns);
	Bio::KBase::Exceptions::ArgumentValidationError->throw(error => $msg,
							       method_name => 'get_relationship_IsInstantiatedBy');
    }
    return($return);
}




=head2 get_relationship_IsInstanceOf

  $return = $obj->get_relationship_IsInstanceOf($ids, $from_fields, $rel_fields, $to_fields)

=over 4

=item Parameter and return types

=begin html

<pre>
$ids is a reference to a list where each element is a string
$from_fields is a reference to a list where each element is a string
$rel_fields is a reference to a list where each element is a string
$to_fields is a reference to a list where each element is a string
$return is a reference to a list where each element is a reference to a list containing 3 items:
	0: a fields_ModelCompartment
	1: a fields_IsInstantiatedBy
	2: a fields_Compartment
fields_ModelCompartment is a reference to a hash where the following keys are defined:
	id has a value which is a string
	compartment_index has a value which is an int
	label has a value which is a reference to a list where each element is a string
	pH has a value which is a float
	potential has a value which is a float
fields_IsInstantiatedBy is a reference to a hash where the following keys are defined:
	id has a value which is a string
fields_Compartment is a reference to a hash where the following keys are defined:
	id has a value which is a string
	abbr has a value which is a string
	mod_date has a value which is a string
	name has a value which is a string
	msid has a value which is a string

</pre>

=end html

=begin text

$ids is a reference to a list where each element is a string
$from_fields is a reference to a list where each element is a string
$rel_fields is a reference to a list where each element is a string
$to_fields is a reference to a list where each element is a string
$return is a reference to a list where each element is a reference to a list containing 3 items:
	0: a fields_ModelCompartment
	1: a fields_IsInstantiatedBy
	2: a fields_Compartment
fields_ModelCompartment is a reference to a hash where the following keys are defined:
	id has a value which is a string
	compartment_index has a value which is an int
	label has a value which is a reference to a list where each element is a string
	pH has a value which is a float
	potential has a value which is a float
fields_IsInstantiatedBy is a reference to a hash where the following keys are defined:
	id has a value which is a string
fields_Compartment is a reference to a hash where the following keys are defined:
	id has a value which is a string
	abbr has a value which is a string
	mod_date has a value which is a string
	name has a value which is a string
	msid has a value which is a string


=end text



=item Description



=back

=cut

sub get_relationship_IsInstanceOf
{
    my $self = shift;
    my($ids, $from_fields, $rel_fields, $to_fields) = @_;

    my @_bad_arguments;
    (ref($ids) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"ids\" (value was \"$ids\")");
    (ref($from_fields) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"from_fields\" (value was \"$from_fields\")");
    (ref($rel_fields) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"rel_fields\" (value was \"$rel_fields\")");
    (ref($to_fields) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"to_fields\" (value was \"$to_fields\")");
    if (@_bad_arguments) {
	my $msg = "Invalid arguments passed to get_relationship_IsInstanceOf:\n" . join("", map { "\t$_\n" } @_bad_arguments);
	Bio::KBase::Exceptions::ArgumentValidationError->throw(error => $msg,
							       method_name => 'get_relationship_IsInstanceOf');
    }

    my $ctx = $Bio::KBase::CDMI::Service::CallContext;
    my($return);
    #BEGIN get_relationship_IsInstanceOf

    $return = $self->_get_relationship($ctx, 'IsInstanceOf', 'IsInstantiatedBy', 1, $ids, $from_fields, $rel_fields, $to_fields);
	
    #END get_relationship_IsInstanceOf
    my @_bad_returns;
    (ref($return) eq 'ARRAY') or push(@_bad_returns, "Invalid type for return variable \"return\" (value was \"$return\")");
    if (@_bad_returns) {
	my $msg = "Invalid returns passed to get_relationship_IsInstanceOf:\n" . join("", map { "\t$_\n" } @_bad_returns);
	Bio::KBase::Exceptions::ArgumentValidationError->throw(error => $msg,
							       method_name => 'get_relationship_IsInstanceOf');
    }
    return($return);
}




=head2 get_relationship_IsLocatedIn

  $return = $obj->get_relationship_IsLocatedIn($ids, $from_fields, $rel_fields, $to_fields)

=over 4

=item Parameter and return types

=begin html

<pre>
$ids is a reference to a list where each element is a string
$from_fields is a reference to a list where each element is a string
$rel_fields is a reference to a list where each element is a string
$to_fields is a reference to a list where each element is a string
$return is a reference to a list where each element is a reference to a list containing 3 items:
	0: a fields_Feature
	1: a fields_IsLocatedIn
	2: a fields_Contig
fields_Feature is a reference to a hash where the following keys are defined:
	id has a value which is a string
	feature_type has a value which is a string
	source_id has a value which is a string
	sequence_length has a value which is an int
	function has a value which is a string
	alias has a value which is a reference to a list where each element is a string
fields_IsLocatedIn is a reference to a hash where the following keys are defined:
	id has a value which is a string
	ordinal has a value which is an int
	begin has a value which is an int
	len has a value which is an int
	dir has a value which is a string
fields_Contig is a reference to a hash where the following keys are defined:
	id has a value which is a string
	source_id has a value which is a string

</pre>

=end html

=begin text

$ids is a reference to a list where each element is a string
$from_fields is a reference to a list where each element is a string
$rel_fields is a reference to a list where each element is a string
$to_fields is a reference to a list where each element is a string
$return is a reference to a list where each element is a reference to a list containing 3 items:
	0: a fields_Feature
	1: a fields_IsLocatedIn
	2: a fields_Contig
fields_Feature is a reference to a hash where the following keys are defined:
	id has a value which is a string
	feature_type has a value which is a string
	source_id has a value which is a string
	sequence_length has a value which is an int
	function has a value which is a string
	alias has a value which is a reference to a list where each element is a string
fields_IsLocatedIn is a reference to a hash where the following keys are defined:
	id has a value which is a string
	ordinal has a value which is an int
	begin has a value which is an int
	len has a value which is an int
	dir has a value which is a string
fields_Contig is a reference to a hash where the following keys are defined:
	id has a value which is a string
	source_id has a value which is a string


=end text



=item Description

A feature is a set of DNA sequence fragments. Most features
are a single contiquous fragment, so they are located in only one
DNA sequence; however, fragments have a maximum length, so even a
single contiguous feature may participate in this relationship
multiple times. A few features belong to multiple DNA sequences. In
that case, however, all the DNA sequences belong to the same genome.
A DNA sequence itself will frequently have thousands of features
connected to it.
It has the following fields:

=over 4


=item ordinal

Sequence number of this segment, starting from 1
and proceeding sequentially forward from there.


=item begin

Index (1-based) of the first residue in the contig
that belongs to the segment.


=item len

Length of this segment.


=item dir

Direction (strand) of the segment: "+" if it is
forward and "-" if it is backward.



=back

=back

=cut

sub get_relationship_IsLocatedIn
{
    my $self = shift;
    my($ids, $from_fields, $rel_fields, $to_fields) = @_;

    my @_bad_arguments;
    (ref($ids) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"ids\" (value was \"$ids\")");
    (ref($from_fields) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"from_fields\" (value was \"$from_fields\")");
    (ref($rel_fields) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"rel_fields\" (value was \"$rel_fields\")");
    (ref($to_fields) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"to_fields\" (value was \"$to_fields\")");
    if (@_bad_arguments) {
	my $msg = "Invalid arguments passed to get_relationship_IsLocatedIn:\n" . join("", map { "\t$_\n" } @_bad_arguments);
	Bio::KBase::Exceptions::ArgumentValidationError->throw(error => $msg,
							       method_name => 'get_relationship_IsLocatedIn');
    }

    my $ctx = $Bio::KBase::CDMI::Service::CallContext;
    my($return);
    #BEGIN get_relationship_IsLocatedIn

    $return = $self->_get_relationship($ctx, 'IsLocatedIn', 'IsLocatedIn', 0, $ids, $from_fields, $rel_fields, $to_fields);
	
    #END get_relationship_IsLocatedIn
    my @_bad_returns;
    (ref($return) eq 'ARRAY') or push(@_bad_returns, "Invalid type for return variable \"return\" (value was \"$return\")");
    if (@_bad_returns) {
	my $msg = "Invalid returns passed to get_relationship_IsLocatedIn:\n" . join("", map { "\t$_\n" } @_bad_returns);
	Bio::KBase::Exceptions::ArgumentValidationError->throw(error => $msg,
							       method_name => 'get_relationship_IsLocatedIn');
    }
    return($return);
}




=head2 get_relationship_IsLocusFor

  $return = $obj->get_relationship_IsLocusFor($ids, $from_fields, $rel_fields, $to_fields)

=over 4

=item Parameter and return types

=begin html

<pre>
$ids is a reference to a list where each element is a string
$from_fields is a reference to a list where each element is a string
$rel_fields is a reference to a list where each element is a string
$to_fields is a reference to a list where each element is a string
$return is a reference to a list where each element is a reference to a list containing 3 items:
	0: a fields_Contig
	1: a fields_IsLocatedIn
	2: a fields_Feature
fields_Contig is a reference to a hash where the following keys are defined:
	id has a value which is a string
	source_id has a value which is a string
fields_IsLocatedIn is a reference to a hash where the following keys are defined:
	id has a value which is a string
	ordinal has a value which is an int
	begin has a value which is an int
	len has a value which is an int
	dir has a value which is a string
fields_Feature is a reference to a hash where the following keys are defined:
	id has a value which is a string
	feature_type has a value which is a string
	source_id has a value which is a string
	sequence_length has a value which is an int
	function has a value which is a string
	alias has a value which is a reference to a list where each element is a string

</pre>

=end html

=begin text

$ids is a reference to a list where each element is a string
$from_fields is a reference to a list where each element is a string
$rel_fields is a reference to a list where each element is a string
$to_fields is a reference to a list where each element is a string
$return is a reference to a list where each element is a reference to a list containing 3 items:
	0: a fields_Contig
	1: a fields_IsLocatedIn
	2: a fields_Feature
fields_Contig is a reference to a hash where the following keys are defined:
	id has a value which is a string
	source_id has a value which is a string
fields_IsLocatedIn is a reference to a hash where the following keys are defined:
	id has a value which is a string
	ordinal has a value which is an int
	begin has a value which is an int
	len has a value which is an int
	dir has a value which is a string
fields_Feature is a reference to a hash where the following keys are defined:
	id has a value which is a string
	feature_type has a value which is a string
	source_id has a value which is a string
	sequence_length has a value which is an int
	function has a value which is a string
	alias has a value which is a reference to a list where each element is a string


=end text



=item Description



=back

=cut

sub get_relationship_IsLocusFor
{
    my $self = shift;
    my($ids, $from_fields, $rel_fields, $to_fields) = @_;

    my @_bad_arguments;
    (ref($ids) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"ids\" (value was \"$ids\")");
    (ref($from_fields) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"from_fields\" (value was \"$from_fields\")");
    (ref($rel_fields) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"rel_fields\" (value was \"$rel_fields\")");
    (ref($to_fields) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"to_fields\" (value was \"$to_fields\")");
    if (@_bad_arguments) {
	my $msg = "Invalid arguments passed to get_relationship_IsLocusFor:\n" . join("", map { "\t$_\n" } @_bad_arguments);
	Bio::KBase::Exceptions::ArgumentValidationError->throw(error => $msg,
							       method_name => 'get_relationship_IsLocusFor');
    }

    my $ctx = $Bio::KBase::CDMI::Service::CallContext;
    my($return);
    #BEGIN get_relationship_IsLocusFor

    $return = $self->_get_relationship($ctx, 'IsLocusFor', 'IsLocatedIn', 1, $ids, $from_fields, $rel_fields, $to_fields);
	
    #END get_relationship_IsLocusFor
    my @_bad_returns;
    (ref($return) eq 'ARRAY') or push(@_bad_returns, "Invalid type for return variable \"return\" (value was \"$return\")");
    if (@_bad_returns) {
	my $msg = "Invalid returns passed to get_relationship_IsLocusFor:\n" . join("", map { "\t$_\n" } @_bad_returns);
	Bio::KBase::Exceptions::ArgumentValidationError->throw(error => $msg,
							       method_name => 'get_relationship_IsLocusFor');
    }
    return($return);
}




=head2 get_relationship_IsModeledBy

  $return = $obj->get_relationship_IsModeledBy($ids, $from_fields, $rel_fields, $to_fields)

=over 4

=item Parameter and return types

=begin html

<pre>
$ids is a reference to a list where each element is a string
$from_fields is a reference to a list where each element is a string
$rel_fields is a reference to a list where each element is a string
$to_fields is a reference to a list where each element is a string
$return is a reference to a list where each element is a reference to a list containing 3 items:
	0: a fields_Genome
	1: a fields_IsModeledBy
	2: a fields_Model
fields_Genome is a reference to a hash where the following keys are defined:
	id has a value which is a string
	pegs has a value which is an int
	rnas has a value which is an int
	scientific_name has a value which is a string
	complete has a value which is an int
	prokaryotic has a value which is an int
	dna_size has a value which is an int
	contigs has a value which is an int
	domain has a value which is a string
	genetic_code has a value which is an int
	gc_content has a value which is a float
	phenotype has a value which is a reference to a list where each element is a string
	md5 has a value which is a string
	source_id has a value which is a string
fields_IsModeledBy is a reference to a hash where the following keys are defined:
	id has a value which is a string
fields_Model is a reference to a hash where the following keys are defined:
	id has a value which is a string
	mod_date has a value which is a string
	name has a value which is a string
	version has a value which is an int
	type has a value which is a string
	status has a value which is a string
	reaction_count has a value which is an int
	compound_count has a value which is an int
	annotation_count has a value which is an int

</pre>

=end html

=begin text

$ids is a reference to a list where each element is a string
$from_fields is a reference to a list where each element is a string
$rel_fields is a reference to a list where each element is a string
$to_fields is a reference to a list where each element is a string
$return is a reference to a list where each element is a reference to a list containing 3 items:
	0: a fields_Genome
	1: a fields_IsModeledBy
	2: a fields_Model
fields_Genome is a reference to a hash where the following keys are defined:
	id has a value which is a string
	pegs has a value which is an int
	rnas has a value which is an int
	scientific_name has a value which is a string
	complete has a value which is an int
	prokaryotic has a value which is an int
	dna_size has a value which is an int
	contigs has a value which is an int
	domain has a value which is a string
	genetic_code has a value which is an int
	gc_content has a value which is a float
	phenotype has a value which is a reference to a list where each element is a string
	md5 has a value which is a string
	source_id has a value which is a string
fields_IsModeledBy is a reference to a hash where the following keys are defined:
	id has a value which is a string
fields_Model is a reference to a hash where the following keys are defined:
	id has a value which is a string
	mod_date has a value which is a string
	name has a value which is a string
	version has a value which is an int
	type has a value which is a string
	status has a value which is a string
	reaction_count has a value which is an int
	compound_count has a value which is an int
	annotation_count has a value which is an int


=end text



=item Description

A genome can be modeled by many different models, but a model belongs
to only one genome.
It has the following fields:

=over 4



=back

=back

=cut

sub get_relationship_IsModeledBy
{
    my $self = shift;
    my($ids, $from_fields, $rel_fields, $to_fields) = @_;

    my @_bad_arguments;
    (ref($ids) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"ids\" (value was \"$ids\")");
    (ref($from_fields) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"from_fields\" (value was \"$from_fields\")");
    (ref($rel_fields) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"rel_fields\" (value was \"$rel_fields\")");
    (ref($to_fields) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"to_fields\" (value was \"$to_fields\")");
    if (@_bad_arguments) {
	my $msg = "Invalid arguments passed to get_relationship_IsModeledBy:\n" . join("", map { "\t$_\n" } @_bad_arguments);
	Bio::KBase::Exceptions::ArgumentValidationError->throw(error => $msg,
							       method_name => 'get_relationship_IsModeledBy');
    }

    my $ctx = $Bio::KBase::CDMI::Service::CallContext;
    my($return);
    #BEGIN get_relationship_IsModeledBy

    $return = $self->_get_relationship($ctx, 'IsModeledBy', 'IsModeledBy', 0, $ids, $from_fields, $rel_fields, $to_fields);
	
    #END get_relationship_IsModeledBy
    my @_bad_returns;
    (ref($return) eq 'ARRAY') or push(@_bad_returns, "Invalid type for return variable \"return\" (value was \"$return\")");
    if (@_bad_returns) {
	my $msg = "Invalid returns passed to get_relationship_IsModeledBy:\n" . join("", map { "\t$_\n" } @_bad_returns);
	Bio::KBase::Exceptions::ArgumentValidationError->throw(error => $msg,
							       method_name => 'get_relationship_IsModeledBy');
    }
    return($return);
}




=head2 get_relationship_Models

  $return = $obj->get_relationship_Models($ids, $from_fields, $rel_fields, $to_fields)

=over 4

=item Parameter and return types

=begin html

<pre>
$ids is a reference to a list where each element is a string
$from_fields is a reference to a list where each element is a string
$rel_fields is a reference to a list where each element is a string
$to_fields is a reference to a list where each element is a string
$return is a reference to a list where each element is a reference to a list containing 3 items:
	0: a fields_Model
	1: a fields_IsModeledBy
	2: a fields_Genome
fields_Model is a reference to a hash where the following keys are defined:
	id has a value which is a string
	mod_date has a value which is a string
	name has a value which is a string
	version has a value which is an int
	type has a value which is a string
	status has a value which is a string
	reaction_count has a value which is an int
	compound_count has a value which is an int
	annotation_count has a value which is an int
fields_IsModeledBy is a reference to a hash where the following keys are defined:
	id has a value which is a string
fields_Genome is a reference to a hash where the following keys are defined:
	id has a value which is a string
	pegs has a value which is an int
	rnas has a value which is an int
	scientific_name has a value which is a string
	complete has a value which is an int
	prokaryotic has a value which is an int
	dna_size has a value which is an int
	contigs has a value which is an int
	domain has a value which is a string
	genetic_code has a value which is an int
	gc_content has a value which is a float
	phenotype has a value which is a reference to a list where each element is a string
	md5 has a value which is a string
	source_id has a value which is a string

</pre>

=end html

=begin text

$ids is a reference to a list where each element is a string
$from_fields is a reference to a list where each element is a string
$rel_fields is a reference to a list where each element is a string
$to_fields is a reference to a list where each element is a string
$return is a reference to a list where each element is a reference to a list containing 3 items:
	0: a fields_Model
	1: a fields_IsModeledBy
	2: a fields_Genome
fields_Model is a reference to a hash where the following keys are defined:
	id has a value which is a string
	mod_date has a value which is a string
	name has a value which is a string
	version has a value which is an int
	type has a value which is a string
	status has a value which is a string
	reaction_count has a value which is an int
	compound_count has a value which is an int
	annotation_count has a value which is an int
fields_IsModeledBy is a reference to a hash where the following keys are defined:
	id has a value which is a string
fields_Genome is a reference to a hash where the following keys are defined:
	id has a value which is a string
	pegs has a value which is an int
	rnas has a value which is an int
	scientific_name has a value which is a string
	complete has a value which is an int
	prokaryotic has a value which is an int
	dna_size has a value which is an int
	contigs has a value which is an int
	domain has a value which is a string
	genetic_code has a value which is an int
	gc_content has a value which is a float
	phenotype has a value which is a reference to a list where each element is a string
	md5 has a value which is a string
	source_id has a value which is a string


=end text



=item Description



=back

=cut

sub get_relationship_Models
{
    my $self = shift;
    my($ids, $from_fields, $rel_fields, $to_fields) = @_;

    my @_bad_arguments;
    (ref($ids) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"ids\" (value was \"$ids\")");
    (ref($from_fields) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"from_fields\" (value was \"$from_fields\")");
    (ref($rel_fields) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"rel_fields\" (value was \"$rel_fields\")");
    (ref($to_fields) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"to_fields\" (value was \"$to_fields\")");
    if (@_bad_arguments) {
	my $msg = "Invalid arguments passed to get_relationship_Models:\n" . join("", map { "\t$_\n" } @_bad_arguments);
	Bio::KBase::Exceptions::ArgumentValidationError->throw(error => $msg,
							       method_name => 'get_relationship_Models');
    }

    my $ctx = $Bio::KBase::CDMI::Service::CallContext;
    my($return);
    #BEGIN get_relationship_Models

    $return = $self->_get_relationship($ctx, 'Models', 'IsModeledBy', 1, $ids, $from_fields, $rel_fields, $to_fields);
	
    #END get_relationship_Models
    my @_bad_returns;
    (ref($return) eq 'ARRAY') or push(@_bad_returns, "Invalid type for return variable \"return\" (value was \"$return\")");
    if (@_bad_returns) {
	my $msg = "Invalid returns passed to get_relationship_Models:\n" . join("", map { "\t$_\n" } @_bad_returns);
	Bio::KBase::Exceptions::ArgumentValidationError->throw(error => $msg,
							       method_name => 'get_relationship_Models');
    }
    return($return);
}




=head2 get_relationship_IsOwnerOf

  $return = $obj->get_relationship_IsOwnerOf($ids, $from_fields, $rel_fields, $to_fields)

=over 4

=item Parameter and return types

=begin html

<pre>
$ids is a reference to a list where each element is a string
$from_fields is a reference to a list where each element is a string
$rel_fields is a reference to a list where each element is a string
$to_fields is a reference to a list where each element is a string
$return is a reference to a list where each element is a reference to a list containing 3 items:
	0: a fields_Genome
	1: a fields_IsOwnerOf
	2: a fields_Feature
fields_Genome is a reference to a hash where the following keys are defined:
	id has a value which is a string
	pegs has a value which is an int
	rnas has a value which is an int
	scientific_name has a value which is a string
	complete has a value which is an int
	prokaryotic has a value which is an int
	dna_size has a value which is an int
	contigs has a value which is an int
	domain has a value which is a string
	genetic_code has a value which is an int
	gc_content has a value which is a float
	phenotype has a value which is a reference to a list where each element is a string
	md5 has a value which is a string
	source_id has a value which is a string
fields_IsOwnerOf is a reference to a hash where the following keys are defined:
	id has a value which is a string
fields_Feature is a reference to a hash where the following keys are defined:
	id has a value which is a string
	feature_type has a value which is a string
	source_id has a value which is a string
	sequence_length has a value which is an int
	function has a value which is a string
	alias has a value which is a reference to a list where each element is a string

</pre>

=end html

=begin text

$ids is a reference to a list where each element is a string
$from_fields is a reference to a list where each element is a string
$rel_fields is a reference to a list where each element is a string
$to_fields is a reference to a list where each element is a string
$return is a reference to a list where each element is a reference to a list containing 3 items:
	0: a fields_Genome
	1: a fields_IsOwnerOf
	2: a fields_Feature
fields_Genome is a reference to a hash where the following keys are defined:
	id has a value which is a string
	pegs has a value which is an int
	rnas has a value which is an int
	scientific_name has a value which is a string
	complete has a value which is an int
	prokaryotic has a value which is an int
	dna_size has a value which is an int
	contigs has a value which is an int
	domain has a value which is a string
	genetic_code has a value which is an int
	gc_content has a value which is a float
	phenotype has a value which is a reference to a list where each element is a string
	md5 has a value which is a string
	source_id has a value which is a string
fields_IsOwnerOf is a reference to a hash where the following keys are defined:
	id has a value which is a string
fields_Feature is a reference to a hash where the following keys are defined:
	id has a value which is a string
	feature_type has a value which is a string
	source_id has a value which is a string
	sequence_length has a value which is an int
	function has a value which is a string
	alias has a value which is a reference to a list where each element is a string


=end text



=item Description

This relationship connects a genome to the features it
contains. Though technically redundant (the information is
available from the feature's contigs), it simplifies the
extremely common process of finding all features for a
genome.
It has the following fields:

=over 4



=back

=back

=cut

sub get_relationship_IsOwnerOf
{
    my $self = shift;
    my($ids, $from_fields, $rel_fields, $to_fields) = @_;

    my @_bad_arguments;
    (ref($ids) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"ids\" (value was \"$ids\")");
    (ref($from_fields) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"from_fields\" (value was \"$from_fields\")");
    (ref($rel_fields) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"rel_fields\" (value was \"$rel_fields\")");
    (ref($to_fields) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"to_fields\" (value was \"$to_fields\")");
    if (@_bad_arguments) {
	my $msg = "Invalid arguments passed to get_relationship_IsOwnerOf:\n" . join("", map { "\t$_\n" } @_bad_arguments);
	Bio::KBase::Exceptions::ArgumentValidationError->throw(error => $msg,
							       method_name => 'get_relationship_IsOwnerOf');
    }

    my $ctx = $Bio::KBase::CDMI::Service::CallContext;
    my($return);
    #BEGIN get_relationship_IsOwnerOf

    $return = $self->_get_relationship($ctx, 'IsOwnerOf', 'IsOwnerOf', 0, $ids, $from_fields, $rel_fields, $to_fields);
	
    #END get_relationship_IsOwnerOf
    my @_bad_returns;
    (ref($return) eq 'ARRAY') or push(@_bad_returns, "Invalid type for return variable \"return\" (value was \"$return\")");
    if (@_bad_returns) {
	my $msg = "Invalid returns passed to get_relationship_IsOwnerOf:\n" . join("", map { "\t$_\n" } @_bad_returns);
	Bio::KBase::Exceptions::ArgumentValidationError->throw(error => $msg,
							       method_name => 'get_relationship_IsOwnerOf');
    }
    return($return);
}




=head2 get_relationship_IsOwnedBy

  $return = $obj->get_relationship_IsOwnedBy($ids, $from_fields, $rel_fields, $to_fields)

=over 4

=item Parameter and return types

=begin html

<pre>
$ids is a reference to a list where each element is a string
$from_fields is a reference to a list where each element is a string
$rel_fields is a reference to a list where each element is a string
$to_fields is a reference to a list where each element is a string
$return is a reference to a list where each element is a reference to a list containing 3 items:
	0: a fields_Feature
	1: a fields_IsOwnerOf
	2: a fields_Genome
fields_Feature is a reference to a hash where the following keys are defined:
	id has a value which is a string
	feature_type has a value which is a string
	source_id has a value which is a string
	sequence_length has a value which is an int
	function has a value which is a string
	alias has a value which is a reference to a list where each element is a string
fields_IsOwnerOf is a reference to a hash where the following keys are defined:
	id has a value which is a string
fields_Genome is a reference to a hash where the following keys are defined:
	id has a value which is a string
	pegs has a value which is an int
	rnas has a value which is an int
	scientific_name has a value which is a string
	complete has a value which is an int
	prokaryotic has a value which is an int
	dna_size has a value which is an int
	contigs has a value which is an int
	domain has a value which is a string
	genetic_code has a value which is an int
	gc_content has a value which is a float
	phenotype has a value which is a reference to a list where each element is a string
	md5 has a value which is a string
	source_id has a value which is a string

</pre>

=end html

=begin text

$ids is a reference to a list where each element is a string
$from_fields is a reference to a list where each element is a string
$rel_fields is a reference to a list where each element is a string
$to_fields is a reference to a list where each element is a string
$return is a reference to a list where each element is a reference to a list containing 3 items:
	0: a fields_Feature
	1: a fields_IsOwnerOf
	2: a fields_Genome
fields_Feature is a reference to a hash where the following keys are defined:
	id has a value which is a string
	feature_type has a value which is a string
	source_id has a value which is a string
	sequence_length has a value which is an int
	function has a value which is a string
	alias has a value which is a reference to a list where each element is a string
fields_IsOwnerOf is a reference to a hash where the following keys are defined:
	id has a value which is a string
fields_Genome is a reference to a hash where the following keys are defined:
	id has a value which is a string
	pegs has a value which is an int
	rnas has a value which is an int
	scientific_name has a value which is a string
	complete has a value which is an int
	prokaryotic has a value which is an int
	dna_size has a value which is an int
	contigs has a value which is an int
	domain has a value which is a string
	genetic_code has a value which is an int
	gc_content has a value which is a float
	phenotype has a value which is a reference to a list where each element is a string
	md5 has a value which is a string
	source_id has a value which is a string


=end text



=item Description



=back

=cut

sub get_relationship_IsOwnedBy
{
    my $self = shift;
    my($ids, $from_fields, $rel_fields, $to_fields) = @_;

    my @_bad_arguments;
    (ref($ids) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"ids\" (value was \"$ids\")");
    (ref($from_fields) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"from_fields\" (value was \"$from_fields\")");
    (ref($rel_fields) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"rel_fields\" (value was \"$rel_fields\")");
    (ref($to_fields) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"to_fields\" (value was \"$to_fields\")");
    if (@_bad_arguments) {
	my $msg = "Invalid arguments passed to get_relationship_IsOwnedBy:\n" . join("", map { "\t$_\n" } @_bad_arguments);
	Bio::KBase::Exceptions::ArgumentValidationError->throw(error => $msg,
							       method_name => 'get_relationship_IsOwnedBy');
    }

    my $ctx = $Bio::KBase::CDMI::Service::CallContext;
    my($return);
    #BEGIN get_relationship_IsOwnedBy

    $return = $self->_get_relationship($ctx, 'IsOwnedBy', 'IsOwnerOf', 1, $ids, $from_fields, $rel_fields, $to_fields);
	
    #END get_relationship_IsOwnedBy
    my @_bad_returns;
    (ref($return) eq 'ARRAY') or push(@_bad_returns, "Invalid type for return variable \"return\" (value was \"$return\")");
    if (@_bad_returns) {
	my $msg = "Invalid returns passed to get_relationship_IsOwnedBy:\n" . join("", map { "\t$_\n" } @_bad_returns);
	Bio::KBase::Exceptions::ArgumentValidationError->throw(error => $msg,
							       method_name => 'get_relationship_IsOwnedBy');
    }
    return($return);
}




=head2 get_relationship_IsProposedLocationOf

  $return = $obj->get_relationship_IsProposedLocationOf($ids, $from_fields, $rel_fields, $to_fields)

=over 4

=item Parameter and return types

=begin html

<pre>
$ids is a reference to a list where each element is a string
$from_fields is a reference to a list where each element is a string
$rel_fields is a reference to a list where each element is a string
$to_fields is a reference to a list where each element is a string
$return is a reference to a list where each element is a reference to a list containing 3 items:
	0: a fields_Compartment
	1: a fields_IsProposedLocationOf
	2: a fields_ReactionRule
fields_Compartment is a reference to a hash where the following keys are defined:
	id has a value which is a string
	abbr has a value which is a string
	mod_date has a value which is a string
	name has a value which is a string
	msid has a value which is a string
fields_IsProposedLocationOf is a reference to a hash where the following keys are defined:
	id has a value which is a string
	type has a value which is a string
fields_ReactionRule is a reference to a hash where the following keys are defined:
	id has a value which is a string
	direction has a value which is a string
	transproton has a value which is a float

</pre>

=end html

=begin text

$ids is a reference to a list where each element is a string
$from_fields is a reference to a list where each element is a string
$rel_fields is a reference to a list where each element is a string
$to_fields is a reference to a list where each element is a string
$return is a reference to a list where each element is a reference to a list containing 3 items:
	0: a fields_Compartment
	1: a fields_IsProposedLocationOf
	2: a fields_ReactionRule
fields_Compartment is a reference to a hash where the following keys are defined:
	id has a value which is a string
	abbr has a value which is a string
	mod_date has a value which is a string
	name has a value which is a string
	msid has a value which is a string
fields_IsProposedLocationOf is a reference to a hash where the following keys are defined:
	id has a value which is a string
	type has a value which is a string
fields_ReactionRule is a reference to a hash where the following keys are defined:
	id has a value which is a string
	direction has a value which is a string
	transproton has a value which is a float


=end text



=item Description

This relationship connects a reaction as it is used in
a complex to the compartments in which it usually takes place.
Most reactions take place in a single compartment. Transporters
take place in two compartments.
It has the following fields:

=over 4


=item type

role of the compartment in the reaction: 'primary'
if it is the sole or starting compartment, 'secondary' if
it is the ending compartment in a multi-compartmental
reaction



=back

=back

=cut

sub get_relationship_IsProposedLocationOf
{
    my $self = shift;
    my($ids, $from_fields, $rel_fields, $to_fields) = @_;

    my @_bad_arguments;
    (ref($ids) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"ids\" (value was \"$ids\")");
    (ref($from_fields) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"from_fields\" (value was \"$from_fields\")");
    (ref($rel_fields) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"rel_fields\" (value was \"$rel_fields\")");
    (ref($to_fields) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"to_fields\" (value was \"$to_fields\")");
    if (@_bad_arguments) {
	my $msg = "Invalid arguments passed to get_relationship_IsProposedLocationOf:\n" . join("", map { "\t$_\n" } @_bad_arguments);
	Bio::KBase::Exceptions::ArgumentValidationError->throw(error => $msg,
							       method_name => 'get_relationship_IsProposedLocationOf');
    }

    my $ctx = $Bio::KBase::CDMI::Service::CallContext;
    my($return);
    #BEGIN get_relationship_IsProposedLocationOf

    $return = $self->_get_relationship($ctx, 'IsProposedLocationOf', 'IsProposedLocationOf', 0, $ids, $from_fields, $rel_fields, $to_fields);
	
    #END get_relationship_IsProposedLocationOf
    my @_bad_returns;
    (ref($return) eq 'ARRAY') or push(@_bad_returns, "Invalid type for return variable \"return\" (value was \"$return\")");
    if (@_bad_returns) {
	my $msg = "Invalid returns passed to get_relationship_IsProposedLocationOf:\n" . join("", map { "\t$_\n" } @_bad_returns);
	Bio::KBase::Exceptions::ArgumentValidationError->throw(error => $msg,
							       method_name => 'get_relationship_IsProposedLocationOf');
    }
    return($return);
}




=head2 get_relationship_HasProposedLocationIn

  $return = $obj->get_relationship_HasProposedLocationIn($ids, $from_fields, $rel_fields, $to_fields)

=over 4

=item Parameter and return types

=begin html

<pre>
$ids is a reference to a list where each element is a string
$from_fields is a reference to a list where each element is a string
$rel_fields is a reference to a list where each element is a string
$to_fields is a reference to a list where each element is a string
$return is a reference to a list where each element is a reference to a list containing 3 items:
	0: a fields_ReactionRule
	1: a fields_IsProposedLocationOf
	2: a fields_Compartment
fields_ReactionRule is a reference to a hash where the following keys are defined:
	id has a value which is a string
	direction has a value which is a string
	transproton has a value which is a float
fields_IsProposedLocationOf is a reference to a hash where the following keys are defined:
	id has a value which is a string
	type has a value which is a string
fields_Compartment is a reference to a hash where the following keys are defined:
	id has a value which is a string
	abbr has a value which is a string
	mod_date has a value which is a string
	name has a value which is a string
	msid has a value which is a string

</pre>

=end html

=begin text

$ids is a reference to a list where each element is a string
$from_fields is a reference to a list where each element is a string
$rel_fields is a reference to a list where each element is a string
$to_fields is a reference to a list where each element is a string
$return is a reference to a list where each element is a reference to a list containing 3 items:
	0: a fields_ReactionRule
	1: a fields_IsProposedLocationOf
	2: a fields_Compartment
fields_ReactionRule is a reference to a hash where the following keys are defined:
	id has a value which is a string
	direction has a value which is a string
	transproton has a value which is a float
fields_IsProposedLocationOf is a reference to a hash where the following keys are defined:
	id has a value which is a string
	type has a value which is a string
fields_Compartment is a reference to a hash where the following keys are defined:
	id has a value which is a string
	abbr has a value which is a string
	mod_date has a value which is a string
	name has a value which is a string
	msid has a value which is a string


=end text



=item Description



=back

=cut

sub get_relationship_HasProposedLocationIn
{
    my $self = shift;
    my($ids, $from_fields, $rel_fields, $to_fields) = @_;

    my @_bad_arguments;
    (ref($ids) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"ids\" (value was \"$ids\")");
    (ref($from_fields) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"from_fields\" (value was \"$from_fields\")");
    (ref($rel_fields) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"rel_fields\" (value was \"$rel_fields\")");
    (ref($to_fields) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"to_fields\" (value was \"$to_fields\")");
    if (@_bad_arguments) {
	my $msg = "Invalid arguments passed to get_relationship_HasProposedLocationIn:\n" . join("", map { "\t$_\n" } @_bad_arguments);
	Bio::KBase::Exceptions::ArgumentValidationError->throw(error => $msg,
							       method_name => 'get_relationship_HasProposedLocationIn');
    }

    my $ctx = $Bio::KBase::CDMI::Service::CallContext;
    my($return);
    #BEGIN get_relationship_HasProposedLocationIn

    $return = $self->_get_relationship($ctx, 'HasProposedLocationIn', 'IsProposedLocationOf', 1, $ids, $from_fields, $rel_fields, $to_fields);
	
    #END get_relationship_HasProposedLocationIn
    my @_bad_returns;
    (ref($return) eq 'ARRAY') or push(@_bad_returns, "Invalid type for return variable \"return\" (value was \"$return\")");
    if (@_bad_returns) {
	my $msg = "Invalid returns passed to get_relationship_HasProposedLocationIn:\n" . join("", map { "\t$_\n" } @_bad_returns);
	Bio::KBase::Exceptions::ArgumentValidationError->throw(error => $msg,
							       method_name => 'get_relationship_HasProposedLocationIn');
    }
    return($return);
}




=head2 get_relationship_IsProteinFor

  $return = $obj->get_relationship_IsProteinFor($ids, $from_fields, $rel_fields, $to_fields)

=over 4

=item Parameter and return types

=begin html

<pre>
$ids is a reference to a list where each element is a string
$from_fields is a reference to a list where each element is a string
$rel_fields is a reference to a list where each element is a string
$to_fields is a reference to a list where each element is a string
$return is a reference to a list where each element is a reference to a list containing 3 items:
	0: a fields_ProteinSequence
	1: a fields_IsProteinFor
	2: a fields_Feature
fields_ProteinSequence is a reference to a hash where the following keys are defined:
	id has a value which is a string
	sequence has a value which is a string
fields_IsProteinFor is a reference to a hash where the following keys are defined:
	id has a value which is a string
fields_Feature is a reference to a hash where the following keys are defined:
	id has a value which is a string
	feature_type has a value which is a string
	source_id has a value which is a string
	sequence_length has a value which is an int
	function has a value which is a string
	alias has a value which is a reference to a list where each element is a string

</pre>

=end html

=begin text

$ids is a reference to a list where each element is a string
$from_fields is a reference to a list where each element is a string
$rel_fields is a reference to a list where each element is a string
$to_fields is a reference to a list where each element is a string
$return is a reference to a list where each element is a reference to a list containing 3 items:
	0: a fields_ProteinSequence
	1: a fields_IsProteinFor
	2: a fields_Feature
fields_ProteinSequence is a reference to a hash where the following keys are defined:
	id has a value which is a string
	sequence has a value which is a string
fields_IsProteinFor is a reference to a hash where the following keys are defined:
	id has a value which is a string
fields_Feature is a reference to a hash where the following keys are defined:
	id has a value which is a string
	feature_type has a value which is a string
	source_id has a value which is a string
	sequence_length has a value which is an int
	function has a value which is a string
	alias has a value which is a reference to a list where each element is a string


=end text



=item Description

This relationship connects a peg feature to the protein
sequence it produces (if any). Only peg features participate in this
relationship. A single protein sequence will frequently be produced
by many features.
It has the following fields:

=over 4



=back

=back

=cut

sub get_relationship_IsProteinFor
{
    my $self = shift;
    my($ids, $from_fields, $rel_fields, $to_fields) = @_;

    my @_bad_arguments;
    (ref($ids) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"ids\" (value was \"$ids\")");
    (ref($from_fields) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"from_fields\" (value was \"$from_fields\")");
    (ref($rel_fields) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"rel_fields\" (value was \"$rel_fields\")");
    (ref($to_fields) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"to_fields\" (value was \"$to_fields\")");
    if (@_bad_arguments) {
	my $msg = "Invalid arguments passed to get_relationship_IsProteinFor:\n" . join("", map { "\t$_\n" } @_bad_arguments);
	Bio::KBase::Exceptions::ArgumentValidationError->throw(error => $msg,
							       method_name => 'get_relationship_IsProteinFor');
    }

    my $ctx = $Bio::KBase::CDMI::Service::CallContext;
    my($return);
    #BEGIN get_relationship_IsProteinFor

    $return = $self->_get_relationship($ctx, 'IsProteinFor', 'IsProteinFor', 0, $ids, $from_fields, $rel_fields, $to_fields);
	
    #END get_relationship_IsProteinFor
    my @_bad_returns;
    (ref($return) eq 'ARRAY') or push(@_bad_returns, "Invalid type for return variable \"return\" (value was \"$return\")");
    if (@_bad_returns) {
	my $msg = "Invalid returns passed to get_relationship_IsProteinFor:\n" . join("", map { "\t$_\n" } @_bad_returns);
	Bio::KBase::Exceptions::ArgumentValidationError->throw(error => $msg,
							       method_name => 'get_relationship_IsProteinFor');
    }
    return($return);
}




=head2 get_relationship_Produces

  $return = $obj->get_relationship_Produces($ids, $from_fields, $rel_fields, $to_fields)

=over 4

=item Parameter and return types

=begin html

<pre>
$ids is a reference to a list where each element is a string
$from_fields is a reference to a list where each element is a string
$rel_fields is a reference to a list where each element is a string
$to_fields is a reference to a list where each element is a string
$return is a reference to a list where each element is a reference to a list containing 3 items:
	0: a fields_Feature
	1: a fields_IsProteinFor
	2: a fields_ProteinSequence
fields_Feature is a reference to a hash where the following keys are defined:
	id has a value which is a string
	feature_type has a value which is a string
	source_id has a value which is a string
	sequence_length has a value which is an int
	function has a value which is a string
	alias has a value which is a reference to a list where each element is a string
fields_IsProteinFor is a reference to a hash where the following keys are defined:
	id has a value which is a string
fields_ProteinSequence is a reference to a hash where the following keys are defined:
	id has a value which is a string
	sequence has a value which is a string

</pre>

=end html

=begin text

$ids is a reference to a list where each element is a string
$from_fields is a reference to a list where each element is a string
$rel_fields is a reference to a list where each element is a string
$to_fields is a reference to a list where each element is a string
$return is a reference to a list where each element is a reference to a list containing 3 items:
	0: a fields_Feature
	1: a fields_IsProteinFor
	2: a fields_ProteinSequence
fields_Feature is a reference to a hash where the following keys are defined:
	id has a value which is a string
	feature_type has a value which is a string
	source_id has a value which is a string
	sequence_length has a value which is an int
	function has a value which is a string
	alias has a value which is a reference to a list where each element is a string
fields_IsProteinFor is a reference to a hash where the following keys are defined:
	id has a value which is a string
fields_ProteinSequence is a reference to a hash where the following keys are defined:
	id has a value which is a string
	sequence has a value which is a string


=end text



=item Description



=back

=cut

sub get_relationship_Produces
{
    my $self = shift;
    my($ids, $from_fields, $rel_fields, $to_fields) = @_;

    my @_bad_arguments;
    (ref($ids) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"ids\" (value was \"$ids\")");
    (ref($from_fields) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"from_fields\" (value was \"$from_fields\")");
    (ref($rel_fields) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"rel_fields\" (value was \"$rel_fields\")");
    (ref($to_fields) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"to_fields\" (value was \"$to_fields\")");
    if (@_bad_arguments) {
	my $msg = "Invalid arguments passed to get_relationship_Produces:\n" . join("", map { "\t$_\n" } @_bad_arguments);
	Bio::KBase::Exceptions::ArgumentValidationError->throw(error => $msg,
							       method_name => 'get_relationship_Produces');
    }

    my $ctx = $Bio::KBase::CDMI::Service::CallContext;
    my($return);
    #BEGIN get_relationship_Produces

    $return = $self->_get_relationship($ctx, 'Produces', 'IsProteinFor', 1, $ids, $from_fields, $rel_fields, $to_fields);
	
    #END get_relationship_Produces
    my @_bad_returns;
    (ref($return) eq 'ARRAY') or push(@_bad_returns, "Invalid type for return variable \"return\" (value was \"$return\")");
    if (@_bad_returns) {
	my $msg = "Invalid returns passed to get_relationship_Produces:\n" . join("", map { "\t$_\n" } @_bad_returns);
	Bio::KBase::Exceptions::ArgumentValidationError->throw(error => $msg,
							       method_name => 'get_relationship_Produces');
    }
    return($return);
}




=head2 get_relationship_IsRealLocationOf

  $return = $obj->get_relationship_IsRealLocationOf($ids, $from_fields, $rel_fields, $to_fields)

=over 4

=item Parameter and return types

=begin html

<pre>
$ids is a reference to a list where each element is a string
$from_fields is a reference to a list where each element is a string
$rel_fields is a reference to a list where each element is a string
$to_fields is a reference to a list where each element is a string
$return is a reference to a list where each element is a reference to a list containing 3 items:
	0: a fields_ModelCompartment
	1: a fields_IsRealLocationOf
	2: a fields_Requirement
fields_ModelCompartment is a reference to a hash where the following keys are defined:
	id has a value which is a string
	compartment_index has a value which is an int
	label has a value which is a reference to a list where each element is a string
	pH has a value which is a float
	potential has a value which is a float
fields_IsRealLocationOf is a reference to a hash where the following keys are defined:
	id has a value which is a string
	type has a value which is a string
fields_Requirement is a reference to a hash where the following keys are defined:
	id has a value which is a string
	direction has a value which is a string
	transproton has a value which is a float
	proton has a value which is a float

</pre>

=end html

=begin text

$ids is a reference to a list where each element is a string
$from_fields is a reference to a list where each element is a string
$rel_fields is a reference to a list where each element is a string
$to_fields is a reference to a list where each element is a string
$return is a reference to a list where each element is a reference to a list containing 3 items:
	0: a fields_ModelCompartment
	1: a fields_IsRealLocationOf
	2: a fields_Requirement
fields_ModelCompartment is a reference to a hash where the following keys are defined:
	id has a value which is a string
	compartment_index has a value which is an int
	label has a value which is a reference to a list where each element is a string
	pH has a value which is a float
	potential has a value which is a float
fields_IsRealLocationOf is a reference to a hash where the following keys are defined:
	id has a value which is a string
	type has a value which is a string
fields_Requirement is a reference to a hash where the following keys are defined:
	id has a value which is a string
	direction has a value which is a string
	transproton has a value which is a float
	proton has a value which is a float


=end text



=item Description

This relationship connects a model's instance of a reaction
to the compartments in which it takes place. Most instances
take place in a single compartment. Transporters use two compartments.
It has the following fields:

=over 4


=item type

role of the compartment in the reaction: 'primary'
if it is the sole or starting compartment, 'secondary' if
it is the ending compartment in a multi-compartmental
reaction



=back

=back

=cut

sub get_relationship_IsRealLocationOf
{
    my $self = shift;
    my($ids, $from_fields, $rel_fields, $to_fields) = @_;

    my @_bad_arguments;
    (ref($ids) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"ids\" (value was \"$ids\")");
    (ref($from_fields) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"from_fields\" (value was \"$from_fields\")");
    (ref($rel_fields) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"rel_fields\" (value was \"$rel_fields\")");
    (ref($to_fields) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"to_fields\" (value was \"$to_fields\")");
    if (@_bad_arguments) {
	my $msg = "Invalid arguments passed to get_relationship_IsRealLocationOf:\n" . join("", map { "\t$_\n" } @_bad_arguments);
	Bio::KBase::Exceptions::ArgumentValidationError->throw(error => $msg,
							       method_name => 'get_relationship_IsRealLocationOf');
    }

    my $ctx = $Bio::KBase::CDMI::Service::CallContext;
    my($return);
    #BEGIN get_relationship_IsRealLocationOf

    $return = $self->_get_relationship($ctx, 'IsRealLocationOf', 'IsRealLocationOf', 0, $ids, $from_fields, $rel_fields, $to_fields);
	
    #END get_relationship_IsRealLocationOf
    my @_bad_returns;
    (ref($return) eq 'ARRAY') or push(@_bad_returns, "Invalid type for return variable \"return\" (value was \"$return\")");
    if (@_bad_returns) {
	my $msg = "Invalid returns passed to get_relationship_IsRealLocationOf:\n" . join("", map { "\t$_\n" } @_bad_returns);
	Bio::KBase::Exceptions::ArgumentValidationError->throw(error => $msg,
							       method_name => 'get_relationship_IsRealLocationOf');
    }
    return($return);
}




=head2 get_relationship_HasRealLocationIn

  $return = $obj->get_relationship_HasRealLocationIn($ids, $from_fields, $rel_fields, $to_fields)

=over 4

=item Parameter and return types

=begin html

<pre>
$ids is a reference to a list where each element is a string
$from_fields is a reference to a list where each element is a string
$rel_fields is a reference to a list where each element is a string
$to_fields is a reference to a list where each element is a string
$return is a reference to a list where each element is a reference to a list containing 3 items:
	0: a fields_Requirement
	1: a fields_IsRealLocationOf
	2: a fields_ModelCompartment
fields_Requirement is a reference to a hash where the following keys are defined:
	id has a value which is a string
	direction has a value which is a string
	transproton has a value which is a float
	proton has a value which is a float
fields_IsRealLocationOf is a reference to a hash where the following keys are defined:
	id has a value which is a string
	type has a value which is a string
fields_ModelCompartment is a reference to a hash where the following keys are defined:
	id has a value which is a string
	compartment_index has a value which is an int
	label has a value which is a reference to a list where each element is a string
	pH has a value which is a float
	potential has a value which is a float

</pre>

=end html

=begin text

$ids is a reference to a list where each element is a string
$from_fields is a reference to a list where each element is a string
$rel_fields is a reference to a list where each element is a string
$to_fields is a reference to a list where each element is a string
$return is a reference to a list where each element is a reference to a list containing 3 items:
	0: a fields_Requirement
	1: a fields_IsRealLocationOf
	2: a fields_ModelCompartment
fields_Requirement is a reference to a hash where the following keys are defined:
	id has a value which is a string
	direction has a value which is a string
	transproton has a value which is a float
	proton has a value which is a float
fields_IsRealLocationOf is a reference to a hash where the following keys are defined:
	id has a value which is a string
	type has a value which is a string
fields_ModelCompartment is a reference to a hash where the following keys are defined:
	id has a value which is a string
	compartment_index has a value which is an int
	label has a value which is a reference to a list where each element is a string
	pH has a value which is a float
	potential has a value which is a float


=end text



=item Description



=back

=cut

sub get_relationship_HasRealLocationIn
{
    my $self = shift;
    my($ids, $from_fields, $rel_fields, $to_fields) = @_;

    my @_bad_arguments;
    (ref($ids) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"ids\" (value was \"$ids\")");
    (ref($from_fields) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"from_fields\" (value was \"$from_fields\")");
    (ref($rel_fields) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"rel_fields\" (value was \"$rel_fields\")");
    (ref($to_fields) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"to_fields\" (value was \"$to_fields\")");
    if (@_bad_arguments) {
	my $msg = "Invalid arguments passed to get_relationship_HasRealLocationIn:\n" . join("", map { "\t$_\n" } @_bad_arguments);
	Bio::KBase::Exceptions::ArgumentValidationError->throw(error => $msg,
							       method_name => 'get_relationship_HasRealLocationIn');
    }

    my $ctx = $Bio::KBase::CDMI::Service::CallContext;
    my($return);
    #BEGIN get_relationship_HasRealLocationIn

    $return = $self->_get_relationship($ctx, 'HasRealLocationIn', 'IsRealLocationOf', 1, $ids, $from_fields, $rel_fields, $to_fields);
	
    #END get_relationship_HasRealLocationIn
    my @_bad_returns;
    (ref($return) eq 'ARRAY') or push(@_bad_returns, "Invalid type for return variable \"return\" (value was \"$return\")");
    if (@_bad_returns) {
	my $msg = "Invalid returns passed to get_relationship_HasRealLocationIn:\n" . join("", map { "\t$_\n" } @_bad_returns);
	Bio::KBase::Exceptions::ArgumentValidationError->throw(error => $msg,
							       method_name => 'get_relationship_HasRealLocationIn');
    }
    return($return);
}




=head2 get_relationship_IsReferencedBy

  $return = $obj->get_relationship_IsReferencedBy($ids, $from_fields, $rel_fields, $to_fields)

=over 4

=item Parameter and return types

=begin html

<pre>
$ids is a reference to a list where each element is a string
$from_fields is a reference to a list where each element is a string
$rel_fields is a reference to a list where each element is a string
$to_fields is a reference to a list where each element is a string
$return is a reference to a list where each element is a reference to a list containing 3 items:
	0: a fields_Genome
	1: a fields_IsReferencedBy
	2: a fields_ObservationalUnit
fields_Genome is a reference to a hash where the following keys are defined:
	id has a value which is a string
	pegs has a value which is an int
	rnas has a value which is an int
	scientific_name has a value which is a string
	complete has a value which is an int
	prokaryotic has a value which is an int
	dna_size has a value which is an int
	contigs has a value which is an int
	domain has a value which is a string
	genetic_code has a value which is an int
	gc_content has a value which is a float
	phenotype has a value which is a reference to a list where each element is a string
	md5 has a value which is a string
	source_id has a value which is a string
fields_IsReferencedBy is a reference to a hash where the following keys are defined:
	id has a value which is a string
fields_ObservationalUnit is a reference to a hash where the following keys are defined:
	id has a value which is a string
	source_name has a value which is a string
	source_name2 has a value which is a reference to a list where each element is a string
	plant_id has a value which is a string

</pre>

=end html

=begin text

$ids is a reference to a list where each element is a string
$from_fields is a reference to a list where each element is a string
$rel_fields is a reference to a list where each element is a string
$to_fields is a reference to a list where each element is a string
$return is a reference to a list where each element is a reference to a list containing 3 items:
	0: a fields_Genome
	1: a fields_IsReferencedBy
	2: a fields_ObservationalUnit
fields_Genome is a reference to a hash where the following keys are defined:
	id has a value which is a string
	pegs has a value which is an int
	rnas has a value which is an int
	scientific_name has a value which is a string
	complete has a value which is an int
	prokaryotic has a value which is an int
	dna_size has a value which is an int
	contigs has a value which is an int
	domain has a value which is a string
	genetic_code has a value which is an int
	gc_content has a value which is a float
	phenotype has a value which is a reference to a list where each element is a string
	md5 has a value which is a string
	source_id has a value which is a string
fields_IsReferencedBy is a reference to a hash where the following keys are defined:
	id has a value which is a string
fields_ObservationalUnit is a reference to a hash where the following keys are defined:
	id has a value which is a string
	source_name has a value which is a string
	source_name2 has a value which is a reference to a list where each element is a string
	plant_id has a value which is a string


=end text



=item Description

This relationship associates each observational unit with the reference
genome that it will be compared to.  All variations will be differences
between the observational unit and the reference.
It has the following fields:

=over 4



=back

=back

=cut

sub get_relationship_IsReferencedBy
{
    my $self = shift;
    my($ids, $from_fields, $rel_fields, $to_fields) = @_;

    my @_bad_arguments;
    (ref($ids) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"ids\" (value was \"$ids\")");
    (ref($from_fields) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"from_fields\" (value was \"$from_fields\")");
    (ref($rel_fields) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"rel_fields\" (value was \"$rel_fields\")");
    (ref($to_fields) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"to_fields\" (value was \"$to_fields\")");
    if (@_bad_arguments) {
	my $msg = "Invalid arguments passed to get_relationship_IsReferencedBy:\n" . join("", map { "\t$_\n" } @_bad_arguments);
	Bio::KBase::Exceptions::ArgumentValidationError->throw(error => $msg,
							       method_name => 'get_relationship_IsReferencedBy');
    }

    my $ctx = $Bio::KBase::CDMI::Service::CallContext;
    my($return);
    #BEGIN get_relationship_IsReferencedBy

    $return = $self->_get_relationship($ctx, 'IsReferencedBy', 'IsReferencedBy', 0, $ids, $from_fields, $rel_fields, $to_fields);
	
    #END get_relationship_IsReferencedBy
    my @_bad_returns;
    (ref($return) eq 'ARRAY') or push(@_bad_returns, "Invalid type for return variable \"return\" (value was \"$return\")");
    if (@_bad_returns) {
	my $msg = "Invalid returns passed to get_relationship_IsReferencedBy:\n" . join("", map { "\t$_\n" } @_bad_returns);
	Bio::KBase::Exceptions::ArgumentValidationError->throw(error => $msg,
							       method_name => 'get_relationship_IsReferencedBy');
    }
    return($return);
}




=head2 get_relationship_UsesReference

  $return = $obj->get_relationship_UsesReference($ids, $from_fields, $rel_fields, $to_fields)

=over 4

=item Parameter and return types

=begin html

<pre>
$ids is a reference to a list where each element is a string
$from_fields is a reference to a list where each element is a string
$rel_fields is a reference to a list where each element is a string
$to_fields is a reference to a list where each element is a string
$return is a reference to a list where each element is a reference to a list containing 3 items:
	0: a fields_ObservationalUnit
	1: a fields_IsReferencedBy
	2: a fields_Genome
fields_ObservationalUnit is a reference to a hash where the following keys are defined:
	id has a value which is a string
	source_name has a value which is a string
	source_name2 has a value which is a reference to a list where each element is a string
	plant_id has a value which is a string
fields_IsReferencedBy is a reference to a hash where the following keys are defined:
	id has a value which is a string
fields_Genome is a reference to a hash where the following keys are defined:
	id has a value which is a string
	pegs has a value which is an int
	rnas has a value which is an int
	scientific_name has a value which is a string
	complete has a value which is an int
	prokaryotic has a value which is an int
	dna_size has a value which is an int
	contigs has a value which is an int
	domain has a value which is a string
	genetic_code has a value which is an int
	gc_content has a value which is a float
	phenotype has a value which is a reference to a list where each element is a string
	md5 has a value which is a string
	source_id has a value which is a string

</pre>

=end html

=begin text

$ids is a reference to a list where each element is a string
$from_fields is a reference to a list where each element is a string
$rel_fields is a reference to a list where each element is a string
$to_fields is a reference to a list where each element is a string
$return is a reference to a list where each element is a reference to a list containing 3 items:
	0: a fields_ObservationalUnit
	1: a fields_IsReferencedBy
	2: a fields_Genome
fields_ObservationalUnit is a reference to a hash where the following keys are defined:
	id has a value which is a string
	source_name has a value which is a string
	source_name2 has a value which is a reference to a list where each element is a string
	plant_id has a value which is a string
fields_IsReferencedBy is a reference to a hash where the following keys are defined:
	id has a value which is a string
fields_Genome is a reference to a hash where the following keys are defined:
	id has a value which is a string
	pegs has a value which is an int
	rnas has a value which is an int
	scientific_name has a value which is a string
	complete has a value which is an int
	prokaryotic has a value which is an int
	dna_size has a value which is an int
	contigs has a value which is an int
	domain has a value which is a string
	genetic_code has a value which is an int
	gc_content has a value which is a float
	phenotype has a value which is a reference to a list where each element is a string
	md5 has a value which is a string
	source_id has a value which is a string


=end text



=item Description



=back

=cut

sub get_relationship_UsesReference
{
    my $self = shift;
    my($ids, $from_fields, $rel_fields, $to_fields) = @_;

    my @_bad_arguments;
    (ref($ids) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"ids\" (value was \"$ids\")");
    (ref($from_fields) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"from_fields\" (value was \"$from_fields\")");
    (ref($rel_fields) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"rel_fields\" (value was \"$rel_fields\")");
    (ref($to_fields) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"to_fields\" (value was \"$to_fields\")");
    if (@_bad_arguments) {
	my $msg = "Invalid arguments passed to get_relationship_UsesReference:\n" . join("", map { "\t$_\n" } @_bad_arguments);
	Bio::KBase::Exceptions::ArgumentValidationError->throw(error => $msg,
							       method_name => 'get_relationship_UsesReference');
    }

    my $ctx = $Bio::KBase::CDMI::Service::CallContext;
    my($return);
    #BEGIN get_relationship_UsesReference

    $return = $self->_get_relationship($ctx, 'UsesReference', 'IsReferencedBy', 1, $ids, $from_fields, $rel_fields, $to_fields);
	
    #END get_relationship_UsesReference
    my @_bad_returns;
    (ref($return) eq 'ARRAY') or push(@_bad_returns, "Invalid type for return variable \"return\" (value was \"$return\")");
    if (@_bad_returns) {
	my $msg = "Invalid returns passed to get_relationship_UsesReference:\n" . join("", map { "\t$_\n" } @_bad_returns);
	Bio::KBase::Exceptions::ArgumentValidationError->throw(error => $msg,
							       method_name => 'get_relationship_UsesReference');
    }
    return($return);
}




=head2 get_relationship_IsRegulatedIn

  $return = $obj->get_relationship_IsRegulatedIn($ids, $from_fields, $rel_fields, $to_fields)

=over 4

=item Parameter and return types

=begin html

<pre>
$ids is a reference to a list where each element is a string
$from_fields is a reference to a list where each element is a string
$rel_fields is a reference to a list where each element is a string
$to_fields is a reference to a list where each element is a string
$return is a reference to a list where each element is a reference to a list containing 3 items:
	0: a fields_Feature
	1: a fields_IsRegulatedIn
	2: a fields_CoregulatedSet
fields_Feature is a reference to a hash where the following keys are defined:
	id has a value which is a string
	feature_type has a value which is a string
	source_id has a value which is a string
	sequence_length has a value which is an int
	function has a value which is a string
	alias has a value which is a reference to a list where each element is a string
fields_IsRegulatedIn is a reference to a hash where the following keys are defined:
	id has a value which is a string
fields_CoregulatedSet is a reference to a hash where the following keys are defined:
	id has a value which is a string
	source_id has a value which is a string
	binding_location has a value which is a reference to a list where each element is an int

</pre>

=end html

=begin text

$ids is a reference to a list where each element is a string
$from_fields is a reference to a list where each element is a string
$rel_fields is a reference to a list where each element is a string
$to_fields is a reference to a list where each element is a string
$return is a reference to a list where each element is a reference to a list containing 3 items:
	0: a fields_Feature
	1: a fields_IsRegulatedIn
	2: a fields_CoregulatedSet
fields_Feature is a reference to a hash where the following keys are defined:
	id has a value which is a string
	feature_type has a value which is a string
	source_id has a value which is a string
	sequence_length has a value which is an int
	function has a value which is a string
	alias has a value which is a reference to a list where each element is a string
fields_IsRegulatedIn is a reference to a hash where the following keys are defined:
	id has a value which is a string
fields_CoregulatedSet is a reference to a hash where the following keys are defined:
	id has a value which is a string
	source_id has a value which is a string
	binding_location has a value which is a reference to a list where each element is an int


=end text



=item Description

This relationship connects a feature to the set of coregulated features.
It has the following fields:

=over 4



=back

=back

=cut

sub get_relationship_IsRegulatedIn
{
    my $self = shift;
    my($ids, $from_fields, $rel_fields, $to_fields) = @_;

    my @_bad_arguments;
    (ref($ids) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"ids\" (value was \"$ids\")");
    (ref($from_fields) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"from_fields\" (value was \"$from_fields\")");
    (ref($rel_fields) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"rel_fields\" (value was \"$rel_fields\")");
    (ref($to_fields) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"to_fields\" (value was \"$to_fields\")");
    if (@_bad_arguments) {
	my $msg = "Invalid arguments passed to get_relationship_IsRegulatedIn:\n" . join("", map { "\t$_\n" } @_bad_arguments);
	Bio::KBase::Exceptions::ArgumentValidationError->throw(error => $msg,
							       method_name => 'get_relationship_IsRegulatedIn');
    }

    my $ctx = $Bio::KBase::CDMI::Service::CallContext;
    my($return);
    #BEGIN get_relationship_IsRegulatedIn

    $return = $self->_get_relationship($ctx, 'IsRegulatedIn', 'IsRegulatedIn', 0, $ids, $from_fields, $rel_fields, $to_fields);
	
    #END get_relationship_IsRegulatedIn
    my @_bad_returns;
    (ref($return) eq 'ARRAY') or push(@_bad_returns, "Invalid type for return variable \"return\" (value was \"$return\")");
    if (@_bad_returns) {
	my $msg = "Invalid returns passed to get_relationship_IsRegulatedIn:\n" . join("", map { "\t$_\n" } @_bad_returns);
	Bio::KBase::Exceptions::ArgumentValidationError->throw(error => $msg,
							       method_name => 'get_relationship_IsRegulatedIn');
    }
    return($return);
}




=head2 get_relationship_IsRegulatedSetOf

  $return = $obj->get_relationship_IsRegulatedSetOf($ids, $from_fields, $rel_fields, $to_fields)

=over 4

=item Parameter and return types

=begin html

<pre>
$ids is a reference to a list where each element is a string
$from_fields is a reference to a list where each element is a string
$rel_fields is a reference to a list where each element is a string
$to_fields is a reference to a list where each element is a string
$return is a reference to a list where each element is a reference to a list containing 3 items:
	0: a fields_CoregulatedSet
	1: a fields_IsRegulatedIn
	2: a fields_Feature
fields_CoregulatedSet is a reference to a hash where the following keys are defined:
	id has a value which is a string
	source_id has a value which is a string
	binding_location has a value which is a reference to a list where each element is an int
fields_IsRegulatedIn is a reference to a hash where the following keys are defined:
	id has a value which is a string
fields_Feature is a reference to a hash where the following keys are defined:
	id has a value which is a string
	feature_type has a value which is a string
	source_id has a value which is a string
	sequence_length has a value which is an int
	function has a value which is a string
	alias has a value which is a reference to a list where each element is a string

</pre>

=end html

=begin text

$ids is a reference to a list where each element is a string
$from_fields is a reference to a list where each element is a string
$rel_fields is a reference to a list where each element is a string
$to_fields is a reference to a list where each element is a string
$return is a reference to a list where each element is a reference to a list containing 3 items:
	0: a fields_CoregulatedSet
	1: a fields_IsRegulatedIn
	2: a fields_Feature
fields_CoregulatedSet is a reference to a hash where the following keys are defined:
	id has a value which is a string
	source_id has a value which is a string
	binding_location has a value which is a reference to a list where each element is an int
fields_IsRegulatedIn is a reference to a hash where the following keys are defined:
	id has a value which is a string
fields_Feature is a reference to a hash where the following keys are defined:
	id has a value which is a string
	feature_type has a value which is a string
	source_id has a value which is a string
	sequence_length has a value which is an int
	function has a value which is a string
	alias has a value which is a reference to a list where each element is a string


=end text



=item Description



=back

=cut

sub get_relationship_IsRegulatedSetOf
{
    my $self = shift;
    my($ids, $from_fields, $rel_fields, $to_fields) = @_;

    my @_bad_arguments;
    (ref($ids) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"ids\" (value was \"$ids\")");
    (ref($from_fields) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"from_fields\" (value was \"$from_fields\")");
    (ref($rel_fields) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"rel_fields\" (value was \"$rel_fields\")");
    (ref($to_fields) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"to_fields\" (value was \"$to_fields\")");
    if (@_bad_arguments) {
	my $msg = "Invalid arguments passed to get_relationship_IsRegulatedSetOf:\n" . join("", map { "\t$_\n" } @_bad_arguments);
	Bio::KBase::Exceptions::ArgumentValidationError->throw(error => $msg,
							       method_name => 'get_relationship_IsRegulatedSetOf');
    }

    my $ctx = $Bio::KBase::CDMI::Service::CallContext;
    my($return);
    #BEGIN get_relationship_IsRegulatedSetOf

    $return = $self->_get_relationship($ctx, 'IsRegulatedSetOf', 'IsRegulatedIn', 1, $ids, $from_fields, $rel_fields, $to_fields);
	
    #END get_relationship_IsRegulatedSetOf
    my @_bad_returns;
    (ref($return) eq 'ARRAY') or push(@_bad_returns, "Invalid type for return variable \"return\" (value was \"$return\")");
    if (@_bad_returns) {
	my $msg = "Invalid returns passed to get_relationship_IsRegulatedSetOf:\n" . join("", map { "\t$_\n" } @_bad_returns);
	Bio::KBase::Exceptions::ArgumentValidationError->throw(error => $msg,
							       method_name => 'get_relationship_IsRegulatedSetOf');
    }
    return($return);
}




=head2 get_relationship_IsRelevantFor

  $return = $obj->get_relationship_IsRelevantFor($ids, $from_fields, $rel_fields, $to_fields)

=over 4

=item Parameter and return types

=begin html

<pre>
$ids is a reference to a list where each element is a string
$from_fields is a reference to a list where each element is a string
$rel_fields is a reference to a list where each element is a string
$to_fields is a reference to a list where each element is a string
$return is a reference to a list where each element is a reference to a list containing 3 items:
	0: a fields_Diagram
	1: a fields_IsRelevantFor
	2: a fields_Subsystem
fields_Diagram is a reference to a hash where the following keys are defined:
	id has a value which is a string
	name has a value which is a string
	content has a value which is a reference to a list where each element is a string
fields_IsRelevantFor is a reference to a hash where the following keys are defined:
	id has a value which is a string
fields_Subsystem is a reference to a hash where the following keys are defined:
	id has a value which is a string
	version has a value which is an int
	curator has a value which is a string
	notes has a value which is a string
	description has a value which is a string
	usable has a value which is an int
	private has a value which is an int
	cluster_based has a value which is an int
	experimental has a value which is an int

</pre>

=end html

=begin text

$ids is a reference to a list where each element is a string
$from_fields is a reference to a list where each element is a string
$rel_fields is a reference to a list where each element is a string
$to_fields is a reference to a list where each element is a string
$return is a reference to a list where each element is a reference to a list containing 3 items:
	0: a fields_Diagram
	1: a fields_IsRelevantFor
	2: a fields_Subsystem
fields_Diagram is a reference to a hash where the following keys are defined:
	id has a value which is a string
	name has a value which is a string
	content has a value which is a reference to a list where each element is a string
fields_IsRelevantFor is a reference to a hash where the following keys are defined:
	id has a value which is a string
fields_Subsystem is a reference to a hash where the following keys are defined:
	id has a value which is a string
	version has a value which is an int
	curator has a value which is a string
	notes has a value which is a string
	description has a value which is a string
	usable has a value which is an int
	private has a value which is an int
	cluster_based has a value which is an int
	experimental has a value which is an int


=end text



=item Description

This relationship connects a diagram to the subsystems that are depicted on
it. Only diagrams which are useful in curating or annotation the subsystem are
specified in this relationship.
It has the following fields:

=over 4



=back

=back

=cut

sub get_relationship_IsRelevantFor
{
    my $self = shift;
    my($ids, $from_fields, $rel_fields, $to_fields) = @_;

    my @_bad_arguments;
    (ref($ids) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"ids\" (value was \"$ids\")");
    (ref($from_fields) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"from_fields\" (value was \"$from_fields\")");
    (ref($rel_fields) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"rel_fields\" (value was \"$rel_fields\")");
    (ref($to_fields) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"to_fields\" (value was \"$to_fields\")");
    if (@_bad_arguments) {
	my $msg = "Invalid arguments passed to get_relationship_IsRelevantFor:\n" . join("", map { "\t$_\n" } @_bad_arguments);
	Bio::KBase::Exceptions::ArgumentValidationError->throw(error => $msg,
							       method_name => 'get_relationship_IsRelevantFor');
    }

    my $ctx = $Bio::KBase::CDMI::Service::CallContext;
    my($return);
    #BEGIN get_relationship_IsRelevantFor

    $return = $self->_get_relationship($ctx, 'IsRelevantFor', 'IsRelevantFor', 0, $ids, $from_fields, $rel_fields, $to_fields);
	
    #END get_relationship_IsRelevantFor
    my @_bad_returns;
    (ref($return) eq 'ARRAY') or push(@_bad_returns, "Invalid type for return variable \"return\" (value was \"$return\")");
    if (@_bad_returns) {
	my $msg = "Invalid returns passed to get_relationship_IsRelevantFor:\n" . join("", map { "\t$_\n" } @_bad_returns);
	Bio::KBase::Exceptions::ArgumentValidationError->throw(error => $msg,
							       method_name => 'get_relationship_IsRelevantFor');
    }
    return($return);
}




=head2 get_relationship_IsRelevantTo

  $return = $obj->get_relationship_IsRelevantTo($ids, $from_fields, $rel_fields, $to_fields)

=over 4

=item Parameter and return types

=begin html

<pre>
$ids is a reference to a list where each element is a string
$from_fields is a reference to a list where each element is a string
$rel_fields is a reference to a list where each element is a string
$to_fields is a reference to a list where each element is a string
$return is a reference to a list where each element is a reference to a list containing 3 items:
	0: a fields_Subsystem
	1: a fields_IsRelevantFor
	2: a fields_Diagram
fields_Subsystem is a reference to a hash where the following keys are defined:
	id has a value which is a string
	version has a value which is an int
	curator has a value which is a string
	notes has a value which is a string
	description has a value which is a string
	usable has a value which is an int
	private has a value which is an int
	cluster_based has a value which is an int
	experimental has a value which is an int
fields_IsRelevantFor is a reference to a hash where the following keys are defined:
	id has a value which is a string
fields_Diagram is a reference to a hash where the following keys are defined:
	id has a value which is a string
	name has a value which is a string
	content has a value which is a reference to a list where each element is a string

</pre>

=end html

=begin text

$ids is a reference to a list where each element is a string
$from_fields is a reference to a list where each element is a string
$rel_fields is a reference to a list where each element is a string
$to_fields is a reference to a list where each element is a string
$return is a reference to a list where each element is a reference to a list containing 3 items:
	0: a fields_Subsystem
	1: a fields_IsRelevantFor
	2: a fields_Diagram
fields_Subsystem is a reference to a hash where the following keys are defined:
	id has a value which is a string
	version has a value which is an int
	curator has a value which is a string
	notes has a value which is a string
	description has a value which is a string
	usable has a value which is an int
	private has a value which is an int
	cluster_based has a value which is an int
	experimental has a value which is an int
fields_IsRelevantFor is a reference to a hash where the following keys are defined:
	id has a value which is a string
fields_Diagram is a reference to a hash where the following keys are defined:
	id has a value which is a string
	name has a value which is a string
	content has a value which is a reference to a list where each element is a string


=end text



=item Description



=back

=cut

sub get_relationship_IsRelevantTo
{
    my $self = shift;
    my($ids, $from_fields, $rel_fields, $to_fields) = @_;

    my @_bad_arguments;
    (ref($ids) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"ids\" (value was \"$ids\")");
    (ref($from_fields) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"from_fields\" (value was \"$from_fields\")");
    (ref($rel_fields) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"rel_fields\" (value was \"$rel_fields\")");
    (ref($to_fields) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"to_fields\" (value was \"$to_fields\")");
    if (@_bad_arguments) {
	my $msg = "Invalid arguments passed to get_relationship_IsRelevantTo:\n" . join("", map { "\t$_\n" } @_bad_arguments);
	Bio::KBase::Exceptions::ArgumentValidationError->throw(error => $msg,
							       method_name => 'get_relationship_IsRelevantTo');
    }

    my $ctx = $Bio::KBase::CDMI::Service::CallContext;
    my($return);
    #BEGIN get_relationship_IsRelevantTo

    $return = $self->_get_relationship($ctx, 'IsRelevantTo', 'IsRelevantFor', 1, $ids, $from_fields, $rel_fields, $to_fields);
	
    #END get_relationship_IsRelevantTo
    my @_bad_returns;
    (ref($return) eq 'ARRAY') or push(@_bad_returns, "Invalid type for return variable \"return\" (value was \"$return\")");
    if (@_bad_returns) {
	my $msg = "Invalid returns passed to get_relationship_IsRelevantTo:\n" . join("", map { "\t$_\n" } @_bad_returns);
	Bio::KBase::Exceptions::ArgumentValidationError->throw(error => $msg,
							       method_name => 'get_relationship_IsRelevantTo');
    }
    return($return);
}




=head2 get_relationship_IsRepresentedBy

  $return = $obj->get_relationship_IsRepresentedBy($ids, $from_fields, $rel_fields, $to_fields)

=over 4

=item Parameter and return types

=begin html

<pre>
$ids is a reference to a list where each element is a string
$from_fields is a reference to a list where each element is a string
$rel_fields is a reference to a list where each element is a string
$to_fields is a reference to a list where each element is a string
$return is a reference to a list where each element is a reference to a list containing 3 items:
	0: a fields_TaxonomicGrouping
	1: a fields_IsRepresentedBy
	2: a fields_ObservationalUnit
fields_TaxonomicGrouping is a reference to a hash where the following keys are defined:
	id has a value which is a string
	domain has a value which is an int
	hidden has a value which is an int
	scientific_name has a value which is a string
	alias has a value which is a reference to a list where each element is a string
fields_IsRepresentedBy is a reference to a hash where the following keys are defined:
	id has a value which is a string
fields_ObservationalUnit is a reference to a hash where the following keys are defined:
	id has a value which is a string
	source_name has a value which is a string
	source_name2 has a value which is a reference to a list where each element is a string
	plant_id has a value which is a string

</pre>

=end html

=begin text

$ids is a reference to a list where each element is a string
$from_fields is a reference to a list where each element is a string
$rel_fields is a reference to a list where each element is a string
$to_fields is a reference to a list where each element is a string
$return is a reference to a list where each element is a reference to a list containing 3 items:
	0: a fields_TaxonomicGrouping
	1: a fields_IsRepresentedBy
	2: a fields_ObservationalUnit
fields_TaxonomicGrouping is a reference to a hash where the following keys are defined:
	id has a value which is a string
	domain has a value which is an int
	hidden has a value which is an int
	scientific_name has a value which is a string
	alias has a value which is a reference to a list where each element is a string
fields_IsRepresentedBy is a reference to a hash where the following keys are defined:
	id has a value which is a string
fields_ObservationalUnit is a reference to a hash where the following keys are defined:
	id has a value which is a string
	source_name has a value which is a string
	source_name2 has a value which is a reference to a list where each element is a string
	plant_id has a value which is a string


=end text



=item Description

This relationship associates observational units with a genus,
species, strain, and/or variety that was the source material.
It has the following fields:

=over 4



=back

=back

=cut

sub get_relationship_IsRepresentedBy
{
    my $self = shift;
    my($ids, $from_fields, $rel_fields, $to_fields) = @_;

    my @_bad_arguments;
    (ref($ids) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"ids\" (value was \"$ids\")");
    (ref($from_fields) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"from_fields\" (value was \"$from_fields\")");
    (ref($rel_fields) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"rel_fields\" (value was \"$rel_fields\")");
    (ref($to_fields) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"to_fields\" (value was \"$to_fields\")");
    if (@_bad_arguments) {
	my $msg = "Invalid arguments passed to get_relationship_IsRepresentedBy:\n" . join("", map { "\t$_\n" } @_bad_arguments);
	Bio::KBase::Exceptions::ArgumentValidationError->throw(error => $msg,
							       method_name => 'get_relationship_IsRepresentedBy');
    }

    my $ctx = $Bio::KBase::CDMI::Service::CallContext;
    my($return);
    #BEGIN get_relationship_IsRepresentedBy

    $return = $self->_get_relationship($ctx, 'IsRepresentedBy', 'IsRepresentedBy', 0, $ids, $from_fields, $rel_fields, $to_fields);
	
    #END get_relationship_IsRepresentedBy
    my @_bad_returns;
    (ref($return) eq 'ARRAY') or push(@_bad_returns, "Invalid type for return variable \"return\" (value was \"$return\")");
    if (@_bad_returns) {
	my $msg = "Invalid returns passed to get_relationship_IsRepresentedBy:\n" . join("", map { "\t$_\n" } @_bad_returns);
	Bio::KBase::Exceptions::ArgumentValidationError->throw(error => $msg,
							       method_name => 'get_relationship_IsRepresentedBy');
    }
    return($return);
}




=head2 get_relationship_DefinedBy

  $return = $obj->get_relationship_DefinedBy($ids, $from_fields, $rel_fields, $to_fields)

=over 4

=item Parameter and return types

=begin html

<pre>
$ids is a reference to a list where each element is a string
$from_fields is a reference to a list where each element is a string
$rel_fields is a reference to a list where each element is a string
$to_fields is a reference to a list where each element is a string
$return is a reference to a list where each element is a reference to a list containing 3 items:
	0: a fields_ObservationalUnit
	1: a fields_IsRepresentedBy
	2: a fields_TaxonomicGrouping
fields_ObservationalUnit is a reference to a hash where the following keys are defined:
	id has a value which is a string
	source_name has a value which is a string
	source_name2 has a value which is a reference to a list where each element is a string
	plant_id has a value which is a string
fields_IsRepresentedBy is a reference to a hash where the following keys are defined:
	id has a value which is a string
fields_TaxonomicGrouping is a reference to a hash where the following keys are defined:
	id has a value which is a string
	domain has a value which is an int
	hidden has a value which is an int
	scientific_name has a value which is a string
	alias has a value which is a reference to a list where each element is a string

</pre>

=end html

=begin text

$ids is a reference to a list where each element is a string
$from_fields is a reference to a list where each element is a string
$rel_fields is a reference to a list where each element is a string
$to_fields is a reference to a list where each element is a string
$return is a reference to a list where each element is a reference to a list containing 3 items:
	0: a fields_ObservationalUnit
	1: a fields_IsRepresentedBy
	2: a fields_TaxonomicGrouping
fields_ObservationalUnit is a reference to a hash where the following keys are defined:
	id has a value which is a string
	source_name has a value which is a string
	source_name2 has a value which is a reference to a list where each element is a string
	plant_id has a value which is a string
fields_IsRepresentedBy is a reference to a hash where the following keys are defined:
	id has a value which is a string
fields_TaxonomicGrouping is a reference to a hash where the following keys are defined:
	id has a value which is a string
	domain has a value which is an int
	hidden has a value which is an int
	scientific_name has a value which is a string
	alias has a value which is a reference to a list where each element is a string


=end text



=item Description



=back

=cut

sub get_relationship_DefinedBy
{
    my $self = shift;
    my($ids, $from_fields, $rel_fields, $to_fields) = @_;

    my @_bad_arguments;
    (ref($ids) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"ids\" (value was \"$ids\")");
    (ref($from_fields) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"from_fields\" (value was \"$from_fields\")");
    (ref($rel_fields) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"rel_fields\" (value was \"$rel_fields\")");
    (ref($to_fields) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"to_fields\" (value was \"$to_fields\")");
    if (@_bad_arguments) {
	my $msg = "Invalid arguments passed to get_relationship_DefinedBy:\n" . join("", map { "\t$_\n" } @_bad_arguments);
	Bio::KBase::Exceptions::ArgumentValidationError->throw(error => $msg,
							       method_name => 'get_relationship_DefinedBy');
    }

    my $ctx = $Bio::KBase::CDMI::Service::CallContext;
    my($return);
    #BEGIN get_relationship_DefinedBy

    $return = $self->_get_relationship($ctx, 'DefinedBy', 'IsRepresentedBy', 1, $ids, $from_fields, $rel_fields, $to_fields);
	
    #END get_relationship_DefinedBy
    my @_bad_returns;
    (ref($return) eq 'ARRAY') or push(@_bad_returns, "Invalid type for return variable \"return\" (value was \"$return\")");
    if (@_bad_returns) {
	my $msg = "Invalid returns passed to get_relationship_DefinedBy:\n" . join("", map { "\t$_\n" } @_bad_returns);
	Bio::KBase::Exceptions::ArgumentValidationError->throw(error => $msg,
							       method_name => 'get_relationship_DefinedBy');
    }
    return($return);
}




=head2 get_relationship_IsRequiredBy

  $return = $obj->get_relationship_IsRequiredBy($ids, $from_fields, $rel_fields, $to_fields)

=over 4

=item Parameter and return types

=begin html

<pre>
$ids is a reference to a list where each element is a string
$from_fields is a reference to a list where each element is a string
$rel_fields is a reference to a list where each element is a string
$to_fields is a reference to a list where each element is a string
$return is a reference to a list where each element is a reference to a list containing 3 items:
	0: a fields_Reaction
	1: a fields_IsRequiredBy
	2: a fields_Requirement
fields_Reaction is a reference to a hash where the following keys are defined:
	id has a value which is a string
	mod_date has a value which is a string
	name has a value which is a string
	msid has a value which is a string
	abbr has a value which is a string
	equation has a value which is a string
	reversibility has a value which is a string
fields_IsRequiredBy is a reference to a hash where the following keys are defined:
	id has a value which is a string
fields_Requirement is a reference to a hash where the following keys are defined:
	id has a value which is a string
	direction has a value which is a string
	transproton has a value which is a float
	proton has a value which is a float

</pre>

=end html

=begin text

$ids is a reference to a list where each element is a string
$from_fields is a reference to a list where each element is a string
$rel_fields is a reference to a list where each element is a string
$to_fields is a reference to a list where each element is a string
$return is a reference to a list where each element is a reference to a list containing 3 items:
	0: a fields_Reaction
	1: a fields_IsRequiredBy
	2: a fields_Requirement
fields_Reaction is a reference to a hash where the following keys are defined:
	id has a value which is a string
	mod_date has a value which is a string
	name has a value which is a string
	msid has a value which is a string
	abbr has a value which is a string
	equation has a value which is a string
	reversibility has a value which is a string
fields_IsRequiredBy is a reference to a hash where the following keys are defined:
	id has a value which is a string
fields_Requirement is a reference to a hash where the following keys are defined:
	id has a value which is a string
	direction has a value which is a string
	transproton has a value which is a float
	proton has a value which is a float


=end text



=item Description

This relationship links a reaction to the way it is used in a model.
It has the following fields:

=over 4



=back

=back

=cut

sub get_relationship_IsRequiredBy
{
    my $self = shift;
    my($ids, $from_fields, $rel_fields, $to_fields) = @_;

    my @_bad_arguments;
    (ref($ids) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"ids\" (value was \"$ids\")");
    (ref($from_fields) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"from_fields\" (value was \"$from_fields\")");
    (ref($rel_fields) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"rel_fields\" (value was \"$rel_fields\")");
    (ref($to_fields) eq 'ARRAY') or push(@_bad_arguments, "Invalid type for argument \"to_fields\" (value was \"$to_fields\")");
    if (@_bad_arguments) {
	my $msg = "Invalid arguments passed to get_relationship_IsRequiredBy:\n" . join("", map { "\t$_\n" } @_bad_arguments);
	Bio::KBase::Exceptions::ArgumentValidationError->throw(error => $msg,
							       method_name => 'get_relationship_IsRequiredBy');
    }

    my $ctx = $Bio::KBase::CDMI::Service::CallContext;
    my($return);
    #BEGIN get_relationship_IsRequiredBy

    $return = $self->_get_relationship($ctx, 'IsRequiredBy', 'IsRequiredBy', 0, $ids, $from_fields, $rel_fields, $to_fields);
	
    #END get_relationship_IsRequiredBy
    my @_bad_returns;
    (ref($return) eq 'ARRAY') or push(@_bad_returns, "Invalid type for return variable \"return\" (value was \"$return\")");
    if (@_bad_returns) {
	my $msg = "Invalid returns passed to get_relationship_IsRequiredBy:\n" . join("", map { "\t$_\n" } @_bad_returns);
	Bio::KBase::Exceptions::ArgumentValidationError->throw(error => $msg,
							       method_name => 'get_relationship_IsRequiredBy');
    }
    return($return);
}




=head2 get_relationship_Requires

  $return = $obj->get_relationship_Requires($ids, $from_fields, $rel_fields, $to_fields)

=over 4

=item Parameter and return types

=begin html

<pre>
$ids is a reference to a list where each element is a string
$from_fields is a reference to a list where each element is a string
$rel_fields is a reference to a lis