import java.awt.dnd.DragSourceListener;
import org.perl.inline.java.*;

public class      PerlDragSourceListener
       extends    InlineJavaPerlCaller
       implements DragSourceListener
{
    String sender;
    String callbacks;

    public PerlDragSourceListener(String sender, String callbacks)
        throws InlineJavaException
    {
        this.sender    = sender;
        this.callbacks = callbacks;
    }

    public void dragEnter(java.awt.dnd.DragSourceDragEvent event) {
        try {
            CallPerl(
                "Java::Swing::DragSourceListener",
                "_DragSourceListener",
                new Object[] {sender, callbacks, "dragEnter", event}
            );
        }
        catch (InlineJavaPerlException ijpe) {
            System.err.println("couldn't call perl ijpe: " + ijpe);
        }
        catch (InlineJavaException ije) {
            System.err.println("couldn't call perl ije: " + ije);
        }
    }
    public void dragOver(java.awt.dnd.DragSourceDragEvent event) {
        try {
            CallPerl(
                "Java::Swing::DragSourceListener",
                "_DragSourceListener",
                new Object[] {sender, callbacks, "dragOver", event}
            );
        }
        catch (InlineJavaPerlException ijpe) {
            System.err.println("couldn't call perl ijpe: " + ijpe);
        }
        catch (InlineJavaException ije) {
            System.err.println("couldn't call perl ije: " + ije);
        }
    }
    public void dropActionChanged(java.awt.dnd.DragSourceDragEvent event) {
        try {
            CallPerl(
                "Java::Swing::DragSourceListener",
                "_DragSourceListener",
                new Object[] {sender, callbacks, "dropActionChanged", event}
            );
        }
        catch (InlineJavaPerlException ijpe) {
            System.err.println("couldn't call perl ijpe: " + ijpe);
        }
        catch (InlineJavaException ije) {
            System.err.println("couldn't call perl ije: " + ije);
        }
    }
    public void dragExit(java.awt.dnd.DragSourceEvent event) {
        try {
            CallPerl(
                "Java::Swing::DragSourceListener",
                "_DragSourceListener",
                new Object[] {sender, callbacks, "dragExit", event}
            );
        }
        catch (InlineJavaPerlException ijpe) {
            System.err.println("couldn't call perl ijpe: " + ijpe);
        }
        catch (InlineJavaException ije) {
            System.err.println("couldn't call perl ije: " + ije);
        }
    }
    public void dragDropEnd(java.awt.dnd.DragSourceDropEvent event) {
        try {
            CallPerl(
                "Java::Swing::DragSourceListener",
                "_DragSourceListener",
                new Object[] {sender, callbacks, "dragDropEnd", event}
            );
        }
        catch (InlineJavaPerlException ijpe) {
            System.err.println("couldn't call perl ijpe: " + ijpe);
        }
        catch (InlineJavaException ije) {
            System.err.println("couldn't call perl ije: " + ije);
        }
    }
}
