import javax.swing.event.DocumentListener;
import org.perl.inline.java.*;

public class      PerlDocumentListener
       extends    InlineJavaPerlCaller
       implements DocumentListener
{
    String sender;
    String callbacks;

    public PerlDocumentListener(String sender, String callbacks)
        throws InlineJavaException
    {
        this.sender    = sender;
        this.callbacks = callbacks;
    }

    public void insertUpdate(javax.swing.event.DocumentEvent event)  {
        try {
            CallPerl(
                "Java::Swing::DocumentListener",
                "_DocumentListener",
                new Object[] {sender, callbacks, "insertUpdate", event}
            );
        }
        catch (InlineJavaPerlException ijpe) {
            System.err.println("couldn't call perl ijpe: " + ijpe);
        }
        catch (InlineJavaException ije) {
            System.err.println("couldn't call perl ije: " + ije);
        }
    }
    public void removeUpdate(javax.swing.event.DocumentEvent event)  {
        try {
            CallPerl(
                "Java::Swing::DocumentListener",
                "_DocumentListener",
                new Object[] {sender, callbacks, "removeUpdate", event}
            );
        }
        catch (InlineJavaPerlException ijpe) {
            System.err.println("couldn't call perl ijpe: " + ijpe);
        }
        catch (InlineJavaException ije) {
            System.err.println("couldn't call perl ije: " + ije);
        }
    }
    public void changedUpdate(javax.swing.event.DocumentEvent event)  {
        try {
            CallPerl(
                "Java::Swing::DocumentListener",
                "_DocumentListener",
                new Object[] {sender, callbacks, "changedUpdate", event}
            );
        }
        catch (InlineJavaPerlException ijpe) {
            System.err.println("couldn't call perl ijpe: " + ijpe);
        }
        catch (InlineJavaException ije) {
            System.err.println("couldn't call perl ije: " + ije);
        }
    }
}
