/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.remote.server;

import java.lang.reflect.Constructor;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.ImmutableCapabilities;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.remote.server.DriverProvider;

public class DefaultDriverProvider
implements DriverProvider {
    private static final Logger LOG = Logger.getLogger(DefaultDriverProvider.class.getName());
    private Capabilities capabilities;
    private Class<? extends WebDriver> driverClass;

    public DefaultDriverProvider(Capabilities capabilities, Class<? extends WebDriver> driverClass) {
        this.capabilities = new ImmutableCapabilities(capabilities);
        this.driverClass = driverClass;
    }

    public static DriverProvider createProvider(Capabilities capabilities, String driverClassName) {
        Class<? extends WebDriver> driverClass = DefaultDriverProvider.getDriverClass(driverClassName);
        if (driverClass == null) {
            return null;
        }
        return new DefaultDriverProvider(capabilities, driverClass);
    }

    @Override
    public Capabilities getProvidedCapabilities() {
        return this.capabilities;
    }

    @Override
    public boolean canCreateDriverInstanceFor(Capabilities capabilities) {
        return this.capabilities.getBrowserName().equals(capabilities.getBrowserName());
    }

    private static Class<? extends WebDriver> getDriverClass(String driverClassName) {
        try {
            return Class.forName(driverClassName).asSubclass(WebDriver.class);
        }
        catch (ClassNotFoundException | NoClassDefFoundError e) {
            LOG.log(Level.INFO, "Driver class not found: " + driverClassName);
            return null;
        }
        catch (UnsupportedClassVersionError e) {
            LOG.log(Level.INFO, "Driver class is built for higher Java version: " + driverClassName);
            return null;
        }
    }

    @Override
    public WebDriver newInstance(Capabilities capabilities) {
        LOG.info("Creating a new session for " + capabilities);
        return this.callConstructor(this.driverClass, capabilities);
    }

    private WebDriver callConstructor(Class<? extends WebDriver> from, Capabilities capabilities) {
        try {
            Constructor<? extends WebDriver> constructor = from.getConstructor(Capabilities.class);
            return constructor.newInstance(capabilities);
        }
        catch (NoSuchMethodException e) {
            try {
                return from.newInstance();
            }
            catch (ReflectiveOperationException e1) {
                throw new WebDriverException(e);
            }
        }
        catch (ReflectiveOperationException e) {
            throw new WebDriverException(e);
        }
    }

    public String toString() {
        return this.driverClass != null ? this.driverClass.toString() : "unknown driver class";
    }
}

