# Copyright 2020, Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

package Google::Ads::GoogleAds::V12::Enums::ClickTypeEnum;

use strict;
use warnings;

use Const::Exporter enums => [
  UNSPECIFIED                           => "UNSPECIFIED",
  UNKNOWN                               => "UNKNOWN",
  APP_DEEPLINK                          => "APP_DEEPLINK",
  BREADCRUMBS                           => "BREADCRUMBS",
  BROADBAND_PLAN                        => "BROADBAND_PLAN",
  CALL_TRACKING                         => "CALL_TRACKING",
  CALLS                                 => "CALLS",
  CLICK_ON_ENGAGEMENT_AD                => "CLICK_ON_ENGAGEMENT_AD",
  GET_DIRECTIONS                        => "GET_DIRECTIONS",
  LOCATION_EXPANSION                    => "LOCATION_EXPANSION",
  LOCATION_FORMAT_CALL                  => "LOCATION_FORMAT_CALL",
  LOCATION_FORMAT_DIRECTIONS            => "LOCATION_FORMAT_DIRECTIONS",
  LOCATION_FORMAT_IMAGE                 => "LOCATION_FORMAT_IMAGE",
  LOCATION_FORMAT_LANDING_PAGE          => "LOCATION_FORMAT_LANDING_PAGE",
  LOCATION_FORMAT_MAP                   => "LOCATION_FORMAT_MAP",
  LOCATION_FORMAT_STORE_INFO            => "LOCATION_FORMAT_STORE_INFO",
  LOCATION_FORMAT_TEXT                  => "LOCATION_FORMAT_TEXT",
  MOBILE_CALL_TRACKING                  => "MOBILE_CALL_TRACKING",
  OFFER_PRINTS                          => "OFFER_PRINTS",
  OTHER                                 => "OTHER",
  PRODUCT_EXTENSION_CLICKS              => "PRODUCT_EXTENSION_CLICKS",
  PRODUCT_LISTING_AD_CLICKS             => "PRODUCT_LISTING_AD_CLICKS",
  SITELINKS                             => "SITELINKS",
  STORE_LOCATOR                         => "STORE_LOCATOR",
  URL_CLICKS                            => "URL_CLICKS",
  VIDEO_APP_STORE_CLICKS                => "VIDEO_APP_STORE_CLICKS",
  VIDEO_CALL_TO_ACTION_CLICKS           => "VIDEO_CALL_TO_ACTION_CLICKS",
  VIDEO_CARD_ACTION_HEADLINE_CLICKS     => "VIDEO_CARD_ACTION_HEADLINE_CLICKS",
  VIDEO_END_CAP_CLICKS                  => "VIDEO_END_CAP_CLICKS",
  VIDEO_WEBSITE_CLICKS                  => "VIDEO_WEBSITE_CLICKS",
  VISUAL_SITELINKS                      => "VISUAL_SITELINKS",
  WIRELESS_PLAN                         => "WIRELESS_PLAN",
  PRODUCT_LISTING_AD_LOCAL              => "PRODUCT_LISTING_AD_LOCAL",
  PRODUCT_LISTING_AD_MULTICHANNEL_LOCAL =>
    "PRODUCT_LISTING_AD_MULTICHANNEL_LOCAL",
  PRODUCT_LISTING_AD_MULTICHANNEL_ONLINE =>
    "PRODUCT_LISTING_AD_MULTICHANNEL_ONLINE",
  PRODUCT_LISTING_ADS_COUPON          => "PRODUCT_LISTING_ADS_COUPON",
  PRODUCT_LISTING_AD_TRANSACTABLE     => "PRODUCT_LISTING_AD_TRANSACTABLE",
  PRODUCT_AD_APP_DEEPLINK             => "PRODUCT_AD_APP_DEEPLINK",
  SHOWCASE_AD_CATEGORY_LINK           => "SHOWCASE_AD_CATEGORY_LINK",
  SHOWCASE_AD_LOCAL_STOREFRONT_LINK   => "SHOWCASE_AD_LOCAL_STOREFRONT_LINK",
  SHOWCASE_AD_ONLINE_PRODUCT_LINK     => "SHOWCASE_AD_ONLINE_PRODUCT_LINK",
  SHOWCASE_AD_LOCAL_PRODUCT_LINK      => "SHOWCASE_AD_LOCAL_PRODUCT_LINK",
  PROMOTION_EXTENSION                 => "PROMOTION_EXTENSION",
  SWIPEABLE_GALLERY_AD_HEADLINE       => "SWIPEABLE_GALLERY_AD_HEADLINE",
  SWIPEABLE_GALLERY_AD_SWIPES         => "SWIPEABLE_GALLERY_AD_SWIPES",
  SWIPEABLE_GALLERY_AD_SEE_MORE       => "SWIPEABLE_GALLERY_AD_SEE_MORE",
  SWIPEABLE_GALLERY_AD_SITELINK_ONE   => "SWIPEABLE_GALLERY_AD_SITELINK_ONE",
  SWIPEABLE_GALLERY_AD_SITELINK_TWO   => "SWIPEABLE_GALLERY_AD_SITELINK_TWO",
  SWIPEABLE_GALLERY_AD_SITELINK_THREE => "SWIPEABLE_GALLERY_AD_SITELINK_THREE",
  SWIPEABLE_GALLERY_AD_SITELINK_FOUR  => "SWIPEABLE_GALLERY_AD_SITELINK_FOUR",
  SWIPEABLE_GALLERY_AD_SITELINK_FIVE  => "SWIPEABLE_GALLERY_AD_SITELINK_FIVE",
  HOTEL_PRICE                         => "HOTEL_PRICE",
  PRICE_EXTENSION                     => "PRICE_EXTENSION",
  HOTEL_BOOK_ON_GOOGLE_ROOM_SELECTION => "HOTEL_BOOK_ON_GOOGLE_ROOM_SELECTION",
  SHOPPING_COMPARISON_LISTING         => "SHOPPING_COMPARISON_LISTING",
  CROSS_NETWORK                       => "CROSS_NETWORK"
];

1;
