#ifdef __cplusplus
extern "C" {
#endif

#include "EXTERN.h"
#include "perl.h"
#include "XSUB.h"
#include "config.h"
#include "uuid.h"

#ifdef __cplusplus
}
#endif


/* 2 hex digits per byte + 4 separators + 1 trailing null */
#define UUID_BUF_SZ() (2 * PERL__UUID__STRUCT_SZ + 4 + 1)

#define SV2STR(s)  (SvGROW(s, UUID_BUF_SZ()+1))


void new_generate(SV *str) {
    uuid_t uuid;
    uuid_generate(uuid);
    sv_setpvn(str, (char*)uuid, sizeof(uuid_t));
}


void new_generate_random(SV *str) {
    uuid_t uuid;
    uuid_generate_random( uuid );
    sv_setpvn(str, (unsigned char*)uuid, sizeof(uuid_t));
}


void new_generate_time(SV *str) {
    uuid_t uuid;
    uuid_generate_time( uuid );
    sv_setpvn(str, (unsigned char*)uuid, sizeof(uuid_t));
}


void new_unparse(SV *in, SV * out) {
    unsigned char str[UUID_BUF_SZ()];
    uuid_unparse((unsigned char*)SvGROW(in, sizeof(uuid_t)+1), str);
    sv_setpvn(out, str, UUID_BUF_SZ()-1);
}


void new_unparse_lower(SV *in, SV * out) {
    char str[UUID_BUF_SZ()];
    uuid_unparse_lower((unsigned char*)SvGROW(in, sizeof(uuid_t)+1), str);
    sv_setpvn(out, str, UUID_BUF_SZ()-1);
}


void new_unparse_upper(SV *in, SV * out) {
    char str[UUID_BUF_SZ()];
    uuid_unparse_upper((unsigned char*)SvGROW(in, sizeof(uuid_t)+1), str);
    sv_setpvn(out, str, UUID_BUF_SZ()-1);
}


int new_parse(SV *in, SV *out) {
    uuid_t uuid;
    int rc;
    rc = uuid_parse(SV2STR(in), uuid);
    if( !rc )
        sv_setpvn(out, (unsigned char*)uuid, sizeof(uuid_t));
    return rc;
}


void new_clear(SV *in) {
    uuid_t uuid;
    uuid_clear(uuid);
    sv_setpvn(in, (char*)uuid, sizeof(uuid_t));
}


int new_is_null(SV *in) {
    if( SvCUR(in) != sizeof(uuid_t) )
        return 0;
    return uuid_is_null((unsigned char*)SvGROW(in, sizeof(uuid_t)+1));
}


void new_copy(SV *dst, SV *src) {
    uuid_t uuid;
    if( SvCUR(src) != sizeof(uuid_t) )
        uuid_clear(uuid);
    else
        /* uuid_copy(uuid, SV2UUID(src)); */
        uuid_copy(uuid, (unsigned char*)SvGROW(src, sizeof(uuid_t)+1));
    sv_setpvn(dst, (unsigned char*)uuid, sizeof(uuid_t));
}


int new_compare(SV *uu1, SV *uu2) {
    return uuid_compare( (unsigned char*)SvGROW(uu1, sizeof(uuid_t)+1), (unsigned char*)SvGROW(uu2, sizeof(uuid_t)+1) );
}


SV* new_uuid() {
    uuid_t uuid;
    char str[UUID_BUF_SZ()];
    uuid_generate(uuid);
    uuid_unparse(uuid, str);
    return newSVpvn(str, UUID_BUF_SZ()-1);
}


int new_type(SV *in) {
    return uuid_type((unsigned char*)SvGROW(in, sizeof(uuid_t)+1));
}


int new_variant(SV *in) {
    unsigned char *ptr = (unsigned char*)SvGROW(in, sizeof(uuid_t)+1);
    unsigned short clock_seq = *(ptr+8);
    if ((clock_seq & 0x80) == 0) return UUID_VARIANT_NCS;
    if ((clock_seq & 0x40) == 0) return UUID_VARIANT_DCE;
    if ((clock_seq & 0x20) == 0) return UUID_VARIANT_MICROSOFT;
    return UUID_VARIANT_OTHER;
}


void do_debug() {
    SV *bmsg, *smsg;
#ifdef PERL__UUID__UUID_UUID_H
    PerlIO_puts(PerlIO_stdout(), "# UUID header: uuid/uuid.h\n");
#elif PERL__UUID__UUID_H
    PerlIO_puts(PerlIO_stdout(), "# UUID header: uuid.h\n");
#elif PERL__UUID__RPC_H
    PerlIO_puts(PerlIO_stdout(), "# UUID header: rpc.h\n");
#endif

#ifdef PERL__UUID__E2FS_INT
    PerlIO_puts(PerlIO_stdout(), "# UUID interface: e2fs\n");
#elif PERL__UUID__RPC_INT
    PerlIO_puts(PerlIO_stdout(), "# UUID interface: rpc\n");
#elif PERL__UUID__WIN_INT
    PerlIO_puts(PerlIO_stdout(), "# UUID interface: win\n");
#elif PERL__UUID__OSSP_INT
    PerlIO_puts(PerlIO_stdout(), "# UUID interface: ossp\n");
#endif

    bmsg = mess("# UUID buffer size: %i\n", UUID_BUF_SZ());
    PerlIO_puts(PerlIO_stdout(), SvPVX(bmsg));
    smsg = mess("# UUID struct size: %i\n", PERL__UUID__STRUCT_SZ);
    PerlIO_puts(PerlIO_stdout(), SvPVX(smsg));
}



MODULE = UUID		PACKAGE = UUID


void
generate(str)
    SV * str
    PROTOTYPE: $
    CODE:
    new_generate(str);

void
generate_random(str)
    SV * str
    PROTOTYPE: $
    CODE:
    new_generate_random(str);

void
generate_time(str)
    SV * str
    PROTOTYPE: $
    CODE:
    new_generate_time(str);

void
unparse(in, out)
    SV * in
    SV * out
    PROTOTYPE: $$
    CODE:
    new_unparse(in, out);

void
unparse_lower(in, out)
    SV * in
    SV * out
    PROTOTYPE: $$
    CODE:
    new_unparse_lower(in, out);

void
unparse_upper(in, out)
    SV * in
    SV * out
    PROTOTYPE: $$
    CODE:
    new_unparse_upper(in, out);

int
parse(in, out)
    SV * in
    SV * out
    PROTOTYPE: $$
    CODE:
    RETVAL = new_parse(in, out);
    OUTPUT:
    RETVAL

void
clear(in)
    SV * in
    PROTOTYPE: $
    CODE:
    new_clear(in);

int
is_null(in)
    SV * in
    PROTOTYPE: $
    CODE:
    RETVAL = new_is_null(in);
    OUTPUT:
    RETVAL

void
copy(dst, src)
    SV * dst
    SV * src
    CODE:
    new_copy(dst, src);

int
compare(uu1, uu2)
    SV * uu1
    SV * uu2
    CODE:
    RETVAL = new_compare(uu1, uu2);
    OUTPUT:
    RETVAL

int
type(in)
    SV * in
    PROTOTYPE: $
    CODE:
    RETVAL = new_type(in);
    OUTPUT:
    RETVAL

int
variant(in)
    SV * in
    PROTOTYPE: $
    CODE:
    RETVAL = new_variant(in);
    OUTPUT:
    RETVAL

SV*
uuid()
    PROTOTYPE:
    CODE:
    RETVAL = new_uuid();
    OUTPUT:
    RETVAL

void
debug()
    PROTOTYPE:
    CODE:
    do_debug();
