/*  GUBI - Gtk+ User Interface Builder
 *  Copyright (C) 1997	Tim Janik	<timj@psynet.net>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/
/* browser.h: widget tree browser functions
 * RCS_ID("$Id: browser.h,v 1.7 1997/08/19 01:34:12 timj Exp $")
*/


#ifndef		__browser_h__
#define		__browser_h__

#ifdef		__cplusplus
  extern	"C"	{
#endif

#include	"gbuild.h"
#include	"windows.h"
#include	"wdtree.h"



/* --- typedefs ---*/
typedef	enum
{
	ADD_AS_CHILD,
	ADD_AS_PARENT,
	ADD_AS_SIB_BEFORE,
	ADD_AS_SIB_AFTER
} add_type_E;



/* --- prototypes --- */
void	browser_create_window		(gb_wdat_base_S	*widget_data);
void	browser_refresh_window		(gb_wdat_base_S	*widget_data,
					 guint		selection_only);
void	browser_select_current_tree	(tree_S		*tree,
					 gboolean	selected);
void	sigh_typelist_Add_clicked	(GtkWidget	*widget,
					 gpointer	func_data);
void	sigh_typelist_AddType_changed	(GtkWidget	*widget,
					 add_type_E	add_type);



/* --- signal handler --- */
void	sigh_browser_Widgets_clicked	(GtkWidget	*widget,
					 gpointer	func_data);
void	sigh_browser_Edit_clicked	(GtkWidget	*widget,
					 gpointer	func_data);
void	sigh_browser_List_clicked	(GtkWidget	*widget,
					 gpointer	func_data);
void	sigh_browser_Delete_clicked	(GtkWidget	*widget,
					 gpointer	func_data);
gint	sigh_typelist_event		(GtkWidget	*widget,
					 GdkEventButton	*event);






#ifdef		__cplusplus
  }
#endif
#endif		/*__browser_h__*/
