@#  GUBI - Gtk+ User Interface Builder
@#  Copyright (C) 1997	Tim Janik	<timj@psynet.net>
@#
@#  This program is free software; you can redistribute it and/or modify
@#  it under the terms of the GNU General Public License as published by
@#  the Free Software Foundation; either version 2 of the License, or
@#  (at your option) any later version.
@#
@#  This program is distributed in the hope that it will be useful,
@#  but WITHOUT ANY WARRANTY; without even the implied warranty of
@#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
@#  GNU General Public License for more details.
@#
@#  You should have received a copy of the GNU General Public License
@#  along with this program; if not, write to the Free Software
@#  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
@#
@#  RCS_ID("$Id: gbuildc.tpl,v 1.12 1997/08/19 01:36:11 timj Exp timj $")
/* @fname@: functions executed on widget tree building
 * file created @Y@/@o@/@d@ @h@:@m@:@s@ by @builder_short@ (@fstate@)
*/
#include	"rcs.h"
RCS_ID("@_@")
RCS_KEY(Template, "$Template: gbuildc.tpl 1997 gubi $")

#define		__@fname_base@_@fname_postf@__

#include	"gbuild.h"
#include	<stdio.h>



/* --- prototypes --- */
static	gb_objdat_S*
		gb_object_data_clone			(gb_objdat_S	*source_data);
static	void	gb_widget_data_clone_with_parent	(gb_wdat_base_S	*source_data,
							 gb_wdat_base_S	*parent_data);



/* ---------------- functions ---------------- */
void
gb_sigh_widget_dump	(GtkWidget	*widget)
{
	g_assert(widget);
	
	printf("gb_sigh_widget_dump(%s):\n", widget->name ? widget->name : "");
	printf("\tname:       %s\n", gtk_widget_get_name(widget));
	printf("\tstate:      %d\n", widget->state);
	printf("\tallocation:\n");
	printf("\t  x:      %d\n", widget->allocation.x);
	printf("\t  y:      %d\n", widget->allocation.y);
	printf("\t  width:  %d\n", widget->allocation.width);
	printf("\t  height: %d\n", widget->allocation.height);
}


void
gb_sigh_pointer_nullify	(
	#ifndef	__cplusplus
			 GtkWidget	*widget,
	#else
			 GtkWidget	*,
	#endif
			 gpointer	*pointer_adress)
{
	g_assert(pointer_adress);
	
	*pointer_adress=NULL;
}


void
gb_free_pointer	(gpointer	*mem)
{
	g_free(mem);
}


void
gb_sigh_structure_free	(
	#ifndef	__cplusplus
			 GtkWidget	*widget,
	#else
			 GtkWidget	*,
	#endif
			 gb_any_S	*Struct)
{
	g_assert(Struct);
	
	if (GB_TYPE_IS_OBJDAT(Struct->type)) {
		register gb_objdat_S	*object_data=GB_CAST(objdat, Struct);
		
		g_free(object_data->keyed_data_stack);
		g_free(object_data->signal_handler_stack);
	}
	if (GB_TYPE_IS_WIDDAT(Struct->type)) {
		register gb_wdat_base_S	*widget_data=GB_wCAST(base, Struct);
		
		g_free(widget_data->linkage);
	}
	
	g_free(Struct);
}


void
gb_window_connect	(gb_wdat_window_S	*window_data)
{
	register gb_wdat_base_S	*widget_data;
	
	g_assert(GB_IS_WIDDAT_WINDOW(window_data));
	
	widget_data=GB_wCAST(base, window_data);
	while (widget_data) {
		gb_widget_connect(widget_data);
		widget_data=widget_data->next;
	}
}


void
gb_widget_connect	(gb_wdat_base_S	*widget_data)
{
	g_assert(GB_IS_WIDDAT(widget_data));
	
	gb_object_connect(GB_CAST(objdat, widget_data));
}


void
gb_object_connect	(gb_objdat_S	*object_data)
{
	register gb_signal_handler_S	*handler;
	
	g_assert(GB_IS_OBJDAT(object_data));
	g_assert(object_data->object);
	
	if (!object_data->signal_handler_stack)
		return;
	
	handler=object_data->signal_handler_stack;
	while (handler->signal_name) {
		register gb_handler_data_U	data_p;
		
		if (handler->connect_options&GB_CONNECT_DATA_POINTER)
			data_p.func_data=*handler->data.func_data_p;
		else
			data_p.func_data=handler->data.func_data;
	
		if (handler->connect_options&GB_CONNECT_OBJECT && data_p.slot_object==NULL)
			data_p.slot_object=GTK_OBJECT(object_data->object);
			
		switch ( handler->connect_options &
			 ( GB_CONNECT |
			   GB_CONNECT_OBJECT |
			   GB_CONNECT_AFTER ) ) {
		
		case	GB_CONNECT:
			handler->handler_id=gtk_signal_connect(
				GTK_OBJECT(object_data->object),
				handler->signal_name,
				handler->handler_func,
				data_p.func_data);
			break;
		
		case	GB_CONNECT | GB_CONNECT_AFTER:
			handler->handler_id=gtk_signal_connect_after(
				GTK_OBJECT(object_data->object),
				handler->signal_name,
				handler->handler_func,
				data_p.func_data);
			break;
		
		case	GB_CONNECT | GB_CONNECT_OBJECT:
			handler->handler_id=gtk_signal_connect_object(
				GTK_OBJECT(object_data->object),
				handler->signal_name,
				handler->handler_func,
				data_p.slot_object);
			break;

		case	GB_CONNECT | GB_CONNECT_OBJECT | GB_CONNECT_AFTER:
			handler->handler_id=gtk_signal_connect_object_after(
				GTK_OBJECT(object_data->object),
				handler->signal_name,
				handler->handler_func,
				data_p.slot_object);
			break;

		default:
			break;
		}
		handler++;
	}
}


void
gb_widget_data_clone	(gb_wdat_base_S	*widget_data)
{
	register gb_wdat_base_S	*temp_data;
	
	g_assert(GB_IS_WIDDAT(widget_data));
	
	
	/* clear all clone references in list
	*/
	temp_data=widget_data;
	while (temp_data->parent)
		temp_data=temp_data->parent;
	while (temp_data) {
		temp_data->clone=NULL;
		temp_data=temp_data->next;
	}
	
	
	/* do the real cloning
	*/
	gb_widget_data_clone_with_parent(widget_data, NULL);
}


gb_objdat_S*
gb_object_data_clone	(gb_objdat_S	*source_data)
{
	register gb_objdat_S	*object_data;
	
	g_assert(GB_IS_OBJDAT(source_data));
	
	
	/* copy the object data structure
	*/
	object_data=GB_CAST(objdat, memdup(source_data, gb_struct_size(source_data->type)));
	object_data->next=NULL;
	
	
	/* set clone reference in source structure
	*/
	source_data->clone=object_data;
	object_data->clone=NULL;
	object_data->gfree_on_destroy=TRUE;
	
	
	/* copy the keyed_data_stack
	*/
	if (source_data->keyed_data_stack) {
		register guint		i;
		for (i=0; source_data->keyed_data_stack[i].key!=NULL; i++);
		i++;
		object_data->keyed_data_stack=GB_CAST(keyed_data, memdup(source_data->keyed_data_stack, i*sizeof(gb_keyed_data_S)));
	}
	
	
	/* copy the signal_handler_stack
	*/
	if (source_data->signal_handler_stack) {
		register guint		i;
		for (i=0; source_data->signal_handler_stack[i].signal_name!=NULL; i++);
		i++;
		object_data->signal_handler_stack=GB_CAST(signal_handler, memdup(source_data->signal_handler_stack, i*sizeof(gb_signal_handler_S)));
	}
	
	return object_data;
}


void
gb_widget_data_clone_with_parent	(gb_wdat_base_S	*source_data,
					 gb_wdat_base_S	*parent_data)
{
	static	 gb_wdat_base_S	**NextPointer;
	register gb_wdat_base_S	*child_data;
	register gb_wdat_base_S	*widget_data;
	
	g_assert(GB_IS_WIDDAT(source_data));
	
	
	/* copy the widget data structure including signal handlers
	*/
	widget_data=GB_wCAST(base, gb_object_data_clone(GB_CAST(objdat, source_data)));
	
	
	/* copy the linkage information
	*/
	if (source_data->linkage)
		widget_data->linkage=GB_CAST(any, memdup(source_data->linkage, gb_struct_size(source_data->linkage->type)));
	
	
	/* if we have a new parent,
	 * we set it, and add us to the list
	*/
	if (parent_data) {
		g_assert(GB_IS_WIDDAT_CONTAINER(parent_data));
		widget_data->parent=parent_data;
		*NextPointer=widget_data;
	}
	
	
	/* make us the last one in the list now
	*/
	NextPointer=&widget_data->next;
	
	
	/* update widget specific fields
	*/
	switch (widget_data->type) {
	
	case	GB_WIDGET_RADIO_BUTTON:
		if (GB_wCAST(radio_button, widget_data)->grouping &&
		    GB_wCAST(radio_button, widget_data)->grouping->clone)
			GB_wCAST(radio_button, widget_data)->grouping=GB_wCAST(radio_button,
				GB_wCAST(radio_button, widget_data)->grouping->clone);
		else
			GB_wCAST(radio_button, widget_data)->grouping=NULL;
		break;
	
	default:
		break;
	}
	
	
	/* let's add our children as well
	*/
	child_data=source_data->next;
	while (child_data) {
		if (child_data->parent==source_data)
			gb_widget_data_clone_with_parent(child_data, widget_data);
		child_data=child_data->next;
	}
}


void
gb_window_build		(gb_wdat_window_S	*window_data)
{
	static	gb_wdat_base_S		*widget_data;
	
	g_assert(GB_IS_WIDDAT_WINDOW(window_data));
	g_assert(!window_data->parent);


	/* create window widget and apply it's data
	*/
	gb_widget_create(GB_wCAST(base, window_data));
	
	
	/* build widget tree
	*/
	widget_data=window_data->next;
	
	while (widget_data) {
		gb_widget_create(widget_data);
		widget_data=widget_data->next;
	};
}


void
gb_widget_create	(gb_wdat_base_S	*widget_data)
{
	
	g_assert(GB_IS_WIDDAT(widget_data));
	/* g_assert(widget_data->parent || GB_IS_WIDDAT_WINDOW(widget_data)); */
	
	if (widget_data->widget)
		g_warning("gb_create_widget(%d):\nfailed to assert: widget_data->widget==NULL",
			  widget_data->type);
	
	
	/* call appropriate creation function for this widget
	*/
	switch (widget_data->type) {
		register GSList		*radio_group;
		
	case	GB_WIDGET_LABEL:
		widget_data->widget=gtk_label_new(GB_wCAST(label, widget_data)->label);
		break;

	case	GB_WIDGET_ENTRY:
		widget_data->widget=gtk_entry_new();
		if (GB_wCAST(entry, widget_data)->init_text)
			gtk_entry_set_text(GTK_ENTRY(widget_data->widget),
					   GB_wCAST(entry, widget_data)->init_text);
		break;

	case	GB_WIDGET_H_SEPARATOR:
		widget_data->widget=gtk_hseparator_new();
		break;
		
	case	GB_WIDGET_V_SEPARATOR:
		widget_data->widget=gtk_vseparator_new();
		break;
		
	case	GB_WIDGET_BUTTON:
		if (GB_wCAST(button, widget_data)->label)
			widget_data->widget=gtk_button_new_with_label(
							GB_wCAST(button,
							widget_data)->label);
		else
			widget_data->widget=gtk_button_new();
		break;

	case	GB_WIDGET_TOGGLE_BUTTON:
		if (GB_wCAST(toggle_button, widget_data)->label)
			widget_data->widget=gtk_toggle_button_new_with_label(
							GB_wCAST(toggle_button,
							widget_data)->label);
		else
			widget_data->widget=gtk_toggle_button_new();
		gtk_toggle_button_set_state(GTK_TOGGLE_BUTTON(widget_data->widget),
					    GB_wCAST(toggle_button, widget_data)->init_state);
		break;
		
	case	GB_WIDGET_CHECK_BUTTON:
		if (GB_wCAST(check_button, widget_data)->label)
			widget_data->widget=gtk_check_button_new_with_label(
							GB_wCAST(check_button,
							widget_data)->label);
		else
			widget_data->widget=gtk_check_button_new();
		gtk_toggle_button_set_state(GTK_TOGGLE_BUTTON(widget_data->widget),
					    GB_wCAST(check_button, widget_data)->init_state);
		break;
	
	case	GB_WIDGET_RADIO_BUTTON:
		if (GB_wCAST(radio_button, widget_data)->grouping) {
			g_assert(GB_wCAST(radio_button, widget_data)->grouping->widget);
			
			radio_group=gtk_radio_button_group(
				GTK_RADIO_BUTTON(GB_wCAST(radio_button, widget_data)->grouping->widget));
		} else
			radio_group=NULL;
		
		if (GB_wCAST(radio_button, widget_data)->label)
			widget_data->widget=gtk_radio_button_new_with_label(
							radio_group,
							GB_wCAST(radio_button,
							widget_data)->label);
		else
			widget_data->widget=gtk_radio_button_new(radio_group);
		gtk_toggle_button_set_state(GTK_TOGGLE_BUTTON(widget_data->widget),
					    GB_wCAST(radio_button, widget_data)->init_state);
		break;

	case	GB_WIDGET_FRAME:
		widget_data->widget=gtk_frame_new(GB_wCAST(frame, widget_data)->label);
		break;
		
	case	GB_WIDGET_TABLE:
		widget_data->widget=gtk_table_new(GB_wCAST(table, widget_data)->rows,
					     GB_wCAST(table, widget_data)->columns,
					     GB_wCAST(table, widget_data)->homogeneous);
		break;
	
	case	GB_WIDGET_NOTEBOOK:
		widget_data->widget=gtk_notebook_new();
		break;
	
	case	GB_WIDGET_H_BOX:
		widget_data->widget=gtk_hbox_new(GB_wCAST(h_box, widget_data)->homogeneous,
					    GB_wCAST(h_box, widget_data)->spacing);
		break;
		
	case	GB_WIDGET_V_BOX:
		widget_data->widget=gtk_vbox_new(GB_wCAST(v_box, widget_data)->homogeneous,
					    GB_wCAST(v_box, widget_data)->spacing);
		break;
		
	case	GB_WIDGET_LIST:
		widget_data->widget=gtk_list_new();
		break;
		
	case	GB_WIDGET_SCROLLED_WINDOW:
		widget_data->widget=gtk_scrolled_window_new(NULL, NULL);
		break;
		
	case	GB_WIDGET_PROGRESS_BAR:
		widget_data->widget=gtk_progress_bar_new();
		gtk_progress_bar_update(GTK_PROGRESS_BAR(widget_data->widget),
					GB_wCAST(progress_bar,
					widget_data)->init_percentage);
		break;
	
	case	GB_WIDGET_ARROW:
		widget_data->widget=gtk_arrow_new(GB_wCAST(arrow, widget_data)->arrow_type,
					     GB_wCAST(arrow, widget_data)->shadow_type);
		break;
	
	case	GB_WIDGET_DRAWING_AREA:
		widget_data->widget=gtk_drawing_area_new();
		break;
	
	case	GB_WIDGET_H_SCALE:
		widget_data->widget=gtk_hscale_new(GB_wCAST(h_scale, widget_data)->adjustment);
		break;
	
	case	GB_WIDGET_V_SCALE:
		widget_data->widget=gtk_vscale_new(GB_wCAST(v_scale, widget_data)->adjustment);
		break;

	case	GB_WIDGET_H_RULER:
		widget_data->widget=gtk_hruler_new();
		break;
		
	case	GB_WIDGET_V_RULER:
		widget_data->widget=gtk_vruler_new();
		break;
	
	case	GB_WIDGET_LIST_ITEM:
		if (GB_wCAST(list_item, widget_data)->label)
			widget_data->widget=gtk_list_item_new_with_label(
							GB_wCAST(list_item,
							widget_data)->label);
		else
			widget_data->widget=gtk_list_item_new();
		break;
	
	case	GB_WIDGET_WINDOW:
		widget_data->widget=gtk_window_new(GB_wCAST(window,
						widget_data)->win_type);
		break;
	
	case	GB_WIDGET_FILE_SELECTION:
		widget_data->widget=gtk_file_selection_new(GB_wCAST(file_selection,
						      widget_data)->title);
		break;

	default:
		g_error("gb_widget_create(): unknown structure type: `%d'",
			widget_data->type);
	};
	
	
	/* if we are a clone, we want to be free()d,
	 * otherwise we want our widget pointer
	 * to be nullified
	*/
	if (widget_data->gfree_on_destroy)
		gtk_signal_connect(GTK_OBJECT(widget_data->widget),
				   "destroy",
				   GTK_SIGNAL_FUNC(gb_sigh_structure_free),
				   widget_data);
	else
		GB_NULLIFY_ON_DESTROY(widget_data->widget, &widget_data->widget);
	
	
	/* link widget to parent
	*/
	if (widget_data->parent) switch (widget_data->parent->type) {
	register gb_linkage_box_S	*l_box;
	register gb_linkage_table_S	*l_table;
	register gb_linkage_notebook_S	*l_notebook;
	register GtkBox			*box;
		
	case	GB_WIDGET_LIST:
	case	GB_WIDGET_FRAME:
	case	GB_WIDGET_LIST_ITEM:
	case	GB_WIDGET_BUTTON:
	case	GB_WIDGET_RADIO_BUTTON:
	case	GB_WIDGET_CHECK_BUTTON:
	case	GB_WIDGET_TOGGLE_BUTTON:
	case	GB_WIDGET_SCROLLED_WINDOW:
	case	GB_WIDGET_WINDOW:
		g_assert(!widget_data->linkage);
		
		gtk_container_add(GTK_CONTAINER(widget_data->parent->widget), widget_data->widget);
		break;
		
	case	GB_WIDGET_TABLE:
		l_table=(gb_linkage_table_S*)widget_data->linkage;
		
		if (l_table) {
			g_assert(l_table->type==GB_LINKAGE_TABLE);
			
			gtk_table_attach(GTK_TABLE(widget_data->parent->widget),
					 widget_data->widget,
					 l_table->left_attach,
					 l_table->right_attach,
					 l_table->top_attach,
					 l_table->bottom_attach,
					 l_table->xoptions,
					 l_table->yoptions,
					 l_table->xpadding,
					 l_table->xpadding);
		} else
			gtk_container_add(GTK_CONTAINER(widget_data->parent->widget), widget_data->widget);
		break;

	case	GB_WIDGET_NOTEBOOK:
		l_notebook=(gb_linkage_notebook_S*)widget_data->linkage;
		
		if (l_notebook) {
			register GtkWidget	*label;
			
			label=gtk_label_new(l_notebook->tab_label);
			gtk_misc_set_alignment(GTK_MISC(label),
					       l_notebook->tab_xalign,
					       l_notebook->tab_yalign);
			gtk_misc_set_padding(GTK_MISC(label),
					     l_notebook->tab_xpad,
					     l_notebook->tab_ypad);
			switch (l_notebook->page_linkage) {
			
			case	GB_PAGE_INSERT:
				gtk_notebook_insert_page(GTK_NOTEBOOK(widget_data->parent->widget),
							 widget_data->widget,
							 label,
							 l_notebook->position);
				break;
			
			case	GB_PAGE_APPEND:
				gtk_notebook_append_page(GTK_NOTEBOOK(widget_data->parent->widget),
							 widget_data->widget,
							 label);
				break;
			
			case	GB_PAGE_PREPEND:
				gtk_notebook_prepend_page(GTK_NOTEBOOK(widget_data->parent->widget),
							 widget_data->widget,
							 label);
				break;
			
			default:
				g_assert_not_reached();
				break;
			}
		} else {
			register GtkWidget	*label;
			
			label=gtk_label_new("");
			gtk_notebook_append_page(GTK_NOTEBOOK(widget_data->parent->widget), widget_data->widget, label);
		}
		gtk_notebook_set_page(GTK_NOTEBOOK(widget_data->parent->widget),
				      GB_wCAST(notebook, widget_data->parent)->initial_page);
		break;
	
	case	GB_WIDGET_H_BOX:
	case	GB_WIDGET_V_BOX:
	case	GB_WIDGET_FILE_SELECTION:
		l_box=(gb_linkage_box_S*)widget_data->linkage;
		if (widget_data->parent->type==GB_WIDGET_FILE_SELECTION)
			box=GTK_BOX(GTK_FILE_SELECTION(widget_data->parent->widget)->main_vbox);
		else
			box=GTK_BOX(widget_data->parent->widget);
		
		if (l_box) {
			g_assert(l_box->type==GB_LINKAGE_BOX);
		
			switch (l_box->pack_type) {
			
			case GTK_PACK_START:
				gtk_box_pack_start(box,
						   widget_data->widget,
						   (l_box->attach&GTK_EXPAND)!=0,
						   (l_box->attach&GTK_FILL)!=0,
						   l_box->padding);
				break;
			
			case GTK_PACK_END:
				gtk_box_pack_end(box,
						 widget_data->widget,
						 (l_box->attach&GTK_EXPAND)!=0,
						 (l_box->attach&GTK_FILL)!=0,
						 l_box->padding);
				break;
			}
		} else
			gtk_container_add(GTK_CONTAINER(box), widget_data->widget);
		break;
			
	default:
		g_error("gb_widget_create(): parent: unknown structure type: `%d'",
			widget_data->parent->type);
		break;
	}
	
	
	/* apply widgets data
	*/
	gb_widget_data_set(widget_data);
}


void
gb_widget_data_set	(gb_wdat_base_S	*widget_data)
{
	
	g_assert(GB_IS_WIDDAT(widget_data));
	
	if (!widget_data->widget) {
		g_warning("gb_widget_data_set(%d):\nfailed to assert: widget_data->widget!=NULL",
			  widget_data->type);
		return;
	}
	
	
	/* set specific data of this widget
	*/
	switch (widget_data->type) {
		
	case	GB_WIDGET_LABEL:
		gtk_label_set(GTK_LABEL(widget_data->widget), GB_wCAST(label, widget_data)->label);
		break;

	case	GB_WIDGET_ENTRY:
		break;

	case	GB_WIDGET_H_SEPARATOR:
		break;
		
	case	GB_WIDGET_V_SEPARATOR:
		break;
		
	case	GB_WIDGET_BUTTON:
		break;

	case	GB_WIDGET_TOGGLE_BUTTON:
		gtk_toggle_button_set_mode(GTK_TOGGLE_BUTTON(widget_data->widget),
					   GB_wCAST(toggle_button, widget_data)->draw_indicator);
		break;
		
	case	GB_WIDGET_CHECK_BUTTON:
		gtk_toggle_button_set_mode(GTK_TOGGLE_BUTTON(widget_data->widget),
					   GB_wCAST(check_button, widget_data)->draw_indicator);
		break;
	
	case	GB_WIDGET_RADIO_BUTTON:
		gtk_toggle_button_set_mode(GTK_TOGGLE_BUTTON(widget_data->widget),
					   GB_wCAST(radio_button, widget_data)->draw_indicator);
		break;

	case	GB_WIDGET_FRAME:
		gtk_frame_set_label(GTK_FRAME(widget_data->widget),
				    GB_wCAST(frame, widget_data)->label);
		gtk_frame_set_shadow_type(GTK_FRAME(widget_data->widget),
					  GB_wCAST(frame, widget_data)->shadow_type);
		gtk_frame_set_label_align(GTK_FRAME(widget_data->widget),
					  GB_wCAST(frame, widget_data)->xalign,
					  GB_wCAST(frame, widget_data)->yalign);
		break;
		
	case	GB_WIDGET_TABLE:
		gtk_table_set_row_spacings(GTK_TABLE(widget_data->widget),
					   GB_wCAST(table, widget_data)->row_spacing);
		gtk_table_set_col_spacings(GTK_TABLE(widget_data->widget),
					   GB_wCAST(table, widget_data)->col_spacing);
		break;
	
	case	GB_WIDGET_NOTEBOOK:
		gtk_notebook_set_tab_pos(GTK_NOTEBOOK(widget_data->widget),
					 GB_wCAST(notebook, widget_data)->tab_position);
		gtk_notebook_set_show_tabs(GTK_NOTEBOOK(widget_data->widget),
					   GB_wCAST(notebook, widget_data)->show_tabs!=0);
		gtk_notebook_set_show_border(GTK_NOTEBOOK(widget_data->widget),
					     GB_wCAST(notebook, widget_data)->show_border!=0);
		break;
	
	case	GB_WIDGET_H_BOX:
		break;
		
	case	GB_WIDGET_V_BOX:
		break;
		
	case	GB_WIDGET_LIST:
		gtk_list_set_selection_mode(GTK_LIST(widget_data->widget),
					    GB_wCAST(list, widget_data)->select_mode);
		break;
		
	case	GB_WIDGET_SCROLLED_WINDOW:
		gtk_scrolled_window_set_policy(GTK_SCROLLED_WINDOW(widget_data->widget),
					GB_wCAST(scrolled_window, widget_data)->hscrollbar_policy,
					GB_wCAST(scrolled_window, widget_data)->vscrollbar_policy);
		break;
		
	case	GB_WIDGET_PROGRESS_BAR:
		break;
	
	case	GB_WIDGET_ARROW:
		gtk_arrow_set(GTK_ARROW(widget_data->widget),
			      GB_wCAST(arrow, widget_data)->arrow_type,
			      GB_wCAST(arrow, widget_data)->shadow_type);
		break;
	
	case	GB_WIDGET_DRAWING_AREA:
		gtk_drawing_area_size(GTK_DRAWING_AREA(widget_data->widget),
				      GB_wCAST(drawing_area, widget_data)->req_width,
				      GB_wCAST(drawing_area, widget_data)->req_height);
		break;
	
	case	GB_WIDGET_H_SCALE:
		gtk_range_set_adjustment(GTK_RANGE(widget_data->widget),
					 GB_wCAST(h_scale, widget_data)->adjustment);
		gtk_scale_set_digits(GTK_SCALE(widget_data->widget),
				     GB_wCAST(h_scale, widget_data)->digits);
		gtk_scale_set_draw_value(GTK_SCALE(widget_data->widget),
					 GB_wCAST(h_scale, widget_data)->draw_value);
		gtk_scale_set_value_pos(GTK_SCALE(widget_data->widget),
					GB_wCAST(h_scale, widget_data)->value_pos);
		gtk_range_set_update_policy(GTK_RANGE(widget_data->widget),
					    GB_wCAST(h_scale, widget_data)->update_policy);
		break;
	
	case	GB_WIDGET_V_SCALE:
		gtk_range_set_adjustment(GTK_RANGE(widget_data->widget),
					 GB_wCAST(v_scale, widget_data)->adjustment);
		gtk_scale_set_digits(GTK_SCALE(widget_data->widget),
				     GB_wCAST(v_scale, widget_data)->digits);
		gtk_scale_set_draw_value(GTK_SCALE(widget_data->widget),
					 GB_wCAST(v_scale, widget_data)->draw_value);
		gtk_scale_set_value_pos(GTK_SCALE(widget_data->widget),
					GB_wCAST(v_scale, widget_data)->value_pos);
		gtk_range_set_update_policy(GTK_RANGE(widget_data->widget),
					    GB_wCAST(v_scale, widget_data)->update_policy);
		break;

	case	GB_WIDGET_H_RULER:
		gtk_ruler_set_metric(GTK_RULER(widget_data->widget),
				     GB_wCAST(h_ruler, widget_data)->metric);
		gtk_ruler_set_range(GTK_RULER(widget_data->widget),
				    GB_wCAST(h_ruler, widget_data)->lower,
				    GB_wCAST(h_ruler, widget_data)->upper,
				    GB_wCAST(h_ruler, widget_data)->position,
				    GB_wCAST(h_ruler, widget_data)->max_size);
		gtk_ruler_draw_ticks(GTK_RULER(widget_data->widget));
		gtk_ruler_draw_pos(GTK_RULER(widget_data->widget));
		break;
		
	case	GB_WIDGET_V_RULER:
		gtk_ruler_set_metric(GTK_RULER(widget_data->widget),
				     GB_wCAST(v_ruler, widget_data)->metric);
		gtk_ruler_set_range(GTK_RULER(widget_data->widget),
				    GB_wCAST(v_ruler, widget_data)->lower,
				    GB_wCAST(v_ruler, widget_data)->upper,
				    GB_wCAST(v_ruler, widget_data)->position,
				    GB_wCAST(v_ruler, widget_data)->max_size);
		gtk_ruler_draw_ticks(GTK_RULER(widget_data->widget));
		gtk_ruler_draw_pos(GTK_RULER(widget_data->widget));
		break;
	
	case	GB_WIDGET_LIST_ITEM:
		break;
	
	case	GB_WIDGET_WINDOW:
		gtk_window_set_title(GTK_WINDOW(widget_data->widget),
				     GB_wCAST(window, widget_data)->title);
		gtk_window_position(GTK_WINDOW(widget_data->widget),
				    GB_wCAST(window, widget_data)->win_position);
		gtk_window_set_policy(GTK_WINDOW(widget_data->widget),
				      (GB_wCAST(window, widget_data)->resize_policy&GB_ALLOW_SHRINK)!=0,
				      (GB_wCAST(window, widget_data)->resize_policy&GB_ALLOW_GROW)!=0,
				      (GB_wCAST(window, widget_data)->resize_policy&GB_AUTO_SHRINK)!=0);
		break;
	
	case	GB_WIDGET_FILE_SELECTION:
		gtk_window_set_title(GTK_WINDOW(widget_data->widget),
				     GB_wCAST(file_selection, widget_data)->title);
		gtk_window_position(GTK_WINDOW(widget_data->widget),
				    GB_wCAST(file_selection, widget_data)->win_position);
		gtk_window_set_policy(GTK_WINDOW(widget_data->widget),
				      (GB_wCAST(file_selection, widget_data)->resize_policy&GB_ALLOW_SHRINK)!=0,
				      (GB_wCAST(file_selection, widget_data)->resize_policy&GB_ALLOW_GROW)!=0,
				      (GB_wCAST(file_selection, widget_data)->resize_policy&GB_AUTO_SHRINK)!=0);
		if (GB_wCAST(file_selection, widget_data)->filename)
			gtk_file_selection_set_filename(GTK_FILE_SELECTION(widget_data->widget),
							GB_wCAST(file_selection, widget_data)->filename);
		break;

	default:
		g_error("gb_widget_data_set(): unknown structure type: `%d'",
			widget_data->type);
	};
	
	
	/* set our name for Gtk+
	*/
	if (widget_data->widget_name)
		gtk_widget_set_name(widget_data->widget, widget_data->widget_name);
	
	
	/* set base data
	*/
	if (widget_data->x>=0 && widget_data->y>=0)
		gtk_widget_set_uposition(widget_data->widget, widget_data->x, widget_data->y);
	if (widget_data->width>0 && widget_data->height>0)
		gtk_widget_set_usize(widget_data->widget, widget_data->width, widget_data->height);
	gtk_widget_set_sensitive(widget_data->widget, (widget_data->flags&GTK_SENSITIVE)!=0);
	if (widget_data->flags&GTK_CAN_DEFAULT)
		GTK_WIDGET_SET_FLAGS(widget_data->widget, GTK_CAN_DEFAULT);
	else
		GTK_WIDGET_UNSET_FLAGS(widget_data->widget, GTK_CAN_DEFAULT);
	if (widget_data->flags&GTK_CAN_FOCUS)
		GTK_WIDGET_SET_FLAGS(widget_data->widget, GTK_CAN_FOCUS);
	else
		GTK_WIDGET_UNSET_FLAGS(widget_data->widget, GTK_CAN_FOCUS);
	gtk_object_set_user_data(GTK_OBJECT(widget_data->widget), widget_data->user_data);
	
	
	/* set misc data
	*/
	if (GTK_IS_MISC(widget_data->widget)) {
		gtk_misc_set_alignment(GTK_MISC(widget_data->widget),
				       GB_wCAST(misc, widget_data)->xalign,
				       GB_wCAST(misc, widget_data)->yalign);
		gtk_misc_set_padding(GTK_MISC(widget_data->widget),
				     GB_wCAST(misc, widget_data)->xpad,
				     GB_wCAST(misc, widget_data)->ypad);
	}
	
	
	/* set container specific data
	*/
	if (GB_IS_WIDDAT_CONTAINER(widget_data))
		gtk_container_border_width(GTK_CONTAINER(widget_data->widget),
					   GB_wCAST(container,
					   	widget_data)->border_width);
	
	
	/* grab default
	*/
	if (widget_data->flags&GTK_HAS_DEFAULT && GTK_WIDGET_CAN_DEFAULT(widget_data->widget))
		gtk_widget_grab_default(widget_data->widget);
	
	
	/* grab focus
	*/
	if (widget_data->flags&GTK_HAS_FOCUS && GTK_WIDGET_CAN_FOCUS(widget_data->widget))
		gtk_widget_grab_focus(widget_data->widget);
	
	
	/* if widget has a parent, show or hide it according to
	 * it's visibility
	*/
	if (widget_data->parent) {
		if (widget_data->flags&GTK_VISIBLE) {
			if (!GTK_WIDGET_VISIBLE(widget_data->widget))
				gtk_widget_show(widget_data->widget);
		} else {
			if (GTK_WIDGET_VISIBLE(widget_data->widget))
				gtk_widget_hide(widget_data->widget);
		}
	}
}


guint	gb_struct_size(const gb_struct_type_E struct_type)
{
	switch (struct_type) {
	
	case	GB_STRUCT_NONE:
	case	GB_STRUCT_LAST:
	default:
		g_assert_not_reached();
		return 0;

	case	GB_LINKAGE_BOX:
		return sizeof(gb_linkage_box_S);
	
	case	GB_LINKAGE_TABLE:
		return sizeof(gb_linkage_table_S);
	
	case	GB_LINKAGE_NOTEBOOK:
		return sizeof(gb_linkage_notebook_S);
		
	case	GB_OBJECT:
		return sizeof(gb_objdat_S);

	case	GB_WIDGET_BASE:
		return sizeof(gb_wdat_base_S);
	
	case	GB_WIDGET_DRAWING_AREA:
		return sizeof(gb_wdat_drawing_area_S);
	
	case	GB_WIDGET_ENTRY:
		return sizeof(gb_wdat_entry_S);
	
	case	GB_WIDGET_PROGRESS_BAR:
		return sizeof(gb_wdat_progress_bar_S);
	
	case	GB_WIDGET_RULER:
		return sizeof(gb_wdat_ruler_S);
	
	case	GB_WIDGET_H_RULER:
		return sizeof(gb_wdat_h_ruler_S);
	
	case	GB_WIDGET_V_RULER:
		return sizeof(gb_wdat_v_ruler_S);
	
	case	GB_WIDGET_SCALE:
		return sizeof(gb_wdat_scale_S);
	
	case	GB_WIDGET_H_SCALE:
		return sizeof(gb_wdat_h_scale_S);
	
	case	GB_WIDGET_V_SCALE:
		return sizeof(gb_wdat_v_scale_S);
	
	case	GB_WIDGET_SEPARATOR:
		return sizeof(gb_wdat_separator_S);
	
	case	GB_WIDGET_H_SEPARATOR:
		return sizeof(gb_wdat_h_separator_S);
	
	case	GB_WIDGET_V_SEPARATOR:
		return sizeof(gb_wdat_v_separator_S);
	
	case	GB_WIDGET_MISC:
		return sizeof(gb_wdat_misc_S);
	
	case	GB_WIDGET_ARROW:
		return sizeof(gb_wdat_arrow_S);
	
	case	GB_WIDGET_LABEL:
		return sizeof(gb_wdat_label_S);
	
	case	GB_WIDGET_CONTAINER:
		return sizeof(gb_wdat_container_S);
	
	case	GB_WIDGET_BUTTON:
		return sizeof(gb_wdat_button_S);
	
	case	GB_WIDGET_TOGGLE_BUTTON:
		return sizeof(gb_wdat_toggle_button_S);
	
	case	GB_WIDGET_CHECK_BUTTON:
		return sizeof(gb_wdat_check_button_S);
	
	case	GB_WIDGET_RADIO_BUTTON:
		return sizeof(gb_wdat_radio_button_S);
	
	case	GB_WIDGET_LIST:
		return sizeof(gb_wdat_list_S);
	
	case	GB_WIDGET_SCROLLED_WINDOW:
		return sizeof(gb_wdat_scrolled_window_S);
	
	case	GB_WIDGET_TABLE:
		return sizeof(gb_wdat_table_S);
	
	case	GB_WIDGET_NOTEBOOK:
		return sizeof(gb_wdat_notebook_S);
	
	case	GB_WIDGET_BOX:
		return sizeof(gb_wdat_box_S);
	
	case	GB_WIDGET_H_BOX:
		return sizeof(gb_wdat_h_box_S);
	
	case	GB_WIDGET_V_BOX:
		return sizeof(gb_wdat_v_box_S);
	
	case	GB_WIDGET_BIN:
		return sizeof(gb_wdat_bin_S);
	
	case	GB_WIDGET_FRAME:
		return sizeof(gb_wdat_frame_S);
	
	case	GB_WIDGET_ITEM:
		return sizeof(gb_wdat_item_S);
	
	case	GB_WIDGET_LIST_ITEM:
		return sizeof(gb_wdat_list_item_S);
	
	case	GB_WIDGET_WINDOW:
		return sizeof(gb_wdat_window_S);
	
	case	GB_WIDGET_FILE_SELECTION:
		return sizeof(gb_wdat_file_selection_S);
	}
}
