/* The GIMP -- an image manipulation program
 * Copyright (C) 1995 Spencer Kimball and Peter Mattis
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <string.h>
#include "buffer_ptr.h"



static void
gimp_ptr_buffer_delete (GimpBuffer * buffer)
{
  GimpPtrBuffer * ptr_buffer = GIMP_PTR_BUFFER (buffer);

  gimp_buffer_uninit (buffer);
  g_free (ptr_buffer);
}


static gboolean
gimp_ptr_buffer_alloc (GimpBuffer   *buffer,
                       GimpArea     *area,
                       Alloc         how)
{
  return TRUE;
}


static gboolean
gimp_ptr_buffer_validate (GimpBuffer  *buffer,
                          GimpArea    *area, 
                          Validate     how)
{
  return TRUE;
}


static gboolean
gimp_ptr_buffer_use (GimpBuffer  *buffer,
                     GimpPortion *portion, 
                     Use          how)
{
  return TRUE;
}


static gboolean
gimp_ptr_buffer_query (GimpBuffer    *buffer,
                       GimpPortion   *portion,
                       GimpMemStatus *status)
{
  status->alloced   = TRUE;
  status->valid     = TRUE;
  status->usecount  = 1;
  
  return TRUE;
}


static gboolean
gimp_ptr_buffer_data (GimpBuffer      *buffer,
                      GimpPortion     *portion,
                      GimpPixelArray  *array)
{
  GimpPtrBuffer * ptr_buffer = GIMP_PTR_BUFFER (buffer);

  /* describe the memory layout */
  array->tag       = buffer->_z.tag;
  array->width     = MIN (buffer->_x.len,
                          portion->focus.b.x) - portion->focus.a.x;
  array->height    = MIN (buffer->_y.len,
                          portion->focus.b.y) - portion->focus.a.y;
  array->pixstride = buffer->_z.len;
  array->rowstride = buffer->_z.len * buffer->_x.len;

  /* get a pointer to the memory */
  array->data = &ptr_buffer->yuck;

  /* and save an offset to the first pixel */
  array->offset = (portion->focus.a.y * array->rowstride) +
                  (portion->focus.a.x * array->pixstride);

  return TRUE;
}


static GimpPtrBufferClass my_class =
{
  {
    BUFFER_PTR,
    gimp_ptr_buffer_delete,
    gimp_ptr_buffer_alloc,
    NULL, /* map */
    gimp_ptr_buffer_validate,
    gimp_ptr_buffer_use,
    gimp_ptr_buffer_query,
    gimp_ptr_buffer_data
  }
};






GimpPtrBuffer *
gimp_ptr_buffer_new (void * ptr,
                     Tag    tag,
                     gint   x_len,
                     gint   x_period,
                     gint   x_offset,
                     gint   y_len,
                     gint   y_period,
                     gint   y_offset)
{
  GimpPtrBuffer * ptr_buffer;

  ptr_buffer = g_new (GimpPtrBuffer, 1);

  gimp_buffer_init (GIMP_BUFFER (ptr_buffer), tag,
                    x_len, x_period, x_offset,
                    y_len, y_period, y_offset);

  d_init (&ptr_buffer->yuck);
  ptr_buffer->yuck.data = ptr;

  GIMP_BUFFER (ptr_buffer)->klass = (void*) &my_class;

  return ptr_buffer;
}


