static const char* op_c_source =
"/* This file is an image processing operation for GEGL                        \n"
" *                                                                            \n"
" * GEGL is free software; you can redistribute it and/or                      \n"
" * modify it under the terms of the GNU Lesser General Public                 \n"
" * License as published by the Free Software Foundation; either               \n"
" * version 3 of the License, or (at your option) any later version.           \n"
" *                                                                            \n"
" * GEGL is distributed in the hope that it will be useful,                    \n"
" * but WITHOUT ANY WARRANTY; without even the implied warranty of             \n"
" * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU          \n"
" * Lesser General Public License for more details.                            \n"
" *                                                                            \n"
" * You should have received a copy of the GNU Lesser General Public           \n"
" * License along with GEGL; if not, see <http://www.gnu.org/licenses/>.       \n"
" *                                                                            \n"
" * Copyright 2004, 2006 Øyvind Kolås <pippin@gimp.org>                      \n"
" */                                                                           \n"
"                                                                              \n"
"#include \"config.h\"                                                         \n"
"#include <glib/gi18n-lib.h>                                                   \n"
"                                                                              \n"
"                                                                              \n"
"#ifdef GEGL_PROPERTIES                                                        \n"
"                                                                              \n"
"#define DEFAULT_SCRIPT \"gegl:invert\"                                        \n"
"                                                                              \n"
"property_string (script, _(\"graph\"), DEFAULT_SCRIPT)                        \n"
"    description (_(\"The gegl graph to run\"))                                \n"
"    ui_meta     (\"multiline\", \"true\")                                     \n"
"                                                                              \n"
"#else                                                                         \n"
"                                                                              \n"
"#define GEGL_OP_COMPOSER                                                      \n"
"#define GEGL_OP_NAME     external                                             \n"
"#define GEGL_OP_C_SOURCE external.c                                           \n"
"                                                                              \n"
"#include \"gegl-op.h\"                                                        \n"
"                                                                              \n"
"static void                                                                   \n"
"prepare (GeglOperation *operation)                                            \n"
"{                                                                             \n"
"  gegl_operation_set_format (operation, \"input\",  babl_format (\"RGBA float\"));\n"
"  gegl_operation_set_format (operation, \"aux\",    babl_format (\"RGBA float\"));\n"
"  gegl_operation_set_format (operation, \"output\", babl_format (\"RGBA float\"));\n"
"}                                                                             \n"
"                                                                              \n"
"static GeglRectangle                                                          \n"
"get_bounding_box (GeglOperation *operation)                                   \n"
"{                                                                             \n"
"  GeglRectangle  result = {0,0,0,0};                                          \n"
"  GeglRectangle *in_rect = gegl_operation_source_get_bounding_box (operation, \n"
"                                                                     \"input\");\n"
"  if (!in_rect)                                                               \n"
"    return result;                                                            \n"
"                                                                              \n"
"  result = *in_rect;                                                          \n"
"  return result;                                                              \n"
"}                                                                             \n"
"                                                                              \n"
"static gboolean                                                               \n"
"process (GeglOperation       *operation,                                      \n"
"         GeglBuffer          *input,                                          \n"
"         GeglBuffer          *aux,                                            \n"
"         GeglBuffer          *output,                                         \n"
"         const GeglRectangle *result,                                         \n"
"         gint                 level)                                          \n"
"{                                                                             \n"
"  GeglProperties *o    = GEGL_PROPERTIES (operation);                         \n"
"  GeglBuffer *in_b     = NULL;                                                \n"
"  GeglBuffer *aux_b    = NULL;                                                \n"
"  GeglBuffer *output_b = NULL;                                                \n"
"                                                                              \n"
"  if (input)                                                                  \n"
"    {                                                                         \n"
"      GeglRectangle rect = {0,0,0,0};                                         \n"
"      GeglColor *blank = gegl_color_new(\"transparent\");                     \n"
"      in_b = gegl_buffer_open (\"/tmp/input.gegl\");                          \n"
"      gegl_buffer_set_extent (in_b, &rect);                                   \n"
"      gegl_buffer_set_extent (in_b, &rect);                                   \n"
"      gegl_buffer_set_color (in_b, &rect, blank);                             \n"
"      gegl_buffer_flush (in_b);                                               \n"
"    }                                                                         \n"
"                                                                              \n"
"  if (aux)                                                                    \n"
"    {                                                                         \n"
"      GeglRectangle rect = {0,0,0,0};                                         \n"
"      GeglColor *blank = gegl_color_new(\"transparent\");                     \n"
"      aux_b = gegl_buffer_open (\"/tmp/aux.gegl\");                           \n"
"      gegl_buffer_set_extent (aux_b, &rect);                                  \n"
"      gegl_buffer_set_color (aux_b, &rect, blank);                            \n"
"      gegl_buffer_flush (aux_b);                                              \n"
"    }                                                                         \n"
"                                                                              \n"
"  if (output)                                                                 \n"
"    {                                                                         \n"
"      GeglRectangle rect = {0,0,0,0};                                         \n"
"      GeglColor *blank = gegl_color_new(\"transparent\");                     \n"
"      output_b = gegl_buffer_open (\"/tmp/output.gegl\");                     \n"
"      gegl_buffer_set_extent (output_b, &rect);                               \n"
"      gegl_buffer_set_color (output_b, &rect, blank);                         \n"
"      gegl_buffer_flush (output_b);                                           \n"
"    }                                                                         \n"
"                                                                              \n"
"  //system gegl runop o->script                                               \n"
"                                                                              \n"
"  return TRUE;                                                                \n"
"}                                                                             \n"
"                                                                              \n"
"static GeglRectangle                                                          \n"
"get_required_for_output (GeglOperation        *operation,                     \n"
"                         const gchar         *input_pad,                      \n"
"                         const GeglRectangle *roi)                            \n"
"{                                                                             \n"
"  GeglRectangle result = *gegl_operation_source_get_bounding_box (operation, \"input\");\n"
"  return result;                                                              \n"
"}                                                                             \n"
"                                                                              \n"
"static void                                                                   \n"
"gegl_op_class_init (GeglOpClass *klass)                                       \n"
"{                                                                             \n"
"  GeglOperationClass         *operation_class;                                \n"
"  GeglOperationComposerClass *composer_class;                                 \n"
"                                                                              \n"
"  operation_class = GEGL_OPERATION_CLASS (klass);                             \n"
"  composer_class  = GEGL_OPERATION_COMPOSER_CLASS (klass);                    \n"
"                                                                              \n"
"  composer_class->process  = process;                                         \n"
"  operation_class->prepare = prepare;                                         \n"
"  operation_class->get_bounding_box = get_bounding_box;                       \n"
"  operation_class->get_required_for_output = get_required_for_output;         \n"
"                                                                              \n"
"  gegl_operation_class_set_keys (operation_class,                             \n"
"  \"name\"        , \"gegl:external\",                                        \n"
"  \"categories\"  , \"script:misc\",                                          \n"
"  \"description\" ,                                                           \n"
"        _(\"run a gegl operation out of process with shared buffers\"),       \n"
"        NULL);                                                                \n"
"}                                                                             \n"
"                                                                              \n"
"#endif                                                                        \n"
;
