static const char* op_c_source =
"/* This file is an image processing operation for GEGL                        \n"
" *                                                                            \n"
" * GEGL is free software; you can redistribute it and/or                      \n"
" * modify it under the terms of the GNU Lesser General Public                 \n"
" * License as published by the Free Software Foundation; either               \n"
" * version 3 of the License, or (at your option) any later version.           \n"
" *                                                                            \n"
" * GEGL is distributed in the hope that it will be useful,                    \n"
" * but WITHOUT ANY WARRANTY; without even the implied warranty of             \n"
" * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU          \n"
" * Lesser General Public License for more details.                            \n"
" *                                                                            \n"
" * You should have received a copy of the GNU Lesser General Public           \n"
" * License along with GEGL; if not, see <http://www.gnu.org/licenses/>.       \n"
" *                                                                            \n"
" * Copyright 2006 Øyvind Kolås <pippin@gimp.org>                            \n"
" * Copyright 2008 Bradley Broom <bmbroom@gmail.com>                           \n"
" */                                                                           \n"
"                                                                              \n"
"#include \"config.h\"                                                         \n"
"#include <glib/gi18n-lib.h>                                                   \n"
"                                                                              \n"
"                                                                              \n"
"#ifdef GEGL_PROPERTIES                                                        \n"
"                                                                              \n"
"property_int (pattern, _(\"Bayer pattern\"), 0)                               \n"
"   description (_(\"Bayer pattern used, 0 seems to work for some nikon files, 2 for some Fuji files.\"))\n"
"   value_range (0, 3)                                                         \n"
"                                                                              \n"
"#else                                                                         \n"
"                                                                              \n"
"#define GEGL_OP_AREA_FILTER                                                   \n"
"#define GEGL_OP_NAME demosaic_bimedian                                        \n"
"#define GEGL_OP_C_SOURCE demosaic-bimedian.c                                  \n"
"                                                                              \n"
"#include \"gegl-op.h\"                                                        \n"
"                                                                              \n"
"                                                                              \n"
"/* Returns the median of four floats. We define the median as the average of  \n"
" * the central two elements.                                                  \n"
" */                                                                           \n"
"static inline gfloat                                                          \n"
"m4 (gfloat a, gfloat b, gfloat c, gfloat d)                                   \n"
"{                                                                             \n"
"  gfloat t;                                                                   \n"
"                                                                              \n"
"  /* Sort ab */                                                               \n"
"  if (a > b)                                                                  \n"
"    {                                                                         \n"
"      t = b;                                                                  \n"
"      b = a;                                                                  \n"
"      a = t;                                                                  \n"
"    }                                                                         \n"
"  /* Sort abc */                                                              \n"
"  if (b > c)                                                                  \n"
"    {                                                                         \n"
"      t = c;                                                                  \n"
"      c = b;                                                                  \n"
"      if (a > t)                                                              \n"
"        {                                                                     \n"
"          b = a;                                                              \n"
"          a = t;                                                              \n"
"        }                                                                     \n"
"      else                                                                    \n"
"    b = t;                                                                    \n"
"    }                                                                         \n"
"  /* Return average of central two elements. */                               \n"
"  if (d >= c) /* Sorted order would be abcd */                                \n"
"    return (b + c) / 2.0;                                                     \n"
"  else if (d >= a) /* Sorted order would be either abdc or adbc */            \n"
"    return (b + d) / 2.0;                                                     \n"
"  else /* Sorted order would be dabc */                                       \n"
"    return (a + b) / 2.0;                                                     \n"
"}                                                                             \n"
"                                                                              \n"
"/* Defines to make the row/col offsets below obvious. */                      \n"
"#define ROW src_rect->width                                                   \n"
"#define COL 1                                                                 \n"
"                                                                              \n"
"/* We expect src_extent to have a one pixel border around all four sides      \n"
" * of dst_extent.                                                             \n"
" */                                                                           \n"
"static void                                                                   \n"
"demosaic (GeglProperties          *op,                                        \n"
"          GeglBuffer          *src,                                           \n"
"          const GeglRectangle *src_rect,                                      \n"
"          GeglBuffer          *dst,                                           \n"
"          const GeglRectangle *dst_rect)                                      \n"
"{                                                                             \n"
"  gint x,y;                                                                   \n"
"  gint offset, doffset;                                                       \n"
"  gfloat *src_buf;                                                            \n"
"  gfloat *dst_buf;                                                            \n"
"                                                                              \n"
"  src_buf = g_new0 (gfloat, src_rect->width * src_rect->height * 1);          \n"
"  dst_buf = g_new0 (gfloat, dst_rect->width * dst_rect->height * 3);          \n"
"                                                                              \n"
"  gegl_buffer_get (src, src_rect, 1.0, babl_format (\"Y float\"), src_buf,    \n"
"                   GEGL_AUTO_ROWSTRIDE, GEGL_ABYSS_NONE);                     \n"
"                                                                              \n"
"  offset = ROW + COL;                                                         \n"
"  doffset = 0;                                                                \n"
"  for (y=dst_rect->y; y<dst_rect->height + dst_rect->y; y++)                  \n"
"    {                                                                         \n"
"      for (x=dst_rect->x; x<dst_rect->width + dst_rect->x; x++)               \n"
"        {                                                                     \n"
"          gfloat red=0.0;                                                     \n"
"          gfloat green=0.0;                                                   \n"
"          gfloat blue=0.0;                                                    \n"
"                                                                              \n"
"          if ((y + op->pattern%2)%2==0)                                       \n"
"            {                                                                 \n"
"              if ((x+op->pattern/2)%2==1)                                     \n"
"                {                                                             \n"
"                  /* GRG                                                      \n"
"                   * BGB                                                      \n"
"                   * GRG                                                      \n"
"                   */                                                         \n"
"                  blue =(src_buf[offset-COL]+src_buf[offset+COL])/2.0;        \n"
"                  green=src_buf[offset];                                      \n"
"                  red  =(src_buf[offset-ROW]+src_buf[offset+ROW])/2.0;        \n"
"                }                                                             \n"
"              else                                                            \n"
"                {                                                             \n"
"                  /* RGR                                                      \n"
"                   * GBG                                                      \n"
"                   * RGR                                                      \n"
"                   */                                                         \n"
"                  blue =src_buf[offset];                                      \n"
"                  green=m4(src_buf[offset-ROW], src_buf[offset-COL],          \n"
"                           src_buf[offset+COL], src_buf[offset+ROW]);         \n"
"                  red  =m4(src_buf[offset-ROW-COL], src_buf[offset-ROW+COL],  \n"
"                           src_buf[offset+ROW-COL], src_buf[offset+ROW+COL]); \n"
"                }                                                             \n"
"            }                                                                 \n"
"          else                                                                \n"
"            {                                                                 \n"
"              if ((x+op->pattern/2)%2==1)                                     \n"
"                {                                                             \n"
"                  /* BGB                                                      \n"
"                   * GRG                                                      \n"
"                   * BGB                                                      \n"
"                   */                                                         \n"
"                  blue =m4(src_buf[offset-ROW-COL], src_buf[offset-ROW+COL],  \n"
"                       src_buf[offset+ROW-COL], src_buf[offset+ROW+COL]);     \n"
"                  green=m4(src_buf[offset-ROW], src_buf[offset-COL],          \n"
"                       src_buf[offset+COL], src_buf[offset+ROW]);             \n"
"                  red  =src_buf[offset];                                      \n"
"                }                                                             \n"
"              else                                                            \n"
"                {                                                             \n"
"                  /* GBG                                                      \n"
"                   * RGR                                                      \n"
"                   * GBG                                                      \n"
"                   */                                                         \n"
"                  blue =(src_buf[offset-ROW]+src_buf[offset+ROW])/2.0;        \n"
"                  green=src_buf[offset];                                      \n"
"                  red  =(src_buf[offset-COL]+src_buf[offset+COL])/2.0;        \n"
"                }                                                             \n"
"            }                                                                 \n"
"                                                                              \n"
"          dst_buf [doffset*3+0] = red;                                        \n"
"          dst_buf [doffset*3+1] = green;                                      \n"
"          dst_buf [doffset*3+2] = blue;                                       \n"
"                                                                              \n"
"          offset++;                                                           \n"
"          doffset++;                                                          \n"
"        }                                                                     \n"
"      offset+=2;                                                              \n"
"    }                                                                         \n"
"                                                                              \n"
"  gegl_buffer_set (dst, dst_rect, 0, babl_format (\"RGB float\"), dst_buf, GEGL_AUTO_ROWSTRIDE);\n"
"  g_free (src_buf);                                                           \n"
"  g_free (dst_buf);                                                           \n"
"}                                                                             \n"
"                                                                              \n"
"                                                                              \n"
"/* Specify required extra pixels around dst_extent: one pixel on every side.  \n"
" */                                                                           \n"
"static void prepare (GeglOperation *operation)                                \n"
"{                                                                             \n"
"  GeglOperationAreaFilter *area = GEGL_OPERATION_AREA_FILTER (operation);     \n"
"  area->right = area->bottom = 1;                                             \n"
"  area->left  = area->top    = 1;                                             \n"
"                                                                              \n"
"  gegl_operation_set_format (operation, \"output\", babl_format (\"RGB float\"));\n"
"}                                                                             \n"
"                                                                              \n"
"                                                                              \n"
"static gboolean                                                               \n"
"process (GeglOperation       *operation,                                      \n"
"         GeglBuffer          *input,                                          \n"
"         GeglBuffer          *output,                                         \n"
"         const GeglRectangle *result,                                         \n"
"         gint                 level)                                          \n"
"{                                                                             \n"
"  GeglProperties *o = GEGL_PROPERTIES (operation);                            \n"
"  GeglRectangle src_rect = gegl_operation_get_required_for_output (operation, \"input\", result);\n"
"                                                                              \n"
"  demosaic (o, input, &src_rect, output, result);                             \n"
"                                                                              \n"
"  return  TRUE;                                                               \n"
"}                                                                             \n"
"                                                                              \n"
"                                                                              \n"
"static void                                                                   \n"
"gegl_op_class_init (GeglOpClass *klass)                                       \n"
"{                                                                             \n"
"  GeglOperationClass       *operation_class;                                  \n"
"  GeglOperationFilterClass *filter_class;                                     \n"
"                                                                              \n"
"  operation_class = GEGL_OPERATION_CLASS (klass);                             \n"
"  filter_class    = GEGL_OPERATION_FILTER_CLASS (klass);                      \n"
"                                                                              \n"
"  filter_class->process    = process;                                         \n"
"  operation_class->prepare = prepare;                                         \n"
"                                                                              \n"
"  gegl_operation_class_set_keys (operation_class,                             \n"
"    \"name\"        , \"gegl:demosaic-bimedian\",                             \n"
"    \"title\"       , _(\"Demosaic With Bimedian Interpolation\"),            \n"
"    \"categories\"  , \"blur\",                                               \n"
"    \"description\" ,                                                         \n"
"          _(\"Performs a grayscale2color demosaicing of an image, using bimedian interpolation.\"),\n"
"          NULL);                                                              \n"
"}                                                                             \n"
"                                                                              \n"
"#endif                                                                        \n"
;
