static const char* op_c_source =
"/* This file is an image processing operation for GEGL                        \n"
" *                                                                            \n"
" * GEGL is free software; you can redistribute it and/or                      \n"
" * modify it under the terms of the GNU Lesser General Public                 \n"
" * License as published by the Free Software Foundation; either               \n"
" * version 3 of the License, or (at your option) any later version.           \n"
" *                                                                            \n"
" * GEGL is distributed in the hope that it will be useful,                    \n"
" * but WITHOUT ANY WARRANTY; without even the implied warranty of             \n"
" * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU          \n"
" * Lesser General Public License for more details.                            \n"
" *                                                                            \n"
" * You should have received a copy of the GNU Lesser General Public           \n"
" * License along with GEGL; if not, see <http://www.gnu.org/licenses/>.       \n"
" *                                                                            \n"
" * Copyright 2006 Øyvind Kolås <pippin@gimp.org>                            \n"
" * Copyright 2013 Téo Mazars   <teo.mazars@ensimag.fr>                       \n"
" */                                                                           \n"
"                                                                              \n"
"#include \"config.h\"                                                         \n"
"#include <glib/gi18n-lib.h>                                                   \n"
"#include <math.h>                                                             \n"
"                                                                              \n"
"#ifdef GEGL_PROPERTIES                                                        \n"
"                                                                              \n"
"enum_start (gegl_pixelize_norm)                                               \n"
"  enum_value (GEGL_PIXELIZE_NORM_MANHATTAN, \"diamond\", N_(\"Diamond\"))     \n"
"  enum_value (GEGL_PIXELIZE_NORM_EUCLIDEAN, \"round\",   N_(\"Round\"))       \n"
"  enum_value (GEGL_PIXELIZE_NORM_INFINITY,  \"square\",  N_(\"Square\"))      \n"
"enum_end (GeglPixelizeNorm)                                                   \n"
"                                                                              \n"
"property_enum   (norm, _(\"Shape\"),                                          \n"
"    GeglPixelizeNorm, gegl_pixelize_norm, GEGL_PIXELIZE_NORM_INFINITY)        \n"
"    description (_(\"The shape of pixels\"))                                  \n"
"                                                                              \n"
"property_int    (size_x, _(\"Block width\"), 16)                              \n"
"    description (_(\"Width of blocks in pixels\"))                            \n"
"    value_range (1, G_MAXINT)                                                 \n"
"    ui_range    (1, 2048)                                                     \n"
"    ui_gamma    (1.5)                                                         \n"
"    ui_meta     (\"unit\", \"pixel-distance\")                                \n"
"    ui_meta     (\"axis\", \"x\")                                             \n"
"                                                                              \n"
"property_int    (size_y, _(\"Block height\"), 16)                             \n"
"    description (_(\"Height of blocks in pixels\"))                           \n"
"    value_range (1, G_MAXINT)                                                 \n"
"    ui_range    (1, 2048)                                                     \n"
"    ui_gamma    (1.5)                                                         \n"
"    ui_meta     (\"unit\", \"pixel-distance\")                                \n"
"    ui_meta     (\"axis\", \"y\")                                             \n"
"                                                                              \n"
"property_double (ratio_x, _(\"Size ratio X\"), 1.0)                           \n"
"    description (_(\"Horizontal size ratio of a pixel inside each block\"))   \n"
"    value_range (0.0, 1.0)                                                    \n"
"    ui_meta     (\"axis\", \"x\")                                             \n"
"                                                                              \n"
"property_double (ratio_y, _(\"Size ratio Y\"), 1.0)                           \n"
"    description (_(\"Vertical size ratio of a pixel inside each block\"))     \n"
"    value_range (0.0, 1.0)                                                    \n"
"    ui_meta     (\"axis\", \"y\")                                             \n"
"                                                                              \n"
"property_color  (background, _(\"Background color\"), \"white\")              \n"
"    description (_(\"Color used to fill the background\"))                    \n"
"    ui_meta     (\"role\", \"color-secondary\")                               \n"
"                                                                              \n"
"#else                                                                         \n"
"                                                                              \n"
"#define GEGL_OP_AREA_FILTER                                                   \n"
"#define GEGL_OP_NAME     pixelize                                             \n"
"#define GEGL_OP_C_SOURCE pixelize.c                                           \n"
"                                                                              \n"
"#include \"gegl-op.h\"                                                        \n"
"                                                                              \n"
"#define CHUNK_SIZE           (1024)                                           \n"
"#define ALLOC_THRESHOLD_SIZE (64)                                             \n"
"#define SQR(x)               ((x)*(x))                                        \n"
"                                                                              \n"
"static void                                                                   \n"
"prepare (GeglOperation *operation)                                            \n"
"{                                                                             \n"
"  GeglProperties              *o;                                             \n"
"  GeglOperationAreaFilter *op_area;                                           \n"
"                                                                              \n"
"  op_area = GEGL_OPERATION_AREA_FILTER (operation);                           \n"
"  o       = GEGL_PROPERTIES (operation);                                      \n"
"                                                                              \n"
"  op_area->left   =                                                           \n"
"  op_area->right  = o->size_x;                                                \n"
"  op_area->top    =                                                           \n"
"  op_area->bottom = o->size_y;                                                \n"
"                                                                              \n"
"  gegl_operation_set_format (operation, \"input\",  babl_format (\"RaGaBaA float\"));\n"
"  gegl_operation_set_format (operation, \"output\", babl_format (\"RaGaBaA float\"));\n"
"}                                                                             \n"
"                                                                              \n"
"static GeglRectangle                                                          \n"
"get_bounding_box (GeglOperation *self)                                        \n"
"{                                                                             \n"
"  GeglRectangle  result = { 0, 0, 0, 0 };                                     \n"
"  GeglRectangle *in_rect;                                                     \n"
"                                                                              \n"
"  in_rect = gegl_operation_source_get_bounding_box (self, \"input\");         \n"
"  if (in_rect)                                                                \n"
"    {                                                                         \n"
"      result = *in_rect;                                                      \n"
"    }                                                                         \n"
"                                                                              \n"
"  return result;                                                              \n"
"}                                                                             \n"
"                                                                              \n"
"static void                                                                   \n"
"mean_rectangle_noalloc (GeglBuffer    *input,                                 \n"
"                        GeglRectangle *rect,                                  \n"
"                        GeglColor     *color)                                 \n"
"{                                                                             \n"
"  GeglBufferIterator *gi;                                                     \n"
"  gfloat              col[] = {0.0, 0.0, 0.0, 0.0};                           \n"
"  gint                c;                                                      \n"
"                                                                              \n"
"  gi = gegl_buffer_iterator_new (input, rect, 0, babl_format (\"RaGaBaA float\"),\n"
"                                 GEGL_ACCESS_READ, GEGL_ABYSS_CLAMP);         \n"
"                                                                              \n"
"  while (gegl_buffer_iterator_next (gi))                                      \n"
"    {                                                                         \n"
"      gint    k;                                                              \n"
"      gfloat *data = (gfloat*) gi->data[0];                                   \n"
"                                                                              \n"
"      for (k = 0; k < gi->length; k++)                                        \n"
"        {                                                                     \n"
"          for (c = 0; c < 4; c++)                                             \n"
"            col[c] += data[c];                                                \n"
"                                                                              \n"
"          data += 4;                                                          \n"
"        }                                                                     \n"
"    }                                                                         \n"
"                                                                              \n"
"  for (c = 0; c < 4; c++)                                                     \n"
"    col[c] /= rect->width * rect->height;                                     \n"
"                                                                              \n"
"  gegl_color_set_pixel (color, babl_format (\"RaGaBaA float\"), col);         \n"
"}                                                                             \n"
"                                                                              \n"
"static void                                                                   \n"
"mean_rectangle (gfloat        *input,                                         \n"
"                GeglRectangle *rect,                                          \n"
"                gint           rowstride,                                     \n"
"                gfloat        *color)                                         \n"
"{                                                                             \n"
"  gint c, x, y;                                                               \n"
"                                                                              \n"
"  for (c = 0; c < 4; c++)                                                     \n"
"    color[c] = 0;                                                             \n"
"                                                                              \n"
"  for (y = rect->y; y < rect->y + rect->height; y++)                          \n"
"    for (x = rect->x; x < rect->x + rect->width; x++)                         \n"
"      for (c = 0; c < 4; c++)                                                 \n"
"        color[c] += input [4 * (y * rowstride + x) + c];                      \n"
"                                                                              \n"
"  for (c = 0; c < 4; c++)                                                     \n"
"    color[c] /= rect->width * rect->height;                                   \n"
"}                                                                             \n"
"                                                                              \n"
"static void                                                                   \n"
"set_rectangle (gfloat          *output,                                       \n"
"               GeglRectangle   *rect,                                         \n"
"               GeglRectangle   *rect_shape,                                   \n"
"               gint             rowstride,                                    \n"
"               gfloat          *color,                                        \n"
"               GeglPixelizeNorm norm)                                         \n"
"{                                                                             \n"
"  gint c, x, y;                                                               \n"
"  gfloat center_x, center_y;                                                  \n"
"  GeglRectangle rect2;                                                        \n"
"                                                                              \n"
"  gfloat shape_area = rect_shape->width * rect_shape->height;                 \n"
"                                                                              \n"
"  center_x = rect_shape->x + rect_shape->width / 2.0f;                        \n"
"  center_y = rect_shape->y + rect_shape->height / 2.0f;                       \n"
"                                                                              \n"
"  gegl_rectangle_intersect (&rect2, rect, rect_shape);                        \n"
"                                                                              \n"
"  switch (norm)                                                               \n"
"    {                                                                         \n"
"    case (GEGL_PIXELIZE_NORM_INFINITY):                                       \n"
"                                                                              \n"
"      for (y = rect2.y; y < rect2.y + rect2.height; y++)                      \n"
"        for (x = rect2.x; x < rect2.x + rect2.width; x++)                     \n"
"          for (c = 0; c < 4; c++)                                             \n"
"            output [4 * (y * rowstride + x) + c] = color[c];                  \n"
"      break;                                                                  \n"
"                                                                              \n"
"    case (GEGL_PIXELIZE_NORM_EUCLIDEAN):                                      \n"
"                                                                              \n"
"      for (y = rect->y; y < rect->y + rect->height; y++)                      \n"
"        for (x = rect->x; x < rect->x + rect->width; x++)                     \n"
"          if (SQR ((x - center_x) / (gfloat) rect_shape->width) +             \n"
"              SQR ((y - center_y) / (gfloat) rect_shape->height) <= 1.0f)     \n"
"            for (c = 0; c < 4; c++)                                           \n"
"              output [4 * (y * rowstride + x) + c] = color[c];                \n"
"      break;                                                                  \n"
"                                                                              \n"
"    case (GEGL_PIXELIZE_NORM_MANHATTAN):                                      \n"
"                                                                              \n"
"      for (y = rect->y; y < rect->y + rect->height; y++)                      \n"
"        for (x = rect->x; x < rect->x + rect->width; x++)                     \n"
"          if (fabsf (center_x - x) * rect_shape->height +                     \n"
"              fabsf (center_y - y) * rect_shape->width < shape_area)          \n"
"            for (c = 0; c < 4; c++)                                           \n"
"              output [4 * (y * rowstride + x) + c] = color[c];                \n"
"                                                                              \n"
"      break;                                                                  \n"
"    }                                                                         \n"
"}                                                                             \n"
"                                                                              \n"
"static void                                                                   \n"
"set_rectangle_noalloc (GeglBuffer      *output,                               \n"
"                       GeglRectangle   *rect,                                 \n"
"                       GeglRectangle   *rect_shape,                           \n"
"                       GeglColor       *color,                                \n"
"                       GeglPixelizeNorm norm)                                 \n"
"{                                                                             \n"
"  if (norm == GEGL_PIXELIZE_NORM_INFINITY)                                    \n"
"    {                                                                         \n"
"      GeglRectangle rect2;                                                    \n"
"      gegl_rectangle_intersect (&rect2, rect, rect_shape);                    \n"
"      gegl_buffer_set_color (output, &rect2, color);                          \n"
"    }                                                                         \n"
"  else                                                                        \n"
"    {                                                                         \n"
"      GeglBufferIterator *gi;                                                 \n"
"      gint                c, x, y;                                            \n"
"      gfloat              col[4];                                             \n"
"      gfloat              center_x, center_y;                                 \n"
"      gfloat              shape_area = rect_shape->width * rect_shape->height;\n"
"                                                                              \n"
"      center_x = rect_shape->x + rect_shape->width / 2.0f;                    \n"
"      center_y = rect_shape->y + rect_shape->height / 2.0f;                   \n"
"                                                                              \n"
"      gegl_color_get_pixel (color, babl_format (\"RaGaBaA float\"), col);     \n"
"                                                                              \n"
"      gi = gegl_buffer_iterator_new (output, rect, 0, babl_format (\"RaGaBaA float\"),\n"
"                                     GEGL_ACCESS_WRITE, GEGL_ABYSS_CLAMP);    \n"
"                                                                              \n"
"      while (gegl_buffer_iterator_next (gi))                                  \n"
"        {                                                                     \n"
"          gfloat       *data = (gfloat*) gi->data[0];                         \n"
"          GeglRectangle roi = gi->roi[0];                                     \n"
"                                                                              \n"
"          switch (norm)                                                       \n"
"            {                                                                 \n"
"            case (GEGL_PIXELIZE_NORM_EUCLIDEAN):                              \n"
"                                                                              \n"
"              for (y = 0; y < roi.height; y++)                                \n"
"                for (x = 0; x < roi.width; x++)                               \n"
"                  if (SQR ((x + roi.x - center_x) / (gfloat) rect_shape->width) +\n"
"                      SQR ((y + roi.y - center_y) / (gfloat) rect_shape->height) <= 1.0f)\n"
"                    for (c = 0; c < 4; c++)                                   \n"
"                      data [4 * (y * roi.width + x) + c] = col[c];            \n"
"              break;                                                          \n"
"                                                                              \n"
"            case (GEGL_PIXELIZE_NORM_MANHATTAN):                              \n"
"                                                                              \n"
"              for (y = 0; y < roi.height; y++)                                \n"
"                for (x = 0; x < roi.width; x++)                               \n"
"                  if (fabsf (x + roi.x - center_x) * rect_shape->height +     \n"
"                      fabsf (y + roi.y - center_y) * rect_shape->width        \n"
"                      < shape_area)                                           \n"
"                    for (c = 0; c < 4; c++)                                   \n"
"                      data [4 * (y * roi.width + x) + c] = col[c];            \n"
"              break;                                                          \n"
"                                                                              \n"
"            case (GEGL_PIXELIZE_NORM_INFINITY):                               \n"
"              break;                                                          \n"
"            }                                                                 \n"
"        }                                                                     \n"
"    }                                                                         \n"
"}                                                                             \n"
"                                                                              \n"
"static int                                                                    \n"
"block_index (int pos,                                                         \n"
"             int size)                                                        \n"
"{                                                                             \n"
"  return pos < 0 ? ((pos + 1) / size - 1) : (pos / size);                     \n"
"}                                                                             \n"
"                                                                              \n"
"static void                                                                   \n"
"pixelize_noalloc (GeglBuffer          *input,                                 \n"
"                  GeglBuffer          *output,                                \n"
"                  const GeglRectangle *roi,                                   \n"
"                  const GeglRectangle *whole_region,                          \n"
"                  GeglProperties          *o)                                 \n"
"{                                                                             \n"
"  gint start_x = block_index (roi->x, o->size_x) * o->size_x;                 \n"
"  gint start_y = block_index (roi->y, o->size_y) * o->size_y;                 \n"
"  gint x, y;                                                                  \n"
"  gint off_shape_x, off_shape_y;                                              \n"
"                                                                              \n"
"  GeglColor *color = gegl_color_new (\"white\");                              \n"
"                                                                              \n"
"  GeglRectangle rect_shape;                                                   \n"
"                                                                              \n"
"  rect_shape.width  = ceilf (o->size_x * (gfloat)o->ratio_x);                 \n"
"  rect_shape.height = ceilf (o->size_y * (gfloat)o->ratio_y);                 \n"
"                                                                              \n"
"  off_shape_x = floorf ((o->size_x - (gfloat)o->ratio_x * o->size_x) / 2.0f); \n"
"  off_shape_y = floorf ((o->size_y - (gfloat)o->ratio_y * o->size_y) / 2.0f); \n"
"                                                                              \n"
"  for (y = start_y; y < roi->y + roi->height; y += o->size_y)                 \n"
"    for (x = start_x; x < roi->x + roi->width; x += o->size_x)                \n"
"      {                                                                       \n"
"        GeglRectangle rect = {x, y, o->size_x, o->size_y};                    \n"
"                                                                              \n"
"        gegl_rectangle_intersect (&rect, whole_region, &rect);                \n"
"                                                                              \n"
"        if (rect.width < 1 || rect.height < 1)                                \n"
"          continue;                                                           \n"
"                                                                              \n"
"        mean_rectangle_noalloc (input, &rect, color);                         \n"
"                                                                              \n"
"        gegl_rectangle_intersect (&rect, roi, &rect);                         \n"
"                                                                              \n"
"        rect_shape.x = x + off_shape_x;                                       \n"
"        rect_shape.y = y + off_shape_y;                                       \n"
"                                                                              \n"
"        set_rectangle_noalloc (output, &rect, &rect_shape, color, o->norm);   \n"
"      }                                                                       \n"
"                                                                              \n"
"  g_object_unref (color);                                                     \n"
"}                                                                             \n"
"                                                                              \n"
"static void                                                                   \n"
"pixelize (gfloat              *input,                                         \n"
"          gfloat              *output,                                        \n"
"          const GeglRectangle *roi,                                           \n"
"          const GeglRectangle *extended_roi,                                  \n"
"          const GeglRectangle *whole_region,                                  \n"
"          GeglProperties          *o)                                         \n"
"{                                                                             \n"
"  gint          start_x = block_index (roi->x, o->size_x) * o->size_x;        \n"
"  gint          start_y = block_index (roi->y, o->size_y) * o->size_y;        \n"
"  gint          x, y;                                                         \n"
"  gint          off_shape_x, off_shape_y;                                     \n"
"  gfloat        color[4];                                                     \n"
"  GeglRectangle rect_shape;                                                   \n"
"                                                                              \n"
"  rect_shape.width  = ceilf (o->size_x * (gfloat)o->ratio_x);                 \n"
"  rect_shape.height = ceilf (o->size_y * (gfloat)o->ratio_y);                 \n"
"                                                                              \n"
"  off_shape_x = floorf ((o->size_x - (gfloat)o->ratio_x * o->size_x) / 2.0f); \n"
"  off_shape_y = floorf ((o->size_y - (gfloat)o->ratio_y * o->size_y) / 2.0f); \n"
"                                                                              \n"
"  for (y = start_y; y < roi->y + roi->height; y += o->size_y)                 \n"
"    for (x = start_x; x < roi->x + roi->width; x += o->size_x)                \n"
"      {                                                                       \n"
"        GeglRectangle rect = {x, y, o->size_x, o->size_y};                    \n"
"        GeglRectangle rect2;                                                  \n"
"                                                                              \n"
"        rect_shape.x = x + off_shape_x;                                       \n"
"        rect_shape.y = y + off_shape_y;                                       \n"
"                                                                              \n"
"        gegl_rectangle_intersect (&rect, whole_region, &rect);                \n"
"                                                                              \n"
"        if (rect.width < 1 || rect.height < 1)                                \n"
"          continue;                                                           \n"
"                                                                              \n"
"        rect2.x = rect.x - extended_roi->x;                                   \n"
"        rect2.y = rect.y - extended_roi->y;                                   \n"
"        rect2.width  = rect.width;                                            \n"
"        rect2.height = rect.height;                                           \n"
"                                                                              \n"
"        mean_rectangle (input, &rect2, extended_roi->width, color);           \n"
"                                                                              \n"
"        gegl_rectangle_intersect (&rect, roi, &rect);                         \n"
"                                                                              \n"
"        rect2.x = rect.x - roi->x;                                            \n"
"        rect2.y = rect.y - roi->y;                                            \n"
"        rect2.width  = rect.width;                                            \n"
"        rect2.height = rect.height;                                           \n"
"                                                                              \n"
"        rect_shape.x -= roi->x;                                               \n"
"        rect_shape.y -= roi->y;                                               \n"
"                                                                              \n"
"        set_rectangle (output, &rect2, &rect_shape,                           \n"
"                       roi->width, color, o->norm);                           \n"
"      }                                                                       \n"
"}                                                                             \n"
"                                                                              \n"
"#include \"opencl/gegl-cl.h\"                                                 \n"
"#include \"gegl-buffer-cl-iterator.h\"                                        \n"
"                                                                              \n"
"#include \"opencl/pixelize.cl.h\"                                             \n"
"                                                                              \n"
"static GeglClRunData *cl_data = NULL;                                         \n"
"                                                                              \n"
"static gboolean                                                               \n"
"cl_pixelize (cl_mem               in_tex,                                     \n"
"             cl_mem               aux_tex,                                    \n"
"             cl_mem               out_tex,                                    \n"
"             const GeglRectangle *src_rect,                                   \n"
"             const GeglRectangle *roi,                                        \n"
"             gint                 xsize,                                      \n"
"             gint                 ysize,                                      \n"
"             gfloat               xratio,                                     \n"
"             gfloat               yratio,                                     \n"
"             gfloat               bg_color[4],                                \n"
"             gint                 norm,                                       \n"
"             GeglRectangle       *image_extent)                               \n"
"{                                                                             \n"
"  cl_int cl_err = 0;                                                          \n"
"  const size_t gbl_size[2]= {roi->width, roi->height};                        \n"
"                                                                              \n"
"  gint cx0 = block_index (roi->x, xsize);                                     \n"
"  gint cy0 = block_index (roi->y, ysize);                                     \n"
"  gint block_count_x = block_index (roi->x + roi->width  + xsize - 1, xsize) - cx0;\n"
"  gint block_count_y = block_index (roi->y + roi->height + ysize - 1, ysize) - cy0;\n"
"  cl_int4 bbox = {{ image_extent->x, image_extent->y,                         \n"
"                    image_extent->x + image_extent->width,                    \n"
"                    image_extent->y + image_extent->height }};                \n"
"                                                                              \n"
"  cl_int line_width = roi->width + 2 * xsize;                                 \n"
"                                                                              \n"
"  size_t gbl_size_tmp[2] = {block_count_x, block_count_y};                    \n"
"                                                                              \n"
"  if (!cl_data)                                                               \n"
"  {                                                                           \n"
"    const char *kernel_name[] = {\"calc_block_color\", \"kernel_pixelize\", NULL};\n"
"    cl_data = gegl_cl_compile_and_build (pixelize_cl_source, kernel_name);    \n"
"  }                                                                           \n"
"                                                                              \n"
"  if (!cl_data) return 1;                                                     \n"
"                                                                              \n"
"  cl_err = gegl_cl_set_kernel_args (cl_data->kernel[0],                       \n"
"                                    sizeof(cl_mem), (void*)&in_tex,           \n"
"                                    sizeof(cl_mem), (void*)&aux_tex,          \n"
"                                    sizeof(cl_int), (void*)&xsize,            \n"
"                                    sizeof(cl_int), (void*)&ysize,            \n"
"                                    sizeof(cl_int), (void*)&roi->x,           \n"
"                                    sizeof(cl_int), (void*)&roi->y,           \n"
"                                    sizeof(cl_int4), &bbox,                   \n"
"                                    sizeof(cl_int), (void*)&line_width,       \n"
"                                    sizeof(cl_int), (void*)&block_count_x,    \n"
"                                    NULL);                                    \n"
"  CL_CHECK;                                                                   \n"
"                                                                              \n"
"  cl_err = gegl_clEnqueueNDRangeKernel (gegl_cl_get_command_queue (),         \n"
"                                        cl_data->kernel[0], 2,                \n"
"                                        NULL, gbl_size_tmp, NULL,             \n"
"                                        0, NULL, NULL);                       \n"
"  CL_CHECK;                                                                   \n"
"                                                                              \n"
"  cl_err = gegl_cl_set_kernel_args (cl_data->kernel[1],                       \n"
"                                    sizeof(cl_mem),   (void*)&aux_tex,        \n"
"                                    sizeof(cl_mem),   (void*)&out_tex,        \n"
"                                    sizeof(cl_int),   (void*)&xsize,          \n"
"                                    sizeof(cl_int),   (void*)&ysize,          \n"
"                                    sizeof(cl_float), (void*)&xratio,         \n"
"                                    sizeof(cl_float), (void*)&yratio,         \n"
"                                    sizeof(cl_int),   (void*)&roi->x,         \n"
"                                    sizeof(cl_int),   (void*)&roi->y,         \n"
"                                    sizeof(cl_float4),(void*)bg_color,        \n"
"                                    sizeof(cl_int),   (void*)&norm,           \n"
"                                    sizeof(cl_int),   (void*)&block_count_x,  \n"
"                                    NULL);                                    \n"
"  CL_CHECK;                                                                   \n"
"                                                                              \n"
"  cl_err = gegl_clEnqueueNDRangeKernel (gegl_cl_get_command_queue (),         \n"
"                                        cl_data->kernel[1], 2,                \n"
"                                        NULL, gbl_size, NULL,                 \n"
"                                        0, NULL, NULL);                       \n"
"  CL_CHECK;                                                                   \n"
"                                                                              \n"
"  return FALSE;                                                               \n"
"                                                                              \n"
"error:                                                                        \n"
"  return TRUE;                                                                \n"
"}                                                                             \n"
"                                                                              \n"
"static gboolean                                                               \n"
"cl_process (GeglOperation       *operation,                                   \n"
"            GeglBuffer          *input,                                       \n"
"            GeglBuffer          *output,                                      \n"
"            const GeglRectangle *roi)                                         \n"
"{                                                                             \n"
"  const Babl *in_format  = babl_format (\"RaGaBaA float\");                   \n"
"  const Babl *out_format = babl_format (\"RaGaBaA float\");                   \n"
"  gint   err;                                                                 \n"
"  gfloat bg_color[4];                                                         \n"
"  gint   norm;                                                                \n"
"                                                                              \n"
"  GeglOperationAreaFilter *op_area = GEGL_OPERATION_AREA_FILTER (operation);  \n"
"  GeglProperties *o = GEGL_PROPERTIES (operation);                            \n"
"  GeglRectangle *image_extent;                                                \n"
"                                                                              \n"
"  GeglBufferClIterator *i = gegl_buffer_cl_iterator_new   (output,            \n"
"                                                           roi,               \n"
"                                                           out_format,        \n"
"                                                           GEGL_CL_BUFFER_WRITE);\n"
"                                                                              \n"
"  gint read = gegl_buffer_cl_iterator_add_2 (i,                               \n"
"                                             input,                           \n"
"                                             roi,                             \n"
"                                             in_format,                       \n"
"                                             GEGL_CL_BUFFER_READ,             \n"
"                                             op_area->left,                   \n"
"                                             op_area->right,                  \n"
"                                             op_area->top,                    \n"
"                                             op_area->bottom,                 \n"
"                                             GEGL_ABYSS_CLAMP);               \n"
"                                                                              \n"
"  gint aux = gegl_buffer_cl_iterator_add_aux (i,                              \n"
"                                              roi,                            \n"
"                                              in_format,                      \n"
"                                              op_area->left,                  \n"
"                                              op_area->right,                 \n"
"                                              op_area->top,                   \n"
"                                              op_area->bottom);               \n"
"                                                                              \n"
"                                                                              \n"
"  gegl_color_get_pixel (o->background, babl_format (\"RaGaBaA float\"), bg_color);\n"
"                                                                              \n"
"  norm = 0;                                                                   \n"
"  norm = o->norm == GEGL_PIXELIZE_NORM_EUCLIDEAN ? 1 : norm;                  \n"
"  norm = o->norm == GEGL_PIXELIZE_NORM_INFINITY  ? 2 : norm;                  \n"
"                                                                              \n"
"  image_extent = gegl_operation_source_get_bounding_box (operation, \"input\");\n"
"                                                                              \n"
"  while (gegl_buffer_cl_iterator_next (i, &err) && !err)                      \n"
"    {                                                                         \n"
"      err = cl_pixelize(i->tex[read],                                         \n"
"                        i->tex[aux],                                          \n"
"                        i->tex[0],                                            \n"
"                        &i->roi[read],                                        \n"
"                        &i->roi[0],                                           \n"
"                        o->size_x,                                            \n"
"                        o->size_y,                                            \n"
"                        o->ratio_x,                                           \n"
"                        o->ratio_y,                                           \n"
"                        bg_color,                                             \n"
"                        norm,                                                 \n"
"                        image_extent);                                        \n"
"                                                                              \n"
"      if (err)                                                                \n"
"        {                                                                     \n"
"          gegl_buffer_cl_iterator_stop (i);                                   \n"
"          break;                                                              \n"
"        }                                                                     \n"
"    }                                                                         \n"
"                                                                              \n"
"  return !err;                                                                \n"
"}                                                                             \n"
"                                                                              \n"
"static gboolean                                                               \n"
"process (GeglOperation       *operation,                                      \n"
"         GeglBuffer          *input,                                          \n"
"         GeglBuffer          *output,                                         \n"
"         const GeglRectangle *roi,                                            \n"
"         gint                 level)                                          \n"
"{                                                                             \n"
"  GeglRectangle            src_rect;                                          \n"
"  GeglRectangle           *whole_region;                                      \n"
"  GeglProperties          *o = GEGL_PROPERTIES (operation);                   \n"
"  GeglOperationAreaFilter *op_area;                                           \n"
"                                                                              \n"
"  op_area = GEGL_OPERATION_AREA_FILTER (operation);                           \n"
"                                                                              \n"
"  whole_region = gegl_operation_source_get_bounding_box (operation, \"input\");\n"
"                                                                              \n"
"  if (gegl_operation_use_opencl (operation))                                  \n"
"    if (cl_process (operation, input, output, roi))                           \n"
"      return TRUE;                                                            \n"
"                                                                              \n"
"  if (o->size_x * o->size_y < SQR (ALLOC_THRESHOLD_SIZE))                     \n"
"    {                                                                         \n"
"      gfloat  background_color[4];                                            \n"
"      gfloat *input_buf  = g_new (gfloat,                                     \n"
"                                  (CHUNK_SIZE + o->size_x * 2) *              \n"
"                                  (CHUNK_SIZE + o->size_y * 2) * 4);          \n"
"      gfloat *output_buf = g_new (gfloat, SQR (CHUNK_SIZE) * 4);              \n"
"      gint    i, j;                                                           \n"
"                                                                              \n"
"      gegl_color_get_pixel (o->background, babl_format(\"RaGaBaA float\"),    \n"
"                            background_color);                                \n"
"                                                                              \n"
"      for (j = 0; (j-1) * CHUNK_SIZE < roi->height; j++)                      \n"
"        for (i = 0; (i-1) * CHUNK_SIZE < roi->width; i++)                     \n"
"          {                                                                   \n"
"            GeglRectangle chunked_result;                                     \n"
"            GeglRectangle chunked_sizes;                                      \n"
"                                                                              \n"
"            chunked_result = *GEGL_RECTANGLE (roi->x + i * CHUNK_SIZE,        \n"
"                                              roi->y + j * CHUNK_SIZE,        \n"
"                                              CHUNK_SIZE, CHUNK_SIZE);        \n"
"                                                                              \n"
"            gegl_rectangle_intersect (&chunked_result, &chunked_result, roi); \n"
"                                                                              \n"
"            if (chunked_result.width < 1  || chunked_result.height < 1)       \n"
"              continue;                                                       \n"
"                                                                              \n"
"            src_rect = chunked_result;                                        \n"
"            src_rect.x -= op_area->left;                                      \n"
"            src_rect.y -= op_area->top;                                       \n"
"            src_rect.width += op_area->left + op_area->right;                 \n"
"            src_rect.height += op_area->top + op_area->bottom;                \n"
"                                                                              \n"
"            gegl_buffer_get (input, &src_rect, 1.0, babl_format (\"RaGaBaA float\"),\n"
"                             input_buf, GEGL_AUTO_ROWSTRIDE, GEGL_ABYSS_CLAMP);\n"
"                                                                              \n"
"            gegl_rectangle_copy (&chunked_sizes, &chunked_result);            \n"
"            chunked_sizes.x = 0;                                              \n"
"            chunked_sizes.y = 0;                                              \n"
"                                                                              \n"
"            set_rectangle (output_buf, &chunked_sizes, &chunked_sizes,        \n"
"                           chunked_result.width, background_color,            \n"
"                           GEGL_PIXELIZE_NORM_INFINITY);                      \n"
"                                                                              \n"
"            pixelize (input_buf, output_buf, &chunked_result, &src_rect,      \n"
"                      whole_region, o);                                       \n"
"                                                                              \n"
"            gegl_buffer_set (output, &chunked_result, 0,                      \n"
"                             babl_format (\"RaGaBaA float\"),                 \n"
"                             output_buf, GEGL_AUTO_ROWSTRIDE);                \n"
"          }                                                                   \n"
"                                                                              \n"
"      g_free (input_buf);                                                     \n"
"      g_free (output_buf);                                                    \n"
"    }                                                                         \n"
"  else                                                                        \n"
"    {                                                                         \n"
"      gegl_buffer_set_color (output, roi, o->background);                     \n"
"      pixelize_noalloc (input, output, roi, whole_region, o);                 \n"
"    }                                                                         \n"
"                                                                              \n"
"  return  TRUE;                                                               \n"
"}                                                                             \n"
"                                                                              \n"
"                                                                              \n"
"static void                                                                   \n"
"gegl_op_class_init (GeglOpClass *klass)                                       \n"
"{                                                                             \n"
"  GeglOperationClass       *operation_class;                                  \n"
"  GeglOperationFilterClass *filter_class;                                     \n"
"                                                                              \n"
"  operation_class = GEGL_OPERATION_CLASS (klass);                             \n"
"  filter_class    = GEGL_OPERATION_FILTER_CLASS (klass);                      \n"
"                                                                              \n"
"  operation_class->prepare          = prepare;                                \n"
"  operation_class->get_bounding_box = get_bounding_box;                       \n"
"  operation_class->opencl_support   = TRUE;                                   \n"
"                                                                              \n"
"  filter_class->process           = process;                                  \n"
"                                                                              \n"
"  gegl_operation_class_set_keys (operation_class,                             \n"
"    \"name\",               \"gegl:pixelize\",                                \n"
"    \"categories\",         \"blur:scramble\",                                \n"
"    \"position-dependent\", \"true\",                                         \n"
"    \"title\",              _(\"Pixelize\"),                                  \n"
"    \"description\", _(\"Simplify image into an array of solid-colored rectangles\"),\n"
"    NULL);                                                                    \n"
"}                                                                             \n"
"                                                                              \n"
"#endif                                                                        \n"
;
