static const char* op_c_source =
"/* mazegen code from rec.games.programmer's maze-faq:                         \n"
" * * maz.c - generate a maze                                                  \n"
" * *                                                                          \n"
" * * algorithm posted to rec.games.programmer by jallen@ic.sunysb.edu         \n"
" * * program cleaned and reorganized by mzraly@ldbvax.dnet.lotus.com          \n"
" * *                                                                          \n"
" * * don't make people pay for this, or I'll jump up and down and             \n"
" * * yell and scream and embarrass you in front of your friends...            \n"
" */                                                                           \n"
"                                                                              \n"
"/* This file is an image processing operation for GEGL                        \n"
" * GEGL is free software; you can redistribute it and/or                      \n"
" * modify it under the terms of the GNU Lesser General Public                 \n"
" * License as published by the Free Software Foundation; either               \n"
" * version 3 of the License, or (at your option) any later version.           \n"
" *                                                                            \n"
" * GEGL is distributed in the hope that it will be useful,                    \n"
" * but WITHOUT ANY WARRANTY; without even the implied warranty of             \n"
" * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU          \n"
" * Lesser General Public License for more details.                            \n"
" *                                                                            \n"
" * You should have received a copy of the GNU Lesser General Public           \n"
" * License along with GEGL; if not, see <http://www.gnu.org/licenses/>.       \n"
" *                                                                            \n"
" * Contains code originaly from GIMP 'maze' Plugin by                         \n"
" * Kevin Turner <acapnotic@users.sourceforge.net>                             \n"
" *                                                                            \n"
" * Maze ported to GEGL:                                                       \n"
" * Copyright 2015 Akash Hiremath (akash akya) <akashh246@gmail.com>           \n"
" */                                                                           \n"
"                                                                              \n"
"#include \"config.h\"                                                         \n"
"#include <glib/gi18n-lib.h>                                                   \n"
"                                                                              \n"
"#ifdef GEGL_PROPERTIES                                                        \n"
"                                                                              \n"
"enum_start (gegl_maze_algorithm)                                              \n"
"  enum_value (GEGL_MAZE_ALGORITHM_DEPTH_FIRST, \"Depth First\", N_(\"Depth first\"))\n"
"  enum_value (GEGL_MAZE_ALGORITHM_PRIM,        \"Prim\",        N_(\"Prim's algorithm\"))\n"
"enum_end (GeglMazeAlgorithm)                                                  \n"
"                                                                              \n"
"property_int    (x, _(\"Width\"), 16)                                         \n"
"    description (_(\"Horizontal width of cells pixels\"))                     \n"
"    value_range (1, G_MAXINT)                                                 \n"
"    ui_range    (1, 256)                                                      \n"
"    ui_gamma    (1.5)                                                         \n"
"    ui_meta     (\"unit\", \"pixel-distance\")                                \n"
"    ui_meta     (\"axis\", \"x\")                                             \n"
"                                                                              \n"
"property_int    (y, _(\"Height\"), 16)                                        \n"
"    description (_(\"Vertical width of cells pixels\"))                       \n"
"    value_range (1, G_MAXINT)                                                 \n"
"    ui_range    (1, 256)                                                      \n"
"    ui_gamma    (1.5)                                                         \n"
"    ui_meta     (\"unit\", \"pixel-distance\")                                \n"
"    ui_meta     (\"axis\", \"y\")                                             \n"
"                                                                              \n"
"property_enum (algorithm_type, _(\"Algorithm type\"),                         \n"
"               GeglMazeAlgorithm, gegl_maze_algorithm,                        \n"
"               GEGL_MAZE_ALGORITHM_DEPTH_FIRST)                               \n"
"  description (_(\"Maze algorithm type\"))                                    \n"
"                                                                              \n"
"property_boolean (tileable, _(\"Tileable\"), FALSE)                           \n"
"                                                                              \n"
"property_seed (seed, _(\"Random seed\"), rand)                                \n"
"                                                                              \n"
"property_color  (fg_color, _(\"Foreground Color\"), \"black\")                \n"
"    description (_(\"The foreground color\"))                                 \n"
"    ui_meta     (\"role\", \"color-primary\")                                 \n"
"                                                                              \n"
"property_color  (bg_color, _(\"Background Color\"), \"white\")                \n"
"    description (_(\"The background color\"))                                 \n"
"    ui_meta     (\"role\", \"color-secondary\")                               \n"
"                                                                              \n"
"#else                                                                         \n"
"                                                                              \n"
"#define GEGL_OP_AREA_FILTER                                                   \n"
"#define GEGL_OP_NAME     maze                                                 \n"
"#define GEGL_OP_C_SOURCE maze.c                                               \n"
"                                                                              \n"
"#include \"gegl-op.h\"                                                        \n"
"#include <stdio.h>                                                            \n"
"#include <math.h>                                                             \n"
"                                                                              \n"
"#define CELL_UP(POS) ((POS) < (x*2) ? -1 : (POS) - x - x)                     \n"
"#define CELL_DOWN(POS) ((POS) >= x*(y-2) ? -1 : (POS) + x + x)                \n"
"#define CELL_LEFT(POS) (((POS) % x) <= 1 ? -1 : (POS) - 2)                    \n"
"#define CELL_RIGHT(POS) (((POS) % x) >= (x - 2) ? -1 : (POS) + 2)             \n"
"                                                                              \n"
"#define WALL_UP(POS) ((POS) - x)                                              \n"
"#define WALL_DOWN(POS) ((POS) + x)                                            \n"
"#define WALL_LEFT(POS) ((POS) - 1)                                            \n"
"#define WALL_RIGHT(POS) ((POS) + 1)                                           \n"
"                                                                              \n"
"#define CELL_UP_TILEABLE(POS) ((POS) < (x*2) ? x*(y-2)+(POS) : (POS) - x - x) \n"
"#define CELL_DOWN_TILEABLE(POS) ((POS) >= x*(y-2) ? (POS) - x*(y-2) : (POS) + x + x)\n"
"#define CELL_LEFT_TILEABLE(POS) (((POS) % x) <= 1 ? (POS) + x - 2 : (POS) - 2)\n"
"#define CELL_RIGHT_TILEABLE(POS) (((POS) % x) >= (x - 2) ? (POS) + 2 - x : (POS) + 2)\n"
"                                                                              \n"
"#define WALL_UP_TILEABLE(POS) ((POS) < x ? x*(y-1)+(POS) : (POS) - x)         \n"
"#define WALL_DOWN_TILEABLE(POS) ((POS) + x)                                   \n"
"#define WALL_LEFT_TILEABLE(POS) (((POS) % x) == 0 ? (POS) + x - 1 : (POS) - 1)\n"
"#define WALL_RIGHT_TILEABLE(POS) ((POS) + 1)                                  \n"
"                                                                              \n"
"                                                                              \n"
"enum CellTypes                                                                \n"
"{                                                                             \n"
"  OUT,                                                                        \n"
"  IN,                                                                         \n"
"  FRONTIER                                                                    \n"
"};                                                                            \n"
"                                                                              \n"
"static GRand *gr;                                                             \n"
"static int    multiple = 57;  /* Must be a prime number */                    \n"
"static int    offset = 1;                                                     \n"
"                                                                              \n"
"static void                                                                   \n"
"depth_first (gint    pos,                                                     \n"
"	     guchar *maz,                                                            \n"
"	     gint    x,                                                              \n"
"	     gint    y,                                                              \n"
"	     gint    rnd)                                                            \n"
"{                                                                             \n"
"  gchar d, i;                                                                 \n"
"  gint  c = 0;                                                                \n"
"  gint  j = 1;                                                                \n"
"                                                                              \n"
"  maz[pos] = IN;                                                              \n"
"                                                                              \n"
"  /* If there is a wall two rows above us, bit 1 is 1. */                     \n"
"  while ((d= (pos <= (x * 2) ? 0 : (maz[pos - x - x ] ? 0 : 1))               \n"
"          /* If there is a wall two rows below us, bit 2 is 1. */             \n"
"          | (pos >= x * (y - 2) ? 0 : (maz[pos + x + x] ? 0 : 2))             \n"
"          /* If there is a wall two columns to the right, bit 3 is 1. */      \n"
"          | (pos % x == x - 2 ? 0 : (maz[pos + 2] ? 0 : 4))                   \n"
"          /* If there is a wall two colums to the left, bit 4 is 1.  */       \n"
"          | ((pos % x == 1 ) ? 0 : (maz[pos-2] ? 0 : 8))))                    \n"
"    {                                                                         \n"
"      do                                                                      \n"
"        {                                                                     \n"
"          rnd = (rnd * multiple + offset);                                    \n"
"          i = 3 & (rnd / d);                                                  \n"
"          if (++c > 100)                                                      \n"
"            {                                                                 \n"
"              i = 99;                                                         \n"
"              break;                                                          \n"
"            }                                                                 \n"
"        }                                                                     \n"
"      while (!(d & (1 << i)));                                                \n"
"                                                                              \n"
"      switch (i)                                                              \n"
"        {                                                                     \n"
"        case 0:                                                               \n"
"          j = -x;                                                             \n"
"          break;                                                              \n"
"        case 1:                                                               \n"
"          j = x;                                                              \n"
"          break;                                                              \n"
"        case 2:                                                               \n"
"          j = 1;                                                              \n"
"          break;                                                              \n"
"        case 3:                                                               \n"
"          j = -1;                                                             \n"
"          break;                                                              \n"
"        case 99:                                                              \n"
"          return;                                                             \n"
"          break;                                                              \n"
"        default:                                                              \n"
"          g_warning (\"maze: mazegen: Going in unknown direction.\\n\"        \n"
"                     \"i: %d, d: %d, seed: %d, mw: %d, mh: %d, mult: %d, offset: %d\\n\",\n"
"		     i, d, rnd, x, y, multiple, offset);                                    \n"
"          break;                                                              \n"
"        }                                                                     \n"
"                                                                              \n"
"      maz[pos + j] = IN;                                                      \n"
"      depth_first (pos + 2 * j, maz, x, y, rnd);                              \n"
"    }                                                                         \n"
"}                                                                             \n"
"                                                                              \n"
"static void                                                                   \n"
"depth_first_tileable (gint    pos,                                            \n"
"		      guchar *maz,                                                          \n"
"		      gint    x,                                                            \n"
"		      gint    y,                                                            \n"
"		      gint    rnd)                                                          \n"
"{                                                                             \n"
"  gchar d, i;                                                                 \n"
"  gint  c = 0;                                                                \n"
"  gint  npos = 2;                                                             \n"
"                                                                              \n"
"  /* Punch a hole here...  */                                                 \n"
"  maz[pos] = IN;                                                              \n"
"                                                                              \n"
"  /* If there is a wall two rows above us, bit 1 is 1. */                     \n"
"  while ((d= (maz[CELL_UP_TILEABLE(pos)] ? 0 : 1)                             \n"
"	  /* If there is a wall two rows below us, bit 2 is 1. */                    \n"
"	  | (maz[CELL_DOWN_TILEABLE(pos)] ? 0 : 2)                                   \n"
"	  /* If there is a wall two columns to the right, bit 3 is 1. */             \n"
"	  | (maz[CELL_RIGHT_TILEABLE(pos)] ? 0 : 4)                                  \n"
"	  /* If there is a wall two colums to the left, bit 4 is 1.  */              \n"
"	  | (maz[CELL_LEFT_TILEABLE(pos)] ? 0 : 8)))                                 \n"
"    {                                                                         \n"
"      do                                                                      \n"
"        {                                                                     \n"
"          rnd = (rnd * multiple + offset);                                    \n"
"          i = 3 & (rnd / d);                                                  \n"
"          if (++c > 100)                                                      \n"
"            {                                                                 \n"
"              i = 99;                                                         \n"
"              break;                                                          \n"
"	    }                                                                        \n"
"	}                                                                            \n"
"      while (!(d & (1 << i)));                                                \n"
"                                                                              \n"
"      switch (i)                                                              \n"
"        {                                                                     \n"
"	case 0:                                                                      \n"
"          maz[WALL_UP_TILEABLE (pos)] = IN;                                   \n"
"          npos = CELL_UP_TILEABLE (pos);                                      \n"
"          break;                                                              \n"
"	case 1:                                                                      \n"
"          maz[WALL_DOWN_TILEABLE (pos)] = IN;                                 \n"
"          npos = CELL_DOWN_TILEABLE (pos);                                    \n"
"          break;                                                              \n"
"	case 2:                                                                      \n"
"          maz[WALL_RIGHT_TILEABLE (pos)] = IN;                                \n"
"          npos = CELL_RIGHT_TILEABLE (pos);                                   \n"
"          break;                                                              \n"
"	case 3:                                                                      \n"
"          maz[WALL_LEFT_TILEABLE (pos)] = IN;                                 \n"
"          npos = CELL_LEFT_TILEABLE (pos);                                    \n"
"          break;                                                              \n"
"	case 99:                                                                     \n"
"          return;                                                             \n"
"          break;                                                              \n"
"	default:                                                                     \n"
"          g_warning (\"maze: mazegen_tileable: Going in unknown direction.\\n\"\n"
"                     \"i: %d, d: %d, seed: %d, mw: %d, mh: %d, mult: %d, offset: %d\\n\",\n"
"                     i, d, rnd, x, y, multiple, offset);                      \n"
"          break;                                                              \n"
"	}                                                                            \n"
"                                                                              \n"
"      depth_first_tileable (npos, maz, x, y, rnd);                            \n"
"    }                                                                         \n"
"}                                                                             \n"
"                                                                              \n"
"static void                                                                   \n"
"prim (gint    pos,                                                            \n"
"      guchar *maz,                                                            \n"
"      guint   x,                                                              \n"
"      guint   y,                                                              \n"
"      int     seed)                                                           \n"
"{                                                                             \n"
"  GSList *front_cells = NULL;                                                 \n"
"  guint   current;                                                            \n"
"  gint    up, down, left, right;                                              \n"
"  char    d, i;                                                               \n"
"  guint   c = 0;                                                              \n"
"  gint    rnd = seed;                                                         \n"
"                                                                              \n"
"  g_rand_set_seed (gr, rnd);                                                  \n"
"                                                                              \n"
"  maz[pos] = IN;                                                              \n"
"                                                                              \n"
"  up    = CELL_UP (pos);                                                      \n"
"  down  = CELL_DOWN (pos);                                                    \n"
"  left  = CELL_LEFT (pos);                                                    \n"
"  right = CELL_RIGHT (pos);                                                   \n"
"                                                                              \n"
"  if (up >= 0)                                                                \n"
"    {                                                                         \n"
"      maz[up] = FRONTIER;                                                     \n"
"      front_cells = g_slist_append (front_cells, GINT_TO_POINTER (up));       \n"
"    }                                                                         \n"
"                                                                              \n"
"  if (down >= 0)                                                              \n"
"    {                                                                         \n"
"      maz[down] = FRONTIER;                                                   \n"
"      front_cells = g_slist_append (front_cells, GINT_TO_POINTER (down));     \n"
"    }                                                                         \n"
"                                                                              \n"
"  if (left >= 0)                                                              \n"
"    {                                                                         \n"
"      maz[left] = FRONTIER;                                                   \n"
"      front_cells = g_slist_append (front_cells, GINT_TO_POINTER (left));     \n"
"    }                                                                         \n"
"                                                                              \n"
"  if (right >= 0)                                                             \n"
"    {                                                                         \n"
"      maz[right] = FRONTIER;                                                  \n"
"      front_cells = g_slist_append (front_cells, GINT_TO_POINTER (right));    \n"
"    }                                                                         \n"
"                                                                              \n"
"  while (g_slist_length (front_cells) > 0)                                    \n"
"    {                                                                         \n"
"      current = g_rand_int_range (gr, 0, g_slist_length (front_cells));       \n"
"      pos = GPOINTER_TO_INT (g_slist_nth (front_cells, current)->data);       \n"
"                                                                              \n"
"      front_cells = g_slist_remove (front_cells, GINT_TO_POINTER (pos));      \n"
"      maz[pos] = IN;                                                          \n"
"                                                                              \n"
"      up    = CELL_UP (pos);                                                  \n"
"      down  = CELL_DOWN (pos);                                                \n"
"      left  = CELL_LEFT (pos);                                                \n"
"      right = CELL_RIGHT (pos);                                               \n"
"                                                                              \n"
"      d = 0;                                                                  \n"
"      if (up >= 0)                                                            \n"
"        {                                                                     \n"
"          switch (maz[up])                                                    \n"
"            {                                                                 \n"
"            case OUT:                                                         \n"
"              maz[up] = FRONTIER;                                             \n"
"              front_cells = g_slist_prepend (front_cells,                     \n"
"                                             GINT_TO_POINTER (up));           \n"
"              break;                                                          \n"
"                                                                              \n"
"            case IN:                                                          \n"
"              d = 1;                                                          \n"
"              break;                                                          \n"
"                                                                              \n"
"            default:                                                          \n"
"              break;                                                          \n"
"            }                                                                 \n"
"        }                                                                     \n"
"                                                                              \n"
"      if (down >= 0)                                                          \n"
"        {                                                                     \n"
"          switch (maz[down])                                                  \n"
"            {                                                                 \n"
"            case OUT:                                                         \n"
"              maz[down] = FRONTIER;                                           \n"
"              front_cells = g_slist_prepend (front_cells,                     \n"
"                                             GINT_TO_POINTER (down));         \n"
"              break;                                                          \n"
"                                                                              \n"
"            case IN:                                                          \n"
"              d = d | 2;                                                      \n"
"              break;                                                          \n"
"                                                                              \n"
"            default:                                                          \n"
"              break;                                                          \n"
"            }                                                                 \n"
"        }                                                                     \n"
"                                                                              \n"
"      if (left >= 0)                                                          \n"
"        {                                                                     \n"
"          switch (maz[left])                                                  \n"
"            {                                                                 \n"
"            case OUT:                                                         \n"
"              maz[left] = FRONTIER;                                           \n"
"              front_cells = g_slist_prepend (front_cells,                     \n"
"                                             GINT_TO_POINTER (left));         \n"
"              break;                                                          \n"
"                                                                              \n"
"            case IN:                                                          \n"
"              d = d | 4;                                                      \n"
"              break;                                                          \n"
"                                                                              \n"
"            default:                                                          \n"
"              break;                                                          \n"
"            }                                                                 \n"
"        }                                                                     \n"
"                                                                              \n"
"      if (right >= 0)                                                         \n"
"        {                                                                     \n"
"          switch (maz[right])                                                 \n"
"            {                                                                 \n"
"            case OUT:                                                         \n"
"              maz[right] = FRONTIER;                                          \n"
"              front_cells = g_slist_prepend (front_cells,                     \n"
"                                             GINT_TO_POINTER (right));        \n"
"              break;                                                          \n"
"                                                                              \n"
"            case IN:                                                          \n"
"              d = d | 8;                                                      \n"
"              break;                                                          \n"
"                                                                              \n"
"            default:                                                          \n"
"              break;                                                          \n"
"            }                                                                 \n"
"        }                                                                     \n"
"                                                                              \n"
"      if (! d)                                                                \n"
"        {                                                                     \n"
"          g_warning (\"maze: prim: Lack of neighbors.\\n\"                    \n"
"                     \"seed: %d, mw: %d, mh: %d, mult: %d, offset: %d\\n\",   \n"
"                     seed, x, y, multiple, offset);                           \n"
"          break;                                                              \n"
"        }                                                                     \n"
"                                                                              \n"
"      c = 0;                                                                  \n"
"      do                                                                      \n"
"        {                                                                     \n"
"          rnd = (rnd * multiple + offset);                                    \n"
"          i = 3 & (rnd / d);                                                  \n"
"          if (++c > 100)                                                      \n"
"            {                                                                 \n"
"              i = 99;                                                         \n"
"              break;                                                          \n"
"            }                                                                 \n"
"        }                                                                     \n"
"      while (!(d & (1 << i)));                                                \n"
"                                                                              \n"
"      switch (i)                                                              \n"
"        {                                                                     \n"
"        case 0:                                                               \n"
"          maz[WALL_UP (pos)] = IN;                                            \n"
"          break;                                                              \n"
"        case 1:                                                               \n"
"          maz[WALL_DOWN (pos)] = IN;                                          \n"
"          break;                                                              \n"
"        case 2:                                                               \n"
"          maz[WALL_LEFT (pos)] = IN;                                          \n"
"          break;                                                              \n"
"        case 3:                                                               \n"
"          maz[WALL_RIGHT (pos)] = IN;                                         \n"
"          break;                                                              \n"
"        case 99:                                                              \n"
"          break;                                                              \n"
"        default:                                                              \n"
"          g_warning (\"maze: prim: Going in unknown direction.\\n\"           \n"
"                     \"i: %d, d: %d, seed: %d, mw: %d, mh: %d, mult: %d, offset: %d\\n\",\n"
"                     i, d, seed, x, y, multiple, offset);                     \n"
"        }                                                                     \n"
"    }                                                                         \n"
"                                                                              \n"
"  g_slist_free (front_cells);                                                 \n"
"}                                                                             \n"
"                                                                              \n"
"static void                                                                   \n"
"prim_tileable (guchar *maz,                                                   \n"
"               guint   x,                                                     \n"
"               guint   y,                                                     \n"
"	       gint     seed)                                                        \n"
"{                                                                             \n"
"  GSList *front_cells = NULL;                                                 \n"
"  guint   current, pos;                                                       \n"
"  guint   up, down, left, right;                                              \n"
"  char    d, i;                                                               \n"
"  guint   c = 0;                                                              \n"
"  gint    rnd = seed;                                                         \n"
"                                                                              \n"
"  g_rand_set_seed (gr, rnd);                                                  \n"
"                                                                              \n"
"  pos = x * 2 * g_rand_int_range (gr, 0, y / 2) +                             \n"
"            2 * g_rand_int_range (gr, 0, x / 2);                              \n"
"                                                                              \n"
"  maz[pos] = IN;                                                              \n"
"                                                                              \n"
"  up    = CELL_UP_TILEABLE (pos);                                             \n"
"  down  = CELL_DOWN_TILEABLE (pos);                                           \n"
"  left  = CELL_LEFT_TILEABLE (pos);                                           \n"
"  right = CELL_RIGHT_TILEABLE (pos);                                          \n"
"                                                                              \n"
"  maz[up] = maz[down] = maz[left] = maz[right] = FRONTIER;                    \n"
"                                                                              \n"
"  front_cells = g_slist_append (front_cells, GINT_TO_POINTER (up));           \n"
"  front_cells = g_slist_append (front_cells, GINT_TO_POINTER (down));         \n"
"  front_cells = g_slist_append (front_cells, GINT_TO_POINTER (left));         \n"
"  front_cells = g_slist_append (front_cells, GINT_TO_POINTER (right));        \n"
"                                                                              \n"
"  while (g_slist_length (front_cells) > 0)                                    \n"
"    {                                                                         \n"
"      current = g_rand_int_range (gr, 0, g_slist_length (front_cells));       \n"
"      pos = GPOINTER_TO_UINT (g_slist_nth (front_cells, current)->data);      \n"
"                                                                              \n"
"      front_cells = g_slist_remove (front_cells, GUINT_TO_POINTER (pos));     \n"
"      maz[pos] = IN;                                                          \n"
"                                                                              \n"
"      up    = CELL_UP_TILEABLE (pos);                                         \n"
"      down  = CELL_DOWN_TILEABLE (pos);                                       \n"
"      left  = CELL_LEFT_TILEABLE (pos);                                       \n"
"      right = CELL_RIGHT_TILEABLE (pos);                                      \n"
"                                                                              \n"
"      d = 0;                                                                  \n"
"      switch (maz[up])                                                        \n"
"        {                                                                     \n"
"        case OUT:                                                             \n"
"          maz[up] = FRONTIER;                                                 \n"
"          front_cells = g_slist_append (front_cells, GINT_TO_POINTER (up));   \n"
"          break;                                                              \n"
"                                                                              \n"
"        case IN:                                                              \n"
"          d = 1;                                                              \n"
"          break;                                                              \n"
"                                                                              \n"
"        default:                                                              \n"
"          break;                                                              \n"
"        }                                                                     \n"
"                                                                              \n"
"      switch (maz[down])                                                      \n"
"        {                                                                     \n"
"        case OUT:                                                             \n"
"          maz[down] = FRONTIER;                                               \n"
"          front_cells = g_slist_append (front_cells, GINT_TO_POINTER (down)); \n"
"          break;                                                              \n"
"                                                                              \n"
"        case IN:                                                              \n"
"          d = d | 2;                                                          \n"
"          break;                                                              \n"
"                                                                              \n"
"        default:                                                              \n"
"          break;                                                              \n"
"        }                                                                     \n"
"                                                                              \n"
"      switch (maz[left])                                                      \n"
"        {                                                                     \n"
"        case OUT:                                                             \n"
"          maz[left] = FRONTIER;                                               \n"
"          front_cells = g_slist_append (front_cells, GINT_TO_POINTER (left)); \n"
"          break;                                                              \n"
"                                                                              \n"
"        case IN:                                                              \n"
"          d = d | 4;                                                          \n"
"          break;                                                              \n"
"                                                                              \n"
"        default:                                                              \n"
"          break;                                                              \n"
"        }                                                                     \n"
"                                                                              \n"
"      switch (maz[right])                                                     \n"
"        {                                                                     \n"
"        case OUT:                                                             \n"
"          maz[right] = FRONTIER;                                              \n"
"          front_cells = g_slist_append (front_cells, GINT_TO_POINTER (right));\n"
"          break;                                                              \n"
"                                                                              \n"
"        case IN:                                                              \n"
"          d = d | 8;                                                          \n"
"          break;                                                              \n"
"                                                                              \n"
"        default:                                                              \n"
"          break;                                                              \n"
"        }                                                                     \n"
"                                                                              \n"
"      if (! d)                                                                \n"
"        {                                                                     \n"
"          g_warning (\"maze: prim's tileable: Lack of neighbors.\\n\"         \n"
"                     \"seed: %d, mw: %d, mh: %d, mult: %d, offset: %d\\n\",   \n"
"                     seed, x, y,multiple,offset);                             \n"
"          break;                                                              \n"
"        }                                                                     \n"
"                                                                              \n"
"      c = 0;                                                                  \n"
"      do                                                                      \n"
"        {                                                                     \n"
"          rnd = (rnd *multiple +offset);                                      \n"
"          i = 3 & (rnd / d);                                                  \n"
"          if (++c > 100)                                                      \n"
"            {                                                                 \n"
"              i = 99;                                                         \n"
"              break;                                                          \n"
"            }                                                                 \n"
"        }                                                                     \n"
"      while (!(d & (1 << i)));                                                \n"
"                                                                              \n"
"      switch (i)                                                              \n"
"        {                                                                     \n"
"        case 0:                                                               \n"
"          maz[WALL_UP_TILEABLE (pos)] = IN;                                   \n"
"          break;                                                              \n"
"        case 1:                                                               \n"
"          maz[WALL_DOWN_TILEABLE (pos)] = IN;                                 \n"
"          break;                                                              \n"
"        case 2:                                                               \n"
"          maz[WALL_LEFT_TILEABLE (pos)] = IN;                                 \n"
"          break;                                                              \n"
"        case 3:                                                               \n"
"          maz[WALL_RIGHT_TILEABLE (pos)] = IN;                                \n"
"          break;                                                              \n"
"        case 99:                                                              \n"
"          break;                                                              \n"
"        default:                                                              \n"
"          g_warning (\"maze: prim's tileable: Going in unknown direction.\\n\"\n"
"                     \"i: %d, d: %d, seed: %d, mw: %d, mh: %d, mult: %d, offset: %d\\n\",\n"
"                     i, d, seed, x, y, multiple, offset);                     \n"
"        }                                                                     \n"
"    }                                                                         \n"
"                                                                              \n"
"  g_slist_free (front_cells);                                                 \n"
"}                                                                             \n"
"                                                                              \n"
"static gboolean                                                               \n"
"process (GeglOperation       *operation,                                      \n"
"         GeglBuffer          *input,                                          \n"
"         GeglBuffer          *output,                                         \n"
"         const GeglRectangle *result,                                         \n"
"         gint                 level)                                          \n"
"{                                                                             \n"
"  GeglProperties *o = GEGL_PROPERTIES (operation);                            \n"
"  GeglRectangle   tile;                                                       \n"
"  GeglRectangle  *in_extent;                                                  \n"
"  guchar         *maz = NULL;                                                 \n"
"  gint            mw;                                                         \n"
"  gint            mh;                                                         \n"
"  gint            i;                                                          \n"
"  gint            j;                                                          \n"
"  gfloat          offset_x;                                                   \n"
"  gfloat          offset_y;                                                   \n"
"                                                                              \n"
"                                                                              \n"
"  in_extent = gegl_operation_source_get_bounding_box (operation, \"input\");  \n"
"                                                                              \n"
"  gegl_buffer_set_color (output, in_extent, o->bg_color);                     \n"
"                                                                              \n"
"  tile.height = o->y;                                                         \n"
"  tile.width  = o->x;                                                         \n"
"                                                                              \n"
"  mh = in_extent->height / tile.height;                                       \n"
"  mw = in_extent->width  / tile.width;                                        \n"
"                                                                              \n"
"  if (mh > 2 && mw > 2)                                                       \n"
"    {                                                                         \n"
"      /* allocate memory for maze and set to zero */                          \n"
"                                                                              \n"
"      maz = (guchar *) g_new0 (guchar, mw * mh);                              \n"
"                                                                              \n"
"      gr = g_rand_new ();                                                     \n"
"                                                                              \n"
"      if (o->tileable)                                                        \n"
"	{                                                                            \n"
"	  /* Tileable mazes must be even. */                                         \n"
"	  mw -= (mw & 1);                                                            \n"
"	  mh -= (mh & 1);                                                            \n"
"	}                                                                            \n"
"      else                                                                    \n"
"	{                                                                            \n"
"	  mw -= !(mw & 1); /* Normal mazes doesn't work with even-sized mazes. */    \n"
"	  mh -= !(mh & 1); /* Note I don't warn the user about this... */            \n"
"	}                                                                            \n"
"                                                                              \n"
"      /* starting offset */                                                   \n"
"      offset_x = (in_extent->width  - (mw * tile.width))  / 2.0f;             \n"
"      offset_y = (in_extent->height - (mh * tile.height)) / 2.0f;             \n"
"                                                                              \n"
"      switch (o->algorithm_type)                                              \n"
"	{                                                                            \n"
"	case GEGL_MAZE_ALGORITHM_DEPTH_FIRST:                                        \n"
"	  if (o->tileable)                                                           \n"
"	    {                                                                        \n"
"	      depth_first_tileable (0, maz, mw, mh, o->seed);                        \n"
"	    }                                                                        \n"
"	  else                                                                       \n"
"	    {                                                                        \n"
"	      depth_first (mw+1, maz, mw, mh, o->seed);                              \n"
"	    }                                                                        \n"
"	  break;                                                                     \n"
"                                                                              \n"
"	case GEGL_MAZE_ALGORITHM_PRIM:                                               \n"
"	  if (o->tileable)                                                           \n"
"	    {                                                                        \n"
"	      prim_tileable (maz, mw, mh, o->seed);                                  \n"
"	    }                                                                        \n"
"	  else                                                                       \n"
"	    {                                                                        \n"
"	      prim (mw+1, maz, mw, mh, o->seed);                                     \n"
"	    }                                                                        \n"
"          break;                                                              \n"
"	}                                                                            \n"
"                                                                              \n"
"      /* start drawing */                                                     \n"
"      tile.x = 0;                                                             \n"
"      tile.y = 0;                                                             \n"
"      gegl_buffer_set_color (output, &tile,                                   \n"
"			     (maz[0]) ? o->fg_color : o->bg_color);                                \n"
"                                                                              \n"
"      /* first row */                                                         \n"
"      for (tile.y = 0, tile.x = offset_x, j = 0;                              \n"
"	   tile.x < in_extent->width;                                                \n"
"	   j++, tile.x += tile.width)                                                \n"
"	{                                                                            \n"
"	  gegl_buffer_set_color (output, &tile,                                      \n"
"				 (maz[j]) ? o->fg_color : o->bg_color);                                   \n"
"	}                                                                            \n"
"                                                                              \n"
"      /* first column  */                                                     \n"
"      for (tile.x = 0, tile.y = offset_y, i = 0;                              \n"
"	   tile.y < in_extent->height;                                               \n"
"	   i += mw, tile.y += tile.width)                                            \n"
"	{                                                                            \n"
"	  gegl_buffer_set_color (output, &tile,                                      \n"
"				 (maz[i]) ? o->fg_color : o->bg_color);                                   \n"
"	}                                                                            \n"
"                                                                              \n"
"      /* Everything else */                                                   \n"
"      for(tile.y = offset_y, i = 0;                                           \n"
"	  tile.y < in_extent->height;                                                \n"
"	  i += mw, tile.y += tile.height)                                            \n"
"	{                                                                            \n"
"	  for (tile.x = offset_x, j = 0;                                             \n"
"	       tile.x < in_extent->width;                                            \n"
"	       j++, tile.x += tile.width)                                            \n"
"	    {                                                                        \n"
"	      gegl_buffer_set_color (output, &tile,                                  \n"
"				     (maz[j+i]) ? o->fg_color : o->bg_color);                             \n"
"	    }                                                                        \n"
"	}                                                                            \n"
"                                                                              \n"
"      if (! o->tileable)                                                      \n"
"	{                                                                            \n"
"          /* last row */                                                      \n"
"	  for (tile.y = in_extent->height-tile.height, tile.x = offset_x;            \n"
"	       tile.x < in_extent->width;                                            \n"
"	       tile.x += tile.width)                                                 \n"
"	    {                                                                        \n"
"	      gegl_buffer_set_color (output, &tile, o->bg_color);                    \n"
"	    }                                                                        \n"
"	}                                                                            \n"
"                                                                              \n"
"      g_rand_free (gr);                                                       \n"
"                                                                              \n"
"      g_free (maz);                                                           \n"
"    }                                                                         \n"
"                                                                              \n"
"  return TRUE;                                                                \n"
"}                                                                             \n"
"                                                                              \n"
"static void                                                                   \n"
"gegl_op_class_init (GeglOpClass *klass)                                       \n"
"{                                                                             \n"
"  GeglOperationClass       *operation_class;                                  \n"
"  GeglOperationFilterClass *filter_class;                                     \n"
"                                                                              \n"
"  operation_class = GEGL_OPERATION_CLASS (klass);                             \n"
"  filter_class    = GEGL_OPERATION_FILTER_CLASS (klass);                      \n"
"                                                                              \n"
"  operation_class->threaded = FALSE;                                          \n"
"  filter_class->process     = process;                                        \n"
"                                                                              \n"
"  gegl_operation_class_set_keys (operation_class,                             \n"
"				 \"name\",               \"gegl:maze\",                                   \n"
"				 \"title\",               _(\"Maze\"),                                    \n"
"				 \"categories\",         \"render\",                                      \n"
"                                 \"license\",            \"GPL3+\",           \n"
"				 \"position-dependent\", \"true\",                                        \n"
"				 \"description\",        _(\"Draw a labyrinth\"),                         \n"
"				 NULL);                                                                   \n"
"}                                                                             \n"
"                                                                              \n"
"#endif                                                                        \n"
;
