/* source/druid.c: extra code to support druids

Moria copyright:
	Copyright (c) 1989-92 James E. Wilson, Robert A. Koeneke

This entire file:
	Copyright (c) 1993 Michael R. Marcelais

	This software may be copied and distributed for educational, research, and
	not for profit purposes provided that this copyright and statement are
	included in all such copies. */

#include "config.h"
#ifdef DRUID
#include "constant.h"
#include "types.h"
#include "externs.h"

#if defined(LINT_ARGS)
void swap32(int32u *, int32u *);
void swap8(int8u *, int8u *);
void swap_stats(int);
#endif

void swap32(a,b)
register int32u *a;
register int32u *b;
{
	register int32u t;
	t=*a;
	*a=*b;
	*b=t;
}

void swap8(a,b)
register int8u *a;
register int8u *b;
{
   register int8u t;
   t=*a;
   *a=*b;
   *b=t;
}

void swap_stats(realm)
register int realm;
{
	register int i;

	if ((druid_swapped && (realm == MAGE)) ||
		 (!druid_swapped && (realm == PRIEST)))
		{
		  swap32(&druid_learned,   &spell_learned);
		  swap32(&druid_worked,    &spell_worked);
		  swap32(&druid_forgotten, &spell_forgotten);
		  swap8 (&druid_new_spells, &py.flags.new_spells);
		  for(i=0;i<32;i++)
                     swap8(&(druid_order[i]), &(spell_order[i]));
		}
	if (realm == MAGE)
	  druid_swapped = FALSE;
	else
	  druid_swapped = TRUE;
}

#endif
