/* Greys */
#define Colour_White            0
#define Colour_Light_Grey_High  1
#define Colour_Light_Grey_Low   2
#define Colour_Medium_Grey_High 3
#define Colour_Medium_Grey_Low  4
#define Colour_Dark_Grey_High   5
#define Colour_Dark_Grey_Low    6
#define Colour_Black            7

/* Standard */
#define Colour_Light_Red        8
#define Colour_Light_Green      9
#define Colour_Light_Yellow     10
#define Colour_Light_Blue       11
#define Colour_Light_Orange     12
#define Colour_Light_Purple     13
#define Colour_Red              14
#define Colour_Green            15
#define Colour_Yellow           16
#define Colour_Blue             17
#define Colour_Orange           18
#define Colour_Purple           19   /* Now a Major Motion Picture */
#define Colour_Dark_Red         20
#define Colour_Dark_Green       21
#define Colour_Dark_Yellow      22
#define Colour_Dark_Blue        23
#define Colour_Dark_Orange      24
#define Colour_Dark_Purple      25
#define Colour_Cream            26

/* Amulets */
#define Colour_Amber            27
#define Colour_Driftwood        28
#define Colour_Coral            29
#define Colour_Agate            30
#define Colour_Ivory            31
#define Colour_Obsidian         32
#define Colour_Bone             33
#define Colour_Brass            34
#define Colour_Bronze           35
#define Colour_Pewter           36
#define Colour_Tortoise_Shell   37

/* Metals */
#define Colour_Aluminum         38
#define Colour_Cast_Iron        39
#define Colour_Chromium         40
#define Colour_Copper           41
#define Colour_Gold             42
#define Colour_Iron             43
#define Colour_Magnesium        44
#define Colour_Molybdenum       45
#define Colour_Nickel           46
#define Colour_Rusty            47
#define Colour_Silver           48
#define Colour_Steel            49
#define Colour_Tin              50
#define Colour_Titanium         51
#define Colour_Tungsten         52
#define Colour_Zirconium        53
#define Colour_Zinc             54

/* Monsters */
#define Colour_Dirt             55
#define Colour_Leperous         56
#define Colour_Flesh            57  /* Well mine is. Your milage may vary */
#define Colour_Disenchanting    58
#define Colour_Rotting          59
#define Colour_Clay             60
#define Colour_Stone            61
#define Colour_Fire             62
#define Colour_Water            63
#define Colour_Earth            64
#define Colour_Air              65
#define Colour_Frost            66
#define Colour_Lightning        67
#define Colour_Gelatinous       68
#define Colour_Umber            69
#define Colour_Crystal          70

/* Mushrooms */
#define Colour_Brown            71
#define Colour_Ecru             72
#define Colour_Furry            73
#define Colour_Plaid            74  /* A very tricky colour to define as RGB */
#define Colour_Slimy            75
#define Colour_Tan              76
#define Colour_Wooden           77
#define Colour_Wrinkled         78  /* Perhaps try some rayshade textures? */

/* Potions */
#define Colour_Icky_Green       79
#define Colour_Light_Brown      80
#define Colour_Clear            81
#define Colour_Azure            82
#define Colour_Bubbling         83  /* Animation needed here... */
#define Colour_Chartreuse       84
#define Colour_Cloudy           85
#define Colour_Crimson          86
#define Colour_Cyan             87
#define Colour_Hazy             88
#define Colour_Indigo           89
#define Colour_Magenta          90
#define Colour_Metallic_Blue    91
#define Colour_Metallic_Red     92
#define Colour_Metallic_Green   93
#define Colour_Metallic_Purple  94
#define Colour_Misty            95
#define Colour_Pink             96
#define Colour_Puce             97
#define Colour_Smoky            98
#define Colour_Tangerine        99
#define Colour_Violet           100
#define Colour_Vermilion        101

/* Rocks */
#define Colour_Alexandrite      102  /* Emerald Green or Deep Red?? */
#define Colour_Amethyst         103
#define Colour_Aquamarine       104
#define Colour_Azurite          105
#define Colour_Beryl            106  /* Emerald or Aquamarine or another? */
#define Colour_Bloodstone       107  /* Green with flecks of Red */
#define Colour_Calcite          108
#define Colour_Carnelian        109
#define Colour_Corundum         110  /* Any colour it feels like */
#define Colour_Diamond          111
#define Colour_Emerald          112
#define Colour_Fluorite         113  /* CaF{sub}2 */
#define Colour_Garnet           114
#define Colour_Granite          115
#define Colour_Jade             116
#define Colour_Jasper           117  /* Carrot */
#define Colour_Lapis_Lazuli     118
#define Colour_Magma            119
#define Colour_Malachite        120  /* Me! */
#define Colour_Marble           121
#define Colour_Moonstone        122
#define Colour_Onyx             123
#define Colour_Pearl            124
#define Colour_Quartz           125
#define Colour_Quartzite        126
#define Colour_Rhodonite        127
#define Colour_Ruby             128  /* Both of these are in fact types of */
#define Colour_Sapphire         129  /* Corundum (above)...                */
#define Colour_Tiger_Eye        130
#define Colour_Topaz            131
#define Colour_Turquoise        132  /* Did I mention Im doing this by hand? */
#define Colour_Zircon           133

/* Treasures */
#define Colour_Food             134  /* Pizza-coloured? */
#define Colour_Slime            135
#define Colour_Leather          136
#define Colour_Cord             137  /* This is getting like a Nabakov book */
#define Colour_Paper            138
#define Colour_Old_Parchment    139  /* "The circus across the park is      */
#define Colour_Apple            140  /* too loud."                          */
#define Colour_Oil              141
#define Colour_Magic_Light      142
#define Colour_Mud              143
#define Colour_Acid             144
#define Colour_Pottery          145
#define Colour_Wine             146  /* Villa Maria '86 */
#define Colour_Mithril          147

/* Woods */
#define Colour_Aspen            148
#define Colour_Balsa            149
#define Colour_Banyan           150
#define Colour_Birch            151
#define Colour_Cedar            152
#define Colour_Cottonwood       153
#define Colour_Cypress          154
#define Colour_Dogwood          155
#define Colour_Elm              156
#define Colour_Eucalyptus       157
#define Colour_Hemlock          158
#define Colour_Hickory          159
#define Colour_Ironwood         160
#define Colour_Locust           161
#define Colour_Mahogany         162
#define Colour_Maple            163
#define Colour_Mulberry         164
#define Colour_Oak              165
#define Colour_Pine             166
#define Colour_Redwood          167
#define Colour_Rosewood         168
#define Colour_Spruce           169
#define Colour_Sycamore         170
#define Colour_Teak             171
#define Colour_Walnut           172

/* Spells/Magic/Breath */
#define Colour_Magic_Missile    173
#define Colour_Poison_Gas       174
#define Colour_Holy_Orb         175

/* defined as a special case... */
#define Colour_Opal             255
#define Colour_Multi_Hued       255
#define Colour_Iridescent       255
#define Colour_Random           255

/* Defined as previous values */
#define Colour_Input                Colour_Light_Blue
#define Colour_OK                   Colour_Green
#define Colour_Ok                   Colour_OK /* I just know I'll do this... */
#define Colour_Attention            Colour_Yellow
#define Colour_Warning              Colour_Red
#define Colour_Plain_Text           Colour_White
#define Colour_Title                Colour_White
#define Colour_Sub_Title            Colour_Light_Grey_High
#define Colour_Field                Colour_White
#define Colour_Non_Applicable       Colour_Dark_Grey_High
#define Colour_Information          Colour_Blue

#define Colour_Damned               Colour_Red
#define Colour_Magik                Colour_Green
#define Colour_Empty                Colour_Dark_Grey_High

#define Colour_Inventory_Book       Colour_Old_Parchment
#define Colour_Inventory_Food       Colour_Food
#define Colour_Inventory_Potion     Colour_Light_Blue
#define Colour_Inventory_Scroll     Colour_Paper
#define Colour_Inventory_Wand       Colour_Iron
#define Colour_Inventory_Staff      Colour_Wooden
#define Colour_Inventory_Ring       Colour_Gold
#define Colour_Inventory_Amulet     Colour_Cream
#define Colour_Inventory_Armour     Colour_Iron
#define Colour_Inventory_Weapon     Colour_Steel
#define Colour_Inventory_Misc       Colour_Light_Grey_High
#define Colour_Inventory_Enchanted  Colour_White

#define Colour_Wall                 Colour_Medium_Grey_High
#define Colour_Floor                Colour_Medium_Grey_High

#define Colour_Default              Colour_White


/* These are the types used by the colour routines */

typedef struct
  {
  unsigned char L; /* the local value for the particular colour */
  unsigned char R; /* The full RGB specification for the colour */
  unsigned char G; /* for those players with 24 bit displays    */
  unsigned char B; /* (lucky so-and-so's...)                    */
  }
colour_entry;

typedef unsigned char attr;


/* Prototypes */


void setattr(attr);
void printattr(char, attr, int, int);
attr loc_colour(int, int);

