#ifndef __TRIGGERS_H__
#define __TRIGGERS_H__
/******************************************************************************
* File: triggers.h                                                            *
* Constants, structures and prototypes for the trigger system.                *
*                                                                             *
* This file is Copyright (C) 1997 by Joachim Pileborg, all rights reserved.   *
******************************************************************************/

/*****************************************************************************/
/* constants */

/* Time scripts are called every 10 second */
#define PULSE_TIME_TRIGGER (10 RL_SEC)

/* Trigger types (used by trigger_data.type) */
#define TT_TIME    1
#define TT_ENTER   2
#define TT_LEAVE   3
#define TT_TELL    4
#define TT_ASK     5
#define TT_SAY     6
#define TT_GIVE    7

#ifndef MAX_TRIGGER
#define MAX_TRIGGER 7
#endif

/* Trigger type flags, used by the room/object/char that has triggers */
#define TTF_TIME   (1 << TT_TIME)
#define TTF_ENTER  (1 << TT_ENTER)
#define TTF_LEAVE  (1 << TT_LEAVE)
#define TTF_TELL   (1 << TT_TELL)
#define TTF_ASK    (1 << TT_ASK)
#define TTF_SAY    (1 << TT_SAY)
#define TTF_GIVE   (1 << TT_GIVE)

/* Trigger sources (used by trigger_data.source) */
#define TS_ROOM    0
#define TS_OBJECT  1
#define TS_MOBILE  2
#define TS_PLAYER  3
#define TS_CHAR    4
#define TS_TEXT    5

/*****************************************************************************/

#define MOB_TRIGGERS(m)   ((m)->mob_specials.triggers)
#define OBJ_TRIGGERS(o)   ((o)->triggers)
#define ROOM_TRIGGERS(r)  (world[(r)].triggers)

/*****************************************************************************/
/* structures */

struct trigger_data
{
	int               type;   /* type of this trigger */
	int               source; /* what is this trigger set on? */
	char             *script; /* name of the script this trigger calls */
	char             *func;   /* name of the function this trigger calls */
	void             *me;     /* the mob/room/item this trigger is set on */

	struct trigger_data *list;  /* pointer to the head of the list  */
	struct trigger_data *next;  /* link to next trigger on the list */
};

struct user_data
{
	void *data;
	int   type;  /* one of the TS_* constants */

	struct user_data *next;
};

/*****************************************************************************/
/* prototypes */

void trigger_time(void);
int  trigger_enter_leave(struct char_data *who, int room, int type);
void trigger_remove(register struct trigger_data *t);
struct trigger_data *trigger_create(int type, char *script, void *ob,
																		int source);
void trigger_add(struct trigger_data *t, struct trigger_data **l);

void _lua_pushuserdata(void *data, int type);

/*****************************************************************************/

#endif /* __TRIGGERS_H__ */
