.\" $Id: luac.man,v 1.3 1996/03/28 20:24:55 lhf Exp $
.TH LUAC 1 "12 March 1996"
.SH NAME
luac \- Lua compiler
.SH SYNOPSIS
.B luac
[
.B \-dlpv
]
[
.B \-o 
.I outputfile
]
.I sourcefile
\&.\|.\|.
.SH DESCRIPTION
.B luac
is the Lua compiler. 
It translates programs written in the Lua programming language
into binary files that can be loaded and executed with
.B lua_dofile
in C or
.B dofile
in Lua.

.BR luac
produces a single output file containing the bytecode
for all named source files.
By default,
the output file is named
.BR luac.out ,
but you can change this with the
.B \-o 
option.

You can use "-" to indicate stdin as a source file.
.SH OPTIONS
.LP
.TP 1i
.B \-d
turns debugging on.
.TP
.B \-l
produces a listing of the compiled bytecode for Lua's virtual machine.
.TP
.B \-p
parses sources files but does not generate any output file.
.TP
.B \-v
prints version information.
.TP
.BI \-o " outputfile"
Name the output file
.IR output ,
instead of the default
.BR luac.out .
The output file cannot be a source file.
.SH FILES
.PD 0
.TP 20
.B luac.out
default output file
.PD
.SH "SEE ALSO"
.BR lua (1)
.LP
.IR "Reference Manual of the Programming Language Lua"
.SH DIAGNOSTICS
Error messages should be self explanatory.
.SH BUGS
Inherits any bugs from Lua,
but Lua has no bugs...
.SH AUTHORS
W. Celes, R. Ierusalimschy & L. H. de Figueiredo
(lua@icad.puc-rio.br)
