#include "zoracle.h"

#define LOGTOFILE

ZOracle::ZOracle(ZOracleConnection* p):ZSQL::ZSQL(p)
{
Initialize();
Connection=p;
}

void ZOracle::Initialize()
{
NumRows=0;
NumCols=0;
FirstSQL=1;
for(int i=0;i<MAX_COLS;i++)
	Row[i].buf=NULL;
Connection->Log("ZOracle::Initialize successful....");
}


int ZOracle::Open(char* sql)
{
char temp[100];
int i;
int ind;

ZSQL::Open(sql);
Connection->Log("ZOracle: Opening Oracle transaction...");
Connection->Log("Opening cursor...");
if(oopen(&Cursor,Connection->GetDB(),NULL,-1,-1,NULL,-1))	{
	Connection->Log("Can't open cursor!");
	return 0;
	}
Connection->Log("Sending query: ",sql);
if(oparse(&Cursor,sql,-1,0,2))	{
	if(Cursor.rc !=942)	{
		Connection->Log("Error parsing SQL: ",sql);
		return 0;
		}
	}
for(i=0;i<MAX_COLS;i++)	{
	cbuf1[i]=sizeof(cbuf[i]);
	if(odescr(&Cursor,i+1,&dbsize[i],&dbtype[i],&cbuf[i],
	          &cbuf1[i],&dsize[i],&prec[i],&scale[i],&nullok[i])) {
		if(Cursor.rc==1007)	
			break;	
		sprintf(temp,"Error getting description for fld[%d]...",i);
		Connection->Log(temp);
		PrintError();
		return 0;
		}
	if(Row[i].buf!=(char*)NULL)
		free(Row[i].buf);
	if((Row[i].buf=(char*)malloc(dsize[i]))==NULL)	{
		i--;
		break;
		}
	if(odefin(&Cursor,i+1,Row[i].buf,dsize[i],SQLT_STR,-1,&Row[i].ind,
		0,-1,-1,&Row[i].retl,&Row[i].retc))	{
		sprintf(temp,"Error binding row column %d",i);
		Connection->Log(temp);
		PrintError();
		return 0;
		}
	}
NumCols=i;
oexfet(&Cursor,1,0,0);
Connection->Log("Transaction opened successfully...");
return 1;
}

void ZOracle::Close()
{
if(IsOpen)	{
	IsOpen=0;
	Connection->Log("Closing Oracle transaction...");
	}
for(int i=0;i<MAX_COLS;i++)	
	if(Row[i].buf!=NULL)
		free(Row[i].buf);
}

int ZOracle::GetSQLData(int col,char* res,int len)
{
if(col>=NumCols)
	return 0;
strncpy(res,Row[col].buf,len);
Connection->Log("Got data: ",Row[col].buf);
return 1;
}

int ZOracle::GetSQLData(int col,int* res)
{
if(col>=NumCols)
	return 0;
*res=atoi(Row[col].buf);

}
int ZOracle::GetSQLData(int col,float* res)
{
if(col>=NumCols)
	return 0;
*res=atof(Row[col].buf);
return 1;
}  

int ZOracle::GetNextRecord()
{
if(FirstSQL)	{
	FirstSQL=0;
	return 1;
	}
if(ofetch(&Cursor))	{
	Connection->Log("Error fetching ...");
	PrintError();
	return 0;
	}
return 1;
}

int ZOracle::GetFieldInfo(int pos ,ZField* fld)
{
if(pos>=GetNumCols())
	return 0;
fld->Length=dsize[pos];
strncpy(fld->Name,cbuf[pos],cbuf1[pos]);
fld->Name[cbuf1[pos]]=0;
return 1;
}

int ZOracle::GetNumCols()
{
return NumCols;
}

int ZOracle::GetNumRows()
{
return NumRows;
} 

void ZOracle::PrintError(int where)
{
char temp[1024];
oerhms(Connection->GetDB(),Cursor.rc,temp,(int)sizeof(temp));
if(where==TO_LOG)
	Connection->Log("ZOracle: ",temp);
else
	printf("ZOracle: %s\n",temp);
}

//***********************************************************************
//			ZDBConnection definitions
//***********************************************************************
/*
For Oracle, the ConnectInfo os the DB identifier, i.e.
the SID. User and pass are needed!
*/

ZOracleConnection::ZOracleConnection(char *ConnectInfo,char* User,char* Pass):ZDBConnection::ZDBConnection(ConnectInfo,User,Pass)
{
char temp[100];
Log("Connecting to Oracle...");
putenv("ORACLE_HOME=/Oracle/home/dba/oracle/product/7.0.16");
sprintf(temp,"ORACLE_SID=%s",ConnectInfo);
putenv(temp);
if (orlon(&lda, hda, User, -1, Pass, -1, -1))	{
	Log("Cannot connect to ",ConnectInfo);
	return;
	}
Log("Connected to Oracle Data Source");
IsConnected=1;
}

ZOracleConnection::~ZOracleConnection()
{
Log("Shutting down connection...");
ShutDown();
}

//****************************************************************************
//				ShutDown
//****************************************************************************
void ZOracleConnection::ShutDown()
{
if(!IsConnected)
	return;
Initialize();
}

//****************************************************************************
//				Initialize
//****************************************************************************
void ZOracleConnection::Initialize()
{
ZDBConnection::Initialize();
ConnectInfo[0]='\0';
User[0]='\0';
Password[0]='\0';
ErrorMessage[0]='\0';
IsConnected=0;
Type=ORACLE_DB;
}

