/* msql_cgi is a prototype API for a 'objected-oriented html'. the idea
   is that the html lets the user customize his/her query and the API
   converts it to a standard select statement and then processes it. this
   API will work with any form html that is designed to pass a sort field,
   then an order by value. in future versions i expect to add the host address
   as a selectable field, for distributed data, and the database and table 
   names as hidden fields.  may 11, 95, sol katz, skatz@blm.gov
*/
#include "msql.h"
#include <stdio.h>
#include <stdlib.h>

#define MAX_ENTRIES 10000

typedef struct {
    char *name;
    char *val;
} entry;

char *makeword(char *line, char stop);
char *fmakeword(FILE *f, char stop, int *len);
char x2c(char *what);
void unescape_url(char *url);
void plustospace(char *str);

main(int argc, char *argv[]) 
{
char      hostname[100]; 
char      database[100]; 
char      table   [100]; 
entry     entries[MAX_ENTRIES];
register  int x,m=0;
int       clint;
char      string [70];
char     *clchar;
int       first=1;
int       NumFlds;
char      temp[100];
char      sqlstr[1000];
int       i,j,k;
char      data[2048];
FILE     *log;
int       select;
int       sock;
int       rows;
int       fkount;
m_field   *one_field;
m_row     one_row;
m_result  *result;
m_result  *fields;
char	  typeName[10];
m_field	  *curField;
m_field   *schema[100];
int       quote = ' ';
/*void      *calloc();*/

printf("Content-type: text/html\n\n");
printf("<title>Test of mSQL2_cgi Interface</title>\n");
printf("<head>Test of mSQL2_cgi Interface</head><br>\n");

if(!strcmp(getenv("REQUEST_METHOD"),"POST")) 
    {
      if(strcmp(getenv("CONTENT_TYPE"),"application/x-www-form-urlencoded"))
      {
        printf("This program can only be used to decode form results. \n");
        exit(1);
      }
      clint = atoi(getenv("CONTENT_LENGTH"));

      for(x=0;clint && (!feof(stdin));x++) 
      {
          m=x;
          entries[x].val = fmakeword(stdin,'&',&clint);
          plustospace(entries[x].val);
          unescape_url(entries[x].val);
          entries[x].name = makeword(entries[x].val,'=');
      }
    }
    else if(!strcmp(getenv("REQUEST_METHOD"),"GET")) 
    {
      clchar = getenv("QUERY_STRING");
      if(clchar == NULL) 
      {
        printf("No query information to decode.\n");
        exit(1);
      }
      for(x=0;clchar[0] != '\0';x++) 
      {
        m=x;
        getword(entries[x].val,clchar,'&');
        plustospace(entries[x].val);
        unescape_url(entries[x].val);
        getword(entries[x].name,entries[x].val,'=');
      }
    }
    else
    {
       printf("This program should be referenced with a METHOD of GET or POST.\n");
       printf("If you don't understand this, see this ");
       printf("<A HREF=\"http://www.ncsa.uiuc.edu/SDG/Software/Mosaic/Docs/fill-out-forms/overview.html\">forms overview</A>.%c",10);
       exit(1);
    }
strcpy (hostname, entries[3].val);
strcpy(database , entries[4].val);
strcpy(table    , entries[5].val);
/*
printf("0 %s 1 %s 2 %s<br> ",entries[0].name, entries[1].name,entries[2].name);
    printf ("0 title    = %s<br>\n", entries[0].val);
    printf ("1 asc/dec  = %s<br>\n", entries[1].val);
    printf ("2 and/or   = %s<br>\n", entries[2].val);
    printf ("3 hostname = %s<br>\n", entries[3].val);
    printf ("4 database = %s<br>\n", entries[4].val);
    printf ("5 table    = %s<br>\n", entries[5].val);
    printf ("6 format   = %s<br>\n", entries[6].val);
    printf ("7          = %s<br>\n", entries[7].val);
    printf ("8          = %s<br>\n", entries[8].val);
    printf ("9          = %s<br>\n", entries[9].val);
    printf ("10         = %s<br>\n", entries[10].val);
*/
    sock = msqlConnect(hostname);
    if( sock == -1 )   
       {
       system ( "date >> msqld.log ");
       log = fopen("msqld.log","a");
       if (log )
       {
         fprintf(log,"Error Connecting to Sock:\n %s\n",msqlErrMsg );
         fclose(log);
     }
     printf("Error Connecting to Sock:<BR> %s<HR>\n",msqlErrMsg );
     return 0; 
     }


select = msqlSelectDB(sock,database);
if (select < 0 )
	{
	printf("\n");
        printf("Error Connecting to %s: %s<HR>\n",database,msqlErrMsg );
	exit(1);
	}
/*
** Get the list of attributes
*/

fields = msqlListFields(sock,table);
if (!fields)
{
  printf("ERROR : Couldn't find %s in %s!\n\n",	table, database);
  exit(1);
}

NumFlds = msqlNumFields(fields);
/*printf("%d is numflds<br> ",NumFlds);*/
if( fields < 0  )   
     {
     printf("Error Selecting %s fields: %s<HR>",table,msqlErrMsg );
     exit(1);
     }

i = 0;

while((curField = msqlFetchField(fields)))
{
        schema[i]=curField;
        i++; 
/*	printf("%-15.15s | ",curField->name);*/
	switch(curField->type)
	{
	case INT_TYPE:
		strcpy(typeName,"int");
		break;
	case CHAR_TYPE:
		strcpy(typeName,"char");
		break;
	case REAL_TYPE:
		strcpy(typeName,"real");
		break;
		default:
	strcpy(typeName,"Unknown");
		break;
	}
/*
	printf("%-8.8s |",typeName);
	printf(" %-6d |",curField->type);
	printf(" %-6d |",curField->length);
	printf(" %-8.8s |", IS_NOT_NULL(curField->flags)?"Y":"N");
	printf(" %-3.3s |<br>\n", IS_PRI_KEY(curField->flags)?"Y":"N");
*/
}

    sprintf(sqlstr,"SELECT * FROM ");
    strcat(sqlstr, table);
    for(x=8; x <= m; x+=3)
      if (strlen( entries[x+1].val ) != 0)
        if ( first )  /* no connector in front of first */
          {
          sprintf(temp," Where ");
          strcat(sqlstr,temp);
          if ( strcmp( entries[x].val,"like") )
	   {
            for ( i = 0; i < NumFlds; i++)
            {
/*               printf ("%s %s <br>\n", entries[x-1].val, schema[i]->name);*/
               if ( !strcmp ( entries[x-1].val, schema[i]->name) )
		 {
/*                    printf ("there is a match <br>\n");*/
                    if ( schema[i]->type == CHAR_TYPE) quote = '\'';
                    break;
 	  	 }
            }
            sprintf(temp,"%s %s %c%s%c ",
               entries[x-1].val, entries[x].val,quote,entries[x+1].val,quote);
            quote = ' ';
           }
          else
            sprintf(temp,"%s %s %s ",
               entries[x-1].val, entries[x].val,regex(entries[x+1].val));
          strcat(sqlstr,temp);
          first = 0;
 	  }
        else 
          {
          if ( strcmp( entries[x].val,"like") )
	    {
            for ( i = 0; i < NumFlds; i++)
              {
/*               printf ("%s %s <br>\n", entries[x-1].val, schema[i]->name);*/
               if ( !strcmp ( entries[x-1].val, schema[i]->name) )
		 {
/*                    printf ("there is a match <br>\n");*/
                    if ( schema[i]->type == CHAR_TYPE) quote = '\'';
                    break;
 	  	 }
              }
            sprintf(temp,"%s %s %s %c%s%c ",
              entries[2].val,entries[x-1].val, entries[x].val,
              quote,entries[x+1].val,quote);
            quote = ' ';
          }
          else
            sprintf(temp,"%s %s %s %s ",
               entries[2].val,
               entries[x-1].val, entries[x].val,regex(entries[x+1].val));
          strcat(sqlstr,temp);
          }
    /* now write sort and order info */
    sprintf(temp," %s by %s %s ",entries[1].name, entries[0].val,entries[1].val);
    strcat(sqlstr,temp);
    sprintf(temp,"  \n  ");        /* final \n for sql statement */
    strcat(sqlstr,temp);
printf("<hr> \n%s <hr>\n",sqlstr);

/*printf("<br>\n");*/
/*printf("</pre> \n");*/
/* the following is for analyzing types of sql errors*/
system ( "date >> msqld.log ");
log = fopen("msqld.log","a");
if (log )
{ 
  strcpy(string,getenv("REMOTE_ADDR"));
  fprintf(log,"%s ", string );
  strcpy(string,getenv("REMOTE_HOST"));
  fprintf(log,"%s \n", string );
  fprintf(log ,"%s \n ",sqlstr);
  fclose(log);
}

if(msqlQuery(sock,sqlstr) < 0)
     {
     printf("<hr>Query failed (%s)<hr>\n",msqlErrMsg);
     printf("<b>If \'Unknown field error\' then you failed to put \' single quotes \' around Character Strings.<b> \n"); 
     printf ("<p><ul>Click on <a href=/gis/msql/dbs5help.html>HELP </a> for help</ul> <br>\n");
     exit(1);
     }

result = msqlStoreResult();
rows   = msqlNumRows(result);
printf("%d record(s) were found <hr> \n", rows );
if (rows > 1000 )
{
   printf("<p>This prototype is limited to return a maximum of 1000 records<br>\n");
   rows = 1000;
}

if ( !strcmp( entries[6].val,"VERTICAL") )
  {
  for (i = 0 ; i < rows ; i++)
     {
     one_row = msqlFetchRow(result);
     for (j = 0; j < NumFlds ; j++ )
       printf("%s: %s<br>\n ",schema[j]->name , one_row[j]);
     printf("<hr> \n");
     }     
}
else 
  {
/* print column name  header line if horizontal */
  for (j = 0; j < NumFlds ; j++ )
       printf("%s | ",schema[j]->name );
  printf("<hr> \n");
  for (i = 0 ; i < rows ; i++)
     {
     one_row = msqlFetchRow(result);
     for (j = 0; j < NumFlds -1 ; j++ )
       printf("%s, ", one_row[j]);
     printf("%s <br> \n",one_row[NumFlds-1]);
     }
   }     
printf("<p><hr>\n");
  
msqlFreeResult(result);
msqlFreeResult(fields);

}
