/* Maarten Boekhold (boekhold@cindy.et.tudelft.nl) oktober 1995 */

#include <sys/types.h>

/*
 * routine to change little endian long to host long (assumes long is 4 bytes)
 */
long get_long(u_char *p)
{
        long res;

        res = *p++;
        res += ((*p++)<<8);
        res += ((*p++)<<16);
        res += ((*p++)<<24);

        return res;
}

void put_long(u_char *p, long val)
{
        *p++ = val & 0xff;
        *p++ = (val >> 8) & 0xff;
        *p++ = (val >> 16) & 0xff;
        *p++ = (val >> 24) & 0xff;
}

/*
 * routine to change little endian short to host short (assumes short
 * is 2 bytes)
 */
short get_short(u_char *p)
{
        short res;

        res = *p++;
        res += ((*p++)<<8);

        return res;
}

void put_short(u_char *p, short val)
{
        *p++ = val & 0xff;
        *p++ = (val >> 8) & 0xff;
}
