#include <stdio.h>
#include "cgic.h"
#include "msql.h"
#include "dbadmin.h"
#include <string.h>

int       state;
int       action;
int       numfields;
int       delitemnum;
char      *fieldnames;
int       sock;
char      newdb[MAX_DATABASENAME_LEN];
char      field[MAX_FIELDS][MAX_FIELDNAME_LEN];
char      type[MAX_FIELDS][5];
char      lengthStr[MAX_FIELDS][5];
char      notnul[MAX_FIELDS][2];
char      key[MAX_FIELDS][2];
char      textquery[MAX_TEXTQUERY_LEN];
char      searchby[MAX_FIELDNAME_LEN];
char      searchdata[MAX_ITEM_LEN];
char      operation[5];
m_result  *res;
m_result  *res2;
m_row     cur;
m_field   *curField;
int       dberror;
char      dbname[MAX_DATABASENAME_LEN];
char      tablename[MAX_TABLENAME_LEN];
char      qbuf[MAX_TEXTQUERY_LEN];
cgiFormResultType cgiError;

void unimplementedOption(void);
void giveDebugInfo(void);
int  getState(void);
void giveTitle(void);
void connectDB(void);
void doTitlePage(void);
void doAdminSelection(void);
void showDatabases(int);
void addDatabase(void);
void doAddDB(void);
void doRemoveDB(void);
void removeDatabase(void);
void modifyStructure(void);
void doModifyStructure(void);
void showCurrentTables(void);
void giveAddTable(void);
void doRemoveTable(void);
void doAddTable(void);
void addTableNow(void);
void getFields(void);
void viewUpdateInfo(void);
void doTableSelection(void);
void giveSearch(void);
void giveInsert(void);
void showSelectData(void);
void giveBackQueryPage(void);

void showTables(void);
void giveCannedSelect(void);
void giveTextQuery(void);
void doTextQuery(void);
void doCannedQuery(void);
void addCannedQuery(void);
void giveInsertForm(void);
void searchRecords(void);
void giveSearchForm(void);
void returnSearch(void);
void doSearchQuery(void);
void showSelectDeleteData(void);
void deleteSearchItem(void);
void performDelete(void);

void giveInitialActions(void);
void giveButtonBar(void);

int cgiMain() {
	cgiHeaderContentType("text/html");
	fprintf(cgiOut, "<HTML><HEAD>\n");
	fprintf(cgiOut, "<TITLE>James Harrell's Database Administration Toolkit</TITLE></HEAD>\n");
	fprintf(cgiOut, "<BODY>\n");
 
        switch (getState())
        {
          case 0: doTitlePage();
                  break;

          case 1: doAdminSelection();
                  break;

          case 2: doAddDB();                    /* ADD DATABASE */
                  break;

          case 3: doRemoveDB();                 /* REMOVE DATABASE */
                  break;
 
          case 4: doModifyStructure();          /* MODIFY TABLES */
                  break;

          case 5: doRemoveTable();              /* DELETE TABLE */
                  break;

          case 6: doAddTable();                 /* ADD TABLE FORM */
                  break;

          case 7: addTableNow();                /* REALLY ADD TABLE */
                  break;
 
          case 8: doTableSelection();
                  break;

          case 9: doTextQuery();		/* Submit Hand query */
                  break;

          case 10: doCannedQuery();             /* Add info to table, etc. */
                  break;
 
          case 11: addCannedQuery();            /* Do the add */
                   break;
 
          case 12: searchRecords();		/* Perform canned search */
                   break;

          case 14: returnSearch();		/* Return data */
                   break;

          case 15: deleteSearchItem();		/* Return data */
                   break;

	  default: unimplementedOption();
        }
        giveButtonBar();
#ifdef DEBUG
        giveDebugInfo();
#endif
	fprintf(cgiOut, "</BODY></HTML>\n");
	return 0;
}

void giveDebugInfo(void)
{
  fprintf(cgiOut,"<HR>\n");
  fprintf(cgiOut,"<CENTER><H3>DEBUG INFORMATION</H3></CENTER>\n");
  fprintf(cgiOut,"State = %d\n",state);
  fprintf(cgiOut,"<HR>\n");
}

int getState(void)
{
  cgiFormInteger("state",&state,0);
  return state;
}

void connectDB(void)
{
  if ((sock = msqlConnect(NULL)) < 0)
  {
    fprintf(cgiOut,"\nError connecting to database : %s\n\n",msqlErrMsg);
    exit(1);
  }
}
 
void giveButtonBar(void)
{
  fprintf(cgiOut,"<HR>\n");
  fprintf(cgiOut,"<CENTER>\n");
  fprintf(cgiOut,"<TABLE CELLPADDING=0 BORDER=4>\n");
  fprintf(cgiOut,"<TR>");
  fprintf(cgiOut,"<TH WIDTH=20%%><A HREF=\"RELPATH/dbadmin?state=-1\">CONNECT SERVER</A></TH>\n"); 
  fprintf(cgiOut,"<TH WIDTH=20%%><A HREF=\"RELPATH/dbadmin\">CONNECT DATABASE</A></TH>\n");
  fprintf(cgiOut,"<TH WIDTH=20%%><A HREF=\"RELPATH/dbadmin?state=1&action=1\">ADD DATABASES</A></TH>\n");
  fprintf(cgiOut,"<TH WIDTH=20%%><A HREF=\"RELPATH/dbadmin?state=1&action=2\">REMOVE DATABASES</A></TH>\n");
  /* fprintf(cgiOut,"<TH WIDTH=20%%><A HREF=\"RELPATH/dbadmin?state=1&action=3\">VIEW/MODIFY STRUCTURE</A></TH>\n"); */
  /* fprintf(cgiOut,"<TH WIDTH=20%%><A HREF=\"RELPATH/dbadmin?state=1&action=4\">VIEW/MODIFY DATABASE</A></TH>\n"); */
  fprintf(cgiOut,"</TR>");
  fprintf(cgiOut,"</TABLE><HR>\n");
}

/* -------------------------- UNIMPLEMENTED ACTIONS --------------------- */
/*                                STATE = -1                              */
void unimplementedOption(void)
{
  giveTitle();
  fprintf(cgiOut,"<HR><H3><CENTER>YOU HAVE REQUESTED AN UNIMPLEMENTED\n");
  fprintf(cgiOut,"OPTION. PLEASE LOOK FOR THIS FUNCTIONALITY IN A FUTURE\n");
  fprintf(cgiOut,"RELEASE...</CENTER></H3><HR>\n");
}


/* -------------------------- INITIAL ACTIONS PAGE ---------------------- */
/*                                STATE = 0                               */

void doTitlePage(void)
{
  giveTitle();
  connectDB();
  giveInitialActions();
  msqlClose(sock);
}

void giveTitle(void) 
{
  fprintf(cgiOut,"<H1>mSQL DataBase Administration</H1>\n");
  fprintf(cgiOut,"<HR>\n");
  fprintf(cgiOut,"<CENTER><EM>This database administration tool is NOT\n");
  fprintf(cgiOut,"freeware. Please license any distribution. See the file\n");
  fprintf(cgiOut,"license.doc for further information! ALL commercial sites\n");
  fprintf(cgiOut,"are required to register their copy!</EM></CENTER><HR>\n");
}

void giveInitialActions(void)
{
  fprintf(cgiOut,"<FORM METHOD=POST ACTION=RELPATH/dbadmin>\n");
  fprintf(cgiOut,"<H3>Please select a database:</H3>\n");
  showDatabases(RADIO_LIST);
  fprintf(cgiOut,"<H3>Please select an action:</H3>\n");
  fprintf(cgiOut,"<DD><INPUT TYPE=RADIO NAME=\"state\" VALUE=8 CHECKED> Query / Update Database...<BR>\n");
  fprintf(cgiOut,"<DD><INPUT TYPE=RADIO NAME=\"state\" VALUE=4> Add / Remove Table Definitions...<BR>\n");
  fprintf(cgiOut,"<P><CENTER><INPUT TYPE=SUBMIT VALUE=\"Connect to Database...\"></CENTER>\n");
  fprintf(cgiOut,"</FORM>\n<HR><HR>\n");
}

/* -------------------------- DO ADMIN SELECTION --------------------------- */
/*                                STATE = 1                                  */

void doAdminSelection(void)
{
  giveTitle();
  connectDB();
  cgiError=cgiFormInteger("action",&action,0);
  switch(action)
    {
    case ADD_DB: addDatabase();
      break;
    case REM_DB: removeDatabase();
      break;
/*     case MOD_DB_STRUCT: modifyStructure(); */
/*       break; */
/*     case VIEW_MOD_DB_INFO: viewUpdateInfo(); */
/*       break; */
    default : fprintf(cgiOut,"\nERROR : No Action Specified!<BR>\n");
    }
}

void addDatabase(void)
{
  fprintf(cgiOut,"<H3>The following databases currently exist:</H3>\n");
  showDatabases(NORMAL);
  fprintf(cgiOut,"<P><H3>Add Database:</H3>\n");
  fprintf(cgiOut,"<FORM METHOD=POST ACTION=RELPATH/dbadmin>");
  fprintf(cgiOut,"<INPUT TYPE=HIDDEN NAME=state VALUE=2>");
  fprintf(cgiOut,"<CENTER><TABLE BORDER=0>\n");
  fprintf(cgiOut,"<TR WIDTH=85%%>\n");
  fprintf(cgiOut,"<TD ALIGN=CENTER WIDTH=33%%>New Database Name:</TD>\n");
  fprintf(cgiOut,"<TD ALIGN=CENTER WIDTH=33%%><INPUT NAME=\"newdb\" SIZE=%d></TD>\n",MAX_DATABASENAME_LEN);
  fprintf(cgiOut,"<TD ALIGN=CENTER WIDTH=33%%><INPUT TYPE=submit VALUE=\"Add Database\"></TD>\n");
  fprintf(cgiOut,"</TR></TABLE></CENTER>\n");
}

void removeDatabase(void)
{
  fprintf(cgiOut,"<H3>Remove Database:</H3>\n");
  fprintf(cgiOut,"<FORM METHOD=POST ACTION=RELPATH/dbadmin>");
  fprintf(cgiOut,"<INPUT TYPE=HIDDEN NAME=state VALUE=3>");
  fprintf(cgiOut,"Please select a database to remove:\n<BR>\n");
  connectDB();
  showDatabases(RADIO_LIST);
  fprintf(cgiOut,"<CENTER><H4>THIS OPERATION CANNOT BE UNDONE!!</H4>\n");
  fprintf(cgiOut,"<INPUT TYPE=SUBMIT VALUE=\"Remove Database\"></CENTER>\n<BR>\n");
  msqlClose(sock);
}

void modifyStructure(void)
{
  fprintf(cgiOut,"<H3>View/Modify Database Structure:</H3>\n");
  fprintf(cgiOut,"<FORM METHOD=POST ACTION=RELPATH/dbadmin>");
  fprintf(cgiOut,"<INPUT TYPE=HIDDEN NAME=state VALUE=4>");
  fprintf(cgiOut,"Please select a database to view/modify structure:\n<BR>\n");
  connectDB();
  showDatabases(RADIO_LIST);
  fprintf(cgiOut,"<INPUT TYPE=SUBMIT VALUE=\"View/Modify Structure\">\n<BR>\n");
  msqlClose(sock);
}

void viewUpdateInfo(void)
{
  fprintf(cgiOut,"<H3>View or Query Database:</H3>\n");
  fprintf(cgiOut,"<FORM METHOD=POST ACTION=RELPATH/dbadmin>");
  fprintf(cgiOut,"<INPUT TYPE=HIDDEN NAME=state VALUE=8>");
  fprintf(cgiOut,"Please select a database to view or query:\n<BR>\n");
  connectDB();
  showDatabases(RADIO_LIST);
  fprintf(cgiOut,"<INPUT TYPE=SUBMIT VALUE=\"Connect Database\">\n<BR>\n");
  msqlClose(sock);
}

void showDatabases(int listVersion)
{
int x=0;
  res = msqlListDBs(sock);
  if (!res)
    {
    fprintf(cgiOut,"\nError : Couldn't get database list!\n<BR>\n");
    msqlClose(sock);
    exit(1);
    }
  if (listVersion==NORMAL) { fprintf(cgiOut,"<UL>\n"); }
  while((cur = msqlFetchRow(res)))
    { 
    x++;
    switch(listVersion)
      { 
      case NORMAL: fprintf(cgiOut,"<LI> %s<BR>\n",cur[0]);
           break;
      case RADIO_LIST: fprintf(cgiOut,"<DD><INPUT TYPE=RADIO NAME=\"dbname\" VALUE=%s",cur[0]);
                       if (x==1) fprintf(cgiOut," CHECKED");
                       fprintf(cgiOut,"> %s<BR>\n",cur[0]);
                       
           break;
      default: fprintf(cgiOut,"%s<BR>\n");
      }
    }
  if (listVersion==NORMAL) { fprintf(cgiOut,"</UL>\n"); }
  msqlFreeResult(res);
}

/* --------------------------- DO ADD DATABASE ---------------------------- */
/*                               STATE = 2                                  */
void doAddDB(void)
{
  giveTitle();
  connectDB();
  cgiError=cgiFormString("newdb",newdb,MAX_DATABASENAME_LEN);
  if (cgiError==cgiFormSuccess)
    {
    if(msqlCreateDB(sock,newdb) < 0)
      {
      fprintf(cgiOut,"\n<BR>mSQL Command Failed!\n<BR>Server Error = %s\n<BR>\n",msqlErrMsg);
      msqlClose(sock);
      exit(1);
      }
     else
      { fprintf(cgiOut,"<BR>Database \"%s\" created.<BR>\n",newdb); }
    /* showDatabases(NORMAL); */
    addDatabase();
    }
   else
    {
    fprintf(cgiOut,"\n<BR>An invalid name was entered for the database!\n<BR>\n");
    fprintf(cgiOut,"Please check that the name is correct and reload page.\n");
    }
  msqlClose(sock);
}


/* -------------------------- REMOVE DATABASE ----------------------------- */
/*                               STATE = 3                                  */

void doRemoveDB(void)
{
  giveTitle();
  connectDB();
  cgiError=cgiFormString("dbname",dbname,MAX_DATABASENAME_LEN);
  if (cgiError==cgiFormSuccess)
    {
    if(msqlDropDB(sock,dbname) < 0)
      {
      fprintf(cgiOut,"\nmSQL Command failed!\n<BR>Server error = %s\n<BR>\n",msqlErrMsg);
      msqlClose(sock);
      exit(1);
      }
     else
      { fprintf(cgiOut,"Database \"%s\" dropped!\n<BR>\n",dbname); }
    removeDatabase();
    }
   else
    { fprintf(cgiOut,"Invalid database selected for removal!\n<BR>\n"); }
  msqlClose(sock);
}

/* ----------------------- MODIFY TABLE STRUCTURE ------------------------- */
/*                               STATE = 4                                  */

void doModifyStructure(void)
{
  giveTitle();
  connectDB();
  cgiError=cgiFormString("dbname",dbname,MAX_DATABASENAME_LEN);
  if (cgiError==cgiFormSuccess)
    {
    if (msqlSelectDB(sock,dbname) < 0)
      {
      fprintf(cgiOut,"ERROR selecting database %s\n<BR>\n",dbname);
      fprintf(cgiOut,"\n%s<BR>\n\n",msqlErrMsg);
      msqlClose(sock);
      exit(1);
      }
     else
      {
/*    if TABLESEXIST */
      showCurrentTables();
      giveAddTable();
      }
    }
   else
    { fprintf(cgiOut,"Invalid database selected for modify!\n<BR>\n"); }
  msqlClose(sock);
}

void showCurrentTables(void)
{
  fprintf(cgiOut,"<H3>The following table definitions exist for database: %s</H3>",dbname);
  fprintf(cgiOut,"<HR>\n");
  res = msqlListTables(sock);
  if (!res)
    {
    fprintf(cgiOut,"\nERROR : Unable to list tables in database %s<BR>\n",dbname);
    exit(1);
    }
   else
    {
    dberror=msqlNumRows(res);
    if (dberror<1)
      { fprintf(cgiOut,"<CENTER><H3>No tables in database.</H3></CENTER>\n<BR>\n"); }
    else 
      {
      while((cur=msqlFetchRow(res)))
        {
        res2 = msqlListFields(sock,cur[0]);
        if (!res2)
          {
          fprintf(cgiOut,"ERROR : Couldn't find %s in %s!<BR>\n",cur[0],dbname);
          msqlFreeResult(res);
          exit(1);
          }
         else
          {
          fprintf(cgiOut,"<BR><CENTER>\n");
          fprintf(cgiOut,"<TABLE CELLPADDING=3 BORDER=5>\n");
          fprintf(cgiOut,"<TR WIDTH=80%%><TH COLSPAN=5>TABLE: %s</TH></TR>\n",cur[0]);
          fprintf(cgiOut,"<TR><TH WIDTH=15%%>FIELD</TH>");
          fprintf(cgiOut,"<TH WIDTH=15%%>TYPE</TH>");
          fprintf(cgiOut,"<TH WIDTH=15%%>LENGTH</TH>");
          fprintf(cgiOut,"<TH WIDTH=15%%>NOT NULL</TH>");
          fprintf(cgiOut,"<TH WIDTH=15%%>KEY</TH></TR>");
          while((curField = msqlFetchField(res2)))
            {
            fprintf(cgiOut,"<TR>\n");
            fprintf(cgiOut,"<TH>%s</TH>\n",curField->name);
            fprintf(cgiOut,"<TD>");
            switch(curField->type)
              {
              case INT_TYPE: fprintf(cgiOut,"int");
                   break;
              case CHAR_TYPE: fprintf(cgiOut,"char");
                   break;
              case REAL_TYPE: fprintf(cgiOut,"real");
                   break;
              default: fprintf(cgiOut,"Unknown");
                   break;
              }
            fprintf(cgiOut,"</TD>\n");
            fprintf(cgiOut,"<TD>%d</TD>\n",curField->length);
              /* fprintf(cgiOut,"<TD>PLACEHOLDER</TD>\n"); */
            fprintf(cgiOut,"<TD>%s</TD>\n", IS_NOT_NULL(curField->flags)? "Y":"N");
            fprintf(cgiOut,"<TD>%s</TD>\n", IS_PRI_KEY(curField->flags)? "Y":"N");
            fprintf(cgiOut,"</TR>");
            }
          fprintf(cgiOut,"</TABLE><BR>\n");
          fprintf(cgiOut,"<FORM METHOD=POST ACTION=RELPATH/dbadmin>\n");
          fprintf(cgiOut,"<INPUT TYPE=HIDDEN NAME=\"dbname\" VALUE=\"%s\">\n",dbname);
          fprintf(cgiOut,"<INPUT TYPE=HIDDEN NAME=\"tablename\" VALUE=%s>\n",cur[0]);
          fprintf(cgiOut,"<INPUT TYPE=HIDDEN NAME=\"state\" VALUE=5>\n");
          fprintf(cgiOut,"<INPUT TYPE=SUBMIT VALUE=\"REMOVE TABLE\">\n");
          fprintf(cgiOut,"</FORM>\n");
          fprintf(cgiOut,"<HR WIDTH=75%%>\n");
          fprintf(cgiOut,"</CENTER>\n");
          }
        }
      msqlFreeResult(res2);
      }
    msqlFreeResult(res);
    }
}

void giveAddTable(void)
{
  fprintf(cgiOut,"<HR WIDTH=90%%><HR WIDTH=80%%>\n");
  fprintf(cgiOut,"<H3>Add table definition with:</H3>\n");
  fprintf(cgiOut,"<FORM METHOD=POST ACTION=RELPATH/dbadmin>\n");
  fprintf(cgiOut,"<INPUT TYPE=HIDDEN NAME=\"state\" VALUE=6>\n");
  fprintf(cgiOut,"<INPUT TYPE=HIDDEN NAME=\"dbname\" VALUE=\"%s\">\n",dbname);
  fprintf(cgiOut,"Number of fields = ");
  fprintf(cgiOut,"<INPUT NAME=\"numfields\" SIZE=2>\n");
  fprintf(cgiOut,"<INPUT TYPE=SUBMIT VALUE=\"CREATE TABLE...\">\n");
  fprintf(cgiOut,"</FORM>\n");
}


/* ------------------------------- REMOVE TABLE --------------------------- */
/*                                  STATE = 5                               */
void doRemoveTable(void)
{
  giveTitle();
  connectDB();
  cgiError=cgiFormString("dbname",dbname,MAX_DATABASENAME_LEN);
  if (cgiError==cgiFormSuccess) 
    {
    cgiError=cgiFormString("tablename",tablename,MAX_TABLENAME_LEN);
    if (cgiError==cgiFormSuccess)
      {
      if (msqlSelectDB(sock,dbname) < 0)
        {
        fprintf(cgiOut,"ERROR selecting database %s\n<BR>\n",dbname);
        fprintf(cgiOut,"\n%s<BR>\n\n",msqlErrMsg);
        msqlClose(sock);
        exit(1);
        }
     else
        {
        fprintf(cgiOut,"\n<BR>Table %s removed from %s,\n",tablename,dbname);
        strcpy(qbuf,"DROP TABLE ");
        strcat(qbuf,tablename);
#ifdef DEBUG
        fprintf(cgiOut,"Query = %s<BR>\n",qbuf);
#endif
        if (msqlQuery(sock,qbuf) == -1)
          {
          fprintf(cgiOut,"ERROR: unable to drop table %s from %s.<BR>\n",tablename,dbname);
          fprintf(cgiOut,"Invalid query = %s<BR>\n",qbuf);
          msqlClose(sock);
          exit(1);
          }
        }
      }
     else
      { fprintf(cgiOut,"\nERROR : Table %s not found!<BR>\n",tablename); }
    }
   else
    { fprintf(cgiOut,"\nERROR : Database %s not found!<BR>\n",dbname); }
  
  showCurrentTables();
  giveAddTable();
  msqlClose(sock);
}


/* -------------------------------- ADD TABLE ----------------------------- */
/*                                  STATE = 6                               */
void doAddTable(void)
{
int x;

  giveTitle();
  connectDB();
  cgiError=cgiFormString("dbname",dbname,MAX_DATABASENAME_LEN);
  if (cgiError==cgiFormSuccess) 
    {
    cgiError=cgiFormIntegerBounded("numfields",&numfields,1,MAX_FIELDS,0);
    if (cgiError==cgiFormSuccess)
      { 
      fprintf(cgiOut,"<H3>Please enter new table definition:</H3><BR>\n");
      fprintf(cgiOut,"<CENTER>\n");
      fprintf(cgiOut,"<FORM METHOD=POST ACTION=RELPATH/dbadmin>\n");
      fprintf(cgiOut,"<INPUT TYPE=HIDDEN NAME=state VALUE=7>\n");
      fprintf(cgiOut,"<INPUT TYPE=HIDDEN NAME=\"dbname\" VALUE=\"%s\">\n",dbname);
      fprintf(cgiOut,"<INPUT TYPE=HIDDEN NAME=\"numfields\" VALUE=%d>\n",numfields);
      fprintf(cgiOut,"<TABLE BORDER=0><TR><TH>Table Name:</TH></TR>\n");
      fprintf(cgiOut,"<TR><TD><INPUT NAME=\"tablename\" VALUE=\"(new_table_name)\" SIZE=%d></TD></TR></TABLE>\n",MAX_TABLENAME_LEN);
      fprintf(cgiOut,"<TABLE CELLPADDING=3 BORDER=4>\n");
      fprintf(cgiOut,"<TR>\n");
      fprintf(cgiOut,"<TH WIDTH=15%%>FIELD\n");
      fprintf(cgiOut,"<TH WIDTH=15%%>TYPE\n");
      fprintf(cgiOut,"<TH WIDTH=15%%>LENGTH\n");
      fprintf(cgiOut,"<TH WIDTH=15%%>NOT NULL\n");
      fprintf(cgiOut,"<TH WIDTH=15%%>KEY\n");
      fprintf(cgiOut,"</TR>\n");
      for(x=1; x<=numfields; x++)
        {
        fprintf(cgiOut,"<TR>\n");
        fprintf(cgiOut,"<TD ALIGN=CENTER><INPUT NAME=\"field%d\" VALUE=\"field%d\" SIZE=25></TD>\n",x,x);
        fprintf(cgiOut,"<TD ALIGN=CENTER><SELECT NAME=\"type%d\">\n",x);
            fprintf(cgiOut,"<OPTION>INT\n");
            fprintf(cgiOut,"<OPTION>CHAR\n");
            fprintf(cgiOut,"<OPTION>REAL\n");
            fprintf(cgiOut,"</SELECT>\n");
        fprintf(cgiOut,"</TD>\n");
        fprintf(cgiOut,"<TD ALIGN=CENTER><INPUT NAME=\"lengthStr%d\" VALUE=25 SIZE=5></TD>\n",x);
        fprintf(cgiOut,"<TD ALIGN=CENTER><SELECT NAME=\"notnul%d\">\n",x);
          if (x==1)
            {
            fprintf(cgiOut,"<OPTION>Y\n");
            fprintf(cgiOut,"<OPTION>N\n");
            }
           else
            {
            fprintf(cgiOut,"<OPTION>N\n");
            fprintf(cgiOut,"<OPTION>Y\n");
            }
            fprintf(cgiOut,"</SELECT>\n");
        fprintf(cgiOut,"</TD>\n");
        fprintf(cgiOut,"<TD ALIGN=CENTER><SELECT NAME=\"key%d\">\n",x);
          if (x==1)
            {
            fprintf(cgiOut,"<OPTION>Y\n");
            fprintf(cgiOut,"<OPTION>N\n");
            }
           else
            {
            fprintf(cgiOut,"<OPTION>N\n");
            /* fprintf(cgiOut,"<OPTION>Y\n"); */
            }
            fprintf(cgiOut,"</SELECT>\n");
        fprintf(cgiOut,"</TD>\n");
        fprintf(cgiOut,"</TR>\n");
        }
      fprintf(cgiOut,"</TABLE>\n");
      fprintf(cgiOut,"*Note: Length will be ignored for INTs and REALs.<BR><BR>\n",numfields);
      fprintf(cgiOut,"<INPUT TYPE=SUBMIT VALUE=\"Add this table definition...\">\n");
      fprintf(cgiOut,"</FORM></CENTER>\n");
      }
     else
      {
      fprintf(cgiOut,"ERROR: Invalid number if fields chosen!<BR>\n");
      fprintf(cgiOut,"Please submit an integer x where 0 &lt x &lt %d<BR>\n",MAX_FIELDS);
      msqlClose(sock);
      exit(1);
      }
    }
   else
    {
    fprintf(cgiOut,"ERROR: Unable to connect to database!<BR>\n");
    msqlClose(sock);
    exit(1);
    }
  msqlClose(sock);
}


/* -------------------------- ADD TABLE NOW ------------------------------- */
/*                               STATE = 7                                  */
void addTableNow(void)
{
int x;

  giveTitle();
  connectDB();

  cgiFormString("dbname",dbname,MAX_DATABASENAME_LEN);
  cgiFormString("tablename",tablename,MAX_TABLENAME_LEN);
  cgiFormInteger("numfields",&numfields,0);
  getFields();
#ifdef DEBUG
  fprintf(cgiOut,"NUMBER OF FIELDS = %d<BR>\n",numfields);
#endif
  if(msqlSelectDB(sock,dbname) < 0)
    {
    fprintf(cgiOut,"ERROR selecting database %s<BR>\n",dbname);
    fprintf(cgiOut,"\n%s<BR>\n\n",msqlErrMsg);
    msqlClose(sock);
    exit(1);
    }
#ifdef DEBUG
  fprintf(cgiOut,"CREATE TABLE %s (<BR>\n",tablename);
  for(x=1; x<=numfields; x++)
    {
    fprintf(cgiOut,"%s %s",&field[x-1][0],&type[x-1][0]); 
    if (strcmp(&type[x-1][0],"CHAR")==0) { fprintf(cgiOut,"(%s)",&lengthStr[x-1][0]); }
    if (strcmp(&notnul[x-1][0],"Y")==0) { fprintf(cgiOut," not null"); }
    if (strcmp(&key[x-1][0],"Y")==0) { fprintf(cgiOut," primary key"); }
    if (x!=numfields) { fprintf(cgiOut,",<BR>\n"); }
     else { fprintf(cgiOut," )<BR>\n"); }
    }
#endif
  strcpy(qbuf,"CREATE TABLE ");
  strcat(qbuf,tablename);
  strcat(qbuf," ( ");
  for(x=1; x<=numfields; x++)
    {
    strcat(qbuf,&field[x-1][0]);
    strcat(qbuf," ");
    strcat(qbuf,&type[x-1][0]);
    if (strcmp(&type[x-1][0],"CHAR")==0)
      {
      strcat(qbuf,"(");
      strcat(qbuf,&lengthStr[x-1][0]);
      strcat(qbuf,")");
      }
    if (strcmp(&notnul[x-1][0],"Y")==0) { strcat(qbuf," not null"); }
    if (strcmp(&key[x-1][0],"Y")==0) { strcat(qbuf," primary key"); }
    if (x!=numfields) { strcat(qbuf,", "); }
     else { strcat(qbuf," )"); }
    }
#ifdef DEBUG
  fprintf(cgiOut,"<BR>query = %s",qbuf);
#endif

  if (msqlQuery(sock,qbuf) == -1)
    {
    fprintf(cgiOut,"ERROR: unable to add table %s to %s.<BR>\n",tablename,dbname);
    fprintf(cgiOut,"Invalid query = %s<BR>\n",qbuf);
    msqlClose(sock);
    exit(1);
    }
  fprintf(cgiOut,"Table %s added.\n",tablename);
  showCurrentTables();
  giveAddTable();
  msqlClose(sock);
}

void getFields(void)
{
  cgiFormString("field1",&field[0][0],MAX_FIELDNAME_LEN);
  cgiFormString("field2",&field[1][0],MAX_FIELDNAME_LEN);
  cgiFormString("field3",&field[2][0],MAX_FIELDNAME_LEN);
  cgiFormString("field4",&field[3][0],MAX_FIELDNAME_LEN);
  cgiFormString("field5",&field[4][0],MAX_FIELDNAME_LEN);
  cgiFormString("field6",&field[5][0],MAX_FIELDNAME_LEN);
  cgiFormString("field7",&field[6][0],MAX_FIELDNAME_LEN);
  cgiFormString("field8",&field[7][0],MAX_FIELDNAME_LEN);
  cgiFormString("field9",&field[8][0],MAX_FIELDNAME_LEN);
  cgiFormString("field10",&field[9][0],MAX_FIELDNAME_LEN);
  cgiFormString("field11",&field[10][0],MAX_FIELDNAME_LEN);
  cgiFormString("field12",&field[11][0],MAX_FIELDNAME_LEN);
  cgiFormString("field13",&field[12][0],MAX_FIELDNAME_LEN);
  cgiFormString("field14",&field[13][0],MAX_FIELDNAME_LEN);
  cgiFormString("field15",&field[14][0],MAX_FIELDNAME_LEN);
  cgiFormString("field16",&field[15][0],MAX_FIELDNAME_LEN);
  cgiFormString("field17",&field[16][0],MAX_FIELDNAME_LEN);
  cgiFormString("field18",&field[17][0],MAX_FIELDNAME_LEN);
  cgiFormString("field19",&field[18][0],MAX_FIELDNAME_LEN);
  cgiFormString("field20",&field[19][0],MAX_FIELDNAME_LEN);
  cgiFormString("field21",&field[20][0],MAX_FIELDNAME_LEN);
  cgiFormString("field22",&field[21][0],MAX_FIELDNAME_LEN);
  cgiFormString("field23",&field[22][0],MAX_FIELDNAME_LEN);
  cgiFormString("field24",&field[23][0],MAX_FIELDNAME_LEN);
  cgiFormString("field25",&field[24][0],MAX_FIELDNAME_LEN);

  cgiFormString("type1",&type[0][0],5);
  cgiFormString("type2",&type[1][0],5);
  cgiFormString("type3",&type[2][0],5);
  cgiFormString("type4",&type[3][0],5);
  cgiFormString("type5",&type[4][0],5);
  cgiFormString("type6",&type[5][0],5);
  cgiFormString("type7",&type[6][0],5);
  cgiFormString("type8",&type[7][0],5);
  cgiFormString("type9",&type[8][0],5);
  cgiFormString("type10",&type[9][0],5);
  cgiFormString("type11",&type[10][0],5);
  cgiFormString("type12",&type[11][0],5);
  cgiFormString("type13",&type[12][0],5);
  cgiFormString("type14",&type[13][0],5);
  cgiFormString("type15",&type[14][0],5);
  cgiFormString("type16",&type[15][0],5);
  cgiFormString("type17",&type[16][0],5);
  cgiFormString("type18",&type[17][0],5);
  cgiFormString("type19",&type[18][0],5);
  cgiFormString("type20",&type[19][0],5);
  cgiFormString("type21",&type[20][0],5);
  cgiFormString("type22",&type[21][0],5);
  cgiFormString("type23",&type[22][0],5);
  cgiFormString("type24",&type[23][0],5);
  cgiFormString("type25",&type[24][0],5);

  cgiFormString("lengthStr1",&lengthStr[0][0],0);
  cgiFormString("lengthStr2",&lengthStr[1][0],0);
  cgiFormString("lengthStr3",&lengthStr[2][0],0);
  cgiFormString("lengthStr4",&lengthStr[3][0],0);
  cgiFormString("lengthStr5",&lengthStr[4][0],0);
  cgiFormString("lengthStr6",&lengthStr[5][0],0);
  cgiFormString("lengthStr7",&lengthStr[6][0],0);
  cgiFormString("lengthStr8",&lengthStr[7][0],0);
  cgiFormString("lengthStr9",&lengthStr[8][0],0);
  cgiFormString("lengthStr10",&lengthStr[9][0],0);
  cgiFormString("lengthStr11",&lengthStr[10][0],0);
  cgiFormString("lengthStr12",&lengthStr[11][0],0);
  cgiFormString("lengthStr13",&lengthStr[12][0],0);
  cgiFormString("lengthStr14",&lengthStr[13][0],0);
  cgiFormString("lengthStr15",&lengthStr[14][0],0);
  cgiFormString("lengthStr16",&lengthStr[15][0],0);
  cgiFormString("lengthStr17",&lengthStr[16][0],0);
  cgiFormString("lengthStr18",&lengthStr[17][0],0);
  cgiFormString("lengthStr19",&lengthStr[18][0],0);
  cgiFormString("lengthStr20",&lengthStr[19][0],0);
  cgiFormString("lengthStr21",&lengthStr[20][0],0);
  cgiFormString("lengthStr22",&lengthStr[21][0],0);
  cgiFormString("lengthStr23",&lengthStr[22][0],0);
  cgiFormString("lengthStr24",&lengthStr[23][0],0);
  cgiFormString("lengthStr25",&lengthStr[24][0],0);

  cgiFormString("notnul1",&notnul[0][0],2);
  cgiFormString("notnul2",&notnul[1][0],2);
  cgiFormString("notnul3",&notnul[2][0],2);
  cgiFormString("notnul4",&notnul[3][0],2);
  cgiFormString("notnul5",&notnul[4][0],2);
  cgiFormString("notnul6",&notnul[5][0],2);
  cgiFormString("notnul7",&notnul[6][0],2);
  cgiFormString("notnul8",&notnul[7][0],2);
  cgiFormString("notnul9",&notnul[8][0],2);
  cgiFormString("notnul10",&notnul[9][0],2);
  cgiFormString("notnul11",&notnul[10][0],2);
  cgiFormString("notnul12",&notnul[11][0],2);
  cgiFormString("notnul13",&notnul[12][0],2);
  cgiFormString("notnul14",&notnul[13][0],2);
  cgiFormString("notnul15",&notnul[14][0],2);
  cgiFormString("notnul16",&notnul[15][0],2);
  cgiFormString("notnul17",&notnul[16][0],2);
  cgiFormString("notnul18",&notnul[17][0],2);
  cgiFormString("notnul19",&notnul[18][0],2);
  cgiFormString("notnul20",&notnul[19][0],2);
  cgiFormString("notnul21",&notnul[20][0],2);
  cgiFormString("notnul22",&notnul[21][0],2);
  cgiFormString("notnul23",&notnul[22][0],2);
  cgiFormString("notnul24",&notnul[23][0],2);
  cgiFormString("notnul25",&notnul[24][0],2);

  cgiFormString("key1",&key[0][0],2);
  cgiFormString("key2",&key[1][0],2);
  cgiFormString("key3",&key[2][0],2);
  cgiFormString("key4",&key[3][0],2);
  cgiFormString("key5",&key[4][0],2);
  cgiFormString("key6",&key[5][0],2);
  cgiFormString("key7",&key[6][0],2);
  cgiFormString("key8",&key[7][0],2);
  cgiFormString("key9",&key[8][0],2);
  cgiFormString("key10",&key[9][0],2);
  cgiFormString("key11",&key[10][0],2);
  cgiFormString("key12",&key[11][0],2);
  cgiFormString("key13",&key[12][0],2);
  cgiFormString("key14",&key[13][0],2);
  cgiFormString("key15",&key[14][0],2);
  cgiFormString("key16",&key[15][0],2);
  cgiFormString("key17",&key[16][0],2);
  cgiFormString("key18",&key[17][0],2);
  cgiFormString("key19",&key[18][0],2);
  cgiFormString("key20",&key[19][0],2);
  cgiFormString("key21",&key[20][0],2);
  cgiFormString("key22",&key[21][0],2);
  cgiFormString("key23",&key[22][0],2);
  cgiFormString("key24",&key[23][0],2);
  cgiFormString("key25",&key[24][0],2);
}


/* -------------------------- CHOOSE TABLE PAGE --------------------------- */
/*                               STATE = 8                                 */

void doTableSelection(void)
{
  giveTitle();
  connectDB();
  cgiFormString("dbname",dbname,MAX_DATABASENAME_LEN);
  if(msqlSelectDB(sock,dbname) < 0)
    {
    fprintf(cgiOut,"ERROR selecting database %s<BR>\n",dbname);
    fprintf(cgiOut,"\n%s<BR>\n\n",msqlErrMsg);
    msqlClose(sock);
    exit(1);
    }
  giveSearch(); 
  giveInsert();
  giveTextQuery();
  msqlClose(sock);
}

void giveSearch(void)
{
  fprintf(cgiOut,"<H3>Search a table (with option to delete items)...</H3>\n");
  fprintf(cgiOut,"<FORM METHOD=POST ACTION=RELPATH/dbadmin>\n");
  fprintf(cgiOut,"<INPUT TYPE=HIDDEN NAME=state VALUE=12>\n");
  showTables();
  fprintf(cgiOut,"<INPUT TYPE=SUBMIT VALUE=\"Perform Search...\">\n");
  fprintf(cgiOut,"</FORM><HR>");
}

void giveInsert(void)
{
  fprintf(cgiOut,"<H3>Add data to a table...</H3>\n");
  fprintf(cgiOut,"<FORM METHOD=POST ACTION=RELPATH/dbadmin>\n");
  fprintf(cgiOut,"<INPUT TYPE=HIDDEN NAME=state VALUE=10>\n");
  showTables();
  fprintf(cgiOut,"<INPUT TYPE=SUBMIT VALUE=\"Begin Insert...\">\n");
  fprintf(cgiOut,"</FORM><HR>");
}

void showTables(void)
{
/*  fprintf(cgiOut,"<H3>Select a table to insert data:</H3>\n"); */
/*  fprintf(cgiOut,"<FORM METHOD=POST ACTION=RELPATH/dbadmin>\n"); */
/*  fprintf(cgiOut,"<INPUT TYPE=HIDDEN NAME=state VALUE=10>\n"); */
int x=0;
  res = msqlListTables(sock);
  if (!res)
    {
    fprintf(cgiOut,"\nERROR : Unable to list tables in database %s<BR>\n",dbname);
    msqlClose(sock);
    exit(1);
    }
  while(cur = msqlFetchRow(res))
    { 
    x++;
    fprintf(cgiOut,"<DD><INPUT TYPE=RADIO NAME=\"tablename\" VALUE=\"%s\" ",cur[0]);
    if (x==1) { fprintf(cgiOut," CHECKED"); }
    fprintf(cgiOut,"> %s\n<BR>",cur[0]);
    }
  fprintf(cgiOut,"<INPUT TYPE=HIDDEN NAME=\"dbname\" VALUE=\"%s\">\n",dbname);
/*  fprintf(cgiOut,"<INPUT TYPE=SUBMIT VALUE=\"New Record... \">\n"); */
/*  fprintf(cgiOut,"</FORM><HR>\n"); */
}

void giveCannedSelect(void)
{
  fprintf(cgiOut,"<H3>Select a query:</H3>\n");
  fprintf(cgiOut,"<FORM METHOD=POST ACTION=RELPATH/dbadmin>");
  fprintf(cgiOut,"<INPUT TYPE=HIDDEN NAME=\"state\" VALUE=xx>\n");
  fprintf(cgiOut,"<INPUT TYPE=HIDDEN NAME=\"dbname\" VALUE=\"%s\">\n",dbname);
  fprintf(cgiOut,"SELECT...<BR>\n");
  fprintf(cgiOut,"<DD><INPUT TYPE=CHECKBOX NAME=\"columns\"> * <BR>\n");
  fprintf(cgiOut,"FROM...<BR>\n");
  res = msqlListTables(sock);
  while((cur = msqlFetchRow(res)))
    { fprintf(cgiOut,"<DD><INPUT TYPE=CHECKBOX NAME=\"tablename\" VALUE=\"%s\"> %s\n<BR>",cur[0],cur[0]); }
  fprintf(cgiOut,"</FORM>\n");
  fprintf(cgiOut,"<HR>\n");
}

void giveTextQuery(void)
{
  fprintf(cgiOut,"<H3>Enter a mSQL query by hand if you prefer:</H3>\n");
  fprintf(cgiOut,"<FORM METHOD=POST ACTION=RELPATH/dbadmin>");
  fprintf(cgiOut,"<INPUT TYPE=HIDDEN NAME=\"state\" VALUE=9>\n");
  fprintf(cgiOut,"<INPUT TYPE=HIDDEN NAME=\"dbname\" VALUE=\"%s\">\n",dbname);
  fprintf(cgiOut,"<TEXTAREA COLS=60 ROWS=10 NAME=\"textquery\">\n");
  fprintf(cgiOut,"SELECT * FROM (tablename)\n");
  fprintf(cgiOut,"</TEXTAREA>\n");
  fprintf(cgiOut,"<INPUT TYPE=SUBMIT VALUE=\"Submit mSQL query...\">\n");
  fprintf(cgiOut,"</FORM>\n");
}


/* --------------------------- DO TEXT QUERY ----------------------------- */
/*                               STATE = 9                                 */

void doTextQuery(void)
{
/* int cols,rows,x,y; */
char *thetextquery;
char *command;

  giveTitle();
  connectDB();
  cgiFormString("dbname",dbname,MAX_DATABASENAME_LEN);
  if(msqlSelectDB(sock,dbname) < 0)
    {
    fprintf(cgiOut,"ERROR selecting database %s<BR>\n",dbname);
    fprintf(cgiOut,"\n%s<BR>\n\n",msqlErrMsg);
    msqlClose(sock);
    exit(1);
    }
  cgiFormString("textquery",textquery,MAX_TEXTQUERY_LEN);
  if (msqlQuery(sock,textquery) == -1)
    {
    fprintf(cgiOut,"ERROR: unable to perform query on database %s.<BR>\n",dbname);
    fprintf(cgiOut,"Invalid query = %s<BR>\n",textquery);
    msqlClose(sock);
    exit(1);
    }
  thetextquery = (char *)malloc(MAX_TEXTQUERY_LEN*sizeof(char));
  bzero(thetextquery,MAX_TEXTQUERY_LEN);
  thetextquery = strcpy(thetextquery,textquery); 
  command = (char *)malloc(100*sizeof(char));
  bzero(command,100);
  command = strtok(textquery," ");
  if (strcmp(command,"select")==0)
    { 
    fprintf(cgiOut,"<CENTER>The query \"%s\" returned the following values:\n",thetextquery);
    showSelectData();
    }
  giveBackQueryPage(); 
  free(thetextquery);
  free(command);
  msqlClose(sock);
}

void showSelectData(void)
{
int cols,rows,x,y;

  res=msqlStoreResult();
  fprintf(cgiOut,"<TABLE BORDER=4 CELLPADDING=2>\n");
  rows=msqlNumRows(res);
  cols=msqlNumFields(res);
  for (x=0; x<rows; x++)
    { 
    fprintf(cgiOut,"<TR>\n");
    cur=msqlFetchRow(res);
    for (y=0; y<cols; y++)
      {
      fprintf(cgiOut,"<TD NOWRAP>\n");
      fprintf(cgiOut,"%s\n",cur[y]);
      fprintf(cgiOut,"</TD>\n");
      }
    fprintf(cgiOut,"</TR>\n");
    }
  fprintf(cgiOut,"</TABLE>\n");
  msqlFreeResult(res);
}


/* -------------------------- CANNED QUERY PAGE -------------------------- */
/*                               STATE = 10                                */

void doCannedQuery(void)
{
int size=1;

  fieldnames = (char *)malloc(1*sizeof(char));
  strcpy(fieldnames,"");
  giveTitle();
  connectDB();
  cgiFormString("dbname",dbname,MAX_DATABASENAME_LEN);
  if(msqlSelectDB(sock,dbname) < 0)
    {
    fprintf(cgiOut,"ERROR selecting database %s<BR>\n",dbname);
    fprintf(cgiOut,"\n%s<BR>\n\n",msqlErrMsg);
    msqlClose(sock);
    exit(1);
    }
  cgiError=cgiFormString("tablename",tablename,MAX_TABLENAME_LEN);
  if (cgiError==cgiFormSuccess)
    {
    if (msqlSelectDB(sock,dbname) < 0)
      {
      fprintf(cgiOut,"ERROR selecting database %s\n<BR>\n",dbname);
      fprintf(cgiOut,"\n%s<BR>\n\n",msqlErrMsg);
      msqlClose(sock);
      exit(1);
      }
   else
      { giveInsertForm(); }
    }
  msqlClose(sock);
}

void giveInsertForm(void)
{
int size=1;
  res=msqlListFields(sock,tablename);
  if (!res)
    {
    fprintf(cgiOut,"ERROR : Couldn't find %s in %s!<BR>\n",tablename,dbname);
    msqlFreeResult(res);
    exit(1);
    }
   else
    {
    fprintf(cgiOut,"<H3>Add new data to table %s:</H3>\n",tablename);
    fprintf(cgiOut,"<CENTER>\n");
    fprintf(cgiOut,"<FORM METHOD=POST ACTION=RELPATH/dbadmin>\n");
    fprintf(cgiOut,"<INPUT TYPE=HIDDEN NAME=\"state\" VALUE=11>\n");
    fprintf(cgiOut,"<INPUT TYPE=HIDDEN NAME=\"dbname\" VALUE=\"%s\">\n",dbname);
    fprintf(cgiOut,"<INPUT TYPE=HIDDEN NAME=\"tablename\" VALUE=\"%s\">\n",tablename);
    fprintf(cgiOut,"<TABLE WIDTH=75%% BORDER=2 CELLPADDING=4>\n");
    while((curField = msqlFetchField(res)))
      {
      size = size + strlen(curField->name) + 2;
      fieldnames= (char *)realloc((void *)fieldnames,size);
      strcat(fieldnames,curField->name);
      strcat(fieldnames,",");
      fprintf(cgiOut,"<TR><TH>%s</TH>\n",curField->name);
      fprintf(cgiOut,"<TD ALIGN=CENTER><INPUT TYPE=\"TEXT\" NAME=\"%s\" SIZE=25></TD></TR>\n",curField->name);
      }
    fprintf(cgiOut,"</TABLE>\n");
    fprintf(cgiOut,"<INPUT TYPE=HIDDEN NAME=\"fieldnames\" VALUE=\"%s\">\n",fieldnames); 
    fprintf(cgiOut,"<INPUT TYPE=SUBMIT VALUE=\"Add entry to table...\">\n");
    fprintf(cgiOut,"</FORM>\n");
    fprintf(cgiOut,"</CENTER>\n");
    free(fieldnames);
#ifdef DEBUG
    fprintf(cgiOut,"SIZE=%d\n");
#endif
    }
  giveBackQueryPage();
}

void giveBackQueryPage(void)
{
  fprintf(cgiOut,"<CENTER><HR>\n");
  fprintf(cgiOut,"<FORM METHOD=POST ACTION=RELPATH/dbadmin>\n");
  fprintf(cgiOut,"<INPUT TYPE=HIDDEN NAME=\"state\" VALUE=8>\n");
  fprintf(cgiOut,"<INPUT TYPE=HIDDEN NAME=\"dbname\" VALUE=\"%s\">\n",dbname);
  fprintf(cgiOut,"<INPUT TYPE=SUBMIT VALUE=\"RETURN TO MAIN QUERY PAGE\">\n");
  fprintf(cgiOut,"</FORM>\n");
  fprintf(cgiOut,"<HR></CENTER>\n");
}

/* -------------------------- ADD CANNED QUERY  -------------------------- */
/*                               STATE = 11                                */

void addCannedQuery(void)
{
int count=0;
int x,lengthstr;
char temp[MAX_ITEM_LEN];

  giveTitle();
  connectDB();
  cgiFormString("dbname",dbname,MAX_DATABASENAME_LEN);
  if(msqlSelectDB(sock,dbname) < 0)
    {
    fprintf(cgiOut,"ERROR selecting database %s<BR>\n",dbname);
    fprintf(cgiOut,"\n%s<BR>\n\n",msqlErrMsg);
    msqlClose(sock);
    exit(1);
    }
  cgiError=cgiFormString("tablename",tablename,MAX_TABLENAME_LEN);
  if (cgiError==cgiFormSuccess)
    {
    if (msqlSelectDB(sock,dbname) < 0)
      {
      fprintf(cgiOut,"ERROR selecting database %s\n<BR>\n",dbname);
      fprintf(cgiOut,"\n%s<BR>\n\n",msqlErrMsg);
      msqlClose(sock);
      exit(1);
      }
    else
      {
      res=msqlListFields(sock,tablename);
      if (!res)
        {
        fprintf(cgiOut,"ERROR : Couldn't find %s in %s!<BR>\n",tablename,dbname);
        msqlFreeResult(res);
        exit(1);
        }
       else
        {
        cgiFormStringSpaceNeeded("fieldnames",&lengthstr);
        fieldnames = (char *)malloc(lengthstr*sizeof(char));
        cgiFormString("fieldnames",fieldnames,lengthstr);
/* HERE! */
        free(fieldnames);
        strcpy(qbuf,"INSERT INTO ");
        strcat(qbuf,tablename);
        strcat(qbuf," ( ");
        while((curField = msqlFetchField(res)))
          {
          if (count>0) {strcat(qbuf,", ");}
          count++;
          strcat(qbuf,curField->name);
          }
        strcat(qbuf," ) VALUES ( ");
        res=msqlListFields(sock,tablename);
        count=0;
        while(curField = msqlFetchField(res))
          {
          cgiFormStringSpaceNeeded(curField->name,&lengthstr);
          if (count>0) {strcat(qbuf,", ");}
          count++;
          switch (curField->type)
            {
              case INT_TYPE:
                              cgiFormString(curField->name,temp,lengthstr);
                              strcat(qbuf,temp);
                   break;
              case CHAR_TYPE: 
                              strcat(qbuf,"'");
                              cgiFormString(curField->name,temp,lengthstr);
                              strcat(qbuf,temp);
                              strcat(qbuf,"'");
                   break;
              case REAL_TYPE: 
                              cgiFormString(curField->name,temp,lengthstr);
                              strcat(qbuf,temp);
                   break;
              default: fprintf(cgiOut,"Error: Unknown mSQL field type");
                   exit(1);
                   break;
            }
          }
        strcat(qbuf,")");
#ifdef DEBUG
        fprintf(cgiOut,"Query = %s<BR>\n",qbuf);
#endif
        if (msqlQuery(sock,qbuf) == -1)
          {
          fprintf(cgiOut,"ERROR: unable to perform query on database %s.<BR>\n",dbname);
          fprintf(cgiOut,"Invalid query = %s<BR>\n",qbuf);
          msqlClose(sock);
          exit(1);
          }
        }
      }
    }
  else
    {
    fprintf(cgiOut,"ERROR getting tablename<BR>\n");
    exit(1);
    }
  fprintf(cgiOut,"Insert completed.\n");
  giveInsertForm();
  msqlClose(sock);
} 


/* --------------------------- SEARCH RECORD ----------------------------- */
/*                               STATE = 12                                */

void searchRecords(void)
{
  giveTitle();
  connectDB();
  cgiFormString("dbname",dbname,MAX_DATABASENAME_LEN);
  if(msqlSelectDB(sock,dbname) < 0)
    {
    fprintf(cgiOut,"ERROR selecting database %s<BR>\n",dbname);
    fprintf(cgiOut,"\n%s<BR>\n\n",msqlErrMsg);
    msqlClose(sock);
    exit(1);
    }
  cgiError=cgiFormString("tablename",tablename,MAX_TABLENAME_LEN);
  giveSearchForm();
  giveBackQueryPage();
  msqlClose(sock);
}

void giveSearchForm(void)
{
  fprintf(cgiOut,"<H3>Search of table %s:</H3>\n",tablename);
  fprintf(cgiOut,"<CENTER>Check the box to the left of any field name to\n");
  fprintf(cgiOut,"indicate it should be used for search criteria. Insert\n");
  fprintf(cgiOut,"similiar data in the text field to limit search.\n");
  fprintf(cgiOut,"INCLUDE SINGLE QUOTE FOR TEXT DATA!!!\n");
  fprintf(cgiOut,"<FORM METHOD=POST ACTION=RELPATH/dbadmin>\n");
  fprintf(cgiOut,"<INPUT TYPE=HIDDEN NAME=\"dbname\" VALUE=\"%s\">\n",dbname);
  fprintf(cgiOut,"<INPUT TYPE=HIDDEN NAME=\"tablename\" VALUE=%s>\n",tablename);
  fprintf(cgiOut,"<INPUT TYPE=HIDDEN NAME=\"state\" VALUE=14>\n");
  fprintf(cgiOut,"<TABLE WIDTH=75%% BORDER=2 CELLPADDING=4>\n");
  res = msqlListFields(sock,tablename);
  while (curField = msqlFetchField(res))
    {
    fprintf(cgiOut,"<TR><TD><INPUT TYPE=RADIO NAME=\"searchby\" VALUE=\"%s\">",curField->name);
    fprintf(cgiOut,"<TH ALIGN=CENTER>%s</TD><TD ALIGN=CENTER><INPUT NAME=\"%s\" SIZE=25></TD></TR>\n",curField->name,curField->name);
    }
  fprintf(cgiOut,"</TABLE>\n");
  fprintf(cgiOut,"USE <SELECT NAME=\"operation\"><OPTION>LIKE<OPTION>=</SELECT>\n");
  fprintf(cgiOut,"<INPUT TYPE=SUBMIT VALUE=\"PERFORM SEARCH...\">\n");
  fprintf(cgiOut,"</FORM></CENTER>\n");
  msqlFreeResult(res);
}


/* --------------------------- RETURN SEARCH  ----------------------------- */
/*                               STATE = 14                                */

void returnSearch(void)
{
  giveTitle();
  connectDB();
  cgiFormString("dbname",dbname,MAX_DATABASENAME_LEN);
  if(msqlSelectDB(sock,dbname) < 0)
    {
    fprintf(cgiOut,"ERROR selecting database %s<BR>\n",dbname);
    fprintf(cgiOut,"\n%s<BR>\n\n",msqlErrMsg);
    msqlClose(sock);
    exit(1);
    }
  cgiError=cgiFormString("tablename",tablename,MAX_TABLENAME_LEN);
  cgiFormString("searchby",searchby,MAX_FIELDNAME_LEN);
  cgiFormString(searchby,searchdata,MAX_ITEM_LEN);
  cgiFormString("operation",operation,5);
  doSearchQuery();
  giveBackQueryPage();
  msqlClose(sock);
}

void doSearchQuery(void)
{
  strcpy(qbuf,"SELECT * FROM ");
  strcat(qbuf,tablename);
  strcat(qbuf," WHERE ");
  strcat(qbuf,searchby);
  strcat(qbuf," ");
  strcat(qbuf,operation);
  strcat(qbuf," ");
  strcat(qbuf,searchdata);
#ifdef DEBUG
  fprintf(cgiOut,"Query = %s\n",qbuf);
#endif
  if (msqlQuery(sock,qbuf) == -1)
    {
    fprintf(cgiOut,"ERROR: unable to perform query on database %s.<BR>\n",dbname);
    fprintf(cgiOut,"Invalid query = %s<BR>\n",qbuf);
    msqlClose(sock);
    exit(1);
    }
  showSelectDeleteData();
}

void showSelectDeleteData(void)
{
int cols,rows,x,y;

  res=msqlStoreResult();
  fprintf(cgiOut,"<FORM METHOD=POST ACTION=RELPATH/dbadmin>");
  fprintf(cgiOut,"<INPUT TYPE=HIDDEN NAME=\"state\" VALUE=15>\n");
  fprintf(cgiOut,"<INPUT TYPE=HIDDEN NAME=\"dbname\" VALUE=\"%s\">\n",dbname);
  fprintf(cgiOut,"<INPUT TYPE=HIDDEN NAME=\"tablename\" VALUE=\"%s\">\n",tablename);
  fprintf(cgiOut,"<INPUT TYPE=HIDDEN NAME=\"textquery\" VALUE=\"%s\">\n",qbuf);
  fprintf(cgiOut,"<H3>Tag item at left to mark for deletion, then click delete\n");
  fprintf(cgiOut,"button at bottom of table to remove record.</H3>\n");
  fprintf(cgiOut,"<CENTER>\n");
  fprintf(cgiOut,"<TABLE BORDER=4 CELLPADDING=2>\n");
  rows=msqlNumRows(res);
  cols=msqlNumFields(res);
  for (x=0; x<rows; x++)
    { 
    fprintf(cgiOut,"<TR>\n");
    cur=msqlFetchRow(res);
    fprintf(cgiOut,"<TD><INPUT TYPE=RADIO NAME=\"delitemnum\" VALUE=%d>",x);
#ifdef DEBUG
    fprintf(cgiOut,"%d",x);
#endif
    fprintf(cgiOut,"</TD>\n");
    for (y=0; y<cols; y++)
      {
      curField=msqlFetchField(res);
      fprintf(cgiOut,"<TD NOWRAP>\n");
      fprintf(cgiOut,"%s\n",cur[y]);
      fprintf(cgiOut,"</TD>\n");
      fprintf(cgiOut,"<INPUT TYPE=HIDDEN NAME=\"%s\" VALUE=\"%s\">\n",curField->name,cur[y]);
      }
    fprintf(cgiOut,"</TR>\n");
    }
  fprintf(cgiOut,"</TABLE>\n");
  fprintf(cgiOut,"<INPUT TYPE=SUBMIT VALUE=\"DELETE TAGGED RECORD\">");
  fprintf(cgiOut,"</FORM>\n");
  fprintf(cgiOut,"</CENTER>\n");
  msqlFreeResult(res);
}


/* ------------------------- DELETE SEARCH ITEM  ------------------------- */
/*                               STATE = 15                                */

void deleteSearchItem(void)
{
  giveTitle();
  connectDB();
  cgiFormString("dbname",dbname,MAX_DATABASENAME_LEN);
  if(msqlSelectDB(sock,dbname) < 0)
    {
    fprintf(cgiOut,"ERROR selecting database %s<BR>\n",dbname);
    fprintf(cgiOut,"\n%s<BR>\n\n",msqlErrMsg);
    msqlClose(sock);
    exit(1);
    }
  cgiError=cgiFormString("tablename",tablename,MAX_TABLENAME_LEN);
  cgiFormString("textquery",qbuf,MAX_TEXTQUERY_LEN);
  cgiFormInteger("delitemnum",&delitemnum,-1);
  performDelete();

  giveBackQueryPage();
  msqlClose(sock);
}

void performDelete(void)
{
int x=0;
char temp[MAX_ITEM_LEN];

  if (delitemnum==-1)
    {
    fprintf(cgiOut,"ERROR: No item selected for deletion!");
    msqlClose(sock);
    exit(1);
    }
  if (msqlQuery(sock,qbuf) == -1)
    {
    fprintf(cgiOut,"ERROR: unable to perform query on database %s.<BR>\n",dbname);
    fprintf(cgiOut,"Invalid query = %s<BR>\n",qbuf);
    msqlClose(sock);
    exit(1);
    }
  res=msqlStoreResult();
  msqlDataSeek(res,delitemnum);
  cur=msqlFetchRow(res);
  strcpy(qbuf,"DELETE FROM ");
  strcat(qbuf,tablename);
  strcat(qbuf," WHERE ");
          while((curField = msqlFetchField(res)))
            {
            x++;
            if (x>1) { strcat(qbuf," AND "); }
            strcat(qbuf,curField->name);
            strcat(qbuf,"=");
            cgiFormString(curField->name,temp,MAX_ITEM_LEN);
            switch(curField->type)
              {
              case INT_TYPE:  strcat(qbuf,temp); 
                   break;
              case CHAR_TYPE: strcat(qbuf,"'");
                              strcat(qbuf,temp);
                              strcat(qbuf,"'");
                   break;
              case REAL_TYPE: strcat(qbuf,temp); 
                   break;
              }
            }
#ifdef DEBUG
  fprintf(cgiOut,"Query = %s\n",qbuf); 
#endif
        if (msqlQuery(sock,qbuf) == -1)
          {
          fprintf(cgiOut,"ERROR: unable to delet record from %s.<BR>\n",tablename);
          fprintf(cgiOut,"Invalid query = %s<BR>\n",qbuf);
          msqlClose(sock);
          exit(1);
          }
  msqlFreeResult(res);
}
