/*
 * Decompiled with CFR 0.152.
 */
package org.islandoftex.arara.cli;

import com.github.ajalt.clikt.completion.CompletionCandidates;
import com.github.ajalt.clikt.core.BaseCliktCommand;
import com.github.ajalt.clikt.core.BaseCliktCommandKt;
import com.github.ajalt.clikt.core.CliktCommand;
import com.github.ajalt.clikt.core.Context;
import com.github.ajalt.clikt.core.MordantContextKt;
import com.github.ajalt.clikt.core.MordantMarkdownContextKt;
import com.github.ajalt.clikt.core.ProgramResult;
import com.github.ajalt.clikt.core.UsageError;
import com.github.ajalt.clikt.output.MordantHelpFormatter;
import com.github.ajalt.clikt.parameters.arguments.ArgumentKt;
import com.github.ajalt.clikt.parameters.options.FlagOptionKt;
import com.github.ajalt.clikt.parameters.options.OptionCallTransformContext;
import com.github.ajalt.clikt.parameters.options.OptionKt;
import com.github.ajalt.clikt.parameters.options.OptionWithValues;
import com.github.ajalt.clikt.parameters.options.OptionWithValuesKt;
import com.github.ajalt.clikt.parameters.types.IntKt;
import com.github.ajalt.clikt.parameters.types.PathKt;
import com.github.ajalt.clikt.parameters.types.RangeKt;
import com.github.ajalt.mordant.rendering.ThemeBuilder;
import com.github.ajalt.mordant.rendering.ThemeKt;
import com.github.ajalt.mordant.terminal.Terminal;
import io.github.oshai.kotlinlogging.KLogger;
import io.github.oshai.kotlinlogging.KotlinLogging;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.properties.ReadOnlyProperty;
import kotlin.reflect.KProperty;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import kotlin.time.Duration;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import kotlin.time.TimeSource;
import org.islandoftex.arara.api.AraraException;
import org.islandoftex.arara.api.configuration.ExecutionMode;
import org.islandoftex.arara.api.files.FileType;
import org.islandoftex.arara.api.files.MPPPath;
import org.islandoftex.arara.api.files.MPPPathKt;
import org.islandoftex.arara.api.files.Project;
import org.islandoftex.arara.api.files.ProjectFile;
import org.islandoftex.arara.api.localization.MPPLocale;
import org.islandoftex.arara.api.rules.Directive;
import org.islandoftex.arara.api.session.ExecutionReport;
import org.islandoftex.arara.api.session.ExecutionStatus;
import org.islandoftex.arara.cli.CLI$special$;
import org.islandoftex.arara.cli.configuration.ConfigurationUtils;
import org.islandoftex.arara.cli.ruleset.DirectiveUtils;
import org.islandoftex.arara.cli.utils.DisplayUtils;
import org.islandoftex.arara.cli.utils.JVMExtensionsKt;
import org.islandoftex.arara.cli.utils.LoggingUtils;
import org.islandoftex.arara.core.configuration.ExecutionOptions;
import org.islandoftex.arara.core.configuration.LoggingOptions;
import org.islandoftex.arara.core.configuration.UserInterfaceOptions;
import org.islandoftex.arara.core.files.FileSearching;
import org.islandoftex.arara.core.localization.LanguageController;
import org.islandoftex.arara.core.rules.Directives;
import org.islandoftex.arara.core.session.ExecutorHooks;
import org.islandoftex.arara.core.session.LinearExecutor;
import org.islandoftex.arara.core.session.Session;
import org.islandoftex.arara.lua.LuaInterpreter;
import org.islandoftex.arara.mvel.utils.MvelState;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0015\n\u0002\u0010\b\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010$\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u000e\u0010?\u001a\b\u0012\u0004\u0012\u00020@0;H\u0002J\b\u0010A\u001a\u00020BH\u0002J$\u0010C\u001a\b\u0012\u0004\u0012\u00020D0;2\u0006\u0010E\u001a\u00020F2\f\u0010G\u001a\b\u0012\u0004\u0012\u00020D0;H\u0002J\b\u0010H\u001a\u00020BH\u0016R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u001b\u0010\f\u001a\u00020\u00058BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000e\u0010\u000f\u001a\u0004\b\r\u0010\u0007R\u001b\u0010\u0010\u001a\u00020\u00058BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0012\u0010\u000f\u001a\u0004\b\u0011\u0010\u0007R\u001b\u0010\u0013\u001a\u00020\u00058BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0015\u0010\u000f\u001a\u0004\b\u0014\u0010\u0007R\u001b\u0010\u0016\u001a\u00020\u00058BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0018\u0010\u000f\u001a\u0004\b\u0017\u0010\u0007R\u001b\u0010\u0019\u001a\u00020\u00058BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001b\u0010\u000f\u001a\u0004\b\u001a\u0010\u0007R\u001d\u0010\u001c\u001a\u0004\u0018\u00010\t8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001f\u0010\u000f\u001a\u0004\b\u001d\u0010\u001eR\u001d\u0010 \u001a\u0004\u0018\u00010!8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b$\u0010\u000f\u001a\u0004\b\"\u0010#R\u001d\u0010%\u001a\u0004\u0018\u00010\t8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b'\u0010\u000f\u001a\u0004\b&\u0010\u001eR\u001d\u0010(\u001a\u0004\u0018\u00010!8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b*\u0010\u000f\u001a\u0004\b)\u0010#R\u001d\u0010+\u001a\u0004\u0018\u00010,8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b/\u0010\u000f\u001a\u0004\b-\u0010.R'\u00100\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\t018BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b4\u0010\u000f\u001a\u0004\b2\u00103R\u001d\u00105\u001a\u0004\u0018\u0001068BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b9\u0010\u000f\u001a\u0004\b7\u00108R!\u0010:\u001a\b\u0012\u0004\u0012\u00020\t0;8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b>\u0010\u000f\u001a\u0004\b<\u0010=\u00a8\u0006I"}, d2={"Lorg/islandoftex/arara/cli/CLI;", "Lcom/github/ajalt/clikt/core/CliktCommand;", "<init>", "()V", "printHelpOnEmptyArgs", "", "getPrintHelpOnEmptyArgs", "()Z", "help", "", "context", "Lcom/github/ajalt/clikt/core/Context;", "log", "getLog", "log$delegate", "Lkotlin/properties/ReadOnlyProperty;", "verbose", "getVerbose", "verbose$delegate", "dryRun", "getDryRun", "dryRun$delegate", "safeRun", "getSafeRun", "safeRun$delegate", "wholeFile", "getWholeFile", "wholeFile$delegate", "preamble", "getPreamble", "()Ljava/lang/String;", "preamble$delegate", "timeout", "", "getTimeout", "()Ljava/lang/Integer;", "timeout$delegate", "language", "getLanguage", "language$delegate", "maxLoops", "getMaxLoops", "maxLoops$delegate", "workingDirectory", "Ljava/nio/file/Path;", "getWorkingDirectory", "()Ljava/nio/file/Path;", "workingDirectory$delegate", "parameters", "", "getParameters", "()Ljava/util/Map;", "parameters$delegate", "properties", "Ljava/util/Properties;", "getProperties", "()Ljava/util/Properties;", "properties$delegate", "reference", "", "getReference", "()Ljava/util/List;", "reference$delegate", "resolveProjects", "Lorg/islandoftex/arara/api/files/Project;", "updateConfigurationFromCommandLine", "", "prependPreambleDirectives", "Lorg/islandoftex/arara/api/rules/Directive;", "fileType", "Lorg/islandoftex/arara/api/files/FileType;", "directives", "run", "cli"})
@SourceDebugExtension(value={"SMAP\nCLI.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CLI.kt\norg/islandoftex/arara/cli/CLI\n+ 2 Convert.kt\ncom/github/ajalt/clikt/parameters/options/OptionWithValuesKt__ConvertKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 5 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,405:1\n65#2,6:406\n82#2,4:412\n1#3:416\n1563#4:417\n1634#4,3:418\n827#4:421\n855#4,2:422\n216#5,2:424\n216#5,2:426\n*S KotlinDebug\n*F\n+ 1 CLI.kt\norg/islandoftex/arara/cli/CLI\n*L\n138#1:406,6\n138#1:412,4\n206#1:417\n206#1:418,3\n285#1:421\n285#1:422,2\n318#1:424,2\n322#1:426,2\n*E\n"})
public final class CLI
extends CliktCommand {
    static final /* synthetic */ KProperty<Object>[] $$delegatedProperties;
    private final boolean printHelpOnEmptyArgs;
    @NotNull
    private final ReadOnlyProperty log$delegate;
    @NotNull
    private final ReadOnlyProperty verbose$delegate;
    @NotNull
    private final ReadOnlyProperty dryRun$delegate;
    @NotNull
    private final ReadOnlyProperty safeRun$delegate;
    @NotNull
    private final ReadOnlyProperty wholeFile$delegate;
    @NotNull
    private final ReadOnlyProperty preamble$delegate;
    @NotNull
    private final ReadOnlyProperty timeout$delegate;
    @NotNull
    private final ReadOnlyProperty language$delegate;
    @NotNull
    private final ReadOnlyProperty maxLoops$delegate;
    @NotNull
    private final ReadOnlyProperty workingDirectory$delegate;
    @NotNull
    private final ReadOnlyProperty parameters$delegate;
    @NotNull
    private final ReadOnlyProperty properties$delegate;
    @NotNull
    private final ReadOnlyProperty reference$delegate;

    public CLI() {
        super("arara");
        CompletionCandidates completionCandidates;
        BaseCliktCommandKt.context((BaseCliktCommand)this, CLI::_init_$lambda$2);
        MordantMarkdownContextKt.installMordantMarkdown(this);
        this.printHelpOnEmptyArgs = true;
        String[] stringArray = new String[]{"-l", "--log"};
        this.log$delegate = FlagOptionKt.flag$default(OptionWithValuesKt.help(OptionWithValuesKt.option$default(this, stringArray, null, null, false, null, null, null, null, false, 510, null), "Generate a log output"), new String[0], false, null, 6, null).provideDelegate(this, (KProperty<?>)$$delegatedProperties[0]);
        stringArray = new String[]{"-v", "--verbose"};
        OptionWithValues optionWithValues = OptionWithValuesKt.help(OptionWithValuesKt.option$default(this, stringArray, null, null, false, null, null, null, null, false, 510, null), "Print the command output");
        stringArray = new String[]{"-s", "--silent"};
        this.verbose$delegate = FlagOptionKt.flag$default(optionWithValues, stringArray, false, null, 6, null).provideDelegate(this, (KProperty<?>)$$delegatedProperties[1]);
        stringArray = new String[]{"-n", "--dry-run"};
        this.dryRun$delegate = FlagOptionKt.flag$default(OptionWithValuesKt.help(OptionWithValuesKt.option$default(this, stringArray, null, null, false, null, null, null, null, false, 510, null), "Go through all the motions of running a command, but with no actual calls"), new String[0], false, null, 6, null).provideDelegate(this, (KProperty<?>)$$delegatedProperties[2]);
        stringArray = new String[]{"-S", "--safe-run"};
        this.safeRun$delegate = FlagOptionKt.flag$default(OptionWithValuesKt.help(OptionWithValuesKt.option$default(this, stringArray, null, null, false, null, null, null, null, false, 510, null), "Run in safe mode and disable potentially harmful features. Make sure your projects uses only allowed features."), new String[0], false, null, 6, null).provideDelegate(this, (KProperty<?>)$$delegatedProperties[3]);
        stringArray = new String[]{"-w", "--whole-file"};
        this.wholeFile$delegate = FlagOptionKt.flag$default(OptionWithValuesKt.help(OptionWithValuesKt.option$default(this, stringArray, null, null, false, null, null, null, null, false, 510, null), "Extract directives in the file, not only in the header"), new String[0], false, null, 6, null).provideDelegate(this, (KProperty<?>)$$delegatedProperties[4]);
        stringArray = new String[]{"-p", "--preamble"};
        this.preamble$delegate = OptionWithValuesKt.help(OptionWithValuesKt.option$default(this, stringArray, null, null, false, null, null, null, null, false, 510, null), "Set the file preamble based on the configuration file").provideDelegate(this, (KProperty<?>)$$delegatedProperties[5]);
        stringArray = new String[]{"-t", "--timeout"};
        this.timeout$delegate = RangeKt.restrictTo$default(IntKt.int$default(OptionWithValuesKt.help(OptionWithValuesKt.option$default(this, stringArray, null, null, false, null, null, null, null, false, 510, null), "Set the execution timeout (in milliseconds)"), false, 1, null), (Comparable)Integer.valueOf(1), null, false, 6, null).provideDelegate(this, (KProperty<?>)$$delegatedProperties[6]);
        stringArray = new String[]{"-L", "--language"};
        this.language$delegate = OptionWithValuesKt.help(OptionWithValuesKt.option$default(this, stringArray, null, null, false, null, null, null, null, false, 510, null), "Set the application language").provideDelegate(this, (KProperty<?>)$$delegatedProperties[7]);
        stringArray = new String[]{"-m", "--max-loops"};
        this.maxLoops$delegate = RangeKt.restrictTo$default(IntKt.int$default(OptionWithValuesKt.help(OptionWithValuesKt.option$default(this, stringArray, null, null, false, null, null, null, null, false, 510, null), "Set the maximum number of loops (> 0)"), false, 1, null), (Comparable)Integer.valueOf(1), null, false, 6, null).provideDelegate(this, (KProperty<?>)$$delegatedProperties[8]);
        stringArray = new String[]{"-d", "--working-directory"};
        this.workingDirectory$delegate = PathKt.path$default(OptionWithValuesKt.help(OptionWithValuesKt.option$default(this, stringArray, null, null, false, null, null, null, null, false, 510, null), "Set the working directory for all tools"), true, false, false, false, true, false, null, 108, null).provideDelegate(this, (KProperty<?>)$$delegatedProperties[9]);
        stringArray = new String[]{"-P", "--call-property"};
        this.parameters$delegate = OptionWithValuesKt.associate$default(OptionWithValuesKt.help(OptionWithValuesKt.option$default(this, stringArray, null, null, false, null, null, null, null, false, 510, null), "Pass parameters to the application to be used within the session."), null, 1, null).provideDelegate(this, (KProperty<?>)$$delegatedProperties[10]);
        stringArray = new String[]{"-F", "--properties-file"};
        OptionWithValues $this$convert_u24default$iv = PathKt.path$default(OptionWithValuesKt.help(OptionWithValuesKt.option$default(this, stringArray, null, null, false, null, null, null, null, false, 510, null), "Pass a properties file to the application to be used within the session."), true, false, false, false, true, false, null, 106, null);
        Function1 metavar$iv = special$$inlined$convert$default$1.INSTANCE;
        Object completionCandidates$iv = null;
        boolean $i$f$convert = false;
        Function2 valueTransform$iv = new Function2<OptionCallTransformContext, String, Properties>($this$convert_u24default$iv){
            final /* synthetic */ OptionWithValues $this_convert;
            {
                this.$this_convert = $receiver;
            }

            /*
             * WARNING - void declaration
             */
            public final Properties invoke(OptionCallTransformContext optionCallTransformContext, String it) {
                Properties properties;
                Intrinsics.checkNotNullParameter(optionCallTransformContext, "<this>");
                Intrinsics.checkNotNullParameter(it, "it");
                try {
                    void it2;
                    Properties properties2;
                    Path path2 = (Path)this.$this_convert.getTransformValue().invoke(optionCallTransformContext, it);
                    OptionCallTransformContext $this$properties_delegate_u24lambda_u245 = optionCallTransformContext;
                    boolean bl = false;
                    Properties $this$properties_delegate_u24lambda_u245_u24lambda_u244 = properties2 = new Properties();
                    boolean bl2 = false;
                    JVMExtensionsKt.load$default($this$properties_delegate_u24lambda_u245_u24lambda_u244, (Path)it2, null, 2, null);
                    properties = properties2;
                }
                catch (UsageError err) {
                    UsageError usageError = err;
                    String string = err.getParamName();
                    if (string == null) {
                        void n;
                        String string2;
                        String string3 = string2 = optionCallTransformContext.getName();
                        UsageError usageError2 = usageError;
                        boolean bl = false;
                        boolean bl3 = ((CharSequence)n).length() == 0;
                        usageError = usageError2;
                        string = !bl3 ? string2 : null;
                        if (string == null) {
                            string = OptionKt.longestName(optionCallTransformContext.getOption());
                        }
                    }
                    usageError.setParamName(string);
                    throw err;
                }
                catch (Exception err) {
                    String string = err.getMessage();
                    if (string == null) {
                        string = "";
                    }
                    optionCallTransformContext.fail(string);
                    throw new KotlinNothingValueException();
                }
                return properties;
            }
        };
        Function2 function2 = OptionWithValuesKt.defaultEachProcessor();
        Function2 function22 = OptionWithValuesKt.defaultAllProcessor();
        Function2 function23 = OptionWithValuesKt.defaultValidator();
        Function1 function1 = $this$convert_u24default$iv.getMetavarGetter();
        if (function1 == null) {
            function1 = metavar$iv;
        }
        if ((completionCandidates = $this$convert_u24default$iv.getExplicitCompletionCandidates()) == null) {
            completionCandidates = completionCandidates$iv;
        }
        this.properties$delegate = OptionWithValues.DefaultImpls.copy$default($this$convert_u24default$iv, valueTransform$iv, function2, function22, function23, null, function1, null, null, false, null, null, null, null, completionCandidates, null, false, false, false, 253904, null).provideDelegate(this, (KProperty<?>)$$delegatedProperties[11]);
        this.reference$delegate = (ReadOnlyProperty)ArgumentKt.multiple$default(ArgumentKt.help(ArgumentKt.argument$default(this, "file", null, null, null, 14, null), "The file(s) to evaluate and process"), true, null, 2, null).provideDelegate(this, $$delegatedProperties[12]);
    }

    @Override
    public boolean getPrintHelpOnEmptyArgs() {
        return this.printHelpOnEmptyArgs;
    }

    @Override
    @NotNull
    public String help(@NotNull Context context2) {
        Intrinsics.checkNotNullParameter(context2, "context");
        return StringsKt.trimMargin("\n        @```\n        " + SequencesKt.joinToString$default(StringsKt.lineSequence(DisplayUtils.INSTANCE.getLogoString()), "\n", null, null, 0, null, CLI::help$lambda$3, 30, null) + "\n        @```\n        @\n        @The cool TeX automation tool.\n        @\n        @arara executes the TeX workflow you tell it to execute. Simply specify\n        your needs within your TeX file and let arara do the work. These directives\n        feature conditional execution and parameter expansion.\n    ", "@");
    }

    private final boolean getLog() {
        return (Boolean)this.log$delegate.getValue(this, $$delegatedProperties[0]);
    }

    private final boolean getVerbose() {
        return (Boolean)this.verbose$delegate.getValue(this, $$delegatedProperties[1]);
    }

    private final boolean getDryRun() {
        return (Boolean)this.dryRun$delegate.getValue(this, $$delegatedProperties[2]);
    }

    private final boolean getSafeRun() {
        return (Boolean)this.safeRun$delegate.getValue(this, $$delegatedProperties[3]);
    }

    private final boolean getWholeFile() {
        return (Boolean)this.wholeFile$delegate.getValue(this, $$delegatedProperties[4]);
    }

    private final String getPreamble() {
        return (String)this.preamble$delegate.getValue(this, $$delegatedProperties[5]);
    }

    private final Integer getTimeout() {
        return (Integer)this.timeout$delegate.getValue(this, $$delegatedProperties[6]);
    }

    private final String getLanguage() {
        return (String)this.language$delegate.getValue(this, $$delegatedProperties[7]);
    }

    private final Integer getMaxLoops() {
        return (Integer)this.maxLoops$delegate.getValue(this, $$delegatedProperties[8]);
    }

    private final Path getWorkingDirectory() {
        return (Path)this.workingDirectory$delegate.getValue(this, $$delegatedProperties[9]);
    }

    private final Map<String, String> getParameters() {
        return (Map)this.parameters$delegate.getValue(this, $$delegatedProperties[10]);
    }

    private final Properties getProperties() {
        return (Properties)this.properties$delegate.getValue(this, $$delegatedProperties[11]);
    }

    private final List<String> getReference() {
        return (List)this.reference$delegate.getValue(this, $$delegatedProperties[12]);
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final List<Project> resolveProjects() {
        Collection<ProjectFile> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Object it;
        org.islandoftex.arara.core.files.Project project;
        List<org.islandoftex.arara.core.files.Project> list;
        Object object = this.getWorkingDirectory();
        if (object == null || (object = MPPPathKt.toMPPPath((Path)object)) == null) {
            object = new MPPPath(".");
        }
        MPPPath workingDir = ((MPPPath)object).normalize();
        String string = CollectionsKt.singleOrNull(this.getReference());
        if (string != null) {
            String string2;
            Object object2 = string;
            String it2 = object2;
            boolean bl = false;
            String string3 = string2 = StringsKt.endsWith$default(((Object)StringsKt.trim((CharSequence)it2)).toString(), ".lua", false, 2, null) ? object2 : null;
            if (string2 != null) {
                String it3 = string2;
                boolean bl2 = false;
                object2 = workingDir.resolve(it3);
                if (object2 != null) {
                    Object object3;
                    Object object4;
                    Object it4 = object4 = object2;
                    boolean bl3 = false;
                    Object object5 = object3 = ((MPPPath)it4).getExists() ? object4 : null;
                    if (object3 != null && (object4 = ((MPPPath)object3).readText()) != null) {
                        List<org.islandoftex.arara.core.files.Project> list2;
                        Object object6;
                        Object $i$a$-runCatching-CLI$resolveProjects$4$22;
                        Object luaScript = object4;
                        boolean bl4 = false;
                        KLogger logger = KotlinLogging.INSTANCE.logger(CLI::resolveProjects$lambda$14$lambda$9);
                        try {
                            boolean $i$a$-runCatching-CLI$resolveProjects$4$22 = false;
                            logger.info(CLI::resolveProjects$lambda$14$lambda$11$lambda$10);
                            $i$a$-runCatching-CLI$resolveProjects$4$22 = Result.constructor-impl(new LuaInterpreter(workingDir).parseProjectsFromLua((String)luaScript));
                        }
                        catch (Throwable throwable) {
                            $i$a$-runCatching-CLI$resolveProjects$4$22 = Result.constructor-impl(ResultKt.createFailure(throwable));
                        }
                        Throwable throwable = Result.exceptionOrNull-impl($i$a$-runCatching-CLI$resolveProjects$4$22);
                        if (throwable == null) {
                            object6 = $i$a$-runCatching-CLI$resolveProjects$4$22;
                        } else {
                            Throwable it5 = throwable;
                            boolean bl5 = false;
                            if (it5 instanceof AraraException) {
                                DisplayUtils.INSTANCE.printWrapped("Found Lua file, attempted to parse it as a project but failed. Continuing by treating the Lua file as regular input. See log for details.\n");
                                logger.info(() -> CLI.resolveProjects$lambda$14$lambda$13$lambda$12(it5));
                            }
                            object6 = null;
                        }
                        if ((list2 = (List<org.islandoftex.arara.core.files.Project>)object6) != null) {
                            list = list2;
                            return list;
                        }
                    }
                }
            }
        }
        org.islandoftex.arara.core.files.Project project2 = project = new org.islandoftex.arara.core.files.Project("Untitled", workingDir, SetsKt.emptySet(), null, 8, null);
        boolean bl = false;
        MPPPath mPPPath = ConfigurationUtils.INSTANCE.configFileForProject(project2);
        if (mPPPath != null) {
            it = mPPPath;
            boolean bl6 = false;
            DisplayUtils.INSTANCE.setConfigurationFileName(((MPPPath)it).toString());
            ConfigurationUtils.INSTANCE.load((MPPPath)it, project2);
        }
        project2 = project;
        boolean bl7 = false;
        it = this.getReference();
        MPPPath mPPPath2 = project2.getWorkingDirectory();
        String string4 = project2.getName();
        boolean $i$f$map = false;
        void var16_23 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void fileName;
            String string5 = (String)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl8 = false;
            collection.add(FileSearching.INSTANCE.resolveFile((String)fileName, workingDir, LinearExecutor.INSTANCE.getExecutionOptions()));
        }
        collection = (List)destination$iv$iv;
        DefaultConstructorMarker defaultConstructorMarker = null;
        int n = 8;
        Set set = null;
        Set set2 = CollectionsKt.toSet((Iterable)collection);
        MPPPath mPPPath3 = mPPPath2;
        String string6 = string4;
        list = CollectionsKt.listOf(new org.islandoftex.arara.core.files.Project(string6, mPPPath3, set2, set, n, defaultConstructorMarker));
        return list;
    }

    /*
     * WARNING - void declaration
     */
    private final void updateConfigurationFromCommandLine() {
        long l;
        MPPLocale mPPLocale;
        int n;
        Object object;
        Session session = Session.INSTANCE;
        String string = this.getLanguage();
        if (string != null) {
            void it;
            String string2 = string;
            object = session;
            n = 0;
            mPPLocale = new MPPLocale((String)it);
            session = object;
        } else {
            mPPLocale = Session.INSTANCE.getUserInterfaceOptions().getLocale();
        }
        DefaultConstructorMarker defaultConstructorMarker = null;
        int n2 = 4;
        int n3 = 0;
        String string3 = Session.INSTANCE.getUserInterfaceOptions().getSwingLookAndFeel();
        MPPLocale mPPLocale2 = mPPLocale;
        session.setUserInterfaceOptions(new UserInterfaceOptions(mPPLocale2, string3, n3, n2, defaultConstructorMarker));
        LanguageController.loadMessagesFor(Session.INSTANCE.getUserInterfaceOptions().getLocale());
        Object object2 = LinearExecutor.INSTANCE;
        ExecutionOptions executionOptions = ExecutionOptions.Companion.from(LinearExecutor.INSTANCE.getExecutionOptions());
        Integer n4 = this.getMaxLoops();
        int n5 = n4 != null ? n4.intValue() : LinearExecutor.INSTANCE.getExecutionOptions().getMaxLoops();
        Integer n6 = this.getTimeout();
        if (n6 != null) {
            void it;
            n = ((Number)n6).intValue();
            int n7 = n5;
            ExecutionOptions executionOptions2 = executionOptions;
            object = object2;
            boolean bl = false;
            long l2 = DurationKt.toDuration((int)it, DurationUnit.MILLISECONDS);
            object2 = object;
            executionOptions = executionOptions2;
            n5 = n7;
            l = l2;
        } else {
            l = LinearExecutor.INSTANCE.getExecutionOptions().getTimeoutValue-UwyO8pc();
        }
        ((LinearExecutor)object2).setExecutionOptions(ExecutionOptions.copy-k5Tw5DY$default(executionOptions, n5, l, false, false, null, this.getVerbose() ? true : LinearExecutor.INSTANCE.getExecutionOptions().getVerbose(), this.getDryRun() ? ExecutionMode.DRY_RUN : (this.getSafeRun() ? ExecutionMode.SAFE_RUN : LinearExecutor.INSTANCE.getExecutionOptions().getExecutionMode()), null, null, this.getWholeFile() ? false : LinearExecutor.INSTANCE.getExecutionOptions().getParseOnlyHeader(), 412, null));
        Session.INSTANCE.setLoggingOptions(new LoggingOptions(this.getLog() ? true : Session.INSTANCE.getLoggingOptions().getEnableLogging(), Session.INSTANCE.getLoggingOptions().getAppendLog(), Session.INSTANCE.getLoggingOptions().getLogFile()));
    }

    /*
     * Unable to fully structure code
     */
    private final List<Directive> prependPreambleDirectives(FileType fileType, List<? extends Directive> directives) {
        v0 = this.getPreamble();
        if (v0 == null) {
            v0 = MvelState.INSTANCE.getDefaultPreamble();
        }
        if ((resolvedPreamble = v0) != null && !MvelState.INSTANCE.getPreambles().containsKey(resolvedPreamble)) {
            var4_4 = LanguageController.getMessages().getERROR_PARSER_INVALID_PREAMBLE();
            var5_6 = new Object[]{resolvedPreamble};
            v1 = String.format(var4_4, Arrays.copyOf(var5_6, var5_6.length));
            Intrinsics.checkNotNullExpressionValue(v1, "format(...)");
            throw new AraraException(v1);
        }
        if (resolvedPreamble == null) ** GOTO lbl-1000
        var6_8 = resolvedPreamble;
        it = var6_8;
        $i$a$-takeIf-CLI$prependPreambleDirectives$allDirectives$1 = false;
        v2 = var5_7 = MvelState.INSTANCE.getPreambles().containsKey(it) != false ? var6_8 : null;
        if (var5_7 == null) ** GOTO lbl-1000
        preambleName = var5_7;
        $i$a$-let-CLI$prependPreambleDirectives$allDirectives$2 = false;
        var10_13 = StringsKt.lines(MapsKt.getValue(MvelState.INSTANCE.getPreambles(), preambleName));
        $i$f$filterNot = false;
        var12_15 = $this$filterNot$iv;
        destination$iv$iv = new ArrayList<E>();
        $i$f$filterNotTo = false;
        for (T element$iv$iv : $this$filterNotTo$iv$iv) {
            it = (String)element$iv$iv;
            $i$a$-filterNot-CLI$prependPreambleDirectives$allDirectives$2$1 = false;
            if (((CharSequence)it).length() == 0) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        var6_8 = CollectionsKt.plus((Collection)Directives.extractDirectives((List)destination$iv$iv, true, fileType), (Iterable)directives);
        if (var6_8 != null) {
            v3 = var6_8;
        } else lbl-1000:
        // 3 sources

        {
            v3 = allDirectives = directives;
        }
        if (allDirectives.isEmpty()) {
            throw new AraraException(LanguageController.getMessages().getERROR_VALIDATE_NO_DIRECTIVES_FOUND());
        }
        return allDirectives;
    }

    @Override
    public void run() {
        ExecutionStatus executionStatus;
        Object object;
        LoggingUtils.INSTANCE.init();
        System.out.println((Object)(DisplayUtils.INSTANCE.getLogoString() + "\n"));
        long executionStart = TimeSource.Monotonic.INSTANCE.markNow-z9LOYto();
        this.updateConfigurationFromCommandLine();
        LoggingUtils.INSTANCE.setupLogging(Session.INSTANCE.getLoggingOptions());
        Map<Object, Object> map2 = this.getProperties();
        if (map2 != null && (map2 = JVMExtensionsKt.toMap((Properties)map2)) != null) {
            Map<Object, Object> $this$forEach$iv = map2;
            boolean bl = false;
            object = $this$forEach$iv.entrySet().iterator();
            while (object.hasNext()) {
                Map.Entry<Object, Object> element$iv;
                Map.Entry<Object, Object> entry = element$iv = object.next();
                boolean bl2 = false;
                String key = (String)entry.getKey();
                String value = (String)entry.getValue();
                Session.INSTANCE.put("arg:" + key, value);
            }
        }
        Map<String, String> $this$forEach$iv = this.getParameters();
        boolean $i$f$forEach = false;
        for (Map.Entry entry : $this$forEach$iv.entrySet()) {
            object = entry;
            boolean bl = false;
            String key = (String)object.getKey();
            String value = (String)object.getValue();
            Session.INSTANCE.put("arg:" + key, value);
        }
        try {
            LinearExecutor.INSTANCE.setHooks(new ExecutorHooks(CLI::run$lambda$26, null, CLI::run$lambda$27, null, arg_0 -> CLI.run$lambda$28(this, arg_0), CLI::run$lambda$29, (arg_0, arg_1) -> CLI.run$lambda$31(this, arg_0, arg_1), 10, null));
            List<Project> projects = this.resolveProjects();
            executionStatus = LinearExecutor.INSTANCE.execute(projects).getExitCode() != 0 ? (ExecutionStatus)new ExecutionStatus.ExternalCallFailed() : (ExecutionStatus)new ExecutionStatus.Processing();
        }
        catch (AraraException ex) {
            DisplayUtils.INSTANCE.printException(ex);
            executionStatus = new ExecutionStatus.CaughtException();
        }
        ExecutionStatus executionStatus2 = executionStatus;
        boolean bl = false;
        DisplayUtils.INSTANCE.printTime(Duration.toDouble-impl(TimeSource.Monotonic.ValueTimeMark.elapsedNow-UwyO8pc(executionStart), DurationUnit.SECONDS));
        throw new ProgramResult(executionStatus2.getExitCode());
    }

    private static final Unit lambda$2$lambda$0(ThemeBuilder $this$Theme) {
        Intrinsics.checkNotNullParameter($this$Theme, "$this$Theme");
        $this$Theme.getFlags().put("markdown.code.block.border", false);
        return Unit.INSTANCE;
    }

    private static final MordantHelpFormatter lambda$2$lambda$1(Context it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return new MordantHelpFormatter(it, null, false, false, 14, null);
    }

    private static final Unit _init_$lambda$2(Context.Builder $this$context) {
        Intrinsics.checkNotNullParameter($this$context, "$this$context");
        MordantContextKt.setTerminal($this$context, new Terminal(null, ThemeKt.Theme$default(null, CLI::lambda$2$lambda$0, 1, null), null, null, null, null, null, 0, null, null, 1021, null));
        $this$context.setHelpFormatter(CLI::lambda$2$lambda$1);
        return Unit.INSTANCE;
    }

    private static final CharSequence help$lambda$3(String it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return "@" + it;
    }

    private static final Unit resolveProjects$lambda$14$lambda$9() {
        return Unit.INSTANCE;
    }

    private static final Object resolveProjects$lambda$14$lambda$11$lambda$10() {
        return "Guessing provided Lua file is a project specification, trying to extract information from that.";
    }

    private static final Object resolveProjects$lambda$14$lambda$13$lambda$12(Throwable $it) {
        return "Failed to parse Lua file argument as project: " + $it.getMessage() + "\nThis file is now treated as regular input file. If it is a project specification, please fix the errors above.";
    }

    private static final Unit run$lambda$26() {
        Session.updateEnvironmentVariables$default(Session.INSTANCE, null, null, 3, null);
        DirectiveUtils.INSTANCE.initializeDirectiveCore();
        return Unit.INSTANCE;
    }

    private static final Unit run$lambda$27(Project it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return Unit.INSTANCE;
    }

    private static final Unit run$lambda$28(CLI this$0, ProjectFile it) {
        Intrinsics.checkNotNullParameter(it, "it");
        this$0.updateConfigurationFromCommandLine();
        JVMExtensionsKt.printFileInformation(it);
        return Unit.INSTANCE;
    }

    private static final Unit run$lambda$29(ExecutionReport it) {
        Intrinsics.checkNotNullParameter(it, "it");
        System.out.println();
        return Unit.INSTANCE;
    }

    private static final List run$lambda$31(CLI this$0, ProjectFile file, List list) {
        List<Directive> list2;
        Intrinsics.checkNotNullParameter(file, "file");
        Intrinsics.checkNotNullParameter(list, "list");
        List<Directive> list3 = list2 = list;
        ProjectFile projectFile = file;
        DirectiveUtils directiveUtils = DirectiveUtils.INSTANCE;
        boolean bl = false;
        boolean bl2 = !((Collection)list).isEmpty() && !MvelState.INSTANCE.getPrependPreambleIfDirectivesGiven();
        List<Directive> list4 = bl2 ? list2 : null;
        if (list4 == null) {
            list4 = this$0.prependPreambleDirectives(file.getFileType(), (List<? extends Directive>)list);
        }
        return directiveUtils.process(projectFile, (List<? extends Directive>)list4);
    }

    static {
        KProperty[] kPropertyArray = new KProperty[]{Reflection.property1(new PropertyReference1Impl(CLI.class, "log", "getLog()Z", 0)), Reflection.property1(new PropertyReference1Impl(CLI.class, "verbose", "getVerbose()Z", 0)), Reflection.property1(new PropertyReference1Impl(CLI.class, "dryRun", "getDryRun()Z", 0)), Reflection.property1(new PropertyReference1Impl(CLI.class, "safeRun", "getSafeRun()Z", 0)), Reflection.property1(new PropertyReference1Impl(CLI.class, "wholeFile", "getWholeFile()Z", 0)), Reflection.property1(new PropertyReference1Impl(CLI.class, "preamble", "getPreamble()Ljava/lang/String;", 0)), Reflection.property1(new PropertyReference1Impl(CLI.class, "timeout", "getTimeout()Ljava/lang/Integer;", 0)), Reflection.property1(new PropertyReference1Impl(CLI.class, "language", "getLanguage()Ljava/lang/String;", 0)), Reflection.property1(new PropertyReference1Impl(CLI.class, "maxLoops", "getMaxLoops()Ljava/lang/Integer;", 0)), Reflection.property1(new PropertyReference1Impl(CLI.class, "workingDirectory", "getWorkingDirectory()Ljava/nio/file/Path;", 0)), Reflection.property1(new PropertyReference1Impl(CLI.class, "parameters", "getParameters()Ljava/util/Map;", 0)), Reflection.property1(new PropertyReference1Impl(CLI.class, "properties", "getProperties()Ljava/util/Properties;", 0)), Reflection.property1(new PropertyReference1Impl(CLI.class, "reference", "getReference()Ljava/util/List;", 0))};
        $$delegatedProperties = kPropertyArray;
    }
}

