untrusted comment: verify with openbsd-77-base.pub
RWSbCCUoGpcxVRvnG1003PNnrDtlQc9hdkcmKbBy40goFqDdkJiCNcT/Cly1KmvaIkhgMtRY4OLkT2Z0wIcucg3C7G0XVMk5/QM=

OpenBSD 7.7 errata 007, June 1, 2025:

Previous fix for X11 server was incomplete.  
CVE-2025-49176

Apply by doing:
    signify -Vep /etc/signify/openbsd-77-base.pub -x 007_xserver.patch.sig \
        -m - | (cd /usr/xenocara && patch -p0)

And then rebuild and install the X server:
    cd /usr/xenocara/xserver
    make -f Makefile.bsd-wrapper obj
    make -f Makefile.bsd-wrapper build

Index: xserver/os/io.c
===================================================================
RCS file: /cvs/xenocara/xserver/os/io.c,v
diff -u -p -r1.19.8.1 io.c
--- xserver/os/io.c	17 Jun 2025 13:18:36 -0000	1.19.8.1
+++ xserver/os/io.c	19 Jun 2025 16:47:20 -0000
@@ -395,6 +395,8 @@ ReadRequestFromClient(ClientPtr client)
                     needed = get_big_req_len(request, client);
             }
             client->req_len = needed;
+            if (needed > MAXINT >> 2)
+                return -(BadLength);
             needed <<= 2;
         }
         if (gotnow < needed) {
