import { Events as AdapterEvents } from '../../adapter';
import * as Zcl from '../../zspec/zcl';
import { ClusterDefinition, CustomClusters } from '../../zspec/zcl/definition/tstype';
import { ControllerEventMap } from '../controller';
import { DeviceType, KeyValue } from '../tstype';
import Endpoint from './endpoint';
import Entity from './entity';
interface LQI {
    neighbors: {
        ieeeAddr: string;
        networkAddress: number;
        linkquality: number;
        relationship: number;
        depth: number;
    }[];
}
interface RoutingTable {
    table: {
        destinationAddress: number;
        status: string;
        nextHop: number;
    }[];
}
type CustomReadResponse = (frame: Zcl.Frame, endpoint: Endpoint) => boolean;
export declare class Device extends Entity<ControllerEventMap> {
    private readonly ID;
    private _applicationVersion?;
    private _dateCode?;
    private _endpoints;
    private _hardwareVersion?;
    private _ieeeAddr;
    private _interviewCompleted;
    private _interviewing;
    private _lastSeen?;
    private _manufacturerID?;
    private _manufacturerName?;
    private _modelID?;
    private _networkAddress;
    private _powerSource?;
    private _softwareBuildID?;
    private _stackVersion?;
    private _type;
    private _zclVersion?;
    private _linkquality?;
    private _skipDefaultResponse;
    private _customReadResponse?;
    private _lastDefaultResponseSequenceNumber?;
    private _checkinInterval?;
    private _pendingRequestTimeout;
    private _customClusters;
    get ieeeAddr(): string;
    set ieeeAddr(ieeeAddr: string);
    get applicationVersion(): number | undefined;
    set applicationVersion(applicationVersion: number);
    get endpoints(): Endpoint[];
    get interviewCompleted(): boolean;
    get interviewing(): boolean;
    get lastSeen(): number | undefined;
    get manufacturerID(): number | undefined;
    get isDeleted(): boolean;
    set type(type: DeviceType);
    get type(): DeviceType;
    get dateCode(): string | undefined;
    set dateCode(dateCode: string);
    set hardwareVersion(hardwareVersion: number);
    get hardwareVersion(): number | undefined;
    get manufacturerName(): string | undefined;
    set manufacturerName(manufacturerName: string | undefined);
    set modelID(modelID: string);
    get modelID(): string | undefined;
    get networkAddress(): number;
    set networkAddress(networkAddress: number);
    get powerSource(): string | undefined;
    set powerSource(powerSource: string);
    get softwareBuildID(): string | undefined;
    set softwareBuildID(softwareBuildID: string);
    get stackVersion(): number | undefined;
    set stackVersion(stackVersion: number);
    get zclVersion(): number | undefined;
    set zclVersion(zclVersion: number);
    get linkquality(): number | undefined;
    set linkquality(linkquality: number);
    get skipDefaultResponse(): boolean;
    set skipDefaultResponse(skipDefaultResponse: boolean);
    get customReadResponse(): CustomReadResponse | undefined;
    set customReadResponse(customReadResponse: CustomReadResponse | undefined);
    get checkinInterval(): number | undefined;
    set checkinInterval(checkinInterval: number | undefined);
    get pendingRequestTimeout(): number;
    set pendingRequestTimeout(pendingRequestTimeout: number);
    get customClusters(): CustomClusters;
    meta: KeyValue;
    private static readonly devices;
    private static loadedFromDatabase;
    private static readonly deletedDevices;
    private static readonly nwkToIeeeCache;
    static readonly ReportablePropertiesMapping: {
        [s: string]: {
            set: (value: string | number, device: Device) => void;
            key: 'modelID' | 'manufacturerName' | 'applicationVersion' | 'zclVersion' | 'powerSource' | 'stackVersion' | 'dateCode' | 'softwareBuildID' | 'hardwareVersion';
        };
    };
    private constructor();
    createEndpoint(ID: number): Endpoint;
    changeIeeeAddress(ieeeAddr: string): void;
    getEndpoint(ID: number): Endpoint | undefined;
    getEndpointByDeviceType(deviceType: string): Endpoint | undefined;
    implicitCheckin(): void;
    updateLastSeen(): void;
    private resetPendingRequestTimeout;
    private hasPendingRequests;
    onZclData(dataPayload: AdapterEvents.ZclPayload, frame: Zcl.Frame, endpoint: Endpoint): Promise<void>;
    /**
     * Reset runtime lookups.
     */
    static resetCache(): void;
    private static fromDatabaseEntry;
    private toDatabaseEntry;
    save(writeDatabase?: boolean): void;
    private static loadFromDatabaseIfNecessary;
    static find(ieeeOrNwkAddress: string | number, includeDeleted?: boolean): Device | undefined;
    static byIeeeAddr(ieeeAddr: string, includeDeleted?: boolean): Device | undefined;
    static byNetworkAddress(networkAddress: number, includeDeleted?: boolean): Device | undefined;
    static byType(type: DeviceType): Device[];
    /**
     * @deprecated use allIterator()
     */
    static all(): Device[];
    static allIterator(predicate?: (value: Device) => boolean): Generator<Device>;
    undelete(interviewCompleted?: boolean): void;
    static create(type: DeviceType, ieeeAddr: string, networkAddress: number, manufacturerID: number | undefined, manufacturerName: string | undefined, powerSource: string | undefined, modelID: string | undefined, interviewCompleted: boolean): Device;
    interview(ignoreCache?: boolean): Promise<void>;
    private interviewQuirks;
    private interviewInternal;
    updateNodeDescriptor(): Promise<void>;
    updateActiveEndpoints(): Promise<void>;
    /**
     * Request device to advertise its network address.
     * Note: This does not actually update the device property (if needed), as this is already done with `zdoResponse` event in Controller.
     */
    requestNetworkAddress(): Promise<void>;
    removeFromNetwork(): Promise<void>;
    removeFromDatabase(): void;
    lqi(): Promise<LQI>;
    routingTable(): Promise<RoutingTable>;
    ping(disableRecovery?: boolean): Promise<void>;
    addCustomCluster(name: string, cluster: ClusterDefinition): void;
}
export default Device;
//# sourceMappingURL=device.d.ts.map