#ifndef _LINUXMT_TIMEX_H
#define _LINUXMT_TIMEX_H

/*
 *	We don't support the complex PLL time loops on Linux 8086
 *	100Hz fixed is more than good enough for us.
 */
 
#define HZ 100
#define CLOCK_TICK_RATE	1193180 /* Underlying HZ */
#define CLOCK_TICK_FACTOR	20	/* Factor of both 1000000 and CLOCK_TICK_RATE */
#define LATCH  ((CLOCK_TICK_RATE + HZ/2) / HZ)	/* For divider */

#endif /* LINUXMT_TIMEX_H */
