/* This file is part of the Project Athena Zephyr Notification System.
 * It contains a panic description for the windowgram COMPILER.
 *
 *	Created by:	Mark W Eichin
 *
 *	$Source: /mit/zephyr/src/zwgc/RCS/panic_desc.c,v $
 *	$Author: eichin $
 *
 *	Copyright (c) 1987 by the Massachusetts Institute of Technology.
 *	For copying and distribution information, see the file
 *	"mit-copyright.h". 
 */

#include <zephyr/mit-copyright.h>

#ifndef lint
static char rcsid_panic_desc_c[] = "$Header: panic_desc.c,v 2.3 88/07/06 16:16:08 eichin Exp $";
#endif lint

char panic_desc[] = {
"show\n\
Missing system default file! Message contains:\n\
	kind: $kind, port: $port, auth: $auth\n\
	Class.instance: $class .$instance\n\
	Opcode: $opcode\n\
	Sender: $sender\n\
	Recipient: $recipient\n\
	Message body:\n\
	$message\n\
	Default description:\n\
	$default\n\
endshow\n\
summary $class.$instance $sender\n"
};

char blank_desc[] = {
"show\n\
Completely Null Description for message. Message contains:\n\
	kind: $kind, port: $port, auth: $auth\n\
	Class.instance: $class .$instance\n\
	Opcode: $opcode\n\
	Sender: $sender\n\
	Recipient: $recipient\n\
	Message body:\n\
	$message\n\
	Default description:\n\
	$default\n\
endshow\n\
summary $class.$instance $sender\n"
};
