#include <stdio.h>
#include <signal.h>
#include <fcntl.h>
#include <string.h>
#include <sys/wait.h>
#include <arpa/telnet.h>
#include "bb.h"
#include "mesg.h"
#include "Parse.h"

extern int currentfolder,last_mesg;
extern int internet;
extern int new_mail_waiting;
extern int idle_count;
extern int remote;
extern FILE *output;
extern int busy; /* if true dont display messages  i.e. during new/write */

extern struct person *user;
extern struct folder *fold;
extern long userposn;
extern unsigned long loggedin; 

static char buff[1024];

void c_help(CommandList *cm, int argc, char **argv)
{
	if (argc>1)
		help(argv[1],u_god(user->status));
	else
		help_list();
}

void c_cd(CommandList *cm, int argc, char **argv)
{
	int i;
	if ((i=foldernumber(argv[1]))==-1)
		printf("Unknown foldername.\n");
    	else
    	{
		get_folder_number(fold,i);
		if(!f_active(fold->status) || (!allowed_r(fold,user) && !allowed_w(fold,user)))
		{
			printf("Unknown foldername.\n");
			get_folder_number(fold,currentfolder);
		}
		else
		{
			printf("Changing to folder %s.\n",fold->name);
			currentfolder=i;
			last_mesg=0;
		}
	}
}


void c_addfol(CommandList *cm, int argc, char **argv)
{
	add_folder();
}

void c_listnew(CommandList *cm, int argc, char **argv)
{
	list_new_items(user,TRUE);
}

void c_listall(CommandList *cm, int argc, char **argv)
{
	list_new_items(user,FALSE);
}

void c_new(CommandList *cm, int argc, char **argv)
{
	sprintf(buff,"Reading New Messages");
	strcpy(user->doing,buff);
	update_user(user,userposn);
	busy=1;
	new(user);
	DisplayStack();
	busy=0;
	get_folder_number(fold,currentfolder);
	update_user(user,userposn);
}


void c_last(CommandList *cm, int argc, char **argv)
{
	last_mesg=fold->last;
	printf("Moved to end of folder. (message %d)\n",last_mesg);
	read_msg(currentfolder,last_mesg,user);

	sprintf(buff,"Reading folder %s",fold->name);
	strcpy(user->doing,buff);

}

void c_first(CommandList *cm, int argc, char **argv)
{
	last_mesg=fold->first;
	printf("Moved to start of folder. (message %d)\n",last_mesg);
	read_msg(currentfolder,last_mesg,user);

	sprintf(buff,"Reading folder %s",fold->name);
	strcpy(user->doing,buff);
}

void c_user(CommandList *cm, int argc, char **argv)
{
	sprintf(buff,"Editing User %s",argv[2]);
	strcpy(user->doing,buff);
	update_user(user,userposn);
	busy=1;
	edit_user(argv[1],argv[2]);
	busy=0;
	DisplayStack();
}


void c_search(CommandList *cm, int argc, char **argv)
{
	sprintf(buff,"Searching Users");
	strcpy(user->doing,buff);
	update_user(user,userposn);

	search(argv[1],argv[2]);
}

void c_folder(CommandList *cm, int argc, char **argv)
{
	sprintf(buff,"Editing folder %s",fold->name);
	strcpy(user->doing,buff);
	update_user(user,userposn);

	edit_folder(argv[1],argv[2]);
}

void c_msg(CommandList *cm, int argc, char **argv)
{
	int z=BoolOpt(argv[1]);
	if (z==0)
	{
		if (!u_mesg(user->status))
		{
			user->status|=(1<<4);
			printf("Messages are now off.\n");
		}else
			printf("Messages are already off.\n");
	}else
	if (z==1)
	{
		if (u_mesg(user->status))
		{
			user->status&=~(1<<4);
			printf("Messages are now on.\n");
		}else
			printf("Messages already on.\n");
	}else
		printf("%s\n",cm->ArgError);
	update_user(user,userposn);
}



void c_inform(CommandList *cm, int argc, char **argv)
{
	int z=BoolOpt(argv[1]);
	if (z==0)
	{
		if (!u_inform(user->status))
		{
			user->status|=(1<<5);
			printf("You will NOT be informed of logins/outs.\n");
		}else
			printf("You are already not informed of logins.\n");
	}else
	if (z==1)
	{
		if (u_inform(user->status))
		{
			user->status&=~(1<<5);
			printf("You now WILL be informed of logins/outs\n");
		}else
			printf("You are already informed of logins/outs.\n");
	}else
		printf("%s\n",cm->ArgError);
	update_user(user,userposn);
}



void c_beep(CommandList *cm, int argc, char **argv)
{
	int z=BoolOpt(argv[1]);
	if (z==0)
	{
		if (!u_beep(user->status))
		{
			user->status|=(1<<6);
			printf("You will NOT hear any beeps.\n");
		}else
			printf("You have already turned beeps off.\n");
	}else
	if (z==1)
	{
		if (u_beep(user->status))
		{
			user->status&=~(1<<6);
			printf("You now WILL get beeps.\n");
		}else
			printf("You are already getting beeps.\n");
	}else
		printf("%s\n",cm->ArgError);
	update_user(user,userposn);
}

void c_wizchat(CommandList *cm, int argc, char **argv)
{
	int z=BoolOpt(argv[1]);
	if (z==0)
	{
		if (!s_chatoff(user->special))
		{
			user->special|=(1<<3);
			printf("You will no longer recieve wizchat.\n");
		}else
			printf("You have already turned wizchat off.\n");
	}else
	if (z==1)
	{
		if (s_chatoff(user->special))
		{
			user->special&=~(1<<3);
			printf("You will now recieve wizchat messages.\n");
		}else
			printf("You already recieve wizchat messages.\n");
	}else
		printf("%s\n",cm->ArgError);
	update_user(user,userposn);
}



void c_autosub(CommandList *cm, int argc, char **argv)
{
	int t,n;

	t=BoolOpt(argv[2]);
	if (t==-1)
	{
		printf("%s\n",cm->ArgError);
		return(0);
	}
	printf("Forcing Subscription to folder %s ",t==0?"Off":"On");

	if ((n=foldernumber(argv[1]))==-1)
		printf("Failed\nUnknown folder name %s\n",argv[1]);
	else
	{
		auto_subscribe(n,t);
		printf(", Done.\n");
	}
}

void c_su(CommandList *cm, int argc, char **argv)
{
	int z=BoolOpt(argv[1]);
	
	if (z==1)
	{
		if (!u_god(user->status))
		{
			user->status|=(1<<2);
			printf("Wiz! Bang! - You're a wizard again.\n");
		}else
			printf("You're already a wizard.\n");
	}else
	if (z==0)
	{
		if (u_god(user->status))
		{
			user->status&=~(1<<2);
			printf("!gnaB !ziW - You feel rather normal.\n");
		}else
			printf("You already are rather normal.\n");
	}else
		printf("%s\n",cm->ArgError);
	update_user(user,userposn);
	set_rights();
}



void c_mesg(CommandList *cm, int argc, char **argv)
{
	sprintf(buff,"MsgEdit %s:%d",fold->name,atoi(argv[2]));
	strcpy(user->doing,buff);
	update_user(user,userposn);
	busy=1;
	mesg_edit(argv[1],fold->name,atoi(argv[2]));
	busy=0;
	DisplayStack();
	sprintf(buff,"Message %s %s:%d",argv[1],fold->name,atoi(argv[2]));
	log(buff);
}

void c_latest(CommandList *cm, int argc, char **argv)
{
	latest(user);
}

void c_who(CommandList *cm, int argc, char **argv)
{
	sprintf(buff,"Checking 'Who'");
	strcpy(user->doing,buff);
	update_user(user,userposn);

	who_list(user);
}

void c_tell(CommandList *cm, int argc, char **argv)
{
	char text[1024];
	int i;
	text[0]=0;
	if (s_coventry(user->special))
		printf("You have been sent to 'coventry' you are not allowed to talk to anyone..\n");
	else
	{
		sprintf(buff,"Talking to %s",argv[1]);
		strcpy(user->doing,buff);
		update_user(user,userposn);
		for (i=2;i<argc;i++) 
		{
			strcat(text,argv[i]);
			strcat(text," ");
		}

		send_mesg(user->name,argv[1],text,u_god(user->status));
	}
}


void c_wiz(CommandList *cm, int argc, char **argv)
{
	char text[1024];
	int i;
	text[0]=0;
	for (i=1;i<argc;i++) 
	{
		strcat(text,argv[i]);
		strcat(text," ");
	}
	sprintf(buff,"(%s): %s",user->name,text);
	broadcast(buff,2);
}

void c_wall(CommandList *cm, int argc, char **argv)
{
	char text[1024];
	int i;
	text[0]=0;
	for (i=1;i<argc;i++) 
	{
		strcat(text,argv[i]);
		strcat(text," ");
	}
	broadcast(text,0);
}


void c_doing(CommandList *cm, int argc, char **argv)
{
	char text[512];
	int i;
	text[0]=0;
	for (i=1;i<argc;i++) 
	{
		strcat(text,argv[i]);
		strcat(text," ");
	}
	strncpy(user->doing,text,79);
	user->doing[80]=0;
	update_user(user,userposn);
}

void c_pwd(CommandList *cm, int argc, char **argv)
{
	printf("Current folder = %s\n",fold->name);
	if (last_mesg==0)
		printf("You havn't read any messages in this folder yet.\n");
	else
		printf("You last read message %d.\n",last_mesg);
}

void c_ls(CommandList *cm, int argc, char **argv)
{
	int many;
	if (allowed_r(fold,user))
	{
		if (argc>1) many=atoi(argv[1]);
		else many=0;
			ls(currentfolder,user,many);
	} else
		printf("You are not permitted to read this folder.\n");
}

void c_topten(CommandList *cm, int argc, char **argv)
{
	int x;
	sprintf(buff,"%s/topten",HOMEPATH);
	signal(SIGCHLD,SIG_DFL);
	x=fork();
	if (x==-1)
		printf("fork() failed.\n");
	else
	if (x==0)
	{
		x=seteuid(getuid());
		if (x<0)
			perror("seteuid");
		else
			execl(buff,"MW TopTen",fold->name,NULL);
	}else
	{
		do{
			x=wait(NULL);
		}while (x==-1 && errno==EINTR);
		if (x==-1)
			perror("wait");
	}
}

void c_board(CommandList *cm, int argc, char **argv)
{
	int ftmp;

	if (stringcmp(argv[1],"lock",-1))
	{
		if (access(LOCKFILE,00))
		{
			if ((ftmp=creat(LOCKFILE,00))<0)
			{
				printf("Could not lockboard.\n");
				perror("Lock Board");
			}else
			{
				printf("Board now locked.\n");
				close(ftmp);
			}
		}else
			printf("Already Locked.\n");
	}else
	if (stringcmp(argv[1],"unlock",-1))
	{
		if (!access(LOCKFILE,00))
		{
			unlink(LOCKFILE);
			printf("Board now unlocked.\n");
		}else
			printf("Board not locked.\n");
	}else
		printf("Do you want to lock or unlock it.");
}



filed_help(char *topic)
{
	if (access(makepath(HELPDIR,"",""),00))
		printf("Sorry, no help available.\n");
	else
	{
		sprintf(buff,"Reading help");
		strcpy(user->doing,buff);
		update_user(user,userposn);

		help(topic,u_god(user->status));
	}
}

void c_listusers(CommandList *cm, int argc, char **argv)
{
	sprintf(buff,"Listing Users");
	strcpy(user->doing,buff);
	update_user(user,userposn);

	list_users(FALSE);
}

void c_newusers(CommandList *cm, int argc, char **argv)
{
	list_users(TRUE);
}


void c_since(CommandList *cm, int argc, char **argv)
{
	sprintf(buff,"Checking Since");
	strcpy(user->doing,buff);
	update_user(user,userposn);

	list_users_since(user->lastlogin);
}


void c_mod(CommandList *cm, int argc, char **argv)
{
	sprintf(buff,"Moderating");
	strcpy(user->doing,buff);
	update_user(user,userposn);

	moderate();
}

void c_passwd(CommandList *cm, int argc, char **argv)
{
	char pw1[PASSWDSIZE], pw2[PASSWDSIZE], salt[3];
		
	sprintf(buff,"Changing Password");
	strcpy(user->doing,buff);
	update_user(user,userposn);

	salt[2]=0;
	strncpy(salt,user->passwd,2);
	if (strcmp(user->passwd,crypt(get_pass("Enter old password: "),salt)))
		printf("Incorrect.\n");
	else
	{
		pick_salt(salt);
		strcpy(pw1,crypt(get_pass("New password: "),salt));
		strcpy(pw2,crypt(get_pass("Again: "),salt));
		if (strcmp(pw1,pw2))
			printf("Did not match.\n");
		else
		{
			strcpy(user->passwd,pw1);
			update_user(user,userposn);
			printf("Password set.\n");
			log("Passwd");
		}
	}
}


void c_resub(CommandList *cm, int argc, char **argv)
{
	if (get_subscribe(user,currentfolder)==TRUE)
		printf("You are already subscribed to %s.\n",fold->name);
	else
	{
		set_subscribe(user,currentfolder,TRUE);
		printf("Resubscribing to %s.\n",fold->name);
	}
}

void c_unsub(CommandList *cm, int argc, char **argv)
{
	if (get_subscribe(user,currentfolder)==FALSE)
		printf("Already Unsubscribed from %s.\n",fold->name);
	else
	{
		set_subscribe(user,currentfolder,FALSE);
		printf("Unsubscribing from %s.\n",fold->name);
	}
}

void c_read(CommandList *cm, int argc, char **argv)
{
	int num=atoi(argv[1]);

	sprintf(buff,"Reading folder %s",fold->name);
	strcpy(user->doing,buff);

	if (read_msg(currentfolder,num,user))
		last_mesg=num;
}

void c_prev(CommandList *cm, int argc, char **argv)
{
	if (last_mesg<=fold->first)
		printf("You are already at the beginning of the folder.\n");
	else
		if (read_msg(currentfolder,last_mesg-1,user))
			last_mesg--;
	sprintf(buff,"Reading folder %s",fold->name);
	strcpy(user->doing,buff);
}


void c_next(CommandList *cm, int argc, char **argv)
{
	if (last_mesg>=fold->last)
		printf("You are already at the end of this folder.\n");
	else
	if (read_msg(currentfolder,last_mesg+1,user))
		last_mesg++;

	sprintf(buff,"Reading folder %s",fold->name);
	strcpy(user->doing,buff);
}

void c_status(CommandList *cm, int argc, char **argv)
{
	char stats[10],gr[10];
	show_user_stats(user->status,stats,FALSE);
	show_fold_groups(user->groups,gr,FALSE);
	printf("Current Status of %s\n",user->name);
	printf("Your real name is %s\n",user->realname);
	printf("Your contact address is %s\n",user->contact);
	printf("Your current status is [%s]\n",stats);
	printf("You have set messages %s\n",u_mesg(user->status)?"off.":"on.");
	printf("You will%s be informed of logins and logouts\n",u_inform(user->status)?" not":"");
	printf("You will%s hear beeps.\n",u_beep(user->status)?" not":"");
	if (u_god(user->status) || s_wizchat(user->special))
	{
		printf("You can use wizchat");
		if (s_chatoff(user->special))
			printf(", but you will not hear any replies");
		printf(".\n");
	}
	if (*gr) printf("You belong to the following group(s) [%s]\n",gr);
	printf("You are currently in folder %s, which you ",fold->name);
	printf(get_subscribe(user,currentfolder)?"are":"are not");
	printf(" subscribed to.\n");
	time_on(user->timeused+(time(0) - loggedin));
}

void c_credits(CommandList *cm, int argc, char **argv)
{
	credits();
}

void c_write(CommandList *cm, int argc, char **argv)
{
	sprintf(buff,"Writing in folder %s",fold->name);
	strcpy(user->doing,buff);
	update_user(user,userposn);
	busy=1;
	add_msg(currentfolder,user,0);
	busy=0;
	DisplayStack();
}


void c_reply(CommandList *cm, int argc, char **argv)
{
	if (last_mesg==0)
		printf("You have to read a message before you can reply to it.\n");
	else
	{
		sprintf(buff,"Replying in folder %s",fold->name);
		strcpy(user->doing,buff);
		update_user(user,userposn);

		printf("Replying to message %d.\n",last_mesg);
		busy=1;
		add_msg(currentfolder,user,last_mesg);
		busy=0;
		DisplayStack();
	}
}

void c_catchup(CommandList *cm, int argc, char **argv)
{
	get_folder_number(fold,currentfolder);
	user->lastread[currentfolder]=fold->last;
	update_user(user,userposn);
	printf("Marking folder %s as read.\n",fold->name);
}

void c_date(CommandList *cm, int argc, char **argv)
{
	long tm;
	tm=time(0);
	printf("Current time and date is %s",ctime(&tm));
}

void c_quit(CommandList *cm, int argc, char **argv)
{
	close_down();
}

void c_save(CommandList *cm, int argc, char **argv)
{
	int msg=atoi(argv[1]);
	char buff[128],file[128];
	FILE *f;
	
	int i,len,x;	

	len=strlen(argv[2]);	
	for(i=0;i<len;i++)
	{
		if (argv[2][i]=='/') file[i]='_';
		else
			file[i]=argv[2][i];
	}
	file[len]=0;

	sprintf(buff,"/tmp/%s",file);

	x=fork();
	if (x==-1)
	{
		printf("fork() failed, cannot save.\n");
	}else
	if (x==0)
	{
		/* we are child */
		int gid,uid;
		uid=geteuid();
		if (seteuid(getuid())==-1) {perror("setuid");exit(0);}
		if ((f=fopen(buff,"a"))==NULL)
		{
			perror(file);
			exit(0);
		}
		output=f;
		fprintf(output,"Saved Message:\n");
		seteuid(uid);	
		read_msg(currentfolder,msg, user);
		fclose(output);
		printf("Mesg no %d saved to %s\n",msg,buff);
		output=stdout;
		exit(0);
	}else
	{
		do{
			x=wait(NULL);
		}while (x==-1 && errno==EINTR);
		if (x==-1)
			perror("wait");
	}
}	
