/*********************************************************
 *     The Milliways III System is copyright 1992        *
 *      J.S.Mitchell. (arthur@sugalaxy.swan.ac.uk)       *
 *       see licence for furthur information.            *
 *********************************************************/

#include <stdio.h>
#include <signal.h>
#include <fcntl.h>
#include <string.h>
#include <sys/wait.h>
#include <arpa/telnet.h>
#include "bb.h"
#include "mesg.h"
#include "Parse.h"
#include "command.h"


static char version[]="Milliways III - Version 1.9.1 28/02/95";

int currentfolder=0,last_mesg=0;
int internet=0;
int new_mail_waiting=0;
int idle_count;
int remote=FALSE;
FILE *output=stdout;
int busy=0; /* if true dont display messages  i.e. during new/write */
int quietmode=0;

struct person *user;
struct folder *fold;
long userposn;
unsigned long loggedin; /* what time did they login */
unsigned long rights=(unsigned long)0;

void set_rights(void)
{
	rights=0l;
	if (u_god(user->status)) rights=3l;
	if (s_wizchat(user->special)) rights|=2l;
	if (s_superuser(user->special)) rights|=4l;
	if (u_mod(user->status)) rights|=8l;
	if (!internet && getuid()!=500) rights|=16l;
}

void main(int argc, char **argv)
{
	char comm[1024];
	char buff[1024];
	struct sigaction s;

	
	user=(struct person *)malloc(sizeof(*user));
	fold=(struct folder *)malloc(sizeof(*fold));
#ifdef NEED_LINEBUF
	setlinebuf(stdout);
	setlinebuf(stderr);
#endif
	if(argc==2&&strcmp(argv[1],"-i")==0&&getuid()==getuid())
		internet=1;

	if (argc>=2 && strcmp(argv[1],"-new")==0)
	{
		char *b;
		b=(char *)getlogin();
		if (b!=NULL && strcmp(b,"bbs"))
 		{
			if (is_old(user,b,&userposn))
				list_new_items(user,TRUE);
		}else
			printf("Username not permitted.\n");
		exit(0);
	}

	signal(SIGINT,SIG_IGN);
	signal(SIGPIPE,SIG_IGN);
#ifdef SIGTSTP
	signal(SIGTSTP,SIG_IGN);
#endif
	if(getuid()!=geteuid())
		signal(SIGQUIT,SIG_IGN);

	/* setup incoming signal handlers */
	s.sa_handler=incoming_mesg;
	s.sa_flags=SA_INTERRUPT|SA_NOMASK;
	s.sa_mask=0;
	sigaction(SIGUSR1,&s,NULL);
/*	signal(SIGUSR1,incoming_mesg);	*/
	s.sa_handler=time_out;
	s.sa_flags=SA_INTERRUPT|SA_NOMASK;
	s.sa_mask=0;
	sigaction(SIGALRM,&s,NULL);
/*	signal(SIGALRM,time_out); */

	close_fifo();
	create_pipe();
	open_fifo();	

/* display all new messages for given user */
	if (argc==3 && !strcmp(argv[1],"-X") && getuid()==geteuid())
	{
		long tmp;
		if (!is_old(user,argv[2],&tmp))
		{
			fprintf(stderr,"%s: User %s not found.\n",argv[0],argv[2]);
			exit(-1);
		}
		remote=TRUE;
		new(user);
		update_user(user,tmp);
		exit(0);
	}
	
/* jump straight to add_mesg() */
	if (argc==4 && !strcmp(argv[1],"-f") && getuid()==geteuid())
	{
		long tmp;
		currentfolder=foldernumber(argv[2]);
		if (currentfolder==-1)
		{
			fprintf(stderr,"%s: Folder %s not found.\n",argv[0],argv[2]);
			exit(-1);
		}
		if (!is_old(user,argv[3],&tmp))
		{
			fprintf(stderr,"%s: User %s not found.\n",argv[0],argv[3]);
			exit(-1);
		}
		remote=TRUE;
		add_msg(currentfolder,user,0);
		exit(0);
	}
/*	if(internet)
		printf("%c%c%c%c%c%c",IAC,WILL,TELOPT_SGA,
				      IAC,WILL,TELOPT_SGA);	*/
	printfile(makepath(LOGIN_BANNER,"",""));
	printf("%s\n",version);
	login_ok(user,&userposn);
	if (!access(LOCKFILE,00))
	if (u_god(user->status))
	{
		printf("The board is currently locked to normal users.\n");
	}else
	{
		printf("The Board has been temporarily closed.\n");
		printf("Please call again soon.\n");
		exit(0);
	}

	if (!(u_god(user->status) && argc==2 && !strcmp(argv[1],"-quiet")))
	{
		sprintf(buff,"%s has just entered the board.",user->name);
		broadcast(buff,1);
		quietmode=1;
	}

#ifdef RWHO
	rwho_update();
#endif
	
	log("Logged In");
	printf("\nLast logged on %s\n",ctime(&user->lastlogin));
	loggedin=time(0);

	user->idletime=time(0);
	strcpy(user->doing,"Logging in");
	update_user(user,userposn);	
	who_add(getpid(),userposn);

	list_new_items(user,TRUE);
	get_folder_number(fold,currentfolder);
	
	InitParser();
	set_rights();

	for (;;)
	{
		alarm(0); idle_count=0;
	    do{
		if (!is_stacked())
		if (u_god(user->status))
			printf("{%s}---* ",fold->name);
		else
		if (u_reg(user->status))
			printf("<%s>---> ",fold->name);
		else
			printf("[%s] _@/ ",fold->name);
		get_str(comm,1023);
		strip_str(comm); 
		if (new_mail_waiting==1)
		{
			printf("\7*** You have new mail.\n");
			new_mail_waiting=0;
		}else
		if (new_mail_waiting>1)
		{
			printf("\7*** You have %d new mail messages.\n",new_mail_waiting);
			new_mail_waiting=0;
		}
		user->idletime=time(0);
		strcpy(user->doing,"Nothing");
		update_user(user,userposn);
		alarm(TIMEOUT);
	     }while (*comm==0);

#ifdef RWHO
	     	rwho_update();
#endif 

		
	DoCommand(comm, table); 

		update_user(user,userposn);

		if (u_ban(user->status))
		{
			printf("--> You appear to have been banned. Goodbye... <--\r\n");
			break;
		}

	}	
	close_down();
}

void close_down(void)
{
	char buff[80];
	user->timeused+= time(0) - loggedin;
	user->lastlogin=time(0);
	update_user(user,userposn);
	who_delete(getpid());
#ifdef RWHO
	rwhocli_userlogout(user->name);
#endif

	sprintf(buff,"%s has just left the board.",user->name);
	broadcast(buff,1);

	log("Logged Out");
	free(user);
	free(fold);
	close_fifo();
	exit(0);
}


void printfile(char *filename)
{
	FILE *afile;
	char buff[512];
	int l;
	
	if ((afile=fopen(filename,"r"))==NULL)
		{perror(filename);exit(-1);}
	while ((l=fread(buff,1,512,afile))>0)
		fwrite(buff,1,l,stdout);
	fclose(afile);
}

void help(char *args, int wiz)
{
	if (args!=NULL &&(strchr(args,'.')!=NULL || strchr(args,'/')!=NULL))
	{
		printf("Sorry, no help available on that subject. *:-)\n");
		return;
	}
	
	if (args==NULL)
	{
		printfile(makepath(HELPDIR,"/","general"));
		if (wiz)
		{
			printfile(makepath(WIZHELP,"/","general"));
		}
	}else
	{
		int found=FALSE;
		char *x;
		x=makepath(HELPDIR,"/",args);
		if (!access(x,00))
		{
			printfile(x);
			found=TRUE;
		}
		if (wiz && !found)
		{
			x=makepath(WIZHELP,"/",args);
			if (!access(x,00))
			{
				printfile(x);
				found=TRUE;
			}
		}		
		if (!found)
			printf("No help available on that subject.\n");
	}
}


void credits(void)
{
	printf("The Milliways III bulletin board system.\n");
	printf("(c) 1992 Arthur Dent (J.S.Mitchell)\n");
	printf("\nLinux / Internet patches: Anarchy\n");
	printf("Basis of new command parser: Anarchy\n");
	printf("General Thanks to:\n");
	printf("Arashi(ideas), Hobbit(spellings), Madsysop(for being annoying).\n\n");
}


int incoming_pipe;

struct mstack
{
	char *text;
	struct mstack *next;
};
	
static struct mstack *MesgStack=NULL;
static int MesgStacked=0;

void StackMesg(char *text)
{
	struct mstack *new;
	new=(struct mstack *)malloc(sizeof(struct mstack));
	new->text=(char *)malloc(strlen(text)+1);
	strcpy(new->text,text);
	new->next=NULL;
	if (MesgStack==NULL)
	{
		MesgStack=new;
		MesgStacked=1;
	}else
	{
		struct mstack *ptr;
		ptr=MesgStack;
		while (ptr->next!=NULL) ptr=ptr->next;
		ptr->next=new;
		MesgStacked++;
	}
}

void DisplayStack(void)
{
	struct mstack *new;
	struct mstack *old;

	new=MesgStack;
	while (new!=NULL)
	{
		write(1,new->text,strlen(new->text));
		free(new->text);
		old=new->next;
		free(new);
		MesgStacked--;
		new=old;
	}
	MesgStack=NULL;
}

void incoming_mesg(int ignore)
{
	extern struct person *user;
	int nos,i;
	char buff[1500];
	char newbuff[1500];
	int ptr=0;
	static state=0;

/*	signal(SIGUSR1,incoming_mesg);
*/	while ((nos=read(incoming_pipe,buff,1024))>0)
	{
	for (i=0;i<nos;i++)
	{
		if (buff[i]==1)
		{
			new_mail_waiting++;
		}else
		if (buff[i]>=FORCE_STATUS && buff[i]<=FORCE_SPECIAL)
		{
			state=buff[i];
			if (ptr>0)
			{
				if (!u_beep(user->status)) strcat(newbuff,"\7");
				if (busy) StackMesg(newbuff);
				else write(1,newbuff,strlen(newbuff));
				ptr=0;
			}
		}else
		if (buff[i]=='!' && state!=0 )
		{
			newbuff[ptr]=0;
			if (state==FORCE_STATUS)
				user->status=user_stats(newbuff,user->status);
			else if (state==FORCE_GROUPS)
				user->groups=folder_groups(newbuff,user->groups);
			else if (state==FORCE_REALNAME)
				strcpy(user->realname,newbuff);
			else if (state==FORCE_CONTACT)
				strcpy(user->contact,newbuff);
			else if (state==FORCE_SPECIAL)
				user->special=set_special(newbuff,user->special);
			else if (state==FORCE_LASTREAD)
			{
				int fol,pos;
				sscanf(newbuff,"%d:%d",&fol,&pos);
				user->lastread[fol]=pos;
			}
			ptr=0;
			state=0;
		}else
		{
		 	newbuff[ptr]=buff[i];
		 	ptr++;
		}
	}
	newbuff[ptr]=0;
	if (ptr>0)
	{
		char tb[1024];
		sprintf(tb,"\n%s",newbuff);
		if (!u_beep(user->status)) strcat(tb,"\7");
		if (busy) StackMesg(tb);
		else write(1,tb,strlen(tb));
	}
	
	}
	set_rights();
}

void open_fifo(void)
{
	if ((incoming_pipe=open(get_pipe_name(getpid()),O_RDONLY|O_NDELAY))<0)
	{
		perror("Error opening incoming pipe");
		exit(-1);
	}
}

void close_fifo(void)
{
	if(incoming_pipe)
		close(incoming_pipe);
	unlink(get_pipe_name(getpid()));
}


void time_out(int ignore)
{
	char buff[128];
	if (idle_count==1)
	{
		char msg[]="*** Timed Out, Good Bye\r\n";
		idle_count++;
		alarm(60);
		write(1,msg,strlen(msg));

		who_delete(getpid());
#ifdef RWHO
		rwhocli_userlogout(user->name);
#endif

		sprintf(buff,"%s has been timed out.",user->name);
		broadcast(buff,1);

		log("Timed Out");
		close_fifo();

		exit(-1);
	}else
	if (idle_count==0)
	{
		char msg[]=" *** Wakey ! Wakey !\r\n";
		msg[0]=7;
		idle_count++;
		alarm(120);
		update_user(user,userposn);	
		write(1,msg,strlen(msg));
	}else
	{
		log("TimedOut (blocked)");
		close_fifo();
		exit(-1);
	}
	
}

