/*********************************************************
 *     The Milliways III System is copyright 1992        *
 *      J.S.Mitchell. (arthur@sugalaxy.swan.ac.uk)       *
 *       see licence for furthur information.            *
 *********************************************************/
#include <stdio.h>
#include <fcntl.h>
#include <signal.h>
#include <string.h>
#include "bb.h"
#include "mesg.h"


void edit_user(char *args, char *name)
{
	long userposn;
	struct person usr;
	char tmp[80];
	
	if (!is_old(&usr,name,&userposn))
	{
		printf("Username %s not found.\n",name);
		return;
	}
	
	if (stringcmp(args,"edit",-1))
		edit_all(&usr);
	else
	if (stringcmp(args,"status",2))
	{
		char stats[12];
		show_user_stats(usr.status,stats,FALSE);
		printf("Current status set to [%s]\n",stats);
		show_user_stats(255,stats,FALSE);
		printf("New status [+-=][%s]: ",stats);
		get_str(stats,9);
		if (*stats)
		{	char statout[11];
			int i;
			i=user_stats(stats,usr.status);
			if (u_del(i))
			{
				printf("Do you really want to delete this user ? ");
				get_str(statout,4);
				if (statout[0]=='y' || statout[0]=='Y')
					usr.status=i;
			}else
				usr.status=i;
			show_user_stats(usr.status,statout,FALSE);
			printf("Status set to [%s].\n",statout);
			force_change(usr.name,FORCE_STATUS,stats);
			sprintf(tmp,"Change Status %s %s",usr.name,stats);
			log(tmp);
		}		
	}else
	if (stringcmp(args,"special",2))
	{
		char stats[20];
		show_special(usr.special,stats,FALSE);
		printf("Current specials set to [%s]\n",stats);
		show_special(65535,stats,FALSE);
		printf("New specials [+-=][%s]: ",stats);
		get_str(stats,18);
		if (*stats)
		{	char statout[20];
			unsigned short i;
			i=set_special(stats,usr.special);
/*			if (u_del(i))
			{
				printf("Do you really want to delete this user ? ");
				get_str(statout,4);
				if (statout[0]=='y' || statout[0]=='Y')
					usr.special=i;
			}else 
*/				usr.special=i;
			show_special(usr.special,statout,FALSE);
			printf("Specials set to [%s].\n",statout);
			force_change(usr.name,FORCE_SPECIAL,stats);
			sprintf(tmp,"Change Special %s %s",usr.name,stats);
			log(tmp);
		}
	}else
	if (stringcmp(args,"groups",2))
	{
		char stats[11];
		show_fold_groups(usr.groups,stats,TRUE);
		printf("User currently in groups [%s]\n",stats);
		printf("New Groups [+-=][12345678]: ");
		get_str(stats,10);
		if (*stats)
		{
			usr.groups=folder_groups(stats,usr.groups);
			force_change(usr.name,FORCE_GROUPS,stats);
			sprintf(tmp,"Change Groups %s %s",usr.name,stats);
			log(tmp);

			show_fold_groups(usr.groups,stats,TRUE);
			printf("Groups changed to [%s]\n",stats);
		}
	}else
	if (stringcmp(args,"passwd",4))
	{
		char pass1[PASSWDSIZE+1],pass2[PASSWDSIZE+1];
		char salt[3];
		pick_salt(salt);
		strcpy(pass1,crypt(get_pass("New Passwd: "),salt));
		strcpy(pass2,crypt(get_pass("Again: "),salt));
		if (strcmp(pass1,pass2))
		{
			printf("Passwords did not match.\nNot done.\n");
			return;
		}else
		{
			strcpy(usr.passwd,pass1);
			printf("Password changed.\n");
			sprintf(tmp,"Change Passwd %s",usr.name);
			log(tmp);

		}
	}else
	if (stringcmp(args,"realname",4))
	{
		char realname[REALNAMESIZE+1];
		printf("Real Name: %s\n",usr.realname);
		printf("Enter new name (%d chars): ",REALNAMESIZE);
		get_str(realname,REALNAMESIZE);
		if (*realname)
		{
			strcpy(usr.realname,realname);
			force_change(usr.name,FORCE_REALNAME,usr.realname);
			printf("New name set.\n");
			sprintf(tmp,"Change Realname %s %s",usr.name,realname);
			log(tmp);

		}
	}else
	if (stringcmp(args,"contact",4))
	{
		char contact[CONTACTSIZE+1];
		printf("Contact address: %s\n",usr.contact);
		printf("New address (%d chars): ",CONTACTSIZE);
		get_str(contact,CONTACTSIZE);
		if (*contact)
		{
			strcpy(usr.contact,contact);
			force_change(usr.name,FORCE_CONTACT,usr.contact);
			printf("New address set.\n");
			sprintf(tmp,"Change Contact %s %s",usr.name,contact);
			log(tmp);

		}
	}else
	if (stringcmp(args,"lastread",4))
	{
		char temp[FOLNAMESIZE+1];
		int folnum;
		int read;
		printf("Lastread in folder? ");
		get_str(temp,FOLNAMESIZE);
		folnum=foldernumber(temp);
		if (folnum==-1)
		{
			printf("Folder not found.\n");
		}else
		{
			printf("Last read message number %d\n",usr.lastread[folnum]);
			printf("New lastread: ");
			get_str(temp,5);
			if (*temp)
			{
				read=atoi(temp);
				usr.lastread[folnum]=read;
				printf("Lastread changed to %d\n",read);
				sprintf(temp,"%d:%d",folnum,read);
				force_change(usr.name,FORCE_LASTREAD,temp);
			}else
				printf("Not changed.\n");
		}
	}else
	if (stringcmp(args,"view",2))
	{
		char stats[10],specs[20];
		long timeon;
		show_user_stats(usr.status,stats,TRUE);
		show_special(usr.special,specs,TRUE);
		printf("Username: %s\nReal Name: %s\n",usr.name,usr.realname);
		printf("Contact: %s\nStatus [%s]\tSpecials [%s]\n",usr.contact,stats,specs);
		show_fold_groups(usr.groups,stats,TRUE);
		printf("Groups [%s]\n",stats);
		timeon=usr.lastlogin;
		printf("Last Login: %s",ctime(&timeon));
		time_on(usr.timeused);
	}else
	{
		printf("Unknown Command\n");
		return;
	}
	update_user(&usr,userposn);
}


void edit_all(struct person *usr)
{
	int i,r;
	char tmp[80];	
	
	printf("Editing user %s\n",usr->name);
	printf("Enter new data for each field <cr> to leave unchanged.\n");
	
	printf("realname: %s\nnew name: ",usr->realname);
	get_str(tmp,REALNAMESIZE);
	if (strlen(tmp)!=0) strcpy(usr->realname,tmp);
	printf("email: %s\nnew email: ",usr->contact);
	get_str(tmp,CONTACTSIZE);
	if (strlen(tmp)!=0) strcpy(usr->contact,tmp);
	printf("subscribed %lo %lo\nsubscibed: ",usr->folders[0],usr->folders[1]);
	get_str(tmp,10);
	if (strlen(tmp)!=0) usr->folders[0]=atoi(tmp);
	printf("last message read (folder:message) -\n");
	for (i=0;i<11;i++) printf("%2d:%03d ",i,usr->lastread[i]);
	printf("\n");
	for (i=11;i<22;i++) printf("%2d:%03d ",i,usr->lastread[i]);
	printf("\n");
	for (i=22;i<32;i++) printf("%2d:%03d ",i,usr->lastread[i]);
	printf("\n");
	for (;;)
	{
		printf("set read - <folder> <message>:");
		get_str(tmp,20);
		if (strlen(tmp)==0) break;
		sscanf(tmp,"%d %d",&i,&r);
		usr->lastread[i]=r;
	}
	show_user_stats(usr->status,tmp,TRUE);
	printf("current status %s\nnew status: ",tmp);
	get_str(tmp,20);
	if (*tmp) 
	{
		usr->status=user_stats(tmp,usr->status);
		show_user_stats(usr->status,tmp,FALSE);
		printf("status now set to [%s]\n",tmp);
	}
}

void edit_folder(char *args, char *name)
{
	char fullpath[256];
	int folnum;
	int afile;
	struct folder fold;
	char tmp[80]; 
	
	if ((folnum=foldernumber(name))==-1)
	{
		printf("Unknown folder name.\n");
		return;
	}
	get_folder_number(&fold,folnum);
	if (stringcmp(args,"status",2))
	{
		show_fold_stats(fold.status,tmp,TRUE);
		printf("Folder %s\nCurrent status:-\n",fold.name);
		printf("User not in group [%s]\n",tmp);
		show_fold_stats(fold.g_status,tmp,TRUE);
		printf("User in group [%s]\n",tmp);
		printf("Change to :-\n");
		printf("User not in group [+-=][arwRWpm]: ");
		get_str(tmp,10);
		if (*tmp)
		{
			fold.status=folder_stats(tmp,fold.status);
			sprintf(fullpath,"Folder Status %s %s",fold.name,tmp);
			show_fold_stats(fold.status,tmp,TRUE);
			printf("Status changed to [%s]\n",tmp);
			if(!f_active(fold.status))
				printf("WARNING: folder may get written over by the next folder created.\n");
		}
		printf("User in group [+-=][arwRWpm]: ");
		get_str(tmp,10);
		if (*tmp)
		{
			fold.g_status=folder_stats(tmp,fold.g_status);
			sprintf(fullpath,"%s %s",fullpath,tmp);
			show_fold_stats(fold.g_status,tmp,TRUE);
			printf("Status changed to [%s]\n",tmp);
			if(!f_active(fold.g_status))
				printf("WARNING: folder may get written over by the next folder created.\n");
		}
		log(fullpath);
	}else
	if (stringcmp(args,"groups",2))
	{
		show_fold_groups(fold.groups,tmp,TRUE);
		printf("Folder %s is currently in groups [%s]\n",fold.name,tmp);
		printf("Folder groups [+-=][12345678]: ");
		get_str(tmp,10);
		if (*tmp)
		{
			fold.groups=folder_groups(tmp,fold.groups);
			sprintf(fullpath,"Folder Groups %s %s",fold.name,tmp);
			log(fullpath);
			show_fold_groups(fold.groups,tmp,TRUE);
			printf("Groups changed to [%s]\n",tmp);
		}
	}else
	if (stringcmp(args,"name",5))
	{
		printf("Current folder name = %s\n",fold.name);
		printf("Change to ? (%d chars): ",FOLNAMESIZE);
		get_str(tmp,FOLNAMESIZE);
		if (*tmp)
		{
			char oldpath[PATHSIZE];	
			sprintf(fullpath,"Folder Rename %s to %s",fold.name,tmp);
			log(fullpath);

			sprintf(oldpath,"%s/%s%s",HOMEPATH,fold.name,INDEX_END);
			sprintf(fullpath,"%s/%s%s",HOMEPATH,tmp,INDEX_END);
			if (!access(oldpath,00)) rename(oldpath,fullpath);
			sprintf(oldpath,"%s/%s%s",HOMEPATH,fold.name,TEXT_END);
			sprintf(fullpath,"%s/%s%s",HOMEPATH,tmp,TEXT_END);
			if (!access(oldpath,00)) rename(oldpath,fullpath);
			if (f_moderated(fold.status)||f_moderated(fold.g_status))
			{
			sprintf(oldpath,"%s/%s%s%s",HOMEPATH,fold.name,INDEX_END,MOD_END);
			sprintf(fullpath,"%s/%s%s%s",HOMEPATH,tmp,INDEX_END,MOD_END);
			if (!access(oldpath,00)) rename(oldpath,fullpath); 
			sprintf(oldpath,"%s/%s%s%s",HOMEPATH,fold.name,TEXT_END,MOD_END);
			sprintf(fullpath,"%s/%s%s%s",HOMEPATH,tmp,TEXT_END,MOD_END);
			if (!access(oldpath,00)) rename(oldpath,fullpath);
			}
		
			strcpy(fold.name,tmp);
			printf("Name changed to %s\n",fold.name);
		}
	}else
	if (stringcmp(args,"size",4))
	{
		printf("First Message in folder is %d\n",fold.first);
		printf("New first message: ");
		get_str(tmp,10);
		if (*tmp)
		{
			fold.first=atoi(tmp);
			printf("First message set to %d\n",fold.first);
		}
		printf("Last Message in folder is %d\n",fold.last);
		printf("New Last message: ");
		get_str(tmp,10);
		if (*tmp)
		{
			fold.last=atoi(tmp);
			printf("Last message set to %d\n",fold.last);
		}
	}else
	if (stringcmp(args,"view",2))
	{
		char buff[10];
		show_fold_stats(fold.status,buff,TRUE);
		printf("\nFolder Name: %s\nTopic: %s\nMessage range %d to %d\n",
		fold.name,fold.topic,fold.first,fold.last);
		printf("Status (out of group) [%s]",buff);
		show_fold_stats(fold.g_status,buff,TRUE);
		printf("    (in group) [%s]\n",buff);
		show_fold_groups(fold.groups,buff,TRUE);
		printf("Groups [%s]\n",buff);
	}
	else
	if (stringcmp(args,"topic",2))
	{
		printf("Current folder topic = '%s'\n",fold.topic);
		printf("New topic (%d chars): ",TOPICSIZE);
		get_str(tmp,TOPICSIZE);
		if (*tmp)
		{
			strcpy(fold.topic,tmp);
			printf("Topic changed to '%s'\n",fold.topic);
			sprintf(fullpath,"Folder Topic %s %s",fold.name,tmp);
			log(fullpath);

		}
	}else
	if (stringcmp(args,"delete",6))
	{
		printf("Do you really want to delete folder %s  ?(yes/no) ",fold.name);
		get_str(tmp,4);
		if (stringcmp(tmp,"yes",-1))
		{
			sprintf(fullpath,"%s/%s%s",HOMEPATH,fold.name,INDEX_END);
			if (!access(fullpath,00)) if (unlink(fullpath)) {perror(fullpath);exit(-1);}
			sprintf(fullpath,"%s/%s%s",HOMEPATH,fold.name,TEXT_END);
			if (!access(fullpath,00)) if (unlink(fullpath)) {perror(fullpath);exit(-1);}
			if (f_moderated(fold.status)||f_moderated(fold.g_status))
			{
			sprintf(fullpath,"%s/%s%s%s",HOMEPATH,fold.name,INDEX_END,MOD_END);
			if (!access(fullpath,00)) if (unlink(fullpath)) {perror(fullpath);exit(-1);}
			sprintf(fullpath,"%s/%s%s%s",HOMEPATH,fold.name,TEXT_END,MOD_END);
			if (!access(fullpath,00)) if (unlink(fullpath)) {perror(fullpath);exit(-1);}
			}
			fold.status=0;
			fold.g_status=0;
			fold.name[0]=0;
			users_lastread(folnum);
			printf("Folder Deleted.\n");
			sprintf(fullpath,"Folder Deleted %s",fold.name);
			log(fullpath);

		}else
		{
			printf("Not Done.\n");
			return;
		}
	}else
		return;

	afile=openfolderfile(O_RDWR);
	Lock_File(afile);
	lseek(afile,folnum*sizeof(struct folder),0);
	write(afile,&fold,sizeof(struct folder));
	Unlock_File(afile);
	close(afile);	
}	

void users_lastread(int folnum)
{
	struct person user;
	int ufile;
	
	ufile=openuserfile(O_RDWR);
	Lock_File(ufile);
	while (read(ufile,&user,sizeof(user))>0)
	{
		lseek(ufile,-1*sizeof(user),1);
		user.lastread[folnum]=0;
		user.folders[0]|=(1<<folnum);
		write(ufile,&user,sizeof(user));
	}
	Unlock_File(ufile);
	close(ufile);
}
	
void mesg_edit(char *args, char *foldername, int msgno)
{
	int index,text;
	struct Header head;
	char *buff;
	
	if ((index=err_open(makepath(foldername,INDEX_END,""),O_RDWR,0))<0)
		return;
	if ((text=err_open(makepath(foldername,TEXT_END,""),O_RDWR,0))<0)
		return;
	
	/* go and get message */
	while (get_data(index,&head) && head.Ref<msgno);
	if (head.Ref!=msgno)
	{
		printf("Message %d not found.\n",msgno);
		return;
	}
	buff=(char *)malloc(head.size);
	lseek(text,head.datafield,0);
	read(text,buff,head.size);	
	
	if (stringcmp(args,"edit",4))
	{
		int tfile;
		int mask;
		char fullpath[20];
		char foo[128];
		long size;
		sprintf(fullpath,"/tmp/mw3XXXXXX");
		mktemp(fullpath);
		mask=umask(~0660);
		if ((tfile=open(fullpath,O_WRONLY|O_CREAT,0666))<0)
		{
			perror("creating temp file");
			return;
		}
		write(tfile,buff,head.size);
		close(tfile);
		umask(mask);
		sprintf(foo,"%s %s",EDITOR,fullpath);
		system(foo);
		if ((tfile=open(fullpath,O_RDONLY))<0)
		{
			perror("reading temp file");
			return;
		}
		size=lseek(tfile,0,2);
		lseek(tfile,0,0);
		buff=(char *)realloc(buff,size);
		read(tfile,buff,size);
		head.size=size;
		close(tfile);
		Lock_File(text);
		head.datafield=lseek(text,0,2);
		write(text,buff,size);
		Unlock_File(text);
	}else
	if (stringcmp(args,"to",-1))
	{
		char foo[SUBJECTSIZE+1];
		printf("Currently to '%s'.\n",head.to);
		printf("to: ");
		get_str(foo,SUBJECTSIZE);
		if (*foo)
		{
			printf("Message now to '%s'\n",foo);
			strcpy(head.to,foo);
		}else
			printf("Not Done.\n");
	}else
	if (stringcmp(args,"subject",3))
	{
		char foo[SUBJECTSIZE+1];
		printf("Current subject is '%s'.\n",head.subject);
		printf("Subject: ");
		get_str(foo,SUBJECTSIZE);
		if (*foo)
		{
			printf("Subject '%s'\n",foo);
			strcpy(head.subject,foo);
		}else
			printf("Not Done.\n");
	}else
	if (stringcmp(args,"delete",3))
	{
		head.status|=(1<<1);
		printf("Message Marked for deletion.\n");
	}else
	if (stringcmp(args,"undelete",5))
	{
		head.status&=~(1<<1);
		printf("Message has been undeleted.\n");
	}else
	if (stringcmp(args,"status",2))
	{
		char answer[11];
		show_mesg_stats(head.status,answer,1);
		printf("Status mode is currently %s\n",answer);
		show_mesg_stats(255,answer,1);
		printf("New status [%s]: ",answer);
		get_str(answer,10);
		if (*answer)
		{
			head.status=mesg_stats(answer,head.status);
			show_mesg_stats(head.status,answer,1);
			printf("Status set to [%s]\n",answer);
		}
	}
	else
		printf("What do you want to do ?\n");
	Lock_File(index);
	lseek(index,-1*sizeof(head),1);
	write(index,&head,sizeof(head));
	Unlock_File(index);
	close(index);
	close(text);
	free(buff);
}			

void time_on(long u)
{
	int s,m,h,d;

	d=u/(60*60*24);
	h=u%(60*60*24);
	h=h/(60*60);
	m=u%(60*60);
	m=m/60;
	s=u%60;

	printf("Total Login Time of ");
	if (d>0)
		printf("%d day%s, ",d,d>1?"s":"");
	if (h>0)
		printf("%d hour%s, ",h,h>1?"s":"");
	if (m>0)
		printf("%d minute%s, ",m,m>1?"s":"");
	printf("%d second%s.\n",s,s==1?"":"s");
}

void force_change(char *to, int what, char *string)
{
	int pid;
	char *path;
	char buff[256];
	int ffile;
	
	if ((pid=get_pid(to))==0)
	{
		return;
	}
	if (pid<0)
	{
		pid*= -1;
	}
	
	path=get_pipe_name(pid);

	if ((ffile=open(path,O_WRONLY|O_APPEND|O_NDELAY))<0)
	{
		printf("open: Cannot force status change on %s\n",to);
		perror(path);
		return;
	}
	sprintf(buff,"%c%s!",what,string);
	if (write(ffile,buff,strlen(buff))<1)
	{
		printf("write: Cannot force status change on %s\n",to);
		perror(path);
	}else
		kill(pid,SIGUSR1);
	if (close(ffile))
		perror("Error closing file");
}

