/*********************************************************
 *     The Milliways III System is copyright 1992        *
 *      J.S.Mitchell. (arthur@sugalaxy.swan.ac.uk)       *
 *       see licence for furthur information.            *
 *********************************************************/
#include <stdio.h>
#include <fcntl.h>
#include <time.h>

#include "bb.h"

int allowed_r(fol, usr)
struct folder *fol;
struct person *usr;
/* permission to read from folder */
{
	if (u_god(usr->status)) return(TRUE); /* superuser */
	if ((fol->groups)&(usr->groups)) /* you are in a common group */
	{
	if (u_reg(usr->status) && f_r_reg(fol->g_status)) return(TRUE); /* registered */
	if (!u_reg(usr->status) && f_r_unreg(fol->g_status)) return(TRUE); /* unregistered */
	}else  /* not in a common group */
	{
	if (u_reg(usr->status) && f_r_reg(fol->status)) return(TRUE); /* registered */
	if (!u_reg(usr->status) && f_r_unreg(fol->status)) return(TRUE); /* unregistered */
	}
	return(FALSE);
}

int is_private(fol, usr)
struct folder *fol;
struct person *usr;
{
	if ((fol->groups)&(usr->groups))
		return(f_private(fol->g_status));
	else
		return(f_private(fol->status));
}

int is_moderated(fol, usr)
struct folder *fol;
struct person *usr;
{
	if (u_god(usr->status)) return(FALSE);
	if ((fol->groups)&(usr->groups))
		return(f_moderated(fol->g_status));
	else
		return(f_moderated(fol->status));
}

int allowed_w(fol, usr)
struct folder *fol;
struct person *usr;
/* permission to write to folder */
{
	if (u_god(usr->status)) return(TRUE); /* superuser */
	if ((fol->groups)&(usr->groups)) /* you are in a common group */
	{
	if (u_reg(usr->status) && f_w_reg(fol->g_status)) return(TRUE); /* registered */
	if (!u_reg(usr->status) && f_w_unreg(fol->g_status)) return(TRUE); /* unregistered */
	}else  /* not in a common group */
	{
	if (u_reg(usr->status) && f_w_reg(fol->status)) return(TRUE); /* registered */
	if (!u_reg(usr->status) && f_w_unreg(fol->status)) return(TRUE); /* unregistered */
	}
	return(FALSE);
}

int u_ban(user) /* is banned */
int user;
{
	if (user&(1<<3))
		return(TRUE);
	else
		return(FALSE);
}

int u_del(user) /* marked for deletion */
int user;
{
	if (user&(1<<7))
		return(TRUE);
	else
		return(FALSE);
}

int u_god(user) /* is a superuser */
int user;
{
	if (user&(1<<2))
		return(TRUE);
	else
		return(FALSE);
}

int u_inform(user) /* gets informed of logins/logouts */
int user;
{
	if (user&(1<<5))
		return(TRUE);
	else
		return(FALSE);
}

int u_mesg(user) /* messages off */
int user;
{
	if (user&(1<<4))
		return(TRUE);
	else
		return(FALSE);
}

int u_beep(user) /* beeps off */
int user;
{
	if (user&(1<<6))
		return(TRUE);
	else
		return(FALSE);
}

int u_mod(user) /* is a moderator */
int user;
{
	if (user&(1<<1))
		return(TRUE);
	else
		return(FALSE);}

int u_reg(user) /* is registered */
int user;
{
	if (user&1)
		return(TRUE);
	else
		return(FALSE);
}

int f_active(stat)
int stat;
{
	if (stat&1)
		return(TRUE);
	else
		return(FALSE);
}

int f_r_unreg(stat)
int stat;
{
	if (stat&(1<<1))
		return(TRUE);
	else
		return(FALSE);
}

int f_w_unreg(stat)
int stat;
{
	if (stat&(1<<2))
		return(TRUE);
	else
		return(FALSE);
}

int f_r_reg(stat)
int stat;
{
	if (stat&(1<<3))
		return(TRUE);
	else
		return(FALSE);
}

int f_w_reg(stat)
int stat;
{
	if (stat&(1<<4))
		return(TRUE);
	else
		return(FALSE);
}

int f_private(stat)
int stat;
{
	if (stat&(1<<5))
		return(TRUE);
	else
		return(FALSE);
}

int f_moderated(stat)
int stat;
{
	if (stat&(1<<6))
		return(TRUE);
	else
		return(FALSE);
}

char user_stats(string,stat)
char *string;
char stat;
{
	int mode=0;
	int i;
	char p=0; /*pattern buffer */
	for (i=0;i<strlen(string);i++)
		switch (string[i])
		{
			case '=': mode=0;break;
			case '+': mode=-1;break;
			case '-': mode=1;break;
			case 'r': p=p|1;break;
			case 'm': p=p|(1<<1);break;
			case 's': p=p|(1<<2);break;
			case 'b': p=p|(1<<3);break;
			case 'n': p=p|(1<<4);break;
			case 'i': p=p|(1<<5);break;
			case 'p': p=p|(1<<6);break;
			case 'D': p=p|(1<<7);break;
		};
	if (mode==0) return(p);
	else if (mode==-1) return(stat|p);
	else if (mode==1) return(stat&(~p));
	else return(p);
}

char mesg_stats(string,stat)
char *string;
char stat;
{
	int mode=0;
	int i;
	char p=0; /*pattern buffer */
	for (i=0;i<strlen(string);i++)
		switch (string[i])
		{
			case '=': mode=0;break;
			case '+': mode=-1;break;
			case '-': mode=1;break;
			case 'd': p=p|(1<<1);break;
			case 'r': p=p|(1<<2);break;
			case 'x': p=p|(1<<3);break;
		};
	if (mode==0) return(p);
	else if (mode==-1) return(stat|p);
	else if (mode==1) return(stat&(~p));
	else return(p);
}
			
char folder_stats(string, stat)
char *string;
char stat;
{
	int mode=0;
	int i;
	char p=0; /*pattern buffer */
	for (i=0;i<strlen(string);i++)
		switch (string[i])
		{
			case '=': mode=0;break;
			case '+': mode=-1;break;
			case '-': mode=1;break;
			case 'a': p=p|1;break;
			case 'r': p=p|(1<<1);break;
			case 'w': p=p|(1<<2);break;
			case 'R': p=p|(1<<3);break;
			case 'W': p=p|(1<<4);break;
			case 'p': p=p|(1<<5);break;
			case 'm': p=p|(1<<6);break;
		};
	if (mode==0) return(p);
	else if (mode==-1) return(stat|p);
	else if (mode==1) return(stat&~p);
	return(p);
}

char folder_groups(string, stat)
char *string;
char stat;
{
	int mode=0;
	int i;
	char p=0; /*pattern buffer */
	for (i=0;i<strlen(string);i++)
		switch (string[i])
		{
			case '=': mode=0;break;
			case '+': mode=-1;break;
			case '-': mode=1;break;
			case '1': p=p|1;break;
			case '2': p=p|(1<<1);break;
			case '3': p=p|(1<<2);break;
			case '4': p=p|(1<<3);break;
			case '5': p=p|(1<<4);break;
			case '6': p=p|(1<<5);break;
			case '7': p=p|(1<<6);break;
			case '8': p=p|(1<<7);break;
		};
	if (mode==0) return(p);
	else if (mode==-1) return(stat|p);
	else if (mode==1) return(stat&~p);
	return(p);
}			

void show_user_stats(stat, tmp, flag)
char stat, *tmp;
int flag;
{
	int i=0;
	
	if (stat&(1<<0)) tmp[i++]='r'; else if (flag) tmp[i++]='-';
	if (stat&(1<<1)) tmp[i++]='m'; else if (flag) tmp[i++]='-';
	if (stat&(1<<2)) tmp[i++]='s'; else if (flag) tmp[i++]='-';
	if (stat&(1<<3)) tmp[i++]='b'; else if (flag) tmp[i++]='-';
	if (stat&(1<<4)) tmp[i++]='n'; else if (flag) tmp[i++]='-';
	if (stat&(1<<5)) tmp[i++]='i'; else if (flag) tmp[i++]='-';
	if (stat&(1<<6)) tmp[i++]='p'; else if (flag) tmp[i++]='-';
	if (stat&(1<<7)) tmp[i++]='D'; else if (flag) tmp[i++]='-';
	tmp[i]=0;
}

void show_mesg_stats(stat, tmp, flag)
char stat, *tmp;
int flag;
{
	int i=0;
	
	if (stat&(1<<1)) tmp[i++]='d'; else if (flag) tmp[i++]='-';
	if (stat&(1<<2)) tmp[i++]='r'; else if (flag) tmp[i++]='-';
	if (stat&(1<<3)) tmp[i++]='x'; else if (flag) tmp[i++]='-';
	tmp[i]=0;
}

void show_fold_stats(stat, tmp, flag)
char stat, *tmp;
int flag;
{
	int i=0;
	
	if (stat&1) tmp[i++]='a'; else if (flag) tmp[i++]='-';
	if (stat&(1<<1)) tmp[i++]='r'; else if (flag) tmp[i++]='-';
	if (stat&(1<<2)) tmp[i++]='w'; else if (flag) tmp[i++]='-';
	if (stat&(1<<3)) tmp[i++]='R'; else if (flag) tmp[i++]='-';
	if (stat&(1<<4)) tmp[i++]='W'; else if (flag) tmp[i++]='-';
	if (stat&(1<<5)) tmp[i++]='p'; else if (flag) tmp[i++]='-';
	if (stat&(1<<6)) tmp[i++]='m'; else if (flag) tmp[i++]='-';
	tmp[i]=0;
}
	
void show_fold_groups(stat, tmp, flag)
char stat, *tmp;
int flag;
{
	int i=0;
	
	if (stat&1) tmp[i++]='1'; else if (flag) tmp[i++]='-';
	if (stat&(1<<1)) tmp[i++]='2'; else if (flag) tmp[i++]='-';
	if (stat&(1<<2)) tmp[i++]='3'; else if (flag) tmp[i++]='-';
	if (stat&(1<<3)) tmp[i++]='4'; else if (flag) tmp[i++]='-';
	if (stat&(1<<4)) tmp[i++]='5'; else if (flag) tmp[i++]='-';
	if (stat&(1<<5)) tmp[i++]='6'; else if (flag) tmp[i++]='-';
	if (stat&(1<<6)) tmp[i++]='7'; else if (flag) tmp[i++]='-';
	if (stat&(1<<7)) tmp[i++]='8'; else if (flag) tmp[i++]='-';
	tmp[i]=0;
}

extern struct person *user;

void log(what)
char *what;
{
	int file;
	char outmsg[1024];
	unsigned long t;
	
	if ((file=open(makepath(LOGFILE,"",""),O_WRONLY|O_CREAT|O_APPEND,0600))<0)
		{perror("log");return;}
	t=time(0);
	sprintf(outmsg,"%*s | %s | %s",NAMESIZE,user->name,what,ctime(&t));
	write(file,outmsg,strlen(outmsg));
	close(file);
}


int get_subscribe(user, folder)
struct person *user;
int folder;
{
	if (folder<=31 && folder>=0)
	{
		if (user->folders[0] & (1<<folder) )
			return(TRUE);
		else
			return(FALSE);
	}else
	if (folder>=32 && folder <=63)
	{
		if (user->folders[1] & (1<< (folder-32)))
			return(TRUE);
		else
			return(FALSE);
	}else
	{
		printf("Error in get_subscribe folder %d\n",folder);
		return(FALSE);
	}
}

void set_subscribe(user,folder,status)
struct person *user;
int folder;
int status;
{
	if (folder>=0 && folder<=31)
	{
		if (status==TRUE)
		{
			user->folders[0]|=(1<<folder);
		}else
		if (status==FALSE)
		{
			user->folders[0]&=~(1<<folder);
		}else
			printf("Error in set_subscribe to folder %d\n",folder);
	}else
	if (folder>=32 && folder<=63)
	{
		if (status==TRUE)
		{
			user->folders[1]|=(1<<(folder-32));
		}else
		if (status==FALSE)
		{
			user->folders[1]&=~(1<<(folder-32));
		}else
			printf("Error in set_subscribe to folder %d\n",folder);
	}else
		printf("Error in set_subscribe to folder %d\n",folder);
}

	
