#include <stdio.h>
#include <fcntl.h>
#include <sys/stat.h>
#include <signal.h>
#include <string.h>
#include "bb.h"

extern char *get_pipe_name();

void create_pipe()
{
	if (mkfifo(get_pipe_name(getpid()),0600))
	{
		perror("Error in Creating mesg pipe");
		exit(-1);
	}
}


char *get_pipe_name(pid)
int pid;
{
	static char fullpath[1024];
	sprintf(fullpath,"%s/mesgs/bbs.%d",HOMEPATH,pid);
	return(fullpath);
}

void send_mesg(from, to, text, wiz)
char *from, *to, *text;
int wiz;
{
	int pid;
	char *path;
	char buff[1024];
	char mesg[513];
	int ffile;
	
	if ((pid=get_user_pid(to))==0)
	{
		printf("User not logged on.\n");
		return;
	}
	if (pid==-1)
	{
		printf("%s is not registered.\n",to);
		return;
	}else
	if (pid<-1)
	{
		if (wiz)
		{
			printf("%s has msg off, writing anyway.\n",to);
			pid=pid * -1;
		}else
		{
			printf("%s has turned messages off.\n",to);
			return;
		}
	}
	
	path=get_pipe_name(pid);

	if (text==NULL)
	{
		printf("Mesg to %s:",to);
		get_str(mesg,512);
		strip_str(mesg);
		if (!*mesg) return;
	}else
	{
		strncpy(mesg,text,512);
	}
	mesg[512]=0;
		
	if (strlen(mesg)<60)
	{
		sprintf(buff,"*** %s: %s\n",from,mesg);
	}else
	{
		int st=0;
		buff[0]=0;
		while (st<strlen(mesg))
		{
			strcat(buff,"*** ");
			strcat(buff,from);
			strcat(buff,": ");
			strncat(buff,&mesg[st],60);
			st+=60;
			
			strcat(buff,"\n");
		}
	}
	
	if ((ffile=open(path,O_WRONLY|O_APPEND|O_NDELAY,0))<0)
	{
		printf("open: Cannot send message to %s.\n",to);
		perror(path);
		return;
	}
	if (write(ffile,buff,strlen(buff))<1)
	{
		printf("write: Cannot send message to %s.\n",to);
		perror(path);
	}else
	{
		kill(pid,SIGUSR1);
	}
	sprintf(buff,"Told %s %s",to,mesg);
	log(buff);
	if (close(ffile))
		perror("error closing message pipe");
}

void inform_of_mail(to)
char *to;
{
	int pid;
	char *path;
	char buff;
	int ffile;
	
	if ((pid=get_user_pid(to))==0)
	{
		return;
	}
	if (pid<0)
	{
		pid*= -1;
	}
	
	path=get_pipe_name(pid);

	if ((ffile=open(path,O_WRONLY|O_APPEND|O_NDELAY))<0)
	{
		printf("open: Cannot inform %s of new mail.\n",to);
		perror(path);
		return;
	}
	buff=1;
	if (write(ffile,&buff,sizeof(buff))<1)
	{
		printf("write: Cannot inform %s of new mail.\n",to);
		perror(path);
	}else
		kill(pid,SIGUSR1);
	if (close(ffile))
		perror("Error closing file");
}


void broadcast(text, state) /* state  0=everyone 1=mesg y 2=wiz*/
char *text;
int state;
{
	char *path;
	char buff[1024];
	int ffile;
	struct person user;
	struct who w;
	int ufile,wfile;

	if (state==2)
		sprintf(buff,"Wiz: %s\n",text);
	else
		sprintf(buff,"SYSTEM: %s\n",text);
	
	wfile=openwhofile(O_RDONLY);
	ufile=openuserfile(O_RDONLY);
	
	while (read(wfile,&w,sizeof(w)))
	{
		lseek(ufile,w.posn,0);
		if (state==1)
		{
			read(ufile,&user,sizeof(user));
			if (!u_inform(user.status))
			{
				path=get_pipe_name(w.pid);

				if ((ffile=open(path,O_WRONLY|O_APPEND|O_NDELAY,0))>=0)
				{
				if (write(ffile,buff,strlen(buff))>0)
					kill(w.pid,SIGUSR1);
				close(ffile);
				}
			}
		}else
		if (state==2)
		{
			read(ufile,&user,sizeof(user));
			if ((u_god(user.status) || s_wizchat(user.special)) && !s_chatoff(user.special))
			{
				path=get_pipe_name(w.pid);

				if ((ffile=open(path,O_WRONLY|O_APPEND|O_NDELAY,0))>=0)
				{
				if (write(ffile,buff,strlen(buff))>0)
					kill(w.pid,SIGUSR1);
				close(ffile);
				}
			}
		}else
		{
			path=get_pipe_name(w.pid);

			if ((ffile=open(path,O_WRONLY|O_APPEND|O_NDELAY,0))>=0)
			{
			if (write(ffile,buff,strlen(buff))>0)
				kill(w.pid,SIGUSR1);
			close(ffile);
			}			
		}
	}
	if (state==0)
		sprintf(buff,"Wall %s",text);
	else
	if (state==2)
		sprintf(buff,"Wiz %s",text);
	if (state!=1) log(buff);


	close(ufile);
	close(wfile);
}

