/*********************************************************
 *     The Milliways III System is copyright 1992        *
 *      J.S.Mitchell. (arthur@sugalaxy.swan.ac.uk)       *
 *       see licence for furthur information.            *
 *********************************************************/

#include <stdio.h>
#include <signal.h>
#include <fcntl.h>
#include <string.h>
#include <sys/wait.h>
#include <arpa/telnet.h>
#include <errno.h>
#include "bb.h"
#include "mesg.h"

static char version[]="Milliways Version 1.2 (beta)";

int currentfolder=0,last_mesg=0;
int internet=0;
int new_mail_waiting=0;
int idle_count;
int remote=FALSE;
int busy=0; /* if true dont display messages  i.e. during new/write */

struct person *user;
static long userposn;

void main(argc, argv)
int argc;
char **argv;
{
	struct folder *fold;
	char comm[1024];
	char *this;
	unsigned long loggedin; /* what time did they login */
	char buff[1024];
	struct sigaction s;

	
	user=(struct person *)malloc(sizeof(*user));
	fold=(struct folder *)malloc(sizeof(*fold));
#ifdef NEED_LINEBUF
	setlinebuf(stdout);
	setlinebuf(stderr);
#endif
	if(argc==2&&strcmp(argv[1],"-i")==0&&getuid()==getuid())
		internet=1;

	if (argc>=2 && strcmp(argv[1],"-new")==0)
	{
		char *b;
		b=(char *)getlogin();
		if (b!=NULL && strcmp(b,"bbs"))
 		{
			if (is_old(user,b,&userposn))
				list_new_items(user,TRUE);
		}else
			printf("Username not permitted.\n");
		exit(0);
	}

	signal(SIGINT,SIG_IGN);
	signal(SIGPIPE,SIG_IGN);
#ifdef SIGTSTP
	signal(SIGTSTP,SIG_IGN);
#endif
	if(getuid()!=geteuid())
		signal(SIGQUIT,SIG_IGN);

	/* setup incoming signal handlers */
#ifdef LINUX
	s.sa_handler=incoming_mesg;
	s.sa_flags=SA_INTERRUPT|SA_NOMASK;
	s.sa_mask=0;
	sigaction(SIGUSR1,&s,NULL);
#else
	signal(SIGUSR1,incoming_mesg);
#endif

#ifdef LINUX
	s.sa_handler=time_out;
	s.sa_flags=SA_INTERRUPT|SA_NOMASK;
	s.sa_mask=0;
	sigaction(SIGALRM,&s,NULL);
#else
	signal(SIGALRM,time_out);
#endif

	close_fifo();
	create_pipe();
	open_fifo();	

/* display all new messages for given user */
	if (argc==3 && !strcmp(argv[1],"-X") && getuid()==geteuid())
	{
		long tmp;
		if (!is_old(user,argv[2],&tmp))
		{
			fprintf(stderr,"%s: User %s not found.\n",argv[0],argv[2]);
			exit(-1);
		}
		remote=TRUE;
		new(user);
		update_user(user,tmp);
		exit(0);
	}
	
/* jump straight to add_mesg() */
	if (argc==4 && !strcmp(argv[1],"-f") && getuid()==geteuid())
	{
		long tmp;
		currentfolder=foldernumber(argv[2]);
		if (currentfolder==-1)
		{
			fprintf(stderr,"%s: Folder %s not found.\n",argv[0],argv[2]);
			exit(-1);
		}
		if (!is_old(user,argv[3],&tmp))
		{
			fprintf(stderr,"%s: User %s not found.\n",argv[0],argv[3]);
			exit(-1);
		}
		remote=TRUE;
		add_msg(currentfolder,user,0);
		exit(0);
	}
/*	if(internet)
		printf("%c%c%c%c%c%c",IAC,WILL,TELOPT_SGA,
				      IAC,WILL,TELOPT_SGA);	*/
	printfile(makepath(LOGIN_BANNER,"",""));
	login_ok(user,&userposn);
	if (!access(LOCKFILE,00))
	if (u_god(user->status))
	{
		printf("The board is currently locked to normal users.\n");
	}else
	{
		printf("The Board has been temporarily closed.\n");
		printf("Please call again soon.\n");
		exit(0);
	}

	if (!(u_god(user->status) && argc==2 && !strcmp(argv[1],"-quiet")))
	{
		sprintf(buff,"%s has just entered the board.",user->name);
		broadcast(buff,1);
	}

	user->idletime=time(0);
	strcpy(user->doing,"Logging in");
	update_user(user,userposn);	
	who_add(getpid(),userposn);
#ifdef RWHO
	rwho_update();
#endif
	
	log("Logged In");
	printf("\nLast logged on %s\n",ctime(&user->lastlogin));
	loggedin=time(0);

	list_new_items(user,TRUE);
	get_folder_number(fold,currentfolder);
	for (;;)
	{
		alarm(0); idle_count=0;
	    do{
		if (!is_stacked())
		if (u_god(user->status))
			printf("{%s}---* ",fold->name);
		else
		if (u_reg(user->status))
			printf("<%s>---> ",fold->name);
		else
			printf("[%s] _@/ ",fold->name);
		get_str(comm,1023);
		strip_str(comm);
		this=(char *)strtok(comm," ");
		if (new_mail_waiting==1)
		{
			printf("\7*** You have new mail.\n");
			new_mail_waiting=0;
		}else
		if (new_mail_waiting>1)
		{
			printf("\7*** You have %d new mail messages.\n",new_mail_waiting);
			new_mail_waiting=0;
		}
		user->idletime=time(0);
		strcpy(user->doing,"Nothing");
		update_user(user,userposn);
		alarm(TIMEOUT);
	     }while (this==NULL);

#ifdef RWHO
	     	rwho_update();
#endif 
		if (stringcmp(this,"cd",-1))
		{
			int i;
			char tmpname[FOLNAMESIZE+1];
			if ((this=(char *)strtok(NULL," "))==NULL)
			{		
				listfolders(user);
				printf("Enter folder name: ");
				get_str(tmpname,FOLNAMESIZE);
				this=tmpname;
			}
			if (*this)
			{
			    if ((i=foldernumber(this))==-1)
				printf("Unknown foldername.\n");
			    else
			    {
				get_folder_number(fold,i);
				if(!f_active(fold->status) 
				|| (!allowed_r(fold,user)
				&& !allowed_w(fold,user)))
				{
					printf("Unknown foldername.\n");
					get_folder_number(fold,currentfolder);
				}
				else
				{
					printf("Changing to folder %s.\n",fold->name);
					currentfolder=i;
					last_mesg=0;
				}
			    }
			}
		}
		else
		if (stringcmp(this,"addfol",-1))
			if (u_god(user->status)) /*superuser*/
			{
				add_folder();
			}
			else
				printf(ERRORMSG);
		else
		if (stringcmp(this,"listnew",-1)|| stringcmp(this,"ln",-1))
			list_new_items(user,TRUE);
		else
		if (stringcmp(this,"listall",-1)||stringcmp(this,"la",-1)||stringcmp(this,"list",-1))
			list_new_items(user,FALSE);
		else
		if (stringcmp(this,"read",5))
		{
			int num;
			char vari[11];
			if ((this=(char *)strtok(NULL," "))==NULL)
			{	printf("Enter message number: ");
				get_str(vari,10);
				if (*vari) sscanf(vari,"%d%*[^\n]",&num);
				else num=0;
			}else
				num=atoi(this);

			sprintf(buff,"Reading folder %s",fold->name);
			strcpy(user->doing,buff);

			if (read_msg(currentfolder,num,user))
				last_mesg=num;
		}
		else
		if (stringcmp(this,"next",5)||stringcmp(this,"forward",8))
		{
			if (last_mesg>=fold->last)
				printf("You are already at the end of this folder.\n");
			else
			if (read_msg(currentfolder,last_mesg+1,user))
				last_mesg++;

			sprintf(buff,"Reading folder %s",fold->name);
			strcpy(user->doing,buff);

		}else
		if (stringcmp(this,"last",-1))
		{
			last_mesg=fold->last;
			printf("Moved to end of folder. (message %d)\n",last_mesg);
			read_msg(currentfolder,last_mesg,user);

			sprintf(buff,"Reading folder %s",fold->name);
			strcpy(user->doing,buff);

		}else
		if (stringcmp(this,"first",-1))
		{
			last_mesg=fold->first;
			printf("Moved to start of folder. (message %d)\n",last_mesg);
			read_msg(currentfolder,last_mesg,user);

			sprintf(buff,"Reading folder %s",fold->name);
			strcpy(user->doing,buff);

		}else
		if (stringcmp(this,"previous",9) || stringcmp(this,"backwards",10))
		{
			if (last_mesg<=fold->first)
				printf("You are already at the beginning of the folder.\n");
			else
				if (read_msg(currentfolder,last_mesg-1,user))
					last_mesg--;
			sprintf(buff,"Reading folder %s",fold->name);
			strcpy(user->doing,buff);

		}else
		if (stringcmp(this,"user",-1)||stringcmp(this,"us",-1))
		{
			if (u_god(user->status)) /*super user*/
			{
				this=(char *)strtok(NULL," ");

				sprintf(buff,"Editing User");
				strcpy(user->doing,buff);
				update_user(user,userposn);
				busy=1;
					edit_user(this);
				busy=0;
				DisplayStack();
			}else
				printf(ERRORMSG);
		}
		else
		if (stringcmp(this,"search",-1))
		{
			if (u_god(user->status)) /*super user*/
			{
				this=(char *)strtok(NULL," ");

				sprintf(buff,"Searching Users");
				strcpy(user->doing,buff);
				update_user(user,userposn);

					search(this);
			}else
				printf(ERRORMSG);
		}
		else
		if (stringcmp(this,"folder",-1)||stringcmp(this,"fol",-1))
		{
			if (u_god(user->status)) /*super user*/
			{
				this=(char *)strtok(NULL," ");

				sprintf(buff,"Editing folder %s",fold->name);
				strcpy(user->doing,buff);
				update_user(user,userposn);

					edit_folder(this);
			}else
				printf(ERRORMSG);
		}
		else
		if (stringcmp(this,"msg",-1))
		{
			this=(char *)strtok(NULL," ");
			if (this==NULL)
				printf("Usage: msg on|off\n");
			else
			if (stringcmp(this,"off",-1) || stringcmp(this,"n",-1))
			{
				if (!u_mesg(user->status))
				{
					user->status|=(1<<4);
					printf("Messages are now off.\n");
				}else
					printf("Messages are already off.\n");
			}else
			if (stringcmp(this,"on",-1) || stringcmp(this,"y",-1))
			{
				if (u_mesg(user->status))
				{
					user->status&=~(1<<4);
					printf("Messages are now on.\n");
				}else
					printf("Messages already on.\n");
			}else
				printf("Use: msg on|off\n");
			update_user(user,userposn);
		}else
		if (stringcmp(this,"inform",-1))
		{
			this=(char *)strtok(NULL," ");
			if (this==NULL)
				printf("Usage: inform on|off\n");
			else
			if (stringcmp(this,"off",-1) || stringcmp(this,"n",-1))
			{
				if (!u_inform(user->status))
				{
					user->status|=(1<<5);
					printf("You will NOT be informed of logins/outs.\n");
				}else
					printf("You are already not informed of logins.\n");
			}else
			if (stringcmp(this,"on",-1) || stringcmp(this,"y",-1))
			{
				if (u_inform(user->status))
				{
					user->status&=~(1<<5);
					printf("You now WILL be informed of logins/outs\n");
				}else
					printf("You are already informed of logins/outs.\n");
			}else
				printf("Use: inform on|off\n");
			update_user(user,userposn);
		}else
		if (stringcmp(this,"beep",-1))
		{
			this=(char *)strtok(NULL," ");
			if (this==NULL)
				printf("Usage: beep on|off\n");
			else
			if (stringcmp(this,"off",-1) || stringcmp(this,"n",-1))
			{
				if (!u_beep(user->status))
				{
					user->status|=(1<<6);
					printf("You will NOT hear any beeps.\n");
				}else
					printf("You have already turned beeps off.\n");
			}else
			if (stringcmp(this,"on",-1) || stringcmp(this,"y",-1))
			{
				if (u_beep(user->status))
				{
					user->status&=~(1<<6);
					printf("You now WILL get beeps.\n");
				}else
					printf("You are already getting beeps.\n");
			}else
				printf("Use: beep on|off\n");
			update_user(user,userposn);
		}else
		if (stringcmp(this,"wizchat",-1) && (u_god(user->status) || s_wizchat(user->special)))
		{
			this=(char *)strtok(NULL," ");
			if (this==NULL)
				printf("Usage: wizchat on|off\n");
			else
			if (stringcmp(this,"off",-1) || stringcmp(this,"n",-1))
			{
				if (!s_chatoff(user->special))
				{
					user->special|=(1<<3);
					printf("You will no longer recieve wizchat.\n");
				}else
					printf("You have already turned wizchat off.\n");
			}else
			if (stringcmp(this,"on",-1) || stringcmp(this,"y",-1))
			{
				if (s_chatoff(user->special))
				{
					user->special&=~(1<<3);
					printf("You will now recieve wizchat messages.\n");
				}else
					printf("You already recieve wizchat messages.\n");
			}else
				printf("Use: wizchat on|off\n");
			update_user(user,userposn);
		}else
		if (stringcmp(this,"su",-1) && s_superuser(user->special))
		{
			this=(char *)strtok(NULL," ");
			if (this==NULL)
				printf("Usage: su on|off\n");
			else
			if (stringcmp(this,"on",-1) || stringcmp(this,"y",-1))
			{
				if (!u_god(user->status))
				{
					user->status|=(1<<2);
					printf("Wiz! Bang! - You're a wizard again.\n");
				}else
					printf("You're already a wizard.\n");
			}else
			if (stringcmp(this,"off",-1) || stringcmp(this,"n",-1))
			{
				if (u_god(user->status))
				{
					user->status&=~(1<<2);
					printf("!gnaB !ziW - You feel rather normal.\n");
				}else
					printf("You already are rather normal.\n");
			}else
				printf("Use: su on|off\n");
			update_user(user,userposn);
		}else
		if (stringcmp(this,"message",-1)||stringcmp(this,"mesg",-1))
		{
			if (u_god(user->status)) /*super user*/
			{
				this=(char *)strtok(NULL," ");

				sprintf(buff,"Editing a Message in folder %s",fold->name);
				strcpy(user->doing,buff);
				update_user(user,userposn);
				busy=1;
					mesg_edit(this,fold->name);
				busy=0;
				DisplayStack();
				sprintf(buff,"Edit Message %s %s",this,fold->name);
				log(buff);
			}else
				printf(ERRORMSG);
		}
		else
		if (stringcmp(this,"new",-1))
		{
			sprintf(buff,"Reading New Messages");
			strcpy(user->doing,buff);
			update_user(user,userposn);
			busy=1;
			new(user);
			DisplayStack();
			busy=0;
			get_folder_number(fold,currentfolder);
			update_user(user,userposn);
		}else
		if (stringcmp(this,"latest",7))
		{
			latest(user);
		}else
		if (stringcmp(this,"write",6))
		{
			sprintf(buff,"Writing in folder %s",fold->name);
			strcpy(user->doing,buff);
			update_user(user,userposn);
			busy=1;
			add_msg(currentfolder,user,0);
			busy=0;
			DisplayStack();
		}else
		if (stringcmp(this,"tell",-1) && u_reg(user->status))
		{
			char *next;
			char *text;
			next=(char *)strtok(NULL," ");
			if (next==NULL)
			{
				printf("Usage: tell <username> <message>.\n");
			}else
			if (s_coventry(user->special))
			{
				printf("You have been sent to 'coventry' you are not allowed to talk to anyone..\n");
			}else
			{
				text=(char *)strtok(NULL,"\n\r");

				sprintf(buff,"Talking to %s",next);
				strcpy(user->doing,buff);
				update_user(user,userposn);

				send_mesg(user->name,next,text,u_god(user->status));
			}
		}else
		if (stringcmp(this,"wiz",-1) && (u_god(user->status) || s_wizchat(user->special)))
		{
			char *text;
			text=(char *)strtok(NULL,"\n\r");
			if (text==NULL)
			{
				printf("Usage: wiz <message>.\n");
			}else
			{
				sprintf(buff,"(%s): %s",user->name,text);
				broadcast(buff,2);
			}
		}else
		if (stringcmp(this,"wall",-1) && u_god(user->status))
		{
			char *text;
			text=(char *)strtok(NULL,"\n\r");
			if (text==NULL)
			{
				printf("Usage: wall <message>.\n");
			}else
				broadcast(text,0);
		}else
		if (stringcmp(this,"doing",-1) && u_god(user->status))
		{
			char *text;
			text=(char *)strtok(NULL,"\n\r");
			if (text==NULL)
			{
				printf("Usage: doing <what>.\n");
			}else
			{
				strcpy(user->doing,text);
				update_user(user,userposn);
			}
		}else
		if (stringcmp(this,"reply",6))
		{
			if (last_mesg==0)
				printf("You have to read a message before you can reply to it.\n");
			else
			{
				sprintf(buff,"Replying in folder %s",fold->name);
				strcpy(user->doing,buff);
				update_user(user,userposn);

				printf("Replying to message %d.\n",last_mesg);
				busy=1;
				add_msg(currentfolder,user,last_mesg);
				busy=0;
				DisplayStack();
			}
		}else
		if (stringcmp(this,"pwd",-1))
		{
			printf("Current folder = %s\n",fold->name);
			if (last_mesg==0)
				printf("You havn't read any messages in this folder yet.\n");
			else
				printf("You last read message %d.\n",last_mesg);
		}
		else
		if (stringcmp(this,"ca",2)) /*catchup*/
		{
			get_folder_number(fold,currentfolder);
			user->lastread[currentfolder]=fold->last;
			update_user(user,userposn);
			printf("Marking folder %s as read.\n",fold->name);
		}
		else
		if (stringcmp(this,"ls",-1))
		{
			if (allowed_r(fold,user))
			{
				int many;
				this=(char *)strtok(NULL," ");
				if (this!=NULL)
					many=atoi(this);
				else many=0;
				ls(currentfolder,user,many);
			}
			else
				printf("You are not permitted to read this folder.\n");
		}
		else
		if (stringcmp(this,"chat",-1))
		{
			if (!internet && getuid()!=300)
			{
				int pid=fork();

				sprintf(buff,"On Chat");
				strcpy(user->doing,buff);
				update_user(user,userposn);

				if(pid==0)
				{
					setgid(getgid());
					setuid(getuid());
					execlp("/usr/local/bin/irc", "irc","-c","#swansea",user->name,NULL);
					perror("irc");
				}
				else
				{
					while(wait(NULL)!=pid);
				}
			}else
				printf("Oh no you don't.\n");
					
		}else
		if (stringcmp(this,"quit",-1)||stringcmp(this,"qq",-1))
		{
			sprintf(buff,"Quitting");
			strcpy(user->doing,buff);
			update_user(user,userposn);

			break;
		}else
		if (stringcmp(this,"topten",-1) && u_god(user->status))
		{
			int x;
			sprintf(buff,"/usr/local/lib/mw/src/utils/topten %s",fold->name);
			signal(SIGCHLD,SIG_DFL);
			x=fork();
			if (x==-1)
				printf("fork() failed.\n");
			else
			if (x==0)
			{
				x=seteuid(getuid());
				if (x<0)
					perror("seteuid");
				else
					execl("/usr/local/lib/mw/src/utils/topten","MW TopTen",fold->name,NULL);
			}else
			{
				do{
					x=wait(NULL);
				}while (x==-1 && errno==EINTR);
				if (x==-1)
					perror("wait");
			}
		}else
		if (stringcmp(this,"board",-1) && u_god(user->status))
		{
			int ftmp;

			this=(char *)strtok(NULL," ");
			if (this==NULL)
				printf("Usage: board lock|unlock\n");
			else
			if (stringcmp(this,"lock",-1))
			{
				if (access(LOCKFILE,00))
				{
					if ((ftmp=creat(LOCKFILE,00))<0)
					{
						printf("Could not lockboard.\n");
						perror("Lock Board");
					}else
					{
						printf("Board now locked.\n");
						close(ftmp);
					}
				}else
					printf("Already Locked.\n");
			}else
			if (stringcmp(this,"unlock",-1))
			{
				if (!access(LOCKFILE,00))
				{
					unlink(LOCKFILE);
					printf("Board now unlocked.\n");
				}else
					printf("Board not locked.\n");
			}else
				printf("Do you want to lock or unlock it.");
		}else
		if (stringcmp(this,"help",5))
		{
			this=(char *)strtok(NULL," ");
			if (access(makepath(HELPDIR,"",""),00))
				printf("Sorry, no help available.\n");
			else
			{
				sprintf(buff,"Reading help");
				strcpy(user->doing,buff);
				update_user(user,userposn);

				help(this,u_god(user->status));
			}
		}
		else
		if (stringcmp(this,"listusers",-1) || stringcmp(this,"lu",-1))
		{
			sprintf(buff,"Listing Users");
			strcpy(user->doing,buff);
			update_user(user,userposn);

			list_users(FALSE);

		}else
		if (stringcmp(this,"newusers",-1) && u_god(user->status))
		{
			list_users(TRUE);
		}else
		if (stringcmp(this,"since",-1))
		{
			sprintf(buff,"Checking Since");
			strcpy(user->doing,buff);
			update_user(user,userposn);

			list_users_since(user->lastlogin);
		}else
		if (stringcmp(this,"mod",-1))
		{
			if (u_mod(user->status))
			{
				sprintf(buff,"Moderating");
				strcpy(user->doing,buff);
				update_user(user,userposn);

				moderate();
			}else
				printf(ERRORMSG);
		}
		else
		if (stringcmp(this,"passwd",-1))
		{
			char pw1[PASSWDSIZE], pw2[PASSWDSIZE], salt[3];
			
				sprintf(buff,"Changing Password");
				strcpy(user->doing,buff);
				update_user(user,userposn);

			salt[2]=0;
			strncpy(salt,user->passwd,2);
			if (strcmp(user->passwd,crypt(get_pass("Enter old password: "),salt)))
				printf("Incorrect.\n");
			else
			{
				pick_salt(salt);
				strcpy(pw1,crypt(get_pass("New password: "),salt));
				strcpy(pw2,crypt(get_pass("Again: "),salt));
				if (strcmp(pw1,pw2))
					printf("Did not match.\n");
				else
				{
					strcpy(user->passwd,pw1);
					update_user(user,userposn);
					printf("Password set.\n");
					log("Passwd");
				}
			}
		}else
		if (stringcmp(this,"resubscribe",12))
		{
			if (get_subscribe(user,currentfolder)==TRUE)
				printf("You are already subscribed to %s.\n",fold->name);
			else
			{
				set_subscribe(user,currentfolder,TRUE);
				printf("Resubscribing to %s.\n",fold->name);
			}
		}else
		if (stringcmp(this,"unsubscribe",12))
		{
			if (get_subscribe(user,currentfolder)==FALSE)
				printf("Already Unsubscribed from %s.\n",fold->name);
			else
			{
				set_subscribe(user,currentfolder,FALSE);
				printf("Unsubscribing from %s.\n",fold->name);
			}
		}else
		if (stringcmp(this,"status",7))
		{
			char stats[10],gr[10];
			show_user_stats(user->status,stats,FALSE);
			show_fold_groups(user->groups,gr,FALSE);
			printf("Current Status of %s\n",user->name);
			printf("Your real name is %s\n",user->realname);
			printf("Your contact address is %s\n",user->contact);
			printf("Your current status is [%s]\n",stats);
			printf("You have set messages %s\n",u_mesg(user->status)?"off.":"on.");
			printf("You will%s be informed of logins and logouts\n",u_inform(user->status)?" not":"");
			printf("You will%s hear beeps.\n",u_beep(user->status)?" not":"");
			if (u_god(user->status) || s_wizchat(user->special))
			{
				printf("You can use wizchat");
				if (s_chatoff(user->special))
					printf(", but you will not hear any replies");
				printf(".\n");
			}
			if (*gr) printf("You belong to the following group(s) [%s]\n",gr);
			printf("You are currently in folder %s, which you ",fold->name);
			printf(get_subscribe(user,currentfolder)?"are":"are not");
			printf(" subscribed to.\n");
			time_on(user->timeused+(time(0) - loggedin));
		}else
		if (stringcmp(this,"who",-1)||stringcmp(this,"qw",-1))
		{
			sprintf(buff,"Checking 'Who'");
			strcpy(user->doing,buff);
			update_user(user,userposn);

			who_list(u_god(user->status));
		}else
		if (stringcmp(this,"credits",-1) || stringcmp(this,"debits",-1))
			credits();
		else
		if (stringcmp(this,"date",-1))
		{
			long tm;
			tm=time(0);
			printf("Current time and date is %s",ctime(&tm));
		}else
		if (this)
		{
			printf(ERRORMSG);
		}
		update_user(user,userposn);
		if (u_ban(user->status))
		{
			printf("--> You appear to have been banned. Goodbye... <--\r\n");
			break;
		}

	}	
	user->timeused+= time(0) - loggedin;
	user->lastlogin=time(0);
	update_user(user,userposn);
	who_delete(getpid());
#ifdef RWHO
	rwhocli_userlogout(user->name);
#endif

	if (!(u_god(user->status) && argc==2 && !strcmp(argv[1],"-quiet")))
	{
		sprintf(buff,"%s has just left the board.",user->name);
		broadcast(buff,1);
	}

	log("Logged Out");
	free(user);
	free(fold);
	close_fifo();
}


void printfile(filename)
char *filename;
{
	FILE *afile;
	char buff[512];
	int l;
	
	if ((afile=fopen(filename,"r"))==NULL)
		{perror(filename);exit(-1);}
	while ((l=fread(buff,1,512,afile))>0)
		fwrite(buff,1,l,stdout);
	fclose(afile);
}

void help(args, wiz)
char *args;
int wiz;
{
	if (args!=NULL &&(strchr(args,'.')!=NULL || strchr(args,'/')!=NULL))
	{
		printf("Sorry, no help available on that subject. *:-)\n");
		return;
	}
	
	if (args==NULL)
	{
		printfile(makepath(HELPDIR,"/","general"));
		if (wiz)
		{
			printfile(makepath(WIZHELP,"/","general"));
		}
	}else
	{
		int found=FALSE;
		char *x;
		x=makepath(HELPDIR,"/",args);
		if (!access(x,00))
		{
			printfile(x);
			found=TRUE;
		}
		if (wiz && !found)
		{
			x=makepath(WIZHELP,"/",args);
			if (!access(x,00))
			{
				printfile(x);
				found=TRUE;
			}
		}		
		if (!found)
			printf("No help available on that subject.\n");
	}
}


void credits()
{
	printf("The Milliways III bulletin board system.\n");
	printf("(c) 1992 Arthur Dent (J.S.Mitchell)\n");
	printf("\nLinux / Internet patches: Anarchy\n");
	printf("General Thanks to:\n");
	printf("Arashi(ideas), Hobbit(spellings), Madsysop(for being annoying).\n\n");
}


int incoming_pipe;

struct mstack
{
	char *text;
	struct mstack *next;
};
	
static struct mstack *MesgStack=NULL;
static int MesgStacked=0;

void StackMesg(text)
char *text;
{
	struct mstack *new;
	new=(struct mstack *)malloc(sizeof(struct mstack));
	new->text=(char *)malloc(strlen(text)+1);
	strcpy(new->text,text);
	new->next=NULL;
	if (MesgStack==NULL)
	{
		MesgStack=new;
		MesgStacked=1;
	}else
	{
		struct mstack *ptr;
		ptr=MesgStack;
		while (ptr->next!=NULL) ptr=ptr->next;
		ptr->next=new;
		MesgStacked++;
	}
}

void DisplayStack()
{
	struct mstack *new;
	struct mstack *old;

	new=MesgStack;
	while (new!=NULL)
	{
		write(1,new->text,strlen(new->text));
		free(new->text);
		old=new->next;
		free(new);
		MesgStacked--;
		new=old;
	}
	MesgStack=NULL;
}

void incoming_mesg(ignore)
int ignore;
{
	extern struct person *user;
	int nos,i;
	char buff[1500];
	char newbuff[1500];
	int ptr=0;
	static state=0;

/*	signal(SIGUSR1,incoming_mesg);
*/	while ((nos=read(incoming_pipe,buff,1024))>0)
	{
	for (i=0;i<nos;i++)
	{
		if (buff[i]==1)
		{
			new_mail_waiting++;
		}else
		if (buff[i]>=FORCE_STATUS && buff[i]<=FORCE_SPECIAL)
		{
			state=buff[i];
			if (ptr>0)
			{
				if (!u_beep(user->status)) strcat(newbuff,"\7");
				if (busy) StackMesg(newbuff);
				else write(1,newbuff,strlen(newbuff));
				ptr=0;
			}
		}else
		if (buff[i]=='!' && state!=0 )
		{
			newbuff[ptr]=0;
			if (state==FORCE_STATUS)
				user->status=user_stats(newbuff,user->status);
			else if (state==FORCE_GROUPS)
				user->groups=folder_groups(newbuff,user->groups);
			else if (state==FORCE_REALNAME)
				strcpy(user->realname,newbuff);
			else if (state==FORCE_CONTACT)
				strcpy(user->contact,newbuff);
			else if (state==FORCE_SPECIAL)
				user->special=set_special(newbuff,user->special);
			else if (state==FORCE_LASTREAD)
			{
				int fol,pos;
				sscanf(newbuff,"%d:%d",&fol,&pos);
				user->lastread[fol]=pos;
			}
			ptr=0;
			state=0;
		}else
		{
		 	newbuff[ptr]=buff[i];
		 	ptr++;
		}
	}
	newbuff[ptr]=0;
	if (ptr>0)
	{
		char tb[1024];
		sprintf(tb,"\n%s",newbuff);
		if (!u_beep(user->status)) strcat(tb,"\7");
		if (busy) StackMesg(tb);
		else write(1,tb,strlen(tb));
	}
	
	}
}

void open_fifo()
{
	if ((incoming_pipe=open(get_pipe_name(getpid()),O_RDONLY|O_NDELAY))<0)
	{
		perror("Error opening incoming pipe");
		exit(-1);
	}
}

void close_fifo()
{
	if(incoming_pipe)
		close(incoming_pipe);
	unlink(get_pipe_name(getpid()));
}


void time_out(ignore)
int ignore;
{
	char buff[128];
	if (idle_count==1)
	{
		char msg[30];
		strcpy(msg,"*** Timed Out, Good Bye\r\n");
		idle_count++;
		alarm(60);
		write(1,msg,strlen(msg));

		who_delete(getpid());
#ifdef RWHO
		rwhocli_userlogout(user->name);
#endif

		sprintf(buff,"%s has been timed out.",user->name);
		broadcast(buff,1);

		log("Timed Out");
		close_fifo();

		exit(-1);
	}else
	if (idle_count==0)
	{
		char msg[30];
		strcpy(msg," *** Wakey ! Wakey !\r\n");
		msg[0]=7;
		idle_count++;
		alarm(120);
		update_user(user,userposn);	
		write(1,msg,strlen(msg));
	}else
	{
		log("TimedOut (blocked)");
		close_fifo();
		exit(-1);
	}
	
}

