/*********************************************************
 *     The Milliways III System is copyright 1992        *
 *      J.S.Mitchell. (arthur@sugalaxy.swan.ac.uk)       *
 *       see licence for furthur information.            *
 *********************************************************/
#include <stdio.h>
#include <fcntl.h>
#include <ctype.h>
#include <string.h>
#include "bb.h"

extern int eof_caught;
extern int remote;
extern int busy;

int add_msg(folnum,user,replyto)
int folnum;
struct person *user;
int replyto;
{
	struct Header *new;
	struct Header inreplyto;
	long replyposn=0l;
	struct folder *fol;
	int index,data,folderfile;
	int ptr=0;
	int limit;
	char *buff;
	char answer[10];
	char c; /* temporary storage of a character */
	long up; /*temp*/
	struct person usr; /*temp*/
	long tt,td; /* for calculating position error in index file */

	fol=(struct folder *)malloc(sizeof(*fol));
	new=(struct Header *)malloc(sizeof(*new));
	/* check write status of folder */
	
	get_folder_number(fol,folnum);
	if (!allowed_w(fol,user))
		{printf("Not allowed to write to this folder.\n");return(0);}
	/* Assign header information */
	if (!remote)
	if (replyto==0)
		printf("Writing in folder %s.\n",fol->name);	
	else
		printf("Replying to message %d in folder %s\n",replyto,fol->name);
	
	if (!remote && is_private(fol,user))
	{
		printf("Note: Operators have the right to read any 'private' messages.\n");
		printf("    : If you don't like this, don't write private messages.\n");	
	}
	if (replyto>0)
	{
		long posn,tmppos;
		int headfile;

		if ((headfile=err_open(makepath(fol->name,INDEX_END,""),O_RDONLY,0))<0)
			return(0);

		posn=(replyto-(fol->first))*sizeof(struct Header);
		tmppos=lseek(headfile,0,2);
		if (posn<0 || posn>tmppos-sizeof(struct Header))
		{
			printf("There is no message %d\n",replyto);
			close(headfile);
			return(-1);
		}else
			lseek(headfile,posn,0);
		while (get_data(headfile,&inreplyto) && inreplyto.Ref<replyto);
		if (inreplyto.Ref!=replyto)
		{
			printf("reply: Error, could not find old message !\n");
			close(headfile);
			return(0);
		}
		replyposn=lseek(headfile,0,1)-sizeof(inreplyto);	
		close(headfile);
		inreplyto.status|=(1<<2);
	}
	
	new->replyto=replyto;	
	new->status=0;
	if (remote) new->status|=(1<<3);
	
	new->date=time(0);
	if (!remote) printf("Message from %s\n",user->name);
	strcpy(new->from,user->name);
	if (replyto==0)
	{
		char t[NAMESIZE+1];
		if (!remote) printf("Send to: ");
		get_str(new->to,SUBJECTSIZE);
		strcpy(t,new->to);
		strip_name(t);
		if (is_private(fol,user) && !is_old(&usr,t,&up))
		{ 
			printf("Message must be addressed to an existing user.\n");
			return(0);
		}
	}
	if (replyto==0)
	{
		if (!remote)
		printf("Subject: ");
		get_str(new->subject,SUBJECTSIZE);
	}else
	{
		char foo[SUBJECTSIZE+1];
		printf("\nEnter subject or press <ENTER> to accept old.\n");
		printf("Subject: %s\n",inreplyto.subject);
		printf("Subject: ");
		get_str(foo,SUBJECTSIZE);
		if (*foo)
		{
			printf("Send to: ");
			get_str(new->to,SUBJECTSIZE);
			if (is_private(fol,user) && !is_old(&usr,new->to,&up))
			{ 
				printf("Message must be addressed to an existing user.\n");
				return(0);
			}
			strcpy(new->subject,foo);
		}
		else
		{
			strcpy(new->subject,inreplyto.subject);
			strcpy(new->to,inreplyto.from);
			printf("Marked as To: %s\n",new->to);
		}
	}	
	/* read in main message text */
	
	clearerr(stdin);	
	buff=(char *)malloc(1024);
	limit=1024;
	if (!remote)
	printf("Enter message ending with a . on a new line\n");
	if (!feof(stdin)) buff[ptr++]=getachar();
	while (!feof(stdin) && buff[ptr-1]!=26 && buff[ptr-1]!=4)
	{
		c=getachar();

		if(c=='.'&&buff[ptr-1]=='\n')
			break;

		if (c=='\n') alarm(TIMEOUT); /* reset timeout */
		if ((isprint(c) || isspace(c)) && c!='\r' ) buff[ptr++]=c;
		if (ptr==limit){
			limit+=1024;
			buff=(char *)realloc(buff,limit);
		}
	}
/*	if(buff[ptr-1]=='.')
	{
		if(internet)
			getachar();
		ptr-=2;
	}
*/
	buff[ptr]=0;
	tidy_string(buff);
	new->size=ptr;
	if (!feof(stdin)&&!internet) read2cr();
	clearerr(stdin);
	/* read in current folder status & prepare message for saveing */

	if (!remote)	
	do{
		printf("Post message, edit, reformat, or Abandon ?");
		get_str(answer,9);
		if (eof_caught==1) break;
		if (stringcmp(answer,"abandon",8)) return(0);
		if (stringcmp(answer,"reformat",9))
		{
			printf("Reformatting...");
			filter_returns(buff);
			tidy_string(buff);
			printf("Done.\r\n");
		}
		if (stringcmp(answer,"edit",5))
		{
			int tfile;
			int mask;
			char foo[128];
			char fullpath[18];
			long size;
			if (chdir("/tmp"))
				{perror("chdir");return(0);}
			sprintf(fullpath,"mw3XXXXXX");
			mktemp(fullpath);
			mask=umask(~0660);
			if ((tfile=err_open(fullpath,O_WRONLY|O_CREAT,0666))<0)
			{return(0);}
			write(tfile,buff,new->size);
			close(tfile);
			umask(mask);
			sprintf(foo,"%s %s",SECUREEDITOR,fullpath);
			system(foo);
			if ((tfile=open(fullpath,O_RDONLY))<0)
				{perror("reading temp file");return(0);}
			size=lseek(tfile,0,2);
			lseek(tfile,0,0);
			buff=(char *)realloc(buff,size);
			read(tfile,buff,size);
			new->size=size;
			close(tfile);
			unlink(fullpath);
		}
	}while (!stringcmp(answer,"post",2));

	folderfile=openfolderfile(O_RDWR);
	Lock_File(folderfile);
		
	/* open files ready for saveing */
	
	if ((index=err_open(
		makepath(fol->name,INDEX_END,is_moderated(fol,user)?MOD_END:"")
		,O_CREAT|O_RDWR,0600))<0)
		{exit(-1);}
	if ((data=err_open(
		makepath(fol->name,TEXT_END,is_moderated(fol,user)?MOD_END:"")
		,O_APPEND|O_CREAT|O_WRONLY,0600))<0)
		{exit(-1);}
	Lock_File(folderfile);
	Lock_File(index);
	Lock_File(data);
	
	new->datafield=lseek(data,0l,2);
	lseek(folderfile,folnum*sizeof(struct folder),0);
	read(folderfile,fol,sizeof(*fol));
	lseek(folderfile,-1*sizeof(struct folder),1);
	if (!is_moderated(fol,user))
	{
		new->Ref=fol->last+1;
		fol->last++;
		if (fol->first==0) fol->first=1;
		if (replyto>0)
		{
			lseek(index,replyposn,0);
			write(index,&inreplyto,sizeof(inreplyto));
		}
	}else
	{
		new->Ref=0;
	}
	
	tt=lseek(index,0,2);
	td=tt%sizeof(*new);
	
	if (td>0){
		printf("Warning: Index error, skipping back %d bytes.\r\n",td);
		lseek(index,-td,1);
	}
	if ((write(index,new,sizeof(*new)))<sizeof(*new))
		{perror("index");exit(-1);}
	if ((write(data,buff,new->size))<new->size)
		{perror("text");exit(-1);}
	if (!is_moderated(fol,user))
		if ((write(folderfile,fol,sizeof(*fol)))<sizeof(*fol))
			{perror(FOLDERFILE);exit(-1);}
	Unlock_File(data);
	Unlock_File(index);
	Unlock_File(folderfile);
	
	close(index);
	close(data);
	close(folderfile);
	if (is_private(fol,user))
		inform_of_mail(new->to);
	return(0);
}

int next_ref_no()
{
	return(1);
}
