/*
 *		    -  - ----==== Y A M A ====---- -  -
 *			
 *			     (c) Alan Cox 1990
 *
 *	This program (YAMA) is made publicly available. Both sources
 *	and object code. The only prohibition on this software is its use
 *	for commercial purposes or the use of games developed on the system
 *	for commercial purposes of any kind.
 *
 *	YAMA is supplied without any warranty implicit or otherwise, and is
 *	used entirely at the operators risk. The author accepts no liability
 *	for anything that occurs directly, indirectly or otherwise as a result
 *	of the use, and or possesion of this software.
 */

/*
 *	Configuration Options
 */
 

/*
 *	Unsupported
#define LOW_MEMORY		/* Build a system with room longtexts on disk 
*/
/*#define DAFT_CPP*/		/* Thick CPP or CC that cant handle the
				   exotic inline macros - setting this
				   avoids them but loses range checking */
#define MAXU	32		/* Max users at a time - dont put this over
				   max file descriptors - 6 */
#define MAXLOOP	16		/* Maximum number of loops at once */
#define MAXRECURSE 64		/* Max table recursion */

/*
 *	Define PYR to get a client interface to RMOL chat
 *	Define TELNET to get a Telnet server
 *	or none of the above to generate a SYSV shared memory server
 */
#define UNIX
/*#define PYR */
/*#define TELNET*/
#ifdef PYR
#define NET
#endif
#ifdef TELNET
#define NET
#endif

typedef long tag;

#define ISOBJ(x)	(x)
#define ISNUM(x)	(x)
#define ISMSG(x)	(x)	/* For future expansion/checking */

#define IFMSG(x)	(1)
#define IFNUM(x)	(1)
#define IFOBJ(x)	(1)	/* You guessed it */

#define OBJ(x)		(x)
#define MSG(x)		(x)
#define NUM(x)		(x)
#define FLAG(x)		(x)	/* And again... */

typedef tag ** TABLE;
typedef tag *  LINE;
typedef tag	ITEM;

/*
 *	System default RVC queries
 */
 
#define RVC_EXIT	(-3)
#define RVC_WEIGHT	(-4)
#define RVC_SIZE	(-5)
#define RVC_LEVEL	(-6)
#define RVC_SCORE	(-7)
#define RVC_STRENGTH	(-8)
#define RVC_SNOOP	(-9)
#define RVC_VIS		(-10)
#define RVC_LDESC	(-11)
#define RVC_NAME	(-12)
#define RVC_ODESC	(-13)


struct ItemHeader
{
	char *ih_Name;
	short ih_Adj;
	short ih_Noun;
	TABLE ih_Control;
	short ih_Child,ih_Next;
};

	
struct Object
{
	struct ItemHeader o_header;
#define ob_Name o_header.ih_Name
#define ob_Adj o_header.ih_Adj
#define ob_Noun o_header.ih_Noun
#define ob_Table o_header.ih_Control
#define ob_Child o_header.ih_Child
#define ob_Next o_header.ih_Next
	tag ob_Data[16];
	char **ob_Desc;
};

struct  Room
{
	struct ItemHeader r_header;
#define rm_Name r_header.ih_Name
#define rm_Adj r_header.ih_Adj
#define rm_Noun r_header.ih_Noun
#define rm_Table r_header.ih_Control
	tag rm_Data[16];
#ifdef LOW_MEMORY
	unsigned long rm_Long;
#else
	char *rm_Long;
#endif
};

struct Player
{
	struct ItemHeader p_header;
#define pl_Name p_header.ih_Name
#define pl_Adj _header.ih_Adj
#define pl_Noun p_header.ih_Noun
#define pl_Table p_header.ih_Control
	tag pl_Data[32];
	char *pl_IOH[3];
	long pl_PwKey;
};

struct StackFrame
{
	struct StackFrame *Previous;
	int LoopInfo[MAXLOOP];
	int ForLoop[MAXLOOP];
	int ForLoc[MAXLOOP];
	int ForVar[MAXLOOP];
	int ForType[MAXLOOP];
	int UserLoop[MAXLOOP];
	int UserVar[MAXLOOP];
};


/*
 *	The macros now all call functions in macro.c mainly due to the size
 *	they were becoming
 */

#define ISITEM(x)	(mac_IsItem(x))
#define VALID(x)	(mac_Valid(x))

#define OBJECT(x)	(mac_Object(x))
#define PLAYER(x)	(mac_Player(x))
#define ROOM(x)		(mac_Room(x))

#ifdef OVERR
#define RDESC(x)	(TQuery(x,ROOM(x)->rm_Long,RVC_LDESC))
#else
#define RDESC(x)(ROOM(x)->rm_Long)
#endif
#define FLAGS(x)	((OBJECT(x)->ob_Data[0]))
#define LOC(x)		((OBJECT(x)->ob_Data[1]))
#ifdef OVERR
#define NAME(x)		(TQuery(x,OBJECT(x)->ob_Name,RVC_NAME))
#else
#define NAME(x)		(OBJECT(x)->ob_Name)
#endif

#define KEY(x)		((OBJECT(x)->ob_SysKey))

#ifdef OVERR
#define EXIT(x,y)	(NQuery2(x,ROOM(x)->rm_Data[(y)+2],RVC_EXIT,y))
#else
#define EXIT(x,y)	(ROOM(x)->rm_Data[(y)+2])
#endif
#define SETEXIT(x,y,z)	(ROOM(x)->rm_Data[(y)+2]=z)
#define RUSER(x,y)	(ROOM(x)->rm_Data[(y)+14])
#define DROPTO(x)	(ROOM(x)->rm_Data[14])	/* OBSOLETE */

#define STATE(x)	((OBJECT(x)->ob_Data[2]&0x0F))
#define MAXSTATE(x)	(((OBJECT(x)->ob_Data[2]&0xF0))>>4)
#ifndef OVERR
#define WEIGHT(x)	(OBJECT(x)->ob_Data[3])
#else
#define WEIGHT(x)	(NQuery(x,OBJECT(x)->ob_Data[3],RVC_WEIGHT))
#endif
#define SETWEIGHT(x,y)	OBJECT(x)->ob_Data[3]=(y);
#ifdef OVERR
#define SIZE(x)		(NQuery(x,OBJECT(x)->ob_Data[4],RVC_SIZE))
#else
#define SIZE(x)		(OBJECT(x)->ob_Data[4])
#endif

#define SETSIZE(x,y)	OBJECT(x)->ob_Data[4]=(y);
#define CLASS(x)	(OBJECT(x)->ob_Data[5])
#define OUSER(x,y)	(OBJECT(x)->ob_Data[y+6])

#ifdef OVERR
#define LEVEL(x)	(NQuery(x,PLAYER(x)->pl_Data[2],RVC_LEVEL))
#define SCORE(x)	(NQuery(x,PLAYER(x)->pl_Data[3],RVC_SCORE))
#define STRENGTH(x)	(NQuery(x,PLAYER(x)->pl_Data[4],RVC_STRENGTH))
#define SNOOP(x)	(NQuery(x,PLAYER(x)->pl_Data[5],RVC_SNOOP))
#define VIS(x)		(NQuery(x,PLAYER(x)->pl_Data[6],RVC_VIS))
#else
#define LEVEL(x)	(PLAYER(x)->pl_Data[2])
#define SCORE(x)	(PLAYER(x)->pl_Data[3])
#define STRENGTH(x)	(PLAYER(x)->pl_Data[4])
#define SNOOP(x)	(PLAYER(x)->pl_Data[5])
#define VIS(x)		(PLAYER(x)->pl_Data[6])
#endif
#define SETLEVEL(x,y)	PLAYER(x)->pl_Data[2]=(y);
#define SETSCORE(x,y)	PLAYER(x)->pl_Data[3]=(y);
#define SETSTRENGTH(x,y)PLAYER(x)->pl_Data[4]=(y);
#define SETSNOOP(x,y)	PLAYER(x)->pl_Data[5]=(y);
#define SETVIS(x,y)	PLAYER(x)->pl_Data[6]=(y);
#define PUSER(x,y)	(PLAYER(x)->pl_Data[y+7])

#define ADJ(x)		(OBJECT(x)->ob_Adj)
#define NOUN(x)		(OBJECT(x)->ob_Noun)

#define FL_TABITEM	0	/* Not yet implemented - true virtual item */
#define FL_PLAYER	1
#define FL_ROOM		2
#define FL_OBJECT	3
#define FL_TYPEMASK	3

#define TYPE(ct)	(FLAGS(ct)&FL_TYPEMASK)
#define PFL_BRIEF	4
#define PFL_MALE	8
#define PFL_BLIND	16
#define PFL_DEAF	32
#define PFL_ASLEEP	64
#define PFL_SEEDARK	128

#define OFL_FLANNEL	4
#define OFL_LIT0	8
#define OFL_LITALL	16
#define OFL_WORN	32

#define RFL_FALL	4
#define RFL_DARK	8
#define RFL_SMALL	16
#define RFL_DEATH	32

#ifdef OVERR
#define ODESC(x,y)	(TQuery2(x,OBJECT(x)->ob_Desc[y],RVC_ODESC,y))
#else
#define ODESC(x,y)	(OBJECT(x)->ob_Desc[y])
#endif

#define CANSEE(a,b)	(((LEVEL(a)>=VIS(b))||(a==b))&&(IsDarkFor(a)==0))
#define GCANSEE(a,b)	(TYPE(b)!=FL_PLAYER||((LEVEL(a)>=VIS(b))||(a==b)))



struct Word
{
	char *wd_Text;
	tag   wd_Code;
	short wd_Type;
	long  wd_Use;
	struct Word *wd_Next;
};

struct User
{
	short us_Uid;
	short us_Handle;
	short us_State;
	short us_Flag;
};

typedef struct User USER;

extern USER UserArray[MAXU];

struct Packet
{
	short pk_Code;
	short pk_Handle;
	short pk_Data;
	char  pk_Text[256];
};

typedef struct Packet PACKET;

#define PK_DISC	0
#define PK_CONN 1
#define PK_TXLN 2
#define PK_ECHO	3
#define PK_DISA 4
#define PK_SRVD 5
#define PK_PRMP 6
#define PK_ENAB 7
#define PK_NECH 8
#define PK_IDSC 9
#define PK_EDSC 10
#define PK_UPDT 11
#define PK_SNPT 12
#define PK_SNPE 13
#define PK_SNPS 14

#define US_IDLE	0
#define US_CMD	1
#define US_GNAM	2
#define US_GEPW	3
#define US_SEPW	4
#define US_VEPW	5
#define US_GSEX	6
#define US_CPWC	7
#define US_CPWN	8
#define US_CPWV 9

#define EXTENDED_KERNEL

#include "prototyp.h"
