#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include "struct.h"
#ifdef PYR
#include "Chat/apppkt.h"
#else
#define US_ONLY	1
#endif

/*
 *	This set of routines handle the reporting of messages. To ensure the
 *	output looks tidy, and to allow snoop to work nicely we collect
 *	input a line at a time. We assume 80 char screens - this probably
 *	should be a define.
 */


static char block[MAXU][81];	/* Buffer for each user */
static int sup_self=0;		/* Set to 1 when reporting cmds */

void ReportInput(x,u)
tag u;
char *x;
{
	/*OBJ(u);*/
	sup_self=1;
	TellUser(u,"%s\n",x);
	sup_self=0;
}
	
/*
 *	Send messages to users. This is potentially a problem function too.
 *	It should be varargs, but not all the compilers have this feature, so
 *	for the moment it assumes things. It should be safe on anything but the
 *	the most wierd of architectures.
 */

void UPrintf(char *m, ...)
{
	va_list a;
	va_start(a,m);
	if(Me()<ISOBJ(0))
	{
		fprintf(stderr,"[ERROR]: Message to garbage user.\n");
		exit(1);
	}
	if(Me()<ISOBJ(MAXU))
		SendIO(Me(),m,a);
	va_end(a);
}

void TellUser(tag u,char *m,...)
{
	va_list x;
	va_start(x,m);
	if(u<ISOBJ(MAXU))
		SendIO(u,m,x);
	va_end(x);
}

/*
 *	Move to a specific tab position.
 */

void Set_Tab(u,n)
tag u;
int n;
{
	if(u>ISOBJ(MAXU))
		return;
	while(strlen(block[u])%n)
		ch_out(u,' ');
}

/*
 *	Send something to a user: Comments RE varargs apply here also
 */
 
void SendIO(tag u,char *msg,va_list a)
{
	SendUser(u,msg,"",a);
}

#ifdef PYR

/*
 *	RMOL chat likes things in ascii for some reason.
 */
 
char *itoa(x)
int x;
{
	static char buf[6];
	sprintf(buf,"%d",x);
	return(buf);
}
#else
#define itoa(x)	(x)
#endif

/*
 *	Build the snooping version of an input line. You can put any header char
 *	you like on this, but Essex MUD1 used '|' and some terminal emulators
 *	have a 'Mud mode' to split snoops into a different window so its best
 *	left for compatibility
 */

char *snoopof(x)
char *x;
{
	static char bf[82];
	strcpy(bf+1,x);
	*bf='|';
	return(bf);
}

/*
 *	Add a character to the buffer
 */

void ch_out(tag u,char c)
{
	int ct=ISOBJ(0);
	if(c=='\n')
	{
		if(sup_self==0)
			say_to_user(US_ONLY,itoa(UserArray[OBJ(u)].us_Handle),block[OBJ(u)]);
		while(ct<ISOBJ(MAXU))
		{
			if(SNOOP(ct)==u&&*block[OBJ(u)]!='|'
#ifndef NET
		&&ChkRedraw()==0
#endif
			)
				say_to_user(US_ONLY,itoa(UserArray[OBJ(ct)].us_Handle),snoopof(block[OBJ(u)]));
			ct++;
		}
		*block[OBJ(u)]=0;
		return;
	}
	if(strlen(block[OBJ(u)])==79)
	{
		ch_out(OBJ(u),'\n');
		if(c==' ') return;
	}
	block[OBJ(u)][strlen(block[OBJ(u)])+1]=0;
	block[OBJ(u)][strlen(block[OBJ(u)])]=c;
}

/*
 *	Our main sending routine. Currently you are limited to sending a max
 *	of 4K of data in one go.. or the blob array will over run. If this
 *	was only to run on UN*X this could be dealt with.
 */

void SendUser(tag u,char *msg,char *hd,va_list a)
{
	char blob[4096];
	char *bp=blob;
	vsprintf(blob,msg,a);
/*	printf("SEND:'%s'\n",blob);*/
	if(*hd)
		ch_out(u,*hd);
	while(*bp)
	{
		ch_out(u,*bp++);
	}
}
