#define PROBDIR "/users/cosc/staff/paul/prog.contest/prob.sets"
#define PROBVAR "PROBDIR"          /* Env var that can override PROBDIR */
#define JUDGE  "paul"              /* User code for progsub to mail to  */
#define JUDGEVAR "JUDGE"           /* Env var that can override JUDGE   */

/*
 * By defualt, programs act on the contest pointed to by the symbolic
 * link PROBDIR/CURRENT_COMP.  CURRENT_COMP can be overridden by the 
 * PROBSET_ENV_NAME environment variable.
 */
#define CURRENT_COMP "current.comp"
#define PROBSET_ENV_NAME "PROBSET"
#define SUBDIR "subs"               /* subdir that contains team submissions */
#define RESULTS_FILE "results"      /* file stored in each teams submit dir  */


#define LANG_LETTERS "c:mod:p"         /* C, Modula, Pascal */
#define PREFIX "problem"

#define WRONG_PENALTY 20

#define CORRECT       0
#define SYNTAX        1
#define CLARIFICATION 2
#define RUN_TIME      3
#define OVER_TIME     4
#define WRONG         5
#define FAILED_TEST   6
#define INACCURATE    7
#define LITTLE_MUCH   8
#define BAD_FORMAT    9

#define MIN_RES CORRECT
#define MAX_RES BAD_FORMAT

struct result_list {
	char *program;
	int result;
	struct result_list *next;
};

char *check_env_var();
char *get_teamdir();
char *get_contest_name();
int  read_results();
int  write_results();
char extract_problem();
int  extract_version();
char *error_message();
char *emalloc();
int  prob_search();
