program change (input, output);

const
  MAX_CHANGE = 80;  {400 div 5;}

type
  coin_type = (c5, c10, c20, c50, d1, d2, end_coin);
  coin_array = array[c5..d2] of integer;

var
  value: coin_array;
  coins_change: array[0..MAX_CHANGE] of integer;
  number_coins: coin_array;
  best_count: integer;


procedure initialise;

  var
    coin_loop: coin_type;
    loop: integer;

  begin

  value[c5] := 5;
  value[c10] := 10;
  value[c20] := 20;
  value[c50] := 50;
  value[d1] := 100;
  value[d2] := 200;
  for coin_loop := c5 to d2 do
    value[coin_loop] := value[coin_loop] div 5;

  coins_change[0] := 0;
  for loop := 1 to MAX_CHANGE do
    coins_change[loop] := MAXINT;
  coin_loop := end_coin;
  repeat
    coin_loop := pred(coin_loop);
    for loop := 0 to MAX_CHANGE - value[coin_loop] do
      if (coins_change[loop] < MAXINT) AND (coins_change[loop] + 1 < coins_change[loop + value[coin_loop]]) then
        coins_change[loop + value[coin_loop]] := coins_change[loop] + 1;
  until (coin_loop = c5);
  end;


procedure check (coin: coin_type;
                total, count: integer);

  var
    loop: integer;

  begin
  if (total >= -MAX_CHANGE) and (count < best_count) then
    begin
    if (total <= 0) AND (count + coins_change[-total] < best_count) then
      best_count := count + coins_change[-total];
    if (coin < end_coin) then
      begin
      for loop := 0 to 5 do
        if (number_coins[coin] >= loop) then
          check(succ(coin), total - value[coin] * loop, count + loop);
      end;
    end;
  end;


procedure doit;

  var
    coin_loop: coin_type;
    total_real: real;
    total, count: integer;
    zeroes: boolean;

  begin
  repeat
    zeroes := TRUE;
    for coin_loop := c5 to d2 do
      begin
      read(number_coins[coin_loop]);
      zeroes := zeroes and (number_coins[coin_loop] = 0);
      end;
    if not zeroes then
      begin
      readln(total_real);
      total := trunc(total_real * 100 + 0.1);
      total := total div 5;
(*writeln('Total is ', total * 5);*)

(* Use biggest coins to get to one coin below total *)
      coin_loop := d2;
      count := 0;
      while (number_coins[coin_loop] = 0) do
        coin_loop := pred(coin_loop);
      while (total >= value[coin_loop]) do
        begin
        count := count + 1;
        total := total - value[coin_loop];
        number_coins[coin_loop] := number_coins[coin_loop] - 1;

        while (number_coins[coin_loop] = 0) and (coin_loop > c5) do
          coin_loop := pred(coin_loop);
        end;

(*writeln('Just below total, count is ', count);*)

(* Now try combinations of coins from here to find best fit *)
      if (total = 0) then
        best_count := count
      else
        best_count := count + coins_change[value[coin_loop] - total] + 1;
(*writeln('Starting with best count ', best_count);*)
      check(c5, total, count);
      writeln(best_count:3);
      end;
  until zeroes;
  end;


begin
initialise;
doit;
end.
