/*
 * Author: Paul Ashton
 * Date written: September 12th 1992
 *
 * Files: stdin - team's solution.
 *        progin - input used to produce solution
 *        judgeout - output of judging program where progin was the
 *                   input file.
 *
 * Algorithm: For each pair of input strings
 *            1. The strings are read in from progin.
 *            2. The length of the judge's and team's solns are compared.
 *            3. The team's program is executed on the input string and
 *               the resulting string is compared with the output
 *               string specified in infile.
 */

#include <stdio.h>
#include <ctype.h>
#include <string.h>

/*
 * These pathnames assume that this program is run when the current directory
 * is the submission directory of the team whose answer is being checked.
 */
#define PROGIN "../../input/a"
#define JUDGEOUT "../../answers/a"

#define INSTRLEN 4
#define MAXSTRLEN 20
#define WORKLEN (2 * MAXSTRLEN)
/*
 * In the worst case we could do a delete for each character in the original
 * then an insert for each character in the target string - i.e. two
 * instructions per character.
 */
#define MAXPROGLEN ((MAXSTRLEN) * (INSTRLEN) * 2)

typedef char StrType[MAXSTRLEN+1];	/* holds a (initial or final) string */
typedef char ProgType[MAXPROGLEN+2];    /* hold a program - extra char for \n*/

void ReadAnswer();

static char *progname;
static int linenum = 0;              /* Used in diagnostics */
int error = 0;

main(argc, argv)
        int argc;
        char *argv[];
{
	FILE *progin, *judgeout;
	StrType initial, final;
	ProgType judge, team;
	char work_store[WORKLEN+1];
	char *cp;
	int posn;
	int len;
	
	progname = argv[0];

	if ((progin = fopen(PROGIN, "r")) == 0) {
		fprintf(stderr, "%s: failed to open %s\n", progname, PROGIN);
		exit(1);
	}
	if ((judgeout = fopen(JUDGEOUT, "r")) == 0) {
		fprintf(stderr, "%s: failed to open %s\n", progname, JUDGEOUT);
		exit(1);
	}

	/* Repeatedly read data sets */
	while (fscanf(progin, "%s %s\n", initial, final) == 2) {
		linenum++;
		ReadAnswer(stdin, team, "Team");
		ReadAnswer(judgeout, judge, "Judge");

		if (strlen(team) != strlen(judge)) {
			printf(
  "Team (%d chars) differs from judge (%d chars) for prog length on line %d\n",
			       strlen(team), strlen(judge), linenum);
			error = 1;
			continue;
		}

		cp = team;
		strcpy(work_store, initial);
		len = strlen(work_store);
		while (*cp != 'E') {
			/* Run program here - error is set
			 * after loop broken out of if an error occurs
			 */
			if (strlen(cp) < 4) {
				printf(
				"Premature end of team's program in line %d\n",
				       linenum);
				break;
			}

			if (strchr("DCI", *cp) == 0) {
				printf("Illegal instruction %c on line %d\n",
				       *cp, linenum);
				break;
			}

			if (!islower(cp[1])) {
				printf(
			  "Character (%c) none-lower case letter in line %d\n",
				       cp[1], linenum);
				break;
			}

			if (!getposn(cp+2, &posn)) {
				printf(
				      "Illegal position \"%c%c\" on line %d\n",
				       cp[2], cp[3], linenum);
				break;
			}
			if (posn > (*cp == 'I' ? len + 1 : len)) {
				printf(
				"Position (%d) off end of string on line %d\n",
				       posn, linenum);
				break;
			}
			if (posn == 0) {
				printf("Position 00 invalid on line %d\n",
				       linenum);
				break;
			}

			{
				int abort = 0;
				StrType temp;

				switch(*cp) {
				      case 'C':
					work_store[posn-1] = cp[1];
					break;

				      case 'D':
					if (work_store[posn-1] != cp[1]) {
						printf(
             "Error in delete on line %d: \"%c\" in string, \"%c\" expected\n",
						       linenum,
						       work_store[posn-1],
						       cp[1]);
						abort = 1;
						break;
					}
					strcpy(temp,work_store+posn);
					strcpy(work_store+posn-1, temp);
					len--;
					break;

				      case 'I':
					if (len == WORKLEN) {
						printf(
       "Working string overflow on line %d: change WORKLEN and recompile %s\n",
						       linenum, progname);
						exit(1);
					}
					strcpy(temp, work_store+posn-1);
					strcpy(work_store+posn, temp);
					work_store[posn-1] = cp[1];
					len++;
					break;
				}
				if (abort) {
					break;
				}
			}
				
			cp += 4;
		}
		if (*cp == 'E') {
			if (strcmp(work_store, final) != 0) {
				printf(
 	 		   "Final computed (%s vs %s) incorrect for line %d\n",
				       work_store, final, linenum);
				error = 1;
			} 
		} else {
			printf("End of program not found in line %d\n",
			       linenum);
			error = 1;
		}
	}

	CheckEof(stdin, "Team");
	if (!error) {
		printf("Team's solution is correct\n");
	}
}


	void
ReadAnswer(infile, buffer, name)
        FILE *infile;
        char *buffer;
        char *name;
{
        if (fgets(buffer, sizeof(ProgType), infile) == 0) {
                printf("%s: read line failed for file %s on line %d\n",
                       progname, name, linenum);
                exit(1);
        }
	if (buffer[strlen(buffer)-1] != '\n') {
                printf("%s: line %d too long for file %s (longer than %d chars)\n",
                       progname, linenum, name, sizeof(ProgType));
                exit(1);
        }
	buffer[strlen(buffer)-1] = '\0';
}


CheckEof(infile, name)
        FILE *infile;
        char *name;
{
	if (fgetc(infile) != EOF) {
		printf("Trailing garbage after expected EOF for %s\n", name);
		error = 1;
	}
}


        int
getposn(cp, ip)
        char *cp;
        int *ip;
{
	if (!isdigit(cp[0]) || !isdigit(cp[1])) {
		return 0;
	}
	*ip = (cp[0] - '0') * 10 + cp[1] - '0';
	return 1;
}
