PROGRAM BridgeHands;

#include "str.h"

CONST probname = 'PROBLEM';
      probnumber = 'X';

TYPE  seats = (south, west, north, east);
      suits = (clubs, diamonds, spades, hearts);
      hand  = array[0..13] of integer;

VAR name : array[seats] of char;
    card : array[0..3] of char;
    debugcounter: integer;
    player : array[seats] of hand;
    dealer : seats;


FUNCTION ReadData : Boolean;   forward;
PROCEDURE Solveproblem;        forward;

PROCEDURE MainProg;
begin  {Main}

name[south] := 'S';
name[west] := 'W';
name[north] := 'N';
name[east] := 'E';
card[0] := 'C';
card[1] := 'D';
card[2] := 'S';
card[3] := 'H';

while ReadData do
  SolveProblem;

end; {of main procedure}

PROCEDURE Error(s: string); begin writeln; writeln(s); HALT end;

PROCEDURE ReadCard(VAR x : integer);
VAR ch : char;
    s : integer;

begin
read(ch);
case ch of
  'C': s :=  0;
  'D': s := 13;
  'S': s := 26;
  'H': s := 39;
  otherwise Error('Illegal suit ' + ch)
  end;  {case on ch}
read(ch);
case ch of
  '2'..'9': x := s + ord(ch) - ord('1');
  'T': x := s +  9;
  'J': x := s + 10;
  'Q': x := s + 11;
  'K': x := s + 12;
  'A': x := s + 13;
  otherwise error('Illegal value ' + ch);
  end;
end;  {Read Card}

FUNCTION Next(p : seats) : seats;
begin
if p = east
  then p := south
  else p := succ(p);
next := p;
end;

FUNCTION ReadData : Boolean;
VAR ch : char;
    got_a_deck : Boolean;
    deck : array[1..52] of integer;
    i,j : integer;
    p : seats;

begin
readln(ch); got_a_deck := true;
case ch of
  'N': dealer := north;
  'E': dealer := east;
  'S': dealer := south;
  'W': dealer := west;
  '#': got_a_deck := false;
  otherwise Error('Illegal dealer ' + ch)
  end;  {case on ch}
if got_a_deck
  then begin
    for i := 0 to 1 do begin
      for j := 1 to 26 do ReadCard(deck[i*26 + j]);
      readln end;
    p := next(dealer); j := 1;
    for i := 1 to 52 do begin
      player[p,j] := deck[i];
      if p = dealer then inc(j);
      p := next(p);
      end;
    end;

ReadData := got_a_deck;
end;  {Read Data}

PROCEDURE WriteCard(c : integer);
VAR s,v : integer;
begin
s := (c-1) div 13; v := c mod 13;
write(card[s]);
case v of
   0: write('A');
   1..8: write(v+1:1);
   9: write('T');
  10: write('J');
  11: write('Q');
  12: write('K');
  end;
write(' ');
end;  {Write Card}

PROCEDURE SolveProblem;
VAR p : seats;
    i,j, x : integer;
begin
for p := south to east do begin
  player[p, 0] := 0;
  for i := 1 to 13 do begin
    j := i-1; x := player[p,i];
    while x < player[p,j] do begin
      player[p, j+1] := player[p,j]; dec(j) end;
    player[p, j+1] := x end;
  write(name[p], ': '); for i := 1 to 13 do WriteCard(player[p,i]); writeln;
  end;

end;

begin mainprog end.
