PROGRAM Permalex;  {Serious attempt to solve the permalex problem}

#include "str.h"

CONST probname = 'PROBLEM';
      probnumber = 'F';
      maxchars = 30;

TYPE  charindex = 0..maxchars;
      longint = 0..maxint;

VAR 
    origstring, sortstring: string;
    table: array[charindex] of record ch : char; num : integer end;
    numchars, nc : integer;
    numperm : longint;

FUNCTION ReadData : Boolean;                forward;
PROCEDURE Solveproblem;                     forward;
PROCEDURE Stringsort(VAR s1, s2 : string);  forward;
FUNCTION CountLeft(l: charindex): longint;  forward;
FUNCTION CountBlock(l: charindex):longint;  forward;

PROCEDURE MainProg;
begin  {Main}

while ReadData do
  SolveProblem;
end; {of main procedure}

PROCEDURE Error(s: string);
begin writeln; writeln('Error - ', s); HALT end;

FUNCTION ReadData : Boolean;
begin

ReadData := false;
readln(origstring);
ReadData := origstring <> '#';
end;  {Read Data}

PROCEDURE SolveProblem;
VAR i : integer;

begin
numchars := length(origstring); numperm := 0;
StringSort(origstring, sortstring);

with table[1] do begin
  ch := sortstring[1]; num := 1 end;
nc := 1;
for i := 2 to numchars do begin
  if sortstring[i] <> table[nc].ch
    then begin
      inc(nc);
      with table[nc] do begin
        ch := sortstring[i]; num := 1 end;
      end
    else inc(table[nc].num);
  end;  {for i := 1 to numchars}

numperm := 1 + CountLeft(1);
writeln(numperm:10); {**readln;{**}
end;

PROCEDURE Stringsort(VAR s1, s2 : string);
VAR i,j : integer;
    ch : char;

begin
s2 := s1;
for i := 2 to numchars do begin
  ch := s1[i]; j := i - 1;
  while ch < s2[j] do begin
    s2[j+1] := s2[j]; dec(j) end;
  s2[j+1] := ch end;
end;  {StringSort}

FUNCTION CountLeft(l: charindex): longint;
VAR nb, np : longint;
    i : charindex;

begin
if l < numchars
  then begin
    i := 1; nb := 0;
    while table[i].ch < origstring[l] do begin
      if table[i].num > 0
        then begin
          dec(table[i].num); nb := nb + CountBlock(l+1); inc(table[i].num) end;
      inc(i) end;
    dec(table[i].num);
    CountLeft := nb + CountLeft(l+1) end
  else CountLeft := 0;
end;

FUNCTION CountBlock(l: charindex): longint;
VAR i,j,k, len : charindex;
    top, bot : array[charindex] of integer;
    cb : longint;
{**}rcb : real;{**}

begin
len := numchars - l + 1;
for i := 1 to len do top[i] := len-i+1;
j := 0;
for i := 1 to nc do
  for k := table[i].num downto 1 do begin
    inc(j); bot[j] := k end;
for i := 1 to j do
  for k := 1 to len do begin
    if bot[i] > 1 then
      if top[k] mod bot[i] = 0
        then begin
          top[k] := top[k] div bot[i]; bot[i] := 1 end;
    if top[k] > 1 then
      if bot[i] mod top[k] = 0
        then begin
          bot[i] := bot[i] div top[k]; top[k] := 1 end;
    end;
cb := 1; for i := 1 to len do cb := cb * top[i] div bot[i];
CountBlock := cb;
end;

begin mainprog end.