PROGRAM Trees_a_Crowd;

#include "str.h"

CONST probname = 'PROBLEM';
      probnumber = 'E';
VAR debugcounter: integer;

CONST maxtrees = 6000; {ultimately about 6,000 - enuf for now}(**)
CONST cmax = 11;
      range = 1;  {distance away of searched voxels}
      bbot = -1;  {-range}
      rtop = 15;  {voxels in range 0 .. rtop}
      btop = 16;  {15+range, need range voxels on either side}
      fac = 16; {256 div (rtop+1)}

TYPE index = 0..maxtrees;
     b_index = bbot..btop;
     c_index = 0..cmax;

VAR  tree: array[index, 1..3] of integer;
     next: array[index] of index;
     minc: array[index] of c_index;
     box: array[b_index, b_index, b_index] of index;
     N: index;
     h: array[c_index] of integer;
     cut: array[c_index] of integer;
     c: c_index;
     f: integer;

PROCEDURE Initialise;       forward;
PROCEDURE ReadTrees;        forward;
PROCEDURE FindDistances;    forward;
PROCEDURE FindHistogram;    forward;

PROCEDURE MainProg;
begin  {Main}

Initialise;
ReadTrees;
FindDistances;
FindHistogram;

for c := 0 to 9 do write(h[c]:4); writeln; ;

end; {of main procedure}

PROCEDURE Error(s: string);
begin writeln; writeln('Error - ', s); HALT end;

PROCEDURE Initialise;
VAR x, y, z: b_index;
    d: integer;

begin
for x := bbot to btop do
  for y := bbot to btop do
    for z := bbot to btop do box[x,y,z] := 0;
for c := 0 to cmax do begin
  h[c] := 0; cut[c] := c*c end;
cut[cmax] := maxint;
end;  {Initialise}

PROCEDURE ReadTrees;
VAR i,j,k: integer;
    x, y, z: b_index;

begin
N := 0;
repeat
  readln(i,j,k);
  if (i = 0) AND (j = 0) AND (k = 0)
    then EXIT;
  N := N + 1; tree[N,1] := i; tree[N,2] := j; tree[N,3] := k;
  minc[N] := cmax;
  x := i div fac; y := j div fac; z := k div fac;
  next[N] := box[x,y,z]; box[x,y,z] := N;
  until false;
end;  {Read Trees}

FUNCTION OldDist(i,j: index): integer;
VAR sum,d: integer;
    k: 1..3;
begin
sum:= 0;
for k := 1 to 3 do begin
  d := abs(tree[i,k] - tree[j,k]);
  sum := sum + d*d end;
OldDist := sum;
end;  {Distance Calculation}

function dist(i,j:integer):integer;
var d: array[1..3] of integer;
    k,sum : integer;
    toofar : Boolean;

begin
toofar := false;
for k := 1 to 3 do begin
  d[k] := abs(tree[i,k] - tree[j,k]);
  if d[k] > 10 then toofar := true end;
if not toofar
  then begin
    sum := 0;
    for k := 1 to 3 do sum := sum + d[k] * d[k];
    dist := sum end
  else dist := maxint;
end;  {distance}

PROCEDURE Bump(i:index; d : integer);
var k : c_index;

begin
k := cmax; while d < cut[k] do dec(k);
if k < minc[i] then minc[i] := k;
end;

PROCEDURE FindDistances;
VAR x, y, z: b_index;
    xs, ys, zs: b_index;
    xe, ye, ze: b_index;
    xp, yp, zp: b_index;
    i,j: index;
    d: integer;

begin
for x := 0 to rtop do
  for y := 0 to rtop do
    for z := 0 to rtop do begin
      xs := x-range; ys := y-range; zs := z-range;
      xe := x+range; ye := y+range; ze := z+range;
      i := box[x,y,z];
      while i <> 0 do begin
        for xp := xs to xe do
          for yp := ys to ye do
            for zp := zs to ze do begin
              j := box[xp,yp,zp];
              while j <> 0 do begin
                if (i <> j)
                  then begin
                    d := dist(i,j); Bump(i, d); Bump(j, d) end;
                j := next[j] end;
              end;
        i := next[i] end;
      end;
end; {find Histogram}

PROCEDURE FindHistogram;
VAR i : integer;

begin
for i := 1 to N do inc(h[minc[i]]);
end;

begin mainprog end.