PROGRAM AnagramChecker;

#include "str.h"

CONST probname = 'PROBLEM';
      probnumber = 'A';
VAR debugcounter: integer;

CONST wordmax = 2000;
      wmax = 20;

TYPE   word = string;
       alpha = 'A'..'Z';
       prof = array[alpha] of integer;
       DicRec = record
                contents : set of alpha;
                lex : word end;

VAR     lexicon : array[1..wordmax] of DicRec;
        Nwords, Nholds : integer;
        this_string : string;
        thisword : DicRec;
        thisprofile : prof;
        hold : array[1..200] of record
                 index : integer;
                 profile : prof;
                 end;
        anagram : array[1..20] of integer;
        NumAnags : integer;
        found : Boolean;

FUNCTION ReadWord: Boolean;    forward;
PROCEDURE ReadDictionary;      forward;
FUNCTION ReadData : Boolean;   forward;
PROCEDURE Solveproblem;        forward;
PROCEDURE FindAnagram(k:integer; thisprofile:prof); forward;
PROCEDURE RecordAnagram;       forward;

PROCEDURE MainProg;
begin  {Main}

ReadDictionary;
while ReadData do
  SolveProblem;

end; {of main procedure}

PROCEDURE Error(s: string);
begin writeln; writeln('Error - ', s); HALT end;

FUNCTION ReadWord: Boolean;
VAR i,c : integer;
    s : string;

begin
readln(s);
if s = '#'
  then ReadWord := false
  else with thisword do begin
    ReadWord := true;
    c := 0; for i := 1 to length(s) do c := c + ord(s[i] <> ' ');
    if c > 20 then Error('String too long: - ' + s);
    for i := 1 to length(s) do if not (s[i] in [' ', 'A'..'Z'])
      then Error('Illegal string: - ' + s);
    this_string := s;
    lex := ''; contents := [];
    for i := 1 to length(s) do
      if s[i] in ['A'..'Z']
        then begin
          contents := contents + [s[i]];
          lex := lex + s[i] end;
    end;
end;  {Read Word}

PROCEDURE ReadDictionary;
begin
Nwords := 0;
while ReadWord do begin
  inc(Nwords); if Nwords > wordmax then Error('Too many dictionary words');
  lexicon[Nwords] := thisword;
  end;
end;  {Read Dictionary}

FUNCTION ReadData : Boolean;
begin
ReadData := ReadWord;
end;  {Read Data}

PROCEDURE SolveProblem;
var i,j : integer;
    c : alpha;
begin
{Have now read the dictionary, and the word to be anagrammed}
{Now need to extract possible words depending on contents and}
{put them into hold, building up the profile. Then run thru hold}
{grabbing each in turn and then recursively seeking partners }
{beyond it}
with thisword do begin
{**write(lex, ' -> ');{**}
  Nholds := 0;
  for c := 'A' to 'Z' do thisprofile[c] := 0;
  for j := 1 to length(lex) do
    if lex[j] <> ' ' then inc(thisprofile[lex[j]]);
  for i := 1 to Nwords do begin
    if lexicon[i].contents <= contents
      then begin
        inc(Nholds);
        with hold[Nholds] do begin
          index := i;
          for c := 'A' to 'Z' do profile[c] := 0;
          for j := 1 to length(lexicon[i].lex) do
            inc(profile[lexicon[i].lex[j]]);
          end;
        end;  {if contents <= contents}
    end;  {for i := 1 to Nwords}
  NumAnags := 0;
  for i := 1 to Nholds do FindAnagram(i, thisprofile);
  end;  {with this word}
end;  {Solve Problem}

PROCEDURE FindAnagram(k:integer; thisprofile:prof);
VAR i : integer;
    c : alpha;
    good : Boolean;
    count : integer;

begin
{**writeln('FindAnagram k = ',k, ' ',lexicon[hold[k].index].lex);{**}
inc(NumAnags); anagram[NumAnags] := hold[k].index; count := 0;
for c := 'A' to 'Z' do begin
  thisprofile[c] := thisprofile[c] - hold[k].profile[c];
  count := count + ord(thisprofile[c] > 0) end;  {for c := A to Z}
{**for c := 'A' to 'Z' do write(thisprofile[c]:2); write(' => ',count);readln;{**}

if count = 0
  then RecordAnagram
  else begin
    for i := k+1 to Nholds do begin
      good := true;
      for c := 'A' to 'Z' do
        if hold[i].profile[c] > thisprofile[c] then good := false;
      if good then FindAnagram(i, thisprofile);
      end;  {for i := k+1 to Nholds}
  end; {count <> 0}
dec(NumAnags);
for c := 'A' to 'Z' do
  thisprofile[c] := thisprofile[c] + hold[k].profile[c];
end;

PROCEDURE RecordAnagram;
VAR i,p,N : integer;
    equal : boolean;
    anags, phrase_words : array[0..20] of word;
    s : string;

begin
for i := 1 to NumAnags do anags[i] := lexicon[anagram[i]].lex;
N := 0; s := this_string; p := pos(' ', s);
while p > 0 do begin
  inc(N); phrase_words[N] := Copy(s, 1, p-1); Delete(s, 1, p);
  p:= pos(' ', s) end;
inc(N); phrase_words[N] := s;

equal := true;
if N <> NumAnags
  then equal := false
  else begin
    phrase_words[0] := ' ';
    for i := 2 to N do begin
      s := phrase_words[i]; p := i-1;
      while s < phrase_words[p] do begin
        phrase_words[p+1] := phrase_words[p]; p := p - 1 end;
      phrase_words[p+1] := s end;
    for i := 1 to N do
      if Anags[i] <> phrase_words[i] then equal := false;
    end;

if not equal
  then begin
    write(this_string, ' =');
    for i := 1 to NumAnags do write(' ', lexicon[anagram[i]].lex);
    writeln end;

end;

begin mainprog end.