#include <stdio.h>

/*
 * The specification of the problem (i.e. that the number N should
 * be printed in a field of width 4) indicates that the maximum value of
 * N anticipated is 9999, which makes the brute force approach taken here
 * computationally feasible.
 */

main()
{
	int N, i, factsum;

	for(;;) {
		if (scanf("%d", &N) != 1 || N == 0) {
			break;
		}
		
		for (factsum = 1, i = 2 ; i < N ; i++) {
			if (N % i == 0) {
				factsum += i;
			}
		}
		printf("%4d%4d   %s\n", N, factsum, N == factsum ? "  perfect":
		       N > factsum ? "deficient" : " abundant");
	}
}
